// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the execution.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. You can use nextToken
	// to obtain further pages of results. The default is 100 and the maximum allowed
	// page size is 1000. A value of 0 uses the default.
	//
	// This is only an upper limit. The actual number of results returned per call
	// might be fewer than the specified maximum.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Lists events in descending order of their timeStamp.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExecutionHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetExecutionHistoryInput"}

	if s.ExecutionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionArn", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of events that occurred in the execution.
	//
	// Events is a required field
	Events []HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s GetExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetExecutionHistory = "GetExecutionHistory"

// GetExecutionHistoryRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Returns the history of the specified execution as a list of events. By default,
// the results are returned in ascending order of the timeStamp of the events.
// Use the reverseOrder parameter to get the latest events first.
//
// If nextToken is returned, there are more results available. The value of
// nextToken is a unique pagination token for each page. Make the call again
// using the returned token to retrieve the next page. Keep all other arguments
// unchanged. Each pagination token expires after 24 hours. Using an expired
// pagination token will return an HTTP 400 InvalidToken error.
//
// This API action is not supported by EXPRESS state machines.
//
//    // Example sending a request using GetExecutionHistoryRequest.
//    req := client.GetExecutionHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/GetExecutionHistory
func (c *Client) GetExecutionHistoryRequest(input *GetExecutionHistoryInput) GetExecutionHistoryRequest {
	op := &aws.Operation{
		Name:       opGetExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExecutionHistoryInput{}
	}

	req := c.newRequest(op, input, &GetExecutionHistoryOutput{})

	return GetExecutionHistoryRequest{Request: req, Input: input, Copy: c.GetExecutionHistoryRequest}
}

// GetExecutionHistoryRequest is the request type for the
// GetExecutionHistory API operation.
type GetExecutionHistoryRequest struct {
	*aws.Request
	Input *GetExecutionHistoryInput
	Copy  func(*GetExecutionHistoryInput) GetExecutionHistoryRequest
}

// Send marshals and sends the GetExecutionHistory API request.
func (r GetExecutionHistoryRequest) Send(ctx context.Context) (*GetExecutionHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetExecutionHistoryResponse{
		GetExecutionHistoryOutput: r.Request.Data.(*GetExecutionHistoryOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetExecutionHistoryRequestPaginator returns a paginator for GetExecutionHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetExecutionHistoryRequest(input)
//   p := sfn.NewGetExecutionHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetExecutionHistoryPaginator(req GetExecutionHistoryRequest) GetExecutionHistoryPaginator {
	return GetExecutionHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetExecutionHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetExecutionHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetExecutionHistoryPaginator struct {
	aws.Pager
}

func (p *GetExecutionHistoryPaginator) CurrentPage() *GetExecutionHistoryOutput {
	return p.Pager.CurrentPage().(*GetExecutionHistoryOutput)
}

// GetExecutionHistoryResponse is the response type for the
// GetExecutionHistory API operation.
type GetExecutionHistoryResponse struct {
	*GetExecutionHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetExecutionHistory request.
func (r *GetExecutionHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
