// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type LaunchAppInput struct {
	_ struct{} `type:"structure"`

	// ID of the application to launch.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s LaunchAppInput) String() string {
	return awsutil.Prettify(s)
}

type LaunchAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LaunchAppOutput) String() string {
	return awsutil.Prettify(s)
}

const opLaunchApp = "LaunchApp"

// LaunchAppRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Launches an application stack.
//
//    // Example sending a request using LaunchAppRequest.
//    req := client.LaunchAppRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/LaunchApp
func (c *Client) LaunchAppRequest(input *LaunchAppInput) LaunchAppRequest {
	op := &aws.Operation{
		Name:       opLaunchApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LaunchAppInput{}
	}

	req := c.newRequest(op, input, &LaunchAppOutput{})

	return LaunchAppRequest{Request: req, Input: input, Copy: c.LaunchAppRequest}
}

// LaunchAppRequest is the request type for the
// LaunchApp API operation.
type LaunchAppRequest struct {
	*aws.Request
	Input *LaunchAppInput
	Copy  func(*LaunchAppInput) LaunchAppRequest
}

// Send marshals and sends the LaunchApp API request.
func (r LaunchAppRequest) Send(ctx context.Context) (*LaunchAppResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &LaunchAppResponse{
		LaunchAppOutput: r.Request.Data.(*LaunchAppOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// LaunchAppResponse is the response type for the
// LaunchApp API operation.
type LaunchAppResponse struct {
	*LaunchAppOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// LaunchApp request.
func (r *LaunchAppResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
