// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sns

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type DeleteTopicInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the topic you want to delete.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTopicInput"}

	if s.TopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTopic = "DeleteTopic"

// DeleteTopicRequest returns a request value for making API operation for
// Amazon Simple Notification Service.
//
// Deletes a topic and all its subscriptions. Deleting a topic might prevent
// some messages previously sent to the topic from being delivered to subscribers.
// This action is idempotent, so deleting a topic that does not exist does not
// result in an error.
//
//    // Example sending a request using DeleteTopicRequest.
//    req := client.DeleteTopicRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic
func (c *Client) DeleteTopicRequest(input *DeleteTopicInput) DeleteTopicRequest {
	op := &aws.Operation{
		Name:       opDeleteTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTopicInput{}
	}

	req := c.newRequest(op, input, &DeleteTopicOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteTopicRequest{Request: req, Input: input, Copy: c.DeleteTopicRequest}
}

// DeleteTopicRequest is the request type for the
// DeleteTopic API operation.
type DeleteTopicRequest struct {
	*aws.Request
	Input *DeleteTopicInput
	Copy  func(*DeleteTopicInput) DeleteTopicRequest
}

// Send marshals and sends the DeleteTopic API request.
func (r DeleteTopicRequest) Send(ctx context.Context) (*DeleteTopicResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTopicResponse{
		DeleteTopicOutput: r.Request.Data.(*DeleteTopicOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTopicResponse is the response type for the
// DeleteTopic API operation.
type DeleteTopicResponse struct {
	*DeleteTopicOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTopic request.
func (r *DeleteTopicResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
