// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeMaintenanceWindowExecutionTaskInvocationsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters used to scope down the returned task invocations. The supported
	// filter key is STATUS with the corresponding values PENDING, IN_PROGRESS,
	// SUCCESS, FAILED, TIMED_OUT, CANCELLING, and CANCELLED.
	Filters []MaintenanceWindowFilter `type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `min:"10" type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// The ID of the specific task in the maintenance window task that should be
	// retrieved.
	//
	// TaskId is a required field
	TaskId *string `min:"36" type:"string" required:"true"`

	// The ID of the maintenance window execution the task is part of.
	//
	// WindowExecutionId is a required field
	WindowExecutionId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceWindowExecutionTaskInvocationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMaintenanceWindowExecutionTaskInvocationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 36))
	}

	if s.WindowExecutionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowExecutionId"))
	}
	if s.WindowExecutionId != nil && len(*s.WindowExecutionId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowExecutionId", 36))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeMaintenanceWindowExecutionTaskInvocationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// Information about the task invocation results per invocation.
	WindowExecutionTaskInvocationIdentities []MaintenanceWindowExecutionTaskInvocationIdentity `type:"list"`
}

// String returns the string representation
func (s DescribeMaintenanceWindowExecutionTaskInvocationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMaintenanceWindowExecutionTaskInvocations = "DescribeMaintenanceWindowExecutionTaskInvocations"

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Retrieves the individual task executions (one per target) for a particular
// task run as part of a maintenance window execution.
//
//    // Example sending a request using DescribeMaintenanceWindowExecutionTaskInvocationsRequest.
//    req := client.DescribeMaintenanceWindowExecutionTaskInvocationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations
func (c *Client) DescribeMaintenanceWindowExecutionTaskInvocationsRequest(input *DescribeMaintenanceWindowExecutionTaskInvocationsInput) DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
	op := &aws.Operation{
		Name:       opDescribeMaintenanceWindowExecutionTaskInvocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceWindowExecutionTaskInvocationsInput{}
	}

	req := c.newRequest(op, input, &DescribeMaintenanceWindowExecutionTaskInvocationsOutput{})

	return DescribeMaintenanceWindowExecutionTaskInvocationsRequest{Request: req, Input: input, Copy: c.DescribeMaintenanceWindowExecutionTaskInvocationsRequest}
}

// DescribeMaintenanceWindowExecutionTaskInvocationsRequest is the request type for the
// DescribeMaintenanceWindowExecutionTaskInvocations API operation.
type DescribeMaintenanceWindowExecutionTaskInvocationsRequest struct {
	*aws.Request
	Input *DescribeMaintenanceWindowExecutionTaskInvocationsInput
	Copy  func(*DescribeMaintenanceWindowExecutionTaskInvocationsInput) DescribeMaintenanceWindowExecutionTaskInvocationsRequest
}

// Send marshals and sends the DescribeMaintenanceWindowExecutionTaskInvocations API request.
func (r DescribeMaintenanceWindowExecutionTaskInvocationsRequest) Send(ctx context.Context) (*DescribeMaintenanceWindowExecutionTaskInvocationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMaintenanceWindowExecutionTaskInvocationsResponse{
		DescribeMaintenanceWindowExecutionTaskInvocationsOutput: r.Request.Data.(*DescribeMaintenanceWindowExecutionTaskInvocationsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMaintenanceWindowExecutionTaskInvocationsResponse is the response type for the
// DescribeMaintenanceWindowExecutionTaskInvocations API operation.
type DescribeMaintenanceWindowExecutionTaskInvocationsResponse struct {
	*DescribeMaintenanceWindowExecutionTaskInvocationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMaintenanceWindowExecutionTaskInvocations request.
func (r *DescribeMaintenanceWindowExecutionTaskInvocationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
