// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCalendarStateInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The specific time for which you want to get calendar state information,
	// in ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601) format. If you do not
	// add AtTime, the current time is assumed.
	AtTime *string `type:"string"`

	// The names or Amazon Resource Names (ARNs) of the Systems Manager documents
	// that represent the calendar entries for which you want to get the state.
	//
	// CalendarNames is a required field
	CalendarNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetCalendarStateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCalendarStateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCalendarStateInput"}

	if s.CalendarNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("CalendarNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCalendarStateOutput struct {
	_ struct{} `type:"structure"`

	// The time, as an ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601) string,
	// that you specified in your command. If you did not specify a time, GetCalendarState
	// uses the current time.
	AtTime *string `type:"string"`

	// The time, as an ISO 8601 (https://en.wikipedia.org/wiki/ISO_8601) string,
	// that the calendar state will change. If the current calendar state is OPEN,
	// NextTransitionTime indicates when the calendar state changes to CLOSED, and
	// vice-versa.
	NextTransitionTime *string `type:"string"`

	// The state of the calendar. An OPEN calendar indicates that actions are allowed
	// to proceed, and a CLOSED calendar indicates that actions are not allowed
	// to proceed.
	State CalendarState `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetCalendarStateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCalendarState = "GetCalendarState"

// GetCalendarStateRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Gets the state of the AWS Systems Manager Change Calendar at an optional,
// specified time. If you specify a time, GetCalendarState returns the state
// of the calendar at a specific time, and returns the next time that the Change
// Calendar state will transition. If you do not specify a time, GetCalendarState
// assumes the current time. Change Calendar entries have two possible states:
// OPEN or CLOSED. For more information about Systems Manager Change Calendar,
// see AWS Systems Manager Change Calendar (https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html)
// in the AWS Systems Manager User Guide.
//
//    // Example sending a request using GetCalendarStateRequest.
//    req := client.GetCalendarStateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState
func (c *Client) GetCalendarStateRequest(input *GetCalendarStateInput) GetCalendarStateRequest {
	op := &aws.Operation{
		Name:       opGetCalendarState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCalendarStateInput{}
	}

	req := c.newRequest(op, input, &GetCalendarStateOutput{})

	return GetCalendarStateRequest{Request: req, Input: input, Copy: c.GetCalendarStateRequest}
}

// GetCalendarStateRequest is the request type for the
// GetCalendarState API operation.
type GetCalendarStateRequest struct {
	*aws.Request
	Input *GetCalendarStateInput
	Copy  func(*GetCalendarStateInput) GetCalendarStateRequest
}

// Send marshals and sends the GetCalendarState API request.
func (r GetCalendarStateRequest) Send(ctx context.Context) (*GetCalendarStateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCalendarStateResponse{
		GetCalendarStateOutput: r.Request.Data.(*GetCalendarStateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCalendarStateResponse is the response type for the
// GetCalendarState API operation.
type GetCalendarStateResponse struct {
	*GetCalendarStateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCalendarState request.
func (r *GetCalendarStateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
