// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request body of the ResetServiceSetting API action.
type ResetServiceSettingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service setting to reset. The setting
	// ID can be /ssm/parameter-store/default-parameter-tier, /ssm/parameter-store/high-throughput-enabled,
	// or /ssm/managed-instance/activation-tier. For example, arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled.
	//
	// SettingId is a required field
	SettingId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetServiceSettingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetServiceSettingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetServiceSettingInput"}

	if s.SettingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SettingId"))
	}
	if s.SettingId != nil && len(*s.SettingId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SettingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result body of the ResetServiceSetting API action.
type ResetServiceSettingOutput struct {
	_ struct{} `type:"structure"`

	// The current, effective service setting after calling the ResetServiceSetting
	// API action.
	ServiceSetting *ServiceSetting `type:"structure"`
}

// String returns the string representation
func (s ResetServiceSettingOutput) String() string {
	return awsutil.Prettify(s)
}

const opResetServiceSetting = "ResetServiceSetting"

// ResetServiceSettingRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// ServiceSetting is an account-level setting for an AWS service. This setting
// defines how a user interacts with or uses a service or a feature of a service.
// For example, if an AWS service charges money to the account based on feature
// or service usage, then the AWS service team might create a default setting
// of "false". This means the user can't use this feature unless they change
// the setting to "true" and intentionally opt in for a paid feature.
//
// Services map a SettingId object to a setting value. AWS services teams define
// the default value for a SettingId. You can't create a new SettingId, but
// you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the GetServiceSetting API action to view
// the current value. Use the UpdateServiceSetting API action to change the
// default setting.
//
// Reset the service setting for the account to the default value as provisioned
// by the AWS service team.
//
//    // Example sending a request using ResetServiceSettingRequest.
//    req := client.ResetServiceSettingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResetServiceSetting
func (c *Client) ResetServiceSettingRequest(input *ResetServiceSettingInput) ResetServiceSettingRequest {
	op := &aws.Operation{
		Name:       opResetServiceSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetServiceSettingInput{}
	}

	req := c.newRequest(op, input, &ResetServiceSettingOutput{})

	return ResetServiceSettingRequest{Request: req, Input: input, Copy: c.ResetServiceSettingRequest}
}

// ResetServiceSettingRequest is the request type for the
// ResetServiceSetting API operation.
type ResetServiceSettingRequest struct {
	*aws.Request
	Input *ResetServiceSettingInput
	Copy  func(*ResetServiceSettingInput) ResetServiceSettingRequest
}

// Send marshals and sends the ResetServiceSetting API request.
func (r ResetServiceSettingRequest) Send(ctx context.Context) (*ResetServiceSettingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetServiceSettingResponse{
		ResetServiceSettingOutput: r.Request.Data.(*ResetServiceSettingOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetServiceSettingResponse is the response type for the
// ResetServiceSetting API operation.
type ResetServiceSettingResponse struct {
	*ResetServiceSettingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetServiceSetting request.
func (r *ResetServiceSettingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
