// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SendAutomationSignalInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an existing Automation execution that you want
	// to send the signal to.
	//
	// AutomationExecutionId is a required field
	AutomationExecutionId *string `min:"36" type:"string" required:"true"`

	// The data sent with the signal. The data schema depends on the type of signal
	// used in the request.
	//
	// For Approve and Reject signal types, the payload is an optional comment that
	// you can send with the signal type. For example:
	//
	// Comment="Looks good"
	//
	// For StartStep and Resume signal types, you must send the name of the Automation
	// step to start or resume as the payload. For example:
	//
	// StepName="step1"
	//
	// For the StopStep signal type, you must send the step execution ID as the
	// payload. For example:
	//
	// StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"
	Payload map[string][]string `min:"1" type:"map"`

	// The type of signal to send to an Automation execution.
	//
	// SignalType is a required field
	SignalType SignalType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SendAutomationSignalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendAutomationSignalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendAutomationSignalInput"}

	if s.AutomationExecutionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutomationExecutionId"))
	}
	if s.AutomationExecutionId != nil && len(*s.AutomationExecutionId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("AutomationExecutionId", 36))
	}
	if s.Payload != nil && len(s.Payload) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Payload", 1))
	}
	if len(s.SignalType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SignalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SendAutomationSignalOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendAutomationSignalOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendAutomationSignal = "SendAutomationSignal"

// SendAutomationSignalRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Sends a signal to an Automation execution to change the current behavior
// or status of the execution.
//
//    // Example sending a request using SendAutomationSignalRequest.
//    req := client.SendAutomationSignalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal
func (c *Client) SendAutomationSignalRequest(input *SendAutomationSignalInput) SendAutomationSignalRequest {
	op := &aws.Operation{
		Name:       opSendAutomationSignal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendAutomationSignalInput{}
	}

	req := c.newRequest(op, input, &SendAutomationSignalOutput{})

	return SendAutomationSignalRequest{Request: req, Input: input, Copy: c.SendAutomationSignalRequest}
}

// SendAutomationSignalRequest is the request type for the
// SendAutomationSignal API operation.
type SendAutomationSignalRequest struct {
	*aws.Request
	Input *SendAutomationSignalInput
	Copy  func(*SendAutomationSignalInput) SendAutomationSignalRequest
}

// Send marshals and sends the SendAutomationSignal API request.
func (r SendAutomationSignalRequest) Send(ctx context.Context) (*SendAutomationSignalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendAutomationSignalResponse{
		SendAutomationSignalOutput: r.Request.Data.(*SendAutomationSignalOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendAutomationSignalResponse is the response type for the
// SendAutomationSignal API operation.
type SendAutomationSignalResponse struct {
	*SendAutomationSignalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendAutomationSignal request.
func (r *SendAutomationSignalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
