// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type TerminateSessionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the session to terminate.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TerminateSessionInput"}

	if s.SessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type TerminateSessionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the session that has been terminated.
	SessionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TerminateSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opTerminateSession = "TerminateSession"

// TerminateSessionRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Permanently ends a session and closes the data connection between the Session
// Manager client and SSM Agent on the instance. A terminated session cannot
// be resumed.
//
//    // Example sending a request using TerminateSessionRequest.
//    req := client.TerminateSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession
func (c *Client) TerminateSessionRequest(input *TerminateSessionInput) TerminateSessionRequest {
	op := &aws.Operation{
		Name:       opTerminateSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateSessionInput{}
	}

	req := c.newRequest(op, input, &TerminateSessionOutput{})

	return TerminateSessionRequest{Request: req, Input: input, Copy: c.TerminateSessionRequest}
}

// TerminateSessionRequest is the request type for the
// TerminateSession API operation.
type TerminateSessionRequest struct {
	*aws.Request
	Input *TerminateSessionInput
	Copy  func(*TerminateSessionInput) TerminateSessionRequest
}

// Send marshals and sends the TerminateSession API request.
func (r TerminateSessionRequest) Send(ctx context.Context) (*TerminateSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TerminateSessionResponse{
		TerminateSessionOutput: r.Request.Data.(*TerminateSessionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TerminateSessionResponse is the response type for the
// TerminateSession API operation.
type TerminateSessionResponse struct {
	*TerminateSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TerminateSession request.
func (r *TerminateSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
