// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateCanaryInput struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where Synthetics stores artifacts from the test
	// runs of this canary. Artifacts include the log file, screenshots, and HAR
	// files.
	//
	// ArtifactS3Location is a required field
	ArtifactS3Location *string `min:"1" type:"string" required:"true"`

	// A structure that includes the entry point from which the canary should start
	// running your script. If the script is stored in an S3 bucket, the bucket
	// name, key, and version are also included.
	//
	// Code is a required field
	Code *CanaryCodeInput `type:"structure" required:"true"`

	// The ARN of the IAM role to be used to run the canary. This role must already
	// exist, and must include lambda.amazonaws.com as a principal in the trust
	// policy. The role must also have the following permissions:
	//
	//    * s3:PutObject
	//
	//    * s3:GetBucketLocation
	//
	//    * s3:ListAllMyBuckets
	//
	//    * cloudwatch:PutMetricData
	//
	//    * logs:CreateLogGroup
	//
	//    * logs:CreateLogStream
	//
	//    * logs:CreateLogStream
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `type:"string" required:"true"`

	// The number of days to retain data about failed runs of this canary. If you
	// omit this field, the default of 31 days is used. The valid range is 1 to
	// 455 days.
	FailureRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The name for this canary. Be sure to give it a descriptive name that distinguishes
	// it from other canaries in your account.
	//
	// Do not include secrets or proprietary information in your canary names. The
	// canary name makes up part of the canary ARN, and the ARN is included in outbound
	// calls over the internet. For more information, see Security Considerations
	// for Synthetics Canaries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the configuration for individual canary runs, such
	// as timeout value.
	RunConfig *CanaryRunConfigInput `type:"structure"`

	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0. For more information about runtime versions, see
	// Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	//
	// RuntimeVersion is a required field
	RuntimeVersion *string `min:"1" type:"string" required:"true"`

	// A structure that contains information about how often the canary is to run
	// and when these test runs are to stop.
	//
	// Schedule is a required field
	Schedule *CanaryScheduleInput `type:"structure" required:"true"`

	// The number of days to retain data about successful runs of this canary. If
	// you omit this field, the default of 31 days is used. The valid range is 1
	// to 455 days.
	SuccessRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// A list of key-value pairs to associate with the canary. You can associate
	// as many as 50 tags with a canary.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions, by granting a user permission to access or
	// change only the resources that have certain tag values.
	Tags map[string]string `min:"1" type:"map"`

	// If this canary is to test an endpoint in a VPC, this structure contains information
	// about the subnet and security groups of the VPC endpoint. For more information,
	// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigInput `type:"structure"`
}

// String returns the string representation
func (s CreateCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCanaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCanaryInput"}

	if s.ArtifactS3Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("ArtifactS3Location"))
	}
	if s.ArtifactS3Location != nil && len(*s.ArtifactS3Location) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ArtifactS3Location", 1))
	}

	if s.Code == nil {
		invalidParams.Add(aws.NewErrParamRequired("Code"))
	}

	if s.ExecutionRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.FailureRetentionPeriodInDays != nil && *s.FailureRetentionPeriodInDays < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureRetentionPeriodInDays", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.RuntimeVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuntimeVersion"))
	}
	if s.RuntimeVersion != nil && len(*s.RuntimeVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuntimeVersion", 1))
	}

	if s.Schedule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Schedule"))
	}
	if s.SuccessRetentionPeriodInDays != nil && *s.SuccessRetentionPeriodInDays < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("SuccessRetentionPeriodInDays", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(aws.ErrInvalidParams))
		}
	}
	if s.RunConfig != nil {
		if err := s.RunConfig.Validate(); err != nil {
			invalidParams.AddNested("RunConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCanaryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ArtifactS3Location != nil {
		v := *s.ArtifactS3Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ArtifactS3Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Code != nil {
		v := s.Code

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Code", v, metadata)
	}
	if s.ExecutionRoleArn != nil {
		v := *s.ExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExecutionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FailureRetentionPeriodInDays != nil {
		v := *s.FailureRetentionPeriodInDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureRetentionPeriodInDays", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RunConfig != nil {
		v := s.RunConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RunConfig", v, metadata)
	}
	if s.RuntimeVersion != nil {
		v := *s.RuntimeVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RuntimeVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Schedule", v, metadata)
	}
	if s.SuccessRetentionPeriodInDays != nil {
		v := *s.SuccessRetentionPeriodInDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SuccessRetentionPeriodInDays", protocol.Int64Value(v), metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.VpcConfig != nil {
		v := s.VpcConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "VpcConfig", v, metadata)
	}
	return nil
}

type CreateCanaryOutput struct {
	_ struct{} `type:"structure"`

	// The full details about the canary you have created.
	Canary *Canary `type:"structure"`
}

// String returns the string representation
func (s CreateCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCanaryOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Canary != nil {
		v := s.Canary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Canary", v, metadata)
	}
	return nil
}

const opCreateCanary = "CreateCanary"

// CreateCanaryRequest returns a request value for making API operation for
// Synthetics.
//
// Creates a canary. Canaries are scripts that monitor your endpoints and APIs
// from the outside-in. Canaries help you check the availability and latency
// of your web services and troubleshoot anomalies by investigating load time
// data, screenshots of the UI, logs, and metrics. You can set up a canary to
// run continuously or just once.
//
// Do not use CreateCanary to modify an existing canary. Use UpdateCanary (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_UpdateCanary.html)
// instead.
//
// To create canaries, you must have the CloudWatchSyntheticsFullAccess policy.
// If you are creating a new IAM role for the canary, you also need the the
// iam:CreateRole, iam:CreatePolicy and iam:AttachRolePolicy permissions. For
// more information, see Necessary Roles and Permissions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles).
//
// Do not include secrets or proprietary information in your canary names. The
// canary name makes up part of the Amazon Resource Name (ARN) for the canary,
// and the ARN is included in outbound calls over the internet. For more information,
// see Security Considerations for Synthetics Canaries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
//
//    // Example sending a request using CreateCanaryRequest.
//    req := client.CreateCanaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/CreateCanary
func (c *Client) CreateCanaryRequest(input *CreateCanaryInput) CreateCanaryRequest {
	op := &aws.Operation{
		Name:       opCreateCanary,
		HTTPMethod: "POST",
		HTTPPath:   "/canary",
	}

	if input == nil {
		input = &CreateCanaryInput{}
	}

	req := c.newRequest(op, input, &CreateCanaryOutput{})

	return CreateCanaryRequest{Request: req, Input: input, Copy: c.CreateCanaryRequest}
}

// CreateCanaryRequest is the request type for the
// CreateCanary API operation.
type CreateCanaryRequest struct {
	*aws.Request
	Input *CreateCanaryInput
	Copy  func(*CreateCanaryInput) CreateCanaryRequest
}

// Send marshals and sends the CreateCanary API request.
func (r CreateCanaryRequest) Send(ctx context.Context) (*CreateCanaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCanaryResponse{
		CreateCanaryOutput: r.Request.Data.(*CreateCanaryOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCanaryResponse is the response type for the
// CreateCanary API operation.
type CreateCanaryResponse struct {
	*CreateCanaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCanary request.
func (r *CreateCanaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
