// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeCanariesInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many canaries are returned each time
	// you use the DescribeCanaries operation. If you omit this parameter, the default
	// of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent operation to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCanariesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeCanariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCanariesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeCanariesOutput struct {
	_ struct{} `type:"structure"`

	// Returns an array. Each item in the array contains the full information about
	// one canary.
	Canaries []Canary `type:"list"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanaries operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeCanariesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Canaries != nil {
		v := s.Canaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Canaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeCanaries = "DescribeCanaries"

// DescribeCanariesRequest returns a request value for making API operation for
// Synthetics.
//
// This operation returns a list of the canaries in your account, along with
// full details about each canary.
//
// This operation does not have resource-level authorization, so if a user is
// able to use DescribeCanaries, the user can see all of the canaries in the
// account. A deny policy can only be used to restrict access to all canaries.
// It cannot be used on specific resources.
//
//    // Example sending a request using DescribeCanariesRequest.
//    req := client.DescribeCanariesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanaries
func (c *Client) DescribeCanariesRequest(input *DescribeCanariesInput) DescribeCanariesRequest {
	op := &aws.Operation{
		Name:       opDescribeCanaries,
		HTTPMethod: "POST",
		HTTPPath:   "/canaries",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCanariesInput{}
	}

	req := c.newRequest(op, input, &DescribeCanariesOutput{})

	return DescribeCanariesRequest{Request: req, Input: input, Copy: c.DescribeCanariesRequest}
}

// DescribeCanariesRequest is the request type for the
// DescribeCanaries API operation.
type DescribeCanariesRequest struct {
	*aws.Request
	Input *DescribeCanariesInput
	Copy  func(*DescribeCanariesInput) DescribeCanariesRequest
}

// Send marshals and sends the DescribeCanaries API request.
func (r DescribeCanariesRequest) Send(ctx context.Context) (*DescribeCanariesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeCanariesResponse{
		DescribeCanariesOutput: r.Request.Data.(*DescribeCanariesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeCanariesRequestPaginator returns a paginator for DescribeCanaries.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeCanariesRequest(input)
//   p := synthetics.NewDescribeCanariesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeCanariesPaginator(req DescribeCanariesRequest) DescribeCanariesPaginator {
	return DescribeCanariesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeCanariesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeCanariesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeCanariesPaginator struct {
	aws.Pager
}

func (p *DescribeCanariesPaginator) CurrentPage() *DescribeCanariesOutput {
	return p.Pager.CurrentPage().(*DescribeCanariesOutput)
}

// DescribeCanariesResponse is the response type for the
// DescribeCanaries API operation.
type DescribeCanariesResponse struct {
	*DescribeCanariesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeCanaries request.
func (r *DescribeCanariesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
