// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package syntheticsiface provides an interface to enable mocking the Synthetics service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package syntheticsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/synthetics"
)

// ClientAPI provides an interface to enable mocking the
// synthetics.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Synthetics.
//    func myFunc(svc syntheticsiface.ClientAPI) bool {
//        // Make svc.CreateCanary request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := synthetics.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        syntheticsiface.ClientPI
//    }
//    func (m *mockClientClient) CreateCanary(input *synthetics.CreateCanaryInput) (*synthetics.CreateCanaryOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateCanaryRequest(*synthetics.CreateCanaryInput) synthetics.CreateCanaryRequest

	DeleteCanaryRequest(*synthetics.DeleteCanaryInput) synthetics.DeleteCanaryRequest

	DescribeCanariesRequest(*synthetics.DescribeCanariesInput) synthetics.DescribeCanariesRequest

	DescribeCanariesLastRunRequest(*synthetics.DescribeCanariesLastRunInput) synthetics.DescribeCanariesLastRunRequest

	DescribeRuntimeVersionsRequest(*synthetics.DescribeRuntimeVersionsInput) synthetics.DescribeRuntimeVersionsRequest

	GetCanaryRequest(*synthetics.GetCanaryInput) synthetics.GetCanaryRequest

	GetCanaryRunsRequest(*synthetics.GetCanaryRunsInput) synthetics.GetCanaryRunsRequest

	ListTagsForResourceRequest(*synthetics.ListTagsForResourceInput) synthetics.ListTagsForResourceRequest

	StartCanaryRequest(*synthetics.StartCanaryInput) synthetics.StartCanaryRequest

	StopCanaryRequest(*synthetics.StopCanaryInput) synthetics.StopCanaryRequest

	TagResourceRequest(*synthetics.TagResourceInput) synthetics.TagResourceRequest

	UntagResourceRequest(*synthetics.UntagResourceInput) synthetics.UntagResourceRequest

	UpdateCanaryRequest(*synthetics.UpdateCanaryInput) synthetics.UpdateCanaryRequest
}

var _ ClientAPI = (*synthetics.Client)(nil)
