// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package translate

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopTextTranslationJobInput struct {
	_ struct{} `type:"structure"`

	// The job ID of the job to be stopped.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTextTranslationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTextTranslationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopTextTranslationJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopTextTranslationJobOutput struct {
	_ struct{} `type:"structure"`

	// The job ID of the stopped batch translation job.
	JobId *string `min:"1" type:"string"`

	// The status of the designated job. Upon successful completion, the job's status
	// will be STOPPED.
	JobStatus JobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s StopTextTranslationJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopTextTranslationJob = "StopTextTranslationJob"

// StopTextTranslationJobRequest returns a request value for making API operation for
// Amazon Translate.
//
// Stops an asynchronous batch translation job that is in progress.
//
// If the job's state is IN_PROGRESS, the job will be marked for termination
// and put into the STOP_REQUESTED state. If the job completes before it can
// be stopped, it is put into the COMPLETED state. Otherwise, the job is put
// into the STOPPED state.
//
// Asynchronous batch translation jobs are started with the StartTextTranslationJob
// operation. You can use the DescribeTextTranslationJob or ListTextTranslationJobs
// operations to get a batch translation job's JobId.
//
//    // Example sending a request using StopTextTranslationJobRequest.
//    req := client.StopTextTranslationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob
func (c *Client) StopTextTranslationJobRequest(input *StopTextTranslationJobInput) StopTextTranslationJobRequest {
	op := &aws.Operation{
		Name:       opStopTextTranslationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTextTranslationJobInput{}
	}

	req := c.newRequest(op, input, &StopTextTranslationJobOutput{})

	return StopTextTranslationJobRequest{Request: req, Input: input, Copy: c.StopTextTranslationJobRequest}
}

// StopTextTranslationJobRequest is the request type for the
// StopTextTranslationJob API operation.
type StopTextTranslationJobRequest struct {
	*aws.Request
	Input *StopTextTranslationJobInput
	Copy  func(*StopTextTranslationJobInput) StopTextTranslationJobRequest
}

// Send marshals and sends the StopTextTranslationJob API request.
func (r StopTextTranslationJobRequest) Send(ctx context.Context) (*StopTextTranslationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopTextTranslationJobResponse{
		StopTextTranslationJobOutput: r.Request.Data.(*StopTextTranslationJobOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopTextTranslationJobResponse is the response type for the
// StopTextTranslationJob API operation.
type StopTextTranslationJobResponse struct {
	*StopTextTranslationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopTextTranslationJob request.
func (r *StopTextTranslationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
