// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// All query arguments of a web request.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type AllQueryArguments struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AllQueryArguments) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Specifies that AWS WAF should allow requests.
//
// This is used only in the context of other settings, for example to specify
// values for RuleAction and web ACL DefaultAction.
type AllowAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AllowAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A logical rule statement used to combine other rule statements with AND logic.
// You provide more than one Statement within the AndStatement.
type AndStatement struct {
	_ struct{} `type:"structure"`

	// The statements to combine with AND logic. You can use any statements that
	// can be nested.
	//
	// Statements is a required field
	Statements []Statement `type:"list" required:"true"`
}

// String returns the string representation
func (s AndStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AndStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AndStatement"}

	if s.Statements == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statements"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Specifies that AWS WAF should block requests.
//
// This is used only in the context of other settings, for example to specify
// values for RuleAction and web ACL DefaultAction.
type BlockAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BlockAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The body of a web request. This immediately follows the request headers.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type Body struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement that defines a string match search for AWS WAF to apply
// to web requests. The byte match statement provides the bytes to search for,
// the location in requests that you want AWS WAF to search, and other settings.
// The bytes to search for are typically a string that corresponds with ASCII
// characters. In the AWS WAF console and the developer guide, this is refered
// to as a string match statement.
type ByteMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want AWS WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The area within the portion of a web request that you want AWS WAF to search
	// for SearchString. Valid values include the following:
	//
	// CONTAINS
	//
	// The specified part of the web request must include the value of SearchString,
	// but the location doesn't matter.
	//
	// CONTAINS_WORD
	//
	// The specified part of the web request must include the value of SearchString,
	// and SearchString must contain only alphanumeric characters or underscore
	// (A-Z, a-z, 0-9, or _). In addition, SearchString must be a word, which means
	// that both of the following are true:
	//
	//    * SearchString is at the beginning of the specified part of the web request
	//    or is preceded by a character other than an alphanumeric character or
	//    underscore (_). Examples include the value of a header and ;BadBot.
	//
	//    * SearchString is at the end of the specified part of the web request
	//    or is followed by a character other than an alphanumeric character or
	//    underscore (_), for example, BadBot; and -BadBot;.
	//
	// EXACTLY
	//
	// The value of the specified part of the web request must exactly match the
	// value of SearchString.
	//
	// STARTS_WITH
	//
	// The value of SearchString must appear at the beginning of the specified part
	// of the web request.
	//
	// ENDS_WITH
	//
	// The value of SearchString must appear at the end of the specified part of
	// the web request.
	//
	// PositionalConstraint is a required field
	PositionalConstraint PositionalConstraint `type:"string" required:"true" enum:"true"`

	// A string value that you want AWS WAF to search for. AWS WAF searches only
	// in the part of web requests that you designate for inspection in FieldToMatch.
	// The maximum length of the value is 50 bytes.
	//
	// Valid values depend on the component that you specify for inspection in FieldToMatch:
	//
	//    * Method: The HTTP method that you want AWS WAF to search for. This indicates
	//    the type of operation specified in the request.
	//
	//    * UriPath: The value that you want AWS WAF to search for in the URI path,
	//    for example, /images/daily-ad.jpg.
	//
	// If SearchString includes alphabetic characters A-Z and a-z, note that the
	// value is case sensitive.
	//
	// If you're using the AWS WAF API
	//
	// Specify a base64-encoded version of the value. The maximum length of the
	// value before you base64-encode it is 50 bytes.
	//
	// For example, suppose the value of Type is HEADER and the value of Data is
	// User-Agent. If you want to search the User-Agent header for the value BadBot,
	// you base64-encode BadBot using MIME base64-encoding and include the resulting
	// value, QmFkQm90, in the value of SearchString.
	//
	// If you're using the AWS CLI or one of the AWS SDKs
	//
	// The value that you want AWS WAF to search for. The SDK automatically base64
	// encodes the value.
	//
	// SearchString is automatically base64 encoded/decoded by the SDK.
	//
	// SearchString is a required field
	SearchString []byte `type:"blob" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, AWS WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ByteMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ByteMatchStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ByteMatchStatement"}

	if s.FieldToMatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldToMatch"))
	}
	if len(s.PositionalConstraint) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PositionalConstraint"))
	}

	if s.SearchString == nil {
		invalidParams.Add(aws.NewErrParamRequired("SearchString"))
	}

	if s.TextTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Specifies that AWS WAF should count requests.
//
// This is used only in the context of other settings, for example to specify
// values for RuleAction and web ACL DefaultAction.
type CountAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CountAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// In a WebACL, this is the action that you want AWS WAF to perform when a web
// request doesn't match any of the rules in the WebACL. The default action
// must be a terminating action, so count is not allowed.
type DefaultAction struct {
	_ struct{} `type:"structure"`

	// Specifies that AWS WAF should allow requests by default.
	Allow *AllowAction `type:"structure"`

	// Specifies that AWS WAF should block requests by default.
	Block *BlockAction `type:"structure"`
}

// String returns the string representation
func (s DefaultAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Specifies a single rule to exclude from the rule group. Excluding a rule
// overrides its action setting for the rule group in the web ACL, setting it
// to COUNT. This effectively excludes the rule from acting on web requests.
type ExcludedRule struct {
	_ struct{} `type:"structure"`

	// The name of the rule to exclude.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExcludedRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExcludedRule"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The part of a web request that you want AWS WAF to inspect. Include the single
// FieldToMatch type that you want to inspect, with additional specifications
// as needed, according to the type. You specify a single request component
// in FieldToMatch for each rule statement that requires it. To inspect more
// than one component of a web request, create a separate rule statement for
// each component.
type FieldToMatch struct {
	_ struct{} `type:"structure"`

	// Inspect all query arguments.
	AllQueryArguments *AllQueryArguments `type:"structure"`

	// Inspect the request body, which immediately follows the request headers.
	// This is the part of a request that contains any additional data that you
	// want to send to your web server as the HTTP request body, such as data from
	// a form.
	//
	// Note that only the first 8 KB (8192 bytes) of the request body are forwarded
	// to AWS WAF for inspection by the underlying host service. If you don't need
	// to inspect more than 8 KB, you can guarantee that you don't allow additional
	// bytes in by combining a statement that inspects the body of the web request,
	// such as ByteMatchStatement or RegexPatternSetReferenceStatement, with a SizeConstraintStatement
	// that enforces an 8 KB size limit on the body of the request. AWS WAF doesn't
	// support inspecting the entire contents of web requests whose bodies exceed
	// the 8 KB limit.
	Body *Body `type:"structure"`

	// Inspect the HTTP method. The method indicates the type of operation that
	// the request is asking the origin to perform.
	Method *Method `type:"structure"`

	// Inspect the query string. This is the part of a URL that appears after a
	// ? character, if any.
	QueryString *QueryString `type:"structure"`

	// Inspect a single header. Provide the name of the header to inspect, for example,
	// User-Agent or Referer. This setting isn't case sensitive.
	SingleHeader *SingleHeader `type:"structure"`

	// Inspect a single query argument. Provide the name of the query argument to
	// inspect, such as UserName or SalesRegion. The name can be up to 30 characters
	// long and isn't case sensitive.
	//
	// This is used only to indicate the web request component for AWS WAF to inspect,
	// in the FieldToMatch specification.
	SingleQueryArgument *SingleQueryArgument `type:"structure"`

	// Inspect the request URI path. This is the part of a web request that identifies
	// a resource, for example, /images/daily-ad.jpg.
	UriPath *UriPath `type:"structure"`
}

// String returns the string representation
func (s FieldToMatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldToMatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FieldToMatch"}
	if s.SingleHeader != nil {
		if err := s.SingleHeader.Validate(); err != nil {
			invalidParams.AddNested("SingleHeader", err.(aws.ErrInvalidParams))
		}
	}
	if s.SingleQueryArgument != nil {
		if err := s.SingleQueryArgument.Validate(); err != nil {
			invalidParams.AddNested("SingleQueryArgument", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A rule group that's defined for an AWS Firewall Manager WAF policy.
type FirewallManagerRuleGroup struct {
	_ struct{} `type:"structure"`

	// The processing guidance for an AWS Firewall Manager rule. This is like a
	// regular rule Statement, but it can only contain a rule group reference.
	//
	// FirewallManagerStatement is a required field
	FirewallManagerStatement *FirewallManagerStatement `type:"structure" required:"true"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The override action to apply to the rules in a rule group. Used only for
	// rule statements that reference a rule group, like RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// Set the override action to none to leave the rule actions in effect. Set
	// it to count to only count matches, regardless of the rule action settings.
	//
	// In a Rule, you must specify either this OverrideAction setting or the rule
	// Action setting, but not both:
	//
	//    * If the rule statement references a rule group, use this override action
	//    setting and not the action setting.
	//
	//    * If the rule statement does not reference a rule group, use the rule
	//    action setting and not this rule override action setting.
	//
	// OverrideAction is a required field
	OverrideAction *OverrideAction `type:"structure" required:"true"`

	// If you define more than one rule group in the first or last Firewall Manager
	// rule groups, AWS WAF evaluates each request against the rule groups in order,
	// starting from the lowest priority setting. The priorities don't need to be
	// consecutive, but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	//
	// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
	// 2019. For information, including how to migrate your AWS WAF resources from
	// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s FirewallManagerRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// The processing guidance for an AWS Firewall Manager rule. This is like a
// regular rule Statement, but it can only contain a rule group reference.
type FirewallManagerStatement struct {
	_ struct{} `type:"structure"`

	//
	// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
	// 2019. For information, including how to migrate your AWS WAF resources from
	// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// A rule statement used to run the rules that are defined in a managed rule
	// group. To use this, provide the vendor name and the name of the rule group
	// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
	//
	// You can't nest a ManagedRuleGroupStatement, for example for use inside a
	// NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement `type:"structure"`

	//
	// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
	// 2019. For information, including how to migrate your AWS WAF resources from
	// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// A rule statement used to run the rules that are defined in a RuleGroup. To
	// use this, create a rule group with your rules, then provide the ARN of the
	// rule group in this statement.
	//
	// You cannot nest a RuleGroupReferenceStatement, for example for use inside
	// a NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement `type:"structure"`
}

// String returns the string representation
func (s FirewallManagerStatement) String() string {
	return awsutil.Prettify(s)
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name.
//
// If the specified header isn't present in the request, AWS WAF doesn't apply
// the rule to the web request at all.
//
// This configuration is used for GeoMatchStatement and RateBasedStatement.
// For IPSetReferenceStatement, use IPSetForwardedIPConfig instead.
//
// AWS WAF only evaluates the first IP address found in the specified HTTP header.
type ForwardedIPConfig struct {
	_ struct{} `type:"structure"`

	// The match status to assign to the web request if the request doesn't have
	// a valid IP address in the specified position.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	//
	// You can specify the following fallback behaviors:
	//
	//    * MATCH - Treat the web request as matching the rule statement. AWS WAF
	//    applies the rule action to the request.
	//
	//    * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// FallbackBehavior is a required field
	FallbackBehavior FallbackBehavior `type:"string" required:"true" enum:"true"`

	// The name of the HTTP header to use for the IP address. For example, to use
	// the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	//
	// HeaderName is a required field
	HeaderName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForwardedIPConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForwardedIPConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ForwardedIPConfig"}
	if len(s.FallbackBehavior) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FallbackBehavior"))
	}

	if s.HeaderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderName != nil && len(*s.HeaderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HeaderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement used to identify web requests based on country of origin.
type GeoMatchStatement struct {
	_ struct{} `type:"structure"`

	// An array of two-character country codes, for example, [ "US", "CN" ], from
	// the alpha-2 country ISO codes of the ISO 3166 international standard.
	CountryCodes []CountryCode `min:"1" type:"list"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	ForwardedIPConfig *ForwardedIPConfig `type:"structure"`
}

// String returns the string representation
func (s GeoMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMatchStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GeoMatchStatement"}
	if s.CountryCodes != nil && len(s.CountryCodes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CountryCodes", 1))
	}
	if s.ForwardedIPConfig != nil {
		if err := s.ForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardedIPConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Part of the response from GetSampledRequests. This is a complex type that
// appears as Headers in the response syntax. HTTPHeader contains the names
// and values of all of the headers that appear in one of the web requests.
type HTTPHeader struct {
	_ struct{} `type:"structure"`

	// The name of the HTTP header.
	Name *string `type:"string"`

	// The value of the HTTP header.
	Value *string `type:"string"`
}

// String returns the string representation
func (s HTTPHeader) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Part of the response from GetSampledRequests. This is a complex type that
// appears as Request in the response syntax. HTTPRequest contains information
// about one of the web requests.
type HTTPRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that the request originated from. If the web ACL is associated
	// with a CloudFront distribution, this is the value of one of the following
	// fields in CloudFront access logs:
	//
	//    * c-ip, if the viewer did not use an HTTP proxy or a load balancer to
	//    send the request
	//
	//    * x-forwarded-for, if the viewer did use an HTTP proxy or a load balancer
	//    to send the request
	ClientIP *string `type:"string"`

	// The two-letter country code for the country that the request originated from.
	// For a current list of country codes, see the Wikipedia entry ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	Country *string `type:"string"`

	// The HTTP version specified in the sampled web request, for example, HTTP/1.1.
	HTTPVersion *string `type:"string"`

	// A complex type that contains the name and value for each header in the sampled
	// web request.
	Headers []HTTPHeader `type:"list"`

	// The HTTP method specified in the sampled web request.
	Method *string `type:"string"`

	// The URI path of the request, which identifies the resource, for example,
	// /images/daily-ad.jpg.
	URI *string `type:"string"`
}

// String returns the string representation
func (s HTTPRequest) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Contains one or more IP addresses or blocks of IP addresses specified in
// Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports any CIDR
// range. For information about CIDR notation, see the Wikipedia entry Classless
// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// AWS WAF assigns an ARN to each IPSet that you create. To use an IP set in
// a rule, you provide the ARN to the Rule statement IPSetReferenceStatement.
type IPSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// Contains an array of strings that specify one or more IP addresses or blocks
	// of IP addresses in Classless Inter-Domain Routing (CIDR) notation. AWS WAF
	// supports all address ranges for IP versions IPv4 and IPv6.
	//
	// Examples:
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff,
	//    specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Addresses is a required field
	Addresses []string `type:"list" required:"true"`

	// A description of the IP set that helps with identification. You cannot change
	// the description of an IP set after you create it.
	Description *string `min:"1" type:"string"`

	// Specify IPV4 or IPV6.
	//
	// IPAddressVersion is a required field
	IPAddressVersion IPAddressVersion `type:"string" required:"true" enum:"true"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IPSet) String() string {
	return awsutil.Prettify(s)
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name.
//
// If the specified header isn't present in the request, AWS WAF doesn't apply
// the rule to the web request at all.
//
// This configuration is used only for IPSetReferenceStatement. For GeoMatchStatement
// and RateBasedStatement, use ForwardedIPConfig instead.
type IPSetForwardedIPConfig struct {
	_ struct{} `type:"structure"`

	// The match status to assign to the web request if the request doesn't have
	// a valid IP address in the specified position.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	//
	// You can specify the following fallback behaviors:
	//
	//    * MATCH - Treat the web request as matching the rule statement. AWS WAF
	//    applies the rule action to the request.
	//
	//    * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// FallbackBehavior is a required field
	FallbackBehavior FallbackBehavior `type:"string" required:"true" enum:"true"`

	// The name of the HTTP header to use for the IP address. For example, to use
	// the X-Forwarded-For (XFF) header, set this to X-Forwarded-For.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	//
	// HeaderName is a required field
	HeaderName *string `min:"1" type:"string" required:"true"`

	// The position in the header to search for the IP address. The header can contain
	// IP addresses of the original client and also of proxies. For example, the
	// header value could be 10.1.1.1, 127.0.0.0, 10.10.10.10 where the first IP
	// address identifies the original client and the rest identify proxies that
	// the request went through.
	//
	// The options for this setting are the following:
	//
	//    * FIRST - Inspect the first IP address in the list of IP addresses in
	//    the header. This is usually the client's original IP.
	//
	//    * LAST - Inspect the last IP address in the list of IP addresses in the
	//    header.
	//
	//    * ANY - Inspect all IP addresses in the header for a match. If the header
	//    contains more than 10 IP addresses, AWS WAF inspects the last 10.
	//
	// Position is a required field
	Position ForwardedIPPosition `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s IPSetForwardedIPConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetForwardedIPConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IPSetForwardedIPConfig"}
	if len(s.FallbackBehavior) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FallbackBehavior"))
	}

	if s.HeaderName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderName != nil && len(*s.HeaderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HeaderName", 1))
	}
	if len(s.Position) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Position"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement used to detect web requests coming from particular IP addresses
// or address ranges. To use this, create an IPSet that specifies the addresses
// you want to detect, then use the ARN of that set in this statement. To create
// an IP set, see CreateIPSet.
//
// Each IP set rule statement references an IP set. You create and maintain
// the set independent of your rules. This allows you to use the single set
// in multiple rules. When you update the referenced set, AWS WAF automatically
// updates all rules that reference it.
type IPSetReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IPSet that this statement references.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	IPSetForwardedIPConfig *IPSetForwardedIPConfig `type:"structure"`
}

// String returns the string representation
func (s IPSetReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetReferenceStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IPSetReferenceStatement"}

	if s.ARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ARN", 20))
	}
	if s.IPSetForwardedIPConfig != nil {
		if err := s.IPSetForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("IPSetForwardedIPConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about an IPSet, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage an IPSet, and the ARN, that you provide to the IPSetReferenceStatement
// to use the address set in a Rule.
type IPSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the IP set that helps with identification. You cannot change
	// the description of an IP set after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the IP set. You cannot change the name of an IPSet after you
	// create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IPSetSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Defines an association between Amazon Kinesis Data Firehose destinations
// and a web ACL resource, for logging from AWS WAF. As part of the association,
// you can specify parts of the standard logging fields to keep out of the logs.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Kinesis Data Firehose Amazon Resource Name (ARNs) that you want
	// to associate with the web ACL.
	//
	// LogDestinationConfigs is a required field
	LogDestinationConfigs []string `min:"1" type:"list" required:"true"`

	// The parts of the request that you want to keep out of the logs. For example,
	// if you redact the cookie field, the cookie field in the firehose will be
	// xxx.
	RedactedFields []FieldToMatch `type:"list"`

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate
	// with LogDestinationConfigs.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingConfiguration"}

	if s.LogDestinationConfigs == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogDestinationConfigs"))
	}
	if s.LogDestinationConfigs != nil && len(s.LogDestinationConfigs) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogDestinationConfigs", 1))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.RedactedFields != nil {
		for i, v := range s.RedactedFields {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RedactedFields", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement used to run the rules that are defined in a managed rule
// group. To use this, provide the vendor name and the name of the rule group
// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
//
// You can't nest a ManagedRuleGroupStatement, for example for use inside a
// NotStatement or OrStatement. It can only be referenced as a top-level statement
// within a rule.
type ManagedRuleGroupStatement struct {
	_ struct{} `type:"structure"`

	// The rules whose actions are set to COUNT by the web ACL, regardless of the
	// action that is set on the rule. This effectively excludes the rule from acting
	// on web requests.
	ExcludedRules []ExcludedRule `type:"list"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// VendorName is a required field
	VendorName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ManagedRuleGroupStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedRuleGroupStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ManagedRuleGroupStatement"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.VendorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VendorName"))
	}
	if s.VendorName != nil && len(*s.VendorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VendorName", 1))
	}
	if s.ExcludedRules != nil {
		for i, v := range s.ExcludedRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about a managed rule group, returned by ListAvailableManagedRuleGroups.
// This provides information like the name and vendor name, that you provide
// when you add a ManagedRuleGroupStatement to a web ACL. Managed rule groups
// include AWS Managed Rules rule groups, which are free of charge to AWS WAF
// customers, and AWS Marketplace managed rule groups, which you can subscribe
// to through AWS Marketplace.
type ManagedRuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// The description of the managed rule group, provided by AWS Managed Rules
	// or the AWS Marketplace seller who manages it.
	Description *string `min:"1" type:"string"`

	// The name of the managed rule group. You use this, along with the vendor name,
	// to identify the rule group.
	Name *string `min:"1" type:"string"`

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	VendorName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ManagedRuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The HTTP method of a web request. The method indicates the type of operation
// that the request is asking the origin to perform.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type Method struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s Method) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Specifies that AWS WAF should do nothing. This is generally used to try out
// a rule without performing any actions. You set the OverrideAction on the
// Rule.
//
// This is used only in the context of other settings, for example to specify
// values for RuleAction and web ACL DefaultAction.
type NoneAction struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s NoneAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A logical rule statement used to negate the results of another rule statement.
// You provide one Statement within the NotStatement.
type NotStatement struct {
	_ struct{} `type:"structure"`

	// The statement to negate. You can use any statement that can be nested.
	//
	// Statement is a required field
	Statement *Statement `type:"structure" required:"true"`
}

// String returns the string representation
func (s NotStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotStatement"}

	if s.Statement == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statement"))
	}
	if s.Statement != nil {
		if err := s.Statement.Validate(); err != nil {
			invalidParams.AddNested("Statement", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A logical rule statement used to combine other rule statements with OR logic.
// You provide more than one Statement within the OrStatement.
type OrStatement struct {
	_ struct{} `type:"structure"`

	// The statements to combine with OR logic. You can use any statements that
	// can be nested.
	//
	// Statements is a required field
	Statements []Statement `type:"list" required:"true"`
}

// String returns the string representation
func (s OrStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OrStatement"}

	if s.Statements == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statements"))
	}
	if s.Statements != nil {
		for i, v := range s.Statements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Statements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The override action to apply to the rules in a rule group. Used only for
// rule statements that reference a rule group, like RuleGroupReferenceStatement
// and ManagedRuleGroupStatement.
//
// Set the override action to none to leave the rule actions in effect. Set
// it to count to only count matches, regardless of the rule action settings.
//
// In a Rule, you must specify either this OverrideAction setting or the rule
// Action setting, but not both:
//
//    * If the rule statement references a rule group, use this override action
//    setting and not the action setting.
//
//    * If the rule statement does not reference a rule group, use the rule
//    action setting and not this rule override action setting.
type OverrideAction struct {
	_ struct{} `type:"structure"`

	// Override the rule action setting to count.
	Count *CountAction `type:"structure"`

	// Don't override the rule action setting.
	None *NoneAction `type:"structure"`
}

// String returns the string representation
func (s OverrideAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The query string of a web request. This is the part of a URL that appears
// after a ? character, if any.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type QueryString struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s QueryString) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rate-based rule tracks the rate of requests for each originating IP address,
// and triggers the rule action when the rate exceeds a limit that you specify
// on the number of requests in any 5-minute time span. You can use this to
// put a temporary block on requests from an IP address that is sending excessive
// requests.
//
// When the rule action triggers, AWS WAF blocks additional requests from the
// IP address until the request rate falls below the limit.
//
// You can optionally nest another statement inside the rate-based statement,
// to narrow the scope of the rule so that it only counts requests that match
// the nested statement. For example, based on recent requests that you have
// seen from an attacker, you might create a rate-based rule with a nested AND
// rule statement that contains the following nested statements:
//
//    * An IP match statement with an IP set that specified the address 192.0.2.44.
//
//    * A string match statement that searches in the User-Agent header for
//    the string BadBot.
//
// In this rate-based rule, you also define a rate limit. For this example,
// the rate limit is 1,000. Requests that meet both of the conditions in the
// statements are counted. If the count exceeds 1,000 requests per five minutes,
// the rule action triggers. Requests that do not meet both conditions are not
// counted towards the rate limit and are not affected by this rule.
//
// You cannot nest a RateBasedStatement, for example for use inside a NotStatement
// or OrStatement. It can only be referenced as a top-level statement within
// a rule.
type RateBasedStatement struct {
	_ struct{} `type:"structure"`

	// Setting that indicates how to aggregate the request counts. The options are
	// the following:
	//
	//    * IP - Aggregate the request counts on the IP address from the web request
	//    origin.
	//
	//    * FORWARDED_IP - Aggregate the request counts on the first IP address
	//    in an HTTP header. If you use this, configure the ForwardedIPConfig, to
	//    specify the header to use.
	//
	// AggregateKeyType is a required field
	AggregateKeyType RateBasedStatementAggregateKeyType `type:"string" required:"true" enum:"true"`

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name.
	//
	// If the specified header isn't present in the request, AWS WAF doesn't apply
	// the rule to the web request at all.
	//
	// This is required if AggregateKeyType is set to FORWARDED_IP.
	ForwardedIPConfig *ForwardedIPConfig `type:"structure"`

	// The limit on requests per 5-minute period for a single originating IP address.
	// If the statement includes a ScopeDownStatement, this limit is applied only
	// to the requests that match the statement.
	//
	// Limit is a required field
	Limit *int64 `min:"100" type:"long" required:"true"`

	// An optional nested statement that narrows the scope of the rate-based statement
	// to matching web requests. This can be any nestable statement, and you can
	// nest statements at any level below this scope-down statement.
	ScopeDownStatement *Statement `type:"structure"`
}

// String returns the string representation
func (s RateBasedStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RateBasedStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RateBasedStatement"}
	if len(s.AggregateKeyType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AggregateKeyType"))
	}

	if s.Limit == nil {
		invalidParams.Add(aws.NewErrParamRequired("Limit"))
	}
	if s.Limit != nil && *s.Limit < 100 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 100))
	}
	if s.ForwardedIPConfig != nil {
		if err := s.ForwardedIPConfig.Validate(); err != nil {
			invalidParams.AddNested("ForwardedIPConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.ScopeDownStatement != nil {
		if err := s.ScopeDownStatement.Validate(); err != nil {
			invalidParams.AddNested("ScopeDownStatement", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The set of IP addresses that are currently blocked for a rate-based statement.
type RateBasedStatementManagedKeysIPSet struct {
	_ struct{} `type:"structure"`

	// The IP addresses that are currently blocked.
	Addresses []string `type:"list"`

	IPAddressVersion IPAddressVersion `type:"string" enum:"true"`
}

// String returns the string representation
func (s RateBasedStatementManagedKeysIPSet) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A single regular expression. This is used in a RegexPatternSet.
type Regex struct {
	_ struct{} `type:"structure"`

	// The string representing the regular expression.
	RegexString *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Regex) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Regex) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Regex"}
	if s.RegexString != nil && len(*s.RegexString) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RegexString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Contains one or more regular expressions.
//
// AWS WAF assigns an ARN to each RegexPatternSet that you create. To use a
// set in a rule, you provide the ARN to the Rule statement RegexPatternSetReferenceStatement.
type RegexPatternSet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the set that helps with identification. You cannot change
	// the description of a set after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// The name of the set. You cannot change the name after you create the set.
	Name *string `min:"1" type:"string"`

	// The regular expression patterns in the set.
	RegularExpressionList []Regex `type:"list"`
}

// String returns the string representation
func (s RegexPatternSet) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement used to search web request components for matches with regular
// expressions. To use this, create a RegexPatternSet that specifies the expressions
// that you want to detect, then use the ARN of that set in this statement.
// A web request matches the pattern set rule statement if the request component
// matches any of the patterns in the set. To create a regex pattern set, see
// CreateRegexPatternSet.
//
// Each regex pattern set rule statement references a regex pattern set. You
// create and maintain the set independent of your rules. This allows you to
// use the single set in multiple rules. When you update the referenced set,
// AWS WAF automatically updates all rules that reference it.
type RegexPatternSetReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RegexPatternSet that this statement
	// references.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The part of a web request that you want AWS WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, AWS WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RegexPatternSetReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegexPatternSetReferenceStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegexPatternSetReferenceStatement"}

	if s.ARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ARN", 20))
	}

	if s.FieldToMatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldToMatch"))
	}

	if s.TextTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about a RegexPatternSet, returned by operations like
// create and list. This provides information like the ID, that you can use
// to retrieve and manage a RegexPatternSet, and the ARN, that you provide to
// the RegexPatternSetReferenceStatement to use the pattern set in a Rule.
type RegexPatternSetSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the set that helps with identification. You cannot change
	// the description of a set after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the set. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the data type instance. You cannot change the name after you
	// create the instance.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RegexPatternSetSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A single rule, which you can use in a WebACL or RuleGroup to identify web
// requests that you want to allow, block, or count. Each rule includes one
// top-level Statement that AWS WAF uses to identify matching web requests,
// and parameters that govern how AWS WAF handles them.
type Rule struct {
	_ struct{} `type:"structure"`

	// The action that AWS WAF should take on a web request when it matches the
	// rule statement. Settings at the web ACL level can override the rule action
	// setting.
	//
	// This is used only for rules whose statements do not reference a rule group.
	// Rule statements that reference a rule group include RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// You must specify either this Action setting or the rule OverrideAction setting,
	// but not both:
	//
	//    * If the rule statement does not reference a rule group, use this rule
	//    action setting and not the rule override action setting.
	//
	//    * If the rule statement references a rule group, use the override action
	//    setting and not this action setting.
	Action *RuleAction `type:"structure"`

	// The name of the rule. You can't change the name of a Rule after you create
	// it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The override action to apply to the rules in a rule group. Used only for
	// rule statements that reference a rule group, like RuleGroupReferenceStatement
	// and ManagedRuleGroupStatement.
	//
	// Set the override action to none to leave the rule actions in effect. Set
	// it to count to only count matches, regardless of the rule action settings.
	//
	// In a Rule, you must specify either this OverrideAction setting or the rule
	// Action setting, but not both:
	//
	//    * If the rule statement references a rule group, use this override action
	//    setting and not the action setting.
	//
	//    * If the rule statement does not reference a rule group, use the rule
	//    action setting and not this rule override action setting.
	OverrideAction *OverrideAction `type:"structure"`

	// If you define more than one Rule in a WebACL, AWS WAF evaluates each request
	// against the Rules in order based on the value of Priority. AWS WAF processes
	// rules with lower priority first. The priorities don't need to be consecutive,
	// but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// The AWS WAF processing statement for the rule, for example ByteMatchStatement
	// or SizeConstraintStatement.
	//
	// Statement is a required field
	Statement *Statement `type:"structure" required:"true"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Rule"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Priority == nil {
		invalidParams.Add(aws.NewErrParamRequired("Priority"))
	}

	if s.Statement == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statement"))
	}

	if s.VisibilityConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("VisibilityConfig"))
	}
	if s.Statement != nil {
		if err := s.Statement.Validate(); err != nil {
			invalidParams.AddNested("Statement", err.(aws.ErrInvalidParams))
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The action that AWS WAF should take on a web request when it matches a rule's
// statement. Settings at the web ACL level can override the rule action setting.
type RuleAction struct {
	_ struct{} `type:"structure"`

	// Instructs AWS WAF to allow the web request.
	Allow *AllowAction `type:"structure"`

	// Instructs AWS WAF to block the web request.
	Block *BlockAction `type:"structure"`

	// Instructs AWS WAF to count the web request and allow it.
	Count *CountAction `type:"structure"`
}

// String returns the string representation
func (s RuleAction) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within
// the capacity. This allows others to reuse the rule group with confidence
// in its capacity requirements.
type RuleGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The web ACL capacity units (WCUs) required for this rule group.
	//
	// When you create your own rule group, you define this, and you cannot change
	// it after creation. When you add or modify the rules in a rule group, AWS
	// WAF enforces this limit. You can check the capacity for a set of rules using
	// CheckCapacity.
	//
	// AWS WAF uses WCUs to calculate and control the operating resources that are
	// used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity
	// differently for each rule type, to reflect the relative cost of each rule.
	// Simple rules that cost little to run use fewer WCUs than more complex rules
	// that use more processing power. Rule group capacity is fixed at creation,
	// which helps users plan their web ACL WCU usage when they use a rule group.
	// The WCU limit for web ACLs is 1,500.
	//
	// Capacity is a required field
	Capacity *int64 `min:"1" type:"long" required:"true"`

	// A description of the rule group that helps with identification. You cannot
	// change the description of a rule group after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name of the rule group. You cannot change the name of a rule group after
	// you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that AWS WAF
	// uses to identify matching web requests, and parameters that govern how AWS
	// WAF handles them.
	Rules []Rule `type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s RuleGroup) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement used to run the rules that are defined in a RuleGroup. To
// use this, create a rule group with your rules, then provide the ARN of the
// rule group in this statement.
//
// You cannot nest a RuleGroupReferenceStatement, for example for use inside
// a NotStatement or OrStatement. It can only be referenced as a top-level statement
// within a rule.
type RuleGroupReferenceStatement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The names of rules that are in the referenced rule group, but that you want
	// AWS WAF to exclude from processing for this rule statement.
	ExcludedRules []ExcludedRule `type:"list"`
}

// String returns the string representation
func (s RuleGroupReferenceStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleGroupReferenceStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RuleGroupReferenceStatement"}

	if s.ARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ARN"))
	}
	if s.ARN != nil && len(*s.ARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ARN", 20))
	}
	if s.ExcludedRules != nil {
		for i, v := range s.ExcludedRules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedRules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about a RuleGroup, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
// to use the rule group in a Rule.
type RuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the rule group that helps with identification. You cannot
	// change the description of a rule group after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the rule group. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the data type instance. You cannot change the name after you
	// create the instance.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about a Rule, returned by operations like DescribeManagedRuleGroup.
// This provides information like the ID, that you can use to retrieve and manage
// a RuleGroup, and the ARN, that you provide to the RuleGroupReferenceStatement
// to use the rule group in a Rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	//
	// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
	// 2019. For information, including how to migrate your AWS WAF resources from
	// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// The action that AWS WAF should take on a web request when it matches a rule's
	// statement. Settings at the web ACL level can override the rule action setting.
	Action *RuleAction `type:"structure"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Represents a single sampled web request. The response from GetSampledRequests
// includes a SampledHTTPRequests complex type that appears as SampledRequests
// in the response syntax. SampledHTTPRequests contains an array of SampledHTTPRequest
// objects.
type SampledHTTPRequest struct {
	_ struct{} `type:"structure"`

	// The action for the Rule that the request matched: ALLOW, BLOCK, or COUNT.
	Action *string `type:"string"`

	// A complex type that contains detailed information about the request.
	//
	// Request is a required field
	Request *HTTPRequest `type:"structure" required:"true"`

	// The name of the Rule that the request matched. For managed rule groups, the
	// format for this name is <vendor name>#<managed rule group name>#<rule name>.
	// For your own rule groups, the format for this name is <rule group name>#<rule
	// name>. If the rule is not in a rule group, the format is <rule name>.
	RuleNameWithinRuleGroup *string `min:"1" type:"string"`

	// The time at which AWS WAF received the request from your AWS resource, in
	// Unix time format (in seconds).
	Timestamp *time.Time `type:"timestamp"`

	// A value that indicates how one result in the response relates proportionally
	// to other results in the response. For example, a result that has a weight
	// of 2 represents roughly twice as many web requests as a result that has a
	// weight of 1.
	//
	// Weight is a required field
	Weight *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s SampledHTTPRequest) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// One of the headers in a web request, identified by name, for example, User-Agent
// or Referer. This setting isn't case sensitive.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type SingleHeader struct {
	_ struct{} `type:"structure"`

	// The name of the query header to inspect.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SingleHeader) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleHeader) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SingleHeader"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// One query argument in a web request, identified by name, for example UserName
// or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
type SingleQueryArgument struct {
	_ struct{} `type:"structure"`

	// The name of the query argument to inspect.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SingleQueryArgument) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleQueryArgument) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SingleQueryArgument"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement that compares a number of bytes against the size of a request
// component, using a comparison operator, such as greater than (>) or less
// than (<). For example, you can use a size constraint statement to look for
// query strings that are longer than 100 bytes.
//
// If you configure AWS WAF to inspect the request body, AWS WAF inspects only
// the first 8192 bytes (8 KB). If the request body for your web requests never
// exceeds 8192 bytes, you can create a size constraint condition and block
// requests that have a request body greater than 8192 bytes.
//
// If you choose URI for the value of Part of the request to filter on, the
// slash (/) in the URI counts as one character. For example, the URI /logo.jpg
// is nine characters long.
type SizeConstraintStatement struct {
	_ struct{} `type:"structure"`

	// The operator to use to compare the request part to the size setting.
	//
	// ComparisonOperator is a required field
	ComparisonOperator ComparisonOperator `type:"string" required:"true" enum:"true"`

	// The part of a web request that you want AWS WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The size, in byte, to compare to the request part, after any transformations.
	//
	// Size is a required field
	Size *int64 `type:"long" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, AWS WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SizeConstraintStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SizeConstraintStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SizeConstraintStatement"}
	if len(s.ComparisonOperator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComparisonOperator"))
	}

	if s.FieldToMatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldToMatch"))
	}

	if s.Size == nil {
		invalidParams.Add(aws.NewErrParamRequired("Size"))
	}

	if s.TextTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Attackers sometimes insert malicious SQL code into web requests in an effort
// to extract data from your database. To allow or block web requests that appear
// to contain malicious SQL code, create one or more SQL injection match conditions.
// An SQL injection match condition identifies the part of web requests, such
// as the URI or the query string, that you want AWS WAF to inspect. Later in
// the process, when you create a web ACL, you specify whether to allow or block
// requests that appear to contain malicious SQL code.
type SqliMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want AWS WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, AWS WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s SqliMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqliMatchStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqliMatchStatement"}

	if s.FieldToMatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldToMatch"))
	}

	if s.TextTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The processing guidance for a Rule, used by AWS WAF to determine whether
// a web request matches the rule.
type Statement struct {
	_ struct{} `type:"structure"`

	// A logical rule statement used to combine other rule statements with AND logic.
	// You provide more than one Statement within the AndStatement.
	AndStatement *AndStatement `type:"structure"`

	// A rule statement that defines a string match search for AWS WAF to apply
	// to web requests. The byte match statement provides the bytes to search for,
	// the location in requests that you want AWS WAF to search, and other settings.
	// The bytes to search for are typically a string that corresponds with ASCII
	// characters. In the AWS WAF console and the developer guide, this is refered
	// to as a string match statement.
	ByteMatchStatement *ByteMatchStatement `type:"structure"`

	// A rule statement used to identify web requests based on country of origin.
	GeoMatchStatement *GeoMatchStatement `type:"structure"`

	// A rule statement used to detect web requests coming from particular IP addresses
	// or address ranges. To use this, create an IPSet that specifies the addresses
	// you want to detect, then use the ARN of that set in this statement. To create
	// an IP set, see CreateIPSet.
	//
	// Each IP set rule statement references an IP set. You create and maintain
	// the set independent of your rules. This allows you to use the single set
	// in multiple rules. When you update the referenced set, AWS WAF automatically
	// updates all rules that reference it.
	IPSetReferenceStatement *IPSetReferenceStatement `type:"structure"`

	// A rule statement used to run the rules that are defined in a managed rule
	// group. To use this, provide the vendor name and the name of the rule group
	// in this statement. You can retrieve the required names by calling ListAvailableManagedRuleGroups.
	//
	// You can't nest a ManagedRuleGroupStatement, for example for use inside a
	// NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement `type:"structure"`

	// A logical rule statement used to negate the results of another rule statement.
	// You provide one Statement within the NotStatement.
	NotStatement *NotStatement `type:"structure"`

	// A logical rule statement used to combine other rule statements with OR logic.
	// You provide more than one Statement within the OrStatement.
	OrStatement *OrStatement `type:"structure"`

	// A rate-based rule tracks the rate of requests for each originating IP address,
	// and triggers the rule action when the rate exceeds a limit that you specify
	// on the number of requests in any 5-minute time span. You can use this to
	// put a temporary block on requests from an IP address that is sending excessive
	// requests.
	//
	// When the rule action triggers, AWS WAF blocks additional requests from the
	// IP address until the request rate falls below the limit.
	//
	// You can optionally nest another statement inside the rate-based statement,
	// to narrow the scope of the rule so that it only counts requests that match
	// the nested statement. For example, based on recent requests that you have
	// seen from an attacker, you might create a rate-based rule with a nested AND
	// rule statement that contains the following nested statements:
	//
	//    * An IP match statement with an IP set that specified the address 192.0.2.44.
	//
	//    * A string match statement that searches in the User-Agent header for
	//    the string BadBot.
	//
	// In this rate-based rule, you also define a rate limit. For this example,
	// the rate limit is 1,000. Requests that meet both of the conditions in the
	// statements are counted. If the count exceeds 1,000 requests per five minutes,
	// the rule action triggers. Requests that do not meet both conditions are not
	// counted towards the rate limit and are not affected by this rule.
	//
	// You cannot nest a RateBasedStatement, for example for use inside a NotStatement
	// or OrStatement. It can only be referenced as a top-level statement within
	// a rule.
	RateBasedStatement *RateBasedStatement `type:"structure"`

	// A rule statement used to search web request components for matches with regular
	// expressions. To use this, create a RegexPatternSet that specifies the expressions
	// that you want to detect, then use the ARN of that set in this statement.
	// A web request matches the pattern set rule statement if the request component
	// matches any of the patterns in the set. To create a regex pattern set, see
	// CreateRegexPatternSet.
	//
	// Each regex pattern set rule statement references a regex pattern set. You
	// create and maintain the set independent of your rules. This allows you to
	// use the single set in multiple rules. When you update the referenced set,
	// AWS WAF automatically updates all rules that reference it.
	RegexPatternSetReferenceStatement *RegexPatternSetReferenceStatement `type:"structure"`

	// A rule statement used to run the rules that are defined in a RuleGroup. To
	// use this, create a rule group with your rules, then provide the ARN of the
	// rule group in this statement.
	//
	// You cannot nest a RuleGroupReferenceStatement, for example for use inside
	// a NotStatement or OrStatement. It can only be referenced as a top-level statement
	// within a rule.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement `type:"structure"`

	// A rule statement that compares a number of bytes against the size of a request
	// component, using a comparison operator, such as greater than (>) or less
	// than (<). For example, you can use a size constraint statement to look for
	// query strings that are longer than 100 bytes.
	//
	// If you configure AWS WAF to inspect the request body, AWS WAF inspects only
	// the first 8192 bytes (8 KB). If the request body for your web requests never
	// exceeds 8192 bytes, you can create a size constraint condition and block
	// requests that have a request body greater than 8192 bytes.
	//
	// If you choose URI for the value of Part of the request to filter on, the
	// slash (/) in the URI counts as one character. For example, the URI /logo.jpg
	// is nine characters long.
	SizeConstraintStatement *SizeConstraintStatement `type:"structure"`

	// Attackers sometimes insert malicious SQL code into web requests in an effort
	// to extract data from your database. To allow or block web requests that appear
	// to contain malicious SQL code, create one or more SQL injection match conditions.
	// An SQL injection match condition identifies the part of web requests, such
	// as the URI or the query string, that you want AWS WAF to inspect. Later in
	// the process, when you create a web ACL, you specify whether to allow or block
	// requests that appear to contain malicious SQL code.
	SqliMatchStatement *SqliMatchStatement `type:"structure"`

	// A rule statement that defines a cross-site scripting (XSS) match search for
	// AWS WAF to apply to web requests. XSS attacks are those where the attacker
	// uses vulnerabilities in a benign website as a vehicle to inject malicious
	// client-site scripts into other legitimate web browsers. The XSS match statement
	// provides the location in requests that you want AWS WAF to search and text
	// transformations to use on the search area before AWS WAF searches for character
	// sequences that are likely to be malicious strings.
	XssMatchStatement *XssMatchStatement `type:"structure"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Statement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Statement"}
	if s.AndStatement != nil {
		if err := s.AndStatement.Validate(); err != nil {
			invalidParams.AddNested("AndStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.ByteMatchStatement != nil {
		if err := s.ByteMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("ByteMatchStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.GeoMatchStatement != nil {
		if err := s.GeoMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("GeoMatchStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.IPSetReferenceStatement != nil {
		if err := s.IPSetReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("IPSetReferenceStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.ManagedRuleGroupStatement != nil {
		if err := s.ManagedRuleGroupStatement.Validate(); err != nil {
			invalidParams.AddNested("ManagedRuleGroupStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.NotStatement != nil {
		if err := s.NotStatement.Validate(); err != nil {
			invalidParams.AddNested("NotStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.OrStatement != nil {
		if err := s.OrStatement.Validate(); err != nil {
			invalidParams.AddNested("OrStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.RateBasedStatement != nil {
		if err := s.RateBasedStatement.Validate(); err != nil {
			invalidParams.AddNested("RateBasedStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.RegexPatternSetReferenceStatement != nil {
		if err := s.RegexPatternSetReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("RegexPatternSetReferenceStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.RuleGroupReferenceStatement != nil {
		if err := s.RuleGroupReferenceStatement.Validate(); err != nil {
			invalidParams.AddNested("RuleGroupReferenceStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.SizeConstraintStatement != nil {
		if err := s.SizeConstraintStatement.Validate(); err != nil {
			invalidParams.AddNested("SizeConstraintStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.SqliMatchStatement != nil {
		if err := s.SqliMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("SqliMatchStatement", err.(aws.ErrInvalidParams))
		}
	}
	if s.XssMatchStatement != nil {
		if err := s.XssMatchStatement.Validate(); err != nil {
			invalidParams.AddNested("XssMatchStatement", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A tag associated with an AWS resource. Tags are key:value pairs that you
// can use to categorize and manage your resources, for purposes like billing
// or other management. Typically, the tag key represents a category, such as
// "environment", and the tag value represents a specific value within that
// category, such as "test," "development," or "production". Or you might set
// the tag key to "customer" and the value to the customer name or ID. You can
// specify one or more tags to add to each AWS resource, up to 50 tags for a
// resource.
//
// You can tag the AWS resources that you manage through AWS WAF: web ACLs,
// rule groups, IP sets, and regex pattern sets. You can't manage or view tags
// through the AWS WAF console.
type Tag struct {
	_ struct{} `type:"structure"`

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The collection of tagging definitions for an AWS resource. Tags are key:value
// pairs that you can use to categorize and manage your resources, for purposes
// like billing or other management. Typically, the tag key represents a category,
// such as "environment", and the tag value represents a specific value within
// that category, such as "test," "development," or "production". Or you might
// set the tag key to "customer" and the value to the customer name or ID. You
// can specify one or more tags to add to each AWS resource, up to 50 tags for
// a resource.
//
// You can tag the AWS resources that you manage through AWS WAF: web ACLs,
// rule groups, IP sets, and regex pattern sets. You can't manage or view tags
// through the AWS WAF console.
type TagInfoForResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	ResourceARN *string `min:"20" type:"string"`

	// The array of Tag objects defined for the resource.
	TagList []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagInfoForResource) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Text transformations eliminate some of the unusual formatting that attackers
// use in web requests in an effort to bypass detection.
type TextTransformation struct {
	_ struct{} `type:"structure"`

	// Sets the relative processing order for multiple transformations that are
	// defined for a rule statement. AWS WAF processes all transformations, from
	// lowest priority to highest, before inspecting the transformed content. The
	// priorities don't need to be consecutive, but they must all be different.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// You can specify the following transformation types:
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want any text transformations.
	//
	// Type is a required field
	Type TextTransformationType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TextTransformation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextTransformation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TextTransformation"}

	if s.Priority == nil {
		invalidParams.Add(aws.NewErrParamRequired("Priority"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// In a GetSampledRequests request, the StartTime and EndTime objects specify
// the time range for which you want AWS WAF to return a sample of web requests.
//
// You must specify the times in Coordinated Universal Time (UTC) format. UTC
// format includes the special designator, Z. For example, "2016-09-27T14:50Z".
// You can specify any time range in the previous three hours.
//
// In a GetSampledRequests response, the StartTime and EndTime objects specify
// the time range for which AWS WAF actually returned a sample of web requests.
// AWS WAF gets the specified number of requests from among the first 5,000
// requests that your AWS resource receives during the specified time period.
// If your resource receives more than 5,000 requests during that period, AWS
// WAF stops sampling after the 5,000th request. In that case, EndTime is the
// time that AWS WAF received the 5,000th request.
type TimeWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time range from which you want GetSampledRequests to return
	// a sample of the requests that your AWS resource received. You must specify
	// the times in Coordinated Universal Time (UTC) format. UTC format includes
	// the special designator, Z. For example, "2016-09-27T14:50Z". You can specify
	// any time range in the previous three hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The beginning of the time range from which you want GetSampledRequests to
	// return a sample of the requests that your AWS resource received. You must
	// specify the times in Coordinated Universal Time (UTC) format. UTC format
	// includes the special designator, Z. For example, "2016-09-27T14:50Z". You
	// can specify any time range in the previous three hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TimeWindow) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeWindow) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimeWindow"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// The path component of the URI of a web request. This is the part of a web
// request that identifies a resource, for example, /images/daily-ad.jpg.
//
// This is used only to indicate the web request component for AWS WAF to inspect,
// in the FieldToMatch specification.
type UriPath struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UriPath) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Defines and enables Amazon CloudWatch metrics and web request sample collection.
type VisibilityConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether the associated resource sends metrics to CloudWatch.
	// For the list of available metrics, see AWS WAF Metrics (https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
	//
	// CloudWatchMetricsEnabled is a required field
	CloudWatchMetricsEnabled *bool `type:"boolean" required:"true"`

	// A name of the CloudWatch metric. The name can contain only the characters:
	// A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to
	// 128 characters long. It can't contain whitespace or metric names reserved
	// for AWS WAF, for example "All" and "Default_Action." You can't change a MetricName
	// after you create a VisibilityConfig.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// A boolean indicating whether AWS WAF should store a sampling of the web requests
	// that match the rules. You can view the sampled requests through the AWS WAF
	// console.
	//
	// SampledRequestsEnabled is a required field
	SampledRequestsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s VisibilityConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VisibilityConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VisibilityConfig"}

	if s.CloudWatchMetricsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchMetricsEnabled"))
	}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}
	if s.MetricName != nil && len(*s.MetricName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MetricName", 1))
	}

	if s.SampledRequestsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("SampledRequestsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A Web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the Web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of
// the rules. The rules in a Web ACL can be a combination of the types Rule,
// RuleGroup, and managed rule group. You can associate a Web ACL with one or
// more AWS resources to protect. The resources can be Amazon CloudFront, an
// Amazon API Gateway API, or an Application Load Balancer.
type WebACL struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Web ACL that you want to associate
	// with the resource.
	//
	// ARN is a required field
	ARN *string `min:"20" type:"string" required:"true"`

	// The web ACL capacity units (WCUs) currently being used by this web ACL.
	//
	// AWS WAF uses WCUs to calculate and control the operating resources that are
	// used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity
	// differently for each rule type, to reflect the relative cost of each rule.
	// Simple rules that cost little to run use fewer WCUs than more complex rules
	// that use more processing power. Rule group capacity is fixed at creation,
	// which helps users plan their web ACL WCU usage when they use a rule group.
	// The WCU limit for web ACLs is 1,500.
	Capacity *int64 `type:"long"`

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// DefaultAction is a required field
	DefaultAction *DefaultAction `type:"structure" required:"true"`

	// A description of the Web ACL that helps with identification. You cannot change
	// the description of a Web ACL after you create it.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the WebACL. This ID is returned in the responses
	// to create and list commands. You use this ID to do things like get, update,
	// and delete a WebACL.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Indicates whether this web ACL is managed by AWS Firewall Manager. If true,
	// then only AWS Firewall Manager can delete the web ACL or any Firewall Manager
	// rule groups in the web ACL.
	ManagedByFirewallManager *bool `type:"boolean"`

	// The name of the Web ACL. You cannot change the name of a Web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The last set of rules for AWS WAF to process in the web ACL. This is defined
	// in an AWS Firewall Manager WAF policy and contains only rule group references.
	// You can't alter these. Any rules and rule groups that you define for the
	// web ACL are prioritized before these.
	//
	// In the Firewall Manager WAF policy, the Firewall Manager administrator can
	// define a set of rule groups to run first in the web ACL and a set of rule
	// groups to run last. Within each set, the administrator prioritizes the rule
	// groups, to determine their relative processing order.
	PostProcessFirewallManagerRuleGroups []FirewallManagerRuleGroup `type:"list"`

	// The first set of rules for AWS WAF to process in the web ACL. This is defined
	// in an AWS Firewall Manager WAF policy and contains only rule group references.
	// You can't alter these. Any rules and rule groups that you define for the
	// web ACL are prioritized after these.
	//
	// In the Firewall Manager WAF policy, the Firewall Manager administrator can
	// define a set of rule groups to run first in the web ACL and a set of rule
	// groups to run last. Within each set, the administrator prioritizes the rule
	// groups, to determine their relative processing order.
	PreProcessFirewallManagerRuleGroups []FirewallManagerRuleGroup `type:"list"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that AWS WAF
	// uses to identify matching web requests, and parameters that govern how AWS
	// WAF handles them.
	Rules []Rule `type:"list"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s WebACL) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// High-level information about a WebACL, returned by operations like create
// and list. This provides information like the ID, that you can use to retrieve
// and manage a WebACL, and the ARN, that you provide to operations like AssociateWebACL.
type WebACLSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string `min:"20" type:"string"`

	// A description of the Web ACL that helps with identification. You cannot change
	// the description of a Web ACL after you create it.
	Description *string `min:"1" type:"string"`

	// The unique identifier for the Web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	Id *string `min:"1" type:"string"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	LockToken *string `min:"1" type:"string"`

	// The name of the Web ACL. You cannot change the name of a Web ACL after you
	// create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebACLSummary) String() string {
	return awsutil.Prettify(s)
}

//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// A rule statement that defines a cross-site scripting (XSS) match search for
// AWS WAF to apply to web requests. XSS attacks are those where the attacker
// uses vulnerabilities in a benign website as a vehicle to inject malicious
// client-site scripts into other legitimate web browsers. The XSS match statement
// provides the location in requests that you want AWS WAF to search and text
// transformations to use on the search area before AWS WAF searches for character
// sequences that are likely to be malicious strings.
type XssMatchStatement struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want AWS WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass detection. If you specify one
	// or more transformations in a rule statement, AWS WAF performs all transformations
	// on the content of the request component identified by FieldToMatch, starting
	// from the lowest priority setting, before inspecting the content for a match.
	//
	// TextTransformations is a required field
	TextTransformations []TextTransformation `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s XssMatchStatement) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *XssMatchStatement) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "XssMatchStatement"}

	if s.FieldToMatch == nil {
		invalidParams.Add(aws.NewErrParamRequired("FieldToMatch"))
	}

	if s.TextTransformations == nil {
		invalidParams.Add(aws.NewErrParamRequired("TextTransformations"))
	}
	if s.TextTransformations != nil && len(s.TextTransformations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TextTransformations", 1))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(aws.ErrInvalidParams))
		}
	}
	if s.TextTransformations != nil {
		for i, v := range s.TextTransformations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TextTransformations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
