// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package wafv2iface provides an interface to enable mocking the AWS WAFV2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package wafv2iface

import (
	"github.com/aws/aws-sdk-go-v2/service/wafv2"
)

// ClientAPI provides an interface to enable mocking the
// wafv2.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // WAFV2.
//    func myFunc(svc wafv2iface.ClientAPI) bool {
//        // Make svc.AssociateWebACL request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := wafv2.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        wafv2iface.ClientPI
//    }
//    func (m *mockClientClient) AssociateWebACL(input *wafv2.AssociateWebACLInput) (*wafv2.AssociateWebACLOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateWebACLRequest(*wafv2.AssociateWebACLInput) wafv2.AssociateWebACLRequest

	CheckCapacityRequest(*wafv2.CheckCapacityInput) wafv2.CheckCapacityRequest

	CreateIPSetRequest(*wafv2.CreateIPSetInput) wafv2.CreateIPSetRequest

	CreateRegexPatternSetRequest(*wafv2.CreateRegexPatternSetInput) wafv2.CreateRegexPatternSetRequest

	CreateRuleGroupRequest(*wafv2.CreateRuleGroupInput) wafv2.CreateRuleGroupRequest

	CreateWebACLRequest(*wafv2.CreateWebACLInput) wafv2.CreateWebACLRequest

	DeleteFirewallManagerRuleGroupsRequest(*wafv2.DeleteFirewallManagerRuleGroupsInput) wafv2.DeleteFirewallManagerRuleGroupsRequest

	DeleteIPSetRequest(*wafv2.DeleteIPSetInput) wafv2.DeleteIPSetRequest

	DeleteLoggingConfigurationRequest(*wafv2.DeleteLoggingConfigurationInput) wafv2.DeleteLoggingConfigurationRequest

	DeletePermissionPolicyRequest(*wafv2.DeletePermissionPolicyInput) wafv2.DeletePermissionPolicyRequest

	DeleteRegexPatternSetRequest(*wafv2.DeleteRegexPatternSetInput) wafv2.DeleteRegexPatternSetRequest

	DeleteRuleGroupRequest(*wafv2.DeleteRuleGroupInput) wafv2.DeleteRuleGroupRequest

	DeleteWebACLRequest(*wafv2.DeleteWebACLInput) wafv2.DeleteWebACLRequest

	DescribeManagedRuleGroupRequest(*wafv2.DescribeManagedRuleGroupInput) wafv2.DescribeManagedRuleGroupRequest

	DisassociateWebACLRequest(*wafv2.DisassociateWebACLInput) wafv2.DisassociateWebACLRequest

	GetIPSetRequest(*wafv2.GetIPSetInput) wafv2.GetIPSetRequest

	GetLoggingConfigurationRequest(*wafv2.GetLoggingConfigurationInput) wafv2.GetLoggingConfigurationRequest

	GetPermissionPolicyRequest(*wafv2.GetPermissionPolicyInput) wafv2.GetPermissionPolicyRequest

	GetRateBasedStatementManagedKeysRequest(*wafv2.GetRateBasedStatementManagedKeysInput) wafv2.GetRateBasedStatementManagedKeysRequest

	GetRegexPatternSetRequest(*wafv2.GetRegexPatternSetInput) wafv2.GetRegexPatternSetRequest

	GetRuleGroupRequest(*wafv2.GetRuleGroupInput) wafv2.GetRuleGroupRequest

	GetSampledRequestsRequest(*wafv2.GetSampledRequestsInput) wafv2.GetSampledRequestsRequest

	GetWebACLRequest(*wafv2.GetWebACLInput) wafv2.GetWebACLRequest

	GetWebACLForResourceRequest(*wafv2.GetWebACLForResourceInput) wafv2.GetWebACLForResourceRequest

	ListAvailableManagedRuleGroupsRequest(*wafv2.ListAvailableManagedRuleGroupsInput) wafv2.ListAvailableManagedRuleGroupsRequest

	ListIPSetsRequest(*wafv2.ListIPSetsInput) wafv2.ListIPSetsRequest

	ListLoggingConfigurationsRequest(*wafv2.ListLoggingConfigurationsInput) wafv2.ListLoggingConfigurationsRequest

	ListRegexPatternSetsRequest(*wafv2.ListRegexPatternSetsInput) wafv2.ListRegexPatternSetsRequest

	ListResourcesForWebACLRequest(*wafv2.ListResourcesForWebACLInput) wafv2.ListResourcesForWebACLRequest

	ListRuleGroupsRequest(*wafv2.ListRuleGroupsInput) wafv2.ListRuleGroupsRequest

	ListTagsForResourceRequest(*wafv2.ListTagsForResourceInput) wafv2.ListTagsForResourceRequest

	ListWebACLsRequest(*wafv2.ListWebACLsInput) wafv2.ListWebACLsRequest

	PutLoggingConfigurationRequest(*wafv2.PutLoggingConfigurationInput) wafv2.PutLoggingConfigurationRequest

	PutPermissionPolicyRequest(*wafv2.PutPermissionPolicyInput) wafv2.PutPermissionPolicyRequest

	TagResourceRequest(*wafv2.TagResourceInput) wafv2.TagResourceRequest

	UntagResourceRequest(*wafv2.UntagResourceInput) wafv2.UntagResourceRequest

	UpdateIPSetRequest(*wafv2.UpdateIPSetInput) wafv2.UpdateIPSetRequest

	UpdateRegexPatternSetRequest(*wafv2.UpdateRegexPatternSetInput) wafv2.UpdateRegexPatternSetRequest

	UpdateRuleGroupRequest(*wafv2.UpdateRuleGroupInput) wafv2.UpdateRuleGroupRequest

	UpdateWebACLRequest(*wafv2.UpdateWebACLInput) wafv2.UpdateWebACLRequest
}

var _ ClientAPI = (*wafv2.Client)(nil)
