// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type UpdateFolderInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The ID of the folder.
	//
	// FolderId is a required field
	FolderId *string `location:"uri" locationName:"FolderId" min:"1" type:"string" required:"true"`

	// The name of the folder.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	ParentFolderId *string `min:"1" type:"string"`

	// The resource state of the folder. Only ACTIVE and RECYCLED are accepted values
	// from the API.
	ResourceState ResourceStateType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateFolderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFolderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFolderInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}

	if s.FolderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FolderId"))
	}
	if s.FolderId != nil && len(*s.FolderId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FolderId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFolderInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentFolderId != nil {
		v := *s.ParentFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceState) > 0 {
		v := s.ResourceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FolderId != nil {
		v := *s.FolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateFolderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateFolderOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateFolderOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateFolder = "UpdateFolder"

// UpdateFolderRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Updates the specified attributes of the specified folder. The user must have
// access to both the folder and its parent folder, if applicable.
//
//    // Example sending a request using UpdateFolderRequest.
//    req := client.UpdateFolderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/UpdateFolder
func (c *Client) UpdateFolderRequest(input *UpdateFolderInput) UpdateFolderRequest {
	op := &aws.Operation{
		Name:       opUpdateFolder,
		HTTPMethod: "PATCH",
		HTTPPath:   "/api/v1/folders/{FolderId}",
	}

	if input == nil {
		input = &UpdateFolderInput{}
	}

	req := c.newRequest(op, input, &UpdateFolderOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateFolderRequest{Request: req, Input: input, Copy: c.UpdateFolderRequest}
}

// UpdateFolderRequest is the request type for the
// UpdateFolder API operation.
type UpdateFolderRequest struct {
	*aws.Request
	Input *UpdateFolderInput
	Copy  func(*UpdateFolderInput) UpdateFolderRequest
}

// Send marshals and sends the UpdateFolder API request.
func (r UpdateFolderRequest) Send(ctx context.Context) (*UpdateFolderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFolderResponse{
		UpdateFolderOutput: r.Request.Data.(*UpdateFolderOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFolderResponse is the response type for the
// UpdateFolder API operation.
type UpdateFolderResponse struct {
	*UpdateFolderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFolder request.
func (r *UpdateFolderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
