// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type RestoreDomainAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreDomainAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreDomainAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreDomainAccessInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 1))
	}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreDomainAccessInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type RestoreDomainAccessOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreDomainAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreDomainAccessOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opRestoreDomainAccess = "RestoreDomainAccess"

// RestoreDomainAccessRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Moves a domain to ACTIVE status if it was in the INACTIVE status.
//
//    // Example sending a request using RestoreDomainAccessRequest.
//    req := client.RestoreDomainAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess
func (c *Client) RestoreDomainAccessRequest(input *RestoreDomainAccessInput) RestoreDomainAccessRequest {
	op := &aws.Operation{
		Name:       opRestoreDomainAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/restoreDomainAccess",
	}

	if input == nil {
		input = &RestoreDomainAccessInput{}
	}

	req := c.newRequest(op, input, &RestoreDomainAccessOutput{})

	return RestoreDomainAccessRequest{Request: req, Input: input, Copy: c.RestoreDomainAccessRequest}
}

// RestoreDomainAccessRequest is the request type for the
// RestoreDomainAccess API operation.
type RestoreDomainAccessRequest struct {
	*aws.Request
	Input *RestoreDomainAccessInput
	Copy  func(*RestoreDomainAccessInput) RestoreDomainAccessRequest
}

// Send marshals and sends the RestoreDomainAccess API request.
func (r RestoreDomainAccessRequest) Send(ctx context.Context) (*RestoreDomainAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreDomainAccessResponse{
		RestoreDomainAccessOutput: r.Request.Data.(*RestoreDomainAccessOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreDomainAccessResponse is the response type for the
// RestoreDomainAccess API operation.
type RestoreDomainAccessResponse struct {
	*RestoreDomainAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreDomainAccess request.
func (r *RestoreDomainAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
