// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDefaultRetentionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The organization ID.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDefaultRetentionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDefaultRetentionPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDefaultRetentionPolicyInput"}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDefaultRetentionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The retention policy description.
	Description *string `type:"string"`

	// The retention policy folder configurations.
	FolderConfigurations []FolderConfiguration `type:"list"`

	// The retention policy ID.
	Id *string `min:"1" type:"string"`

	// The retention policy name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDefaultRetentionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDefaultRetentionPolicy = "GetDefaultRetentionPolicy"

// GetDefaultRetentionPolicyRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Gets the default retention policy details for the specified organization.
//
//    // Example sending a request using GetDefaultRetentionPolicyRequest.
//    req := client.GetDefaultRetentionPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy
func (c *Client) GetDefaultRetentionPolicyRequest(input *GetDefaultRetentionPolicyInput) GetDefaultRetentionPolicyRequest {
	op := &aws.Operation{
		Name:       opGetDefaultRetentionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDefaultRetentionPolicyInput{}
	}

	req := c.newRequest(op, input, &GetDefaultRetentionPolicyOutput{})

	return GetDefaultRetentionPolicyRequest{Request: req, Input: input, Copy: c.GetDefaultRetentionPolicyRequest}
}

// GetDefaultRetentionPolicyRequest is the request type for the
// GetDefaultRetentionPolicy API operation.
type GetDefaultRetentionPolicyRequest struct {
	*aws.Request
	Input *GetDefaultRetentionPolicyInput
	Copy  func(*GetDefaultRetentionPolicyInput) GetDefaultRetentionPolicyRequest
}

// Send marshals and sends the GetDefaultRetentionPolicy API request.
func (r GetDefaultRetentionPolicyRequest) Send(ctx context.Context) (*GetDefaultRetentionPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDefaultRetentionPolicyResponse{
		GetDefaultRetentionPolicyOutput: r.Request.Data.(*GetDefaultRetentionPolicyOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDefaultRetentionPolicyResponse is the response type for the
// GetDefaultRetentionPolicy API operation.
type GetDefaultRetentionPolicyResponse struct {
	*GetDefaultRetentionPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDefaultRetentionPolicy request.
func (r *GetDefaultRetentionPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
