// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package xray

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type BatchGetTracesInput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Specify the trace IDs of requests for which to retrieve segments.
	//
	// TraceIds is a required field
	TraceIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetTracesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTracesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetTracesInput"}

	if s.TraceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("TraceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetTracesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TraceIds != nil {
		v := s.TraceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "TraceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type BatchGetTracesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token.
	NextToken *string `type:"string"`

	// Full traces for the specified requests.
	Traces []Trace `type:"list"`

	// Trace IDs of requests that haven't been processed.
	UnprocessedTraceIds []string `type:"list"`
}

// String returns the string representation
func (s BatchGetTracesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchGetTracesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Traces != nil {
		v := s.Traces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Traces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.UnprocessedTraceIds != nil {
		v := s.UnprocessedTraceIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UnprocessedTraceIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opBatchGetTraces = "BatchGetTraces"

// BatchGetTracesRequest returns a request value for making API operation for
// AWS X-Ray.
//
// Retrieves a list of traces specified by ID. Each trace is a collection of
// segment documents that originates from a single request. Use GetTraceSummaries
// to get a list of trace IDs.
//
//    // Example sending a request using BatchGetTracesRequest.
//    req := client.BatchGetTracesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces
func (c *Client) BatchGetTracesRequest(input *BatchGetTracesInput) BatchGetTracesRequest {
	op := &aws.Operation{
		Name:       opBatchGetTraces,
		HTTPMethod: "POST",
		HTTPPath:   "/Traces",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetTracesInput{}
	}

	req := c.newRequest(op, input, &BatchGetTracesOutput{})

	return BatchGetTracesRequest{Request: req, Input: input, Copy: c.BatchGetTracesRequest}
}

// BatchGetTracesRequest is the request type for the
// BatchGetTraces API operation.
type BatchGetTracesRequest struct {
	*aws.Request
	Input *BatchGetTracesInput
	Copy  func(*BatchGetTracesInput) BatchGetTracesRequest
}

// Send marshals and sends the BatchGetTraces API request.
func (r BatchGetTracesRequest) Send(ctx context.Context) (*BatchGetTracesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetTracesResponse{
		BatchGetTracesOutput: r.Request.Data.(*BatchGetTracesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewBatchGetTracesRequestPaginator returns a paginator for BatchGetTraces.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.BatchGetTracesRequest(input)
//   p := xray.NewBatchGetTracesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewBatchGetTracesPaginator(req BatchGetTracesRequest) BatchGetTracesPaginator {
	return BatchGetTracesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *BatchGetTracesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// BatchGetTracesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type BatchGetTracesPaginator struct {
	aws.Pager
}

func (p *BatchGetTracesPaginator) CurrentPage() *BatchGetTracesOutput {
	return p.Pager.CurrentPage().(*BatchGetTracesOutput)
}

// BatchGetTracesResponse is the response type for the
// BatchGetTraces API operation.
type BatchGetTracesResponse struct {
	*BatchGetTracesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetTraces request.
func (r *BatchGetTracesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
