// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/video/livestream/v1/outputs.proto

package livestream

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The manifest type can be either `HLS` or `DASH`.
type Manifest_ManifestType int32

const (
	// The manifest type is not specified.
	Manifest_MANIFEST_TYPE_UNSPECIFIED Manifest_ManifestType = 0
	// Create an `HLS` manifest. The corresponding file extension is `.m3u8`.
	Manifest_HLS Manifest_ManifestType = 1
	// Create a `DASH` manifest. The corresponding file extension is `.mpd`.
	Manifest_DASH Manifest_ManifestType = 2
)

// Enum value maps for Manifest_ManifestType.
var (
	Manifest_ManifestType_name = map[int32]string{
		0: "MANIFEST_TYPE_UNSPECIFIED",
		1: "HLS",
		2: "DASH",
	}
	Manifest_ManifestType_value = map[string]int32{
		"MANIFEST_TYPE_UNSPECIFIED": 0,
		"HLS":                       1,
		"DASH":                      2,
	}
)

func (x Manifest_ManifestType) Enum() *Manifest_ManifestType {
	p := new(Manifest_ManifestType)
	*p = x
	return p
}

func (x Manifest_ManifestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Manifest_ManifestType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_outputs_proto_enumTypes[0].Descriptor()
}

func (Manifest_ManifestType) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_outputs_proto_enumTypes[0]
}

func (x Manifest_ManifestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Manifest_ManifestType.Descriptor instead.
func (Manifest_ManifestType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{2, 0}
}

// Encoding of an input element such as an audio, video, or text track.
// Elementary streams must be packaged before mapping and sharing between
// different output formats.
type ElementaryStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this elementary stream.
	Key string `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	// Required. Encoding of an audio, video, or text track.
	//
	// Types that are assignable to ElementaryStream:
	//	*ElementaryStream_VideoStream
	//	*ElementaryStream_AudioStream
	//	*ElementaryStream_TextStream
	ElementaryStream isElementaryStream_ElementaryStream `protobuf_oneof:"elementary_stream"`
}

func (x *ElementaryStream) Reset() {
	*x = ElementaryStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ElementaryStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ElementaryStream) ProtoMessage() {}

func (x *ElementaryStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ElementaryStream.ProtoReflect.Descriptor instead.
func (*ElementaryStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{0}
}

func (x *ElementaryStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (m *ElementaryStream) GetElementaryStream() isElementaryStream_ElementaryStream {
	if m != nil {
		return m.ElementaryStream
	}
	return nil
}

func (x *ElementaryStream) GetVideoStream() *VideoStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_VideoStream); ok {
		return x.VideoStream
	}
	return nil
}

func (x *ElementaryStream) GetAudioStream() *AudioStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_AudioStream); ok {
		return x.AudioStream
	}
	return nil
}

func (x *ElementaryStream) GetTextStream() *TextStream {
	if x, ok := x.GetElementaryStream().(*ElementaryStream_TextStream); ok {
		return x.TextStream
	}
	return nil
}

type isElementaryStream_ElementaryStream interface {
	isElementaryStream_ElementaryStream()
}

type ElementaryStream_VideoStream struct {
	// Encoding of a video stream.
	VideoStream *VideoStream `protobuf:"bytes,1,opt,name=video_stream,json=videoStream,proto3,oneof"`
}

type ElementaryStream_AudioStream struct {
	// Encoding of an audio stream.
	AudioStream *AudioStream `protobuf:"bytes,2,opt,name=audio_stream,json=audioStream,proto3,oneof"`
}

type ElementaryStream_TextStream struct {
	// Encoding of a text stream. For example, closed captions or subtitles.
	TextStream *TextStream `protobuf:"bytes,3,opt,name=text_stream,json=textStream,proto3,oneof"`
}

func (*ElementaryStream_VideoStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_AudioStream) isElementaryStream_ElementaryStream() {}

func (*ElementaryStream_TextStream) isElementaryStream_ElementaryStream() {}

// Multiplexing settings for output stream.
type MuxStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this multiplexed stream.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The container format. The default is `fmp4`.
	//
	// Supported container formats:
	//
	// - `fmp4` - the corresponding file extension is `.m4s`
	// - `ts` - the corresponding file extension is `.ts`
	Container string `protobuf:"bytes,3,opt,name=container,proto3" json:"container,omitempty"`
	// List of `ElementaryStream` [key][google.cloud.video.livestream.v1.ElementaryStream.key]s multiplexed in this
	// stream.
	//
	// - For `fmp4` container, must contain either one video or one audio stream.
	// - For `ts` container, must contain exactly one audio stream and up to one
	// video stream.
	ElementaryStreams []string `protobuf:"bytes,4,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// Segment settings for `fmp4` and `ts`.
	SegmentSettings *SegmentSettings `protobuf:"bytes,5,opt,name=segment_settings,json=segmentSettings,proto3" json:"segment_settings,omitempty"`
}

func (x *MuxStream) Reset() {
	*x = MuxStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MuxStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MuxStream) ProtoMessage() {}

func (x *MuxStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MuxStream.ProtoReflect.Descriptor instead.
func (*MuxStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{1}
}

func (x *MuxStream) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *MuxStream) GetContainer() string {
	if x != nil {
		return x.Container
	}
	return ""
}

func (x *MuxStream) GetElementaryStreams() []string {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *MuxStream) GetSegmentSettings() *SegmentSettings {
	if x != nil {
		return x.SegmentSettings
	}
	return nil
}

// Manifest configuration.
type Manifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the generated file. The default is `manifest` with the
	// extension suffix corresponding to the `Manifest` [type][google.cloud.video.livestream.v1.Manifest.type]. If multiple
	// manifests are added to the channel, each must have a unique file name.
	FileName string `protobuf:"bytes,1,opt,name=file_name,json=fileName,proto3" json:"file_name,omitempty"`
	// Required. Type of the manifest, can be `HLS` or `DASH`.
	Type Manifest_ManifestType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.video.livestream.v1.Manifest_ManifestType" json:"type,omitempty"`
	// Required. List of `MuxStream` [key][google.cloud.video.livestream.v1.MuxStream.key]s that should appear in this
	// manifest.
	//
	// - For HLS, either `fmp4` or `ts` mux streams can be specified but not
	// mixed.
	// - For DASH, only `fmp4` mux streams can be specified.
	MuxStreams []string `protobuf:"bytes,3,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// Maximum number of segments that this manifest holds. Once the manifest
	// reaches this maximum number of segments, whenever a new segment is added to
	// the manifest, the oldest segment will be removed from the manifest.
	// The minimum value is 3 and the default value is 5.
	MaxSegmentCount int32 `protobuf:"varint,4,opt,name=max_segment_count,json=maxSegmentCount,proto3" json:"max_segment_count,omitempty"`
	// How long to keep a segment on the output Google Cloud Storage bucket after
	// it is removed from the manifest. This field should be large enough to cover
	// the manifest propagation delay. Otherwise, a player could receive 404
	// errors while accessing segments which are listed in the manifest that the
	// player has, but were already deleted from the output Google Cloud Storage
	// bucket. Default value is `60s`.
	SegmentKeepDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=segment_keep_duration,json=segmentKeepDuration,proto3" json:"segment_keep_duration,omitempty"`
}

func (x *Manifest) Reset() {
	*x = Manifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Manifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Manifest) ProtoMessage() {}

func (x *Manifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Manifest.ProtoReflect.Descriptor instead.
func (*Manifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{2}
}

func (x *Manifest) GetFileName() string {
	if x != nil {
		return x.FileName
	}
	return ""
}

func (x *Manifest) GetType() Manifest_ManifestType {
	if x != nil {
		return x.Type
	}
	return Manifest_MANIFEST_TYPE_UNSPECIFIED
}

func (x *Manifest) GetMuxStreams() []string {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (x *Manifest) GetMaxSegmentCount() int32 {
	if x != nil {
		return x.MaxSegmentCount
	}
	return 0
}

func (x *Manifest) GetSegmentKeepDuration() *durationpb.Duration {
	if x != nil {
		return x.SegmentKeepDuration
	}
	return nil
}

// Sprite sheet configuration.
type SpriteSheet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Format type. The default is `jpeg`.
	//
	// Supported formats:
	//
	// - `jpeg`
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// Required. File name prefix for the generated sprite sheets. If multiple
	// sprite sheets are added to the channel, each must have a unique file
	// prefix.
	// Each sprite sheet has an incremental 10-digit zero-padded suffix starting
	// from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
	FilePrefix string `protobuf:"bytes,2,opt,name=file_prefix,json=filePrefix,proto3" json:"file_prefix,omitempty"`
	// Required. The width of the sprite in pixels. Must be an even integer.
	SpriteWidthPixels int32 `protobuf:"varint,3,opt,name=sprite_width_pixels,json=spriteWidthPixels,proto3" json:"sprite_width_pixels,omitempty"`
	// Required. The height of the sprite in pixels. Must be an even integer.
	SpriteHeightPixels int32 `protobuf:"varint,4,opt,name=sprite_height_pixels,json=spriteHeightPixels,proto3" json:"sprite_height_pixels,omitempty"`
	// The maximum number of sprites per row in a sprite sheet. Valid range is
	// [1, 10] and the default value is 1.
	ColumnCount int32 `protobuf:"varint,5,opt,name=column_count,json=columnCount,proto3" json:"column_count,omitempty"`
	// The maximum number of rows per sprite sheet. When the sprite sheet is full,
	// a new sprite sheet is created. Valid range is [1, 10] and the default value
	// is 1.
	RowCount int32 `protobuf:"varint,6,opt,name=row_count,json=rowCount,proto3" json:"row_count,omitempty"`
	// Create sprites at regular intervals. Valid range is [1 second, 1 hour] and
	// the default value is `10s`.
	Interval *durationpb.Duration `protobuf:"bytes,7,opt,name=interval,proto3" json:"interval,omitempty"`
	// The quality of the generated sprite sheet. Enter a value between 1
	// and 100, where 1 is the lowest quality and 100 is the highest quality.
	// The default is 100. A high quality value corresponds to a low image data
	// compression ratio.
	Quality int32 `protobuf:"varint,8,opt,name=quality,proto3" json:"quality,omitempty"`
}

func (x *SpriteSheet) Reset() {
	*x = SpriteSheet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SpriteSheet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpriteSheet) ProtoMessage() {}

func (x *SpriteSheet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpriteSheet.ProtoReflect.Descriptor instead.
func (*SpriteSheet) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{3}
}

func (x *SpriteSheet) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *SpriteSheet) GetFilePrefix() string {
	if x != nil {
		return x.FilePrefix
	}
	return ""
}

func (x *SpriteSheet) GetSpriteWidthPixels() int32 {
	if x != nil {
		return x.SpriteWidthPixels
	}
	return 0
}

func (x *SpriteSheet) GetSpriteHeightPixels() int32 {
	if x != nil {
		return x.SpriteHeightPixels
	}
	return 0
}

func (x *SpriteSheet) GetColumnCount() int32 {
	if x != nil {
		return x.ColumnCount
	}
	return 0
}

func (x *SpriteSheet) GetRowCount() int32 {
	if x != nil {
		return x.RowCount
	}
	return 0
}

func (x *SpriteSheet) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *SpriteSheet) GetQuality() int32 {
	if x != nil {
		return x.Quality
	}
	return 0
}

// Preprocessing configurations.
type PreprocessingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify the video cropping configuration.
	Crop *PreprocessingConfig_Crop `protobuf:"bytes,2,opt,name=crop,proto3" json:"crop,omitempty"`
	// Specify the video pad filter configuration.
	Pad *PreprocessingConfig_Pad `protobuf:"bytes,3,opt,name=pad,proto3" json:"pad,omitempty"`
}

func (x *PreprocessingConfig) Reset() {
	*x = PreprocessingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig) ProtoMessage() {}

func (x *PreprocessingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{4}
}

func (x *PreprocessingConfig) GetCrop() *PreprocessingConfig_Crop {
	if x != nil {
		return x.Crop
	}
	return nil
}

func (x *PreprocessingConfig) GetPad() *PreprocessingConfig_Pad {
	if x != nil {
		return x.Pad
	}
	return nil
}

// Video stream resource.
type VideoStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Codec settings.
	//
	// Types that are assignable to CodecSettings:
	//	*VideoStream_H264
	CodecSettings isVideoStream_CodecSettings `protobuf_oneof:"codec_settings"`
}

func (x *VideoStream) Reset() {
	*x = VideoStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream) ProtoMessage() {}

func (x *VideoStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream.ProtoReflect.Descriptor instead.
func (*VideoStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{5}
}

func (m *VideoStream) GetCodecSettings() isVideoStream_CodecSettings {
	if m != nil {
		return m.CodecSettings
	}
	return nil
}

func (x *VideoStream) GetH264() *VideoStream_H264CodecSettings {
	if x, ok := x.GetCodecSettings().(*VideoStream_H264); ok {
		return x.H264
	}
	return nil
}

type isVideoStream_CodecSettings interface {
	isVideoStream_CodecSettings()
}

type VideoStream_H264 struct {
	// H264 codec settings.
	H264 *VideoStream_H264CodecSettings `protobuf:"bytes,20,opt,name=h264,proto3,oneof"`
}

func (*VideoStream_H264) isVideoStream_CodecSettings() {}

// Audio stream resource.
type AudioStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies whether pass through (transmuxing) is enabled or not.
	// If set to `true`, the rest of the settings, other than `mapping`, will be
	// ignored. The default is `false`.
	Transmux bool `protobuf:"varint,8,opt,name=transmux,proto3" json:"transmux,omitempty"`
	// The codec for this audio stream. The default is `aac`.
	//
	// Supported audio codecs:
	//
	// - `aac`
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// Required. Audio bitrate in bits per second. Must be between 1 and 10,000,000.
	BitrateBps int32 `protobuf:"varint,2,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Number of audio channels. Must be between 1 and 6. The default is 2.
	ChannelCount int32 `protobuf:"varint,3,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying layout of the audio channels.
	// This only affects the metadata embedded in the container headers, if
	// supported by the specified format. The default is `[fl, fr]`.
	//
	// Supported channel names:
	//
	// - `fl` - Front left channel
	// - `fr` - Front right channel
	// - `sl` - Side left channel
	// - `sr` - Side right channel
	// - `fc` - Front center channel
	// - `lfe` - Low frequency
	ChannelLayout []string `protobuf:"bytes,4,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
	// The mapping for the input streams and audio channels.
	Mapping []*AudioStream_AudioMapping `protobuf:"bytes,5,rep,name=mapping,proto3" json:"mapping,omitempty"`
	// The audio sample rate in Hertz. The default is 48000 Hertz.
	SampleRateHertz int32 `protobuf:"varint,6,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
}

func (x *AudioStream) Reset() {
	*x = AudioStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream) ProtoMessage() {}

func (x *AudioStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream.ProtoReflect.Descriptor instead.
func (*AudioStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{6}
}

func (x *AudioStream) GetTransmux() bool {
	if x != nil {
		return x.Transmux
	}
	return false
}

func (x *AudioStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioStream) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *AudioStream) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioStream) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

func (x *AudioStream) GetMapping() []*AudioStream_AudioMapping {
	if x != nil {
		return x.Mapping
	}
	return nil
}

func (x *AudioStream) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

// Encoding of a text stream. For example, closed captions or subtitles.
type TextStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The codec for this text stream.
	//
	// Supported text codecs:
	//
	// - `cea608`
	// - `cea708`
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
}

func (x *TextStream) Reset() {
	*x = TextStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextStream) ProtoMessage() {}

func (x *TextStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextStream.ProtoReflect.Descriptor instead.
func (*TextStream) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{7}
}

func (x *TextStream) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

// Segment settings for `fmp4` and `ts`.
type SegmentSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of the segments in seconds. The default is `6s`. Note that
	// `segmentDuration` must be greater than or equal to
	// [gop_duration][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.gop_duration], and
	// `segmentDuration` must be divisible by
	// [gop_duration][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.gop_duration].
	// Valid range is [2s, 20s].
	//
	// All [mux_streams][google.cloud.video.livestream.v1.Manifest.mux_streams] in the same manifest must have the
	// same segment duration.
	SegmentDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=segment_duration,json=segmentDuration,proto3" json:"segment_duration,omitempty"`
}

func (x *SegmentSettings) Reset() {
	*x = SegmentSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SegmentSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SegmentSettings) ProtoMessage() {}

func (x *SegmentSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SegmentSettings.ProtoReflect.Descriptor instead.
func (*SegmentSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{8}
}

func (x *SegmentSettings) GetSegmentDuration() *durationpb.Duration {
	if x != nil {
		return x.SegmentDuration
	}
	return nil
}

// Video cropping configuration for the input video. The cropped input video
// is scaled to match the output resolution.
type PreprocessingConfig_Crop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of pixels to crop from the top. The default is 0.
	TopPixels int32 `protobuf:"varint,1,opt,name=top_pixels,json=topPixels,proto3" json:"top_pixels,omitempty"`
	// The number of pixels to crop from the bottom. The default is 0.
	BottomPixels int32 `protobuf:"varint,2,opt,name=bottom_pixels,json=bottomPixels,proto3" json:"bottom_pixels,omitempty"`
	// The number of pixels to crop from the left. The default is 0.
	LeftPixels int32 `protobuf:"varint,3,opt,name=left_pixels,json=leftPixels,proto3" json:"left_pixels,omitempty"`
	// The number of pixels to crop from the right. The default is 0.
	RightPixels int32 `protobuf:"varint,4,opt,name=right_pixels,json=rightPixels,proto3" json:"right_pixels,omitempty"`
}

func (x *PreprocessingConfig_Crop) Reset() {
	*x = PreprocessingConfig_Crop{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Crop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Crop) ProtoMessage() {}

func (x *PreprocessingConfig_Crop) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Crop.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Crop) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PreprocessingConfig_Crop) GetTopPixels() int32 {
	if x != nil {
		return x.TopPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetBottomPixels() int32 {
	if x != nil {
		return x.BottomPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetLeftPixels() int32 {
	if x != nil {
		return x.LeftPixels
	}
	return 0
}

func (x *PreprocessingConfig_Crop) GetRightPixels() int32 {
	if x != nil {
		return x.RightPixels
	}
	return 0
}

// Pad filter configuration for the input video. The padded input video
// is scaled after padding with black to match the output resolution.
type PreprocessingConfig_Pad struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of pixels to add to the top. The default is 0.
	TopPixels int32 `protobuf:"varint,1,opt,name=top_pixels,json=topPixels,proto3" json:"top_pixels,omitempty"`
	// The number of pixels to add to the bottom. The default is 0.
	BottomPixels int32 `protobuf:"varint,2,opt,name=bottom_pixels,json=bottomPixels,proto3" json:"bottom_pixels,omitempty"`
	// The number of pixels to add to the left. The default is 0.
	LeftPixels int32 `protobuf:"varint,3,opt,name=left_pixels,json=leftPixels,proto3" json:"left_pixels,omitempty"`
	// The number of pixels to add to the right. The default is 0.
	RightPixels int32 `protobuf:"varint,4,opt,name=right_pixels,json=rightPixels,proto3" json:"right_pixels,omitempty"`
}

func (x *PreprocessingConfig_Pad) Reset() {
	*x = PreprocessingConfig_Pad{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreprocessingConfig_Pad) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreprocessingConfig_Pad) ProtoMessage() {}

func (x *PreprocessingConfig_Pad) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreprocessingConfig_Pad.ProtoReflect.Descriptor instead.
func (*PreprocessingConfig_Pad) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{4, 1}
}

func (x *PreprocessingConfig_Pad) GetTopPixels() int32 {
	if x != nil {
		return x.TopPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetBottomPixels() int32 {
	if x != nil {
		return x.BottomPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetLeftPixels() int32 {
	if x != nil {
		return x.LeftPixels
	}
	return 0
}

func (x *PreprocessingConfig_Pad) GetRightPixels() int32 {
	if x != nil {
		return x.RightPixels
	}
	return 0
}

// H264 codec settings.
type VideoStream_H264CodecSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The width of the video in pixels. Must be an even integer.
	// Valid range is [320, 1920].
	WidthPixels int32 `protobuf:"varint,1,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// Required. The height of the video in pixels. Must be an even integer.
	// Valid range is [180, 1080].
	HeightPixels int32 `protobuf:"varint,2,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// Required. The target video frame rate in frames per second (FPS). Must be less
	// than or equal to 60. Will default to the input frame rate if larger
	// than the input frame rate. The API will generate an output FPS that is
	// divisible by the input FPS, and smaller or equal to the target FPS. See
	// [Calculating frame
	// rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
	// more information.
	FrameRate float64 `protobuf:"fixed64,3,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
	// Required. The video bitrate in bits per second. Minimum value is 10,000.
	//
	// - For SD resolution (< 720p), must be <= 3,000,000 (3 Mbps).
	// - For HD resolution (<= 1080p), must be <= 15,000,000 (15 Mbps).
	BitrateBps int32 `protobuf:"varint,4,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Specifies whether an open Group of Pictures (GOP) structure should be
	// allowed or not. The default is `false`.
	AllowOpenGop bool `protobuf:"varint,6,opt,name=allow_open_gop,json=allowOpenGop,proto3" json:"allow_open_gop,omitempty"`
	// GOP mode can be either by frame count or duration.
	//
	// Types that are assignable to GopMode:
	//	*VideoStream_H264CodecSettings_GopFrameCount
	//	*VideoStream_H264CodecSettings_GopDuration
	GopMode isVideoStream_H264CodecSettings_GopMode `protobuf_oneof:"gop_mode"`
	// Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
	// greater than zero. The default is equal to [bitrate_bps][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.bitrate_bps].
	VbvSizeBits int32 `protobuf:"varint,9,opt,name=vbv_size_bits,json=vbvSizeBits,proto3" json:"vbv_size_bits,omitempty"`
	// Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
	// Must be greater than zero. The default is equal to 90% of
	// [vbv_size_bits][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.vbv_size_bits].
	VbvFullnessBits int32 `protobuf:"varint,10,opt,name=vbv_fullness_bits,json=vbvFullnessBits,proto3" json:"vbv_fullness_bits,omitempty"`
	// The entropy coder to use. The default is `cabac`.
	//
	// Supported entropy coders:
	//
	// - `cavlc`
	// - `cabac`
	EntropyCoder string `protobuf:"bytes,11,opt,name=entropy_coder,json=entropyCoder,proto3" json:"entropy_coder,omitempty"`
	// Allow B-pyramid for reference frame selection. This may not be supported
	// on all decoders. The default is `false`.
	BPyramid bool `protobuf:"varint,12,opt,name=b_pyramid,json=bPyramid,proto3" json:"b_pyramid,omitempty"`
	// The number of consecutive B-frames. Must be greater than or equal to
	// zero. Must be less than [gop_frame_count][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.gop_frame_count] if set. The default
	// is 0.
	BFrameCount int32 `protobuf:"varint,13,opt,name=b_frame_count,json=bFrameCount,proto3" json:"b_frame_count,omitempty"`
	// Specify the intensity of the adaptive quantizer (AQ). Must be between 0
	// and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
	// higher value equals a lower bitrate but smoother image. The default is 0.
	AqStrength float64 `protobuf:"fixed64,14,opt,name=aq_strength,json=aqStrength,proto3" json:"aq_strength,omitempty"`
	// Enforces the specified codec profile. The following profiles are
	// supported:
	//
	// *   `baseline`
	// *   `main` (default)
	// *   `high`
	//
	// The available options are [FFmpeg-compatible Profile
	// Options](https://trac.ffmpeg.org/wiki/Encode/H.264#Profile).
	// Note that certain values for this field may cause the
	// transcoder to override other fields you set in the [H264CodecSettings][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings]
	// message.
	Profile string `protobuf:"bytes,15,opt,name=profile,proto3" json:"profile,omitempty"`
	// Enforces the specified codec tune. The available options are
	// [FFmpeg-compatible Encode
	// Options](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune)
	// Note that certain values for this field may cause the transcoder to
	// override other fields you set in the [H264CodecSettings][google.cloud.video.livestream.v1.VideoStream.H264CodecSettings] message.
	Tune string `protobuf:"bytes,16,opt,name=tune,proto3" json:"tune,omitempty"`
}

func (x *VideoStream_H264CodecSettings) Reset() {
	*x = VideoStream_H264CodecSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStream_H264CodecSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStream_H264CodecSettings) ProtoMessage() {}

func (x *VideoStream_H264CodecSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStream_H264CodecSettings.ProtoReflect.Descriptor instead.
func (*VideoStream_H264CodecSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{5, 0}
}

func (x *VideoStream_H264CodecSettings) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetAllowOpenGop() bool {
	if x != nil {
		return x.AllowOpenGop
	}
	return false
}

func (m *VideoStream_H264CodecSettings) GetGopMode() isVideoStream_H264CodecSettings_GopMode {
	if m != nil {
		return m.GopMode
	}
	return nil
}

func (x *VideoStream_H264CodecSettings) GetGopFrameCount() int32 {
	if x, ok := x.GetGopMode().(*VideoStream_H264CodecSettings_GopFrameCount); ok {
		return x.GopFrameCount
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetGopDuration() *durationpb.Duration {
	if x, ok := x.GetGopMode().(*VideoStream_H264CodecSettings_GopDuration); ok {
		return x.GopDuration
	}
	return nil
}

func (x *VideoStream_H264CodecSettings) GetVbvSizeBits() int32 {
	if x != nil {
		return x.VbvSizeBits
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetVbvFullnessBits() int32 {
	if x != nil {
		return x.VbvFullnessBits
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetEntropyCoder() string {
	if x != nil {
		return x.EntropyCoder
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetBPyramid() bool {
	if x != nil {
		return x.BPyramid
	}
	return false
}

func (x *VideoStream_H264CodecSettings) GetBFrameCount() int32 {
	if x != nil {
		return x.BFrameCount
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetAqStrength() float64 {
	if x != nil {
		return x.AqStrength
	}
	return 0
}

func (x *VideoStream_H264CodecSettings) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *VideoStream_H264CodecSettings) GetTune() string {
	if x != nil {
		return x.Tune
	}
	return ""
}

type isVideoStream_H264CodecSettings_GopMode interface {
	isVideoStream_H264CodecSettings_GopMode()
}

type VideoStream_H264CodecSettings_GopFrameCount struct {
	// Select the GOP size based on the specified frame count.
	// If GOP frame count is set instead of GOP duration, GOP duration will be
	// calculated by `gopFrameCount`/`frameRate`. The calculated GOP duration
	// must satisfy the limitations on `gopDuration` as well.
	// Valid range is [60, 600].
	GopFrameCount int32 `protobuf:"varint,7,opt,name=gop_frame_count,json=gopFrameCount,proto3,oneof"`
}

type VideoStream_H264CodecSettings_GopDuration struct {
	// Select the GOP size based on the specified duration. The default is
	// `2s`. Note that `gopDuration` must be less than or equal to
	// [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration], and
	// [segment_duration][google.cloud.video.livestream.v1.SegmentSettings.segment_duration] must be divisible
	// by `gopDuration`. Valid range is [2s, 20s].
	//
	// All video streams in the same channel must have the same GOP size.
	GopDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=gop_duration,json=gopDuration,proto3,oneof"`
}

func (*VideoStream_H264CodecSettings_GopFrameCount) isVideoStream_H264CodecSettings_GopMode() {}

func (*VideoStream_H264CodecSettings_GopDuration) isVideoStream_H264CodecSettings_GopMode() {}

// The mapping for the input streams and audio channels.
type AudioStream_AudioMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The `Channel` [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key] that identifies the input that this
	// audio mapping applies to. If an active input doesn't have an audio
	// mapping, the primary audio track in the input stream will be selected.
	InputKey string `protobuf:"bytes,6,opt,name=input_key,json=inputKey,proto3" json:"input_key,omitempty"`
	// Required. The zero-based index of the track in the input stream.
	// All [mapping][google.cloud.video.livestream.v1.AudioStream.mapping]s in the same [AudioStream][google.cloud.video.livestream.v1.AudioStream]
	// must have the same input track.
	InputTrack int32 `protobuf:"varint,2,opt,name=input_track,json=inputTrack,proto3" json:"input_track,omitempty"`
	// Required. The zero-based index of the channel in the input stream.
	InputChannel int32 `protobuf:"varint,3,opt,name=input_channel,json=inputChannel,proto3" json:"input_channel,omitempty"`
	// Required. The zero-based index of the channel in the output audio stream.
	// Must be consistent with the [input_channel][google.cloud.video.livestream.v1.AudioStream.AudioMapping.input_channel].
	OutputChannel int32 `protobuf:"varint,4,opt,name=output_channel,json=outputChannel,proto3" json:"output_channel,omitempty"`
}

func (x *AudioStream_AudioMapping) Reset() {
	*x = AudioStream_AudioMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStream_AudioMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStream_AudioMapping) ProtoMessage() {}

func (x *AudioStream_AudioMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStream_AudioMapping.ProtoReflect.Descriptor instead.
func (*AudioStream_AudioMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP(), []int{6, 0}
}

func (x *AudioStream_AudioMapping) GetInputKey() string {
	if x != nil {
		return x.InputKey
	}
	return ""
}

func (x *AudioStream_AudioMapping) GetInputTrack() int32 {
	if x != nil {
		return x.InputTrack
	}
	return 0
}

func (x *AudioStream_AudioMapping) GetInputChannel() int32 {
	if x != nil {
		return x.InputChannel
	}
	return 0
}

func (x *AudioStream_AudioMapping) GetOutputChannel() int32 {
	if x != nil {
		return x.OutputChannel
	}
	return 0
}

var File_google_cloud_video_livestream_v1_outputs_proto protoreflect.FileDescriptor

var file_google_cloud_video_livestream_v1_outputs_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xb2, 0x02, 0x0a, 0x10, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x52, 0x0a, 0x0c, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48,
	0x00, 0x52, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x52,
	0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x12, 0x4f, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x42, 0x13, 0x0a, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x79, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x22, 0xc8, 0x01, 0x0a, 0x09, 0x4d, 0x75, 0x78,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x5c, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x0f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x22, 0xdc, 0x02, 0x0a, 0x08, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x50, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x6d, 0x75, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0f, 0x6d, 0x61, 0x78, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x4d, 0x0a, 0x15, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x65,
	0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x65, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x40, 0x0a, 0x0c, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x41, 0x4e, 0x49, 0x46, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x48, 0x4c, 0x53, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x41, 0x53, 0x48,
	0x10, 0x02, 0x22, 0xc8, 0x02, 0x0a, 0x0b, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x33, 0x0a, 0x13, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x11, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x57, 0x69, 0x64, 0x74, 0x68, 0x50,
	0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65,
	0x48, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x08,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xd3, 0x03,
	0x0a, 0x13, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x04, 0x63, 0x72, 0x6f, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x72, 0x6f, 0x70, 0x52,
	0x04, 0x63, 0x72, 0x6f, 0x70, 0x12, 0x4b, 0x0a, 0x03, 0x70, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x64, 0x52, 0x03, 0x70,
	0x61, 0x64, 0x1a, 0x8e, 0x01, 0x0a, 0x04, 0x43, 0x72, 0x6f, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x70, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x70, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x6f,
	0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6c, 0x65, 0x66, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x1a, 0x8d, 0x01, 0x0a, 0x03, 0x50, 0x61, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x70, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x74, 0x6f, 0x70, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x6f,
	0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6c, 0x65, 0x66, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x22, 0xbf, 0x05, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x12, 0x55, 0x0a, 0x04, 0x68, 0x32, 0x36, 0x34, 0x18, 0x14, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x48, 0x32, 0x36, 0x34, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x48, 0x00, 0x52, 0x04, 0x68, 0x32, 0x36, 0x34, 0x1a, 0xc6, 0x04, 0x0a, 0x11, 0x48,
	0x32, 0x36, 0x34, 0x43, 0x6f, 0x64, 0x65, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d,
	0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x0b,
	0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x42,
	0x70, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x6e,
	0x5f, 0x67, 0x6f, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x4f, 0x70, 0x65, 0x6e, 0x47, 0x6f, 0x70, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x6f, 0x70, 0x5f,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x70, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x0c, 0x67, 0x6f, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0b, 0x67, 0x6f, 0x70, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x76, 0x62, 0x76, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62,
	0x69, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x76, 0x62, 0x76, 0x53, 0x69,
	0x7a, 0x65, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x76, 0x62, 0x76, 0x5f, 0x66, 0x75,
	0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0f, 0x76, 0x62, 0x76, 0x46, 0x75, 0x6c, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x69,
	0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x6f,
	0x70, 0x79, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x5f, 0x70, 0x79, 0x72,
	0x61, 0x6d, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x62, 0x50, 0x79, 0x72,
	0x61, 0x6d, 0x69, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x62, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x71, 0x5f, 0x73,
	0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x61,
	0x71, 0x53, 0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x75, 0x6e, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x67, 0x6f, 0x70, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xe2, 0x03, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x75,
	0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x75,
	0x78, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x24, 0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6c, 0x61,
	0x79, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x54, 0x0a, 0x07, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12,
	0x2a, 0x0a, 0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68,
	0x65, 0x72, 0x74, 0x7a, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x1a, 0xac, 0x01, 0x0a, 0x0c,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x20, 0x0a, 0x09,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x24,
	0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x2a,
	0x0a, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0x27, 0x0a, 0x0a, 0x54, 0x65,
	0x78, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x63, 0x6f,
	0x64, 0x65, 0x63, 0x22, 0x57, 0x0a, 0x0f, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xef, 0x01, 0x0a,
	0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x5c, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x3a, 0x3a,
	0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_livestream_v1_outputs_proto_rawDescOnce sync.Once
	file_google_cloud_video_livestream_v1_outputs_proto_rawDescData = file_google_cloud_video_livestream_v1_outputs_proto_rawDesc
)

func file_google_cloud_video_livestream_v1_outputs_proto_rawDescGZIP() []byte {
	file_google_cloud_video_livestream_v1_outputs_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_livestream_v1_outputs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_livestream_v1_outputs_proto_rawDescData)
	})
	return file_google_cloud_video_livestream_v1_outputs_proto_rawDescData
}

var file_google_cloud_video_livestream_v1_outputs_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_video_livestream_v1_outputs_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_video_livestream_v1_outputs_proto_goTypes = []interface{}{
	(Manifest_ManifestType)(0),            // 0: google.cloud.video.livestream.v1.Manifest.ManifestType
	(*ElementaryStream)(nil),              // 1: google.cloud.video.livestream.v1.ElementaryStream
	(*MuxStream)(nil),                     // 2: google.cloud.video.livestream.v1.MuxStream
	(*Manifest)(nil),                      // 3: google.cloud.video.livestream.v1.Manifest
	(*SpriteSheet)(nil),                   // 4: google.cloud.video.livestream.v1.SpriteSheet
	(*PreprocessingConfig)(nil),           // 5: google.cloud.video.livestream.v1.PreprocessingConfig
	(*VideoStream)(nil),                   // 6: google.cloud.video.livestream.v1.VideoStream
	(*AudioStream)(nil),                   // 7: google.cloud.video.livestream.v1.AudioStream
	(*TextStream)(nil),                    // 8: google.cloud.video.livestream.v1.TextStream
	(*SegmentSettings)(nil),               // 9: google.cloud.video.livestream.v1.SegmentSettings
	(*PreprocessingConfig_Crop)(nil),      // 10: google.cloud.video.livestream.v1.PreprocessingConfig.Crop
	(*PreprocessingConfig_Pad)(nil),       // 11: google.cloud.video.livestream.v1.PreprocessingConfig.Pad
	(*VideoStream_H264CodecSettings)(nil), // 12: google.cloud.video.livestream.v1.VideoStream.H264CodecSettings
	(*AudioStream_AudioMapping)(nil),      // 13: google.cloud.video.livestream.v1.AudioStream.AudioMapping
	(*durationpb.Duration)(nil),           // 14: google.protobuf.Duration
}
var file_google_cloud_video_livestream_v1_outputs_proto_depIdxs = []int32{
	6,  // 0: google.cloud.video.livestream.v1.ElementaryStream.video_stream:type_name -> google.cloud.video.livestream.v1.VideoStream
	7,  // 1: google.cloud.video.livestream.v1.ElementaryStream.audio_stream:type_name -> google.cloud.video.livestream.v1.AudioStream
	8,  // 2: google.cloud.video.livestream.v1.ElementaryStream.text_stream:type_name -> google.cloud.video.livestream.v1.TextStream
	9,  // 3: google.cloud.video.livestream.v1.MuxStream.segment_settings:type_name -> google.cloud.video.livestream.v1.SegmentSettings
	0,  // 4: google.cloud.video.livestream.v1.Manifest.type:type_name -> google.cloud.video.livestream.v1.Manifest.ManifestType
	14, // 5: google.cloud.video.livestream.v1.Manifest.segment_keep_duration:type_name -> google.protobuf.Duration
	14, // 6: google.cloud.video.livestream.v1.SpriteSheet.interval:type_name -> google.protobuf.Duration
	10, // 7: google.cloud.video.livestream.v1.PreprocessingConfig.crop:type_name -> google.cloud.video.livestream.v1.PreprocessingConfig.Crop
	11, // 8: google.cloud.video.livestream.v1.PreprocessingConfig.pad:type_name -> google.cloud.video.livestream.v1.PreprocessingConfig.Pad
	12, // 9: google.cloud.video.livestream.v1.VideoStream.h264:type_name -> google.cloud.video.livestream.v1.VideoStream.H264CodecSettings
	13, // 10: google.cloud.video.livestream.v1.AudioStream.mapping:type_name -> google.cloud.video.livestream.v1.AudioStream.AudioMapping
	14, // 11: google.cloud.video.livestream.v1.SegmentSettings.segment_duration:type_name -> google.protobuf.Duration
	14, // 12: google.cloud.video.livestream.v1.VideoStream.H264CodecSettings.gop_duration:type_name -> google.protobuf.Duration
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_video_livestream_v1_outputs_proto_init() }
func file_google_cloud_video_livestream_v1_outputs_proto_init() {
	if File_google_cloud_video_livestream_v1_outputs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ElementaryStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MuxStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Manifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SpriteSheet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SegmentSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Crop); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreprocessingConfig_Pad); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStream_H264CodecSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStream_AudioMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ElementaryStream_VideoStream)(nil),
		(*ElementaryStream_AudioStream)(nil),
		(*ElementaryStream_TextStream)(nil),
	}
	file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*VideoStream_H264)(nil),
	}
	file_google_cloud_video_livestream_v1_outputs_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*VideoStream_H264CodecSettings_GopFrameCount)(nil),
		(*VideoStream_H264CodecSettings_GopDuration)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_livestream_v1_outputs_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_livestream_v1_outputs_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_livestream_v1_outputs_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_livestream_v1_outputs_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_livestream_v1_outputs_proto_msgTypes,
	}.Build()
	File_google_cloud_video_livestream_v1_outputs_proto = out.File
	file_google_cloud_video_livestream_v1_outputs_proto_rawDesc = nil
	file_google_cloud_video_livestream_v1_outputs_proto_goTypes = nil
	file_google_cloud_video_livestream_v1_outputs_proto_depIdxs = nil
}
