/* amd64-linux.elf-so_fold.h
   created from amd64-linux.elf-so_fold.bin, 17621 (0x44d5) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2023 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2023 Laszlo Molnar
   Copyright (C) 2000-2023 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_LINUX_ELF_SO_FOLD_SIZE    17621
#define STUB_AMD64_LINUX_ELF_SO_FOLD_ADLER32 0xe13d329b
#define STUB_AMD64_LINUX_ELF_SO_FOLD_CRC32   0xc9f23c06

unsigned char stub_amd64_linux_elf_so_fold[17621] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 40, 33,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 23,  0, 20,  0,
/* 0x0040 */  72,131,236,  8, 72, 99,255,184,  0,  0,  0,  0,232,  0,  0,  0,
/* 0x0050 */   0,191,127,  0,  0,  0,232,  0,  0,  0,  0, 72,131,236,  8, 76,
/* 0x0060 */ 139, 71,  8, 72, 57, 23,115, 10,191,127,  0,  0,  0,232,  0,  0,
/* 0x0070 */   0,  0, 72,141, 74,255, 72,131,249,255,116, 21, 65, 15,182,  0,
/* 0x0080 */ 136,  6, 73,255,192, 72,255,198, 72,255,201, 72,131,249,255,117,
/* 0x0090 */ 235, 72,  1, 87,  8, 72, 41, 23, 72,131,196,  8,195, 85, 83, 72,
/* 0x00a0 */ 131,236, 40, 72,137,253, 72,137,243, 72,131, 62,  0, 15,132,235,
/* 0x00b0 */   0,  0,  0,186, 12,  0,  0,  0, 72,141,116, 36, 16, 72,137,239,
/* 0x00c0 */ 232,150,255,255,255,131,124, 36, 16,  0,117, 46,129,124, 36, 20,
/* 0x00d0 */  85, 80, 88, 33,116, 10,191,  2,  0,  0,  0,232, 96,255,255,255,
/* 0x00e0 */  72,131,125,  0,  0, 15,132,179,  0,  0,  0,191,  3,  0,  0,  0,
/* 0x00f0 */ 232, 75,255,255,255,233,164,  0,  0,  0,131,124, 36, 20,  0,144,
/* 0x0100 */ 117, 10,191,  4,  0,  0,  0,232, 52,255,255,255,139, 68, 36, 20,
/* 0x0110 */  59, 68, 36, 16,119,  9,139, 68, 36, 16, 72, 59,  3,118, 10,191,
/* 0x0120 */   5,  0,  0,  0,232, 23,255,255,255,139, 68, 36, 20, 59, 68, 36,
/* 0x0130 */  16,115, 70,139, 68, 36, 16, 72,137, 68, 36,  8, 72,139,115,  8,
/* 0x0140 */  72,139,125,  8, 72,131,239, 12, 72,141, 84, 36,  8,232,  0,  0,
/* 0x0150 */   0,  0,133,192,117, 11,139, 68, 36, 16, 72, 59, 68, 36,  8,116,
/* 0x0160 */  10,191,  7,  0,  0,  0,232,213,254,255,255,139, 68, 36, 20, 72,
/* 0x0170 */   1, 69,  8, 72, 41, 69,  0,235, 16,139, 84, 36, 20, 72,139,115,
/* 0x0180 */   8, 72,137,239,232,210,254,255,255,139, 68, 36, 16, 72,  1, 67,
/* 0x0190 */   8, 72, 41,  3, 72,131, 59,  0, 15,133, 21,255,255,255, 72,131,
/* 0x01a0 */ 196, 40, 91, 93,195, 72,137, 92, 36,240, 72,137,108, 36,248, 72,
/* 0x01b0 */ 131,236, 24,137,209,189,  0,  0,  0,  0, 72,184,255,255,255,255,
/* 0x01c0 */   1,  0,  0,  0, 72, 35,  7, 72,186,  1,  0,  0,  0,  1,  0,  0,
/* 0x01d0 */   0, 72, 57,208, 15,133,143,  0,  0,  0, 72,139, 71, 40, 72, 43,
/* 0x01e0 */  71, 32, 72,  1,198,137,240,247,216, 33,193,131,249,  5,118, 18,
/* 0x01f0 */  72,137,245, 72,199,  6, 15,  5, 95, 94,102,199, 70,  4, 90,195,
/* 0x0200 */ 235,103,232,  4,  0,  0,  0,117,112,120,  0, 95,190,  0,  0,  0,
/* 0x0210 */   0,232,  0,  0,  0,  0,137,195,190,  6,  0,  0,  0,137,199,232,
/* 0x0220 */   0,  0,  0,  0,232,  7,  0,  0,  0, 15,  5, 95, 94, 90,195,  0,
/* 0x0230 */  94,186,  6,  0,  0,  0,137,223,232,  0,  0,  0,  0, 65,185,  0,
/* 0x0240 */   0,  0,  0, 65,137,216,185,  1,  0,  0,  0,186,  5,  0,  0,  0,
/* 0x0250 */ 190,  6,  0,  0,  0,191,  0,  0,  0,  0,232,  0,  0,  0,  0, 72,
/* 0x0260 */ 137,197,137,223,232,  0,  0,  0,  0, 72,137,232, 72,139, 92, 36,
/* 0x0270 */   8, 72,139,108, 36, 16, 72,131,196, 24,195, 72,137, 92, 36,224,
/* 0x0280 */  72,137,108, 36,232, 76,137,100, 36,240, 76,137,108, 36,248, 72,
/* 0x0290 */ 129,236,168,  2,  0,  0, 73,199,197,  0,240,255,255,232, 16,  0,
/* 0x02a0 */   0,  0, 47,112,114,111, 99, 47,115,101,108,102, 47, 97,117,120,
/* 0x02b0 */ 118,  0, 94,185,  0,  0,  0,  0,186,  0,  0,  0,  0,191,  0,  0,
/* 0x02c0 */   0,  0,232,  0,  0,  0,  0,137,197,133,192,120, 67, 73,137,228,
/* 0x02d0 */ 186,128,  2,  0,  0, 72,137,230,137,199,232,  0,  0,  0,  0, 72,
/* 0x02e0 */ 131,224,240, 73,  1,196,137,239,232,  0,  0,  0,  0, 72,137,224,
/* 0x02f0 */  76, 57,228,115, 27, 72,131, 56,  6,117, 12, 72,139, 64,  8, 73,
/* 0x0300 */ 137,197, 73,247,221,235,  9, 72,131,192, 16, 76, 57,224,114,229,
/* 0x0310 */  76,137,232, 72,139,156, 36,136,  2,  0,  0, 72,139,172, 36,144,
/* 0x0320 */   2,  0,  0, 76,139,164, 36,152,  2,  0,  0, 76,139,172, 36,160,
/* 0x0330 */   2,  0,  0, 72,129,196,168,  2,  0,  0,195, 72,137, 92, 36,224,
/* 0x0340 */  76,137,100, 36,232, 76,137,108, 36,240, 76,137,116, 36,248, 72,
/* 0x0350 */ 129,236, 40, 16,  0,  0, 65,137,253, 73,137,244,137,211, 72,137,
/* 0x0360 */ 218, 72,137,231,232,  0,  0,  0,  0, 68,137,238, 65,185,  0,  0,
/* 0x0370 */   0,  0, 65,184,255,255,255,255,185, 50,  0,  0,  0,186,  3,  0,
/* 0x0380 */   0,  0, 76,137,231,232,  0,  0,  0,  0, 72,137,218, 72,137,230,
/* 0x0390 */  76,137,231,232,  0,  0,  0,  0, 72,139,156, 36,  8, 16,  0,  0,
/* 0x03a0 */  76,139,164, 36, 16, 16,  0,  0, 76,139,172, 36, 24, 16,  0,  0,
/* 0x03b0 */  76,139,180, 36, 32, 16,  0,  0, 72,129,196, 40, 16,  0,  0,195,
/* 0x03c0 */ 232,  9,  0,  0,  0, 64,  4,  2,  6,  1,  5,  3,  7,  0, 90,139,
/* 0x03d0 */  71,  4,131,224,  7, 15,190,  4,  2,131,224,  7,195, 65, 87, 65,
/* 0x03e0 */  86, 65, 85, 65, 84, 85, 83, 72,129,236,152,  0,  0,  0, 72,137,
/* 0x03f0 */ 251, 72,137,116, 36, 72, 73,137,214,232,125,254,255,255, 72,137,
/* 0x0400 */  68, 36, 64,139,  3, 72,137,218, 72, 41,194, 72,137, 84, 36, 56,
/* 0x0410 */  72,139,  3, 72,137,132, 36,128,  0,  0,  0, 72,139, 67,  8, 72,
/* 0x0420 */ 137,132, 36,136,  0,  0,  0, 68,139, 99, 12, 73,  1,212,137,216,
/* 0x0430 */  68, 41,224,137, 68, 36, 52,139, 91,  4, 72,137, 92, 36, 40, 72,
/* 0x0440 */   1, 84, 36, 40,137,195, 65,185,  0,  0,  0,  0, 65,184,255,255,
/* 0x0450 */ 255,255,185, 34,  0,  0,  0,186,  3,  0,  0,  0, 72,137,222,191,
/* 0x0460 */   0,  0,  0,  0,232,  0,  0,  0,  0, 72,137, 68, 36, 32, 72,137,
/* 0x0470 */ 218, 76,137,230, 72,137,199,232,  0,  0,  0,  0, 76,139,108, 36,
/* 0x0480 */  32, 73,131,197, 24, 72,139, 84, 36, 32,139, 66, 24, 72,137, 68,
/* 0x0490 */  36, 96, 76,137,116, 36,104, 72,137, 68, 36,112, 76,137,116, 36,
/* 0x04a0 */ 120, 65,139, 69,  4, 72,131,192, 12, 72,137, 68, 36, 80, 76,137,
/* 0x04b0 */ 108, 36, 88, 72,137, 68, 36, 96, 76,137,108, 36,104, 72,141,116,
/* 0x04c0 */  36,112, 72,141,124, 36, 96,232,209,251,255,255, 73,141,110, 64,
/* 0x04d0 */  77, 15,183,126, 56, 74,141,  4,253,  0,  0,  0,  0, 76, 41,248,
/* 0x04e0 */  76,141,124,197,  0, 65,131,126, 64,  1,116, 10, 72,131,197, 56,
/* 0x04f0 */ 131,125,  0,  1,117,246, 72,139, 68, 36, 56, 72, 43, 69, 16, 72,
/* 0x0500 */ 137, 68, 36, 24,246, 69,  4,  1, 15,132,140,  0,  0,  0,232,  4,
/* 0x0510 */   0,  0,  0,117,112,120,  0, 95,190,  0,  0,  0,  0,232,  0,  0,
/* 0x0520 */   0,  0,137,195,139, 84, 36, 64,247,218,137, 84, 36, 20, 65,137,
/* 0x0530 */ 212, 76,137,230,137,199,232,  0,  0,  0,  0, 65,139, 85,  0, 76,
/* 0x0540 */ 137,246,137,223,232,  0,  0,  0,  0,139, 84, 36, 20, 65, 43, 85,
/* 0x0550 */   0, 65,139,117,  0, 72,  3,116, 36, 56,137,223,232,  0,  0,  0,
/* 0x0560 */   0, 76,137,230, 72,139,124, 36, 56,232,  0,  0,  0,  0, 72,137,
/* 0x0570 */ 239,232,  0,  0,  0,  0, 65,185,  0,  0,  0,  0, 65,137,216,185,
/* 0x0580 */  17,  0,  0,  0,137,194, 76,137,230, 72,139,124, 36, 56,232,  0,
/* 0x0590 */   0,  0,  0,137,223,232,  0,  0,  0,  0, 72,199, 68, 36,  8,  0,
/* 0x05a0 */   0,  0,  0, 76, 57,253, 15,131,251,  1,  0,  0,131,125,  0,  1,
/* 0x05b0 */  15,133,228,  1,  0,  0,246, 69,  4,  2, 15,133,218,  1,  0,  0,
/* 0x05c0 */  72,139, 85,  8, 72,139, 69, 32, 72,  1,208,139,180, 36,136,  0,
/* 0x05d0 */   0,  0, 72, 57,240, 15,134,191,  1,  0,  0, 72,137,240, 72, 41,
/* 0x05e0 */ 208, 72,137,194, 72, 59,117,  8,184,  0,  0,  0,  0, 73,137,197,
/* 0x05f0 */  76, 15, 67,234, 72,199, 68, 36, 96, 12,  0,  0,  0,186, 12,  0,
/* 0x0600 */   0,  0, 72,141,116, 36, 80, 72,141,124, 36, 96,232, 74,250,255,
/* 0x0610 */ 255, 72,131,108, 36,104, 12, 72,139, 85, 16, 73,141, 76, 21,  0,
/* 0x0620 */  72,  3, 76, 36, 24, 72,139,117, 40, 76, 41,238, 68,  1,234,139,
/* 0x0630 */  68, 36, 64,247,208, 65,137,212, 65, 33,196, 68,137,227, 72, 41,
/* 0x0640 */ 217, 72,137, 76, 36,120, 72,141, 52, 51, 72,137,116, 36,112, 65,
/* 0x0650 */ 190,  0,  0,  0,  0, 72,199,  4, 36,  0,  0,  0,  0,246, 69,  4,
/* 0x0660 */   1,116,106,232,  4,  0,  0,  0,117,112,120,  0, 95,190,  0,  0,
/* 0x0670 */   0,  0,232,  0,  0,  0,  0, 65,137,198, 72,139,116, 36,112,137,
/* 0x0680 */ 199,232,  0,  0,  0,  0, 72,139,116, 36,120, 72,137,218, 68,137,
/* 0x0690 */ 247,232,  0,  0,  0,  0, 72,139,116, 36,112, 72,139,124, 36,120,
/* 0x06a0 */ 232,  0,  0,  0,  0, 72,139,116, 36,112, 72,139,124, 36,120, 65,
/* 0x06b0 */ 185,  0,  0,  0,  0, 69,137,240,185, 17,  0,  0,  0,186,  3,  0,
/* 0x06c0 */   0,  0,232,  0,  0,  0,  0, 72,137,  4, 36,235, 17, 72,139,116,
/* 0x06d0 */  36,120, 68,137,226,139,124, 36,112,232, 93,252,255,255, 68,137,
/* 0x06e0 */ 224, 72,  1, 68, 36,120,139, 84, 36, 80, 72,137, 84, 36,112,139,
/* 0x06f0 */  68, 36, 84, 72,131,192, 12, 72,137, 68, 36, 96, 72,141,116, 36,
/* 0x0700 */ 112, 72,141,124, 36, 96,232,146,249,255,255, 72,131,124, 36,  8,
/* 0x0710 */   0,117, 30,246, 69,  4,  1,116, 24, 72,139,116, 36,120,139, 84,
/* 0x0720 */  36, 64,247,210, 72,137,239,232,121,250,255,255, 72,137, 68, 36,
/* 0x0730 */   8,246, 69,  4,  1,116, 71, 68,137,230,  3,116, 36, 80, 72,139,
/* 0x0740 */  60, 36,232,  0,  0,  0,  0, 72,137,239,232,  0,  0,  0,  0,139,
/* 0x0750 */ 116, 36, 80, 72,139,124, 36, 24, 72,  3,125, 16, 76,  1,239, 65,
/* 0x0760 */ 185,  0,  0,  0,  0, 69,137,240,185, 17,  0,  0,  0,137,194,232,
/* 0x0770 */   0,  0,  0,  0, 68,137,247,232,  0,  0,  0,  0,235, 28, 72,137,
/* 0x0780 */ 239,232,  0,  0,  0,  0, 72,139,117, 40, 72,139,124, 36, 24, 72,
/* 0x0790 */   3,125, 16,137,194,232,  0,  0,  0,  0, 72,131,197, 56, 76, 57,
/* 0x07a0 */ 253, 15,130,  5,254,255,255,139,116, 36, 52, 72,139,124, 36, 32,
/* 0x07b0 */ 232,  0,  0,  0,  0, 72,139, 68, 36, 72, 72,139, 80, 16, 72,139,
/* 0x07c0 */ 112,  8, 72,139, 56,255, 84, 36, 40, 72,139, 68, 36,  8, 72,129,
/* 0x07d0 */ 196,152,  0,  0,  0, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95,195,
/* 0x07e0 */  85, 72,137,229, 83, 82, 86, 87,232,101,  0,  0,  0, 91, 95, 94,
/* 0x07f0 */  80, 15,182, 75,  9,133,201,116, 11, 15,182, 83, 10,139, 54,232,
/* 0x0800 */   4,  0,  0,  0, 88, 91, 93,195,131,249, 73,117, 68, 83, 87, 72,
/* 0x0810 */ 141, 76, 55,253, 94, 86, 91,235, 47, 72, 57,206,115, 50, 86, 94,
/* 0x0820 */ 172, 60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,
/* 0x0830 */ 232, 60,  1,119,228, 72, 57,206,115, 22, 86,173, 40,208,117,223,
/* 0x0840 */  95, 15,200, 41,248,  1,216,171, 72, 57,206,115,  3,172,235,223,
/* 0x0850 */  91,195, 82, 15,182, 87,  8, 87, 86, 95, 94,139, 70,  4, 72,131,
/* 0x0860 */ 198, 12, 72,  1,240, 80, 87, 49,219, 49,201, 72,131,205,255,235,
/* 0x0870 */  78,139, 30, 72,131,238,252, 17,219,138, 22,243,195,  1,219,116,
/* 0x0880 */ 240,243,195, 72,141,  4, 47,131,249,  5,138, 16,118, 32,131,253,
/* 0x0890 */ 252,119, 27,131,233,  4,139, 16, 72,131,192,  4,131,233,  4,137,
/* 0x08a0 */  23, 72,141,127,  4,115,239,131,193,  4,138, 16,116, 15, 72,255,
/* 0x08b0 */ 192,136, 23,255,201,138, 16, 72,141,127,  1,117,241,243,195,252,
/* 0x08c0 */ 128,250,  8, 15,133,218,  0,  0,  0,235,  8, 72,255,198,136, 23,
/* 0x08d0 */  72,255,199,138, 22,  1,219,117, 10,139, 30, 72,131,238,252, 17,
/* 0x08e0 */ 219,138, 22,114,230,141, 65,  1,235, 18,255,200,  1,219,117, 10,
/* 0x08f0 */ 139, 30, 72,131,238,252, 17,219,138, 22, 17,192,  1,219,117, 10,
/* 0x0900 */ 139, 30, 72,131,238,252, 17,219,138, 22, 17,192,  1,219,117, 10,
/* 0x0910 */ 139, 30, 72,131,238,252, 17,219,138, 22,115,206,131,232,  3,114,
/* 0x0920 */  29,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,255, 15,
/* 0x0930 */ 132,  0,  0,  0,  0,209,248, 72, 99,232,114, 67,235, 14,  1,219,
/* 0x0940 */ 117,  8,139, 30, 72,131,238,252, 17,219,114, 51,255,193,  1,219,
/* 0x0950 */ 117,  8,139, 30, 72,131,238,252, 17,219,114, 35,  1,219,117, 10,
/* 0x0960 */ 139, 30, 72,131,238,252, 17,219,138, 22, 17,201,  1,219,117,  8,
/* 0x0970 */ 139, 30, 72,131,238,252, 17,219,115,226,131,193,  2,235, 16,  1,
/* 0x0980 */ 219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,201, 72,
/* 0x0990 */ 129,253,  0,251,255,255,131,209,  2,232,  0,  0,  0,  0,233, 48,
/* 0x09a0 */ 255,255,255, 87, 94,128,250,  5, 15,133,204,  0,  0,  0,235,  8,
/* 0x09b0 */  72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30,
/* 0x09c0 */  72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,235, 18,255,
/* 0x09d0 */ 200,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,
/* 0x09e0 */ 192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,
/* 0x09f0 */ 192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,
/* 0x0a00 */ 206,131,232,  3,114, 27,193,224,  8, 15,182,210,  9,208, 72,255,
/* 0x0a10 */ 198,131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,235,
/* 0x0a20 */  14,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,
/* 0x0a30 */ 201,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22, 17,
/* 0x0a40 */ 201,117, 35,255,193,  1,219,117, 10,139, 30, 72,131,238,252, 17,
/* 0x0a50 */ 219,138, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,
/* 0x0a60 */ 219,115,226,131,193,  2, 72,129,253,  0,251,255,255,131,209,  1,
/* 0x0a70 */ 232,  0,  0,  0,  0,233, 62,255,255,255, 87, 94,128,250,  2, 15,
/* 0x0a80 */ 133,182,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,199,138,
/* 0x0a90 */  22,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,114,
/* 0x0aa0 */ 230,141, 65,  1,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0ab0 */ 138, 22, 17,192,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,
/* 0x0ac0 */ 138, 22,115,224,131,232,  3,114, 23,193,224,  8, 15,182,210,  9,
/* 0x0ad0 */ 208, 72,255,198,131,240,255, 15,132,  0,  0,  0,  0, 72, 99,232,
/* 0x0ae0 */ 141, 65,  1,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138,
/* 0x0af0 */  22, 17,201,  1,219,117, 10,139, 30, 72,131,238,252, 17,219,138,
/* 0x0b00 */  22, 17,201,117, 35,137,193,131,192,  2,  1,219,117, 10,139, 30,
/* 0x0b10 */  72,131,238,252, 17,219,138, 22, 17,201,  1,219,117,  8,139, 30,
/* 0x0b20 */  72,131,238,252, 17,219,115,226, 72,129,253,  0,243,255,255, 17,
/* 0x0b30 */ 193,232,  0,  0,  0,  0,233, 84,255,255,255, 87, 94, 91, 93, 95,
/* 0x0b40 */  72,141,116, 36, 16, 72,129,236,  0,  4,  0,  0, 72,137,226,232,
/* 0x0b50 */   0,  0,  0,  0, 72,129,196,  0,  4,  0,  0, 85, 94, 83, 95, 93,
/* 0x0b60 */  91, 80,104, 11,  0,  0,  0, 88,195, 89, 72,137,240, 72, 41,200,
/* 0x0b70 */  90, 72, 41,215, 89,137, 57, 91, 93,195,204,195, 87,137,240,137,
/* 0x0b80 */ 209,243,170, 88,195, 87,137,208,131,224,  7, 72,137,209, 72,193,
/* 0x0b90 */ 233,  3,243, 72,165,145,243,164, 88,195, 72,137,248, 37,255, 15,
/* 0x0ba0 */   0,  0, 72, 41,199, 72,  1,198,106,  9, 73,137,202, 88, 15,  5,
/* 0x0bb0 */  72, 61,  0,240,255,255,114,  1,204,195, 72,137,248, 37,255, 15,
/* 0x0bc0 */   0,  0, 72, 41,199, 72,  1,198,106, 11,235,225,106, 60,235,  2,
/* 0x0bd0 */ 106, 77,235,  5,104, 63,  1,  0,  0,235,  2,106,  3,235,  5,104,
/* 0x0be0 */   1,  1,  0,  0,235,  2,106,  1,235,  2,106,  0,235, 17, 72,137,
/* 0x0bf0 */ 248, 72, 37,255, 15,  0,  0, 72, 41,199, 72,  1,198,106, 10,235,
/* 0x0c00 */ 172, 65,128,248, 14, 15,133,  0,  0,  0,  0, 85, 72,137,229, 68,
/* 0x0c10 */ 139,  9, 73,137,208, 72,137,242, 72,141,119,  2, 86,138,  7,255,
/* 0x0c20 */ 202,136,193, 36,  7,192,233,  3, 72,199,195,  0,253,255,255, 72,
/* 0x0c30 */ 211,227,136,193, 72,141,156, 92,136,241,255,255, 72,131,227,192,
/* 0x0c40 */ 106,  0, 72, 57,220,117,249, 83, 72,141,123,  8,138, 78,255,255,
/* 0x0c50 */ 202,136, 71,  2,136,200,192,233,  4,136, 79,  1, 36, 15,136,  7,
/* 0x0c60 */  72,141, 79,252, 80, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86,
/* 0x0c70 */  65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,
/* 0x0c80 */ 137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,
/* 0x0c90 */ 116, 36,248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,
/* 0x0ca0 */ 182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76,
/* 0x0cb0 */  36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137,
/* 0x0cc0 */  68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,
/* 0x0cd0 */   0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,
/* 0x0ce0 */   1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,
/* 0x0cf0 */   0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,
/* 0x0d00 */   0,211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19,
/* 0x0d10 */  72,139, 92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,
/* 0x0d20 */   4,235,235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,
/* 0x0d30 */ 255, 49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,
/* 0x0d40 */   0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,
/* 0x0d50 */ 194,131,250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,
/* 0x0d60 */   0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68,
/* 0x0d70 */  33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,
/* 0x0d80 */ 224,  4, 72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,
/* 0x0d90 */ 119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,
/* 0x0da0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17,
/* 0x0db0 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,
/* 0x0dc0 */ 131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92,
/* 0x0dd0 */  36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,
/* 0x0de0 */   5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208,
/* 0x0df0 */  68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,
/* 0x0e00 */   1,208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,
/* 0x0e10 */ 141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84,
/* 0x0e20 */  36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,
/* 0x0e30 */ 214,137,235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0,
/* 0x0e40 */  72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231,
/* 0x0e50 */  15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x0e60 */   8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,
/* 0x0e70 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32,
/* 0x0e80 */  65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,
/* 0x0e90 */ 219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45,
/* 0x0ea0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,
/* 0x0eb0 */ 102, 41,194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,
/* 0x0ec0 */ 254,255,  0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,255,
/* 0x0ed0 */   0,  0,  0,127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,
/* 0x0ee0 */ 141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,
/* 0x0ef0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x0f00 */  15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x0f10 */  57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,
/* 0x0f20 */ 193,248,  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65,
/* 0x0f30 */  41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,102,
/* 0x0f40 */  65,137, 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199,
/* 0x0f50 */  65,137,245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68,
/* 0x0f60 */  36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139,
/* 0x0f70 */  68, 36,200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,
/* 0x0f80 */ 208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,
/* 0x0f90 */ 137,208,102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,
/* 0x0fa0 */ 251,255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76,
/* 0x0fb0 */  57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0fc0 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0,
/* 0x0fd0 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x0fe0 */  78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,
/* 0x0ff0 */ 139, 76, 36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139,
/* 0x1000 */  84, 36,192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,
/* 0x1010 */ 131,124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,
/* 0x1020 */   6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65,
/* 0x1030 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x1040 */ 251,255,255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,
/* 0x1050 */ 231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1060 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,
/* 0x1070 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,
/* 0x1080 */ 208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,
/* 0x1090 */   5, 68,137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,
/* 0x10a0 */   1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,
/* 0x10b0 */ 255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,
/* 0x10c0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x10d0 */   9,194, 15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x10e0 */ 183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195,
/* 0x10f0 */  65,193,248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,
/* 0x1100 */   0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,
/* 0x1110 */ 139, 92, 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,
/* 0x1120 */ 137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199,
/* 0x1130 */  68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x1140 */ 208,102,193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233,
/* 0x1150 */  17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1160 */ 102, 41,194, 65,129,251,255,255,255,  0,102,137,150,152,  1,  0,
/* 0x1170 */   0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,
/* 0x1180 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,
/* 0x1190 */ 176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x11a0 */  65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,
/* 0x11b0 */ 248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,
/* 0x11c0 */ 233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x11d0 */   5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,176,  1,
/* 0x11e0 */   0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7,
/* 0x11f0 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1200 */ 150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1210 */ 193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,
/* 0x1220 */ 193,248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,
/* 0x1230 */ 192,235, 34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1240 */  41,194,139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,
/* 0x1250 */ 192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116,
/* 0x1260 */  36,196, 65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,
/* 0x1270 */ 216, 15,159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137,
/* 0x1280 */  68, 36,200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,
/* 0x1290 */ 132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x12a0 */  72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11,
/* 0x12b0 */  15,183,202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,
/* 0x12c0 */   8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x12d0 */ 137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,
/* 0x12e0 */ 235,120, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x12f0 */ 194, 65,129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,
/* 0x1300 */ 231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1310 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,
/* 0x1320 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,
/* 0x1330 */ 195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,
/* 0x1340 */   5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,
/* 0x1350 */ 224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,
/* 0x1360 */ 235, 39, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,
/* 0x1370 */ 129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,
/* 0x1380 */ 137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,
/* 0x1390 */   0, 72, 99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119,
/* 0x13a0 */  26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,
/* 0x13b0 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,
/* 0x13c0 */ 216,193,232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,
/* 0x13d0 */ 137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,
/* 0x13e0 */   1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,
/* 0x13f0 */ 232,  5,141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,
/* 0x1400 */ 184,  1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,
/* 0x1410 */ 124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,
/* 0x1420 */   3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,
/* 0x1430 */ 184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,
/* 0x1440 */   3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,
/* 0x1450 */ 255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,
/* 0x1460 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1470 */   9,194, 15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1480 */ 193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,
/* 0x1490 */ 192, 41,200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,
/* 0x14a0 */ 195, 65, 41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102,
/* 0x14b0 */  41,194,102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,
/* 0x14c0 */   3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,
/* 0x14d0 */ 192,209,248, 65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,
/* 0x14e0 */ 137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192,
/* 0x14f0 */  68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,
/* 0x1500 */   0,235, 81,141,112,251, 65,129,251,255,255,255,  0,119, 26, 76,
/* 0x1510 */  57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1520 */ 193,227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69,
/* 0x1530 */  57,218,114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,
/* 0x1540 */ 139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193,
/* 0x1550 */  68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72,
/* 0x1560 */  99,195, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76,
/* 0x1570 */  57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1580 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,
/* 0x1590 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,
/* 0x15a0 */ 195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,
/* 0x15b0 */ 102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x15c0 */ 232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16,
/* 0x15d0 */  69,  1,237,255,206,117,136, 65,255,198,116, 64,131,197,  2, 69,
/* 0x15e0 */  57,254,119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68,
/* 0x15f0 */  15,182, 44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2,
/* 0x1600 */  15,149,194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,
/* 0x1610 */ 211, 68, 59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,
/* 0x1620 */ 255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,
/* 0x1630 */   7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,
/* 0x1640 */ 248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59,
/* 0x1650 */  49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 65, 87, 72,141,
/* 0x1660 */  71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69,
/* 0x1670 */  49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,
/* 0x1680 */ 184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,
/* 0x1690 */ 195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139,
/* 0x16a0 */  92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,
/* 0x16b0 */ 139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,
/* 0x16c0 */   0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,
/* 0x16d0 */   0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,
/* 0x16e0 */   0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,
/* 0x16f0 */   1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,
/* 0x1700 */   0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193,
/* 0x1710 */  57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,
/* 0x1720 */ 208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196,
/* 0x1730 */  76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1740 */ 255,194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124,
/* 0x1750 */  36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,
/* 0x1760 */ 200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108,
/* 0x1770 */  36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,
/* 0x1780 */ 255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,
/* 0x1790 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x17a0 */  65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202,
/* 0x17b0 */  15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,
/* 0x17c0 */   0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,
/* 0x17d0 */ 190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102,
/* 0x17e0 */  65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,
/* 0x17f0 */   0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,
/* 0x1800 */ 124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,
/* 0x1810 */ 184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,
/* 0x1820 */ 182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0,
/* 0x1830 */  65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,
/* 0x1840 */   4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7,
/* 0x1850 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x1860 */ 183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1870 */ 175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,
/* 0x1880 */ 246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,
/* 0x1890 */   2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,
/* 0x18a0 */ 193,232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,
/* 0x18b0 */   0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,
/* 0x18c0 */ 255,255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,
/* 0x18d0 */ 129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,
/* 0x18e0 */ 132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x18f0 */  72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11,
/* 0x1900 */  15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,
/* 0x1910 */   8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,
/* 0x1920 */   0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,
/* 0x1930 */ 116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,
/* 0x1940 */ 232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124,
/* 0x1950 */  36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,
/* 0x1960 */   0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,
/* 0x1970 */ 131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,
/* 0x1980 */   0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x1990 */  72,139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17,
/* 0x19a0 */  72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,
/* 0x19b0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x19c0 */  15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x19d0 */  15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0,
/* 0x19e0 */  76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,
/* 0x19f0 */ 193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,
/* 0x1a00 */ 134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188,
/* 0x1a10 */  15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,
/* 0x1a20 */ 200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1a30 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,
/* 0x1a40 */   1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,
/* 0x1a50 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x1a60 */ 183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1a70 */ 175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,
/* 0x1a80 */   0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,
/* 0x1a90 */ 141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,
/* 0x1aa0 */   1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76,
/* 0x1ab0 */  57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1ac0 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0,
/* 0x1ad0 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1ae0 */  79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,
/* 0x1af0 */   4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,
/* 0x1b00 */ 192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,
/* 0x1b10 */   0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,
/* 0x1b20 */   3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0,
/* 0x1b30 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,
/* 0x1b40 */ 137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,
/* 0x1b50 */ 194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,
/* 0x1b60 */   0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,
/* 0x1b70 */   4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1b80 */ 199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232,
/* 0x1b90 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,
/* 0x1ba0 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,
/* 0x1bb0 */   1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65,
/* 0x1bc0 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x1bd0 */ 255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132,
/* 0x1be0 */  68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1bf0 */ 255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,
/* 0x1c00 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,
/* 0x1c10 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,
/* 0x1c20 */ 200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,
/* 0x1c30 */ 137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,
/* 0x1c40 */ 200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,
/* 0x1c50 */ 137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124,
/* 0x1c60 */  36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,
/* 0x1c70 */   0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,
/* 0x1c80 */   0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,
/* 0x1c90 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x1ca0 */  17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x1cb0 */ 115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,
/* 0x1cc0 */ 248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,
/* 0x1cd0 */ 224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,
/* 0x1ce0 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x1cf0 */  65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,
/* 0x1d00 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x1d10 */  15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1d20 */  65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,
/* 0x1d30 */   0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2,
/* 0x1d40 */  72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,
/* 0x1d50 */   0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,
/* 0x1d60 */ 208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,
/* 0x1d70 */   0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0,
/* 0x1d80 */  68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,
/* 0x1d90 */ 255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,
/* 0x1da0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1db0 */   9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,
/* 0x1dc0 */ 194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237,
/* 0x1dd0 */  41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195,
/* 0x1de0 */  65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,
/* 0x1df0 */ 102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,
/* 0x1e00 */ 224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,
/* 0x1e10 */   0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,
/* 0x1e20 */ 197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,
/* 0x1e30 */ 224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73,
/* 0x1e40 */  99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76,
/* 0x1e50 */  57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1e60 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,
/* 0x1e70 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x1e80 */ 184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,
/* 0x1e90 */ 102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1ea0 */   5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143,
/* 0x1eb0 */  65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,
/* 0x1ec0 */   0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,
/* 0x1ed0 */ 248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,
/* 0x1ee0 */ 192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,
/* 0x1ef0 */ 194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,
/* 0x1f00 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,
/* 0x1f10 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1f20 */  65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,
/* 0x1f30 */ 206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,
/* 0x1f40 */   4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,
/* 0x1f50 */   0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0,
/* 0x1f60 */  77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,
/* 0x1f70 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1f80 */  65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1f90 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,
/* 0x1fa0 */ 200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195,
/* 0x1fb0 */  65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,
/* 0x1fc0 */ 102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,
/* 0x1fd0 */ 198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232,
/* 0x1fe0 */  68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,
/* 0x1ff0 */ 199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,
/* 0x2000 */ 228, 15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,
/* 0x2010 */ 247,255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,
/* 0x2020 */   1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,
/* 0x2030 */ 255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92,
/* 0x2040 */  36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65,
/* 0x2050 */  94, 65, 95, 72,139,117,248, 72,139,125, 16,139, 75,  4, 72,  1,
/* 0x2060 */ 206,139, 19, 72,  1,215,201,235,  2, 87, 94, 88, 72, 41,199, 88,
/* 0x2070 */  89,137, 57, 72, 41,240,195,  0, 46,115,121,109,116, 97, 98,  0,
/* 0x2080 */  46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97,
/* 0x2090 */  98,  0, 46,114,101,108, 97, 83, 79, 95, 77, 65, 73, 78,  0, 69,
/* 0x20a0 */  88, 80, 95, 72, 69, 65, 68,  0, 46,114,101,108, 97, 78, 82, 86,
/* 0x20b0 */  50, 69,  0, 46,114,101,108, 97, 78, 82, 86, 50, 68,  0, 46,114,
/* 0x20c0 */ 101,108, 97, 78, 82, 86, 50, 66,  0, 46,114,101,108, 97, 83, 79,
/* 0x20d0 */  95, 72, 69, 65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0, 83,
/* 0x20e0 */  79, 95, 84, 65, 73, 76,  0, 46,114,101,108, 97, 76, 90, 77, 65,
/* 0x20f0 */  95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x2100 */  48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  0, 76, 90, 77,
/* 0x2110 */  65, 95, 68, 69, 67, 51, 48,  0, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x2120 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2130 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2140 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2150 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2160 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x2170 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2180 */  64,  0,  0,  0,  0,  0,  0,  0,160,  7,  0,  0,  0,  0,  0,  0,
/* 0x2190 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x21a0 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x21b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x21c0 */ 240, 42,  0,  0,  0,  0,  0,  0,120,  3,  0,  0,  0,  0,  0,  0,
/* 0x21d0 */  21,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x21e0 */  24,  0,  0,  0,  0,  0,  0,  0, 40,  0,  0,  0,  1,  0,  0,  0,
/* 0x21f0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2200 */ 224,  7,  0,  0,  0,  0,  0,  0,224,  0,  0,  0,  0,  0,  0,  0,
/* 0x2210 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2220 */   0,  0,  0,  0,  0,  0,  0,  0, 54,  0,  0,  0,  1,  0,  0,  0,
/* 0x2230 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2240 */ 192,  8,  0,  0,  0,  0,  0,  0,229,  0,  0,  0,  0,  0,  0,  0,
/* 0x2250 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2260 */   0,  0,  0,  0,  0,  0,  0,  0, 49,  0,  0,  0,  4,  0,  0,  0,
/* 0x2270 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2280 */ 104, 46,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2290 */  21,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x22a0 */  24,  0,  0,  0,  0,  0,  0,  0, 65,  0,  0,  0,  1,  0,  0,  0,
/* 0x22b0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x22c0 */ 165,  9,  0,  0,  0,  0,  0,  0,215,  0,  0,  0,  0,  0,  0,  0,
/* 0x22d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x22e0 */   0,  0,  0,  0,  0,  0,  0,  0, 60,  0,  0,  0,  4,  0,  0,  0,
/* 0x22f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2300 */ 152, 46,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2310 */  21,  0,  0,  0,  6,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2320 */  24,  0,  0,  0,  0,  0,  0,  0, 76,  0,  0,  0,  1,  0,  0,  0,
/* 0x2330 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2340 */ 124, 10,  0,  0,  0,  0,  0,  0,193,  0,  0,  0,  0,  0,  0,  0,
/* 0x2350 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2360 */   0,  0,  0,  0,  0,  0,  0,  0, 71,  0,  0,  0,  4,  0,  0,  0,
/* 0x2370 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2380 */ 200, 46,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2390 */  21,  0,  0,  0,  8,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x23a0 */  24,  0,  0,  0,  0,  0,  0,  0, 87,  0,  0,  0,  1,  0,  0,  0,
/* 0x23b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23c0 */  61, 11,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0,
/* 0x23d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x23e0 */   0,  0,  0,  0,  0,  0,  0,  0, 82,  0,  0,  0,  4,  0,  0,  0,
/* 0x23f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2400 */ 248, 46,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2410 */  21,  0,  0,  0, 10,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2420 */  24,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  1,  0,  0,  0,
/* 0x2430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2440 */ 105, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2450 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2460 */   0,  0,  0,  0,  0,  0,  0,  0,104,  0,  0,  0,  1,  0,  0,  0,
/* 0x2470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2480 */ 105, 11,  0,  0,  0,  0,  0,  0,152,  0,  0,  0,  0,  0,  0,  0,
/* 0x2490 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x24a0 */   0,  0,  0,  0,  0,  0,  0,  0,117,  0,  0,  0,  1,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24c0 */   1, 12,  0,  0,  0,  0,  0,  0,100,  0,  0,  0,  0,  0,  0,  0,
/* 0x24d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x24e0 */   0,  0,  0,  0,  0,  0,  0,  0,112,  0,  0,  0,  4,  0,  0,  0,
/* 0x24f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */  16, 47,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */  21,  0,  0,  0, 14,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2520 */  24,  0,  0,  0,  0,  0,  0,  0,128,  0,  0,  0,  1,  0,  0,  0,
/* 0x2530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */ 101, 12,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x2550 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2560 */   0,  0,  0,  0,  0,  0,  0,  0,139,  0,  0,  0,  1,  0,  0,  0,
/* 0x2570 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2580 */  92, 22,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x2590 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */   0,  0,  0,  0,  0,  0,  0,  0,150,  0,  0,  0,  1,  0,  0,  0,
/* 0x25b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  83, 32,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x25e0 */   0,  0,  0,  0,  0,  0,  0,  0,161,  0,  0,  0,  1,  0,  0,  0,
/* 0x25f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */ 107, 32,  0,  0,  0,  0,  0,  0, 12,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2620 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x2630 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2640 */ 119, 32,  0,  0,  0,  0,  0,  0,170,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2660 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2670 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2680 */ 232, 38,  0,  0,  0,  0,  0,  0, 96,  3,  0,  0,  0,  0,  0,  0,
/* 0x2690 */  22,  0,  0,  0, 14,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x26a0 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x26b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26c0 */  72, 42,  0,  0,  0,  0,  0,  0,168,  0,  0,  0,  0,  0,  0,  0,
/* 0x26d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x26e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2700 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2710 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,
/* 0x2720 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2730 */   0,  0,  0,  0,  3,  0, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x2750 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2760 */   0,  0,  0,  0,  3,  0,  4,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  6,  0,
/* 0x2780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */   0,  0,  0,  0,  3,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 10,  0,
/* 0x27b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27c0 */   0,  0,  0,  0,  3,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 13,  0,
/* 0x27e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27f0 */   0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,
/* 0x2810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2820 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2830 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0, 16,  0, 13,  0,
/* 0x2840 */  49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2850 */   6,  0,  0,  0, 16,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2860 */   0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0, 16,  0, 13,  0,
/* 0x2870 */  95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */  22,  0,  0,  0, 16,  0, 13,  0, 28,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */   0,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 16,  0, 13,  0,
/* 0x28a0 */  49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28b0 */  37,  0,  0,  0, 16,  0, 13,  0,103,  0,  0,  0,  0,  0,  0,  0,
/* 0x28c0 */   0,  0,  0,  0,  0,  0,  0,  0, 47,  0,  0,  0, 16,  0, 13,  0,
/* 0x28d0 */  63,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28e0 */  52,  0,  0,  0, 18,  0, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28f0 */   0,  0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0, 16,  0, 13,  0,
/* 0x2900 */ 125,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */  62,  0,  0,  0, 18,  0,  1,  0,128,  3,  0,  0,  0,  0,  0,  0,
/* 0x2920 */  29,  0,  0,  0,  0,  0,  0,  0, 73,  0,  0,  0, 16,  0, 13,  0,
/* 0x2930 */ 107,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2940 */  86,  0,  0,  0, 16,  0, 13,  0,129,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */   0,  0,  0,  0,  0,  0,  0,  0, 91,  0,  0,  0, 16,  0, 13,  0,
/* 0x2960 */  19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2970 */  98,  0,  0,  0, 16,  0, 13,  0, 17,  0,  0,  0,  0,  0,  0,  0,
/* 0x2980 */   0,  0,  0,  0,  0,  0,  0,  0,106,  0,  0,  0, 16,  0, 13,  0,
/* 0x2990 */ 133,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29a0 */ 115,  0,  0,  0, 16,  0, 13,  0,125,  0,  0,  0,  0,  0,  0,  0,
/* 0x29b0 */   0,  0,  0,  0,  0,  0,  0,  0,122,  0,  0,  0, 16,  0, 13,  0,
/* 0x29c0 */  81,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29d0 */ 129,  0,  0,  0, 16,  0, 13,  0, 99,  0,  0,  0,  0,  0,  0,  0,
/* 0x29e0 */   0,  0,  0,  0,  0,  0,  0,  0,134,  0,  0,  0, 16,  0, 13,  0,
/* 0x29f0 */ 118,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a00 */ 141,  0,  0,  0, 16,  0, 13,  0,148,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */   0,  0,  0,  0,  0,  0,  0,  0,150,  0,  0,  0, 16,  0, 13,  0,
/* 0x2a20 */ 114,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a30 */ 156,  0,  0,  0, 18,  0,  1,  0,157,  3,  0,  0,  0,  0,  0,  0,
/* 0x2a40 */   3,  4,  0,  0,  0,  0,  0,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x2a50 */ 101,120,112, 97,110,100,  0,109,117,110,109, 97,112,  0,109,101,
/* 0x2a60 */ 109, 99,112,121,  0, 79, 95, 66, 73, 78, 70, 79,  0,102,116,114,
/* 0x2a70 */ 117,110, 99, 97,116,101,  0,109,109, 97,112,  0,101,111,102,  0,
/* 0x2a80 */ 119,114,105,116,101,  0, 80, 70, 95,116,111, 95, 80, 82, 79, 84,
/* 0x2a90 */   0,109,101,109,102,100, 95, 99,114,101, 97,116,101,  0,114,101,
/* 0x2aa0 */  97,100,  0,109,101,109,115,101,116,  0,109,121, 95, 98,107,112,
/* 0x2ab0 */ 116,  0, 80,112,114,111,116,101, 99,116,  0, 80,119,114,105,116,
/* 0x2ac0 */ 101,  0, 80,117,110,109, 97,112,  0,101,120,105,116,  0,111,112,
/* 0x2ad0 */ 101,110, 97,116,  0,109,112,114,111,116,101, 99,116,  0, 99,108,
/* 0x2ae0 */ 111,115,101,  0,117,112,120, 95,115,111, 95,109, 97,105,110,  0,
/* 0x2af0 */  13,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 27,  0,  0,  0,
/* 0x2b00 */ 252,255,255,255,255,255,255,255, 23,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b10 */   4,  0,  0,  0, 31,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2b20 */  46,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 31,  0,  0,  0,
/* 0x2b30 */ 252,255,255,255,255,255,255,255, 14,  1,  0,  0,  0,  0,  0,  0,
/* 0x2b40 */   4,  0,  0,  0, 15,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2b50 */ 210,  1,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 24,  0,  0,  0,
/* 0x2b60 */ 252,255,255,255,255,255,255,255,224,  1,  0,  0,  0,  0,  0,  0,
/* 0x2b70 */   4,  0,  0,  0, 19,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2b80 */ 249,  1,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 29,  0,  0,  0,
/* 0x2b90 */ 252,255,255,255,255,255,255,255, 27,  2,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */   4,  0,  0,  0, 14,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2bb0 */  37,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 34,  0,  0,  0,
/* 0x2bc0 */ 252,255,255,255,255,255,255,255,131,  2,  0,  0,  0,  0,  0,  0,
/* 0x2bd0 */   4,  0,  0,  0, 32,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2be0 */ 155,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 25,  0,  0,  0,
/* 0x2bf0 */ 252,255,255,255,255,255,255,255,169,  2,  0,  0,  0,  0,  0,  0,
/* 0x2c00 */   4,  0,  0,  0, 34,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2c10 */  37,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x2c20 */ 252,255,255,255,255,255,255,255, 70,  3,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */   4,  0,  0,  0, 20,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2c40 */  84,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x2c50 */ 252,255,255,255,255,255,255,255, 37,  4,  0,  0,  0,  0,  0,  0,
/* 0x2c60 */   4,  0,  0,  0, 20,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2c70 */  56,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x2c80 */ 252,255,255,255,255,255,255,255,222,  4,  0,  0,  0,  0,  0,  0,
/* 0x2c90 */   4,  0,  0,  0, 24,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2ca0 */ 247,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 19,  0,  0,  0,
/* 0x2cb0 */ 252,255,255,255,255,255,255,255,  5,  5,  0,  0,  0,  0,  0,  0,
/* 0x2cc0 */   4,  0,  0,  0, 29,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2cd0 */  29,  5,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 29,  0,  0,  0,
/* 0x2ce0 */ 252,255,255,255,255,255,255,255, 42,  5,  0,  0,  0,  0,  0,  0,
/* 0x2cf0 */   4,  0,  0,  0, 30,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2d00 */  50,  5,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x2d10 */ 252,255,255,255,255,255,255,255, 79,  5,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */   4,  0,  0,  0, 14,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2d30 */  86,  5,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 34,  0,  0,  0,
/* 0x2d40 */ 252,255,255,255,255,255,255,255, 51,  6,  0,  0,  0,  0,  0,  0,
/* 0x2d50 */   4,  0,  0,  0, 24,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2d60 */  66,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 19,  0,  0,  0,
/* 0x2d70 */ 252,255,255,255,255,255,255,255, 82,  6,  0,  0,  0,  0,  0,  0,
/* 0x2d80 */   4,  0,  0,  0, 29,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2d90 */  97,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x2da0 */ 252,255,255,255,255,255,255,255,131,  6,  0,  0,  0,  0,  0,  0,
/* 0x2db0 */   4,  0,  0,  0, 14,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2dc0 */   3,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x2dd0 */ 252,255,255,255,255,255,255,255, 11,  7,  0,  0,  0,  0,  0,  0,
/* 0x2de0 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2df0 */  48,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 14,  0,  0,  0,
/* 0x2e00 */ 252,255,255,255,255,255,255,255, 56,  7,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   4,  0,  0,  0, 34,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2e20 */  66,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x2e30 */ 252,255,255,255,255,255,255,255, 86,  7,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   4,  0,  0,  0, 28,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2e50 */ 113,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x2e60 */ 252,255,255,255,255,255,255,255,218,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   2,  0,  0,  0,  1,  0,  0,  0,159,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */ 113,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x2e90 */ 252,255,255,255,255,255,255,255,204,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   2,  0,  0,  0,  1,  0,  0,  0,159,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */ 113,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x2ec0 */ 252,255,255,255,255,255,255,255,182,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */   2,  0,  0,  0,  1,  0,  0,  0,159,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */  93,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x2ef0 */ 252,255,255,255,255,255,255,255, 19,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   2,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x2f10 */   6,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x2f20 */  18,  0,  0,  0,  0,  0,  0,  0,102,105,108,101, 32,102,111,114,
/* 0x2f30 */ 109, 97,116, 32,101,108,102, 54, 52, 45,120, 56, 54, 45, 54, 52,
/* 0x2f40 */  10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32,
/* 0x2f50 */  78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,
/* 0x2f60 */ 122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32,
/* 0x2f70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x2f80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101,
/* 0x2f90 */  32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,
/* 0x2fa0 */ 115, 10, 32, 32, 48, 32, 83, 79, 95, 77, 65, 73, 78, 32, 32, 32,
/* 0x2fb0 */  32, 32, 32, 32, 48, 55, 97, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2fc0 */  48, 52, 48, 32, 32, 50, 42, 42, 52, 32, 32, 67, 79, 78, 84, 69,
/* 0x2fd0 */  78, 84, 83, 10, 32, 32, 49, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x2fe0 */  32, 32, 32, 32, 32, 32, 48,101, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x2ff0 */  32, 48, 55,101, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3000 */  84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 78, 82, 86, 50, 69, 32,
/* 0x3010 */  32, 32, 32, 32, 32, 32, 32, 32, 48,101, 53, 32, 32, 48, 32, 32,
/* 0x3020 */  48, 32, 32, 48, 56, 99, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3030 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 78, 82, 86, 50,
/* 0x3040 */  68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,100, 55, 32, 32, 48,
/* 0x3050 */  32, 32, 48, 32, 32, 48, 57, 97, 53, 32, 32, 50, 42, 42, 48, 32,
/* 0x3060 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 78, 82,
/* 0x3070 */  86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 49, 32,
/* 0x3080 */  32, 48, 32, 32, 48, 32, 32, 48, 97, 55, 99, 32, 32, 50, 42, 42,
/* 0x3090 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x30a0 */  83, 79, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x30b0 */  99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 51,100, 32, 32, 50,
/* 0x30c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x30d0 */  54, 32,112,116,114, 95, 78, 69, 88, 84, 32, 32, 32, 32, 32, 32,
/* 0x30e0 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 54, 57, 32, 32, 50,
/* 0x30f0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3100 */  55, 32, 83, 79, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 32,
/* 0x3110 */  48, 57, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 54, 57, 32,
/* 0x3120 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3130 */  32, 32, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32,
/* 0x3140 */  32, 32, 48, 54, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 48,
/* 0x3150 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3160 */  83, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3170 */  32, 32, 32, 32, 48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3180 */  48, 99, 54, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3190 */  69, 78, 84, 83, 10, 32, 49, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x31a0 */  67, 50, 48, 32, 32, 32, 32, 48, 57,102, 55, 32, 32, 48, 32, 32,
/* 0x31b0 */  48, 32, 32, 48, 49, 54, 53, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x31c0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 76, 90, 77,
/* 0x31d0 */  65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 56, 32, 32,
/* 0x31e0 */  48, 32, 32, 48, 32, 32, 48, 50, 48, 53, 51, 32, 32, 50, 42, 42,
/* 0x31f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32,
/* 0x3200 */  69, 88, 80, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 99,
/* 0x3210 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 48, 54, 98, 32, 32, 50,
/* 0x3220 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89,
/* 0x3230 */  77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3250 */  32, 32,100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48, 32,
/* 0x3260 */  69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3280 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76,
/* 0x3290 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x32a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x32b0 */ 100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32, 69, 88,
/* 0x32c0 */  80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x32e0 */  83, 79, 95, 77, 65, 73, 78, 32, 48, 32, 83, 79, 95, 77, 65, 73,
/* 0x32f0 */  78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3300 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,
/* 0x3310 */  32, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3330 */  32, 32, 78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10,
/* 0x3340 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3350 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48,
/* 0x3360 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3370 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3380 */  83, 79, 95, 72, 69, 65, 68, 32, 48, 32, 83, 79, 95, 72, 69, 65,
/* 0x3390 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,112,116,114, 95, 78,
/* 0x33b0 */  69, 88, 84, 32, 48, 32,112,116,114, 95, 78, 69, 88, 84, 10, 48,
/* 0x33c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x33d0 */ 108, 32, 32, 32, 32,100, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x33e0 */  48, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48,
/* 0x33f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3400 */ 100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32,
/* 0x3410 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x3420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3430 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48,
/* 0x3440 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3460 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32,
/* 0x3470 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x3480 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 49, 32,103, 32,
/* 0x3490 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x34a0 */  80,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34b0 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88,
/* 0x34c0 */  80, 95, 72, 69, 65, 68, 32, 48, 32,102, 95,101,120,112, 97,110,
/* 0x34d0 */ 100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34e0 */  53,102, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x34f0 */  73, 76, 32, 48, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48,
/* 0x3500 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 99, 32,103, 32, 32,
/* 0x3510 */  32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,
/* 0x3520 */ 101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 51, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3540 */  79, 95, 84, 65, 73, 76, 32, 48, 32, 79, 95, 66, 73, 78, 70, 79,
/* 0x3550 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x3560 */  55, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x3570 */  76, 32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10, 48, 48,
/* 0x3580 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51,102, 32,103,
/* 0x3590 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x35a0 */  32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35b0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 83,
/* 0x35c0 */  79, 95, 84, 65, 73, 76, 32, 48, 32,101,111,102, 10, 48, 48, 48,
/* 0x35d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,100, 32,103, 32,
/* 0x35e0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x35f0 */ 119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3600 */  48, 48, 48, 51, 56, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 83,
/* 0x3610 */  79, 95, 77, 65, 73, 78, 32, 48, 49,100, 32, 80, 70, 95,116,111,
/* 0x3620 */  95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3630 */  48, 48, 48, 48, 54, 98, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3640 */  79, 95, 84, 65, 73, 76, 32, 48, 32,109,101,109,102,100, 95, 99,
/* 0x3650 */ 114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3660 */  48, 48, 48, 48, 56, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3670 */  79, 95, 84, 65, 73, 76, 32, 48, 32,114,101, 97,100, 10, 48, 48,
/* 0x3680 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51, 32,103,
/* 0x3690 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x36a0 */  32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36b0 */  48, 48, 48, 48, 48, 48, 49, 49, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x36c0 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,121, 95, 98,107,
/* 0x36d0 */ 112,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x36e0 */  48, 56, 53, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x36f0 */  65, 73, 76, 32, 48, 32, 80,112,114,111,116,101, 99,116, 10, 48,
/* 0x3700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,100, 32,
/* 0x3710 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x3720 */  48, 32, 80,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 48, 48, 48, 48, 53, 49, 32,103, 32, 32, 32, 32, 32,
/* 0x3740 */  32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,117,110,109,
/* 0x3750 */  97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3760 */  48, 54, 51, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x3770 */  65, 73, 76, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 54, 32,103, 32, 32, 32,
/* 0x3790 */  32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,111,112,
/* 0x37a0 */ 101,110, 97,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x37b0 */  48, 48, 48, 57, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79,
/* 0x37c0 */  95, 84, 65, 73, 76, 32, 48, 32,109,112,114,111,116,101, 99,116,
/* 0x37d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x37e0 */  50, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x37f0 */  76, 32, 48, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 48, 48, 48, 48, 48, 48, 51, 57,100, 32,103, 32, 32, 32, 32,
/* 0x3810 */  32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 52, 48, 51, 32,
/* 0x3820 */ 117,112,120, 95,115,111, 95,109, 97,105,110, 10, 10, 82, 69, 76,
/* 0x3830 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x3840 */  70, 79, 82, 32, 91, 83, 79, 95, 77, 65, 73, 78, 93, 58, 10, 79,
/* 0x3850 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3860 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3870 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3880 */  48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3890 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,121, 95, 98,107,
/* 0x38a0 */ 112,116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x38b0 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38c0 */  48, 48, 48, 48, 49, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x38d0 */  80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,
/* 0x38e0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x38f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3900 */ 101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x3910 */  32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,
/* 0x3920 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x3930 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48,101, 32, 82, 95, 88,
/* 0x3940 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,
/* 0x3950 */  95,101,120,112, 97,110,100, 43, 48,120,102,102,102,102,102,102,
/* 0x3960 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x3970 */  48, 48, 48, 48, 48, 48, 48, 48, 49,100, 50, 32, 82, 95, 88, 56,
/* 0x3980 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,
/* 0x3990 */ 109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,
/* 0x39a0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x39b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,101, 48, 32, 82,
/* 0x39c0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x39d0 */  32,102,116,114,117,110, 99, 97,116,101, 43, 48,120,102,102,102,
/* 0x39e0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x39f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,102, 57, 32, 82,
/* 0x3a00 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x3a10 */  32, 80,119,114,105,116,101, 43, 48,120,102,102,102,102,102,102,
/* 0x3a20 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x3a30 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 98, 32, 82, 95, 88, 56,
/* 0x3a40 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80,109,
/* 0x3a50 */  97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3a60 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a70 */  48, 48, 48, 50, 50, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3a80 */  80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,
/* 0x3a90 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3aa0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x3ab0 */  56, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x3ac0 */  50, 32, 32, 32, 32,111,112,101,110, 97,116, 43, 48,120,102,102,
/* 0x3ad0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x3ae0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 57, 98, 32,
/* 0x3af0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x3b00 */  32, 32,114,101, 97,100, 43, 48,120,102,102,102,102,102,102,102,
/* 0x3b10 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x3b20 */  48, 48, 48, 48, 48, 48, 48, 50, 97, 57, 32, 82, 95, 88, 56, 54,
/* 0x3b30 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,
/* 0x3b40 */ 115,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3b50 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 51, 50, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3b70 */  80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109, 99,112,121, 43,
/* 0x3b80 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3b90 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ba0 */  51, 52, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x3bb0 */  51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,
/* 0x3bc0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x3bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 53, 52, 32, 82,
/* 0x3be0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x3bf0 */  32,109,101,109, 99,112,121, 43, 48,120,102,102,102,102,102,102,
/* 0x3c00 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 50, 53, 32, 82, 95, 88, 56,
/* 0x3c20 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109,
/* 0x3c30 */  97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3c40 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  48, 48, 48, 52, 51, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3c60 */  80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109, 99,112,121, 43,
/* 0x3c70 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3c80 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c90 */  52,100,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x3ca0 */  51, 50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x3cb0 */ 116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3cc0 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cd0 */  48, 48, 48, 52,102, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3ce0 */  80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110, 99, 97,
/* 0x3cf0 */ 116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3d00 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d10 */  48, 48, 48, 53, 48, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x3d20 */  80, 76, 84, 51, 50, 32, 32, 32, 32, 80,119,114,105,116,101, 43,
/* 0x3d30 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3d40 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d50 */  53, 49,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x3d60 */  51, 50, 32, 32, 32, 32, 80,119,114,105,116,101, 43, 48,120,102,
/* 0x3d70 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x3d80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 50, 97,
/* 0x3d90 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x3da0 */  32, 32, 32, 80,117,110,109, 97,112, 43, 48,120,102,102,102,102,
/* 0x3db0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 51, 50, 32, 82, 95,
/* 0x3dd0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x3de0 */  80, 70, 95,116,111, 95, 80, 82, 79, 84, 43, 48,120,102,102,102,
/* 0x3df0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x3e00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 52,102, 32, 82,
/* 0x3e10 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x3e20 */  32, 80,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x3e30 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 53, 53, 54, 32, 82, 95, 88, 56, 54, 95,
/* 0x3e50 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,
/* 0x3e60 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3e70 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e80 */  48, 48, 54, 51, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x3e90 */  76, 84, 51, 50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,
/* 0x3ea0 */ 101, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x3eb0 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ec0 */  48, 48, 48, 48, 48, 54, 52, 50, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3ed0 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110,
/* 0x3ee0 */  99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x3ef0 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  48, 48, 48, 48, 48, 54, 53, 50, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x3f10 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80,119,114,105,116,
/* 0x3f20 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3f30 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f40 */  48, 48, 54, 54, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x3f50 */  76, 84, 51, 50, 32, 32, 32, 32, 80,117,110,109, 97,112, 43, 48,
/* 0x3f60 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x3f70 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x3f80 */  56, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x3f90 */  50, 32, 32, 32, 32, 80,109, 97,112, 43, 48,120,102,102,102,102,
/* 0x3fa0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 48, 51, 32, 82, 95,
/* 0x3fc0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x3fd0 */  80,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x3fe0 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 48, 48, 48, 48, 55, 48, 98, 32, 82, 95, 88, 56, 54,
/* 0x4000 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80, 70, 95,
/* 0x4010 */ 116,111, 95, 80, 82, 79, 84, 43, 48,120,102,102,102,102,102,102,
/* 0x4020 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 48, 48, 48, 48, 48, 48, 55, 51, 48, 32, 82, 95, 88, 56,
/* 0x4040 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80,109,
/* 0x4050 */  97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4060 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4070 */  48, 48, 48, 55, 51, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4080 */  80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,
/* 0x4090 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x40a0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x40b0 */  52, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x40c0 */  50, 32, 32, 32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 43,
/* 0x40d0 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x40e0 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  55, 53, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4100 */  51, 50, 32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 43, 48,
/* 0x4110 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4120 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x4130 */  55, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4140 */  50, 32, 32, 32, 32, 80,117,110,109, 97,112, 43, 48,120,102,102,
/* 0x4150 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10,
/* 0x4160 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4170 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10,
/* 0x4180 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4190 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x41a0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x41b0 */  48, 48, 48, 48, 48, 48, 48,100, 97, 32, 82, 95, 88, 56, 54, 95,
/* 0x41c0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x41d0 */  72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41e0 */  48, 48, 48, 48, 48, 57,102, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41f0 */  48, 48, 48, 48, 48, 48, 55, 49, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4200 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84,
/* 0x4210 */  65, 73, 76, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4220 */ 102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4230 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4240 */  78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4260 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4270 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4280 */  99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4290 */  32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57,102, 10,
/* 0x42b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 49,
/* 0x42c0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x42d0 */  32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120,102,102,
/* 0x42e0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10,
/* 0x42f0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4300 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10,
/* 0x4310 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4320 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4330 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4340 */  48, 48, 48, 48, 48, 48, 48, 98, 54, 32, 82, 95, 88, 56, 54, 95,
/* 0x4350 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x4360 */  72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4370 */  48, 48, 48, 48, 48, 57,102, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4380 */  48, 48, 48, 48, 48, 48, 53,100, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4390 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84,
/* 0x43a0 */  65, 73, 76, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x43b0 */ 102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x43c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x43d0 */  83, 79, 95, 72, 69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x43e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x43f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4400 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 49, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x4420 */  50, 32, 32, 32, 32, 32,117,112,120, 95,115,111, 95,109, 97,105,
/* 0x4430 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4440 */ 102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4450 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x4460 */  77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4470 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4480 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4490 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44a0 */  48, 48, 48, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67,
/* 0x44b0 */  51, 50, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x44c0 */  48, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44d0 */  48, 48, 49, 50, 10
};
