// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }
// Test reflection type traits [meta.reflection.traits], type properties.

#include <functional>
#include <meta>

using namespace std::meta;

class ClassType { };
class DerivedType : public ClassType { };
enum EnumType { e0 };
struct ThrowDefaultClass { ThrowDefaultClass () noexcept (false); };
struct ThrowCopyConsClass { ThrowCopyConsClass (const ThrowCopyConsClass &) noexcept (false); };
struct ThrowMoveConsClass { ThrowMoveConsClass (ThrowMoveConsClass &&) noexcept (false); };
struct NoexceptDefaultClass { NoexceptDefaultClass () noexcept (true); };
struct ExceptDefaultClass { ExceptDefaultClass () noexcept (false); };
struct NoexceptCopyConsClass { NoexceptCopyConsClass (const NoexceptCopyConsClass &) noexcept (true); };
struct ExceptCopyConsClass { ExceptCopyConsClass (const ExceptCopyConsClass &) noexcept (false); };
struct NoexceptMoveConsClass { NoexceptMoveConsClass (NoexceptMoveConsClass &&) noexcept (true); NoexceptMoveConsClass &operator= (NoexceptMoveConsClass &&) = default; };
struct ExceptMoveConsClass { ExceptMoveConsClass (ExceptMoveConsClass &&) noexcept (false); };
struct NoexceptCopyAssignClass { NoexceptCopyAssignClass &operator= (const NoexceptCopyAssignClass &) noexcept (true); };
struct ExceptCopyAssignClass { ExceptCopyAssignClass &operator= (const ExceptCopyAssignClass &) noexcept (false); };
struct NoexceptMoveAssignClass { NoexceptMoveAssignClass (NoexceptMoveAssignClass &&) = default; NoexceptMoveAssignClass &operator= (NoexceptMoveAssignClass &&) noexcept (true); };
struct ExceptMoveAssignClass { ExceptMoveAssignClass &operator= (ExceptMoveAssignClass &&) noexcept (false); };
struct DeletedCopyAssignClass { DeletedCopyAssignClass & operator= (const DeletedCopyAssignClass &) = delete; };
struct DeletedMoveAssignClass { DeletedMoveAssignClass &operator= (DeletedMoveAssignClass &&) = delete; };
struct NType { int i; int j; virtual ~NType (); };
struct TType { int i; private: int j; };
struct SLType { int i; int j; ~SLType (); };
struct PODType { int i; int j; };
struct LType { int i; constexpr LType (int j) : i(j) {} };
struct HasTemplateCCtor { HasTemplateCCtor (const HasTemplateCCtor &) = default; template <class T> HasTemplateCCtor (T &&); };
struct MoveOnly { MoveOnly (MoveOnly &&) = default; };
struct MoveOnly2 { MoveOnly2 (MoveOnly2 &&) = delete; };
class PolymorphicClass { virtual void rotate (int); };
struct CopyConsOnlyType {
  CopyConsOnlyType (int) { }
  CopyConsOnlyType (CopyConsOnlyType &&) = delete;
  CopyConsOnlyType (const CopyConsOnlyType &) = default;
  CopyConsOnlyType &operator= (const CopyConsOnlyType &) = delete;
  CopyConsOnlyType &operator= (CopyConsOnlyType &&) = delete;
};
struct MoveConsOnlyType {
  MoveConsOnlyType (int) { }
  MoveConsOnlyType (const MoveConsOnlyType &) = delete;
  MoveConsOnlyType (MoveConsOnlyType &&) = default;
  MoveConsOnlyType &operator= (const MoveConsOnlyType &) = delete;
  MoveConsOnlyType &operator= (MoveConsOnlyType &&) = delete;
};
struct NoexceptExplicitClass {
  NoexceptExplicitClass (double &) noexcept (true);
  explicit NoexceptExplicitClass (int &) noexcept (true);
  NoexceptExplicitClass (double &, int &, double &) noexcept (true);
};
struct ExceptExplicitClass {
  ExceptExplicitClass (double &) noexcept (false);
  explicit ExceptExplicitClass (int &) noexcept (false);
  ExceptExplicitClass (double &, int &, double &) noexcept (false);
};
struct NothrowExplicitClass {
  NothrowExplicitClass (double &) throw ();
  explicit NothrowExplicitClass (int &) throw ();
  NothrowExplicitClass (double &, int &, double &) throw ();
};

namespace N1
{
  struct Empty {};
  struct B { int i; B () {} };
  struct D : B {};
  enum E { ee1 };
  enum E2 { ee2 };
  enum class SE { e1 };
  enum class SE2 { e2 };
  enum OpE : int;
  enum class OpSE : bool;
  union U { int i; Empty b; };
  struct Abstract { virtual ~Abstract () = 0; };
  struct AbstractDelDtor { ~AbstractDelDtor () = delete; virtual void foo () = 0; };
  struct Ukn;
  template <class To>
  struct ImplicitTo { operator To (); };
  template <class To>
  struct DelImplicitTo { operator To () = delete; };
  template <class To>
  struct ExplicitTo { explicit operator To (); };
  struct Ellipsis { Ellipsis (...) {} };
  struct DelEllipsis { DelEllipsis (...) = delete; };
  struct Any { template <class T> Any (T &&) {} };
  struct nAny { template <class... T> nAny (T &&...) {} };
  struct DelnAny { template <class... T> DelnAny (T &&...) = delete; };
  template <class... Args>
  struct FromArgs { FromArgs (Args...); };
  struct DelDef { DelDef () = delete; };
  struct DelCopy { DelCopy (const DelCopy &) = delete; };
  struct DelDtor {
    DelDtor () = default;
    DelDtor (const DelDtor &) = default;
    DelDtor (DelDtor &&) = default;
    DelDtor (int);
    DelDtor (int, B, U);
    ~DelDtor () = delete;
  };
  struct Nontrivial {
    Nontrivial ();
    Nontrivial (const Nontrivial &);
    Nontrivial &operator= (const Nontrivial &);
    ~Nontrivial ();
  };
  union NontrivialUnion { int i; Nontrivial n; };
  struct UnusualCopy { UnusualCopy (UnusualCopy &); };
}
struct X { X () = default; X (int) noexcept {} X (double) {} };
struct Y { int i; X x; };
struct Z : Y { };

static_assert (is_trivially_constructible_type (^^int, {}));
static_assert (is_trivially_constructible_type (^^int, { ^^int }));
static_assert (is_trivially_constructible_type (^^int, { ^^int & }));
static_assert (is_trivially_constructible_type (^^int, { ^^int && }));
static_assert (is_trivially_constructible_type (^^int, { ^^const int & }));
static_assert (!is_trivially_constructible_type (^^int, { ^^void * }));
static_assert (!is_trivially_constructible_type (^^int, { ^^int * }));
static_assert (!is_trivially_constructible_type (^^int, { ^^const int * }));
static_assert (!is_trivially_constructible_type (^^int *, { ^^void * }));
static_assert (!is_trivially_constructible_type (^^int *, { ^^const int * }));
static_assert (!is_trivially_constructible_type (^^int &, { ^^const int }));
static_assert (is_trivially_constructible_type (^^const int &, { ^^int }));
static_assert (is_trivially_constructible_type (^^const int &, { ^^int & }));
static_assert (is_trivially_constructible_type (^^const int *, { ^^int * }));
static_assert (!is_trivially_constructible_type (^^PolymorphicClass, {}));
static_assert (!is_trivially_constructible_type (^^PolymorphicClass, { ^^PolymorphicClass }));
static_assert (!is_trivially_constructible_type (^^PolymorphicClass, { ^^PolymorphicClass & }));
static_assert (!is_trivially_constructible_type (^^PolymorphicClass, { ^^PolymorphicClass && }));
static_assert (!is_trivially_constructible_type (^^PolymorphicClass, { ^^const PolymorphicClass & }));
static_assert (is_trivially_constructible_type (^^TType, {}));
static_assert (is_trivially_constructible_type (^^TType, { ^^TType }));
static_assert (is_trivially_constructible_type (^^TType, { ^^TType & }));
static_assert (is_trivially_constructible_type (^^TType, { ^^TType && }));
static_assert (is_trivially_constructible_type (^^TType, { ^^const TType & }));
static_assert (!is_trivially_constructible_type (^^TType, { ^^int, ^^int }));
static_assert (is_trivially_constructible_type (^^PODType, {}));
static_assert (is_trivially_constructible_type (^^PODType, { ^^PODType }));
static_assert (is_trivially_constructible_type (^^PODType, { ^^PODType & }));
static_assert (is_trivially_constructible_type (^^PODType, { ^^PODType && }));
static_assert (is_trivially_constructible_type (^^PODType, { ^^const PODType & }));
static_assert (is_trivially_constructible_type (^^PODType, { ^^int, ^^int }));
static_assert (!is_trivially_constructible_type (^^NType, {}));
static_assert (!is_trivially_constructible_type (^^SLType, {}));
static_assert (!is_trivially_constructible_type (^^LType, {}));
static_assert (!is_trivially_constructible_type (^^LType, { ^^int }));
static_assert (!is_trivially_constructible_type (^^N1::DelDef, {}));
static_assert (!is_trivially_constructible_type (^^N1::Abstract, {}));
static_assert (!is_trivially_constructible_type (^^N1::Ellipsis, {}));
static_assert (!is_trivially_constructible_type (^^N1::DelEllipsis, {}));
static_assert (!is_trivially_constructible_type (^^N1::Any, {}));
static_assert (!is_trivially_constructible_type (^^N1::DelCopy, {}));
static_assert (!is_trivially_constructible_type (^^N1::DelCopy, { ^^const N1::DelCopy & }));
static_assert (!is_trivially_constructible_type (^^N1::DelDtor, {}));
static_assert (!is_trivially_constructible_type (^^N1::Nontrivial, {}));
static_assert (!is_trivially_constructible_type (^^N1::UnusualCopy, {}));
static_assert (!is_trivially_constructible_type (^^CopyConsOnlyType, {}));
static_assert (!is_trivially_constructible_type (^^CopyConsOnlyType, { ^^CopyConsOnlyType }));
static_assert (is_trivially_constructible_type (^^CopyConsOnlyType, { ^^CopyConsOnlyType & }));
static_assert (!is_trivially_constructible_type (^^CopyConsOnlyType, { ^^CopyConsOnlyType && }));
static_assert (is_trivially_constructible_type (^^CopyConsOnlyType, { ^^const CopyConsOnlyType & }));
static_assert (!is_trivially_constructible_type (^^MoveConsOnlyType, {}));
static_assert (is_trivially_constructible_type (^^MoveConsOnlyType, { ^^MoveConsOnlyType }));
static_assert (!is_trivially_constructible_type (^^MoveConsOnlyType, { ^^MoveConsOnlyType & }));
static_assert (is_trivially_constructible_type (^^MoveConsOnlyType, { ^^MoveConsOnlyType && }));
static_assert (!is_trivially_constructible_type (^^MoveConsOnlyType, { ^^const MoveConsOnlyType & }));
static_assert (is_trivially_constructible_type (^^ClassType, { ^^DerivedType }));
static_assert (is_trivially_constructible_type (^^ClassType, { ^^DerivedType & }));
static_assert (is_trivially_constructible_type (^^ClassType, { ^^DerivedType && }));
static_assert (is_trivially_constructible_type (^^ClassType, { ^^const DerivedType & }));
static_assert (!is_trivially_constructible_type (^^HasTemplateCCtor, {}));
static_assert (!is_trivially_constructible_type (^^HasTemplateCCtor, { ^^HasTemplateCCtor }));
static_assert (is_trivially_constructible_type (^^HasTemplateCCtor, { ^^const HasTemplateCCtor & }));
static_assert (!is_trivially_constructible_type (^^MoveOnly, {}));
static_assert (is_trivially_constructible_type (^^MoveOnly, { ^^MoveOnly }));
static_assert (!is_trivially_constructible_type (^^MoveOnly, { ^^MoveOnly & }));
static_assert (is_trivially_constructible_type (^^MoveOnly, { ^^MoveOnly && }));
static_assert (!is_trivially_constructible_type (^^MoveOnly, { ^^const MoveOnly & }));
static_assert (!is_trivially_constructible_type (^^MoveOnly2, {}));
static_assert (!is_trivially_constructible_type (^^int [], {}));

static_assert (is_nothrow_constructible_type (^^NoexceptExplicitClass, { ^^double & }));
static_assert (is_nothrow_constructible_type (^^NoexceptExplicitClass, { ^^int & }));
static_assert (is_nothrow_constructible_type (^^NoexceptExplicitClass, { ^^double &, ^^int &, ^^double & }));
static_assert (is_nothrow_constructible_type (^^NothrowExplicitClass, { ^^double & }));
static_assert (is_nothrow_constructible_type (^^NothrowExplicitClass, { ^^int & }));
static_assert (is_nothrow_constructible_type (^^NothrowExplicitClass, { ^^double &, ^^int &, ^^double & }));
static_assert (is_nothrow_constructible_type (^^int [1], {}));
static_assert (!is_nothrow_constructible_type (^^NoexceptExplicitClass, { ^^void * }));
static_assert (!is_nothrow_constructible_type (^^NoexceptExplicitClass, {}));
static_assert (!is_nothrow_constructible_type (^^NoexceptExplicitClass, { ^^int, ^^double }));
static_assert (!is_nothrow_constructible_type (^^NothrowExplicitClass, { ^^void * }));
static_assert (!is_nothrow_constructible_type (^^NothrowExplicitClass, {}));
static_assert (!is_nothrow_constructible_type (^^NothrowExplicitClass, { ^^int, ^^double }));
static_assert (!is_nothrow_constructible_type (^^ExceptExplicitClass, { ^^double & }));
static_assert (!is_nothrow_constructible_type (^^ExceptExplicitClass, { ^^int & }));
static_assert (!is_nothrow_constructible_type (^^ExceptExplicitClass, { ^^double &, ^^int &, ^^double & }));
static_assert (!is_nothrow_constructible_type (^^int [], {}));
static_assert (is_nothrow_constructible_type (^^int [1], {}));
static_assert (is_nothrow_constructible_type (^^int [1], { ^^int }));
static_assert (is_nothrow_constructible_type (^^int [2], { ^^int }));
static_assert (is_nothrow_constructible_type (^^int [2], { ^^int, ^^int }));
static_assert (!is_nothrow_constructible_type (^^int [1], { ^^int, ^^int }));
static_assert (!is_nothrow_constructible_type (^^int [], {}));
static_assert (!is_nothrow_constructible_type (^^int [], { ^^int }));
static_assert (!is_nothrow_constructible_type (^^int [], { ^^int, ^^int }));
static_assert (is_nothrow_constructible_type (^^X [2], {}));
static_assert (is_nothrow_constructible_type (^^X [1], { ^^X }));
static_assert (is_nothrow_constructible_type (^^X [1], { ^^int }));
static_assert (!is_nothrow_constructible_type (^^X [1], { ^^double }));
static_assert (!is_nothrow_constructible_type (^^X [2], { ^^int, ^^double }));
static_assert (is_nothrow_constructible_type (^^Y, {}));
static_assert (is_nothrow_constructible_type (^^Y, { ^^Y }));
static_assert (is_nothrow_constructible_type (^^Y, { ^^int }));
static_assert (!is_nothrow_constructible_type (^^Y, { ^^X }));
static_assert (is_nothrow_constructible_type (^^Y, { ^^int, ^^X }));
static_assert (is_nothrow_constructible_type (^^Y, { ^^int, ^^int }));
static_assert (!is_nothrow_constructible_type (^^Y, { ^^int, ^^double }));
static_assert (is_nothrow_constructible_type (^^Z, {}));
static_assert (is_nothrow_constructible_type (^^Z, { ^^Z }));
static_assert (is_nothrow_constructible_type (^^Z, { ^^Y }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^int }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^int, ^^X }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^int, ^^int }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^Y, ^^double }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^int, ^^double }));
static_assert (!is_nothrow_constructible_type (^^Z, { ^^X }));

using func_type_v0 = void (*) ();
using func_type_i0 = int (*) ();
using func_type_l0 = int &(*) ();
using func_type_ii = int (*) (int);
using func_type_il = int (*) (int &);
using func_type_ir = int (*) (int &&);
struct W { };

using mem_type_i = int W::*;
using memfun_type_i = int (W::*) ();
using memfun_type_iic = int &(W::*) (int &) const;
struct F {
  int &operator () ();
  long &operator () () const;
  short &operator () (int) &&;
  char &operator () (int) const &;
private:
  void operator () (int, int);
};
using CF = const F;
struct T { T (int) { } };
struct NT { NT (int) noexcept { } };
struct Ex { explicit Ex (int) noexcept { } };
using func_type = void (*) ();
using func_type_nt = void (*) () noexcept;
using mem_type = int W::*;
using memfun_type = int (W::*) ();
using memfun_type_nt = int (W::*) () noexcept;
struct F2 {
  int &operator () ();
  long &operator () () const noexcept;
  short &operator () (int) &&;
  char &operator () (int) const & noexcept;
private:
  void operator () (int, int) noexcept;
};
using CF2 = const F2;
struct FW { W operator () () const noexcept { return {}; } };
struct V { explicit V (W) noexcept; V (...); };

static_assert (is_invocable_type (^^func_type_v0, {}));
static_assert (!is_invocable_type (^^func_type_v0, { ^^int }));
static_assert (is_invocable_type (^^func_type_i0, {}));
static_assert (!is_invocable_type (^^func_type_i0, { ^^int }));
static_assert (is_invocable_type (^^func_type_l0, {}));
static_assert (!is_invocable_type (^^func_type_l0 (int), {}));
static_assert (!is_invocable_type (^^func_type_ii, {}));
static_assert (is_invocable_type (^^func_type_ii, { ^^int }));
static_assert (!is_invocable_type (^^func_type_il, {}));
static_assert (!is_invocable_type (^^func_type_il, { ^^int }));
static_assert (is_invocable_type (^^func_type_il, { ^^int & }));
static_assert (!is_invocable_type (^^func_type_ir, {}));
static_assert (is_invocable_type (^^func_type_ir, { ^^int }));
static_assert (!is_invocable_type (^^func_type_ir, { ^^int & }));
static_assert (!is_invocable_type (^^mem_type_i, {}));
static_assert (!is_invocable_type (^^mem_type_i, { ^^int }));
static_assert (!is_invocable_type (^^mem_type_i, { ^^int & }));
static_assert (is_invocable_type (^^mem_type_i, { ^^W & }));
static_assert (!is_invocable_type (^^memfun_type_i, {}));
static_assert (!is_invocable_type (^^memfun_type_i, { ^^int }));
static_assert (!is_invocable_type (^^memfun_type_i, { ^^int & }));
static_assert (is_invocable_type (^^memfun_type_i, { ^^W & }));
static_assert (is_invocable_type (^^memfun_type_i, { ^^W * }));
static_assert (!is_invocable_type (^^memfun_type_i, { ^^const W & }));
static_assert (!is_invocable_type (^^memfun_type_i, { ^^W &, ^^int }));
static_assert (!is_invocable_type (^^memfun_type_iic, {}));
static_assert (!is_invocable_type (^^memfun_type_iic, { ^^int }));
static_assert (!is_invocable_type (^^memfun_type_iic, { ^^int & }));
static_assert (!is_invocable_type (^^memfun_type_iic, { ^^W &, ^^int }));
static_assert (!is_invocable_type (^^memfun_type_iic, { ^^const W &, ^^int }));
static_assert (!is_invocable_type (^^memfun_type_iic, { ^^const W &, ^^int &, ^^int }));
static_assert (is_invocable_type (^^memfun_type_iic, { ^^const W &, ^^int & }));
static_assert (is_invocable_type (^^memfun_type_iic, { ^^const W *, ^^int & }));
static_assert (!is_invocable_type (^^F, { ^^int, ^^int }));

static_assert (!is_nothrow_invocable_type (^^func_type, {}));
static_assert (is_nothrow_invocable_type (^^func_type_nt, {}));
static_assert (!is_nothrow_invocable_type (^^mem_type, {}));
static_assert (!is_nothrow_invocable_type (^^mem_type, { ^^int }));
static_assert (!is_nothrow_invocable_type (^^mem_type, { ^^int & }));
static_assert (is_nothrow_invocable_type (^^mem_type, { ^^W & }));
static_assert (!is_nothrow_invocable_type (^^memfun_type, {}));
static_assert (!is_nothrow_invocable_type (^^memfun_type, { ^^int }));
static_assert (!is_nothrow_invocable_type (^^memfun_type, { ^^int & }));
static_assert (!is_nothrow_invocable_type (^^memfun_type, { ^^W & }));
static_assert (!is_nothrow_invocable_type (^^memfun_type, { ^^W * }));
static_assert (!is_nothrow_invocable_type (^^memfun_type_nt, {}));
static_assert (!is_nothrow_invocable_type (^^memfun_type_nt, { ^^int }));
static_assert (!is_nothrow_invocable_type (^^memfun_type_nt, { ^^int & }));
static_assert (is_nothrow_invocable_type (^^memfun_type_nt, { ^^W & }));
static_assert (is_nothrow_invocable_type (^^memfun_type_nt, { ^^W * }));
static_assert (!is_nothrow_invocable_type (^^F2, {}));
static_assert (is_nothrow_invocable_type (^^CF2, {}));
static_assert (!is_nothrow_invocable_type (^^F2, { ^^int }));
static_assert (is_nothrow_invocable_type (^^F2 &, { ^^int }));
static_assert (is_nothrow_invocable_type (^^CF2, { ^^int }));
static_assert (is_nothrow_invocable_type (^^CF2 &, { ^^int }));
static_assert (!is_nothrow_invocable_type (^^F2, { ^^int, ^^int }));
static_assert (is_nothrow_invocable_type (^^FW, {}));

static_assert (is_invocable_r_type (^^void, ^^func_type_v0, {}));
static_assert (!is_invocable_r_type (^^void *, ^^func_type_v0, {}));
static_assert (!is_invocable_r_type (^^int, ^^func_type_v0, {}));
static_assert (!is_invocable_r_type (^^void, ^^func_type_v0, { ^^int }));
static_assert (!is_invocable_r_type (^^void *, ^^func_type_v0, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_v0, { ^^int }));
static_assert (is_invocable_r_type (^^void, ^^func_type_i0, {}));
static_assert (is_invocable_r_type (^^int, ^^func_type_i0, {}));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_i0, {}));
static_assert (is_invocable_r_type (^^long, ^^func_type_i0, {}));
static_assert (!is_invocable_r_type (^^void, ^^func_type_i0, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_i0, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_i0, { ^^int }));
static_assert (!is_invocable_r_type (^^long, ^^func_type_i0, { ^^int }));
static_assert (is_invocable_r_type (^^void, ^^func_type_l0, {}));
static_assert (is_invocable_r_type (^^int, ^^func_type_l0, {}));
static_assert (is_invocable_r_type (^^int &, ^^func_type_l0, {}));
static_assert (!is_invocable_r_type (^^int &&, ^^func_type_l0, {}));
static_assert (is_invocable_r_type (^^long, ^^func_type_l0, {}));
static_assert (!is_invocable_r_type (^^long &, ^^func_type_l0, {}));
static_assert (!is_invocable_r_type (^^void, ^^func_type_l0, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_l0, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_l0, { ^^int }));
static_assert (!is_invocable_r_type (^^long, ^^func_type_l0, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_ii, {}));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_ii, {}));
static_assert (!is_invocable_r_type (^^long, ^^func_type_ii, {}));
static_assert (is_invocable_r_type (^^int, ^^func_type_ii, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_ii, { ^^int }));
static_assert (is_invocable_r_type (^^long, ^^func_type_ii, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_il, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_il, { ^^int }));
static_assert (!is_invocable_r_type (^^long, ^^func_type_il, { ^^int }));
static_assert (is_invocable_r_type (^^int, ^^func_type_il, { ^^int & }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_il, { ^^int & }));
static_assert (is_invocable_r_type (^^long, ^^func_type_il, { ^^int & }));
static_assert (is_invocable_r_type (^^int, ^^func_type_ir, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_ir, { ^^int }));
static_assert (is_invocable_r_type (^^long, ^^func_type_ir, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^func_type_ir, { ^^int & }));
static_assert (!is_invocable_r_type (^^int &, ^^func_type_ir, { ^^int & }));
static_assert (!is_invocable_r_type (^^long, ^^func_type_ir, { ^^int & }));
static_assert (!is_invocable_r_type (^^int, ^^mem_type_i, { ^^int }));
static_assert (!is_invocable_r_type (^^int &, ^^mem_type_i, { ^^int }));
static_assert (!is_invocable_r_type (^^long, ^^mem_type_i, { ^^int }));
static_assert (!is_invocable_r_type (^^int, ^^mem_type_i, { ^^int & }));
static_assert (!is_invocable_r_type (^^int &, ^^mem_type_i, { ^^int & }));
static_assert (!is_invocable_r_type (^^long, ^^mem_type_i, { ^^int & }));
static_assert (is_invocable_r_type (^^int, ^^mem_type_i, { ^^W & }));
static_assert (is_invocable_r_type (^^int &, ^^mem_type_i, { ^^W & }));
static_assert (is_invocable_r_type (^^long, ^^mem_type_i, { ^^W & }));
static_assert (is_invocable_r_type (^^int, ^^memfun_type_i, { ^^W & }));
static_assert (!is_invocable_r_type (^^int &, ^^memfun_type_i, { ^^W & }));
static_assert (is_invocable_r_type (^^long, ^^memfun_type_i, { ^^W & }));
static_assert (!is_invocable_r_type (^^int, ^^memfun_type_i, { ^^const W & }));
static_assert (is_invocable_r_type (^^int, ^^memfun_type_iic, { ^^const W &, ^^int & }));
static_assert (is_invocable_r_type (^^int &, ^^memfun_type_iic, { ^^const W &, ^^int & }));
static_assert (is_invocable_r_type (^^long, ^^memfun_type_iic, { ^^const W &, ^^int & }));
static_assert (!is_invocable_r_type (^^long &, ^^memfun_type_iic, { ^^const W &, ^^int & }));
static_assert (is_invocable_r_type (^^int &, ^^F, {}));
static_assert (is_invocable_r_type (^^int &, ^^F &, {}));
static_assert (is_invocable_r_type (^^long &, ^^CF, {}));
static_assert (is_invocable_r_type (^^long &, ^^CF &, {}));
static_assert (is_invocable_r_type (^^short &, ^^F, { ^^int }));
static_assert (is_invocable_r_type (^^char &, ^^F &, { ^^int }));
static_assert (is_invocable_r_type (^^char &, ^^CF, { ^^int }));
static_assert (is_invocable_r_type (^^char &, ^^CF &, { ^^int }));

static_assert (is_nothrow_invocable_r_type (^^int, ^^mem_type, { ^^W & }));
static_assert (is_nothrow_invocable_r_type (^^int &, ^^mem_type, { ^^W & }));
static_assert (is_nothrow_invocable_r_type (^^long, ^^mem_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^long &, ^^mem_type, { ^^W & }));
static_assert (is_nothrow_invocable_r_type (^^int &, ^^mem_type, { ^^W * }));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^mem_type, { ^^W & }));
static_assert (is_nothrow_invocable_r_type (^^NT, ^^mem_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^mem_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^memfun_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^NT, ^^memfun_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^memfun_type, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^memfun_type_nt, { ^^W & }));
static_assert (is_nothrow_invocable_r_type (^^NT, ^^memfun_type_nt, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^memfun_type_nt, { ^^W & }));
static_assert (!is_nothrow_invocable_r_type (^^int &, ^^F2, {}));
static_assert (is_nothrow_invocable_r_type (^^long &, ^^CF2, {}));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^F2, {}));
static_assert (!is_nothrow_invocable_r_type (^^NT, ^^F2, {}));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^F2, {}));
static_assert (!is_nothrow_invocable_r_type (^^void, ^^F2, {}));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^CF2, {}));
static_assert (is_nothrow_invocable_r_type (^^NT, ^^CF2, {}));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^CF2, {}));
static_assert (is_nothrow_invocable_r_type (^^void, ^^CF2, {}));
static_assert (!is_nothrow_invocable_r_type (^^short &, ^^F2, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^char &, ^^F2 &, { ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^F2 &, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^NT, ^^F2 &, { ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^F2 &, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^char &, ^^CF2, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^char &, ^^CF2 &, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^void, ^^CF2 &, { ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^T, ^^CF2 &, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^NT, ^^CF2 &, { ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^Ex, ^^CF2 &, { ^^int }));
static_assert (is_nothrow_invocable_r_type (^^void, ^^CF2 &, { ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^void, ^^F2, { ^^int, ^^int }));
static_assert (!is_nothrow_invocable_r_type (^^V, ^^FW, {}));

static_assert (invoke_result (^^std::copyable_function <void ()>, {}) == ^^void);
static_assert (invoke_result (^^std::copyable_function <int ()>, {}) == ^^int);
static_assert (invoke_result (^^std::copyable_function <int & ()>, {}) == ^^int &);
static_assert (invoke_result (^^std::copyable_function <void (long, int)>, { ^^long, ^^int }) == ^^void);
static_assert (invoke_result (^^std::copyable_function <int (double, unsigned)>, { ^^double, ^^unsigned }) == ^^int);
static_assert (invoke_result (^^std::copyable_function <int & (int &)>, { ^^int & }) == ^^int &);
