// Code generated via go generate from gen_breaktest.go. DO NOT EDIT.

package uniseg

// wordBreakTestCases are Grapheme testcases taken from
// https://www.unicode.org/Public/15.0.0/ucd/auxiliary/WordBreakTest.txt
// on September 5, 2023. See
// https://www.unicode.org/license.html for the Unicode license agreement.
var wordBreakTestCases = []testCase{
	{original: "\u0001\u0001", expected: [][]rune{{0x0001}, {0x0001}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0001\u0308\u0001", expected: [][]rune{{0x0001, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0001\u000D", expected: [][]rune{{0x0001}, {0x000D}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u0308\u000D", expected: [][]rune{{0x0001, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0001\u000A", expected: [][]rune{{0x0001}, {0x000A}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u0308\u000A", expected: [][]rune{{0x0001, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0001\u000B", expected: [][]rune{{0x0001}, {0x000B}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0001\u0308\u000B", expected: [][]rune{{0x0001, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0001\u3031", expected: [][]rune{{0x0001}, {0x3031}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0001\u0308\u3031", expected: [][]rune{{0x0001, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0001\u0041", expected: [][]rune{{0x0001}, {0x0041}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0001\u0308\u0041", expected: [][]rune{{0x0001, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0001\u003A", expected: [][]rune{{0x0001}, {0x003A}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u0308\u003A", expected: [][]rune{{0x0001, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u002C", expected: [][]rune{{0x0001}, {0x002C}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u0308\u002C", expected: [][]rune{{0x0001, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u002E", expected: [][]rune{{0x0001}, {0x002E}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0001\u0308\u002E", expected: [][]rune{{0x0001, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0001\u0030", expected: [][]rune{{0x0001}, {0x0030}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0001\u0308\u0030", expected: [][]rune{{0x0001, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0001\u005F", expected: [][]rune{{0x0001}, {0x005F}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0001\u0308\u005F", expected: [][]rune{{0x0001, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0001\U0001F1E6", expected: [][]rune{{0x0001}, {0x1F1E6}}},                                                                            // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0001\u0308\U0001F1E6", expected: [][]rune{{0x0001, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0001\u05D0", expected: [][]rune{{0x0001}, {0x05D0}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0001\u0308\u05D0", expected: [][]rune{{0x0001, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0001\u0022", expected: [][]rune{{0x0001}, {0x0022}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0001\u0308\u0022", expected: [][]rune{{0x0001, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0001\u0027", expected: [][]rune{{0x0001}, {0x0027}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u0308\u0027", expected: [][]rune{{0x0001, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u231A", expected: [][]rune{{0x0001}, {0x231A}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0001\u0308\u231A", expected: [][]rune{{0x0001, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0001\u0020", expected: [][]rune{{0x0001}, {0x0020}}},                                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0001\u0308\u0020", expected: [][]rune{{0x0001, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0001\u00AD", expected: [][]rune{{0x0001, 0x00AD}}},                                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0001\u0308\u00AD", expected: [][]rune{{0x0001, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0001\u0300", expected: [][]rune{{0x0001, 0x0300}}},                                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0001\u0308\u0300", expected: [][]rune{{0x0001, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0001\u200D", expected: [][]rune{{0x0001, 0x200D}}},                                                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0001\u0308\u200D", expected: [][]rune{{0x0001, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0001\u0061\u2060", expected: [][]rune{{0x0001}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0001\u0308\u0061\u2060", expected: [][]rune{{0x0001, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0001\u0061\u003A", expected: [][]rune{{0x0001}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u0308\u0061\u003A", expected: [][]rune{{0x0001, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u0061\u0027", expected: [][]rune{{0x0001}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u0308\u0061\u0027", expected: [][]rune{{0x0001, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u0061\u0027\u2060", expected: [][]rune{{0x0001}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0001\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0001, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0001\u0061\u002C", expected: [][]rune{{0x0001}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u0308\u0061\u002C", expected: [][]rune{{0x0001, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u0031\u003A", expected: [][]rune{{0x0001}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u0308\u0031\u003A", expected: [][]rune{{0x0001, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0001\u0031\u0027", expected: [][]rune{{0x0001}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u0308\u0031\u0027", expected: [][]rune{{0x0001, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0001\u0031\u002C", expected: [][]rune{{0x0001}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u0308\u0031\u002C", expected: [][]rune{{0x0001, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0001\u0031\u002E\u2060", expected: [][]rune{{0x0001}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0001\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0001, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0001", expected: [][]rune{{0x000D}, {0x0001}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000D\u0308\u0001", expected: [][]rune{{0x000D}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000D\u000D", expected: [][]rune{{0x000D}, {0x000D}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u0308\u000D", expected: [][]rune{{0x000D}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000D\u000A", expected: [][]rune{{0x000D, 0x000A}}},                                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u0308\u000A", expected: [][]rune{{0x000D}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000D\u000B", expected: [][]rune{{0x000D}, {0x000B}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000D\u0308\u000B", expected: [][]rune{{0x000D}, {0x0308}, {0x000B}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000D\u3031", expected: [][]rune{{0x000D}, {0x3031}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000D\u0308\u3031", expected: [][]rune{{0x000D}, {0x0308}, {0x3031}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000D\u0041", expected: [][]rune{{0x000D}, {0x0041}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000D\u0308\u0041", expected: [][]rune{{0x000D}, {0x0308}, {0x0041}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000D\u003A", expected: [][]rune{{0x000D}, {0x003A}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u0308\u003A", expected: [][]rune{{0x000D}, {0x0308}, {0x003A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u002C", expected: [][]rune{{0x000D}, {0x002C}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u0308\u002C", expected: [][]rune{{0x000D}, {0x0308}, {0x002C}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u002E", expected: [][]rune{{0x000D}, {0x002E}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000D\u0308\u002E", expected: [][]rune{{0x000D}, {0x0308}, {0x002E}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000D\u0030", expected: [][]rune{{0x000D}, {0x0030}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000D\u0308\u0030", expected: [][]rune{{0x000D}, {0x0308}, {0x0030}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000D\u005F", expected: [][]rune{{0x000D}, {0x005F}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000D\u0308\u005F", expected: [][]rune{{0x000D}, {0x0308}, {0x005F}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000D\U0001F1E6", expected: [][]rune{{0x000D}, {0x1F1E6}}},                                                                            // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u0308\U0001F1E6", expected: [][]rune{{0x000D}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000D\u05D0", expected: [][]rune{{0x000D}, {0x05D0}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000D\u0308\u05D0", expected: [][]rune{{0x000D}, {0x0308}, {0x05D0}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000D\u0022", expected: [][]rune{{0x000D}, {0x0022}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000D\u0308\u0022", expected: [][]rune{{0x000D}, {0x0308}, {0x0022}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000D\u0027", expected: [][]rune{{0x000D}, {0x0027}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u0308\u0027", expected: [][]rune{{0x000D}, {0x0308}, {0x0027}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u231A", expected: [][]rune{{0x000D}, {0x231A}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000D\u0308\u231A", expected: [][]rune{{0x000D}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000D\u0020", expected: [][]rune{{0x000D}, {0x0020}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000D\u0308\u0020", expected: [][]rune{{0x000D}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000D\u00AD", expected: [][]rune{{0x000D}, {0x00AD}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000D\u0308\u00AD", expected: [][]rune{{0x000D}, {0x0308, 0x00AD}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000D\u0300", expected: [][]rune{{0x000D}, {0x0300}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000D\u0308\u0300", expected: [][]rune{{0x000D}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000D\u200D", expected: [][]rune{{0x000D}, {0x200D}}},                                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000D\u0308\u200D", expected: [][]rune{{0x000D}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000D\u0061\u2060", expected: [][]rune{{0x000D}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0308\u0061\u2060", expected: [][]rune{{0x000D}, {0x0308}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0061\u003A", expected: [][]rune{{0x000D}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u0308\u0061\u003A", expected: [][]rune{{0x000D}, {0x0308}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u0061\u0027", expected: [][]rune{{0x000D}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u0308\u0061\u0027", expected: [][]rune{{0x000D}, {0x0308}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u0061\u0027\u2060", expected: [][]rune{{0x000D}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0308\u0061\u0027\u2060", expected: [][]rune{{0x000D}, {0x0308}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0061\u002C", expected: [][]rune{{0x000D}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u0308\u0061\u002C", expected: [][]rune{{0x000D}, {0x0308}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u0031\u003A", expected: [][]rune{{0x000D}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u0308\u0031\u003A", expected: [][]rune{{0x000D}, {0x0308}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000D\u0031\u0027", expected: [][]rune{{0x000D}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u0308\u0031\u0027", expected: [][]rune{{0x000D}, {0x0308}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000D\u0031\u002C", expected: [][]rune{{0x000D}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u0308\u0031\u002C", expected: [][]rune{{0x000D}, {0x0308}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000D\u0031\u002E\u2060", expected: [][]rune{{0x000D}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u0308\u0031\u002E\u2060", expected: [][]rune{{0x000D}, {0x0308}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0001", expected: [][]rune{{0x000A}, {0x0001}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000A\u0308\u0001", expected: [][]rune{{0x000A}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000A\u000D", expected: [][]rune{{0x000A}, {0x000D}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u0308\u000D", expected: [][]rune{{0x000A}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000A\u000A", expected: [][]rune{{0x000A}, {0x000A}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u0308\u000A", expected: [][]rune{{0x000A}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000A\u000B", expected: [][]rune{{0x000A}, {0x000B}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000A\u0308\u000B", expected: [][]rune{{0x000A}, {0x0308}, {0x000B}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000A\u3031", expected: [][]rune{{0x000A}, {0x3031}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000A\u0308\u3031", expected: [][]rune{{0x000A}, {0x0308}, {0x3031}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000A\u0041", expected: [][]rune{{0x000A}, {0x0041}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000A\u0308\u0041", expected: [][]rune{{0x000A}, {0x0308}, {0x0041}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000A\u003A", expected: [][]rune{{0x000A}, {0x003A}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u0308\u003A", expected: [][]rune{{0x000A}, {0x0308}, {0x003A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u002C", expected: [][]rune{{0x000A}, {0x002C}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u0308\u002C", expected: [][]rune{{0x000A}, {0x0308}, {0x002C}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u002E", expected: [][]rune{{0x000A}, {0x002E}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000A\u0308\u002E", expected: [][]rune{{0x000A}, {0x0308}, {0x002E}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000A\u0030", expected: [][]rune{{0x000A}, {0x0030}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000A\u0308\u0030", expected: [][]rune{{0x000A}, {0x0308}, {0x0030}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000A\u005F", expected: [][]rune{{0x000A}, {0x005F}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000A\u0308\u005F", expected: [][]rune{{0x000A}, {0x0308}, {0x005F}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000A\U0001F1E6", expected: [][]rune{{0x000A}, {0x1F1E6}}},                                                                            // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000A\u0308\U0001F1E6", expected: [][]rune{{0x000A}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000A\u05D0", expected: [][]rune{{0x000A}, {0x05D0}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000A\u0308\u05D0", expected: [][]rune{{0x000A}, {0x0308}, {0x05D0}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000A\u0022", expected: [][]rune{{0x000A}, {0x0022}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000A\u0308\u0022", expected: [][]rune{{0x000A}, {0x0308}, {0x0022}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000A\u0027", expected: [][]rune{{0x000A}, {0x0027}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u0308\u0027", expected: [][]rune{{0x000A}, {0x0308}, {0x0027}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u231A", expected: [][]rune{{0x000A}, {0x231A}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000A\u0308\u231A", expected: [][]rune{{0x000A}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000A\u0020", expected: [][]rune{{0x000A}, {0x0020}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000A\u0308\u0020", expected: [][]rune{{0x000A}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000A\u00AD", expected: [][]rune{{0x000A}, {0x00AD}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000A\u0308\u00AD", expected: [][]rune{{0x000A}, {0x0308, 0x00AD}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000A\u0300", expected: [][]rune{{0x000A}, {0x0300}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000A\u0308\u0300", expected: [][]rune{{0x000A}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000A\u200D", expected: [][]rune{{0x000A}, {0x200D}}},                                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000A\u0308\u200D", expected: [][]rune{{0x000A}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000A\u0061\u2060", expected: [][]rune{{0x000A}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0308\u0061\u2060", expected: [][]rune{{0x000A}, {0x0308}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0061\u003A", expected: [][]rune{{0x000A}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u0308\u0061\u003A", expected: [][]rune{{0x000A}, {0x0308}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u0061\u0027", expected: [][]rune{{0x000A}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u0308\u0061\u0027", expected: [][]rune{{0x000A}, {0x0308}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u0061\u0027\u2060", expected: [][]rune{{0x000A}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0308\u0061\u0027\u2060", expected: [][]rune{{0x000A}, {0x0308}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0061\u002C", expected: [][]rune{{0x000A}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u0308\u0061\u002C", expected: [][]rune{{0x000A}, {0x0308}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u0031\u003A", expected: [][]rune{{0x000A}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u0308\u0031\u003A", expected: [][]rune{{0x000A}, {0x0308}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000A\u0031\u0027", expected: [][]rune{{0x000A}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u0308\u0031\u0027", expected: [][]rune{{0x000A}, {0x0308}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000A\u0031\u002C", expected: [][]rune{{0x000A}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u0308\u0031\u002C", expected: [][]rune{{0x000A}, {0x0308}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000A\u0031\u002E\u2060", expected: [][]rune{{0x000A}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000A\u0308\u0031\u002E\u2060", expected: [][]rune{{0x000A}, {0x0308}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0001", expected: [][]rune{{0x000B}, {0x0001}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000B\u0308\u0001", expected: [][]rune{{0x000B}, {0x0308}, {0x0001}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u000B\u000D", expected: [][]rune{{0x000B}, {0x000D}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u0308\u000D", expected: [][]rune{{0x000B}, {0x0308}, {0x000D}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u000B\u000A", expected: [][]rune{{0x000B}, {0x000A}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u0308\u000A", expected: [][]rune{{0x000B}, {0x0308}, {0x000A}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u000B\u000B", expected: [][]rune{{0x000B}, {0x000B}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000B\u0308\u000B", expected: [][]rune{{0x000B}, {0x0308}, {0x000B}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u000B\u3031", expected: [][]rune{{0x000B}, {0x3031}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000B\u0308\u3031", expected: [][]rune{{0x000B}, {0x0308}, {0x3031}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u000B\u0041", expected: [][]rune{{0x000B}, {0x0041}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000B\u0308\u0041", expected: [][]rune{{0x000B}, {0x0308}, {0x0041}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u000B\u003A", expected: [][]rune{{0x000B}, {0x003A}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u0308\u003A", expected: [][]rune{{0x000B}, {0x0308}, {0x003A}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u002C", expected: [][]rune{{0x000B}, {0x002C}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u0308\u002C", expected: [][]rune{{0x000B}, {0x0308}, {0x002C}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u002E", expected: [][]rune{{0x000B}, {0x002E}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000B\u0308\u002E", expected: [][]rune{{0x000B}, {0x0308}, {0x002E}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u000B\u0030", expected: [][]rune{{0x000B}, {0x0030}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000B\u0308\u0030", expected: [][]rune{{0x000B}, {0x0308}, {0x0030}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u000B\u005F", expected: [][]rune{{0x000B}, {0x005F}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000B\u0308\u005F", expected: [][]rune{{0x000B}, {0x0308}, {0x005F}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u000B\U0001F1E6", expected: [][]rune{{0x000B}, {0x1F1E6}}},                                                                            // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u0308\U0001F1E6", expected: [][]rune{{0x000B}, {0x0308}, {0x1F1E6}}},                                                            // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u000B\u05D0", expected: [][]rune{{0x000B}, {0x05D0}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000B\u0308\u05D0", expected: [][]rune{{0x000B}, {0x0308}, {0x05D0}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u000B\u0022", expected: [][]rune{{0x000B}, {0x0022}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000B\u0308\u0022", expected: [][]rune{{0x000B}, {0x0308}, {0x0022}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u000B\u0027", expected: [][]rune{{0x000B}, {0x0027}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u0308\u0027", expected: [][]rune{{0x000B}, {0x0308}, {0x0027}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u231A", expected: [][]rune{{0x000B}, {0x231A}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000B\u0308\u231A", expected: [][]rune{{0x000B}, {0x0308}, {0x231A}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u000B\u0020", expected: [][]rune{{0x000B}, {0x0020}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000B\u0308\u0020", expected: [][]rune{{0x000B}, {0x0308}, {0x0020}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u000B\u00AD", expected: [][]rune{{0x000B}, {0x00AD}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000B\u0308\u00AD", expected: [][]rune{{0x000B}, {0x0308, 0x00AD}}},                                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u000B\u0300", expected: [][]rune{{0x000B}, {0x0300}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000B\u0308\u0300", expected: [][]rune{{0x000B}, {0x0308, 0x0300}}},                                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u000B\u200D", expected: [][]rune{{0x000B}, {0x200D}}},                                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000B\u0308\u200D", expected: [][]rune{{0x000B}, {0x0308, 0x200D}}},                                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u000B\u0061\u2060", expected: [][]rune{{0x000B}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0308\u0061\u2060", expected: [][]rune{{0x000B}, {0x0308}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0061\u003A", expected: [][]rune{{0x000B}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u0308\u0061\u003A", expected: [][]rune{{0x000B}, {0x0308}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u0061\u0027", expected: [][]rune{{0x000B}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u0308\u0061\u0027", expected: [][]rune{{0x000B}, {0x0308}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u0061\u0027\u2060", expected: [][]rune{{0x000B}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0308\u0061\u0027\u2060", expected: [][]rune{{0x000B}, {0x0308}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0061\u002C", expected: [][]rune{{0x000B}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u0308\u0061\u002C", expected: [][]rune{{0x000B}, {0x0308}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u0031\u003A", expected: [][]rune{{0x000B}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u0308\u0031\u003A", expected: [][]rune{{0x000B}, {0x0308}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u000B\u0031\u0027", expected: [][]rune{{0x000B}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u0308\u0031\u0027", expected: [][]rune{{0x000B}, {0x0308}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u000B\u0031\u002C", expected: [][]rune{{0x000B}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u0308\u0031\u002C", expected: [][]rune{{0x000B}, {0x0308}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u000B\u0031\u002E\u2060", expected: [][]rune{{0x000B}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000B\u0308\u0031\u002E\u2060", expected: [][]rune{{0x000B}, {0x0308}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0001", expected: [][]rune{{0x3031}, {0x0001}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u3031\u0308\u0001", expected: [][]rune{{0x3031, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u3031\u000D", expected: [][]rune{{0x3031}, {0x000D}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u3031\u0308\u000D", expected: [][]rune{{0x3031, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u3031\u000A", expected: [][]rune{{0x3031}, {0x000A}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u3031\u0308\u000A", expected: [][]rune{{0x3031, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u3031\u000B", expected: [][]rune{{0x3031}, {0x000B}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u3031\u0308\u000B", expected: [][]rune{{0x3031, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u3031\u3031", expected: [][]rune{{0x3031, 0x3031}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u3031\u0308\u3031", expected: [][]rune{{0x3031, 0x0308, 0x3031}}},                                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u3031\u0041", expected: [][]rune{{0x3031}, {0x0041}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u3031\u0308\u0041", expected: [][]rune{{0x3031, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u3031\u003A", expected: [][]rune{{0x3031}, {0x003A}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u0308\u003A", expected: [][]rune{{0x3031, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u002C", expected: [][]rune{{0x3031}, {0x002C}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u0308\u002C", expected: [][]rune{{0x3031, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u002E", expected: [][]rune{{0x3031}, {0x002E}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u3031\u0308\u002E", expected: [][]rune{{0x3031, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u3031\u0030", expected: [][]rune{{0x3031}, {0x0030}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u3031\u0308\u0030", expected: [][]rune{{0x3031, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u3031\u005F", expected: [][]rune{{0x3031, 0x005F}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u3031\u0308\u005F", expected: [][]rune{{0x3031, 0x0308, 0x005F}}},                                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u3031\U0001F1E6", expected: [][]rune{{0x3031}, {0x1F1E6}}},                                                                            // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u3031\u0308\U0001F1E6", expected: [][]rune{{0x3031, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u3031\u05D0", expected: [][]rune{{0x3031}, {0x05D0}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u3031\u0308\u05D0", expected: [][]rune{{0x3031, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u3031\u0022", expected: [][]rune{{0x3031}, {0x0022}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u3031\u0308\u0022", expected: [][]rune{{0x3031, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u3031\u0027", expected: [][]rune{{0x3031}, {0x0027}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u0308\u0027", expected: [][]rune{{0x3031, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u231A", expected: [][]rune{{0x3031}, {0x231A}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u3031\u0308\u231A", expected: [][]rune{{0x3031, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u3031\u0020", expected: [][]rune{{0x3031}, {0x0020}}},                                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u3031\u0308\u0020", expected: [][]rune{{0x3031, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u3031\u00AD", expected: [][]rune{{0x3031, 0x00AD}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u3031\u0308\u00AD", expected: [][]rune{{0x3031, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u3031\u0300", expected: [][]rune{{0x3031, 0x0300}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u3031\u0308\u0300", expected: [][]rune{{0x3031, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u3031\u200D", expected: [][]rune{{0x3031, 0x200D}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u3031\u0308\u200D", expected: [][]rune{{0x3031, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u3031\u0061\u2060", expected: [][]rune{{0x3031}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0308\u0061\u2060", expected: [][]rune{{0x3031, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0061\u003A", expected: [][]rune{{0x3031}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u0308\u0061\u003A", expected: [][]rune{{0x3031, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u0061\u0027", expected: [][]rune{{0x3031}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u0308\u0061\u0027", expected: [][]rune{{0x3031, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u0061\u0027\u2060", expected: [][]rune{{0x3031}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0308\u0061\u0027\u2060", expected: [][]rune{{0x3031, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0061\u002C", expected: [][]rune{{0x3031}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u0308\u0061\u002C", expected: [][]rune{{0x3031, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u0031\u003A", expected: [][]rune{{0x3031}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u0308\u0031\u003A", expected: [][]rune{{0x3031, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u3031\u0031\u0027", expected: [][]rune{{0x3031}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u0308\u0031\u0027", expected: [][]rune{{0x3031, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u3031\u0031\u002C", expected: [][]rune{{0x3031}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u0308\u0031\u002C", expected: [][]rune{{0x3031, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u3031\u0031\u002E\u2060", expected: [][]rune{{0x3031}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u3031\u0308\u0031\u002E\u2060", expected: [][]rune{{0x3031, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0001", expected: [][]rune{{0x0041}, {0x0001}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0041\u0308\u0001", expected: [][]rune{{0x0041, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0041\u000D", expected: [][]rune{{0x0041}, {0x000D}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0041\u0308\u000D", expected: [][]rune{{0x0041, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0041\u000A", expected: [][]rune{{0x0041}, {0x000A}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0041\u0308\u000A", expected: [][]rune{{0x0041, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0041\u000B", expected: [][]rune{{0x0041}, {0x000B}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0041\u0308\u000B", expected: [][]rune{{0x0041, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0041\u3031", expected: [][]rune{{0x0041}, {0x3031}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0041\u0308\u3031", expected: [][]rune{{0x0041, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0041\u0041", expected: [][]rune{{0x0041, 0x0041}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0041\u0308\u0041", expected: [][]rune{{0x0041, 0x0308, 0x0041}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0041\u003A", expected: [][]rune{{0x0041}, {0x003A}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u0308\u003A", expected: [][]rune{{0x0041, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u002C", expected: [][]rune{{0x0041}, {0x002C}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u0308\u002C", expected: [][]rune{{0x0041, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u002E", expected: [][]rune{{0x0041}, {0x002E}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0041\u0308\u002E", expected: [][]rune{{0x0041, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0041\u0030", expected: [][]rune{{0x0041, 0x0030}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0041\u0308\u0030", expected: [][]rune{{0x0041, 0x0308, 0x0030}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0041\u005F", expected: [][]rune{{0x0041, 0x005F}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0041\u0308\u005F", expected: [][]rune{{0x0041, 0x0308, 0x005F}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0041\U0001F1E6", expected: [][]rune{{0x0041}, {0x1F1E6}}},                                                                            // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0041\u0308\U0001F1E6", expected: [][]rune{{0x0041, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0041\u05D0", expected: [][]rune{{0x0041, 0x05D0}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0041\u0308\u05D0", expected: [][]rune{{0x0041, 0x0308, 0x05D0}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0041\u0022", expected: [][]rune{{0x0041}, {0x0022}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0041\u0308\u0022", expected: [][]rune{{0x0041, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0041\u0027", expected: [][]rune{{0x0041}, {0x0027}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u0308\u0027", expected: [][]rune{{0x0041, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u231A", expected: [][]rune{{0x0041}, {0x231A}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0041\u0308\u231A", expected: [][]rune{{0x0041, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0041\u0020", expected: [][]rune{{0x0041}, {0x0020}}},                                                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0041\u0308\u0020", expected: [][]rune{{0x0041, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0041\u00AD", expected: [][]rune{{0x0041, 0x00AD}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0041\u0308\u00AD", expected: [][]rune{{0x0041, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0041\u0300", expected: [][]rune{{0x0041, 0x0300}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0041\u0308\u0300", expected: [][]rune{{0x0041, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0041\u200D", expected: [][]rune{{0x0041, 0x200D}}},                                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0041\u0308\u200D", expected: [][]rune{{0x0041, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0041\u0061\u2060", expected: [][]rune{{0x0041, 0x0061, 0x2060}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0308\u0061\u2060", expected: [][]rune{{0x0041, 0x0308, 0x0061, 0x2060}}},                                                       // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0061\u003A", expected: [][]rune{{0x0041, 0x0061}, {0x003A}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u0308\u0061\u003A", expected: [][]rune{{0x0041, 0x0308, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u0061\u0027", expected: [][]rune{{0x0041, 0x0061}, {0x0027}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u0308\u0061\u0027", expected: [][]rune{{0x0041, 0x0308, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u0061\u0027\u2060", expected: [][]rune{{0x0041, 0x0061}, {0x0027, 0x2060}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0041, 0x0308, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0061\u002C", expected: [][]rune{{0x0041, 0x0061}, {0x002C}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u0308\u0061\u002C", expected: [][]rune{{0x0041, 0x0308, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u0031\u003A", expected: [][]rune{{0x0041, 0x0031}, {0x003A}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u0308\u0031\u003A", expected: [][]rune{{0x0041, 0x0308, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0041\u0031\u0027", expected: [][]rune{{0x0041, 0x0031}, {0x0027}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u0308\u0031\u0027", expected: [][]rune{{0x0041, 0x0308, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0041\u0031\u002C", expected: [][]rune{{0x0041, 0x0031}, {0x002C}}},                                                                   // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u0308\u0031\u002C", expected: [][]rune{{0x0041, 0x0308, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0041\u0031\u002E\u2060", expected: [][]rune{{0x0041, 0x0031}, {0x002E, 0x2060}}},                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0041\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0041, 0x0308, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0001", expected: [][]rune{{0x003A}, {0x0001}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u003A\u0308\u0001", expected: [][]rune{{0x003A, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u003A\u000D", expected: [][]rune{{0x003A}, {0x000D}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u003A\u0308\u000D", expected: [][]rune{{0x003A, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u003A\u000A", expected: [][]rune{{0x003A}, {0x000A}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u003A\u0308\u000A", expected: [][]rune{{0x003A, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u003A\u000B", expected: [][]rune{{0x003A}, {0x000B}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u003A\u0308\u000B", expected: [][]rune{{0x003A, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u003A\u3031", expected: [][]rune{{0x003A}, {0x3031}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u003A\u0308\u3031", expected: [][]rune{{0x003A, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u003A\u0041", expected: [][]rune{{0x003A}, {0x0041}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u003A\u0308\u0041", expected: [][]rune{{0x003A, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u003A\u003A", expected: [][]rune{{0x003A}, {0x003A}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u0308\u003A", expected: [][]rune{{0x003A, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u002C", expected: [][]rune{{0x003A}, {0x002C}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u0308\u002C", expected: [][]rune{{0x003A, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u002E", expected: [][]rune{{0x003A}, {0x002E}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u003A\u0308\u002E", expected: [][]rune{{0x003A, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u003A\u0030", expected: [][]rune{{0x003A}, {0x0030}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u003A\u0308\u0030", expected: [][]rune{{0x003A, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u003A\u005F", expected: [][]rune{{0x003A}, {0x005F}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u003A\u0308\u005F", expected: [][]rune{{0x003A, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u003A\U0001F1E6", expected: [][]rune{{0x003A}, {0x1F1E6}}},                                                                            // ÷ [0.2] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u003A\u0308\U0001F1E6", expected: [][]rune{{0x003A, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u003A\u05D0", expected: [][]rune{{0x003A}, {0x05D0}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u003A\u0308\u05D0", expected: [][]rune{{0x003A, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u003A\u0022", expected: [][]rune{{0x003A}, {0x0022}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u003A\u0308\u0022", expected: [][]rune{{0x003A, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u003A\u0027", expected: [][]rune{{0x003A}, {0x0027}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u0308\u0027", expected: [][]rune{{0x003A, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u231A", expected: [][]rune{{0x003A}, {0x231A}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u003A\u0308\u231A", expected: [][]rune{{0x003A, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u003A\u0020", expected: [][]rune{{0x003A}, {0x0020}}},                                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u003A\u0308\u0020", expected: [][]rune{{0x003A, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u003A\u00AD", expected: [][]rune{{0x003A, 0x00AD}}},                                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u003A\u0308\u00AD", expected: [][]rune{{0x003A, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u003A\u0300", expected: [][]rune{{0x003A, 0x0300}}},                                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u003A\u0308\u0300", expected: [][]rune{{0x003A, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u003A\u200D", expected: [][]rune{{0x003A, 0x200D}}},                                                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u003A\u0308\u200D", expected: [][]rune{{0x003A, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u003A\u0061\u2060", expected: [][]rune{{0x003A}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0308\u0061\u2060", expected: [][]rune{{0x003A, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0061\u003A", expected: [][]rune{{0x003A}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u0308\u0061\u003A", expected: [][]rune{{0x003A, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u0061\u0027", expected: [][]rune{{0x003A}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u0308\u0061\u0027", expected: [][]rune{{0x003A, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u0061\u0027\u2060", expected: [][]rune{{0x003A}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0308\u0061\u0027\u2060", expected: [][]rune{{0x003A, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0061\u002C", expected: [][]rune{{0x003A}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u0308\u0061\u002C", expected: [][]rune{{0x003A, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u0031\u003A", expected: [][]rune{{0x003A}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u0308\u0031\u003A", expected: [][]rune{{0x003A, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u003A\u0031\u0027", expected: [][]rune{{0x003A}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u0308\u0031\u0027", expected: [][]rune{{0x003A, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u003A\u0031\u002C", expected: [][]rune{{0x003A}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u0308\u0031\u002C", expected: [][]rune{{0x003A, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u003A\u0031\u002E\u2060", expected: [][]rune{{0x003A}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u003A\u0308\u0031\u002E\u2060", expected: [][]rune{{0x003A, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0001", expected: [][]rune{{0x002C}, {0x0001}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002C\u0308\u0001", expected: [][]rune{{0x002C, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002C\u000D", expected: [][]rune{{0x002C}, {0x000D}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u0308\u000D", expected: [][]rune{{0x002C, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002C\u000A", expected: [][]rune{{0x002C}, {0x000A}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u0308\u000A", expected: [][]rune{{0x002C, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002C\u000B", expected: [][]rune{{0x002C}, {0x000B}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u002C\u0308\u000B", expected: [][]rune{{0x002C, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u002C\u3031", expected: [][]rune{{0x002C}, {0x3031}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u002C\u0308\u3031", expected: [][]rune{{0x002C, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u002C\u0041", expected: [][]rune{{0x002C}, {0x0041}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u002C\u0308\u0041", expected: [][]rune{{0x002C, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u002C\u003A", expected: [][]rune{{0x002C}, {0x003A}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u0308\u003A", expected: [][]rune{{0x002C, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u002C", expected: [][]rune{{0x002C}, {0x002C}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u0308\u002C", expected: [][]rune{{0x002C, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u002E", expected: [][]rune{{0x002C}, {0x002E}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u002C\u0308\u002E", expected: [][]rune{{0x002C, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u002C\u0030", expected: [][]rune{{0x002C}, {0x0030}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002C\u0308\u0030", expected: [][]rune{{0x002C, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002C\u005F", expected: [][]rune{{0x002C}, {0x005F}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u002C\u0308\u005F", expected: [][]rune{{0x002C, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u002C\U0001F1E6", expected: [][]rune{{0x002C}, {0x1F1E6}}},                                                                            // ÷ [0.2] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u0308\U0001F1E6", expected: [][]rune{{0x002C, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002C\u05D0", expected: [][]rune{{0x002C}, {0x05D0}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u002C\u0308\u05D0", expected: [][]rune{{0x002C, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u002C\u0022", expected: [][]rune{{0x002C}, {0x0022}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u002C\u0308\u0022", expected: [][]rune{{0x002C, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u002C\u0027", expected: [][]rune{{0x002C}, {0x0027}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u0308\u0027", expected: [][]rune{{0x002C, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u231A", expected: [][]rune{{0x002C}, {0x231A}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u002C\u0308\u231A", expected: [][]rune{{0x002C, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u002C\u0020", expected: [][]rune{{0x002C}, {0x0020}}},                                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u002C\u0308\u0020", expected: [][]rune{{0x002C, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u002C\u00AD", expected: [][]rune{{0x002C, 0x00AD}}},                                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002C\u0308\u00AD", expected: [][]rune{{0x002C, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002C\u0300", expected: [][]rune{{0x002C, 0x0300}}},                                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002C\u0308\u0300", expected: [][]rune{{0x002C, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002C\u200D", expected: [][]rune{{0x002C, 0x200D}}},                                                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u002C\u0308\u200D", expected: [][]rune{{0x002C, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u002C\u0061\u2060", expected: [][]rune{{0x002C}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0308\u0061\u2060", expected: [][]rune{{0x002C, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0061\u003A", expected: [][]rune{{0x002C}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u0308\u0061\u003A", expected: [][]rune{{0x002C, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u0061\u0027", expected: [][]rune{{0x002C}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u0308\u0061\u0027", expected: [][]rune{{0x002C, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u0061\u0027\u2060", expected: [][]rune{{0x002C}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0308\u0061\u0027\u2060", expected: [][]rune{{0x002C, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0061\u002C", expected: [][]rune{{0x002C}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u0308\u0061\u002C", expected: [][]rune{{0x002C, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u0031\u003A", expected: [][]rune{{0x002C}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u0308\u0031\u003A", expected: [][]rune{{0x002C, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002C\u0031\u0027", expected: [][]rune{{0x002C}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u0308\u0031\u0027", expected: [][]rune{{0x002C, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002C\u0031\u002C", expected: [][]rune{{0x002C}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u0308\u0031\u002C", expected: [][]rune{{0x002C, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002C\u0031\u002E\u2060", expected: [][]rune{{0x002C}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002C\u0308\u0031\u002E\u2060", expected: [][]rune{{0x002C, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0001", expected: [][]rune{{0x002E}, {0x0001}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002E\u0308\u0001", expected: [][]rune{{0x002E, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u002E\u000D", expected: [][]rune{{0x002E}, {0x000D}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002E\u0308\u000D", expected: [][]rune{{0x002E, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u002E\u000A", expected: [][]rune{{0x002E}, {0x000A}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002E\u0308\u000A", expected: [][]rune{{0x002E, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u002E\u000B", expected: [][]rune{{0x002E}, {0x000B}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u002E\u0308\u000B", expected: [][]rune{{0x002E, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u002E\u3031", expected: [][]rune{{0x002E}, {0x3031}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u002E\u0308\u3031", expected: [][]rune{{0x002E, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u002E\u0041", expected: [][]rune{{0x002E}, {0x0041}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u002E\u0308\u0041", expected: [][]rune{{0x002E, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u002E\u003A", expected: [][]rune{{0x002E}, {0x003A}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u0308\u003A", expected: [][]rune{{0x002E, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u002C", expected: [][]rune{{0x002E}, {0x002C}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u0308\u002C", expected: [][]rune{{0x002E, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u002E", expected: [][]rune{{0x002E}, {0x002E}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u002E\u0308\u002E", expected: [][]rune{{0x002E, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u002E\u0030", expected: [][]rune{{0x002E}, {0x0030}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002E\u0308\u0030", expected: [][]rune{{0x002E, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u002E\u005F", expected: [][]rune{{0x002E}, {0x005F}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u002E\u0308\u005F", expected: [][]rune{{0x002E, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u002E\U0001F1E6", expected: [][]rune{{0x002E}, {0x1F1E6}}},                                                                            // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002E\u0308\U0001F1E6", expected: [][]rune{{0x002E, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u002E\u05D0", expected: [][]rune{{0x002E}, {0x05D0}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u002E\u0308\u05D0", expected: [][]rune{{0x002E, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u002E\u0022", expected: [][]rune{{0x002E}, {0x0022}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u002E\u0308\u0022", expected: [][]rune{{0x002E, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u002E\u0027", expected: [][]rune{{0x002E}, {0x0027}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u0308\u0027", expected: [][]rune{{0x002E, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u231A", expected: [][]rune{{0x002E}, {0x231A}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u002E\u0308\u231A", expected: [][]rune{{0x002E, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u002E\u0020", expected: [][]rune{{0x002E}, {0x0020}}},                                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u002E\u0308\u0020", expected: [][]rune{{0x002E, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u002E\u00AD", expected: [][]rune{{0x002E, 0x00AD}}},                                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002E\u0308\u00AD", expected: [][]rune{{0x002E, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u002E\u0300", expected: [][]rune{{0x002E, 0x0300}}},                                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002E\u0308\u0300", expected: [][]rune{{0x002E, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u002E\u200D", expected: [][]rune{{0x002E, 0x200D}}},                                                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u002E\u0308\u200D", expected: [][]rune{{0x002E, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u002E\u0061\u2060", expected: [][]rune{{0x002E}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0308\u0061\u2060", expected: [][]rune{{0x002E, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0061\u003A", expected: [][]rune{{0x002E}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u0308\u0061\u003A", expected: [][]rune{{0x002E, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u0061\u0027", expected: [][]rune{{0x002E}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u0308\u0061\u0027", expected: [][]rune{{0x002E, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u0061\u0027\u2060", expected: [][]rune{{0x002E}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0308\u0061\u0027\u2060", expected: [][]rune{{0x002E, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0061\u002C", expected: [][]rune{{0x002E}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u0308\u0061\u002C", expected: [][]rune{{0x002E, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u0031\u003A", expected: [][]rune{{0x002E}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u0308\u0031\u003A", expected: [][]rune{{0x002E, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u002E\u0031\u0027", expected: [][]rune{{0x002E}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u0308\u0031\u0027", expected: [][]rune{{0x002E, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u002E\u0031\u002C", expected: [][]rune{{0x002E}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u0308\u0031\u002C", expected: [][]rune{{0x002E, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u002E\u0031\u002E\u2060", expected: [][]rune{{0x002E}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u002E\u0308\u0031\u002E\u2060", expected: [][]rune{{0x002E, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0001", expected: [][]rune{{0x0030}, {0x0001}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0030\u0308\u0001", expected: [][]rune{{0x0030, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0030\u000D", expected: [][]rune{{0x0030}, {0x000D}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0030\u0308\u000D", expected: [][]rune{{0x0030, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0030\u000A", expected: [][]rune{{0x0030}, {0x000A}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0030\u0308\u000A", expected: [][]rune{{0x0030, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0030\u000B", expected: [][]rune{{0x0030}, {0x000B}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0030\u0308\u000B", expected: [][]rune{{0x0030, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0030\u3031", expected: [][]rune{{0x0030}, {0x3031}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0030\u0308\u3031", expected: [][]rune{{0x0030, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0030\u0041", expected: [][]rune{{0x0030, 0x0041}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0030\u0308\u0041", expected: [][]rune{{0x0030, 0x0308, 0x0041}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0030\u003A", expected: [][]rune{{0x0030}, {0x003A}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u0308\u003A", expected: [][]rune{{0x0030, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u002C", expected: [][]rune{{0x0030}, {0x002C}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u0308\u002C", expected: [][]rune{{0x0030, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u002E", expected: [][]rune{{0x0030}, {0x002E}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0030\u0308\u002E", expected: [][]rune{{0x0030, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0030\u0030", expected: [][]rune{{0x0030, 0x0030}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0030\u0308\u0030", expected: [][]rune{{0x0030, 0x0308, 0x0030}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0030\u005F", expected: [][]rune{{0x0030, 0x005F}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0030\u0308\u005F", expected: [][]rune{{0x0030, 0x0308, 0x005F}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0030\U0001F1E6", expected: [][]rune{{0x0030}, {0x1F1E6}}},                                                                            // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0030\u0308\U0001F1E6", expected: [][]rune{{0x0030, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0030\u05D0", expected: [][]rune{{0x0030, 0x05D0}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0030\u0308\u05D0", expected: [][]rune{{0x0030, 0x0308, 0x05D0}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0030\u0022", expected: [][]rune{{0x0030}, {0x0022}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0030\u0308\u0022", expected: [][]rune{{0x0030, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0030\u0027", expected: [][]rune{{0x0030}, {0x0027}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u0308\u0027", expected: [][]rune{{0x0030, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u231A", expected: [][]rune{{0x0030}, {0x231A}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0030\u0308\u231A", expected: [][]rune{{0x0030, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0030\u0020", expected: [][]rune{{0x0030}, {0x0020}}},                                                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0030\u0308\u0020", expected: [][]rune{{0x0030, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0030\u00AD", expected: [][]rune{{0x0030, 0x00AD}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0030\u0308\u00AD", expected: [][]rune{{0x0030, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0030\u0300", expected: [][]rune{{0x0030, 0x0300}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0030\u0308\u0300", expected: [][]rune{{0x0030, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0030\u200D", expected: [][]rune{{0x0030, 0x200D}}},                                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0030\u0308\u200D", expected: [][]rune{{0x0030, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0030\u0061\u2060", expected: [][]rune{{0x0030, 0x0061, 0x2060}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0308\u0061\u2060", expected: [][]rune{{0x0030, 0x0308, 0x0061, 0x2060}}},                                                       // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0061\u003A", expected: [][]rune{{0x0030, 0x0061}, {0x003A}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u0308\u0061\u003A", expected: [][]rune{{0x0030, 0x0308, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u0061\u0027", expected: [][]rune{{0x0030, 0x0061}, {0x0027}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u0308\u0061\u0027", expected: [][]rune{{0x0030, 0x0308, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u0061\u0027\u2060", expected: [][]rune{{0x0030, 0x0061}, {0x0027, 0x2060}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0030, 0x0308, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0061\u002C", expected: [][]rune{{0x0030, 0x0061}, {0x002C}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u0308\u0061\u002C", expected: [][]rune{{0x0030, 0x0308, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u0031\u003A", expected: [][]rune{{0x0030, 0x0031}, {0x003A}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u0308\u0031\u003A", expected: [][]rune{{0x0030, 0x0308, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0030\u0031\u0027", expected: [][]rune{{0x0030, 0x0031}, {0x0027}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u0308\u0031\u0027", expected: [][]rune{{0x0030, 0x0308, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0030\u0031\u002C", expected: [][]rune{{0x0030, 0x0031}, {0x002C}}},                                                                   // ÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u0308\u0031\u002C", expected: [][]rune{{0x0030, 0x0308, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0030\u0031\u002E\u2060", expected: [][]rune{{0x0030, 0x0031}, {0x002E, 0x2060}}},                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0030\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0030, 0x0308, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0001", expected: [][]rune{{0x005F}, {0x0001}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u005F\u0308\u0001", expected: [][]rune{{0x005F, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u005F\u000D", expected: [][]rune{{0x005F}, {0x000D}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u005F\u0308\u000D", expected: [][]rune{{0x005F, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u005F\u000A", expected: [][]rune{{0x005F}, {0x000A}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u005F\u0308\u000A", expected: [][]rune{{0x005F, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u005F\u000B", expected: [][]rune{{0x005F}, {0x000B}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u005F\u0308\u000B", expected: [][]rune{{0x005F, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u005F\u3031", expected: [][]rune{{0x005F, 0x3031}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u005F\u0308\u3031", expected: [][]rune{{0x005F, 0x0308, 0x3031}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u005F\u0041", expected: [][]rune{{0x005F, 0x0041}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u005F\u0308\u0041", expected: [][]rune{{0x005F, 0x0308, 0x0041}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u005F\u003A", expected: [][]rune{{0x005F}, {0x003A}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u0308\u003A", expected: [][]rune{{0x005F, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u002C", expected: [][]rune{{0x005F}, {0x002C}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u0308\u002C", expected: [][]rune{{0x005F, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u002E", expected: [][]rune{{0x005F}, {0x002E}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u005F\u0308\u002E", expected: [][]rune{{0x005F, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u005F\u0030", expected: [][]rune{{0x005F, 0x0030}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u005F\u0308\u0030", expected: [][]rune{{0x005F, 0x0308, 0x0030}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u005F\u005F", expected: [][]rune{{0x005F, 0x005F}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u005F\u0308\u005F", expected: [][]rune{{0x005F, 0x0308, 0x005F}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u005F\U0001F1E6", expected: [][]rune{{0x005F}, {0x1F1E6}}},                                                                            // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u005F\u0308\U0001F1E6", expected: [][]rune{{0x005F, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u005F\u05D0", expected: [][]rune{{0x005F, 0x05D0}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u005F\u0308\u05D0", expected: [][]rune{{0x005F, 0x0308, 0x05D0}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u005F\u0022", expected: [][]rune{{0x005F}, {0x0022}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u005F\u0308\u0022", expected: [][]rune{{0x005F, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u005F\u0027", expected: [][]rune{{0x005F}, {0x0027}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u0308\u0027", expected: [][]rune{{0x005F, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u231A", expected: [][]rune{{0x005F}, {0x231A}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u005F\u0308\u231A", expected: [][]rune{{0x005F, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u005F\u0020", expected: [][]rune{{0x005F}, {0x0020}}},                                                                                 // ÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u005F\u0308\u0020", expected: [][]rune{{0x005F, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u005F\u00AD", expected: [][]rune{{0x005F, 0x00AD}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u005F\u0308\u00AD", expected: [][]rune{{0x005F, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u005F\u0300", expected: [][]rune{{0x005F, 0x0300}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u005F\u0308\u0300", expected: [][]rune{{0x005F, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u005F\u200D", expected: [][]rune{{0x005F, 0x200D}}},                                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u005F\u0308\u200D", expected: [][]rune{{0x005F, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u005F\u0061\u2060", expected: [][]rune{{0x005F, 0x0061, 0x2060}}},                                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0308\u0061\u2060", expected: [][]rune{{0x005F, 0x0308, 0x0061, 0x2060}}},                                                       // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0061\u003A", expected: [][]rune{{0x005F, 0x0061}, {0x003A}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u0308\u0061\u003A", expected: [][]rune{{0x005F, 0x0308, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u0061\u0027", expected: [][]rune{{0x005F, 0x0061}, {0x0027}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u0308\u0061\u0027", expected: [][]rune{{0x005F, 0x0308, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u0061\u0027\u2060", expected: [][]rune{{0x005F, 0x0061}, {0x0027, 0x2060}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0308\u0061\u0027\u2060", expected: [][]rune{{0x005F, 0x0308, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0061\u002C", expected: [][]rune{{0x005F, 0x0061}, {0x002C}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u0308\u0061\u002C", expected: [][]rune{{0x005F, 0x0308, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u0031\u003A", expected: [][]rune{{0x005F, 0x0031}, {0x003A}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u0308\u0031\u003A", expected: [][]rune{{0x005F, 0x0308, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u005F\u0031\u0027", expected: [][]rune{{0x005F, 0x0031}, {0x0027}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u0308\u0031\u0027", expected: [][]rune{{0x005F, 0x0308, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u005F\u0031\u002C", expected: [][]rune{{0x005F, 0x0031}, {0x002C}}},                                                                   // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u0308\u0031\u002C", expected: [][]rune{{0x005F, 0x0308, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u005F\u0031\u002E\u2060", expected: [][]rune{{0x005F, 0x0031}, {0x002E, 0x2060}}},                                                     // ÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u005F\u0308\u0031\u002E\u2060", expected: [][]rune{{0x005F, 0x0308, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0001", expected: [][]rune{{0x1F1E6}, {0x0001}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0001", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0001}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\U0001F1E6\u000D", expected: [][]rune{{0x1F1E6}, {0x000D}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u000D", expected: [][]rune{{0x1F1E6, 0x0308}, {0x000D}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\U0001F1E6\u000A", expected: [][]rune{{0x1F1E6}, {0x000A}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u000A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x000A}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\U0001F1E6\u000B", expected: [][]rune{{0x1F1E6}, {0x000B}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u000B", expected: [][]rune{{0x1F1E6, 0x0308}, {0x000B}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\U0001F1E6\u3031", expected: [][]rune{{0x1F1E6}, {0x3031}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u3031", expected: [][]rune{{0x1F1E6, 0x0308}, {0x3031}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\U0001F1E6\u0041", expected: [][]rune{{0x1F1E6}, {0x0041}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0041", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0041}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\U0001F1E6\u003A", expected: [][]rune{{0x1F1E6}, {0x003A}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u003A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x003A}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u002C", expected: [][]rune{{0x1F1E6}, {0x002C}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u002C", expected: [][]rune{{0x1F1E6, 0x0308}, {0x002C}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u002E", expected: [][]rune{{0x1F1E6}, {0x002E}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u002E", expected: [][]rune{{0x1F1E6, 0x0308}, {0x002E}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\U0001F1E6\u0030", expected: [][]rune{{0x1F1E6}, {0x0030}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0030", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0030}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\U0001F1E6\u005F", expected: [][]rune{{0x1F1E6}, {0x005F}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u005F", expected: [][]rune{{0x1F1E6, 0x0308}, {0x005F}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\U0001F1E6\U0001F1E6", expected: [][]rune{{0x1F1E6, 0x1F1E6}}},                                                                         // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\U0001F1E6\u0308\U0001F1E6", expected: [][]rune{{0x1F1E6, 0x0308, 0x1F1E6}}},                                                           // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\U0001F1E6\u05D0", expected: [][]rune{{0x1F1E6}, {0x05D0}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u05D0", expected: [][]rune{{0x1F1E6, 0x0308}, {0x05D0}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\U0001F1E6\u0022", expected: [][]rune{{0x1F1E6}, {0x0022}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0022", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0022}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0027", expected: [][]rune{{0x1F1E6}, {0x0027}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0027", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0027}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u231A", expected: [][]rune{{0x1F1E6}, {0x231A}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u231A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x231A}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\U0001F1E6\u0020", expected: [][]rune{{0x1F1E6}, {0x0020}}},                                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0020", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0020}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\U0001F1E6\u00AD", expected: [][]rune{{0x1F1E6, 0x00AD}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u00AD", expected: [][]rune{{0x1F1E6, 0x0308, 0x00AD}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0300", expected: [][]rune{{0x1F1E6, 0x0300}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0300", expected: [][]rune{{0x1F1E6, 0x0308, 0x0300}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\U0001F1E6\u200D", expected: [][]rune{{0x1F1E6, 0x200D}}},                                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u200D", expected: [][]rune{{0x1F1E6, 0x0308, 0x200D}}},                                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0061\u2060", expected: [][]rune{{0x1F1E6}, {0x0061, 0x2060}}},                                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0061\u2060", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0061, 0x2060}}},                                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0061\u003A", expected: [][]rune{{0x1F1E6}, {0x0061}, {0x003A}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0061\u003A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0061}, {0x003A}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u0061\u0027", expected: [][]rune{{0x1F1E6}, {0x0061}, {0x0027}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0061\u0027", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0061}, {0x0027}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0061\u0027\u2060", expected: [][]rune{{0x1F1E6}, {0x0061}, {0x0027, 0x2060}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0061\u0027\u2060", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0061\u002C", expected: [][]rune{{0x1F1E6}, {0x0061}, {0x002C}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0061\u002C", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0061}, {0x002C}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u0031\u003A", expected: [][]rune{{0x1F1E6}, {0x0031}, {0x003A}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0031\u003A", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0031}, {0x003A}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\U0001F1E6\u0031\u0027", expected: [][]rune{{0x1F1E6}, {0x0031}, {0x0027}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0031\u0027", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0031}, {0x0027}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\U0001F1E6\u0031\u002C", expected: [][]rune{{0x1F1E6}, {0x0031}, {0x002C}}},                                                            // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0031\u002C", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0031}, {0x002C}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\U0001F1E6\u0031\u002E\u2060", expected: [][]rune{{0x1F1E6}, {0x0031}, {0x002E, 0x2060}}},                                              // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\U0001F1E6\u0308\u0031\u002E\u2060", expected: [][]rune{{0x1F1E6, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0001", expected: [][]rune{{0x05D0}, {0x0001}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u05D0\u0308\u0001", expected: [][]rune{{0x05D0, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u05D0\u000D", expected: [][]rune{{0x05D0}, {0x000D}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u0308\u000D", expected: [][]rune{{0x05D0, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u05D0\u000A", expected: [][]rune{{0x05D0}, {0x000A}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u0308\u000A", expected: [][]rune{{0x05D0, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u05D0\u000B", expected: [][]rune{{0x05D0}, {0x000B}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u05D0\u0308\u000B", expected: [][]rune{{0x05D0, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u05D0\u3031", expected: [][]rune{{0x05D0}, {0x3031}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u05D0\u0308\u3031", expected: [][]rune{{0x05D0, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u05D0\u0041", expected: [][]rune{{0x05D0, 0x0041}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u05D0\u0308\u0041", expected: [][]rune{{0x05D0, 0x0308, 0x0041}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u05D0\u003A", expected: [][]rune{{0x05D0}, {0x003A}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u0308\u003A", expected: [][]rune{{0x05D0, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u002C", expected: [][]rune{{0x05D0}, {0x002C}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u0308\u002C", expected: [][]rune{{0x05D0, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u002E", expected: [][]rune{{0x05D0}, {0x002E}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u05D0\u0308\u002E", expected: [][]rune{{0x05D0, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u05D0\u0030", expected: [][]rune{{0x05D0, 0x0030}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u05D0\u0308\u0030", expected: [][]rune{{0x05D0, 0x0308, 0x0030}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u05D0\u005F", expected: [][]rune{{0x05D0, 0x005F}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u05D0\u0308\u005F", expected: [][]rune{{0x05D0, 0x0308, 0x005F}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u05D0\U0001F1E6", expected: [][]rune{{0x05D0}, {0x1F1E6}}},                                                                            // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u0308\U0001F1E6", expected: [][]rune{{0x05D0, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u05D0\u05D0", expected: [][]rune{{0x05D0, 0x05D0}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u05D0\u0308\u05D0", expected: [][]rune{{0x05D0, 0x0308, 0x05D0}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u05D0\u0022", expected: [][]rune{{0x05D0}, {0x0022}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u05D0\u0308\u0022", expected: [][]rune{{0x05D0, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u05D0\u0027", expected: [][]rune{{0x05D0, 0x0027}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0308\u0027", expected: [][]rune{{0x05D0, 0x0308, 0x0027}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u231A", expected: [][]rune{{0x05D0}, {0x231A}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u05D0\u0308\u231A", expected: [][]rune{{0x05D0, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u05D0\u0020", expected: [][]rune{{0x05D0}, {0x0020}}},                                                                                 // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u05D0\u0308\u0020", expected: [][]rune{{0x05D0, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u05D0\u00AD", expected: [][]rune{{0x05D0, 0x00AD}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u00AD", expected: [][]rune{{0x05D0, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0300", expected: [][]rune{{0x05D0, 0x0300}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u0300", expected: [][]rune{{0x05D0, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u05D0\u200D", expected: [][]rune{{0x05D0, 0x200D}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u200D", expected: [][]rune{{0x05D0, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u05D0\u0061\u2060", expected: [][]rune{{0x05D0, 0x0061, 0x2060}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u0061\u2060", expected: [][]rune{{0x05D0, 0x0308, 0x0061, 0x2060}}},                                                       // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0061\u003A", expected: [][]rune{{0x05D0, 0x0061}, {0x003A}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u0308\u0061\u003A", expected: [][]rune{{0x05D0, 0x0308, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u0061\u0027", expected: [][]rune{{0x05D0, 0x0061}, {0x0027}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0308\u0061\u0027", expected: [][]rune{{0x05D0, 0x0308, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0061\u0027\u2060", expected: [][]rune{{0x05D0, 0x0061}, {0x0027, 0x2060}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u0061\u0027\u2060", expected: [][]rune{{0x05D0, 0x0308, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0061\u002C", expected: [][]rune{{0x05D0, 0x0061}, {0x002C}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u0308\u0061\u002C", expected: [][]rune{{0x05D0, 0x0308, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u0031\u003A", expected: [][]rune{{0x05D0, 0x0031}, {0x003A}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u0308\u0031\u003A", expected: [][]rune{{0x05D0, 0x0308, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u05D0\u0031\u0027", expected: [][]rune{{0x05D0, 0x0031}, {0x0027}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0308\u0031\u0027", expected: [][]rune{{0x05D0, 0x0308, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0031\u002C", expected: [][]rune{{0x05D0, 0x0031}, {0x002C}}},                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u0308\u0031\u002C", expected: [][]rune{{0x05D0, 0x0308, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u05D0\u0031\u002E\u2060", expected: [][]rune{{0x05D0, 0x0031}, {0x002E, 0x2060}}},                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u05D0\u0308\u0031\u002E\u2060", expected: [][]rune{{0x05D0, 0x0308, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0001", expected: [][]rune{{0x0022}, {0x0001}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0022\u0308\u0001", expected: [][]rune{{0x0022, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0022\u000D", expected: [][]rune{{0x0022}, {0x000D}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0022\u0308\u000D", expected: [][]rune{{0x0022, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0022\u000A", expected: [][]rune{{0x0022}, {0x000A}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0022\u0308\u000A", expected: [][]rune{{0x0022, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0022\u000B", expected: [][]rune{{0x0022}, {0x000B}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0022\u0308\u000B", expected: [][]rune{{0x0022, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0022\u3031", expected: [][]rune{{0x0022}, {0x3031}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0022\u0308\u3031", expected: [][]rune{{0x0022, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0022\u0041", expected: [][]rune{{0x0022}, {0x0041}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0022\u0308\u0041", expected: [][]rune{{0x0022, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0022\u003A", expected: [][]rune{{0x0022}, {0x003A}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u0308\u003A", expected: [][]rune{{0x0022, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u002C", expected: [][]rune{{0x0022}, {0x002C}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u0308\u002C", expected: [][]rune{{0x0022, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u002E", expected: [][]rune{{0x0022}, {0x002E}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0022\u0308\u002E", expected: [][]rune{{0x0022, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0022\u0030", expected: [][]rune{{0x0022}, {0x0030}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0022\u0308\u0030", expected: [][]rune{{0x0022, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0022\u005F", expected: [][]rune{{0x0022}, {0x005F}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0022\u0308\u005F", expected: [][]rune{{0x0022, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0022\U0001F1E6", expected: [][]rune{{0x0022}, {0x1F1E6}}},                                                                            // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0022\u0308\U0001F1E6", expected: [][]rune{{0x0022, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0022\u05D0", expected: [][]rune{{0x0022}, {0x05D0}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0022\u0308\u05D0", expected: [][]rune{{0x0022, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0022\u0022", expected: [][]rune{{0x0022}, {0x0022}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0022\u0308\u0022", expected: [][]rune{{0x0022, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0022\u0027", expected: [][]rune{{0x0022}, {0x0027}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u0308\u0027", expected: [][]rune{{0x0022, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u231A", expected: [][]rune{{0x0022}, {0x231A}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0022\u0308\u231A", expected: [][]rune{{0x0022, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0022\u0020", expected: [][]rune{{0x0022}, {0x0020}}},                                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0022\u0308\u0020", expected: [][]rune{{0x0022, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0022\u00AD", expected: [][]rune{{0x0022, 0x00AD}}},                                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0022\u0308\u00AD", expected: [][]rune{{0x0022, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0022\u0300", expected: [][]rune{{0x0022, 0x0300}}},                                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0022\u0308\u0300", expected: [][]rune{{0x0022, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0022\u200D", expected: [][]rune{{0x0022, 0x200D}}},                                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0022\u0308\u200D", expected: [][]rune{{0x0022, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0022\u0061\u2060", expected: [][]rune{{0x0022}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0308\u0061\u2060", expected: [][]rune{{0x0022, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0061\u003A", expected: [][]rune{{0x0022}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u0308\u0061\u003A", expected: [][]rune{{0x0022, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u0061\u0027", expected: [][]rune{{0x0022}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u0308\u0061\u0027", expected: [][]rune{{0x0022, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u0061\u0027\u2060", expected: [][]rune{{0x0022}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0022, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0061\u002C", expected: [][]rune{{0x0022}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u0308\u0061\u002C", expected: [][]rune{{0x0022, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u0031\u003A", expected: [][]rune{{0x0022}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u0308\u0031\u003A", expected: [][]rune{{0x0022, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0022\u0031\u0027", expected: [][]rune{{0x0022}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u0308\u0031\u0027", expected: [][]rune{{0x0022, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0022\u0031\u002C", expected: [][]rune{{0x0022}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u0308\u0031\u002C", expected: [][]rune{{0x0022, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0022\u0031\u002E\u2060", expected: [][]rune{{0x0022}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0022\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0022, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0001", expected: [][]rune{{0x0027}, {0x0001}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0027\u0308\u0001", expected: [][]rune{{0x0027, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0027\u000D", expected: [][]rune{{0x0027}, {0x000D}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0027\u0308\u000D", expected: [][]rune{{0x0027, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0027\u000A", expected: [][]rune{{0x0027}, {0x000A}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0027\u0308\u000A", expected: [][]rune{{0x0027, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0027\u000B", expected: [][]rune{{0x0027}, {0x000B}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0027\u0308\u000B", expected: [][]rune{{0x0027, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0027\u3031", expected: [][]rune{{0x0027}, {0x3031}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0027\u0308\u3031", expected: [][]rune{{0x0027, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0027\u0041", expected: [][]rune{{0x0027}, {0x0041}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0027\u0308\u0041", expected: [][]rune{{0x0027, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0027\u003A", expected: [][]rune{{0x0027}, {0x003A}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u0308\u003A", expected: [][]rune{{0x0027, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u002C", expected: [][]rune{{0x0027}, {0x002C}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u0308\u002C", expected: [][]rune{{0x0027, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u002E", expected: [][]rune{{0x0027}, {0x002E}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0027\u0308\u002E", expected: [][]rune{{0x0027, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0027\u0030", expected: [][]rune{{0x0027}, {0x0030}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0027\u0308\u0030", expected: [][]rune{{0x0027, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0027\u005F", expected: [][]rune{{0x0027}, {0x005F}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0027\u0308\u005F", expected: [][]rune{{0x0027, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0027\U0001F1E6", expected: [][]rune{{0x0027}, {0x1F1E6}}},                                                                            // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0027\u0308\U0001F1E6", expected: [][]rune{{0x0027, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0027\u05D0", expected: [][]rune{{0x0027}, {0x05D0}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0027\u0308\u05D0", expected: [][]rune{{0x0027, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0027\u0022", expected: [][]rune{{0x0027}, {0x0022}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0027\u0308\u0022", expected: [][]rune{{0x0027, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0027\u0027", expected: [][]rune{{0x0027}, {0x0027}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u0308\u0027", expected: [][]rune{{0x0027, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u231A", expected: [][]rune{{0x0027}, {0x231A}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0027\u0308\u231A", expected: [][]rune{{0x0027, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0027\u0020", expected: [][]rune{{0x0027}, {0x0020}}},                                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0027\u0308\u0020", expected: [][]rune{{0x0027, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0027\u00AD", expected: [][]rune{{0x0027, 0x00AD}}},                                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0027\u0308\u00AD", expected: [][]rune{{0x0027, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0027\u0300", expected: [][]rune{{0x0027, 0x0300}}},                                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0027\u0308\u0300", expected: [][]rune{{0x0027, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0027\u200D", expected: [][]rune{{0x0027, 0x200D}}},                                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0027\u0308\u200D", expected: [][]rune{{0x0027, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0027\u0061\u2060", expected: [][]rune{{0x0027}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0308\u0061\u2060", expected: [][]rune{{0x0027, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0061\u003A", expected: [][]rune{{0x0027}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u0308\u0061\u003A", expected: [][]rune{{0x0027, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u0061\u0027", expected: [][]rune{{0x0027}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u0308\u0061\u0027", expected: [][]rune{{0x0027, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u0061\u0027\u2060", expected: [][]rune{{0x0027}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0027, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0061\u002C", expected: [][]rune{{0x0027}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u0308\u0061\u002C", expected: [][]rune{{0x0027, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u0031\u003A", expected: [][]rune{{0x0027}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u0308\u0031\u003A", expected: [][]rune{{0x0027, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0027\u0031\u0027", expected: [][]rune{{0x0027}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u0308\u0031\u0027", expected: [][]rune{{0x0027, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0027\u0031\u002C", expected: [][]rune{{0x0027}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u0308\u0031\u002C", expected: [][]rune{{0x0027, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0027\u0031\u002E\u2060", expected: [][]rune{{0x0027}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0027\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0027, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0001", expected: [][]rune{{0x231A}, {0x0001}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u231A\u0308\u0001", expected: [][]rune{{0x231A, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u231A\u000D", expected: [][]rune{{0x231A}, {0x000D}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u0308\u000D", expected: [][]rune{{0x231A, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u231A\u000A", expected: [][]rune{{0x231A}, {0x000A}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u0308\u000A", expected: [][]rune{{0x231A, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u231A\u000B", expected: [][]rune{{0x231A}, {0x000B}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u231A\u0308\u000B", expected: [][]rune{{0x231A, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u231A\u3031", expected: [][]rune{{0x231A}, {0x3031}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u231A\u0308\u3031", expected: [][]rune{{0x231A, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u231A\u0041", expected: [][]rune{{0x231A}, {0x0041}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u231A\u0308\u0041", expected: [][]rune{{0x231A, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u231A\u003A", expected: [][]rune{{0x231A}, {0x003A}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u0308\u003A", expected: [][]rune{{0x231A, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u002C", expected: [][]rune{{0x231A}, {0x002C}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u0308\u002C", expected: [][]rune{{0x231A, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u002E", expected: [][]rune{{0x231A}, {0x002E}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u231A\u0308\u002E", expected: [][]rune{{0x231A, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u231A\u0030", expected: [][]rune{{0x231A}, {0x0030}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u231A\u0308\u0030", expected: [][]rune{{0x231A, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u231A\u005F", expected: [][]rune{{0x231A}, {0x005F}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u231A\u0308\u005F", expected: [][]rune{{0x231A, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u231A\U0001F1E6", expected: [][]rune{{0x231A}, {0x1F1E6}}},                                                                            // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u0308\U0001F1E6", expected: [][]rune{{0x231A, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u231A\u05D0", expected: [][]rune{{0x231A}, {0x05D0}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u231A\u0308\u05D0", expected: [][]rune{{0x231A, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u231A\u0022", expected: [][]rune{{0x231A}, {0x0022}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u231A\u0308\u0022", expected: [][]rune{{0x231A, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u231A\u0027", expected: [][]rune{{0x231A}, {0x0027}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u0308\u0027", expected: [][]rune{{0x231A, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u231A", expected: [][]rune{{0x231A}, {0x231A}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u231A\u0308\u231A", expected: [][]rune{{0x231A, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u231A\u0020", expected: [][]rune{{0x231A}, {0x0020}}},                                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u231A\u0308\u0020", expected: [][]rune{{0x231A, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u231A\u00AD", expected: [][]rune{{0x231A, 0x00AD}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u231A\u0308\u00AD", expected: [][]rune{{0x231A, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u231A\u0300", expected: [][]rune{{0x231A, 0x0300}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u231A\u0308\u0300", expected: [][]rune{{0x231A, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u231A\u200D", expected: [][]rune{{0x231A, 0x200D}}},                                                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u231A\u0308\u200D", expected: [][]rune{{0x231A, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u231A\u0061\u2060", expected: [][]rune{{0x231A}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0308\u0061\u2060", expected: [][]rune{{0x231A, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0061\u003A", expected: [][]rune{{0x231A}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u0308\u0061\u003A", expected: [][]rune{{0x231A, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u0061\u0027", expected: [][]rune{{0x231A}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u0308\u0061\u0027", expected: [][]rune{{0x231A, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u0061\u0027\u2060", expected: [][]rune{{0x231A}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0308\u0061\u0027\u2060", expected: [][]rune{{0x231A, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0061\u002C", expected: [][]rune{{0x231A}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u0308\u0061\u002C", expected: [][]rune{{0x231A, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u0031\u003A", expected: [][]rune{{0x231A}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u0308\u0031\u003A", expected: [][]rune{{0x231A, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u231A\u0031\u0027", expected: [][]rune{{0x231A}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u0308\u0031\u0027", expected: [][]rune{{0x231A, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u231A\u0031\u002C", expected: [][]rune{{0x231A}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u0308\u0031\u002C", expected: [][]rune{{0x231A, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u231A\u0031\u002E\u2060", expected: [][]rune{{0x231A}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u231A\u0308\u0031\u002E\u2060", expected: [][]rune{{0x231A, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0001", expected: [][]rune{{0x0020}, {0x0001}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0020\u0308\u0001", expected: [][]rune{{0x0020, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0020\u000D", expected: [][]rune{{0x0020}, {0x000D}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0020\u0308\u000D", expected: [][]rune{{0x0020, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0020\u000A", expected: [][]rune{{0x0020}, {0x000A}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0020\u0308\u000A", expected: [][]rune{{0x0020, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0020\u000B", expected: [][]rune{{0x0020}, {0x000B}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0020\u0308\u000B", expected: [][]rune{{0x0020, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0020\u3031", expected: [][]rune{{0x0020}, {0x3031}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0020\u0308\u3031", expected: [][]rune{{0x0020, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0020\u0041", expected: [][]rune{{0x0020}, {0x0041}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0020\u0308\u0041", expected: [][]rune{{0x0020, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0020\u003A", expected: [][]rune{{0x0020}, {0x003A}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u0308\u003A", expected: [][]rune{{0x0020, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u002C", expected: [][]rune{{0x0020}, {0x002C}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u0308\u002C", expected: [][]rune{{0x0020, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u002E", expected: [][]rune{{0x0020}, {0x002E}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0020\u0308\u002E", expected: [][]rune{{0x0020, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0020\u0030", expected: [][]rune{{0x0020}, {0x0030}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0020\u0308\u0030", expected: [][]rune{{0x0020, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0020\u005F", expected: [][]rune{{0x0020}, {0x005F}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0020\u0308\u005F", expected: [][]rune{{0x0020, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0020\U0001F1E6", expected: [][]rune{{0x0020}, {0x1F1E6}}},                                                                            // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0020\u0308\U0001F1E6", expected: [][]rune{{0x0020, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0020\u05D0", expected: [][]rune{{0x0020}, {0x05D0}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0020\u0308\u05D0", expected: [][]rune{{0x0020, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0020\u0022", expected: [][]rune{{0x0020}, {0x0022}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0020\u0308\u0022", expected: [][]rune{{0x0020, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0020\u0027", expected: [][]rune{{0x0020}, {0x0027}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u0308\u0027", expected: [][]rune{{0x0020, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u231A", expected: [][]rune{{0x0020}, {0x231A}}},                                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0020\u0308\u231A", expected: [][]rune{{0x0020, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0020\u0020", expected: [][]rune{{0x0020, 0x0020}}},                                                                                   // ÷ [0.2] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0020\u0308\u0020", expected: [][]rune{{0x0020, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0020\u00AD", expected: [][]rune{{0x0020, 0x00AD}}},                                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0020\u0308\u00AD", expected: [][]rune{{0x0020, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0020\u0300", expected: [][]rune{{0x0020, 0x0300}}},                                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0020\u0308\u0300", expected: [][]rune{{0x0020, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0020\u200D", expected: [][]rune{{0x0020, 0x200D}}},                                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0020\u0308\u200D", expected: [][]rune{{0x0020, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0020\u0061\u2060", expected: [][]rune{{0x0020}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0308\u0061\u2060", expected: [][]rune{{0x0020, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0061\u003A", expected: [][]rune{{0x0020}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u0308\u0061\u003A", expected: [][]rune{{0x0020, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u0061\u0027", expected: [][]rune{{0x0020}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u0308\u0061\u0027", expected: [][]rune{{0x0020, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u0061\u0027\u2060", expected: [][]rune{{0x0020}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0020, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0061\u002C", expected: [][]rune{{0x0020}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u0308\u0061\u002C", expected: [][]rune{{0x0020, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u0031\u003A", expected: [][]rune{{0x0020}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u0308\u0031\u003A", expected: [][]rune{{0x0020, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0020\u0031\u0027", expected: [][]rune{{0x0020}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u0308\u0031\u0027", expected: [][]rune{{0x0020, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0020\u0031\u002C", expected: [][]rune{{0x0020}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u0308\u0031\u002C", expected: [][]rune{{0x0020, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0020\u0031\u002E\u2060", expected: [][]rune{{0x0020}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0020\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0020, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0001", expected: [][]rune{{0x00AD}, {0x0001}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u00AD\u0308\u0001", expected: [][]rune{{0x00AD, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u00AD\u000D", expected: [][]rune{{0x00AD}, {0x000D}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00AD\u0308\u000D", expected: [][]rune{{0x00AD, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u00AD\u000A", expected: [][]rune{{0x00AD}, {0x000A}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00AD\u0308\u000A", expected: [][]rune{{0x00AD, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u00AD\u000B", expected: [][]rune{{0x00AD}, {0x000B}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u00AD\u0308\u000B", expected: [][]rune{{0x00AD, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u00AD\u3031", expected: [][]rune{{0x00AD}, {0x3031}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u00AD\u0308\u3031", expected: [][]rune{{0x00AD, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u00AD\u0041", expected: [][]rune{{0x00AD}, {0x0041}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u00AD\u0308\u0041", expected: [][]rune{{0x00AD, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u00AD\u003A", expected: [][]rune{{0x00AD}, {0x003A}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u0308\u003A", expected: [][]rune{{0x00AD, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u002C", expected: [][]rune{{0x00AD}, {0x002C}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u0308\u002C", expected: [][]rune{{0x00AD, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u002E", expected: [][]rune{{0x00AD}, {0x002E}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u00AD\u0308\u002E", expected: [][]rune{{0x00AD, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u00AD\u0030", expected: [][]rune{{0x00AD}, {0x0030}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u00AD\u0308\u0030", expected: [][]rune{{0x00AD, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u00AD\u005F", expected: [][]rune{{0x00AD}, {0x005F}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u00AD\u0308\u005F", expected: [][]rune{{0x00AD, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u00AD\U0001F1E6", expected: [][]rune{{0x00AD}, {0x1F1E6}}},                                                                            // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00AD\u0308\U0001F1E6", expected: [][]rune{{0x00AD, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u00AD\u05D0", expected: [][]rune{{0x00AD}, {0x05D0}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u00AD\u0308\u05D0", expected: [][]rune{{0x00AD, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u00AD\u0022", expected: [][]rune{{0x00AD}, {0x0022}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u00AD\u0308\u0022", expected: [][]rune{{0x00AD, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u00AD\u0027", expected: [][]rune{{0x00AD}, {0x0027}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u0308\u0027", expected: [][]rune{{0x00AD, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u231A", expected: [][]rune{{0x00AD}, {0x231A}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u00AD\u0308\u231A", expected: [][]rune{{0x00AD, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u00AD\u0020", expected: [][]rune{{0x00AD}, {0x0020}}},                                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u00AD\u0308\u0020", expected: [][]rune{{0x00AD, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u00AD\u00AD", expected: [][]rune{{0x00AD, 0x00AD}}},                                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u00AD", expected: [][]rune{{0x00AD, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0300", expected: [][]rune{{0x00AD, 0x0300}}},                                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u0300", expected: [][]rune{{0x00AD, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u00AD\u200D", expected: [][]rune{{0x00AD, 0x200D}}},                                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u200D", expected: [][]rune{{0x00AD, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u00AD\u0061\u2060", expected: [][]rune{{0x00AD}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u0061\u2060", expected: [][]rune{{0x00AD, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0061\u003A", expected: [][]rune{{0x00AD}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u0308\u0061\u003A", expected: [][]rune{{0x00AD, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u0061\u0027", expected: [][]rune{{0x00AD}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u0308\u0061\u0027", expected: [][]rune{{0x00AD, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u0061\u0027\u2060", expected: [][]rune{{0x00AD}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u0061\u0027\u2060", expected: [][]rune{{0x00AD, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0061\u002C", expected: [][]rune{{0x00AD}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u0308\u0061\u002C", expected: [][]rune{{0x00AD, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u0031\u003A", expected: [][]rune{{0x00AD}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u0308\u0031\u003A", expected: [][]rune{{0x00AD, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u00AD\u0031\u0027", expected: [][]rune{{0x00AD}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u0308\u0031\u0027", expected: [][]rune{{0x00AD, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u00AD\u0031\u002C", expected: [][]rune{{0x00AD}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u0308\u0031\u002C", expected: [][]rune{{0x00AD, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u00AD\u0031\u002E\u2060", expected: [][]rune{{0x00AD}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u00AD\u0308\u0031\u002E\u2060", expected: [][]rune{{0x00AD, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0001", expected: [][]rune{{0x0300}, {0x0001}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0300\u0308\u0001", expected: [][]rune{{0x0300, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0300\u000D", expected: [][]rune{{0x0300}, {0x000D}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u0308\u000D", expected: [][]rune{{0x0300, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0300\u000A", expected: [][]rune{{0x0300}, {0x000A}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u0308\u000A", expected: [][]rune{{0x0300, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0300\u000B", expected: [][]rune{{0x0300}, {0x000B}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0300\u0308\u000B", expected: [][]rune{{0x0300, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0300\u3031", expected: [][]rune{{0x0300}, {0x3031}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0300\u0308\u3031", expected: [][]rune{{0x0300, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0300\u0041", expected: [][]rune{{0x0300}, {0x0041}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0300\u0308\u0041", expected: [][]rune{{0x0300, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0300\u003A", expected: [][]rune{{0x0300}, {0x003A}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u0308\u003A", expected: [][]rune{{0x0300, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u002C", expected: [][]rune{{0x0300}, {0x002C}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u0308\u002C", expected: [][]rune{{0x0300, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u002E", expected: [][]rune{{0x0300}, {0x002E}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0300\u0308\u002E", expected: [][]rune{{0x0300, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0300\u0030", expected: [][]rune{{0x0300}, {0x0030}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0300\u0308\u0030", expected: [][]rune{{0x0300, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0300\u005F", expected: [][]rune{{0x0300}, {0x005F}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0300\u0308\u005F", expected: [][]rune{{0x0300, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0300\U0001F1E6", expected: [][]rune{{0x0300}, {0x1F1E6}}},                                                                            // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0300\u0308\U0001F1E6", expected: [][]rune{{0x0300, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0300\u05D0", expected: [][]rune{{0x0300}, {0x05D0}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0300\u0308\u05D0", expected: [][]rune{{0x0300, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0300\u0022", expected: [][]rune{{0x0300}, {0x0022}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0300\u0308\u0022", expected: [][]rune{{0x0300, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0300\u0027", expected: [][]rune{{0x0300}, {0x0027}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u0308\u0027", expected: [][]rune{{0x0300, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u231A", expected: [][]rune{{0x0300}, {0x231A}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0300\u0308\u231A", expected: [][]rune{{0x0300, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0300\u0020", expected: [][]rune{{0x0300}, {0x0020}}},                                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0300\u0308\u0020", expected: [][]rune{{0x0300, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0300\u00AD", expected: [][]rune{{0x0300, 0x00AD}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0300\u0308\u00AD", expected: [][]rune{{0x0300, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0300\u0300", expected: [][]rune{{0x0300, 0x0300}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0300\u0308\u0300", expected: [][]rune{{0x0300, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0300\u200D", expected: [][]rune{{0x0300, 0x200D}}},                                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0300\u0308\u200D", expected: [][]rune{{0x0300, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0300\u0061\u2060", expected: [][]rune{{0x0300}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0308\u0061\u2060", expected: [][]rune{{0x0300, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0061\u003A", expected: [][]rune{{0x0300}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u0308\u0061\u003A", expected: [][]rune{{0x0300, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u0061\u0027", expected: [][]rune{{0x0300}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u0308\u0061\u0027", expected: [][]rune{{0x0300, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u0061\u0027\u2060", expected: [][]rune{{0x0300}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0300, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0061\u002C", expected: [][]rune{{0x0300}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u0308\u0061\u002C", expected: [][]rune{{0x0300, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u0031\u003A", expected: [][]rune{{0x0300}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u0308\u0031\u003A", expected: [][]rune{{0x0300, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0300\u0031\u0027", expected: [][]rune{{0x0300}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u0308\u0031\u0027", expected: [][]rune{{0x0300, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0300\u0031\u002C", expected: [][]rune{{0x0300}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u0308\u0031\u002C", expected: [][]rune{{0x0300, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0300\u0031\u002E\u2060", expected: [][]rune{{0x0300}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0300\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0300, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0001", expected: [][]rune{{0x200D}, {0x0001}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u200D\u0308\u0001", expected: [][]rune{{0x200D, 0x0308}, {0x0001}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u200D\u000D", expected: [][]rune{{0x200D}, {0x000D}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u200D\u0308\u000D", expected: [][]rune{{0x200D, 0x0308}, {0x000D}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u200D\u000A", expected: [][]rune{{0x200D}, {0x000A}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u200D\u0308\u000A", expected: [][]rune{{0x200D, 0x0308}, {0x000A}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u200D\u000B", expected: [][]rune{{0x200D}, {0x000B}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u200D\u0308\u000B", expected: [][]rune{{0x200D, 0x0308}, {0x000B}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u200D\u3031", expected: [][]rune{{0x200D}, {0x3031}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u200D\u0308\u3031", expected: [][]rune{{0x200D, 0x0308}, {0x3031}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u200D\u0041", expected: [][]rune{{0x200D}, {0x0041}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u200D\u0308\u0041", expected: [][]rune{{0x200D, 0x0308}, {0x0041}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u200D\u003A", expected: [][]rune{{0x200D}, {0x003A}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u0308\u003A", expected: [][]rune{{0x200D, 0x0308}, {0x003A}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u002C", expected: [][]rune{{0x200D}, {0x002C}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u0308\u002C", expected: [][]rune{{0x200D, 0x0308}, {0x002C}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u002E", expected: [][]rune{{0x200D}, {0x002E}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u200D\u0308\u002E", expected: [][]rune{{0x200D, 0x0308}, {0x002E}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u200D\u0030", expected: [][]rune{{0x200D}, {0x0030}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u200D\u0308\u0030", expected: [][]rune{{0x200D, 0x0308}, {0x0030}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u200D\u005F", expected: [][]rune{{0x200D}, {0x005F}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u200D\u0308\u005F", expected: [][]rune{{0x200D, 0x0308}, {0x005F}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u200D\U0001F1E6", expected: [][]rune{{0x200D}, {0x1F1E6}}},                                                                            // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u200D\u0308\U0001F1E6", expected: [][]rune{{0x200D, 0x0308}, {0x1F1E6}}},                                                              // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u200D\u05D0", expected: [][]rune{{0x200D}, {0x05D0}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u200D\u0308\u05D0", expected: [][]rune{{0x200D, 0x0308}, {0x05D0}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u200D\u0022", expected: [][]rune{{0x200D}, {0x0022}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u200D\u0308\u0022", expected: [][]rune{{0x200D, 0x0308}, {0x0022}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u200D\u0027", expected: [][]rune{{0x200D}, {0x0027}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u0308\u0027", expected: [][]rune{{0x200D, 0x0308}, {0x0027}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u231A", expected: [][]rune{{0x200D, 0x231A}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] WATCH (ExtPict) ÷ [0.3]
	{original: "\u200D\u0308\u231A", expected: [][]rune{{0x200D, 0x0308}, {0x231A}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u200D\u0020", expected: [][]rune{{0x200D}, {0x0020}}},                                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u200D\u0308\u0020", expected: [][]rune{{0x200D, 0x0308}, {0x0020}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u200D\u00AD", expected: [][]rune{{0x200D, 0x00AD}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u200D\u0308\u00AD", expected: [][]rune{{0x200D, 0x0308, 0x00AD}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u200D\u0300", expected: [][]rune{{0x200D, 0x0300}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u200D\u0308\u0300", expected: [][]rune{{0x200D, 0x0308, 0x0300}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u200D\u200D", expected: [][]rune{{0x200D, 0x200D}}},                                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u200D\u0308\u200D", expected: [][]rune{{0x200D, 0x0308, 0x200D}}},                                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u200D\u0061\u2060", expected: [][]rune{{0x200D}, {0x0061, 0x2060}}},                                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0308\u0061\u2060", expected: [][]rune{{0x200D, 0x0308}, {0x0061, 0x2060}}},                                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0061\u003A", expected: [][]rune{{0x200D}, {0x0061}, {0x003A}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u0308\u0061\u003A", expected: [][]rune{{0x200D, 0x0308}, {0x0061}, {0x003A}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u0061\u0027", expected: [][]rune{{0x200D}, {0x0061}, {0x0027}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u0308\u0061\u0027", expected: [][]rune{{0x200D, 0x0308}, {0x0061}, {0x0027}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u0061\u0027\u2060", expected: [][]rune{{0x200D}, {0x0061}, {0x0027, 0x2060}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0308\u0061\u0027\u2060", expected: [][]rune{{0x200D, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0061\u002C", expected: [][]rune{{0x200D}, {0x0061}, {0x002C}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u0308\u0061\u002C", expected: [][]rune{{0x200D, 0x0308}, {0x0061}, {0x002C}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u0031\u003A", expected: [][]rune{{0x200D}, {0x0031}, {0x003A}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u0308\u0031\u003A", expected: [][]rune{{0x200D, 0x0308}, {0x0031}, {0x003A}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u200D\u0031\u0027", expected: [][]rune{{0x200D}, {0x0031}, {0x0027}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u0308\u0031\u0027", expected: [][]rune{{0x200D, 0x0308}, {0x0031}, {0x0027}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u200D\u0031\u002C", expected: [][]rune{{0x200D}, {0x0031}, {0x002C}}},                                                                 // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u0308\u0031\u002C", expected: [][]rune{{0x200D, 0x0308}, {0x0031}, {0x002C}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u200D\u0031\u002E\u2060", expected: [][]rune{{0x200D}, {0x0031}, {0x002E, 0x2060}}},                                                   // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u200D\u0308\u0031\u002E\u2060", expected: [][]rune{{0x200D, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                                     // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0001", expected: [][]rune{{0x0061, 0x2060}, {0x0001}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0001", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x0001}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u2060\u000D", expected: [][]rune{{0x0061, 0x2060}, {0x000D}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u000D", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x000D}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u2060\u000A", expected: [][]rune{{0x0061, 0x2060}, {0x000A}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u000A", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x000A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u2060\u000B", expected: [][]rune{{0x0061, 0x2060}, {0x000B}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u000B", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x000B}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u2060\u3031", expected: [][]rune{{0x0061, 0x2060}, {0x3031}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u3031", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x3031}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u2060\u0041", expected: [][]rune{{0x0061, 0x2060, 0x0041}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0041", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0041}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u2060\u003A", expected: [][]rune{{0x0061, 0x2060}, {0x003A}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u003A", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x003A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u002C", expected: [][]rune{{0x0061, 0x2060}, {0x002C}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u002C", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x002C}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u002E", expected: [][]rune{{0x0061, 0x2060}, {0x002E}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u002E", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x002E}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u2060\u0030", expected: [][]rune{{0x0061, 0x2060, 0x0030}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0030", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0030}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u2060\u005F", expected: [][]rune{{0x0061, 0x2060, 0x005F}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u005F", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x005F}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u2060\U0001F1E6", expected: [][]rune{{0x0061, 0x2060}, {0x1F1E6}}},                                                              // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u2060\u0308\U0001F1E6", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x1F1E6}}},                                                // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u2060\u05D0", expected: [][]rune{{0x0061, 0x2060, 0x05D0}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u05D0", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x05D0}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u2060\u0022", expected: [][]rune{{0x0061, 0x2060}, {0x0022}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0022", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x0022}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0027", expected: [][]rune{{0x0061, 0x2060}, {0x0027}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0027", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x0027}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u231A", expected: [][]rune{{0x0061, 0x2060}, {0x231A}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u231A", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x231A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u2060\u0020", expected: [][]rune{{0x0061, 0x2060}, {0x0020}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0020", expected: [][]rune{{0x0061, 0x2060, 0x0308}, {0x0020}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u2060\u00AD", expected: [][]rune{{0x0061, 0x2060, 0x00AD}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u00AD", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x00AD}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0300", expected: [][]rune{{0x0061, 0x2060, 0x0300}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0300", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0300}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u2060\u200D", expected: [][]rune{{0x0061, 0x2060, 0x200D}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u200D", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x200D}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0061\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0061, 0x2060}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0061\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0061, 0x2060}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0061\u003A", expected: [][]rune{{0x0061, 0x2060, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0061\u003A", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0061}, {0x003A}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u0061\u0027", expected: [][]rune{{0x0061, 0x2060, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0061\u0027", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0061}, {0x0027}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0061}, {0x0027, 0x2060}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0061\u002C", expected: [][]rune{{0x0061, 0x2060, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0061\u002C", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0061}, {0x002C}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u0031\u003A", expected: [][]rune{{0x0061, 0x2060, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0031\u003A", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0031}, {0x003A}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u2060\u0031\u0027", expected: [][]rune{{0x0061, 0x2060, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0031\u0027", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0031}, {0x0027}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u2060\u0031\u002C", expected: [][]rune{{0x0061, 0x2060, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0031\u002C", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0031}, {0x002C}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u2060\u0031\u002E\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u2060\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0061, 0x2060, 0x0308, 0x0031}, {0x002E, 0x2060}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0001", expected: [][]rune{{0x0061}, {0x003A}, {0x0001}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0001", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u003A\u000D", expected: [][]rune{{0x0061}, {0x003A}, {0x000D}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u000D", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u003A\u000A", expected: [][]rune{{0x0061}, {0x003A}, {0x000A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u000A", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u003A\u000B", expected: [][]rune{{0x0061}, {0x003A}, {0x000B}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u000B", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u003A\u3031", expected: [][]rune{{0x0061}, {0x003A}, {0x3031}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u3031", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u003A\u0041", expected: [][]rune{{0x0061, 0x003A, 0x0041}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0041", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0041}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u003A\u003A", expected: [][]rune{{0x0061}, {0x003A}, {0x003A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u003A", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u002C", expected: [][]rune{{0x0061}, {0x003A}, {0x002C}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u002C", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u002E", expected: [][]rune{{0x0061}, {0x003A}, {0x002E}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u002E", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u003A\u0030", expected: [][]rune{{0x0061}, {0x003A}, {0x0030}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0030", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0030}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u003A\u005F", expected: [][]rune{{0x0061}, {0x003A}, {0x005F}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u005F", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u003A\U0001F1E6", expected: [][]rune{{0x0061}, {0x003A}, {0x1F1E6}}},                                                            // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u003A\u0308\U0001F1E6", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u003A\u05D0", expected: [][]rune{{0x0061, 0x003A, 0x05D0}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u05D0", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x05D0}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u003A\u0022", expected: [][]rune{{0x0061}, {0x003A}, {0x0022}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0022", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0027", expected: [][]rune{{0x0061}, {0x003A}, {0x0027}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0027", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u231A", expected: [][]rune{{0x0061}, {0x003A}, {0x231A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u231A", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u003A\u0020", expected: [][]rune{{0x0061}, {0x003A}, {0x0020}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0020", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u003A\u00AD", expected: [][]rune{{0x0061}, {0x003A, 0x00AD}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u00AD", expected: [][]rune{{0x0061}, {0x003A, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0300", expected: [][]rune{{0x0061}, {0x003A, 0x0300}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0300", expected: [][]rune{{0x0061}, {0x003A, 0x0308, 0x0300}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u003A\u200D", expected: [][]rune{{0x0061}, {0x003A, 0x200D}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u200D", expected: [][]rune{{0x0061}, {0x003A, 0x0308, 0x200D}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0061\u2060", expected: [][]rune{{0x0061, 0x003A, 0x0061, 0x2060}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0061\u2060", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0061, 0x2060}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0061\u003A", expected: [][]rune{{0x0061, 0x003A, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0061\u003A", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0061}, {0x003A}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u0061\u0027", expected: [][]rune{{0x0061, 0x003A, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0061\u0027", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0061}, {0x0027}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x003A, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0061}, {0x0027, 0x2060}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0061\u002C", expected: [][]rune{{0x0061, 0x003A, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0061\u002C", expected: [][]rune{{0x0061, 0x003A, 0x0308, 0x0061}, {0x002C}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u0031\u003A", expected: [][]rune{{0x0061}, {0x003A}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0031\u003A", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0031}, {0x003A}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u003A\u0031\u0027", expected: [][]rune{{0x0061}, {0x003A}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0031\u0027", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0031}, {0x0027}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u003A\u0031\u002C", expected: [][]rune{{0x0061}, {0x003A}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0031\u002C", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0031}, {0x002C}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u003A\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x003A}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u003A\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x003A, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0001", expected: [][]rune{{0x0061}, {0x0027}, {0x0001}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0001", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u0027\u000D", expected: [][]rune{{0x0061}, {0x0027}, {0x000D}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u000D", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u0027\u000A", expected: [][]rune{{0x0061}, {0x0027}, {0x000A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u000A", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0027\u000B", expected: [][]rune{{0x0061}, {0x0027}, {0x000B}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u000B", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u0027\u3031", expected: [][]rune{{0x0061}, {0x0027}, {0x3031}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u3031", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u0027\u0041", expected: [][]rune{{0x0061, 0x0027, 0x0041}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0041", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0041}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u0027\u003A", expected: [][]rune{{0x0061}, {0x0027}, {0x003A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u002C", expected: [][]rune{{0x0061}, {0x0027}, {0x002C}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u002E", expected: [][]rune{{0x0061}, {0x0027}, {0x002E}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u002E", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u0030", expected: [][]rune{{0x0061}, {0x0027}, {0x0030}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0030", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0030}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u0027\u005F", expected: [][]rune{{0x0061}, {0x0027}, {0x005F}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u005F", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u0027\U0001F1E6", expected: [][]rune{{0x0061}, {0x0027}, {0x1F1E6}}},                                                            // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u0027\u0308\U0001F1E6", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u0027\u05D0", expected: [][]rune{{0x0061, 0x0027, 0x05D0}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u05D0", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x05D0}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u0027\u0022", expected: [][]rune{{0x0061}, {0x0027}, {0x0022}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0022", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0027", expected: [][]rune{{0x0061}, {0x0027}, {0x0027}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u231A", expected: [][]rune{{0x0061}, {0x0027}, {0x231A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u231A", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u0027\u0020", expected: [][]rune{{0x0061}, {0x0027}, {0x0020}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0020", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u0027\u00AD", expected: [][]rune{{0x0061}, {0x0027, 0x00AD}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u00AD", expected: [][]rune{{0x0061}, {0x0027, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0300", expected: [][]rune{{0x0061}, {0x0027, 0x0300}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0300", expected: [][]rune{{0x0061}, {0x0027, 0x0308, 0x0300}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0027\u200D", expected: [][]rune{{0x0061}, {0x0027, 0x200D}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u200D", expected: [][]rune{{0x0061}, {0x0027, 0x0308, 0x200D}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0061\u2060", expected: [][]rune{{0x0061, 0x0027, 0x0061, 0x2060}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0061\u2060", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0061, 0x2060}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0061\u003A", expected: [][]rune{{0x0061, 0x0027, 0x0061}, {0x003A}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0061\u003A", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0061}, {0x003A}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u0061\u0027", expected: [][]rune{{0x0061, 0x0027, 0x0061}, {0x0027}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0061\u0027", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0061}, {0x0027}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x0027, 0x0061}, {0x0027, 0x2060}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0061}, {0x0027, 0x2060}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0061\u002C", expected: [][]rune{{0x0061, 0x0027, 0x0061}, {0x002C}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0061\u002C", expected: [][]rune{{0x0061, 0x0027, 0x0308, 0x0061}, {0x002C}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u0031\u003A", expected: [][]rune{{0x0061}, {0x0027}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0031\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0031}, {0x003A}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u0031\u0027", expected: [][]rune{{0x0061}, {0x0027}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0031\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0031}, {0x0027}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u0031\u002C", expected: [][]rune{{0x0061}, {0x0027}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0031\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0031}, {0x002C}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x0027}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x0027, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0001", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0001}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0001", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0001}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u000D", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x000D}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u000D", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x000D}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u000A", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x000A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u000A", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x000A}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u000B", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x000B}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u000B", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x000B}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u3031", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x3031}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u3031", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x3031}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0041", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0041}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0041", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0041}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x003A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x003A}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x002C}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x002C}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u002E", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x002E}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u002E", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x002E}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0030", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0030}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0030", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0030}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u005F", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x005F}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u005F", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x005F}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u0027\u2060\U0001F1E6", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x1F1E6}}},                                              // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\U0001F1E6", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x1F1E6}}},                                // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u05D0", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x05D0}}},                                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u05D0", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x05D0}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0022", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0022}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0022", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0022}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0027}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0027}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u231A", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x231A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u231A", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x231A}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0020", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0020}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0020", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0020}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u00AD", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x00AD}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u00AD", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308, 0x00AD}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0300", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0300}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0300", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308, 0x0300}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u200D", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x200D}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u200D", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308, 0x200D}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0061\u2060", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0061, 0x2060}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0061\u2060", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0061, 0x2060}}},                           // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0061\u003A", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0061}, {0x003A}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0061\u003A", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0061}, {0x003A}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0061\u0027", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0061}, {0x0027}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0061\u0027", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0061}, {0x0027}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0061}, {0x0027, 0x2060}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0061}, {0x0027, 0x2060}}},           // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0061\u002C", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0061}, {0x002C}}},                                       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0061\u002C", expected: [][]rune{{0x0061, 0x0027, 0x2060, 0x0308, 0x0061}, {0x002C}}},                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0031\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0031}, {0x003A}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0031\u003A", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0031}, {0x003A}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0031\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0031}, {0x0027}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0031\u0027", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0031}, {0x0027}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0031\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0031}, {0x002C}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0031\u002C", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0031}, {0x002C}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x0027, 0x2060}, {0x0031}, {0x002E, 0x2060}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u0027\u2060\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x0027, 0x2060, 0x0308}, {0x0031}, {0x002E, 0x2060}}},       // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0001", expected: [][]rune{{0x0061}, {0x002C}, {0x0001}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0001", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0061\u002C\u000D", expected: [][]rune{{0x0061}, {0x002C}, {0x000D}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u000D", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0061\u002C\u000A", expected: [][]rune{{0x0061}, {0x002C}, {0x000A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u000A", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0061\u002C\u000B", expected: [][]rune{{0x0061}, {0x002C}, {0x000B}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u000B", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0061\u002C\u3031", expected: [][]rune{{0x0061}, {0x002C}, {0x3031}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u3031", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0061\u002C\u0041", expected: [][]rune{{0x0061}, {0x002C}, {0x0041}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0041", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0041}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002C\u003A", expected: [][]rune{{0x0061}, {0x002C}, {0x003A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u003A", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u002C", expected: [][]rune{{0x0061}, {0x002C}, {0x002C}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u002C", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u002E", expected: [][]rune{{0x0061}, {0x002C}, {0x002E}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u002E", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0061\u002C\u0030", expected: [][]rune{{0x0061}, {0x002C}, {0x0030}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0030", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0030}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0061\u002C\u005F", expected: [][]rune{{0x0061}, {0x002C}, {0x005F}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u005F", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0061\u002C\U0001F1E6", expected: [][]rune{{0x0061}, {0x002C}, {0x1F1E6}}},                                                            // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u002C\u0308\U0001F1E6", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0061\u002C\u05D0", expected: [][]rune{{0x0061}, {0x002C}, {0x05D0}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u05D0", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x05D0}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0061\u002C\u0022", expected: [][]rune{{0x0061}, {0x002C}, {0x0022}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0022", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0027", expected: [][]rune{{0x0061}, {0x002C}, {0x0027}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0027", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u231A", expected: [][]rune{{0x0061}, {0x002C}, {0x231A}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u231A", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0061\u002C\u0020", expected: [][]rune{{0x0061}, {0x002C}, {0x0020}}},                                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0020", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0061\u002C\u00AD", expected: [][]rune{{0x0061}, {0x002C, 0x00AD}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u00AD", expected: [][]rune{{0x0061}, {0x002C, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0300", expected: [][]rune{{0x0061}, {0x002C, 0x0300}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0300", expected: [][]rune{{0x0061}, {0x002C, 0x0308, 0x0300}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0061\u002C\u200D", expected: [][]rune{{0x0061}, {0x002C, 0x200D}}},                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u200D", expected: [][]rune{{0x0061}, {0x002C, 0x0308, 0x200D}}},                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0061\u2060", expected: [][]rune{{0x0061}, {0x002C}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0061\u2060", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0061, 0x2060}}},                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0061\u003A", expected: [][]rune{{0x0061}, {0x002C}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0061\u003A", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0061}, {0x003A}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u0061\u0027", expected: [][]rune{{0x0061}, {0x002C}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0061\u0027", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0061}, {0x0027}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0061\u0027\u2060", expected: [][]rune{{0x0061}, {0x002C}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0061\u002C", expected: [][]rune{{0x0061}, {0x002C}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0061\u002C", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0061}, {0x002C}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u0031\u003A", expected: [][]rune{{0x0061}, {0x002C}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0031\u003A", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0031}, {0x003A}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0061\u002C\u0031\u0027", expected: [][]rune{{0x0061}, {0x002C}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0031\u0027", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0031}, {0x0027}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0061\u002C\u0031\u002C", expected: [][]rune{{0x0061}, {0x002C}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0031\u002C", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0031}, {0x002C}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0061\u002C\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x002C}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0061\u002C\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0061}, {0x002C, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0001", expected: [][]rune{{0x0031}, {0x003A}, {0x0001}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0001", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u003A\u000D", expected: [][]rune{{0x0031}, {0x003A}, {0x000D}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u000D", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u003A\u000A", expected: [][]rune{{0x0031}, {0x003A}, {0x000A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u000A", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u003A\u000B", expected: [][]rune{{0x0031}, {0x003A}, {0x000B}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u000B", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u003A\u3031", expected: [][]rune{{0x0031}, {0x003A}, {0x3031}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u3031", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u003A\u0041", expected: [][]rune{{0x0031}, {0x003A}, {0x0041}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0041", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0041}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u003A\u003A", expected: [][]rune{{0x0031}, {0x003A}, {0x003A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u003A", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u002C", expected: [][]rune{{0x0031}, {0x003A}, {0x002C}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u002C", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u002E", expected: [][]rune{{0x0031}, {0x003A}, {0x002E}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u002E", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u003A\u0030", expected: [][]rune{{0x0031}, {0x003A}, {0x0030}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0030", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0030}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u003A\u005F", expected: [][]rune{{0x0031}, {0x003A}, {0x005F}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u005F", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u003A\U0001F1E6", expected: [][]rune{{0x0031}, {0x003A}, {0x1F1E6}}},                                                            // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u003A\u0308\U0001F1E6", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u003A\u05D0", expected: [][]rune{{0x0031}, {0x003A}, {0x05D0}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u05D0", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x05D0}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u003A\u0022", expected: [][]rune{{0x0031}, {0x003A}, {0x0022}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0022", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0027", expected: [][]rune{{0x0031}, {0x003A}, {0x0027}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0027", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u231A", expected: [][]rune{{0x0031}, {0x003A}, {0x231A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u231A", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u003A\u0020", expected: [][]rune{{0x0031}, {0x003A}, {0x0020}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0020", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u003A\u00AD", expected: [][]rune{{0x0031}, {0x003A, 0x00AD}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u00AD", expected: [][]rune{{0x0031}, {0x003A, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0300", expected: [][]rune{{0x0031}, {0x003A, 0x0300}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0300", expected: [][]rune{{0x0031}, {0x003A, 0x0308, 0x0300}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u003A\u200D", expected: [][]rune{{0x0031}, {0x003A, 0x200D}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u200D", expected: [][]rune{{0x0031}, {0x003A, 0x0308, 0x200D}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0061\u2060", expected: [][]rune{{0x0031}, {0x003A}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0061\u2060", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0061, 0x2060}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0061\u003A", expected: [][]rune{{0x0031}, {0x003A}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0061\u003A", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0061}, {0x003A}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u0061\u0027", expected: [][]rune{{0x0031}, {0x003A}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0061\u0027", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0061}, {0x0027}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x003A}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0061\u002C", expected: [][]rune{{0x0031}, {0x003A}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0061\u002C", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0061}, {0x002C}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u0031\u003A", expected: [][]rune{{0x0031}, {0x003A}, {0x0031}, {0x003A}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0031\u003A", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0031}, {0x003A}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u003A\u0031\u0027", expected: [][]rune{{0x0031}, {0x003A}, {0x0031}, {0x0027}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0031\u0027", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0031}, {0x0027}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u003A\u0031\u002C", expected: [][]rune{{0x0031}, {0x003A}, {0x0031}, {0x002C}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0031\u002C", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0031}, {0x002C}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u003A\u0031\u002E\u2060", expected: [][]rune{{0x0031}, {0x003A}, {0x0031}, {0x002E, 0x2060}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u003A\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0031}, {0x003A, 0x0308}, {0x0031}, {0x002E, 0x2060}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0001", expected: [][]rune{{0x0031}, {0x0027}, {0x0001}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0001", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u0027\u000D", expected: [][]rune{{0x0031}, {0x0027}, {0x000D}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u000D", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u0027\u000A", expected: [][]rune{{0x0031}, {0x0027}, {0x000A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u000A", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u0027\u000B", expected: [][]rune{{0x0031}, {0x0027}, {0x000B}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u000B", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u0027\u3031", expected: [][]rune{{0x0031}, {0x0027}, {0x3031}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u3031", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u0027\u0041", expected: [][]rune{{0x0031}, {0x0027}, {0x0041}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0041", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0041}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u0027\u003A", expected: [][]rune{{0x0031}, {0x0027}, {0x003A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u003A", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u002C", expected: [][]rune{{0x0031}, {0x0027}, {0x002C}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u002C", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u002E", expected: [][]rune{{0x0031}, {0x0027}, {0x002E}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u002E", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u0027\u0030", expected: [][]rune{{0x0031, 0x0027, 0x0030}}},                                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0030", expected: [][]rune{{0x0031, 0x0027, 0x0308, 0x0030}}},                                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u0027\u005F", expected: [][]rune{{0x0031}, {0x0027}, {0x005F}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u005F", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u0027\U0001F1E6", expected: [][]rune{{0x0031}, {0x0027}, {0x1F1E6}}},                                                            // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u0027\u0308\U0001F1E6", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u0027\u05D0", expected: [][]rune{{0x0031}, {0x0027}, {0x05D0}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u05D0", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x05D0}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u0027\u0022", expected: [][]rune{{0x0031}, {0x0027}, {0x0022}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0022", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0027", expected: [][]rune{{0x0031}, {0x0027}, {0x0027}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0027", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u231A", expected: [][]rune{{0x0031}, {0x0027}, {0x231A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u231A", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u0027\u0020", expected: [][]rune{{0x0031}, {0x0027}, {0x0020}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0020", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u0027\u00AD", expected: [][]rune{{0x0031}, {0x0027, 0x00AD}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u00AD", expected: [][]rune{{0x0031}, {0x0027, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0300", expected: [][]rune{{0x0031}, {0x0027, 0x0300}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0300", expected: [][]rune{{0x0031}, {0x0027, 0x0308, 0x0300}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u0027\u200D", expected: [][]rune{{0x0031}, {0x0027, 0x200D}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u200D", expected: [][]rune{{0x0031}, {0x0027, 0x0308, 0x200D}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0061\u2060", expected: [][]rune{{0x0031}, {0x0027}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0061\u2060", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0061, 0x2060}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0061\u003A", expected: [][]rune{{0x0031}, {0x0027}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0061\u003A", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0061}, {0x003A}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u0061\u0027", expected: [][]rune{{0x0031}, {0x0027}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0061\u0027", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0061}, {0x0027}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x0027}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0061\u002C", expected: [][]rune{{0x0031}, {0x0027}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0061\u002C", expected: [][]rune{{0x0031}, {0x0027, 0x0308}, {0x0061}, {0x002C}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u0031\u003A", expected: [][]rune{{0x0031, 0x0027, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0031\u003A", expected: [][]rune{{0x0031, 0x0027, 0x0308, 0x0031}, {0x003A}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u0027\u0031\u0027", expected: [][]rune{{0x0031, 0x0027, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0031\u0027", expected: [][]rune{{0x0031, 0x0027, 0x0308, 0x0031}, {0x0027}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u0027\u0031\u002C", expected: [][]rune{{0x0031, 0x0027, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0031\u002C", expected: [][]rune{{0x0031, 0x0027, 0x0308, 0x0031}, {0x002C}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u0027\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x0027, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u0027\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x0027, 0x0308, 0x0031}, {0x002E, 0x2060}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0001", expected: [][]rune{{0x0031}, {0x002C}, {0x0001}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0001", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0001}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u002C\u000D", expected: [][]rune{{0x0031}, {0x002C}, {0x000D}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u000D", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x000D}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u002C\u000A", expected: [][]rune{{0x0031}, {0x002C}, {0x000A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u000A", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x000A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u002C\u000B", expected: [][]rune{{0x0031}, {0x002C}, {0x000B}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u000B", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x000B}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u002C\u3031", expected: [][]rune{{0x0031}, {0x002C}, {0x3031}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u3031", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x3031}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u002C\u0041", expected: [][]rune{{0x0031}, {0x002C}, {0x0041}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0041", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0041}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002C\u003A", expected: [][]rune{{0x0031}, {0x002C}, {0x003A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u003A", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x003A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u002C", expected: [][]rune{{0x0031}, {0x002C}, {0x002C}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u002C", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x002C}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u002E", expected: [][]rune{{0x0031}, {0x002C}, {0x002E}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u002E", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x002E}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u002C\u0030", expected: [][]rune{{0x0031, 0x002C, 0x0030}}},                                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0030", expected: [][]rune{{0x0031, 0x002C, 0x0308, 0x0030}}},                                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u002C\u005F", expected: [][]rune{{0x0031}, {0x002C}, {0x005F}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u005F", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x005F}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u002C\U0001F1E6", expected: [][]rune{{0x0031}, {0x002C}, {0x1F1E6}}},                                                            // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u002C\u0308\U0001F1E6", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x1F1E6}}},                                              // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u002C\u05D0", expected: [][]rune{{0x0031}, {0x002C}, {0x05D0}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u05D0", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x05D0}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u002C\u0022", expected: [][]rune{{0x0031}, {0x002C}, {0x0022}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0022", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0022}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0027", expected: [][]rune{{0x0031}, {0x002C}, {0x0027}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0027", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0027}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u231A", expected: [][]rune{{0x0031}, {0x002C}, {0x231A}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u231A", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x231A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u002C\u0020", expected: [][]rune{{0x0031}, {0x002C}, {0x0020}}},                                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0020", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0020}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u002C\u00AD", expected: [][]rune{{0x0031}, {0x002C, 0x00AD}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u00AD", expected: [][]rune{{0x0031}, {0x002C, 0x0308, 0x00AD}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0300", expected: [][]rune{{0x0031}, {0x002C, 0x0300}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0300", expected: [][]rune{{0x0031}, {0x002C, 0x0308, 0x0300}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u002C\u200D", expected: [][]rune{{0x0031}, {0x002C, 0x200D}}},                                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u200D", expected: [][]rune{{0x0031}, {0x002C, 0x0308, 0x200D}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0061\u2060", expected: [][]rune{{0x0031}, {0x002C}, {0x0061, 0x2060}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0061\u2060", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0061, 0x2060}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0061\u003A", expected: [][]rune{{0x0031}, {0x002C}, {0x0061}, {0x003A}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0061\u003A", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0061}, {0x003A}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u0061\u0027", expected: [][]rune{{0x0031}, {0x002C}, {0x0061}, {0x0027}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0061\u0027", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0061}, {0x0027}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x002C}, {0x0061}, {0x0027, 0x2060}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0061}, {0x0027, 0x2060}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0061\u002C", expected: [][]rune{{0x0031}, {0x002C}, {0x0061}, {0x002C}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0061\u002C", expected: [][]rune{{0x0031}, {0x002C, 0x0308}, {0x0061}, {0x002C}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u0031\u003A", expected: [][]rune{{0x0031, 0x002C, 0x0031}, {0x003A}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0031\u003A", expected: [][]rune{{0x0031, 0x002C, 0x0308, 0x0031}, {0x003A}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002C\u0031\u0027", expected: [][]rune{{0x0031, 0x002C, 0x0031}, {0x0027}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0031\u0027", expected: [][]rune{{0x0031, 0x002C, 0x0308, 0x0031}, {0x0027}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002C\u0031\u002C", expected: [][]rune{{0x0031, 0x002C, 0x0031}, {0x002C}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0031\u002C", expected: [][]rune{{0x0031, 0x002C, 0x0308, 0x0031}, {0x002C}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002C\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x002C, 0x0031}, {0x002E, 0x2060}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002C\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x002C, 0x0308, 0x0031}, {0x002E, 0x2060}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0001", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0001}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0001", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0001}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u000D", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x000D}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u000D", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x000D}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u000A", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x000A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u000A", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x000A}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u000B", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x000B}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u000B", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x000B}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u3031", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x3031}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u3031", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x3031}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0041", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0041}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0041", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0041}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u003A", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x003A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u003A", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x003A}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u002C", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x002C}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u002C", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x002C}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u002E", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x002E}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u002E", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x002E}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0030", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0030}}},                                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0030", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0308, 0x0030}}},                                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u005F", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x005F}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u005F", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x005F}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0031\u002E\u2060\U0001F1E6", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x1F1E6}}},                                              // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\U0001F1E6", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x1F1E6}}},                                // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u05D0", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x05D0}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u05D0", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x05D0}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0022", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0022}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0022", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0022}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0027", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0027}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0027", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0027}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u231A", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x231A}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u231A", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x231A}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0020", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0020}}},                                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0020", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0020}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u00AD", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x00AD}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u00AD", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308, 0x00AD}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0300", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0300}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0300", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308, 0x0300}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u200D", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x200D}}},                                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u200D", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308, 0x200D}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0061\u2060", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0061, 0x2060}}},                                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0061\u2060", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0061, 0x2060}}},                       // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0061\u003A", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0061}, {0x003A}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0061\u003A", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0061}, {0x003A}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0061\u0027", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0061}, {0x0027}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0061\u0027", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0061}, {0x0027}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0061}, {0x0027, 0x2060}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0061\u0027\u2060", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0061}, {0x0027, 0x2060}}},       // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0061\u002C", expected: [][]rune{{0x0031}, {0x002E, 0x2060}, {0x0061}, {0x002C}}},                                   // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0061\u002C", expected: [][]rune{{0x0031}, {0x002E, 0x2060, 0x0308}, {0x0061}, {0x002C}}},                     // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0031\u003A", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0031}, {0x003A}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0031\u003A", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0308, 0x0031}, {0x003A}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0031\u0027", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0031}, {0x0027}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0031\u0027", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0308, 0x0031}, {0x0027}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0031\u002C", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0031}, {0x002C}}},                                       // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0031\u002C", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0308, 0x0031}, {0x002C}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0031}, {0x002E, 0x2060}}},                         // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u0031\u002E\u2060\u0308\u0031\u002E\u2060", expected: [][]rune{{0x0031, 0x002E, 0x2060, 0x0308, 0x0031}, {0x002E, 0x2060}}},           // ÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]
	{original: "\u000D\u000A\u0061\u000A\u0308", expected: [][]rune{{0x000D, 0x000A}, {0x0061}, {0x000A}, {0x0308}}},                                   // ÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]
	{original: "\u0061\u0308", expected: [][]rune{{0x0061, 0x0308}}},                                                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]
	{original: "\u0020\u200D\u0646", expected: [][]rune{{0x0020, 0x200D}, {0x0646}}},                                                                   // ÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] ARABIC LETTER NOON (ALetter) ÷ [0.3]
	{original: "\u0646\u200D\u0020", expected: [][]rune{{0x0646, 0x200D}, {0x0020}}},                                                                   // ÷ [0.2] ARABIC LETTER NOON (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]
	{original: "\u0041\u0041\u0041", expected: [][]rune{{0x0041, 0x0041, 0x0041}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0041\u003A\u0041", expected: [][]rune{{0x0041, 0x003A, 0x0041}}},                                                                     // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0041\u003A\u003A\u0041", expected: [][]rune{{0x0041}, {0x003A}, {0x003A}, {0x0041}}},                                                 // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u05D0\u0027", expected: [][]rune{{0x05D0, 0x0027}}},                                                                                   // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]
	{original: "\u05D0\u0022\u05D0", expected: [][]rune{{0x05D0, 0x0022, 0x05D0}}},                                                                     // ÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.2] QUOTATION MARK (Double_Quote) × [7.3] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]
	{original: "\u0041\u0030\u0030\u0041", expected: [][]rune{{0x0041, 0x0030, 0x0030, 0x0041}}},                                                       // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0030\u002C\u0030", expected: [][]rune{{0x0030, 0x002C, 0x0030}}},                                                                     // ÷ [0.2] DIGIT ZERO (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u0030\u002C\u002C\u0030", expected: [][]rune{{0x0030}, {0x002C}, {0x002C}, {0x0030}}},                                                 // ÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]
	{original: "\u3031\u3031", expected: [][]rune{{0x3031, 0x3031}}},                                                                                   // ÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]
	{original: "\u0041\u005F\u0030\u005F\u3031\u005F", expected: [][]rune{{0x0041, 0x005F, 0x0030, 0x005F, 0x3031, 0x005F}}},                           // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]
	{original: "\u0041\u005F\u005F\u0041", expected: [][]rune{{0x0041, 0x005F, 0x005F, 0x0041}}},                                                       // ÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]
	{original: "\U0001F1E6\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x1F1E6, 0x1F1E7}, {0x1F1E8}, {0x0062}}},                                    // ÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7}, {0x1F1E8}, {0x0062}}},                    // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\u200D\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7, 0x200D}, {0x1F1E8}, {0x0062}}},      // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0061\U0001F1E6\u200D\U0001F1E7\U0001F1E8\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x200D, 0x1F1E7}, {0x1F1E8}, {0x0062}}},      // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0061\U0001F1E6\U0001F1E7\U0001F1E8\U0001F1E9\u0062", expected: [][]rune{{0x0061}, {0x1F1E6, 0x1F1E7}, {0x1F1E8, 0x1F1E9}, {0x0062}}}, // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\U0001F476\U0001F3FF\U0001F476", expected: [][]rune{{0x1F476, 0x1F3FF}, {0x1F476}}},                                                    // ÷ [0.2] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [999.0] BABY (ExtPict) ÷ [0.3]
	{original: "\U0001F6D1\u200D\U0001F6D1", expected: [][]rune{{0x1F6D1, 0x200D, 0x1F6D1}}},                                                           // ÷ [0.2] OCTAGONAL SIGN (ExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u0061\u200D\U0001F6D1", expected: [][]rune{{0x0061, 0x200D, 0x1F6D1}}},                                                                // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u2701\u200D\u2701", expected: [][]rune{{0x2701, 0x200D, 0x2701}}},                                                                     // ÷ [0.2] UPPER BLADE SCISSORS (Other) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] UPPER BLADE SCISSORS (Other) ÷ [0.3]
	{original: "\u0061\u200D\u2701", expected: [][]rune{{0x0061, 0x200D, 0x2701}}},                                                                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] UPPER BLADE SCISSORS (Other) ÷ [0.3]
	{original: "\U0001F476\U0001F3FF\u0308\u200D\U0001F476\U0001F3FF", expected: [][]rune{{0x1F476, 0x1F3FF, 0x0308, 0x200D, 0x1F476, 0x1F3FF}}},       // ÷ [0.2] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]
	{original: "\U0001F6D1\U0001F3FF", expected: [][]rune{{0x1F6D1, 0x1F3FF}}},                                                                         // ÷ [0.2] OCTAGONAL SIGN (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]
	{original: "\u200D\U0001F6D1\U0001F3FF", expected: [][]rune{{0x200D, 0x1F6D1, 0x1F3FF}}},                                                           // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]
	{original: "\u200D\U0001F6D1", expected: [][]rune{{0x200D, 0x1F6D1}}},                                                                              // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u200D\U0001F6D1", expected: [][]rune{{0x200D, 0x1F6D1}}},                                                                              // ÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\U0001F6D1\U0001F6D1", expected: [][]rune{{0x1F6D1}, {0x1F6D1}}},                                                                       // ÷ [0.2] OCTAGONAL SIGN (ExtPict) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]
	{original: "\u0061\u0308\u200D\u0308\u0062", expected: [][]rune{{0x0061, 0x0308, 0x200D, 0x0308, 0x0062}}},                                         // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0061\u0020\u0020\u0062", expected: [][]rune{{0x0061}, {0x0020, 0x0020}, {0x0062}}},                                                   // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]
	{original: "\u0031\u003A\u003A\u0031", expected: [][]rune{{0x0031}, {0x003A}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u003A\u003A\u0061", expected: [][]rune{{0x0031}, {0x003A}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u003A\u002E\u0031", expected: [][]rune{{0x0031}, {0x003A}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u003A\u002E\u0061", expected: [][]rune{{0x0031}, {0x003A}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u003A\u002C\u0031", expected: [][]rune{{0x0031}, {0x003A}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u003A\u002C\u0061", expected: [][]rune{{0x0031}, {0x003A}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u003A\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x003A}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u003A\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x003A}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002E\u003A\u0031", expected: [][]rune{{0x0031}, {0x002E}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002E\u003A\u0061", expected: [][]rune{{0x0031}, {0x002E}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002E\u002E\u0031", expected: [][]rune{{0x0031}, {0x002E}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002E\u002E\u0061", expected: [][]rune{{0x0031}, {0x002E}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002E\u002C\u0031", expected: [][]rune{{0x0031}, {0x002E}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002E\u002C\u0061", expected: [][]rune{{0x0031}, {0x002E}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002E\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002E}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002E\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002E}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002C\u003A\u0031", expected: [][]rune{{0x0031}, {0x002C}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u003A\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x003A}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002C\u003A\u0061", expected: [][]rune{{0x0031}, {0x002C}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u003A\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x003A}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002C\u002E\u0031", expected: [][]rune{{0x0031}, {0x002C}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u002E\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x002E}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002C\u002E\u0061", expected: [][]rune{{0x0031}, {0x002C}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u002E\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x002E}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u002C\u002C\u0031", expected: [][]rune{{0x0031}, {0x002C}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u002C\u0031", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x002C}, {0x0031}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0031\u002C\u002C\u0061", expected: [][]rune{{0x0031}, {0x002C}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0031\u002C\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0031}, {0x002C}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0031\u005F\u0061\u002C\u002C\u0061", expected: [][]rune{{0x0031, 0x005F, 0x0061}, {0x002C}, {0x002C}, {0x0061}}},                     // ÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u003A\u003A\u0031", expected: [][]rune{{0x0061}, {0x003A}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u003A\u003A\u0061", expected: [][]rune{{0x0061}, {0x003A}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u003A\u002E\u0031", expected: [][]rune{{0x0061}, {0x003A}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u003A\u002E\u0061", expected: [][]rune{{0x0061}, {0x003A}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u003A\u002C\u0031", expected: [][]rune{{0x0061}, {0x003A}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u003A\u002C\u0061", expected: [][]rune{{0x0061}, {0x003A}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u003A\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x003A}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u003A\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x003A}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002E\u003A\u0031", expected: [][]rune{{0x0061}, {0x002E}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002E\u003A\u0061", expected: [][]rune{{0x0061}, {0x002E}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002E\u002E\u0031", expected: [][]rune{{0x0061}, {0x002E}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002E\u002E\u0061", expected: [][]rune{{0x0061}, {0x002E}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002E\u002C\u0031", expected: [][]rune{{0x0061}, {0x002E}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002E\u002C\u0061", expected: [][]rune{{0x0061}, {0x002E}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002E\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002E}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002E\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002E}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002C\u003A\u0031", expected: [][]rune{{0x0061}, {0x002C}, {0x003A}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u003A\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x003A}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002C\u003A\u0061", expected: [][]rune{{0x0061}, {0x002C}, {0x003A}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u003A\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x003A}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002C\u002E\u0031", expected: [][]rune{{0x0061}, {0x002C}, {0x002E}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u002E\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x002E}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002C\u002E\u0061", expected: [][]rune{{0x0061}, {0x002C}, {0x002E}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u002E\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x002E}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u002C\u002C\u0031", expected: [][]rune{{0x0061}, {0x002C}, {0x002C}, {0x0031}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u002C\u0031", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x002C}, {0x0031}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]
	{original: "\u0061\u002C\u002C\u0061", expected: [][]rune{{0x0061}, {0x002C}, {0x002C}, {0x0061}}},                                                 // ÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0031\u002C\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0031}, {0x002C}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
	{original: "\u0061\u005F\u0061\u002C\u002C\u0061", expected: [][]rune{{0x0061, 0x005F, 0x0061}, {0x002C}, {0x002C}, {0x0061}}},                     // ÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]
}
