/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Side
#define GUARD_Side

#include "GlobalConstants.h"
#include "Stuff.h"

#include <vector>
#include <string>
#include <map>
#include <list>

using std::vector;
using std::string;
using std::map;
using std::list;

class Group;

class SideDataStruct
{
public:
	string mainData;
	map<string, string> unitData;
};

class AIScript
{
public:
	vector<ustring> script;
	map<ustring, int> functionLookup;
	int firstLine;
};

class Side
{
public:
	Side(const string& iName, int iMySide = -1);
	~Side();

	void FilesToSDStruct();
	//must be seperate to constructor as we access the side
	//in group constructors called by loading data
	void LoadData(bool ignoreMinorIssues);
	void ClearDataStructs();

	void Reset();
	void ChangeMySide(int newMySide);
	
	void CheckOverData(bool ignoreMinorIssues);

	//GetPointsValue is used in ForceSelect, in SetupBattle we use the saved myPoints
	int GetPointsValue();
	int GetTotalUnits();
	int GetTotalHealth();
	int GetTotalCapShips();
	
	void CreateAIScriptVec(const string& aiName);
	void MakeFunctionLookupTable(const string& scriptName);
	
	void AddAIError(const string& msg);
	bool alreadyAIError;

	string name;
	string commander;
	Uint16 color;
	Uint16 laserColor;
	Uint16 radarColor;
	int myFlag;
	int myPoints;
	int mySide;

	list<string> aiErrorReports;	
	SDL_Rect startingRect;
	SideDataStruct sdStruct;

	vector<Group> groups;
	map<string, SDL_Surface*> unitPictures;

	map<string, AIScript> aiScripts;

	//don't want people decrementing them to negative values
	unsigned int scriptVars[nAIVars];
	CoordsInt saveGroups[nAIVars];

private:
	void LoadFromStruct();	
	void CheckOverAI(const string& scriptName);
	void SetColors();
};

#endif
