/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2015  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
namespace Pasang {

class MenuMaker {

    public delegate void ActivateFunc ();

    private string menu_xml = "";
    private GLib.ActionMap action_map;

    public MenuMaker (GLib.ActionMap action_map) {
        this.action_map = action_map;
    }

    public MenuMaker add_separator () {
        menu_xml += "</section><section>";
        return this;
    }

    public MenuMaker add (string name, string label, ActivateFunc func, string? accel = null) {
        var simple_action = new GLib.SimpleAction (name, null);
        simple_action.set_enabled (true);
        action_map.add_action (simple_action);
        menu_xml += ("<item>" +
                     @"<attribute name='label'>$label</attribute>" +
                     @"<attribute name='action'>win.$name</attribute>" +
                     "</item>");
        simple_action.activate.connect (() => func ());
        if (accel != null) {
            string[] accels = {accel};
            (GLib.Application.get_default () as Gtk.Application)
                .set_accels_for_action (@"win.$name", accels);
        }
        return this;
    }

    public GLib.MenuModel end () {
        Gtk.Builder builder = new Gtk.Builder ();
        try {
            builder.add_from_string (
                "<interface>" +
                "  <menu id='MenuBar'>" +
                @"    <section>$menu_xml</section>" +
                "  </menu>" +
                "</interface>",
                -1  // String length. -1 means null-terminated. This has no business in vala!!
            );
        }
        catch (Error e) {
            stderr.printf ("Fail to build menu: %s\n", e.message);
            assert_not_reached ();
        }

        return (builder.get_object ("MenuBar") as GLib.MenuModel);
    }
}//class

}//namespace


// vim: tabstop=4: expandtab: textwidth=100: autoindent:
