/* pattern-editor.c generated by valac 0.46.3, the Vala compiler
 * generated from pattern-editor.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <../config.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define PASANG_TYPE_PATTERN_EDITOR (pasang_pattern_editor_get_type ())
#define PASANG_PATTERN_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditor))
#define PASANG_PATTERN_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditorClass))
#define PASANG_IS_PATTERN_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN_EDITOR))
#define PASANG_IS_PATTERN_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN_EDITOR))
#define PASANG_PATTERN_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditorClass))

typedef struct _PasangPatternEditor PasangPatternEditor;
typedef struct _PasangPatternEditorClass PasangPatternEditorClass;
typedef struct _PasangPatternEditorPrivate PasangPatternEditorPrivate;

#define PASANG_TYPE_PATTERN_SELECTOR (pasang_pattern_selector_get_type ())
#define PASANG_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelector))
#define PASANG_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))
#define PASANG_IS_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_IS_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_PATTERN_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))

typedef struct _PasangPatternSelector PasangPatternSelector;
typedef struct _PasangPatternSelectorClass PasangPatternSelectorClass;

#define PASANG_TYPE_PATTERN (pasang_pattern_get_type ())
#define PASANG_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN, PasangPattern))
#define PASANG_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN, PasangPatternClass))
#define PASANG_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN))
#define PASANG_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN))
#define PASANG_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN, PasangPatternClass))

typedef struct _PasangPattern PasangPattern;
typedef struct _PasangPatternClass PasangPatternClass;

#define PASANG_TYPE_CUSTOM_PATTERN (pasang_custom_pattern_get_type ())
#define PASANG_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPattern))
#define PASANG_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))
#define PASANG_IS_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_IS_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_CUSTOM_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))

typedef struct _PasangCustomPattern PasangCustomPattern;
typedef struct _PasangCustomPatternClass PasangCustomPatternClass;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;
enum  {
	PASANG_PATTERN_EDITOR_0_PROPERTY,
	PASANG_PATTERN_EDITOR_NUM_PROPERTIES
};
static GParamSpec* pasang_pattern_editor_properties[PASANG_PATTERN_EDITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pasang_pattern_unref0(var) ((var == NULL) ? NULL : (var = (pasang_pattern_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PasangPatternPrivate PasangPatternPrivate;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _PasangCustomPatternPrivate PasangCustomPatternPrivate;

struct _PasangPatternEditor {
	GtkGrid parent_instance;
	PasangPatternEditorPrivate * priv;
};

struct _PasangPatternEditorClass {
	GtkGridClass parent_class;
};

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangPatternEditorPrivate {
	GtkDrawingArea* editing_box;
	PasangPatternSelector* pattern_selector;
	PasangCustomPattern** patterns;
	gint patterns_length1;
	gint _patterns_size_;
	GtkGrid* pattern_button_box;
	gchar* custom_pattern_filename;
	PasangCustomPattern* active_pattern;
	PasangPiece active_color;
	gchar symmetry;
	PasangPoint cursor;
	PasangPoint* cursors;
	gint cursors_length1;
	gint _cursors_size_;
	GtkGestureDrag* gesture;
	GtkEventControllerMotion* event_controller;
};

struct _PasangPattern {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangPatternPrivate * priv;
	gchar* name;
	gchar* dots;
	guint8* pixbuf_data;
	gint pixbuf_data_length1;
	gint _pixbuf_data_size_;
	GdkPixbuf* pixbuf;
	gint dot_width;
	GtkRadioButton* button;
};

struct _PasangPatternClass {
	GTypeClass parent_class;
	void (*finalize) (PasangPattern *self);
	void (*background) (PasangPattern* self, gint n, gint x, gint y);
	void (*create_pixbuf) (PasangPattern* self);
};

struct _Block5Data {
	int _ref_count_;
	PasangPatternEditor* self;
	gint dot;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gchar code;
};

struct _PasangCustomPattern {
	PasangPattern parent_instance;
	PasangCustomPatternPrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint _board_size_;
};

struct _PasangCustomPatternClass {
	PasangPatternClass parent_class;
};

static gint PasangPatternEditor_private_offset;
static gpointer pasang_pattern_editor_parent_class = NULL;

GType pasang_pattern_editor_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPatternEditor, g_object_unref)
GType pasang_pattern_selector_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPatternSelector, g_object_unref)
gpointer pasang_pattern_ref (gpointer instance);
void pasang_pattern_unref (gpointer instance);
GParamSpec* pasang_param_spec_pattern (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void pasang_value_set_pattern (GValue* value,
                               gpointer v_object);
void pasang_value_take_pattern (GValue* value,
                                gpointer v_object);
gpointer pasang_value_get_pattern (const GValue* value);
GType pasang_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPattern, pasang_pattern_unref)
GType pasang_custom_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangCustomPattern, pasang_pattern_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
void pasang_point_init_xy (PasangPoint *self,
                           gint x,
                           gint y);
PasangPatternEditor* pasang_pattern_editor_new (PasangPatternSelector* ps);
PasangPatternEditor* pasang_pattern_editor_construct (GType object_type,
                                                      PasangPatternSelector* ps);
static GtkWidget* pasang_pattern_editor_create_symmetry_box (PasangPatternEditor* self);
static GtkWidget* pasang_pattern_editor_create_editing_box (PasangPatternEditor* self);
static void pasang_pattern_editor_init_pattern_list (PasangPatternEditor* self);
void pasang_pattern_editor_apply (PasangPatternEditor* self,
                                  gboolean must_save);
gboolean pasang_game_is_valid_pattern (const gchar* pattern);
static void pasang_pattern_editor_add_pattern (PasangPatternEditor* self,
                                        PasangCustomPattern* pattern);
PasangCustomPattern* pasang_custom_pattern_new_from_text (const gchar* dots);
PasangCustomPattern* pasang_custom_pattern_construct_from_text (GType object_type,
                                                                const gchar* dots);
PasangCustomPattern* pasang_custom_pattern_new (void);
PasangCustomPattern* pasang_custom_pattern_construct (GType object_type);
static void pasang_pattern_editor_ensure_user_datadir (PasangPatternEditor* self);
gint pasang_custom_pattern_count_whites (PasangCustomPattern* self);
PasangCustomPattern* pasang_custom_pattern_new_copy (PasangCustomPattern* original);
PasangCustomPattern* pasang_custom_pattern_construct_copy (GType object_type,
                                                           PasangCustomPattern* original);
static void _vala_array_add10 (PasangPattern** * array,
                        int* length,
                        int* size,
                        PasangPattern* value);
void pasang_pattern_selector_add_patterns (PasangPatternSelector* self,
                                           PasangPattern** additional_patterns,
                                           gint additional_patterns_length1);
static void pasang_pattern_editor_pattern_button_clicked (PasangPatternEditor* self,
                                                   GtkButton* source);
static void _pasang_pattern_editor_pattern_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _vala_array_add11 (PasangCustomPattern** * array,
                        int* length,
                        int* size,
                        PasangCustomPattern* value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean _____lambda24_ (Block6Data* _data6_,
                         cairo_t* cr);
static gboolean ______lambda24__gtk_widget_draw (GtkWidget* _sender,
                                          cairo_t* cr,
                                          gpointer self);
static void _____lambda25_ (Block6Data* _data6_,
                     GtkToggleButton* s);
static void pasang_pattern_editor_set_cursors (PasangPatternEditor* self);
static void ______lambda25__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                gpointer self);
#define PASANG_BOARD_WIDTH 13
static gboolean __lambda26_ (PasangPatternEditor* self,
                      cairo_t* cr);
static void pasang_pattern_editor_draw_editing_box (PasangPatternEditor* self,
                                             cairo_t* cr);
static gboolean ___lambda26__gtk_widget_draw (GtkWidget* _sender,
                                       cairo_t* cr,
                                       gpointer self);
static void __lambda27_ (PasangPatternEditor* self,
                  gdouble x,
                  gdouble y);
static void pasang_pattern_editor_track (PasangPatternEditor* self,
                                  gint x,
                                  gint y);
static void ___lambda27__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static void __lambda28_ (PasangPatternEditor* self,
                  gdouble x,
                  gdouble y);
static void pasang_pattern_editor_toggle_color (PasangPatternEditor* self);
static void ___lambda28__gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                               gdouble start_x,
                                               gdouble start_y,
                                               gpointer self);
static void __lambda29_ (PasangPatternEditor* self,
                  gdouble x,
                  gdouble y);
static void pasang_pattern_editor_apply_color (PasangPatternEditor* self);
static void ___lambda29__gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                                gdouble offset_x,
                                                gdouble offset_y,
                                                gpointer self);
static void __lambda30_ (PasangPatternEditor* self,
                  gdouble x,
                  gdouble y);
static void ___lambda30__gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                             gdouble offset_x,
                                             gdouble offset_y,
                                             gpointer self);
static void pasang_pattern_editor_redraw_cursors (PasangPatternEditor* self);
static void _vala_array_add12 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add13 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add14 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add15 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add16 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add17 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static void _vala_array_add18 (PasangPoint* * array,
                        int* length,
                        int* size,
                        const PasangPoint* value);
static gdouble pasang_pattern_editor_get_cell_width (PasangPatternEditor* self);
void pasang_custom_pattern_update (PasangCustomPattern* self);
#define PASANG_BOARD_SIZE (13 * 13)
static void pasang_pattern_editor_finalize (GObject * obj);
static void _vala_pasang_pattern_editor_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
pasang_pattern_editor_get_instance_private (PasangPatternEditor* self)
{
	return G_STRUCT_MEMBER_P (self, PasangPatternEditor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 75 "pattern-editor.vala"
	return self ? g_object_ref (self) : NULL;
#line 367 "pattern-editor.c"
}

PasangPatternEditor*
pasang_pattern_editor_construct (GType object_type,
                                 PasangPatternSelector* ps)
{
	PasangPatternEditor * self = NULL;
	PasangPatternSelector* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkSeparator* _tmp3_;
	GtkSeparator* _tmp4_;
	GtkScrolledWindow* scrolled_box = NULL;
	GtkScrolledWindow* _tmp5_;
	GtkGrid* _tmp6_;
	GtkWidget* editing_box = NULL;
	GtkWidget* _tmp7_;
#line 74 "pattern-editor.vala"
	g_return_val_if_fail (ps != NULL, NULL);
#line 74 "pattern-editor.vala"
	self = (PasangPatternEditor*) g_object_new (object_type, NULL);
#line 75 "pattern-editor.vala"
	_tmp0_ = _g_object_ref0 (ps);
#line 75 "pattern-editor.vala"
	_g_object_unref0 (self->priv->pattern_selector);
#line 75 "pattern-editor.vala"
	self->priv->pattern_selector = _tmp0_;
#line 76 "pattern-editor.vala"
	_tmp1_ = pasang_pattern_editor_create_symmetry_box (self);
#line 76 "pattern-editor.vala"
	_tmp2_ = _tmp1_;
#line 76 "pattern-editor.vala"
	gtk_grid_attach ((GtkGrid*) self, _tmp2_, 0, 0, 2, 1);
#line 76 "pattern-editor.vala"
	_g_object_unref0 (_tmp2_);
#line 77 "pattern-editor.vala"
	_tmp3_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
#line 77 "pattern-editor.vala"
	g_object_ref_sink (_tmp3_);
#line 77 "pattern-editor.vala"
	_tmp4_ = _tmp3_;
#line 77 "pattern-editor.vala"
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp4_, 0, 1, 2, 1);
#line 77 "pattern-editor.vala"
	_g_object_unref0 (_tmp4_);
#line 78 "pattern-editor.vala"
	_tmp5_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 78 "pattern-editor.vala"
	g_object_ref_sink (_tmp5_);
#line 78 "pattern-editor.vala"
	scrolled_box = _tmp5_;
#line 79 "pattern-editor.vala"
	_tmp6_ = self->priv->pattern_button_box;
#line 79 "pattern-editor.vala"
	gtk_container_add ((GtkContainer*) scrolled_box, (GtkWidget*) _tmp6_);
#line 80 "pattern-editor.vala"
	gtk_scrolled_window_set_policy (scrolled_box, GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
#line 81 "pattern-editor.vala"
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) scrolled_box, 0, 2, 1, 1);
#line 82 "pattern-editor.vala"
	_tmp7_ = pasang_pattern_editor_create_editing_box (self);
#line 82 "pattern-editor.vala"
	editing_box = _tmp7_;
#line 83 "pattern-editor.vala"
	gtk_widget_set_hexpand (editing_box, TRUE);
#line 84 "pattern-editor.vala"
	gtk_widget_set_vexpand (editing_box, TRUE);
#line 85 "pattern-editor.vala"
	gtk_grid_attach ((GtkGrid*) self, editing_box, 1, 2, 1, 1);
#line 86 "pattern-editor.vala"
	pasang_pattern_editor_init_pattern_list (self);
#line 87 "pattern-editor.vala"
	pasang_pattern_editor_apply (self, FALSE);
#line 74 "pattern-editor.vala"
	_g_object_unref0 (editing_box);
#line 74 "pattern-editor.vala"
	_g_object_unref0 (scrolled_box);
#line 74 "pattern-editor.vala"
	return self;
#line 447 "pattern-editor.c"
}

PasangPatternEditor*
pasang_pattern_editor_new (PasangPatternSelector* ps)
{
#line 74 "pattern-editor.vala"
	return pasang_pattern_editor_construct (PASANG_TYPE_PATTERN_EDITOR, ps);
#line 455 "pattern-editor.c"
}

/**
     * Create pattern list from pattern file. If the pattern file has not been created, then
     * populate the list with a few sample patterns.
     */
static void
pasang_pattern_editor_init_pattern_list (PasangPatternEditor* self)
{
	GtkGrid* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	PasangCustomPattern* _tmp24_;
	PasangCustomPattern* _tmp25_;
	PasangCustomPattern** _tmp26_;
	gint _tmp26__length1;
	PasangCustomPattern** _tmp27_;
	gint _tmp27__length1;
	PasangCustomPattern* _tmp28_;
	PasangCustomPattern* _tmp29_;
	GtkRadioButton* _tmp30_;
	GError* _inner_error0_ = NULL;
#line 94 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 95 "pattern-editor.vala"
	_tmp0_ = self->priv->pattern_button_box;
#line 95 "pattern-editor.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp0_, GTK_ORIENTATION_VERTICAL);
#line 96 "pattern-editor.vala"
	_tmp1_ = g_get_home_dir ();
#line 96 "pattern-editor.vala"
	_tmp2_ = g_build_filename (_tmp1_, USER_DATADIR, "custom-patterns", NULL, NULL);
#line 96 "pattern-editor.vala"
	_g_free0 (self->priv->custom_pattern_filename);
#line 96 "pattern-editor.vala"
	self->priv->custom_pattern_filename = _tmp2_;
#line 98 "pattern-editor.vala"
	_tmp3_ = self->priv->custom_pattern_filename;
#line 98 "pattern-editor.vala"
	if (g_file_test (_tmp3_, G_FILE_TEST_EXISTS)) {
#line 497 "pattern-editor.c"
		{
			gchar* s = NULL;
			const gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar** contents = NULL;
			const gchar* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
			gint contents_length1;
			gint _contents_size_;
			gchar** _tmp9_;
			gint _tmp9__length1;
#line 101 "pattern-editor.vala"
			_tmp4_ = self->priv->custom_pattern_filename;
#line 101 "pattern-editor.vala"
			g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error0_);
#line 101 "pattern-editor.vala"
			_g_free0 (s);
#line 101 "pattern-editor.vala"
			s = _tmp5_;
#line 101 "pattern-editor.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 101 "pattern-editor.vala"
				_g_free0 (s);
#line 522 "pattern-editor.c"
				goto __catch9_g_error;
			}
#line 102 "pattern-editor.vala"
			_tmp6_ = s;
#line 102 "pattern-editor.vala"
			_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
#line 102 "pattern-editor.vala"
			contents = _tmp8_;
#line 102 "pattern-editor.vala"
			contents_length1 = _vala_array_length (_tmp7_);
#line 102 "pattern-editor.vala"
			_contents_size_ = contents_length1;
#line 103 "pattern-editor.vala"
			_tmp9_ = contents;
#line 103 "pattern-editor.vala"
			_tmp9__length1 = contents_length1;
#line 539 "pattern-editor.c"
			{
				gchar** content_collection = NULL;
				gint content_collection_length1 = 0;
				gint _content_collection_size_ = 0;
				gint content_it = 0;
#line 103 "pattern-editor.vala"
				content_collection = _tmp9_;
#line 103 "pattern-editor.vala"
				content_collection_length1 = _tmp9__length1;
#line 103 "pattern-editor.vala"
				for (content_it = 0; content_it < content_collection_length1; content_it = content_it + 1) {
#line 551 "pattern-editor.c"
					gchar* _tmp10_;
					gchar* content = NULL;
#line 103 "pattern-editor.vala"
					_tmp10_ = g_strdup (content_collection[content_it]);
#line 103 "pattern-editor.vala"
					content = _tmp10_;
#line 558 "pattern-editor.c"
					{
						const gchar* _tmp11_;
#line 106 "pattern-editor.vala"
						_tmp11_ = content;
#line 106 "pattern-editor.vala"
						if (pasang_game_is_valid_pattern (_tmp11_)) {
#line 565 "pattern-editor.c"
							const gchar* _tmp12_;
							PasangCustomPattern* _tmp13_;
							PasangCustomPattern* _tmp14_;
#line 107 "pattern-editor.vala"
							_tmp12_ = content;
#line 107 "pattern-editor.vala"
							_tmp13_ = pasang_custom_pattern_new_from_text (_tmp12_);
#line 107 "pattern-editor.vala"
							_tmp14_ = _tmp13_;
#line 107 "pattern-editor.vala"
							pasang_pattern_editor_add_pattern (self, _tmp14_);
#line 107 "pattern-editor.vala"
							_pasang_pattern_unref0 (_tmp14_);
#line 579 "pattern-editor.c"
						}
#line 103 "pattern-editor.vala"
						_g_free0 (content);
#line 583 "pattern-editor.c"
					}
				}
			}
#line 99 "pattern-editor.vala"
			contents = (_vala_array_free (contents, contents_length1, (GDestroyNotify) g_free), NULL);
#line 99 "pattern-editor.vala"
			_g_free0 (s);
#line 591 "pattern-editor.c"
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* e = NULL;
			FILE* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
#line 99 "pattern-editor.vala"
			e = _inner_error0_;
#line 99 "pattern-editor.vala"
			_inner_error0_ = NULL;
#line 111 "pattern-editor.vala"
			_tmp15_ = stderr;
#line 111 "pattern-editor.vala"
			_tmp16_ = e;
#line 111 "pattern-editor.vala"
			_tmp17_ = _tmp16_->message;
#line 111 "pattern-editor.vala"
			fprintf (_tmp15_, "File error: %s\n", _tmp17_);
#line 99 "pattern-editor.vala"
			_g_error_free0 (e);
#line 614 "pattern-editor.c"
		}
		__finally9:
#line 99 "pattern-editor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 99 "pattern-editor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 99 "pattern-editor.vala"
			g_clear_error (&_inner_error0_);
#line 99 "pattern-editor.vala"
			return;
#line 625 "pattern-editor.c"
		}
	} else {
		PasangCustomPattern* _tmp18_;
		PasangCustomPattern* _tmp19_;
		PasangCustomPattern* _tmp20_;
		PasangCustomPattern* _tmp21_;
		PasangCustomPattern* _tmp22_;
		PasangCustomPattern* _tmp23_;
#line 116 "pattern-editor.vala"
		_tmp18_ = pasang_custom_pattern_new_from_text ("PPPPPHPPPPPPHHPPHHHHHPPHPHHHHPPHPPHPHHHPHHPPPHHPHPHHHPPHHHHP");
#line 116 "pattern-editor.vala"
		_tmp19_ = _tmp18_;
#line 116 "pattern-editor.vala"
		pasang_pattern_editor_add_pattern (self, _tmp19_);
#line 116 "pattern-editor.vala"
		_pasang_pattern_unref0 (_tmp19_);
#line 117 "pattern-editor.vala"
		_tmp20_ = pasang_custom_pattern_new_from_text ("PPPPHHHPPPPPHHHHHHHHHPPHPPPPPPPHPPHPHHHHHPHPHHPHPPPHPHHHHPHP");
#line 117 "pattern-editor.vala"
		_tmp21_ = _tmp20_;
#line 117 "pattern-editor.vala"
		pasang_pattern_editor_add_pattern (self, _tmp21_);
#line 117 "pattern-editor.vala"
		_pasang_pattern_unref0 (_tmp21_);
#line 118 "pattern-editor.vala"
		_tmp22_ = pasang_custom_pattern_new_from_text ("HHHHPPPHHHHPPPHPHPHPPPPHPPPHPPPHPPHHHHHHHHHPPPPPHHHPPPPHHHPH");
#line 118 "pattern-editor.vala"
		_tmp23_ = _tmp22_;
#line 118 "pattern-editor.vala"
		pasang_pattern_editor_add_pattern (self, _tmp23_);
#line 118 "pattern-editor.vala"
		_pasang_pattern_unref0 (_tmp23_);
#line 658 "pattern-editor.c"
	}
#line 121 "pattern-editor.vala"
	_tmp24_ = pasang_custom_pattern_new ();
#line 121 "pattern-editor.vala"
	_tmp25_ = _tmp24_;
#line 121 "pattern-editor.vala"
	pasang_pattern_editor_add_pattern (self, _tmp25_);
#line 121 "pattern-editor.vala"
	_pasang_pattern_unref0 (_tmp25_);
#line 122 "pattern-editor.vala"
	_tmp26_ = self->priv->patterns;
#line 122 "pattern-editor.vala"
	_tmp26__length1 = self->priv->patterns_length1;
#line 122 "pattern-editor.vala"
	_tmp27_ = self->priv->patterns;
#line 122 "pattern-editor.vala"
	_tmp27__length1 = self->priv->patterns_length1;
#line 122 "pattern-editor.vala"
	_tmp28_ = _tmp26_[_tmp27__length1 - 1];
#line 122 "pattern-editor.vala"
	self->priv->active_pattern = _tmp28_;
#line 123 "pattern-editor.vala"
	_tmp29_ = self->priv->active_pattern;
#line 123 "pattern-editor.vala"
	_tmp30_ = ((PasangPattern*) _tmp29_)->button;
#line 123 "pattern-editor.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp30_, TRUE);
#line 686 "pattern-editor.c"
}

/**
     * Ensure that user datadir exists.
     */
static void
pasang_pattern_editor_ensure_user_datadir (PasangPatternEditor* self)
{
	gchar* dir_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
#line 129 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 130 "pattern-editor.vala"
	_tmp0_ = g_get_home_dir ();
#line 130 "pattern-editor.vala"
	_tmp1_ = g_build_filename (_tmp0_, USER_DATADIR, NULL, NULL);
#line 130 "pattern-editor.vala"
	dir_name = _tmp1_;
#line 131 "pattern-editor.vala"
	_tmp2_ = dir_name;
#line 131 "pattern-editor.vala"
	if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
#line 711 "pattern-editor.c"
		const gchar* _tmp3_;
#line 132 "pattern-editor.vala"
		_tmp3_ = dir_name;
#line 132 "pattern-editor.vala"
		mkdir (_tmp3_, (mode_t) 0777);
#line 717 "pattern-editor.c"
	}
#line 129 "pattern-editor.vala"
	_g_free0 (dir_name);
#line 721 "pattern-editor.c"
}

/**
     * Submit all valid patterns (those with 60 whites & 60 blacks) to the pattern selector.
     * Save all valid patterns.
     */
static gpointer
_pasang_pattern_ref0 (gpointer self)
{
#line 143 "pattern-editor.vala"
	return self ? pasang_pattern_ref (self) : NULL;
#line 733 "pattern-editor.c"
}

static void
_vala_array_add10 (PasangPattern** * array,
                   int* length,
                   int* size,
                   PasangPattern* value)
{
#line 145 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 145 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 145 "pattern-editor.vala"
		*array = g_renew (PasangPattern*, *array, (*size) + 1);
#line 748 "pattern-editor.c"
	}
#line 145 "pattern-editor.vala"
	(*array)[(*length)++] = value;
#line 145 "pattern-editor.vala"
	(*array)[*length] = NULL;
#line 754 "pattern-editor.c"
}

void
pasang_pattern_editor_apply (PasangPatternEditor* self,
                             gboolean must_save)
{
	gchar* text_to_save = NULL;
	gchar* _tmp0_;
	PasangPattern** valid_patterns = NULL;
	PasangPattern** _tmp1_;
	gint valid_patterns_length1;
	gint _valid_patterns_size_;
	PasangCustomPattern** _tmp2_;
	gint _tmp2__length1;
	PasangPatternSelector* _tmp14_;
	PasangPattern** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
#line 140 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 141 "pattern-editor.vala"
	_tmp0_ = g_strdup ("Custom patterns for Pasang Emas\nH=background (beHind), P=pattern\n");
#line 141 "pattern-editor.vala"
	text_to_save = _tmp0_;
#line 142 "pattern-editor.vala"
	_tmp1_ = g_new0 (PasangPattern*, 0 + 1);
#line 142 "pattern-editor.vala"
	valid_patterns = _tmp1_;
#line 142 "pattern-editor.vala"
	valid_patterns_length1 = 0;
#line 142 "pattern-editor.vala"
	_valid_patterns_size_ = valid_patterns_length1;
#line 143 "pattern-editor.vala"
	_tmp2_ = self->priv->patterns;
#line 143 "pattern-editor.vala"
	_tmp2__length1 = self->priv->patterns_length1;
#line 791 "pattern-editor.c"
	{
		PasangCustomPattern** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
#line 143 "pattern-editor.vala"
		p_collection = _tmp2_;
#line 143 "pattern-editor.vala"
		p_collection_length1 = _tmp2__length1;
#line 143 "pattern-editor.vala"
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
#line 803 "pattern-editor.c"
			PasangCustomPattern* _tmp3_;
			PasangCustomPattern* p = NULL;
#line 143 "pattern-editor.vala"
			_tmp3_ = _pasang_pattern_ref0 (p_collection[p_it]);
#line 143 "pattern-editor.vala"
			p = _tmp3_;
#line 810 "pattern-editor.c"
			{
				PasangCustomPattern* _tmp4_;
				PasangPattern** _tmp5_;
				gint _tmp5__length1;
				PasangCustomPattern* _tmp6_;
				PasangCustomPattern* _tmp7_;
				const gchar* _tmp8_;
				PasangCustomPattern* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
#line 144 "pattern-editor.vala"
				_tmp4_ = p;
#line 144 "pattern-editor.vala"
				if (pasang_custom_pattern_count_whites (_tmp4_) != 60) {
#line 144 "pattern-editor.vala"
					_pasang_pattern_unref0 (p);
#line 144 "pattern-editor.vala"
					continue;
#line 831 "pattern-editor.c"
				}
#line 145 "pattern-editor.vala"
				_tmp5_ = valid_patterns;
#line 145 "pattern-editor.vala"
				_tmp5__length1 = valid_patterns_length1;
#line 145 "pattern-editor.vala"
				_tmp6_ = p;
#line 145 "pattern-editor.vala"
				_tmp7_ = pasang_custom_pattern_new_copy (_tmp6_);
#line 145 "pattern-editor.vala"
				_vala_array_add10 (&valid_patterns, &valid_patterns_length1, &_valid_patterns_size_, (PasangPattern*) _tmp7_);
#line 146 "pattern-editor.vala"
				_tmp8_ = text_to_save;
#line 146 "pattern-editor.vala"
				_tmp9_ = p;
#line 146 "pattern-editor.vala"
				_tmp10_ = ((PasangPattern*) _tmp9_)->dots;
#line 146 "pattern-editor.vala"
				_tmp11_ = g_strconcat (_tmp10_, "\n", NULL);
#line 146 "pattern-editor.vala"
				_tmp12_ = _tmp11_;
#line 146 "pattern-editor.vala"
				_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
#line 146 "pattern-editor.vala"
				_g_free0 (text_to_save);
#line 146 "pattern-editor.vala"
				text_to_save = _tmp13_;
#line 146 "pattern-editor.vala"
				_g_free0 (_tmp12_);
#line 143 "pattern-editor.vala"
				_pasang_pattern_unref0 (p);
#line 863 "pattern-editor.c"
			}
		}
	}
#line 148 "pattern-editor.vala"
	_tmp14_ = self->priv->pattern_selector;
#line 148 "pattern-editor.vala"
	_tmp15_ = valid_patterns;
#line 148 "pattern-editor.vala"
	_tmp15__length1 = valid_patterns_length1;
#line 148 "pattern-editor.vala"
	pasang_pattern_selector_add_patterns (_tmp14_, _tmp15_, (gint) _tmp15__length1);
#line 149 "pattern-editor.vala"
	if (must_save) {
#line 150 "pattern-editor.vala"
		pasang_pattern_editor_ensure_user_datadir (self);
#line 879 "pattern-editor.c"
		{
			const gchar* _tmp16_;
			const gchar* _tmp17_;
#line 152 "pattern-editor.vala"
			_tmp16_ = self->priv->custom_pattern_filename;
#line 152 "pattern-editor.vala"
			_tmp17_ = text_to_save;
#line 152 "pattern-editor.vala"
			g_file_set_contents (_tmp16_, _tmp17_, (gssize) -1, &_inner_error0_);
#line 152 "pattern-editor.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 891 "pattern-editor.c"
				goto __catch10_g_error;
			}
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			FILE* _tmp18_;
			GError* _tmp19_;
			const gchar* _tmp20_;
#line 151 "pattern-editor.vala"
			e = _inner_error0_;
#line 151 "pattern-editor.vala"
			_inner_error0_ = NULL;
#line 155 "pattern-editor.vala"
			_tmp18_ = stderr;
#line 155 "pattern-editor.vala"
			_tmp19_ = e;
#line 155 "pattern-editor.vala"
			_tmp20_ = _tmp19_->message;
#line 155 "pattern-editor.vala"
			fprintf (_tmp18_, "File error: %s\n", _tmp20_);
#line 151 "pattern-editor.vala"
			_g_error_free0 (e);
#line 916 "pattern-editor.c"
		}
		__finally10:
#line 151 "pattern-editor.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 151 "pattern-editor.vala"
			valid_patterns = (_vala_array_free (valid_patterns, valid_patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 151 "pattern-editor.vala"
			_g_free0 (text_to_save);
#line 151 "pattern-editor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 151 "pattern-editor.vala"
			g_clear_error (&_inner_error0_);
#line 151 "pattern-editor.vala"
			return;
#line 931 "pattern-editor.c"
		}
	}
#line 140 "pattern-editor.vala"
	valid_patterns = (_vala_array_free (valid_patterns, valid_patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 140 "pattern-editor.vala"
	_g_free0 (text_to_save);
#line 938 "pattern-editor.c"
}

/**
     * Add a new pattern.
     * Side effect: patterns, pattern_buttons, pattern_button_box
     */
static void
_pasang_pattern_editor_pattern_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
#line 172 "pattern-editor.vala"
	pasang_pattern_editor_pattern_button_clicked ((PasangPatternEditor*) self, _sender);
#line 951 "pattern-editor.c"
}

static void
_vala_array_add11 (PasangCustomPattern** * array,
                   int* length,
                   int* size,
                   PasangCustomPattern* value)
{
#line 175 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 175 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 175 "pattern-editor.vala"
		*array = g_renew (PasangCustomPattern*, *array, (*size) + 1);
#line 966 "pattern-editor.c"
	}
#line 175 "pattern-editor.vala"
	(*array)[(*length)++] = value;
#line 175 "pattern-editor.vala"
	(*array)[*length] = NULL;
#line 972 "pattern-editor.c"
}

static void
pasang_pattern_editor_add_pattern (PasangPatternEditor* self,
                                   PasangCustomPattern* pattern)
{
	GtkRadioButton* button = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	PasangCustomPattern** _tmp2_;
	gint _tmp2__length1;
	GtkRadioButton* _tmp8_;
	GtkRadioButton* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkGrid* _tmp12_;
	GtkRadioButton* _tmp13_;
	GtkGrid* _tmp14_;
	PasangCustomPattern** _tmp15_;
	gint _tmp15__length1;
	PasangCustomPattern* _tmp16_;
#line 164 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 164 "pattern-editor.vala"
	g_return_if_fail (pattern != NULL);
#line 165 "pattern-editor.vala"
	_tmp0_ = ((PasangPattern*) pattern)->button;
#line 165 "pattern-editor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 165 "pattern-editor.vala"
	button = _tmp1_;
#line 166 "pattern-editor.vala"
	_tmp2_ = self->priv->patterns;
#line 166 "pattern-editor.vala"
	_tmp2__length1 = self->priv->patterns_length1;
#line 166 "pattern-editor.vala"
	if (_tmp2__length1 != 0) {
#line 1010 "pattern-editor.c"
		GtkRadioButton* _tmp3_;
		PasangCustomPattern** _tmp4_;
		gint _tmp4__length1;
		PasangCustomPattern* _tmp5_;
		GtkRadioButton* _tmp6_;
		GSList* _tmp7_;
#line 167 "pattern-editor.vala"
		_tmp3_ = button;
#line 167 "pattern-editor.vala"
		_tmp4_ = self->priv->patterns;
#line 167 "pattern-editor.vala"
		_tmp4__length1 = self->priv->patterns_length1;
#line 167 "pattern-editor.vala"
		_tmp5_ = _tmp4_[0];
#line 167 "pattern-editor.vala"
		_tmp6_ = ((PasangPattern*) _tmp5_)->button;
#line 167 "pattern-editor.vala"
		_tmp7_ = gtk_radio_button_get_group (_tmp6_);
#line 167 "pattern-editor.vala"
		gtk_radio_button_set_group (_tmp3_, _tmp7_);
#line 1031 "pattern-editor.c"
	}
#line 169 "pattern-editor.vala"
	_tmp8_ = button;
#line 169 "pattern-editor.vala"
	gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp8_, FALSE);
#line 170 "pattern-editor.vala"
	_tmp9_ = button;
#line 170 "pattern-editor.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp9_, (guint) 0);
#line 171 "pattern-editor.vala"
	_tmp10_ = button;
#line 171 "pattern-editor.vala"
	gtk_button_set_relief ((GtkButton*) _tmp10_, GTK_RELIEF_NONE);
#line 172 "pattern-editor.vala"
	_tmp11_ = button;
#line 172 "pattern-editor.vala"
	g_signal_connect_object ((GtkButton*) _tmp11_, "clicked", (GCallback) _pasang_pattern_editor_pattern_button_clicked_gtk_button_clicked, self, 0);
#line 173 "pattern-editor.vala"
	_tmp12_ = self->priv->pattern_button_box;
#line 173 "pattern-editor.vala"
	_tmp13_ = button;
#line 173 "pattern-editor.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
#line 174 "pattern-editor.vala"
	_tmp14_ = self->priv->pattern_button_box;
#line 174 "pattern-editor.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
#line 175 "pattern-editor.vala"
	_tmp15_ = self->priv->patterns;
#line 175 "pattern-editor.vala"
	_tmp15__length1 = self->priv->patterns_length1;
#line 175 "pattern-editor.vala"
	_tmp16_ = _pasang_pattern_ref0 (pattern);
#line 175 "pattern-editor.vala"
	_vala_array_add11 (&self->priv->patterns, &self->priv->patterns_length1, &self->priv->_patterns_size_, _tmp16_);
#line 164 "pattern-editor.vala"
	_g_object_unref0 (button);
#line 1069 "pattern-editor.c"
}

/**
     * The user wants to edit another pattern.
     */
static void
pasang_pattern_editor_pattern_button_clicked (PasangPatternEditor* self,
                                              GtkButton* source)
{
	PasangCustomPattern** _tmp0_;
	gint _tmp0__length1;
#line 181 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 181 "pattern-editor.vala"
	g_return_if_fail (source != NULL);
#line 182 "pattern-editor.vala"
	_tmp0_ = self->priv->patterns;
#line 182 "pattern-editor.vala"
	_tmp0__length1 = self->priv->patterns_length1;
#line 1089 "pattern-editor.c"
	{
		PasangCustomPattern** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 182 "pattern-editor.vala"
		pattern_collection = _tmp0_;
#line 182 "pattern-editor.vala"
		pattern_collection_length1 = _tmp0__length1;
#line 182 "pattern-editor.vala"
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 1101 "pattern-editor.c"
			PasangCustomPattern* _tmp1_;
			PasangCustomPattern* pattern = NULL;
#line 182 "pattern-editor.vala"
			_tmp1_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 182 "pattern-editor.vala"
			pattern = _tmp1_;
#line 1108 "pattern-editor.c"
			{
				PasangCustomPattern* _tmp2_;
				GtkRadioButton* _tmp3_;
#line 183 "pattern-editor.vala"
				_tmp2_ = pattern;
#line 183 "pattern-editor.vala"
				_tmp3_ = ((PasangPattern*) _tmp2_)->button;
#line 183 "pattern-editor.vala"
				if (source == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton)) {
#line 1118 "pattern-editor.c"
					PasangCustomPattern* _tmp4_;
					GtkDrawingArea* _tmp5_;
#line 184 "pattern-editor.vala"
					_tmp4_ = pattern;
#line 184 "pattern-editor.vala"
					self->priv->active_pattern = _tmp4_;
#line 185 "pattern-editor.vala"
					_tmp5_ = self->priv->editing_box;
#line 185 "pattern-editor.vala"
					gtk_widget_queue_draw ((GtkWidget*) _tmp5_);
#line 186 "pattern-editor.vala"
					_pasang_pattern_unref0 (pattern);
#line 186 "pattern-editor.vala"
					return;
#line 1133 "pattern-editor.c"
				}
#line 182 "pattern-editor.vala"
				_pasang_pattern_unref0 (pattern);
#line 1137 "pattern-editor.c"
			}
		}
	}
#line 189 "pattern-editor.vala"
	g_assert_not_reached ();
#line 1143 "pattern-editor.c"
}

/**
     * Create a visual list of symmetry types.
     */
static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 195 "pattern-editor.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 195 "pattern-editor.vala"
	return _data5_;
#line 1156 "pattern-editor.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 195 "pattern-editor.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 1166 "pattern-editor.c"
		PasangPatternEditor* self;
#line 195 "pattern-editor.vala"
		self = _data5_->self;
#line 195 "pattern-editor.vala"
		_g_object_unref0 (self);
#line 195 "pattern-editor.vala"
		g_slice_free (Block5Data, _data5_);
#line 1174 "pattern-editor.c"
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 201 "pattern-editor.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 201 "pattern-editor.vala"
	return _data6_;
#line 1185 "pattern-editor.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 201 "pattern-editor.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1195 "pattern-editor.c"
		PasangPatternEditor* self;
#line 201 "pattern-editor.vala"
		self = _data6_->_data5_->self;
#line 201 "pattern-editor.vala"
		block5_data_unref (_data6_->_data5_);
#line 201 "pattern-editor.vala"
		_data6_->_data5_ = NULL;
#line 201 "pattern-editor.vala"
		g_slice_free (Block6Data, _data6_);
#line 1205 "pattern-editor.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 1223 "pattern-editor.c"
}

static gboolean
_____lambda24_ (Block6Data* _data6_,
                cairo_t* cr)
{
	Block5Data* _data5_;
	PasangPatternEditor* self;
	cairo_pattern_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	cairo_pattern_t* _tmp5_;
	cairo_pattern_t* _tmp6_;
	gboolean result = FALSE;
#line 212 "pattern-editor.vala"
	_data5_ = _data6_->_data5_;
#line 212 "pattern-editor.vala"
	self = _data5_->self;
#line 212 "pattern-editor.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 213 "pattern-editor.vala"
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) (11 * _data5_->dot), (gdouble) (11 * _data5_->dot));
#line 214 "pattern-editor.vala"
	_tmp0_ = cairo_pattern_create_rgb (0.2, 0.2, 0.2);
#line 214 "pattern-editor.vala"
	_tmp1_ = _tmp0_;
#line 214 "pattern-editor.vala"
	cairo_set_source (cr, _tmp1_);
#line 214 "pattern-editor.vala"
	_cairo_pattern_destroy0 (_tmp1_);
#line 215 "pattern-editor.vala"
	cairo_fill (cr);
#line 216 "pattern-editor.vala"
	cairo_rectangle (cr, (gdouble) (1 * _data5_->dot), (gdouble) (3 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 217 "pattern-editor.vala"
	cairo_rectangle (cr, (gdouble) (9 * _data5_->dot), (gdouble) (7 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 218 "pattern-editor.vala"
	if (_data6_->code == '/') {
#line 218 "pattern-editor.vala"
		_tmp2_ = TRUE;
#line 1266 "pattern-editor.c"
	} else {
#line 218 "pattern-editor.vala"
		_tmp2_ = _data6_->code == 'X';
#line 1270 "pattern-editor.c"
	}
#line 218 "pattern-editor.vala"
	if (_tmp2_) {
#line 219 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (3 * _data5_->dot), (gdouble) (1 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 220 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (7 * _data5_->dot), (gdouble) (9 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 1278 "pattern-editor.c"
	}
#line 222 "pattern-editor.vala"
	if (_data6_->code == 'F') {
#line 222 "pattern-editor.vala"
		_tmp3_ = TRUE;
#line 1284 "pattern-editor.c"
	} else {
#line 222 "pattern-editor.vala"
		_tmp3_ = _data6_->code == 'X';
#line 1288 "pattern-editor.c"
	}
#line 222 "pattern-editor.vala"
	if (_tmp3_) {
#line 223 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (7 * _data5_->dot), (gdouble) (1 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 224 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (3 * _data5_->dot), (gdouble) (9 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 1296 "pattern-editor.c"
	}
#line 226 "pattern-editor.vala"
	if (_data6_->code == 'H') {
#line 226 "pattern-editor.vala"
		_tmp4_ = TRUE;
#line 1302 "pattern-editor.c"
	} else {
#line 226 "pattern-editor.vala"
		_tmp4_ = _data6_->code == 'X';
#line 1306 "pattern-editor.c"
	}
#line 226 "pattern-editor.vala"
	if (_tmp4_) {
#line 227 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (9 * _data5_->dot), (gdouble) (3 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 228 "pattern-editor.vala"
		cairo_rectangle (cr, (gdouble) (1 * _data5_->dot), (gdouble) (7 * _data5_->dot), (gdouble) _data5_->dot, (gdouble) _data5_->dot);
#line 1314 "pattern-editor.c"
	}
#line 230 "pattern-editor.vala"
	_tmp5_ = cairo_pattern_create_rgb (0.8, 0.8, (gdouble) 1);
#line 230 "pattern-editor.vala"
	_tmp6_ = _tmp5_;
#line 230 "pattern-editor.vala"
	cairo_set_source (cr, _tmp6_);
#line 230 "pattern-editor.vala"
	_cairo_pattern_destroy0 (_tmp6_);
#line 231 "pattern-editor.vala"
	cairo_fill (cr);
#line 232 "pattern-editor.vala"
	result = TRUE;
#line 232 "pattern-editor.vala"
	return result;
#line 1330 "pattern-editor.c"
}

static gboolean
______lambda24__gtk_widget_draw (GtkWidget* _sender,
                                 cairo_t* cr,
                                 gpointer self)
{
	gboolean result;
	result = _____lambda24_ (self, cr);
#line 212 "pattern-editor.vala"
	return result;
#line 1342 "pattern-editor.c"
}

static void
_____lambda25_ (Block6Data* _data6_,
                GtkToggleButton* s)
{
	Block5Data* _data5_;
	PasangPatternEditor* self;
#line 236 "pattern-editor.vala"
	_data5_ = _data6_->_data5_;
#line 236 "pattern-editor.vala"
	self = _data5_->self;
#line 236 "pattern-editor.vala"
	g_return_if_fail (s != NULL);
#line 237 "pattern-editor.vala"
	self->priv->symmetry = _data6_->code;
#line 238 "pattern-editor.vala"
	pasang_pattern_editor_set_cursors (self);
#line 1361 "pattern-editor.c"
}

static void
______lambda25__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                           gpointer self)
{
#line 236 "pattern-editor.vala"
	_____lambda25_ (self, _sender);
#line 1370 "pattern-editor.c"
}

static GtkWidget*
pasang_pattern_editor_create_symmetry_box (PasangPatternEditor* self)
{
	Block5Data* _data5_;
	GtkGrid* box = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	gchar* symmetry_codes = NULL;
	gchar* _tmp2_;
	GtkRadioButton* representative = NULL;
	GtkWidget* result = NULL;
#line 195 "pattern-editor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 195 "pattern-editor.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 195 "pattern-editor.vala"
	_data5_->_ref_count_ = 1;
#line 195 "pattern-editor.vala"
	_data5_->self = g_object_ref (self);
#line 196 "pattern-editor.vala"
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
#line 196 "pattern-editor.vala"
	g_object_ref_sink (_tmp0_);
#line 196 "pattern-editor.vala"
	box = _tmp0_;
#line 197 "pattern-editor.vala"
	_tmp1_ = box;
#line 197 "pattern-editor.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp1_, GTK_ORIENTATION_HORIZONTAL);
#line 198 "pattern-editor.vala"
	_tmp2_ = g_strdup ("SFH/X");
#line 198 "pattern-editor.vala"
	symmetry_codes = _tmp2_;
#line 199 "pattern-editor.vala"
	representative = NULL;
#line 200 "pattern-editor.vala"
	_data5_->dot = 2;
#line 1410 "pattern-editor.c"
	{
		gint i = 0;
#line 201 "pattern-editor.vala"
		i = 0;
#line 1415 "pattern-editor.c"
		{
			gboolean _tmp3_ = FALSE;
#line 201 "pattern-editor.vala"
			_tmp3_ = TRUE;
#line 201 "pattern-editor.vala"
			while (TRUE) {
#line 1422 "pattern-editor.c"
				Block6Data* _data6_;
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GtkRadioButton* _tmp8_ = NULL;
				GtkRadioButton* _tmp9_;
				GtkRadioButton* button = NULL;
				GtkRadioButton* _tmp13_;
				GtkRadioButton* _tmp14_ = NULL;
				GtkRadioButton* _tmp15_;
				GtkRadioButton* _tmp17_;
				GtkRadioButton* _tmp18_;
				GtkRadioButton* _tmp19_;
				const gchar* _tmp20_;
				GtkDrawingArea* icon = NULL;
				GtkDrawingArea* _tmp21_;
				GtkDrawingArea* _tmp22_;
				GtkRadioButton* _tmp23_;
				GtkDrawingArea* _tmp24_;
				GtkDrawingArea* _tmp25_;
				GtkRadioButton* _tmp26_;
				GtkGrid* _tmp27_;
				GtkRadioButton* _tmp28_;
#line 201 "pattern-editor.vala"
				_data6_ = g_slice_new0 (Block6Data);
#line 201 "pattern-editor.vala"
				_data6_->_ref_count_ = 1;
#line 201 "pattern-editor.vala"
				_data6_->_data5_ = block5_data_ref (_data5_);
#line 201 "pattern-editor.vala"
				if (!_tmp3_) {
#line 1454 "pattern-editor.c"
					gint _tmp4_;
#line 201 "pattern-editor.vala"
					_tmp4_ = i;
#line 201 "pattern-editor.vala"
					i = _tmp4_ + 1;
#line 1460 "pattern-editor.c"
				}
#line 201 "pattern-editor.vala"
				_tmp3_ = FALSE;
#line 201 "pattern-editor.vala"
				_tmp5_ = symmetry_codes;
#line 201 "pattern-editor.vala"
				_tmp6_ = strlen (_tmp5_);
#line 201 "pattern-editor.vala"
				_tmp7_ = _tmp6_;
#line 201 "pattern-editor.vala"
				if (!(i < _tmp7_)) {
#line 201 "pattern-editor.vala"
					block6_data_unref (_data6_);
#line 201 "pattern-editor.vala"
					_data6_ = NULL;
#line 201 "pattern-editor.vala"
					break;
#line 1478 "pattern-editor.c"
				}
#line 202 "pattern-editor.vala"
				_tmp9_ = representative;
#line 202 "pattern-editor.vala"
				if (_tmp9_ == NULL) {
#line 1484 "pattern-editor.c"
					GtkRadioButton* _tmp10_;
#line 202 "pattern-editor.vala"
					_tmp10_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
#line 202 "pattern-editor.vala"
					g_object_ref_sink (_tmp10_);
#line 202 "pattern-editor.vala"
					_g_object_unref0 (_tmp8_);
#line 202 "pattern-editor.vala"
					_tmp8_ = _tmp10_;
#line 1494 "pattern-editor.c"
				} else {
					GtkRadioButton* _tmp11_;
					GtkRadioButton* _tmp12_;
#line 202 "pattern-editor.vala"
					_tmp11_ = representative;
#line 202 "pattern-editor.vala"
					_tmp12_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp11_);
#line 202 "pattern-editor.vala"
					g_object_ref_sink (_tmp12_);
#line 202 "pattern-editor.vala"
					_g_object_unref0 (_tmp8_);
#line 202 "pattern-editor.vala"
					_tmp8_ = _tmp12_;
#line 1508 "pattern-editor.c"
				}
#line 202 "pattern-editor.vala"
				_tmp13_ = _g_object_ref0 (_tmp8_);
#line 202 "pattern-editor.vala"
				button = _tmp13_;
#line 203 "pattern-editor.vala"
				_tmp15_ = representative;
#line 203 "pattern-editor.vala"
				_tmp14_ = _tmp15_;
#line 203 "pattern-editor.vala"
				if (_tmp14_ == NULL) {
#line 1520 "pattern-editor.c"
					GtkRadioButton* _tmp16_;
#line 203 "pattern-editor.vala"
					_tmp16_ = button;
#line 203 "pattern-editor.vala"
					_tmp14_ = _tmp16_;
#line 1526 "pattern-editor.c"
				}
#line 203 "pattern-editor.vala"
				_tmp17_ = _g_object_ref0 (_tmp14_);
#line 203 "pattern-editor.vala"
				_g_object_unref0 (representative);
#line 203 "pattern-editor.vala"
				representative = _tmp17_;
#line 204 "pattern-editor.vala"
				_tmp18_ = button;
#line 204 "pattern-editor.vala"
				gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp18_, FALSE);
#line 205 "pattern-editor.vala"
				_tmp19_ = button;
#line 205 "pattern-editor.vala"
				gtk_button_set_relief ((GtkButton*) _tmp19_, GTK_RELIEF_NONE);
#line 208 "pattern-editor.vala"
				_tmp20_ = symmetry_codes;
#line 208 "pattern-editor.vala"
				_data6_->code = (gchar) string_get (_tmp20_, (glong) i);
#line 209 "pattern-editor.vala"
				_tmp21_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 209 "pattern-editor.vala"
				g_object_ref_sink (_tmp21_);
#line 209 "pattern-editor.vala"
				icon = _tmp21_;
#line 210 "pattern-editor.vala"
				_tmp22_ = icon;
#line 210 "pattern-editor.vala"
				gtk_widget_set_size_request ((GtkWidget*) _tmp22_, 11 * _data5_->dot, 11 * _data5_->dot);
#line 211 "pattern-editor.vala"
				_tmp23_ = button;
#line 211 "pattern-editor.vala"
				_tmp24_ = icon;
#line 211 "pattern-editor.vala"
				gtk_button_set_image ((GtkButton*) _tmp23_, (GtkWidget*) _tmp24_);
#line 212 "pattern-editor.vala"
				_tmp25_ = icon;
#line 212 "pattern-editor.vala"
				g_signal_connect_data ((GtkWidget*) _tmp25_, "draw", (GCallback) ______lambda24__gtk_widget_draw, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 236 "pattern-editor.vala"
				_tmp26_ = button;
#line 236 "pattern-editor.vala"
				g_signal_connect_data ((GtkToggleButton*) _tmp26_, "toggled", (GCallback) ______lambda25__gtk_toggle_button_toggled, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 240 "pattern-editor.vala"
				_tmp27_ = box;
#line 240 "pattern-editor.vala"
				_tmp28_ = button;
#line 240 "pattern-editor.vala"
				gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
#line 201 "pattern-editor.vala"
				_g_object_unref0 (icon);
#line 201 "pattern-editor.vala"
				_g_object_unref0 (button);
#line 201 "pattern-editor.vala"
				_g_object_unref0 (_tmp8_);
#line 201 "pattern-editor.vala"
				block6_data_unref (_data6_);
#line 201 "pattern-editor.vala"
				_data6_ = NULL;
#line 1586 "pattern-editor.c"
			}
		}
	}
#line 242 "pattern-editor.vala"
	result = (GtkWidget*) box;
#line 242 "pattern-editor.vala"
	_g_object_unref0 (representative);
#line 242 "pattern-editor.vala"
	_g_free0 (symmetry_codes);
#line 242 "pattern-editor.vala"
	block5_data_unref (_data5_);
#line 242 "pattern-editor.vala"
	_data5_ = NULL;
#line 242 "pattern-editor.vala"
	return result;
#line 1602 "pattern-editor.c"
}

static gboolean
__lambda26_ (PasangPatternEditor* self,
             cairo_t* cr)
{
	gboolean result = FALSE;
#line 248 "pattern-editor.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 249 "pattern-editor.vala"
	pasang_pattern_editor_draw_editing_box (self, cr);
#line 250 "pattern-editor.vala"
	result = TRUE;
#line 250 "pattern-editor.vala"
	return result;
#line 1618 "pattern-editor.c"
}

static gboolean
___lambda26__gtk_widget_draw (GtkWidget* _sender,
                              cairo_t* cr,
                              gpointer self)
{
	gboolean result;
	result = __lambda26_ ((PasangPatternEditor*) self, cr);
#line 248 "pattern-editor.vala"
	return result;
#line 1630 "pattern-editor.c"
}

static void
__lambda27_ (PasangPatternEditor* self,
             gdouble x,
             gdouble y)
{
#line 257 "pattern-editor.vala"
	pasang_pattern_editor_track (self, (gint) x, (gint) y);
#line 1640 "pattern-editor.c"
}

static void
___lambda27__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
#line 256 "pattern-editor.vala"
	__lambda27_ ((PasangPatternEditor*) self, x, y);
#line 1651 "pattern-editor.c"
}

static void
__lambda28_ (PasangPatternEditor* self,
             gdouble x,
             gdouble y)
{
#line 265 "pattern-editor.vala"
	pasang_pattern_editor_track (self, (gint) x, (gint) y);
#line 266 "pattern-editor.vala"
	pasang_pattern_editor_toggle_color (self);
#line 1663 "pattern-editor.c"
}

static void
___lambda28__gtk_gesture_drag_drag_begin (GtkGestureDrag* _sender,
                                          gdouble start_x,
                                          gdouble start_y,
                                          gpointer self)
{
#line 264 "pattern-editor.vala"
	__lambda28_ ((PasangPatternEditor*) self, start_x, start_y);
#line 1674 "pattern-editor.c"
}

static void
__lambda29_ (PasangPatternEditor* self,
             gdouble x,
             gdouble y)
{
	GtkGestureDrag* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	PasangPiece _tmp3_;
#line 269 "pattern-editor.vala"
	_tmp0_ = self->priv->gesture;
#line 269 "pattern-editor.vala"
	gtk_gesture_get_point ((GtkGesture*) _tmp0_, NULL, &_tmp1_, &_tmp2_);
#line 269 "pattern-editor.vala"
	x = _tmp1_;
#line 269 "pattern-editor.vala"
	y = _tmp2_;
#line 270 "pattern-editor.vala"
	pasang_pattern_editor_track (self, (gint) x, (gint) y);
#line 271 "pattern-editor.vala"
	_tmp3_ = self->priv->active_color;
#line 271 "pattern-editor.vala"
	if (_tmp3_ != PASANG_PIECE_NULL) {
#line 271 "pattern-editor.vala"
		pasang_pattern_editor_apply_color (self);
#line 1702 "pattern-editor.c"
	}
}

static void
___lambda29__gtk_gesture_drag_drag_update (GtkGestureDrag* _sender,
                                           gdouble offset_x,
                                           gdouble offset_y,
                                           gpointer self)
{
#line 268 "pattern-editor.vala"
	__lambda29_ ((PasangPatternEditor*) self, offset_x, offset_y);
#line 1714 "pattern-editor.c"
}

static void
__lambda30_ (PasangPatternEditor* self,
             gdouble x,
             gdouble y)
{
#line 274 "pattern-editor.vala"
	self->priv->active_color = PASANG_PIECE_NULL;
#line 1724 "pattern-editor.c"
}

static void
___lambda30__gtk_gesture_drag_drag_end (GtkGestureDrag* _sender,
                                        gdouble offset_x,
                                        gdouble offset_y,
                                        gpointer self)
{
#line 273 "pattern-editor.vala"
	__lambda30_ ((PasangPatternEditor*) self, offset_x, offset_y);
#line 1735 "pattern-editor.c"
}

static GtkWidget*
pasang_pattern_editor_create_editing_box (PasangPatternEditor* self)
{
	GtkDrawingArea* _tmp0_;
	GtkDrawingArea* _tmp1_;
	GtkDrawingArea* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkDrawingArea* _tmp4_;
	GtkEventControllerMotion* _tmp5_;
	GtkEventControllerMotion* _tmp6_;
	GtkDrawingArea* _tmp7_;
	GtkGestureDrag* _tmp8_;
	GtkGestureDrag* _tmp9_;
	GtkGestureDrag* _tmp10_;
	GtkGestureDrag* _tmp11_;
	GtkGestureDrag* _tmp12_;
	GtkGestureDrag* _tmp13_;
	GtkDrawingArea* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* result = NULL;
#line 245 "pattern-editor.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 246 "pattern-editor.vala"
	_tmp0_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 246 "pattern-editor.vala"
	g_object_ref_sink (_tmp0_);
#line 246 "pattern-editor.vala"
	_g_object_unref0 (self->priv->editing_box);
#line 246 "pattern-editor.vala"
	self->priv->editing_box = _tmp0_;
#line 247 "pattern-editor.vala"
	_tmp1_ = self->priv->editing_box;
#line 247 "pattern-editor.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, PASANG_BOARD_WIDTH * 25, PASANG_BOARD_WIDTH * 25);
#line 248 "pattern-editor.vala"
	_tmp2_ = self->priv->editing_box;
#line 248 "pattern-editor.vala"
	g_signal_connect_object ((GtkWidget*) _tmp2_, "draw", (GCallback) ___lambda26__gtk_widget_draw, self, 0);
#line 254 "pattern-editor.vala"
	_tmp3_ = self->priv->editing_box;
#line 254 "pattern-editor.vala"
	gtk_widget_add_events ((GtkWidget*) _tmp3_, (gint) GDK_POINTER_MOTION_MASK);
#line 255 "pattern-editor.vala"
	_tmp4_ = self->priv->editing_box;
#line 255 "pattern-editor.vala"
	_tmp5_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ((GtkWidget*) _tmp4_);
#line 255 "pattern-editor.vala"
	_g_object_unref0 (self->priv->event_controller);
#line 255 "pattern-editor.vala"
	self->priv->event_controller = _tmp5_;
#line 256 "pattern-editor.vala"
	_tmp6_ = self->priv->event_controller;
#line 256 "pattern-editor.vala"
	g_signal_connect_object (_tmp6_, "motion", (GCallback) ___lambda27__gtk_event_controller_motion_motion, self, 0);
#line 261 "pattern-editor.vala"
	_tmp7_ = self->priv->editing_box;
#line 261 "pattern-editor.vala"
	_tmp8_ = (GtkGestureDrag*) gtk_gesture_drag_new ((GtkWidget*) _tmp7_);
#line 261 "pattern-editor.vala"
	_g_object_unref0 (self->priv->gesture);
#line 261 "pattern-editor.vala"
	self->priv->gesture = _tmp8_;
#line 262 "pattern-editor.vala"
	_tmp9_ = self->priv->gesture;
#line 262 "pattern-editor.vala"
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp9_, GTK_PHASE_BUBBLE);
#line 263 "pattern-editor.vala"
	_tmp10_ = self->priv->gesture;
#line 263 "pattern-editor.vala"
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp10_, (guint) 1);
#line 264 "pattern-editor.vala"
	_tmp11_ = self->priv->gesture;
#line 264 "pattern-editor.vala"
	g_signal_connect_object (_tmp11_, "drag-begin", (GCallback) ___lambda28__gtk_gesture_drag_drag_begin, self, 0);
#line 268 "pattern-editor.vala"
	_tmp12_ = self->priv->gesture;
#line 268 "pattern-editor.vala"
	g_signal_connect_object (_tmp12_, "drag-update", (GCallback) ___lambda29__gtk_gesture_drag_drag_update, self, 0);
#line 273 "pattern-editor.vala"
	_tmp13_ = self->priv->gesture;
#line 273 "pattern-editor.vala"
	g_signal_connect_object (_tmp13_, "drag-end", (GCallback) ___lambda30__gtk_gesture_drag_drag_end, self, 0);
#line 277 "pattern-editor.vala"
	_tmp14_ = self->priv->editing_box;
#line 277 "pattern-editor.vala"
	_tmp15_ = _g_object_ref0 ((GtkWidget*) _tmp14_);
#line 277 "pattern-editor.vala"
	result = _tmp15_;
#line 277 "pattern-editor.vala"
	return result;
#line 1828 "pattern-editor.c"
}

/**
     * Show all cells that will change upon the next mouse click.
     * Side effect: cursors (computed from cursor and symmetry)
     */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1477 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1477 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1477 "glib-2.0.vapi"
	return result;
#line 1851 "pattern-editor.c"
}

static void
_vala_array_add12 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 315 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 315 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 315 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1866 "pattern-editor.c"
	}
#line 315 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1870 "pattern-editor.c"
}

static void
_vala_array_add13 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 316 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 316 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 316 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1885 "pattern-editor.c"
	}
#line 316 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1889 "pattern-editor.c"
}

static void
_vala_array_add14 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 317 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 317 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 317 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1904 "pattern-editor.c"
	}
#line 317 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1908 "pattern-editor.c"
}

static void
_vala_array_add15 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 318 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 318 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 318 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1923 "pattern-editor.c"
	}
#line 318 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1927 "pattern-editor.c"
}

static void
_vala_array_add16 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 319 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 319 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 319 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1942 "pattern-editor.c"
	}
#line 319 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1946 "pattern-editor.c"
}

static void
_vala_array_add17 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 320 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 320 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 320 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1961 "pattern-editor.c"
	}
#line 320 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1965 "pattern-editor.c"
}

static void
_vala_array_add18 (PasangPoint* * array,
                   int* length,
                   int* size,
                   const PasangPoint* value)
{
#line 321 "pattern-editor.vala"
	if ((*length) == (*size)) {
#line 321 "pattern-editor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 321 "pattern-editor.vala"
		*array = g_renew (PasangPoint, *array, *size);
#line 1980 "pattern-editor.c"
	}
#line 321 "pattern-editor.vala"
	(*array)[(*length)++] = *value;
#line 1984 "pattern-editor.c"
}

static void
pasang_pattern_editor_set_cursors (PasangPatternEditor* self)
{
	PasangPoint* _tmp0_;
	gint x = 0;
	PasangPoint _tmp1_;
	gint y = 0;
	PasangPoint _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gchar* s = NULL;
	gchar* _tmp8_;
	PasangPoint _tmp9_ = {0};
	PasangPoint* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp14_;
	const gchar* _tmp17_;
	PasangPoint* _tmp20_;
	gint _tmp20__length1;
	PasangPoint _tmp21_ = {0};
	const gchar* _tmp22_;
	const gchar* _tmp25_;
	const gchar* _tmp28_;
#line 297 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 298 "pattern-editor.vala"
	pasang_pattern_editor_redraw_cursors (self);
#line 299 "pattern-editor.vala"
	_tmp0_ = g_new0 (PasangPoint, 0);
#line 299 "pattern-editor.vala"
	self->priv->cursors = (g_free (self->priv->cursors), NULL);
#line 299 "pattern-editor.vala"
	self->priv->cursors = _tmp0_;
#line 299 "pattern-editor.vala"
	self->priv->cursors_length1 = 0;
#line 299 "pattern-editor.vala"
	self->priv->_cursors_size_ = self->priv->cursors_length1;
#line 301 "pattern-editor.vala"
	_tmp1_ = self->priv->cursor;
#line 301 "pattern-editor.vala"
	x = _tmp1_.x - 6;
#line 302 "pattern-editor.vala"
	_tmp2_ = self->priv->cursor;
#line 302 "pattern-editor.vala"
	y = _tmp2_.y - 6;
#line 303 "pattern-editor.vala"
	if (x == 0) {
#line 303 "pattern-editor.vala"
		_tmp7_ = y == 0;
#line 2039 "pattern-editor.c"
	} else {
#line 303 "pattern-editor.vala"
		_tmp7_ = FALSE;
#line 2043 "pattern-editor.c"
	}
#line 303 "pattern-editor.vala"
	if (_tmp7_) {
#line 303 "pattern-editor.vala"
		_tmp6_ = TRUE;
#line 2049 "pattern-editor.c"
	} else {
#line 303 "pattern-editor.vala"
		_tmp6_ = x < -5;
#line 2053 "pattern-editor.c"
	}
#line 303 "pattern-editor.vala"
	if (_tmp6_) {
#line 303 "pattern-editor.vala"
		_tmp5_ = TRUE;
#line 2059 "pattern-editor.c"
	} else {
#line 303 "pattern-editor.vala"
		_tmp5_ = x > 5;
#line 2063 "pattern-editor.c"
	}
#line 303 "pattern-editor.vala"
	if (_tmp5_) {
#line 303 "pattern-editor.vala"
		_tmp4_ = TRUE;
#line 2069 "pattern-editor.c"
	} else {
#line 303 "pattern-editor.vala"
		_tmp4_ = y < -5;
#line 2073 "pattern-editor.c"
	}
#line 303 "pattern-editor.vala"
	if (_tmp4_) {
#line 303 "pattern-editor.vala"
		_tmp3_ = TRUE;
#line 2079 "pattern-editor.c"
	} else {
#line 303 "pattern-editor.vala"
		_tmp3_ = y > 5;
#line 2083 "pattern-editor.c"
	}
#line 303 "pattern-editor.vala"
	if (_tmp3_) {
#line 303 "pattern-editor.vala"
		return;
#line 2089 "pattern-editor.c"
	}
#line 313 "pattern-editor.vala"
	_tmp8_ = g_strdup_printf ("%c", self->priv->symmetry);
#line 313 "pattern-editor.vala"
	s = _tmp8_;
#line 314 "pattern-editor.vala"
	pasang_point_init_xy (&_tmp9_, x, y);
#line 314 "pattern-editor.vala"
	_tmp10_ = g_new0 (PasangPoint, 1);
#line 314 "pattern-editor.vala"
	_tmp10_[0] = _tmp9_;
#line 314 "pattern-editor.vala"
	self->priv->cursors = (g_free (self->priv->cursors), NULL);
#line 314 "pattern-editor.vala"
	self->priv->cursors = _tmp10_;
#line 314 "pattern-editor.vala"
	self->priv->cursors_length1 = 1;
#line 314 "pattern-editor.vala"
	self->priv->_cursors_size_ = self->priv->cursors_length1;
#line 315 "pattern-editor.vala"
	_tmp11_ = s;
#line 315 "pattern-editor.vala"
	if (string_contains ("/X", _tmp11_)) {
#line 2113 "pattern-editor.c"
		PasangPoint* _tmp12_;
		gint _tmp12__length1;
		PasangPoint _tmp13_ = {0};
#line 315 "pattern-editor.vala"
		_tmp12_ = self->priv->cursors;
#line 315 "pattern-editor.vala"
		_tmp12__length1 = self->priv->cursors_length1;
#line 315 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp13_, y, x);
#line 315 "pattern-editor.vala"
		_vala_array_add12 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp13_);
#line 2125 "pattern-editor.c"
	}
#line 316 "pattern-editor.vala"
	_tmp14_ = s;
#line 316 "pattern-editor.vala"
	if (string_contains ("FX", _tmp14_)) {
#line 2131 "pattern-editor.c"
		PasangPoint* _tmp15_;
		gint _tmp15__length1;
		PasangPoint _tmp16_ = {0};
#line 316 "pattern-editor.vala"
		_tmp15_ = self->priv->cursors;
#line 316 "pattern-editor.vala"
		_tmp15__length1 = self->priv->cursors_length1;
#line 316 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp16_, -y, x);
#line 316 "pattern-editor.vala"
		_vala_array_add13 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp16_);
#line 2143 "pattern-editor.c"
	}
#line 317 "pattern-editor.vala"
	_tmp17_ = s;
#line 317 "pattern-editor.vala"
	if (string_contains ("HX", _tmp17_)) {
#line 2149 "pattern-editor.c"
		PasangPoint* _tmp18_;
		gint _tmp18__length1;
		PasangPoint _tmp19_ = {0};
#line 317 "pattern-editor.vala"
		_tmp18_ = self->priv->cursors;
#line 317 "pattern-editor.vala"
		_tmp18__length1 = self->priv->cursors_length1;
#line 317 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp19_, -x, y);
#line 317 "pattern-editor.vala"
		_vala_array_add14 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp19_);
#line 2161 "pattern-editor.c"
	}
#line 318 "pattern-editor.vala"
	_tmp20_ = self->priv->cursors;
#line 318 "pattern-editor.vala"
	_tmp20__length1 = self->priv->cursors_length1;
#line 318 "pattern-editor.vala"
	pasang_point_init_xy (&_tmp21_, -x, -y);
#line 318 "pattern-editor.vala"
	_vala_array_add15 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp21_);
#line 319 "pattern-editor.vala"
	_tmp22_ = s;
#line 319 "pattern-editor.vala"
	if (string_contains ("/X", _tmp22_)) {
#line 2175 "pattern-editor.c"
		PasangPoint* _tmp23_;
		gint _tmp23__length1;
		PasangPoint _tmp24_ = {0};
#line 319 "pattern-editor.vala"
		_tmp23_ = self->priv->cursors;
#line 319 "pattern-editor.vala"
		_tmp23__length1 = self->priv->cursors_length1;
#line 319 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp24_, -y, -x);
#line 319 "pattern-editor.vala"
		_vala_array_add16 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp24_);
#line 2187 "pattern-editor.c"
	}
#line 320 "pattern-editor.vala"
	_tmp25_ = s;
#line 320 "pattern-editor.vala"
	if (string_contains ("FX", _tmp25_)) {
#line 2193 "pattern-editor.c"
		PasangPoint* _tmp26_;
		gint _tmp26__length1;
		PasangPoint _tmp27_ = {0};
#line 320 "pattern-editor.vala"
		_tmp26_ = self->priv->cursors;
#line 320 "pattern-editor.vala"
		_tmp26__length1 = self->priv->cursors_length1;
#line 320 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp27_, y, -x);
#line 320 "pattern-editor.vala"
		_vala_array_add17 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp27_);
#line 2205 "pattern-editor.c"
	}
#line 321 "pattern-editor.vala"
	_tmp28_ = s;
#line 321 "pattern-editor.vala"
	if (string_contains ("HX", _tmp28_)) {
#line 2211 "pattern-editor.c"
		PasangPoint* _tmp29_;
		gint _tmp29__length1;
		PasangPoint _tmp30_ = {0};
#line 321 "pattern-editor.vala"
		_tmp29_ = self->priv->cursors;
#line 321 "pattern-editor.vala"
		_tmp29__length1 = self->priv->cursors_length1;
#line 321 "pattern-editor.vala"
		pasang_point_init_xy (&_tmp30_, x, -y);
#line 321 "pattern-editor.vala"
		_vala_array_add18 (&self->priv->cursors, &self->priv->cursors_length1, &self->priv->_cursors_size_, &_tmp30_);
#line 2223 "pattern-editor.c"
	}
	{
		gint i = 0;
#line 324 "pattern-editor.vala"
		i = 0;
#line 2229 "pattern-editor.c"
		{
			gboolean _tmp31_ = FALSE;
#line 324 "pattern-editor.vala"
			_tmp31_ = TRUE;
#line 324 "pattern-editor.vala"
			while (TRUE) {
#line 2236 "pattern-editor.c"
				PasangPoint* _tmp33_;
				gint _tmp33__length1;
				PasangPoint* _tmp34_;
				gint _tmp34__length1;
				PasangPoint* _tmp35_;
				gint _tmp35__length1;
				PasangPoint* _tmp36_;
				gint _tmp36__length1;
				PasangPoint* _tmp37_;
				gint _tmp37__length1;
#line 324 "pattern-editor.vala"
				if (!_tmp31_) {
#line 2249 "pattern-editor.c"
					gint _tmp32_;
#line 324 "pattern-editor.vala"
					_tmp32_ = i;
#line 324 "pattern-editor.vala"
					i = _tmp32_ + 1;
#line 2255 "pattern-editor.c"
				}
#line 324 "pattern-editor.vala"
				_tmp31_ = FALSE;
#line 324 "pattern-editor.vala"
				_tmp33_ = self->priv->cursors;
#line 324 "pattern-editor.vala"
				_tmp33__length1 = self->priv->cursors_length1;
#line 324 "pattern-editor.vala"
				if (!(i < _tmp33__length1)) {
#line 324 "pattern-editor.vala"
					break;
#line 2267 "pattern-editor.c"
				}
#line 325 "pattern-editor.vala"
				_tmp34_ = self->priv->cursors;
#line 325 "pattern-editor.vala"
				_tmp34__length1 = self->priv->cursors_length1;
#line 325 "pattern-editor.vala"
				_tmp35_ = self->priv->cursors;
#line 325 "pattern-editor.vala"
				_tmp35__length1 = self->priv->cursors_length1;
#line 325 "pattern-editor.vala"
				_tmp35_[i].x = _tmp35_[i].x + 6;
#line 326 "pattern-editor.vala"
				_tmp36_ = self->priv->cursors;
#line 326 "pattern-editor.vala"
				_tmp36__length1 = self->priv->cursors_length1;
#line 326 "pattern-editor.vala"
				_tmp37_ = self->priv->cursors;
#line 326 "pattern-editor.vala"
				_tmp37__length1 = self->priv->cursors_length1;
#line 326 "pattern-editor.vala"
				_tmp37_[i].y = _tmp37_[i].y + 6;
#line 2289 "pattern-editor.c"
			}
		}
	}
#line 328 "pattern-editor.vala"
	pasang_pattern_editor_redraw_cursors (self);
#line 297 "pattern-editor.vala"
	_g_free0 (s);
#line 2297 "pattern-editor.c"
}

/**
     * Convert mouse position (pixelx, pixely) into board position (row, column).
     * Side effect: cursor and (indirectly) cursors.
     */
static void
pasang_pattern_editor_track (PasangPatternEditor* self,
                             gint x,
                             gint y)
{
	PasangPoint p = {0};
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean _tmp4_ = FALSE;
	PasangPoint _tmp5_;
	PasangPoint _tmp6_;
	PasangPoint _tmp9_;
#line 335 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 336 "pattern-editor.vala"
	_tmp0_ = pasang_pattern_editor_get_cell_width (self);
#line 336 "pattern-editor.vala"
	_tmp1_ = _tmp0_;
#line 336 "pattern-editor.vala"
	_tmp2_ = pasang_pattern_editor_get_cell_width (self);
#line 336 "pattern-editor.vala"
	_tmp3_ = _tmp2_;
#line 336 "pattern-editor.vala"
	pasang_point_init_xy (&p, (gint) (x / _tmp1_), (gint) (y / _tmp3_));
#line 337 "pattern-editor.vala"
	_tmp5_ = p;
#line 337 "pattern-editor.vala"
	_tmp6_ = self->priv->cursor;
#line 337 "pattern-editor.vala"
	if (_tmp5_.x == _tmp6_.x) {
#line 2336 "pattern-editor.c"
		PasangPoint _tmp7_;
		PasangPoint _tmp8_;
#line 337 "pattern-editor.vala"
		_tmp7_ = p;
#line 337 "pattern-editor.vala"
		_tmp8_ = self->priv->cursor;
#line 337 "pattern-editor.vala"
		_tmp4_ = _tmp7_.y == _tmp8_.y;
#line 2345 "pattern-editor.c"
	} else {
#line 337 "pattern-editor.vala"
		_tmp4_ = FALSE;
#line 2349 "pattern-editor.c"
	}
#line 337 "pattern-editor.vala"
	if (_tmp4_) {
#line 337 "pattern-editor.vala"
		return;
#line 2355 "pattern-editor.c"
	}
#line 338 "pattern-editor.vala"
	_tmp9_ = p;
#line 338 "pattern-editor.vala"
	self->priv->cursor = _tmp9_;
#line 339 "pattern-editor.vala"
	pasang_pattern_editor_set_cursors (self);
#line 2363 "pattern-editor.c"
}

static void
pasang_pattern_editor_redraw_cursors (PasangPatternEditor* self)
{
	PasangPoint* _tmp0_;
	gint _tmp0__length1;
#line 342 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 343 "pattern-editor.vala"
	_tmp0_ = self->priv->cursors;
#line 343 "pattern-editor.vala"
	_tmp0__length1 = self->priv->cursors_length1;
#line 2377 "pattern-editor.c"
	{
		PasangPoint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
#line 343 "pattern-editor.vala"
		c_collection = _tmp0_;
#line 343 "pattern-editor.vala"
		c_collection_length1 = _tmp0__length1;
#line 343 "pattern-editor.vala"
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
#line 2389 "pattern-editor.c"
			PasangPoint c = {0};
#line 343 "pattern-editor.vala"
			c = c_collection[c_it];
#line 2393 "pattern-editor.c"
			{
				GtkDrawingArea* _tmp1_;
				PasangPoint _tmp2_;
				gdouble _tmp3_;
				gdouble _tmp4_;
				PasangPoint _tmp5_;
				gdouble _tmp6_;
				gdouble _tmp7_;
				gdouble _tmp8_;
				gdouble _tmp9_;
				gdouble _tmp10_;
				gdouble _tmp11_;
#line 344 "pattern-editor.vala"
				_tmp1_ = self->priv->editing_box;
#line 344 "pattern-editor.vala"
				_tmp2_ = c;
#line 344 "pattern-editor.vala"
				_tmp3_ = pasang_pattern_editor_get_cell_width (self);
#line 344 "pattern-editor.vala"
				_tmp4_ = _tmp3_;
#line 344 "pattern-editor.vala"
				_tmp5_ = c;
#line 344 "pattern-editor.vala"
				_tmp6_ = pasang_pattern_editor_get_cell_width (self);
#line 344 "pattern-editor.vala"
				_tmp7_ = _tmp6_;
#line 344 "pattern-editor.vala"
				_tmp8_ = pasang_pattern_editor_get_cell_width (self);
#line 344 "pattern-editor.vala"
				_tmp9_ = _tmp8_;
#line 344 "pattern-editor.vala"
				_tmp10_ = pasang_pattern_editor_get_cell_width (self);
#line 344 "pattern-editor.vala"
				_tmp11_ = _tmp10_;
#line 344 "pattern-editor.vala"
				gtk_widget_queue_draw_area ((GtkWidget*) _tmp1_, (gint) (_tmp2_.x * _tmp4_), (gint) (_tmp5_.y * _tmp7_), (gint) _tmp9_, (gint) _tmp11_);
#line 2430 "pattern-editor.c"
			}
		}
	}
}

/**
     * Toggle the colour on the mouse-tracking cursor. 
     * Copy the new colour to the other cursors.
     */
static void
pasang_pattern_editor_toggle_color (PasangPatternEditor* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	PasangPoint _tmp4_;
	PasangCustomPattern* _tmp11_;
	PasangPiece* _tmp12_;
	gint _tmp12__length1;
	PasangPoint _tmp13_;
	PasangPoint _tmp14_;
	PasangPiece _tmp15_;
	PasangPiece _tmp16_ = 0;
	PasangPiece _tmp17_;
#line 353 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 354 "pattern-editor.vala"
	_tmp4_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
	if (_tmp4_.x < 1) {
#line 354 "pattern-editor.vala"
		_tmp3_ = TRUE;
#line 2464 "pattern-editor.c"
	} else {
		PasangPoint _tmp5_;
#line 354 "pattern-editor.vala"
		_tmp5_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
		_tmp3_ = _tmp5_.x > 11;
#line 2471 "pattern-editor.c"
	}
#line 354 "pattern-editor.vala"
	if (_tmp3_) {
#line 354 "pattern-editor.vala"
		_tmp2_ = TRUE;
#line 2477 "pattern-editor.c"
	} else {
		PasangPoint _tmp6_;
#line 354 "pattern-editor.vala"
		_tmp6_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
		_tmp2_ = _tmp6_.y < 1;
#line 2484 "pattern-editor.c"
	}
#line 354 "pattern-editor.vala"
	if (_tmp2_) {
#line 354 "pattern-editor.vala"
		_tmp1_ = TRUE;
#line 2490 "pattern-editor.c"
	} else {
		PasangPoint _tmp7_;
#line 354 "pattern-editor.vala"
		_tmp7_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
		_tmp1_ = _tmp7_.y > 11;
#line 2497 "pattern-editor.c"
	}
#line 354 "pattern-editor.vala"
	if (_tmp1_) {
#line 354 "pattern-editor.vala"
		_tmp0_ = TRUE;
#line 2503 "pattern-editor.c"
	} else {
		gboolean _tmp8_ = FALSE;
		PasangPoint _tmp9_;
#line 354 "pattern-editor.vala"
		_tmp9_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
		if (_tmp9_.x == 6) {
#line 2511 "pattern-editor.c"
			PasangPoint _tmp10_;
#line 354 "pattern-editor.vala"
			_tmp10_ = self->priv->cursor;
#line 354 "pattern-editor.vala"
			_tmp8_ = _tmp10_.y == 6;
#line 2517 "pattern-editor.c"
		} else {
#line 354 "pattern-editor.vala"
			_tmp8_ = FALSE;
#line 2521 "pattern-editor.c"
		}
#line 354 "pattern-editor.vala"
		_tmp0_ = _tmp8_;
#line 2525 "pattern-editor.c"
	}
#line 354 "pattern-editor.vala"
	if (_tmp0_) {
#line 354 "pattern-editor.vala"
		return;
#line 2531 "pattern-editor.c"
	}
#line 355 "pattern-editor.vala"
	_tmp11_ = self->priv->active_pattern;
#line 355 "pattern-editor.vala"
	_tmp12_ = _tmp11_->board;
#line 355 "pattern-editor.vala"
	_tmp12__length1 = _tmp11_->board_length1;
#line 355 "pattern-editor.vala"
	_tmp13_ = self->priv->cursor;
#line 355 "pattern-editor.vala"
	_tmp14_ = self->priv->cursor;
#line 355 "pattern-editor.vala"
	_tmp15_ = _tmp12_[(_tmp13_.y * PASANG_BOARD_WIDTH) + _tmp14_.x];
#line 355 "pattern-editor.vala"
	self->priv->active_color = _tmp15_;
#line 356 "pattern-editor.vala"
	_tmp17_ = self->priv->active_color;
#line 356 "pattern-editor.vala"
	if (_tmp17_ == PASANG_PIECE_WHITE) {
#line 356 "pattern-editor.vala"
		_tmp16_ = PASANG_PIECE_BLACK;
#line 2553 "pattern-editor.c"
	} else {
#line 356 "pattern-editor.vala"
		_tmp16_ = PASANG_PIECE_WHITE;
#line 2557 "pattern-editor.c"
	}
#line 356 "pattern-editor.vala"
	self->priv->active_color = _tmp16_;
#line 357 "pattern-editor.vala"
	pasang_pattern_editor_apply_color (self);
#line 2563 "pattern-editor.c"
}

/**
     * Apply current_color on the board positions indicated by cursors.
     * If this is the last pattern in the list, and a valid pattern has been produced, then
     * add a new pattern button.
     */
static void
pasang_pattern_editor_apply_color (PasangPatternEditor* self)
{
	PasangPoint* _tmp0_;
	gint _tmp0__length1;
	PasangCustomPattern* _tmp6_;
	gboolean _tmp7_ = FALSE;
	PasangCustomPattern* _tmp8_;
	PasangCustomPattern** _tmp9_;
	gint _tmp9__length1;
	PasangCustomPattern** _tmp10_;
	gint _tmp10__length1;
	PasangCustomPattern* _tmp11_;
#line 365 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 366 "pattern-editor.vala"
	_tmp0_ = self->priv->cursors;
#line 366 "pattern-editor.vala"
	_tmp0__length1 = self->priv->cursors_length1;
#line 2590 "pattern-editor.c"
	{
		PasangPoint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
#line 366 "pattern-editor.vala"
		c_collection = _tmp0_;
#line 366 "pattern-editor.vala"
		c_collection_length1 = _tmp0__length1;
#line 366 "pattern-editor.vala"
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
#line 2602 "pattern-editor.c"
			PasangPoint c = {0};
#line 366 "pattern-editor.vala"
			c = c_collection[c_it];
#line 2606 "pattern-editor.c"
			{
				PasangCustomPattern* _tmp1_;
				PasangPiece* _tmp2_;
				gint _tmp2__length1;
				PasangPoint _tmp3_;
				PasangPoint _tmp4_;
				PasangPiece _tmp5_;
#line 367 "pattern-editor.vala"
				_tmp1_ = self->priv->active_pattern;
#line 367 "pattern-editor.vala"
				_tmp2_ = _tmp1_->board;
#line 367 "pattern-editor.vala"
				_tmp2__length1 = _tmp1_->board_length1;
#line 367 "pattern-editor.vala"
				_tmp3_ = c;
#line 367 "pattern-editor.vala"
				_tmp4_ = c;
#line 367 "pattern-editor.vala"
				_tmp5_ = self->priv->active_color;
#line 367 "pattern-editor.vala"
				_tmp2_[(_tmp3_.y * PASANG_BOARD_WIDTH) + _tmp4_.x] = _tmp5_;
#line 2628 "pattern-editor.c"
			}
		}
	}
#line 369 "pattern-editor.vala"
	_tmp6_ = self->priv->active_pattern;
#line 369 "pattern-editor.vala"
	pasang_custom_pattern_update (_tmp6_);
#line 370 "pattern-editor.vala"
	pasang_pattern_editor_redraw_cursors (self);
#line 371 "pattern-editor.vala"
	_tmp8_ = self->priv->active_pattern;
#line 371 "pattern-editor.vala"
	_tmp9_ = self->priv->patterns;
#line 371 "pattern-editor.vala"
	_tmp9__length1 = self->priv->patterns_length1;
#line 371 "pattern-editor.vala"
	_tmp10_ = self->priv->patterns;
#line 371 "pattern-editor.vala"
	_tmp10__length1 = self->priv->patterns_length1;
#line 371 "pattern-editor.vala"
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
#line 371 "pattern-editor.vala"
	if (_tmp8_ == _tmp11_) {
#line 2652 "pattern-editor.c"
		PasangCustomPattern* _tmp12_;
#line 371 "pattern-editor.vala"
		_tmp12_ = self->priv->active_pattern;
#line 371 "pattern-editor.vala"
		_tmp7_ = pasang_custom_pattern_count_whites (_tmp12_) == 60;
#line 2658 "pattern-editor.c"
	} else {
#line 371 "pattern-editor.vala"
		_tmp7_ = FALSE;
#line 2662 "pattern-editor.c"
	}
#line 371 "pattern-editor.vala"
	if (_tmp7_) {
#line 2666 "pattern-editor.c"
		PasangCustomPattern* _tmp13_;
		PasangCustomPattern* _tmp14_;
#line 372 "pattern-editor.vala"
		_tmp13_ = pasang_custom_pattern_new ();
#line 372 "pattern-editor.vala"
		_tmp14_ = _tmp13_;
#line 372 "pattern-editor.vala"
		pasang_pattern_editor_add_pattern (self, _tmp14_);
#line 372 "pattern-editor.vala"
		_pasang_pattern_unref0 (_tmp14_);
#line 2677 "pattern-editor.c"
	}
}

static void
pasang_pattern_editor_draw_editing_box (PasangPatternEditor* self,
                                        cairo_t* cr)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	cairo_pattern_t* _tmp4_;
	cairo_pattern_t* _tmp5_;
	PasangPoint* _tmp102_;
	gint _tmp102__length1;
#line 375 "pattern-editor.vala"
	g_return_if_fail (self != NULL);
#line 375 "pattern-editor.vala"
	g_return_if_fail (cr != NULL);
#line 376 "pattern-editor.vala"
	_tmp0_ = pasang_pattern_editor_get_cell_width (self);
#line 376 "pattern-editor.vala"
	_tmp1_ = _tmp0_;
#line 376 "pattern-editor.vala"
	_tmp2_ = pasang_pattern_editor_get_cell_width (self);
#line 376 "pattern-editor.vala"
	_tmp3_ = _tmp2_;
#line 376 "pattern-editor.vala"
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, PASANG_BOARD_WIDTH * _tmp1_, PASANG_BOARD_WIDTH * _tmp3_);
#line 377 "pattern-editor.vala"
	_tmp4_ = cairo_pattern_create_rgb (0.0, 0.5, 0.5);
#line 377 "pattern-editor.vala"
	_tmp5_ = _tmp4_;
#line 377 "pattern-editor.vala"
	cairo_set_source (cr, _tmp5_);
#line 377 "pattern-editor.vala"
	_cairo_pattern_destroy0 (_tmp5_);
#line 378 "pattern-editor.vala"
	cairo_fill (cr);
#line 2717 "pattern-editor.c"
	{
		gint position = 0;
#line 380 "pattern-editor.vala"
		position = 0;
#line 2722 "pattern-editor.c"
		{
			gboolean _tmp6_ = FALSE;
#line 380 "pattern-editor.vala"
			_tmp6_ = TRUE;
#line 380 "pattern-editor.vala"
			while (TRUE) {
#line 2729 "pattern-editor.c"
				gint x = 0;
				gint y = 0;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				PasangCustomPattern* _tmp13_;
				PasangPiece* _tmp14_;
				gint _tmp14__length1;
				PasangPiece _tmp15_;
#line 380 "pattern-editor.vala"
				if (!_tmp6_) {
#line 2742 "pattern-editor.c"
					gint _tmp7_;
#line 380 "pattern-editor.vala"
					_tmp7_ = position;
#line 380 "pattern-editor.vala"
					position = _tmp7_ + 1;
#line 2748 "pattern-editor.c"
				}
#line 380 "pattern-editor.vala"
				_tmp6_ = FALSE;
#line 380 "pattern-editor.vala"
				if (!(position < PASANG_BOARD_SIZE)) {
#line 380 "pattern-editor.vala"
					break;
#line 2756 "pattern-editor.c"
				}
#line 381 "pattern-editor.vala"
				x = position % PASANG_BOARD_WIDTH;
#line 382 "pattern-editor.vala"
				y = position / PASANG_BOARD_WIDTH;
#line 383 "pattern-editor.vala"
				if (x < 1) {
#line 383 "pattern-editor.vala"
					_tmp11_ = TRUE;
#line 2766 "pattern-editor.c"
				} else {
#line 383 "pattern-editor.vala"
					_tmp11_ = x > 11;
#line 2770 "pattern-editor.c"
				}
#line 383 "pattern-editor.vala"
				if (_tmp11_) {
#line 383 "pattern-editor.vala"
					_tmp10_ = TRUE;
#line 2776 "pattern-editor.c"
				} else {
#line 383 "pattern-editor.vala"
					_tmp10_ = y < 1;
#line 2780 "pattern-editor.c"
				}
#line 383 "pattern-editor.vala"
				if (_tmp10_) {
#line 383 "pattern-editor.vala"
					_tmp9_ = TRUE;
#line 2786 "pattern-editor.c"
				} else {
#line 383 "pattern-editor.vala"
					_tmp9_ = y > 11;
#line 2790 "pattern-editor.c"
				}
#line 383 "pattern-editor.vala"
				if (_tmp9_) {
#line 383 "pattern-editor.vala"
					_tmp8_ = TRUE;
#line 2796 "pattern-editor.c"
				} else {
					gboolean _tmp12_ = FALSE;
#line 383 "pattern-editor.vala"
					if (x == 6) {
#line 383 "pattern-editor.vala"
						_tmp12_ = y == 6;
#line 2803 "pattern-editor.c"
					} else {
#line 383 "pattern-editor.vala"
						_tmp12_ = FALSE;
#line 2807 "pattern-editor.c"
					}
#line 383 "pattern-editor.vala"
					_tmp8_ = _tmp12_;
#line 2811 "pattern-editor.c"
				}
#line 383 "pattern-editor.vala"
				if (_tmp8_) {
#line 383 "pattern-editor.vala"
					continue;
#line 2817 "pattern-editor.c"
				}
#line 384 "pattern-editor.vala"
				_tmp13_ = self->priv->active_pattern;
#line 384 "pattern-editor.vala"
				_tmp14_ = _tmp13_->board;
#line 384 "pattern-editor.vala"
				_tmp14__length1 = _tmp13_->board_length1;
#line 384 "pattern-editor.vala"
				_tmp15_ = _tmp14_[position];
#line 384 "pattern-editor.vala"
				if (_tmp15_ == PASANG_PIECE_WHITE) {
#line 2829 "pattern-editor.c"
					gdouble _tmp16_;
					gdouble _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					gdouble _tmp20_;
					gdouble _tmp21_;
					gdouble _tmp22_;
					gdouble _tmp23_;
					cairo_pattern_t* _tmp24_;
					cairo_pattern_t* _tmp25_;
					gdouble _tmp26_;
					gdouble _tmp27_;
					gdouble _tmp28_;
					gdouble _tmp29_;
					gdouble _tmp30_;
					gdouble _tmp31_;
					gdouble _tmp32_;
					gdouble _tmp33_;
					gdouble _tmp34_;
					gdouble _tmp35_;
					gdouble _tmp36_;
					gdouble _tmp37_;
					cairo_pattern_t* _tmp38_;
					cairo_pattern_t* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					gdouble _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					gdouble _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					gdouble _tmp48_;
					gdouble _tmp49_;
					gdouble _tmp50_;
					gdouble _tmp51_;
					cairo_pattern_t* _tmp52_;
					cairo_pattern_t* _tmp53_;
					gdouble _tmp54_;
					gdouble _tmp55_;
					gdouble _tmp56_;
					gdouble _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_;
					gdouble _tmp60_;
					gdouble _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_;
					gdouble _tmp65_;
					cairo_pattern_t* _tmp66_;
					cairo_pattern_t* _tmp67_;
					gdouble _tmp68_;
					gdouble _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					gdouble _tmp72_;
					gdouble _tmp73_;
					gdouble _tmp74_;
					gdouble _tmp75_;
					gdouble _tmp76_;
					gdouble _tmp77_;
					gdouble _tmp78_;
					gdouble _tmp79_;
					cairo_pattern_t* _tmp80_;
					cairo_pattern_t* _tmp81_;
					gdouble _tmp82_;
					gdouble _tmp83_;
					gdouble _tmp84_;
					gdouble _tmp85_;
					gdouble _tmp86_;
					gdouble _tmp87_;
					gdouble _tmp88_;
					gdouble _tmp89_;
					cairo_pattern_t* _tmp90_;
					cairo_pattern_t* _tmp91_;
#line 386 "pattern-editor.vala"
					_tmp16_ = pasang_pattern_editor_get_cell_width (self);
#line 386 "pattern-editor.vala"
					_tmp17_ = _tmp16_;
#line 386 "pattern-editor.vala"
					_tmp18_ = pasang_pattern_editor_get_cell_width (self);
#line 386 "pattern-editor.vala"
					_tmp19_ = _tmp18_;
#line 386 "pattern-editor.vala"
					_tmp20_ = pasang_pattern_editor_get_cell_width (self);
#line 386 "pattern-editor.vala"
					_tmp21_ = _tmp20_;
#line 386 "pattern-editor.vala"
					_tmp22_ = pasang_pattern_editor_get_cell_width (self);
#line 386 "pattern-editor.vala"
					_tmp23_ = _tmp22_;
#line 386 "pattern-editor.vala"
					cairo_rectangle (cr, x * _tmp17_, y * _tmp19_, _tmp21_, _tmp23_);
#line 387 "pattern-editor.vala"
					_tmp24_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, 0.8);
#line 387 "pattern-editor.vala"
					_tmp25_ = _tmp24_;
#line 387 "pattern-editor.vala"
					cairo_set_source (cr, _tmp25_);
#line 387 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp25_);
#line 388 "pattern-editor.vala"
					cairo_fill (cr);
#line 390 "pattern-editor.vala"
					_tmp26_ = pasang_pattern_editor_get_cell_width (self);
#line 390 "pattern-editor.vala"
					_tmp27_ = _tmp26_;
#line 390 "pattern-editor.vala"
					_tmp28_ = pasang_pattern_editor_get_cell_width (self);
#line 390 "pattern-editor.vala"
					_tmp29_ = _tmp28_;
#line 390 "pattern-editor.vala"
					cairo_move_to (cr, (x + 1) * _tmp27_, y * _tmp29_);
#line 391 "pattern-editor.vala"
					_tmp30_ = pasang_pattern_editor_get_cell_width (self);
#line 391 "pattern-editor.vala"
					_tmp31_ = _tmp30_;
#line 391 "pattern-editor.vala"
					_tmp32_ = pasang_pattern_editor_get_cell_width (self);
#line 391 "pattern-editor.vala"
					_tmp33_ = _tmp32_;
#line 391 "pattern-editor.vala"
					cairo_line_to (cr, (x + 0.5) * _tmp31_, (y + 0.5) * _tmp33_);
#line 392 "pattern-editor.vala"
					_tmp34_ = pasang_pattern_editor_get_cell_width (self);
#line 392 "pattern-editor.vala"
					_tmp35_ = _tmp34_;
#line 392 "pattern-editor.vala"
					_tmp36_ = pasang_pattern_editor_get_cell_width (self);
#line 392 "pattern-editor.vala"
					_tmp37_ = _tmp36_;
#line 392 "pattern-editor.vala"
					cairo_line_to (cr, x * _tmp35_, y * _tmp37_);
#line 393 "pattern-editor.vala"
					cairo_close_path (cr);
#line 394 "pattern-editor.vala"
					_tmp38_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, (gdouble) 1);
#line 394 "pattern-editor.vala"
					_tmp39_ = _tmp38_;
#line 394 "pattern-editor.vala"
					cairo_set_source (cr, _tmp39_);
#line 394 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp39_);
#line 395 "pattern-editor.vala"
					cairo_fill (cr);
#line 396 "pattern-editor.vala"
					_tmp40_ = pasang_pattern_editor_get_cell_width (self);
#line 396 "pattern-editor.vala"
					_tmp41_ = _tmp40_;
#line 396 "pattern-editor.vala"
					_tmp42_ = pasang_pattern_editor_get_cell_width (self);
#line 396 "pattern-editor.vala"
					_tmp43_ = _tmp42_;
#line 396 "pattern-editor.vala"
					cairo_move_to (cr, x * _tmp41_, y * _tmp43_);
#line 397 "pattern-editor.vala"
					_tmp44_ = pasang_pattern_editor_get_cell_width (self);
#line 397 "pattern-editor.vala"
					_tmp45_ = _tmp44_;
#line 397 "pattern-editor.vala"
					_tmp46_ = pasang_pattern_editor_get_cell_width (self);
#line 397 "pattern-editor.vala"
					_tmp47_ = _tmp46_;
#line 397 "pattern-editor.vala"
					cairo_line_to (cr, (x + 0.5) * _tmp45_, (y + 0.5) * _tmp47_);
#line 398 "pattern-editor.vala"
					_tmp48_ = pasang_pattern_editor_get_cell_width (self);
#line 398 "pattern-editor.vala"
					_tmp49_ = _tmp48_;
#line 398 "pattern-editor.vala"
					_tmp50_ = pasang_pattern_editor_get_cell_width (self);
#line 398 "pattern-editor.vala"
					_tmp51_ = _tmp50_;
#line 398 "pattern-editor.vala"
					cairo_line_to (cr, x * _tmp49_, (y + 1) * _tmp51_);
#line 399 "pattern-editor.vala"
					cairo_close_path (cr);
#line 400 "pattern-editor.vala"
					_tmp52_ = cairo_pattern_create_rgb (0.95, 0.95, 0.95);
#line 400 "pattern-editor.vala"
					_tmp53_ = _tmp52_;
#line 400 "pattern-editor.vala"
					cairo_set_source (cr, _tmp53_);
#line 400 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp53_);
#line 401 "pattern-editor.vala"
					cairo_fill (cr);
#line 403 "pattern-editor.vala"
					_tmp54_ = pasang_pattern_editor_get_cell_width (self);
#line 403 "pattern-editor.vala"
					_tmp55_ = _tmp54_;
#line 403 "pattern-editor.vala"
					_tmp56_ = pasang_pattern_editor_get_cell_width (self);
#line 403 "pattern-editor.vala"
					_tmp57_ = _tmp56_;
#line 403 "pattern-editor.vala"
					cairo_move_to (cr, x * _tmp55_, (y + 1) * _tmp57_);
#line 404 "pattern-editor.vala"
					_tmp58_ = pasang_pattern_editor_get_cell_width (self);
#line 404 "pattern-editor.vala"
					_tmp59_ = _tmp58_;
#line 404 "pattern-editor.vala"
					_tmp60_ = pasang_pattern_editor_get_cell_width (self);
#line 404 "pattern-editor.vala"
					_tmp61_ = _tmp60_;
#line 404 "pattern-editor.vala"
					cairo_line_to (cr, (x + 0.5) * _tmp59_, (y + 0.5) * _tmp61_);
#line 405 "pattern-editor.vala"
					_tmp62_ = pasang_pattern_editor_get_cell_width (self);
#line 405 "pattern-editor.vala"
					_tmp63_ = _tmp62_;
#line 405 "pattern-editor.vala"
					_tmp64_ = pasang_pattern_editor_get_cell_width (self);
#line 405 "pattern-editor.vala"
					_tmp65_ = _tmp64_;
#line 405 "pattern-editor.vala"
					cairo_line_to (cr, (x + 1) * _tmp63_, (y + 1) * _tmp65_);
#line 406 "pattern-editor.vala"
					cairo_close_path (cr);
#line 407 "pattern-editor.vala"
					_tmp66_ = cairo_pattern_create_rgb (0.7, 0.7, 0.6);
#line 407 "pattern-editor.vala"
					_tmp67_ = _tmp66_;
#line 407 "pattern-editor.vala"
					cairo_set_source (cr, _tmp67_);
#line 407 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp67_);
#line 408 "pattern-editor.vala"
					cairo_fill (cr);
#line 409 "pattern-editor.vala"
					_tmp68_ = pasang_pattern_editor_get_cell_width (self);
#line 409 "pattern-editor.vala"
					_tmp69_ = _tmp68_;
#line 409 "pattern-editor.vala"
					_tmp70_ = pasang_pattern_editor_get_cell_width (self);
#line 409 "pattern-editor.vala"
					_tmp71_ = _tmp70_;
#line 409 "pattern-editor.vala"
					cairo_move_to (cr, (x + 1) * _tmp69_, (y + 1) * _tmp71_);
#line 410 "pattern-editor.vala"
					_tmp72_ = pasang_pattern_editor_get_cell_width (self);
#line 410 "pattern-editor.vala"
					_tmp73_ = _tmp72_;
#line 410 "pattern-editor.vala"
					_tmp74_ = pasang_pattern_editor_get_cell_width (self);
#line 410 "pattern-editor.vala"
					_tmp75_ = _tmp74_;
#line 410 "pattern-editor.vala"
					cairo_line_to (cr, (x + 0.5) * _tmp73_, (y + 0.5) * _tmp75_);
#line 411 "pattern-editor.vala"
					_tmp76_ = pasang_pattern_editor_get_cell_width (self);
#line 411 "pattern-editor.vala"
					_tmp77_ = _tmp76_;
#line 411 "pattern-editor.vala"
					_tmp78_ = pasang_pattern_editor_get_cell_width (self);
#line 411 "pattern-editor.vala"
					_tmp79_ = _tmp78_;
#line 411 "pattern-editor.vala"
					cairo_line_to (cr, (x + 1) * _tmp77_, y * _tmp79_);
#line 412 "pattern-editor.vala"
					cairo_close_path (cr);
#line 413 "pattern-editor.vala"
					_tmp80_ = cairo_pattern_create_rgb (0.8, 0.8, 0.7);
#line 413 "pattern-editor.vala"
					_tmp81_ = _tmp80_;
#line 413 "pattern-editor.vala"
					cairo_set_source (cr, _tmp81_);
#line 413 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp81_);
#line 414 "pattern-editor.vala"
					cairo_fill (cr);
#line 416 "pattern-editor.vala"
					_tmp82_ = pasang_pattern_editor_get_cell_width (self);
#line 416 "pattern-editor.vala"
					_tmp83_ = _tmp82_;
#line 416 "pattern-editor.vala"
					_tmp84_ = pasang_pattern_editor_get_cell_width (self);
#line 416 "pattern-editor.vala"
					_tmp85_ = _tmp84_;
#line 416 "pattern-editor.vala"
					_tmp86_ = pasang_pattern_editor_get_cell_width (self);
#line 416 "pattern-editor.vala"
					_tmp87_ = _tmp86_;
#line 416 "pattern-editor.vala"
					_tmp88_ = pasang_pattern_editor_get_cell_width (self);
#line 416 "pattern-editor.vala"
					_tmp89_ = _tmp88_;
#line 416 "pattern-editor.vala"
					cairo_rectangle (cr, (x + 0.1) * _tmp83_, (y + 0.1) * _tmp85_, 0.8 * _tmp87_, 0.8 * _tmp89_);
#line 417 "pattern-editor.vala"
					_tmp90_ = cairo_pattern_create_rgb ((gdouble) 1, (gdouble) 1, 0.7);
#line 417 "pattern-editor.vala"
					_tmp91_ = _tmp90_;
#line 417 "pattern-editor.vala"
					cairo_set_source (cr, _tmp91_);
#line 417 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp91_);
#line 418 "pattern-editor.vala"
					cairo_fill (cr);
#line 3130 "pattern-editor.c"
				} else {
					gdouble _tmp92_;
					gdouble _tmp93_;
					gdouble _tmp94_;
					gdouble _tmp95_;
					gdouble _tmp96_;
					gdouble _tmp97_;
					gdouble _tmp98_;
					gdouble _tmp99_;
					cairo_pattern_t* _tmp100_;
					cairo_pattern_t* _tmp101_;
#line 421 "pattern-editor.vala"
					_tmp92_ = pasang_pattern_editor_get_cell_width (self);
#line 421 "pattern-editor.vala"
					_tmp93_ = _tmp92_;
#line 421 "pattern-editor.vala"
					_tmp94_ = pasang_pattern_editor_get_cell_width (self);
#line 421 "pattern-editor.vala"
					_tmp95_ = _tmp94_;
#line 421 "pattern-editor.vala"
					_tmp96_ = pasang_pattern_editor_get_cell_width (self);
#line 421 "pattern-editor.vala"
					_tmp97_ = _tmp96_;
#line 421 "pattern-editor.vala"
					_tmp98_ = pasang_pattern_editor_get_cell_width (self);
#line 421 "pattern-editor.vala"
					_tmp99_ = _tmp98_;
#line 421 "pattern-editor.vala"
					cairo_rectangle (cr, (x + 0.05) * _tmp93_, (y + 0.05) * _tmp95_, 0.9 * _tmp97_, 0.9 * _tmp99_);
#line 422 "pattern-editor.vala"
					_tmp100_ = cairo_pattern_create_rgb ((gdouble) 0, 0.4, 0.4);
#line 422 "pattern-editor.vala"
					_tmp101_ = _tmp100_;
#line 422 "pattern-editor.vala"
					cairo_set_source (cr, _tmp101_);
#line 422 "pattern-editor.vala"
					_cairo_pattern_destroy0 (_tmp101_);
#line 423 "pattern-editor.vala"
					cairo_fill (cr);
#line 3170 "pattern-editor.c"
				}
			}
		}
	}
#line 426 "pattern-editor.vala"
	_tmp102_ = self->priv->cursors;
#line 426 "pattern-editor.vala"
	_tmp102__length1 = self->priv->cursors_length1;
#line 3179 "pattern-editor.c"
	{
		PasangPoint* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
#line 426 "pattern-editor.vala"
		c_collection = _tmp102_;
#line 426 "pattern-editor.vala"
		c_collection_length1 = _tmp102__length1;
#line 426 "pattern-editor.vala"
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
#line 3191 "pattern-editor.c"
			PasangPoint c = {0};
#line 426 "pattern-editor.vala"
			c = c_collection[c_it];
#line 3195 "pattern-editor.c"
			{
				PasangPoint _tmp103_;
				PasangPoint _tmp104_;
				gdouble _tmp105_;
				gdouble _tmp106_;
				PasangPoint _tmp107_;
				gdouble _tmp108_;
				gdouble _tmp109_;
				gdouble _tmp110_;
				gdouble _tmp111_;
				gdouble _tmp112_;
				gdouble _tmp113_;
				cairo_pattern_t* _tmp114_;
				cairo_pattern_t* _tmp115_;
#line 427 "pattern-editor.vala"
				_tmp103_ = c;
#line 427 "pattern-editor.vala"
				if (_tmp103_.x == 0) {
#line 427 "pattern-editor.vala"
					continue;
#line 3216 "pattern-editor.c"
				}
#line 428 "pattern-editor.vala"
				_tmp104_ = c;
#line 428 "pattern-editor.vala"
				_tmp105_ = pasang_pattern_editor_get_cell_width (self);
#line 428 "pattern-editor.vala"
				_tmp106_ = _tmp105_;
#line 428 "pattern-editor.vala"
				_tmp107_ = c;
#line 428 "pattern-editor.vala"
				_tmp108_ = pasang_pattern_editor_get_cell_width (self);
#line 428 "pattern-editor.vala"
				_tmp109_ = _tmp108_;
#line 428 "pattern-editor.vala"
				_tmp110_ = pasang_pattern_editor_get_cell_width (self);
#line 428 "pattern-editor.vala"
				_tmp111_ = _tmp110_;
#line 428 "pattern-editor.vala"
				_tmp112_ = pasang_pattern_editor_get_cell_width (self);
#line 428 "pattern-editor.vala"
				_tmp113_ = _tmp112_;
#line 428 "pattern-editor.vala"
				cairo_rectangle (cr, (_tmp104_.x + 0.2) * _tmp106_, (_tmp107_.y + 0.2) * _tmp109_, 0.6 * _tmp111_, 0.6 * _tmp113_);
#line 429 "pattern-editor.vala"
				_tmp114_ = cairo_pattern_create_rgb (0.5, 0.5, (gdouble) 1);
#line 429 "pattern-editor.vala"
				_tmp115_ = _tmp114_;
#line 429 "pattern-editor.vala"
				cairo_set_source (cr, _tmp115_);
#line 429 "pattern-editor.vala"
				_cairo_pattern_destroy0 (_tmp115_);
#line 430 "pattern-editor.vala"
				cairo_fill (cr);
#line 3250 "pattern-editor.c"
			}
		}
	}
}

static gdouble
pasang_pattern_editor_get_cell_width (PasangPatternEditor* self)
{
	gdouble result;
	GtkAllocation alloc = {0};
	GtkDrawingArea* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gint width = 0;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
#line 285 "pattern-editor.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 286 "pattern-editor.vala"
	memset (&alloc, 0, sizeof (GtkAllocation));
#line 287 "pattern-editor.vala"
	_tmp0_ = self->priv->editing_box;
#line 287 "pattern-editor.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
#line 287 "pattern-editor.vala"
	alloc = _tmp1_;
#line 288 "pattern-editor.vala"
	_tmp2_ = alloc;
#line 288 "pattern-editor.vala"
	_tmp3_ = alloc;
#line 288 "pattern-editor.vala"
	width = MIN (_tmp2_.width, _tmp3_.height);
#line 289 "pattern-editor.vala"
	result = (1.0 * width) / PASANG_BOARD_WIDTH;
#line 289 "pattern-editor.vala"
	return result;
#line 3286 "pattern-editor.c"
}

static void
pasang_pattern_editor_class_init (PasangPatternEditorClass * klass,
                                  gpointer klass_data)
{
#line 21 "pattern-editor.vala"
	pasang_pattern_editor_parent_class = g_type_class_peek_parent (klass);
#line 21 "pattern-editor.vala"
	g_type_class_adjust_private_offset (klass, &PasangPatternEditor_private_offset);
#line 21 "pattern-editor.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_pasang_pattern_editor_get_property;
#line 21 "pattern-editor.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_pattern_editor_finalize;
#line 3301 "pattern-editor.c"
}

static void
pasang_pattern_editor_instance_init (PasangPatternEditor * self,
                                     gpointer klass)
{
	PasangCustomPattern** _tmp0_;
	GtkGrid* _tmp1_;
	PasangPoint* _tmp2_;
#line 21 "pattern-editor.vala"
	self->priv = pasang_pattern_editor_get_instance_private (self);
#line 22 "pattern-editor.vala"
	self->priv->editing_box = NULL;
#line 28 "pattern-editor.vala"
	_tmp0_ = g_new0 (PasangCustomPattern*, 0 + 1);
#line 28 "pattern-editor.vala"
	self->priv->patterns = _tmp0_;
#line 28 "pattern-editor.vala"
	self->priv->patterns_length1 = 0;
#line 28 "pattern-editor.vala"
	self->priv->_patterns_size_ = self->priv->patterns_length1;
#line 33 "pattern-editor.vala"
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
#line 33 "pattern-editor.vala"
	g_object_ref_sink (_tmp1_);
#line 33 "pattern-editor.vala"
	self->priv->pattern_button_box = _tmp1_;
#line 48 "pattern-editor.vala"
	self->priv->active_color = PASANG_PIECE_NULL;
#line 58 "pattern-editor.vala"
	self->priv->symmetry = 'S';
#line 63 "pattern-editor.vala"
	pasang_point_init_xy (&self->priv->cursor, 0, 0);
#line 69 "pattern-editor.vala"
	_tmp2_ = g_new0 (PasangPoint, 0);
#line 69 "pattern-editor.vala"
	self->priv->cursors = _tmp2_;
#line 69 "pattern-editor.vala"
	self->priv->cursors_length1 = 0;
#line 69 "pattern-editor.vala"
	self->priv->_cursors_size_ = self->priv->cursors_length1;
#line 3343 "pattern-editor.c"
}

static void
pasang_pattern_editor_finalize (GObject * obj)
{
	PasangPatternEditor * self;
#line 21 "pattern-editor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditor);
#line 22 "pattern-editor.vala"
	_g_object_unref0 (self->priv->editing_box);
#line 23 "pattern-editor.vala"
	_g_object_unref0 (self->priv->pattern_selector);
#line 28 "pattern-editor.vala"
	self->priv->patterns = (_vala_array_free (self->priv->patterns, self->priv->patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 33 "pattern-editor.vala"
	_g_object_unref0 (self->priv->pattern_button_box);
#line 38 "pattern-editor.vala"
	_g_free0 (self->priv->custom_pattern_filename);
#line 69 "pattern-editor.vala"
	self->priv->cursors = (g_free (self->priv->cursors), NULL);
#line 71 "pattern-editor.vala"
	_g_object_unref0 (self->priv->gesture);
#line 72 "pattern-editor.vala"
	_g_object_unref0 (self->priv->event_controller);
#line 21 "pattern-editor.vala"
	G_OBJECT_CLASS (pasang_pattern_editor_parent_class)->finalize (obj);
#line 3370 "pattern-editor.c"
}

GType
pasang_pattern_editor_get_type (void)
{
	static volatile gsize pasang_pattern_editor_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_pattern_editor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangPatternEditorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_pattern_editor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangPatternEditor), 0, (GInstanceInitFunc) pasang_pattern_editor_instance_init, NULL };
		GType pasang_pattern_editor_type_id;
		pasang_pattern_editor_type_id = g_type_register_static (gtk_grid_get_type (), "PasangPatternEditor", &g_define_type_info, 0);
		PasangPatternEditor_private_offset = g_type_add_instance_private (pasang_pattern_editor_type_id, sizeof (PasangPatternEditorPrivate));
		g_once_init_leave (&pasang_pattern_editor_type_id__volatile, pasang_pattern_editor_type_id);
	}
	return pasang_pattern_editor_type_id__volatile;
}

static void
_vala_pasang_pattern_editor_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PasangPatternEditor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PASANG_TYPE_PATTERN_EDITOR, PasangPatternEditor);
#line 21 "pattern-editor.vala"
	switch (property_id) {
#line 3397 "pattern-editor.c"
		default:
#line 21 "pattern-editor.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "pattern-editor.vala"
		break;
#line 3403 "pattern-editor.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

