/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ChebyshevDistance
extends NormalizableDistance
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7739904999895461429L;

    public ChebyshevDistance() {
    }

    public ChebyshevDistance(Instances data) {
        super(data);
    }

    @Override
    public String globalInfo() {
        return "Implements the Chebyshev distance. The distance between two vectors is the greatest of their differences along any coordinate dimension.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Chebyshev distance");
        result.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Chebyshev_distance");
        return result;
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        double result = currDist;
        if ((diff = Math.abs(diff)) > result) {
            result = diff;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

