#ifndef ATL_stGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,63,102,141,180,219,258,297,336,492,570,648,959,1271,1426,1582,1738,1894,2206,2518,3765,5012,5167,5323,5479,5635,5791,5947,6103,6259,6882,7506,7817,8129,8441,8753,8908,9064,9220,9376,9688,10000
 * N : 25,63,102,141,180,219,258,297,336,492,570,648,959,1271,1426,1582,1738,1894,2206,2518,3765,5012,5167,5323,5479,5635,5791,5947,6103,6259,6882,7506,7817,8129,8441,8753,8908,9064,9220,9376,9688,10000
 * NB : 1,3,4,4,7,7,8,16,19,11,27,83,83,99,111,115,116,119,119,131,135,163,163,164,164,165,165,166,166,167,171,195,195,227,229,235,235,236,236,239,239,259
 */
#define ATL_stGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 44) (nb_) = 1; \
   else if ((n_) < 82) (nb_) = 3; \
   else if ((n_) < 160) (nb_) = 4; \
   else if ((n_) < 238) (nb_) = 7; \
   else if ((n_) < 277) (nb_) = 8; \
   else if ((n_) < 316) (nb_) = 16; \
   else if ((n_) < 414) (nb_) = 19; \
   else if ((n_) < 531) (nb_) = 11; \
   else if ((n_) < 609) (nb_) = 27; \
   else if ((n_) < 1115) (nb_) = 83; \
   else if ((n_) < 1348) (nb_) = 99; \
   else if ((n_) < 1504) (nb_) = 111; \
   else if ((n_) < 1660) (nb_) = 115; \
   else if ((n_) < 1816) (nb_) = 116; \
   else if ((n_) < 2362) (nb_) = 119; \
   else if ((n_) < 3141) (nb_) = 131; \
   else if ((n_) < 4388) (nb_) = 135; \
   else if ((n_) < 5245) (nb_) = 163; \
   else if ((n_) < 5557) (nb_) = 164; \
   else if ((n_) < 5869) (nb_) = 165; \
   else if ((n_) < 6181) (nb_) = 166; \
   else if ((n_) < 6570) (nb_) = 167; \
   else if ((n_) < 7194) (nb_) = 171; \
   else if ((n_) < 7973) (nb_) = 195; \
   else if ((n_) < 8285) (nb_) = 227; \
   else if ((n_) < 8597) (nb_) = 229; \
   else if ((n_) < 8986) (nb_) = 235; \
   else if ((n_) < 9298) (nb_) = 236; \
   else if ((n_) < 9844) (nb_) = 239; \
   else (nb_) = 259; \
}


#endif    /* end ifndef ATL_stGetNB_geqrf */
