// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateDelegateToResource = "AssociateDelegateToResource"

// AssociateDelegateToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDelegateToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDelegateToResource for more information on using the AssociateDelegateToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateDelegateToResourceRequest method.
//    req, resp := client.AssociateDelegateToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource
func (c *WorkMail) AssociateDelegateToResourceRequest(input *AssociateDelegateToResourceInput) (req *request.Request, output *AssociateDelegateToResourceOutput) {
	op := &request.Operation{
		Name:       opAssociateDelegateToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateDelegateToResourceInput{}
	}

	output = &AssociateDelegateToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateDelegateToResource API operation for Amazon WorkMail.
//
// Adds a member to the resource's set of delegates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation AssociateDelegateToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource
func (c *WorkMail) AssociateDelegateToResource(input *AssociateDelegateToResourceInput) (*AssociateDelegateToResourceOutput, error) {
	req, out := c.AssociateDelegateToResourceRequest(input)
	return out, req.Send()
}

// AssociateDelegateToResourceWithContext is the same as AssociateDelegateToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDelegateToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) AssociateDelegateToResourceWithContext(ctx aws.Context, input *AssociateDelegateToResourceInput, opts ...request.Option) (*AssociateDelegateToResourceOutput, error) {
	req, out := c.AssociateDelegateToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateMemberToGroup = "AssociateMemberToGroup"

// AssociateMemberToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToGroup for more information on using the AssociateMemberToGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateMemberToGroupRequest method.
//    req, resp := client.AssociateMemberToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup
func (c *WorkMail) AssociateMemberToGroupRequest(input *AssociateMemberToGroupInput) (req *request.Request, output *AssociateMemberToGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateMemberToGroupInput{}
	}

	output = &AssociateMemberToGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateMemberToGroup API operation for Amazon WorkMail.
//
// Adds a member to the group's set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation AssociateMemberToGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup
func (c *WorkMail) AssociateMemberToGroup(input *AssociateMemberToGroupInput) (*AssociateMemberToGroupOutput, error) {
	req, out := c.AssociateMemberToGroupRequest(input)
	return out, req.Send()
}

// AssociateMemberToGroupWithContext is the same as AssociateMemberToGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) AssociateMemberToGroupWithContext(ctx aws.Context, input *AssociateMemberToGroupInput, opts ...request.Option) (*AssociateMemberToGroupOutput, error) {
	req, out := c.AssociateMemberToGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias
func (c *WorkMail) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for Amazon WorkMail.
//
// Adds an alias to the set of a given member of Amazon WorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEmailAddressInUseException "EmailAddressInUseException"
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeMailDomainNotFoundException "MailDomainNotFoundException"
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * ErrCodeMailDomainStateException "MailDomainStateException"
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias
func (c *WorkMail) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup
func (c *WorkMail) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for Amazon WorkMail.
//
// Creates a group that can be used in Amazon WorkMail by calling the RegisterToWorkMail
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeNameAvailabilityException "NameAvailabilityException"
//   The entity (user, group, or user) name isn't unique in Amazon WorkMail.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeReservedNameException "ReservedNameException"
//   This entity name is not allowed in Amazon WorkMail.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup
func (c *WorkMail) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResource = "CreateResource"

// CreateResourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResource for more information on using the CreateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceRequest method.
//    req, resp := client.CreateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource
func (c *WorkMail) CreateResourceRequest(input *CreateResourceInput) (req *request.Request, output *CreateResourceOutput) {
	op := &request.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	output = &CreateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResource API operation for Amazon WorkMail.
//
// Creates a new Amazon WorkMail resource. The available types are equipment
// and room.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeNameAvailabilityException "NameAvailabilityException"
//   The entity (user, group, or user) name isn't unique in Amazon WorkMail.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeReservedNameException "ReservedNameException"
//   This entity name is not allowed in Amazon WorkMail.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource
func (c *WorkMail) CreateResource(input *CreateResourceInput) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	return out, req.Send()
}

// CreateResourceWithContext is the same as CreateResource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateResourceWithContext(ctx aws.Context, input *CreateResourceInput, opts ...request.Option) (*CreateResourceOutput, error) {
	req, out := c.CreateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser
func (c *WorkMail) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon WorkMail.
//
// Creates a user who can be used in Amazon WorkMail by calling the RegisterToWorkMail
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation CreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   The supplied password doesn't match the minimum security constraints, such
//   as length or use of special characters.
//
//   * ErrCodeNameAvailabilityException "NameAvailabilityException"
//   The entity (user, group, or user) name isn't unique in Amazon WorkMail.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeReservedNameException "ReservedNameException"
//   This entity name is not allowed in Amazon WorkMail.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser
func (c *WorkMail) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAlias for more information on using the DeleteAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias
func (c *WorkMail) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAlias API operation for Amazon WorkMail.
//
// Remove the alias from a set of aliases for a given user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias
func (c *WorkMail) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	return out, req.Send()
}

// DeleteAliasWithContext is the same as DeleteAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteAliasWithContext(ctx aws.Context, input *DeleteAliasInput, opts ...request.Option) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup
func (c *WorkMail) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for Amazon WorkMail.
//
// Deletes a group from Amazon WorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup
func (c *WorkMail) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMailboxPermissions = "DeleteMailboxPermissions"

// DeleteMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMailboxPermissions for more information on using the DeleteMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMailboxPermissionsRequest method.
//    req, resp := client.DeleteMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions
func (c *WorkMail) DeleteMailboxPermissionsRequest(input *DeleteMailboxPermissionsInput) (req *request.Request, output *DeleteMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opDeleteMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMailboxPermissionsInput{}
	}

	output = &DeleteMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMailboxPermissions API operation for Amazon WorkMail.
//
// Deletes permissions granted to a user or group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteMailboxPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions
func (c *WorkMail) DeleteMailboxPermissions(input *DeleteMailboxPermissionsInput) (*DeleteMailboxPermissionsOutput, error) {
	req, out := c.DeleteMailboxPermissionsRequest(input)
	return out, req.Send()
}

// DeleteMailboxPermissionsWithContext is the same as DeleteMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteMailboxPermissionsWithContext(ctx aws.Context, input *DeleteMailboxPermissionsInput, opts ...request.Option) (*DeleteMailboxPermissionsOutput, error) {
	req, out := c.DeleteMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResource for more information on using the DeleteResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceRequest method.
//    req, resp := client.DeleteResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource
func (c *WorkMail) DeleteResourceRequest(input *DeleteResourceInput) (req *request.Request, output *DeleteResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	output = &DeleteResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResource API operation for Amazon WorkMail.
//
// Deletes the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource
func (c *WorkMail) DeleteResource(input *DeleteResourceInput) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	return out, req.Send()
}

// DeleteResourceWithContext is the same as DeleteResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteResourceWithContext(ctx aws.Context, input *DeleteResourceInput, opts ...request.Option) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser
func (c *WorkMail) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon WorkMail.
//
// Deletes a user from Amazon WorkMail and all subsequent systems. The action
// can't be undone. The mailbox is kept as-is for a minimum of 30 days, without
// any means to restore it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser
func (c *WorkMail) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterFromWorkMail = "DeregisterFromWorkMail"

// DeregisterFromWorkMailRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterFromWorkMail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterFromWorkMail for more information on using the DeregisterFromWorkMail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterFromWorkMailRequest method.
//    req, resp := client.DeregisterFromWorkMailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail
func (c *WorkMail) DeregisterFromWorkMailRequest(input *DeregisterFromWorkMailInput) (req *request.Request, output *DeregisterFromWorkMailOutput) {
	op := &request.Operation{
		Name:       opDeregisterFromWorkMail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterFromWorkMailInput{}
	}

	output = &DeregisterFromWorkMailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterFromWorkMail API operation for Amazon WorkMail.
//
// Mark a user, group, or resource as no longer used in Amazon WorkMail. This
// action disassociates the mailbox and schedules it for clean-up. Amazon WorkMail
// keeps mailboxes for 30 days before they are permanently removed. The functionality
// in the console is Disable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DeregisterFromWorkMail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail
func (c *WorkMail) DeregisterFromWorkMail(input *DeregisterFromWorkMailInput) (*DeregisterFromWorkMailOutput, error) {
	req, out := c.DeregisterFromWorkMailRequest(input)
	return out, req.Send()
}

// DeregisterFromWorkMailWithContext is the same as DeregisterFromWorkMail with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterFromWorkMail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DeregisterFromWorkMailWithContext(ctx aws.Context, input *DeregisterFromWorkMailInput, opts ...request.Option) (*DeregisterFromWorkMailOutput, error) {
	req, out := c.DeregisterFromWorkMailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGroup = "DescribeGroup"

// DescribeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGroup for more information on using the DescribeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGroupRequest method.
//    req, resp := client.DescribeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup
func (c *WorkMail) DescribeGroupRequest(input *DescribeGroupInput) (req *request.Request, output *DescribeGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGroupInput{}
	}

	output = &DescribeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGroup API operation for Amazon WorkMail.
//
// Returns the data available for the group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup
func (c *WorkMail) DescribeGroup(input *DescribeGroupInput) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	return out, req.Send()
}

// DescribeGroupWithContext is the same as DescribeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeGroupWithContext(ctx aws.Context, input *DescribeGroupInput, opts ...request.Option) (*DescribeGroupOutput, error) {
	req, out := c.DescribeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOrganization = "DescribeOrganization"

// DescribeOrganizationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrganization operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrganization for more information on using the DescribeOrganization
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrganizationRequest method.
//    req, resp := client.DescribeOrganizationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization
func (c *WorkMail) DescribeOrganizationRequest(input *DescribeOrganizationInput) (req *request.Request, output *DescribeOrganizationOutput) {
	op := &request.Operation{
		Name:       opDescribeOrganization,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOrganizationInput{}
	}

	output = &DescribeOrganizationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrganization API operation for Amazon WorkMail.
//
// Provides more information regarding a given organization based on its identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeOrganization for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization
func (c *WorkMail) DescribeOrganization(input *DescribeOrganizationInput) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	return out, req.Send()
}

// DescribeOrganizationWithContext is the same as DescribeOrganization with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrganization for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeOrganizationWithContext(ctx aws.Context, input *DescribeOrganizationInput, opts ...request.Option) (*DescribeOrganizationOutput, error) {
	req, out := c.DescribeOrganizationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResource = "DescribeResource"

// DescribeResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResource for more information on using the DescribeResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceRequest method.
//    req, resp := client.DescribeResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource
func (c *WorkMail) DescribeResourceRequest(input *DescribeResourceInput) (req *request.Request, output *DescribeResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceInput{}
	}

	output = &DescribeResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResource API operation for Amazon WorkMail.
//
// Returns the data available for the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource
func (c *WorkMail) DescribeResource(input *DescribeResourceInput) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	return out, req.Send()
}

// DescribeResourceWithContext is the same as DescribeResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeResourceWithContext(ctx aws.Context, input *DescribeResourceInput, opts ...request.Option) (*DescribeResourceOutput, error) {
	req, out := c.DescribeResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserRequest method.
//    req, resp := client.DescribeUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser
func (c *WorkMail) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon WorkMail.
//
// Provides information regarding the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DescribeUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser
func (c *WorkMail) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDelegateFromResource = "DisassociateDelegateFromResource"

// DisassociateDelegateFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDelegateFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDelegateFromResource for more information on using the DisassociateDelegateFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateDelegateFromResourceRequest method.
//    req, resp := client.DisassociateDelegateFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource
func (c *WorkMail) DisassociateDelegateFromResourceRequest(input *DisassociateDelegateFromResourceInput) (req *request.Request, output *DisassociateDelegateFromResourceOutput) {
	op := &request.Operation{
		Name:       opDisassociateDelegateFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateDelegateFromResourceInput{}
	}

	output = &DisassociateDelegateFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateDelegateFromResource API operation for Amazon WorkMail.
//
// Removes a member from the resource's set of delegates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DisassociateDelegateFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource
func (c *WorkMail) DisassociateDelegateFromResource(input *DisassociateDelegateFromResourceInput) (*DisassociateDelegateFromResourceOutput, error) {
	req, out := c.DisassociateDelegateFromResourceRequest(input)
	return out, req.Send()
}

// DisassociateDelegateFromResourceWithContext is the same as DisassociateDelegateFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDelegateFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DisassociateDelegateFromResourceWithContext(ctx aws.Context, input *DisassociateDelegateFromResourceInput, opts ...request.Option) (*DisassociateDelegateFromResourceOutput, error) {
	req, out := c.DisassociateDelegateFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromGroup = "DisassociateMemberFromGroup"

// DisassociateMemberFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromGroup for more information on using the DisassociateMemberFromGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateMemberFromGroupRequest method.
//    req, resp := client.DisassociateMemberFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup
func (c *WorkMail) DisassociateMemberFromGroupRequest(input *DisassociateMemberFromGroupInput) (req *request.Request, output *DisassociateMemberFromGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateMemberFromGroupInput{}
	}

	output = &DisassociateMemberFromGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateMemberFromGroup API operation for Amazon WorkMail.
//
// Removes a member from a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation DisassociateMemberFromGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup
func (c *WorkMail) DisassociateMemberFromGroup(input *DisassociateMemberFromGroupInput) (*DisassociateMemberFromGroupOutput, error) {
	req, out := c.DisassociateMemberFromGroupRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromGroupWithContext is the same as DisassociateMemberFromGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) DisassociateMemberFromGroupWithContext(ctx aws.Context, input *DisassociateMemberFromGroupInput, opts ...request.Option) (*DisassociateMemberFromGroupOutput, error) {
	req, out := c.DisassociateMemberFromGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAliases for more information on using the ListAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases
func (c *WorkMail) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for Amazon WorkMail.
//
// Creates a paginated call to list the aliases associated with a given entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases
func (c *WorkMail) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	return out, req.Send()
}

// ListAliasesWithContext is the same as ListAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListAliasesWithContext(ctx aws.Context, input *ListAliasesInput, opts ...request.Option) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAliases operation.
//    pageNum := 0
//    err := client.ListAliasesPages(params,
//        func(page *ListAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListAliasesPages(input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool) error {
	return c.ListAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAliasesPagesWithContext same as ListAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListAliasesPagesWithContext(ctx aws.Context, input *ListAliasesInput, fn func(*ListAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAliasesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListGroupMembers = "ListGroupMembers"

// ListGroupMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupMembers for more information on using the ListGroupMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupMembersRequest method.
//    req, resp := client.ListGroupMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers
func (c *WorkMail) ListGroupMembersRequest(input *ListGroupMembersInput) (req *request.Request, output *ListGroupMembersOutput) {
	op := &request.Operation{
		Name:       opListGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupMembersInput{}
	}

	output = &ListGroupMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupMembers API operation for Amazon WorkMail.
//
// Returns an overview of the members of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListGroupMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers
func (c *WorkMail) ListGroupMembers(input *ListGroupMembersInput) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	return out, req.Send()
}

// ListGroupMembersWithContext is the same as ListGroupMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupMembersWithContext(ctx aws.Context, input *ListGroupMembersInput, opts ...request.Option) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupMembersPages iterates over the pages of a ListGroupMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupMembers operation.
//    pageNum := 0
//    err := client.ListGroupMembersPages(params,
//        func(page *ListGroupMembersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListGroupMembersPages(input *ListGroupMembersInput, fn func(*ListGroupMembersOutput, bool) bool) error {
	return c.ListGroupMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupMembersPagesWithContext same as ListGroupMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupMembersPagesWithContext(ctx aws.Context, input *ListGroupMembersInput, fn func(*ListGroupMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListGroupMembersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups
func (c *WorkMail) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for Amazon WorkMail.
//
// Returns summaries of the organization's groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups
func (c *WorkMail) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListMailboxPermissions = "ListMailboxPermissions"

// ListMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMailboxPermissions for more information on using the ListMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMailboxPermissionsRequest method.
//    req, resp := client.ListMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions
func (c *WorkMail) ListMailboxPermissionsRequest(input *ListMailboxPermissionsInput) (req *request.Request, output *ListMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opListMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMailboxPermissionsInput{}
	}

	output = &ListMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMailboxPermissions API operation for Amazon WorkMail.
//
// Lists the mailbox permissions associated with a mailbox.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListMailboxPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions
func (c *WorkMail) ListMailboxPermissions(input *ListMailboxPermissionsInput) (*ListMailboxPermissionsOutput, error) {
	req, out := c.ListMailboxPermissionsRequest(input)
	return out, req.Send()
}

// ListMailboxPermissionsWithContext is the same as ListMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxPermissionsWithContext(ctx aws.Context, input *ListMailboxPermissionsInput, opts ...request.Option) (*ListMailboxPermissionsOutput, error) {
	req, out := c.ListMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMailboxPermissionsPages iterates over the pages of a ListMailboxPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMailboxPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMailboxPermissions operation.
//    pageNum := 0
//    err := client.ListMailboxPermissionsPages(params,
//        func(page *ListMailboxPermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListMailboxPermissionsPages(input *ListMailboxPermissionsInput, fn func(*ListMailboxPermissionsOutput, bool) bool) error {
	return c.ListMailboxPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMailboxPermissionsPagesWithContext same as ListMailboxPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListMailboxPermissionsPagesWithContext(ctx aws.Context, input *ListMailboxPermissionsInput, fn func(*ListMailboxPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMailboxPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMailboxPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMailboxPermissionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListOrganizations = "ListOrganizations"

// ListOrganizationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOrganizations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOrganizations for more information on using the ListOrganizations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOrganizationsRequest method.
//    req, resp := client.ListOrganizationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations
func (c *WorkMail) ListOrganizationsRequest(input *ListOrganizationsInput) (req *request.Request, output *ListOrganizationsOutput) {
	op := &request.Operation{
		Name:       opListOrganizations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOrganizationsInput{}
	}

	output = &ListOrganizationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOrganizations API operation for Amazon WorkMail.
//
// Returns summaries of the customer's non-deleted organizations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListOrganizations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations
func (c *WorkMail) ListOrganizations(input *ListOrganizationsInput) (*ListOrganizationsOutput, error) {
	req, out := c.ListOrganizationsRequest(input)
	return out, req.Send()
}

// ListOrganizationsWithContext is the same as ListOrganizations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOrganizations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListOrganizationsWithContext(ctx aws.Context, input *ListOrganizationsInput, opts ...request.Option) (*ListOrganizationsOutput, error) {
	req, out := c.ListOrganizationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOrganizationsPages iterates over the pages of a ListOrganizations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOrganizations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOrganizations operation.
//    pageNum := 0
//    err := client.ListOrganizationsPages(params,
//        func(page *ListOrganizationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListOrganizationsPages(input *ListOrganizationsInput, fn func(*ListOrganizationsOutput, bool) bool) error {
	return c.ListOrganizationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOrganizationsPagesWithContext same as ListOrganizationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListOrganizationsPagesWithContext(ctx aws.Context, input *ListOrganizationsInput, fn func(*ListOrganizationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOrganizationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOrganizationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListOrganizationsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListResourceDelegates = "ListResourceDelegates"

// ListResourceDelegatesRequest generates a "aws/request.Request" representing the
// client's request for the ListResourceDelegates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourceDelegates for more information on using the ListResourceDelegates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourceDelegatesRequest method.
//    req, resp := client.ListResourceDelegatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates
func (c *WorkMail) ListResourceDelegatesRequest(input *ListResourceDelegatesInput) (req *request.Request, output *ListResourceDelegatesOutput) {
	op := &request.Operation{
		Name:       opListResourceDelegates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceDelegatesInput{}
	}

	output = &ListResourceDelegatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourceDelegates API operation for Amazon WorkMail.
//
// Lists the delegates associated with a resource. Users and groups can be resource
// delegates and answer requests on behalf of the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListResourceDelegates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates
func (c *WorkMail) ListResourceDelegates(input *ListResourceDelegatesInput) (*ListResourceDelegatesOutput, error) {
	req, out := c.ListResourceDelegatesRequest(input)
	return out, req.Send()
}

// ListResourceDelegatesWithContext is the same as ListResourceDelegates with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceDelegates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourceDelegatesWithContext(ctx aws.Context, input *ListResourceDelegatesInput, opts ...request.Option) (*ListResourceDelegatesOutput, error) {
	req, out := c.ListResourceDelegatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResources for more information on using the ListResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources
func (c *WorkMail) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for Amazon WorkMail.
//
// Returns summaries of the organization's resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources
func (c *WorkMail) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesPages iterates over the pages of a ListResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListResources operation.
//    pageNum := 0
//    err := client.ListResourcesPages(params,
//        func(page *ListResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListResourcesPages(input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool) error {
	return c.ListResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesPagesWithContext same as ListResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListResourcesPagesWithContext(ctx aws.Context, input *ListResourcesInput, fn func(*ListResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListResourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers
func (c *WorkMail) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon WorkMail.
//
// Returns summaries of the organization's users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers
func (c *WorkMail) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkMail) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListUsersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutMailboxPermissions = "PutMailboxPermissions"

// PutMailboxPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the PutMailboxPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMailboxPermissions for more information on using the PutMailboxPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMailboxPermissionsRequest method.
//    req, resp := client.PutMailboxPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions
func (c *WorkMail) PutMailboxPermissionsRequest(input *PutMailboxPermissionsInput) (req *request.Request, output *PutMailboxPermissionsOutput) {
	op := &request.Operation{
		Name:       opPutMailboxPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMailboxPermissionsInput{}
	}

	output = &PutMailboxPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutMailboxPermissions API operation for Amazon WorkMail.
//
// Sets permissions for a user or group. This replaces any pre-existing permissions
// set for the entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation PutMailboxPermissions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions
func (c *WorkMail) PutMailboxPermissions(input *PutMailboxPermissionsInput) (*PutMailboxPermissionsOutput, error) {
	req, out := c.PutMailboxPermissionsRequest(input)
	return out, req.Send()
}

// PutMailboxPermissionsWithContext is the same as PutMailboxPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See PutMailboxPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) PutMailboxPermissionsWithContext(ctx aws.Context, input *PutMailboxPermissionsInput, opts ...request.Option) (*PutMailboxPermissionsOutput, error) {
	req, out := c.PutMailboxPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterToWorkMail = "RegisterToWorkMail"

// RegisterToWorkMailRequest generates a "aws/request.Request" representing the
// client's request for the RegisterToWorkMail operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterToWorkMail for more information on using the RegisterToWorkMail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterToWorkMailRequest method.
//    req, resp := client.RegisterToWorkMailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail
func (c *WorkMail) RegisterToWorkMailRequest(input *RegisterToWorkMailInput) (req *request.Request, output *RegisterToWorkMailOutput) {
	op := &request.Operation{
		Name:       opRegisterToWorkMail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterToWorkMailInput{}
	}

	output = &RegisterToWorkMailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterToWorkMail API operation for Amazon WorkMail.
//
// Registers an existing and disabled user, group, or resource/entity for Amazon
// WorkMail use by associating a mailbox and calendaring capabilities. It performs
// no change if the entity is enabled and fails if the entity is deleted. This
// operation results in the accumulation of costs. For more information, see
// Pricing (http://aws.amazon.com/workmail/pricing). The equivalent console
// functionality for this operation is Enable. Users can either be created by
// calling the CreateUser API or they can be synchronized from your directory.
// For more information, see DeregisterFromWorkMail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation RegisterToWorkMail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEmailAddressInUseException "EmailAddressInUseException"
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeEntityAlreadyRegisteredException "EntityAlreadyRegisteredException"
//   The user, group, or resource that you're trying to register is already registered.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeMailDomainNotFoundException "MailDomainNotFoundException"
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * ErrCodeMailDomainStateException "MailDomainStateException"
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail
func (c *WorkMail) RegisterToWorkMail(input *RegisterToWorkMailInput) (*RegisterToWorkMailOutput, error) {
	req, out := c.RegisterToWorkMailRequest(input)
	return out, req.Send()
}

// RegisterToWorkMailWithContext is the same as RegisterToWorkMail with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterToWorkMail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) RegisterToWorkMailWithContext(ctx aws.Context, input *RegisterToWorkMailInput, opts ...request.Option) (*RegisterToWorkMailOutput, error) {
	req, out := c.RegisterToWorkMailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPassword = "ResetPassword"

// ResetPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ResetPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetPassword for more information on using the ResetPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetPasswordRequest method.
//    req, resp := client.ResetPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword
func (c *WorkMail) ResetPasswordRequest(input *ResetPasswordInput) (req *request.Request, output *ResetPasswordOutput) {
	op := &request.Operation{
		Name:       opResetPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetPasswordInput{}
	}

	output = &ResetPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetPassword API operation for Amazon WorkMail.
//
// Allows the administrator to reset the password for a user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation ResetPassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeInvalidPasswordException "InvalidPasswordException"
//   The supplied password doesn't match the minimum security constraints, such
//   as length or use of special characters.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword
func (c *WorkMail) ResetPassword(input *ResetPasswordInput) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	return out, req.Send()
}

// ResetPasswordWithContext is the same as ResetPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) ResetPasswordWithContext(ctx aws.Context, input *ResetPasswordInput, opts ...request.Option) (*ResetPasswordOutput, error) {
	req, out := c.ResetPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePrimaryEmailAddress = "UpdatePrimaryEmailAddress"

// UpdatePrimaryEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePrimaryEmailAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePrimaryEmailAddress for more information on using the UpdatePrimaryEmailAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePrimaryEmailAddressRequest method.
//    req, resp := client.UpdatePrimaryEmailAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress
func (c *WorkMail) UpdatePrimaryEmailAddressRequest(input *UpdatePrimaryEmailAddressInput) (req *request.Request, output *UpdatePrimaryEmailAddressOutput) {
	op := &request.Operation{
		Name:       opUpdatePrimaryEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePrimaryEmailAddressInput{}
	}

	output = &UpdatePrimaryEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePrimaryEmailAddress API operation for Amazon WorkMail.
//
// Updates the primary email for an entity. The current email is moved into
// the list of aliases (or swapped between an existing alias and the current
// primary email) and the email provided in the input is promoted as the primary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UpdatePrimaryEmailAddress for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryServiceAuthenticationFailedException "DirectoryServiceAuthenticationFailedException"
//   The Directory Service doesn't recognize the credentials supplied by the Amazon
//   WorkMail service.
//
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEmailAddressInUseException "EmailAddressInUseException"
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeMailDomainNotFoundException "MailDomainNotFoundException"
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * ErrCodeMailDomainStateException "MailDomainStateException"
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   One or more of the input parameters don't match the service's restrictions.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   You can't perform a write operation against a read-only directory.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress
func (c *WorkMail) UpdatePrimaryEmailAddress(input *UpdatePrimaryEmailAddressInput) (*UpdatePrimaryEmailAddressOutput, error) {
	req, out := c.UpdatePrimaryEmailAddressRequest(input)
	return out, req.Send()
}

// UpdatePrimaryEmailAddressWithContext is the same as UpdatePrimaryEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePrimaryEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UpdatePrimaryEmailAddressWithContext(ctx aws.Context, input *UpdatePrimaryEmailAddressInput, opts ...request.Option) (*UpdatePrimaryEmailAddressOutput, error) {
	req, out := c.UpdatePrimaryEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceRequest method.
//    req, resp := client.UpdateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource
func (c *WorkMail) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *UpdateResourceOutput) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &UpdateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResource API operation for Amazon WorkMail.
//
// Updates data for the resource. It must be preceded by a describe call in
// order to have the latest information. The dataset in the request should be
// the one expected when performing another describe call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkMail's
// API operation UpdateResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDirectoryUnavailableException "DirectoryUnavailableException"
//   The directory that you are trying to perform operations on isn't available.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   The identifier supplied for the entity is valid, but it does not exist in
//   your organization.
//
//   * ErrCodeEntityStateException "EntityStateException"
//   You are performing an operation on an entity that isn't in the expected state,
//   such as trying to update a deleted user.
//
//   * ErrCodeInvalidConfigurationException "InvalidConfigurationException"
//   The configuration for a resource isn't valid. A resource must either be able
//   to auto-respond to requests or have at least one delegate associated that
//   can do it on its behalf.
//
//   * ErrCodeEmailAddressInUseException "EmailAddressInUseException"
//   The email address that you're trying to assign is already created for a different
//   user, group, or resource.
//
//   * ErrCodeMailDomainNotFoundException "MailDomainNotFoundException"
//   For an email or alias to be created in Amazon WorkMail, the included domain
//   must be defined in the organization.
//
//   * ErrCodeMailDomainStateException "MailDomainStateException"
//   After a domain has been added to the organization, it must be verified. The
//   domain is not yet verified.
//
//   * ErrCodeNameAvailabilityException "NameAvailabilityException"
//   The entity (user, group, or user) name isn't unique in Amazon WorkMail.
//
//   * ErrCodeOrganizationNotFoundException "OrganizationNotFoundException"
//   An operation received a valid organization identifier that either doesn't
//   belong or exist in the system.
//
//   * ErrCodeOrganizationStateException "OrganizationStateException"
//   The organization must have a valid state (Active or Synchronizing) to perform
//   certain operations on the organization or its entities.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource
func (c *WorkMail) UpdateResource(input *UpdateResourceInput) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkMail) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*UpdateResourceOutput, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateDelegateToResourceInput struct {
	_ struct{} `type:"structure"`

	// The member (user or group) to associate to the resource.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization under which the resource exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The resource for which members are associated.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDelegateToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDelegateToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDelegateToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDelegateToResourceInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *AssociateDelegateToResourceInput) SetEntityId(v string) *AssociateDelegateToResourceInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AssociateDelegateToResourceInput) SetOrganizationId(v string) *AssociateDelegateToResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateDelegateToResourceInput) SetResourceId(v string) *AssociateDelegateToResourceInput {
	s.ResourceId = &v
	return s
}

type AssociateDelegateToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDelegateToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateDelegateToResourceOutput) GoString() string {
	return s.String()
}

type AssociateMemberToGroupInput struct {
	_ struct{} `type:"structure"`

	// The group for which the member is associated.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The member to associate to the group.
	//
	// MemberId is a required field
	MemberId *string `min:"12" type:"string" required:"true"`

	// The organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateMemberToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateMemberToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AssociateMemberToGroupInput) SetGroupId(v string) *AssociateMemberToGroupInput {
	s.GroupId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *AssociateMemberToGroupInput) SetMemberId(v string) *AssociateMemberToGroupInput {
	s.MemberId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *AssociateMemberToGroupInput) SetOrganizationId(v string) *AssociateMemberToGroupInput {
	s.OrganizationId = &v
	return s
}

type AssociateMemberToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateMemberToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateMemberToGroupOutput) GoString() string {
	return s.String()
}

// At least one delegate must be associated to the resource to disable automatic
// replies from the resource.
type BookingOptions struct {
	_ struct{} `type:"structure"`

	// The resource's ability to automatically reply to requests. If disabled, delegates
	// must be associated to the resource.
	AutoAcceptRequests *bool `type:"boolean"`

	// The resource's ability to automatically decline any conflicting requests.
	AutoDeclineConflictingRequests *bool `type:"boolean"`

	// The resource's ability to automatically decline any recurring requests.
	AutoDeclineRecurringRequests *bool `type:"boolean"`
}

// String returns the string representation
func (s BookingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BookingOptions) GoString() string {
	return s.String()
}

// SetAutoAcceptRequests sets the AutoAcceptRequests field's value.
func (s *BookingOptions) SetAutoAcceptRequests(v bool) *BookingOptions {
	s.AutoAcceptRequests = &v
	return s
}

// SetAutoDeclineConflictingRequests sets the AutoDeclineConflictingRequests field's value.
func (s *BookingOptions) SetAutoDeclineConflictingRequests(v bool) *BookingOptions {
	s.AutoDeclineConflictingRequests = &v
	return s
}

// SetAutoDeclineRecurringRequests sets the AutoDeclineRecurringRequests field's value.
func (s *BookingOptions) SetAutoDeclineRecurringRequests(v bool) *BookingOptions {
	s.AutoDeclineRecurringRequests = &v
	return s
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias to add to the user.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The alias is added to this Amazon WorkMail entity.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization under which the member exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasInput) SetAlias(v string) *CreateAliasInput {
	s.Alias = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *CreateAliasInput) SetEntityId(v string) *CreateAliasInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateAliasInput) SetOrganizationId(v string) *CreateAliasInput {
	s.OrganizationId = &v
	return s
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The organization under which the group is to be created.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateGroupInput) SetOrganizationId(v string) *CreateGroupInput {
	s.OrganizationId = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the group.
	GroupId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupOutput) SetGroupId(v string) *CreateGroupOutput {
	s.GroupId = &v
	return s
}

type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the created resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier associated with the organization for which the resource is
	// created.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The type of the created resource.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateResourceInput) SetName(v string) *CreateResourceInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateResourceInput) SetOrganizationId(v string) *CreateResourceInput {
	s.OrganizationId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateResourceInput) SetType(v string) *CreateResourceInput {
	s.Type = &v
	return s
}

type CreateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the created resource.
	ResourceId *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceOutput) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateResourceOutput) SetResourceId(v string) *CreateResourceOutput {
	s.ResourceId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The display name for the user to be created.
	//
	// DisplayName is a required field
	DisplayName *string `type:"string" required:"true"`

	// The name for the user to be created.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the organization for which the user is created.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The password for the user to be created.
	//
	// Password is a required field
	Password *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserInput) SetDisplayName(v string) *CreateUserInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUserInput) SetName(v string) *CreateUserInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *CreateUserInput) SetOrganizationId(v string) *CreateUserInput {
	s.OrganizationId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The information regarding the newly created user.
	UserId *string `min:"12" type:"string"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

// The name of the attribute, which is one of the values defined in the UserAttribute
// enumeration.
type Delegate struct {
	_ struct{} `type:"structure"`

	// The identifier for the user or group is associated as the resource's delegate.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The type of the delegate: user or group.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"MemberType"`
}

// String returns the string representation
func (s Delegate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delegate) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Delegate) SetId(v string) *Delegate {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *Delegate) SetType(v string) *Delegate {
	s.Type = &v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The aliases to be removed from the user's set of aliases. Duplicate entries
	// in the list are collapsed into single entries (the list is transformed into
	// a set).
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The identifier for the Amazon WorkMail entity to have the aliases removed.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the user exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *DeleteAliasInput) SetAlias(v string) *DeleteAliasInput {
	s.Alias = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *DeleteAliasInput) SetEntityId(v string) *DeleteAliasInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteAliasInput) SetOrganizationId(v string) *DeleteAliasInput {
	s.OrganizationId = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group to be deleted.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The organization that contains the group.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteGroupInput) SetGroupId(v string) *DeleteGroupInput {
	s.GroupId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteGroupInput) SetOrganizationId(v string) *DeleteGroupInput {
	s.OrganizationId = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

type DeleteMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entity (user or group) for which to delete mailbox
	// permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier of the entity (user or group) for which to delete granted
	// permissions.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The identifier of the organization under which the entity (user or group)
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.GranteeId == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteeId"))
	}
	if s.GranteeId != nil && len(*s.GranteeId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GranteeId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DeleteMailboxPermissionsInput) SetEntityId(v string) *DeleteMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetGranteeId sets the GranteeId field's value.
func (s *DeleteMailboxPermissionsInput) SetGranteeId(v string) *DeleteMailboxPermissionsInput {
	s.GranteeId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteMailboxPermissionsInput) SetOrganizationId(v string) *DeleteMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

type DeleteMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMailboxPermissionsOutput) GoString() string {
	return s.String()
}

type DeleteResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the organization for which the resource is
	// deleted.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource to be deleted.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteResourceInput) SetOrganizationId(v string) *DeleteResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteResourceInput) SetResourceId(v string) *DeleteResourceInput {
	s.ResourceId = &v
	return s
}

type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteResourceOutput) GoString() string {
	return s.String()
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The organization that contains the user.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the user to be deleted.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeleteUserInput) SetOrganizationId(v string) *DeleteUserInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DeleteUserInput) SetUserId(v string) *DeleteUserInput {
	s.UserId = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

type DeregisterFromWorkMailInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity to be updated.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the Amazon WorkMail entity
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterFromWorkMailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterFromWorkMailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterFromWorkMailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterFromWorkMailInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DeregisterFromWorkMailInput) SetEntityId(v string) *DeregisterFromWorkMailInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DeregisterFromWorkMailInput) SetOrganizationId(v string) *DeregisterFromWorkMailInput {
	s.OrganizationId = &v
	return s
}

type DeregisterFromWorkMailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterFromWorkMailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterFromWorkMailOutput) GoString() string {
	return s.String()
}

type DescribeGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group to be described.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupInput) SetGroupId(v string) *DescribeGroupInput {
	s.GroupId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeGroupInput) SetOrganizationId(v string) *DescribeGroupInput {
	s.OrganizationId = &v
	return s
}

type DescribeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when a user was deregistered from Amazon WorkMail, in UNIX
	// epoch time format.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The email of the described group.
	Email *string `min:"1" type:"string"`

	// The date and time when a user was registered to Amazon WorkMail, in UNIX
	// epoch time format.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the described group.
	GroupId *string `min:"12" type:"string"`

	// The name of the described group.
	Name *string `min:"1" type:"string"`

	// The state of the user: enabled (registered to Amazon WorkMail) or disabled
	// (deregistered or never registered to Amazon WorkMail).
	State *string `type:"string" enum:"EntityState"`
}

// String returns the string representation
func (s DescribeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGroupOutput) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeGroupOutput) SetDisabledDate(v time.Time) *DescribeGroupOutput {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeGroupOutput) SetEmail(v string) *DescribeGroupOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeGroupOutput) SetEnabledDate(v time.Time) *DescribeGroupOutput {
	s.EnabledDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *DescribeGroupOutput) SetGroupId(v string) *DescribeGroupOutput {
	s.GroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeGroupOutput) SetName(v string) *DescribeGroupOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeGroupOutput) SetState(v string) *DescribeGroupOutput {
	s.State = &v
	return s
}

type DescribeOrganizationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization to be described.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeOrganizationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOrganizationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeOrganizationInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeOrganizationInput) SetOrganizationId(v string) *DescribeOrganizationInput {
	s.OrganizationId = &v
	return s
}

type DescribeOrganizationOutput struct {
	_ struct{} `type:"structure"`

	// The alias for an organization.
	Alias *string `min:"1" type:"string"`

	// The date at which the organization became usable in the Amazon WorkMail context,
	// in UNIX epoch time format.
	CompletedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The default mail domain associated with the organization.
	DefaultMailDomain *string `type:"string"`

	// The identifier for the directory associated with an Amazon WorkMail organization.
	DirectoryId *string `type:"string"`

	// The type of directory associated with the Amazon WorkMail organization.
	DirectoryType *string `type:"string"`

	// The (optional) error message indicating if unexpected behavior was encountered
	// with regards to the organization.
	ErrorMessage *string `type:"string"`

	// The identifier of an organization.
	OrganizationId *string `type:"string"`

	// The state of an organization.
	State *string `type:"string"`
}

// String returns the string representation
func (s DescribeOrganizationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrganizationOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *DescribeOrganizationOutput) SetAlias(v string) *DescribeOrganizationOutput {
	s.Alias = &v
	return s
}

// SetCompletedDate sets the CompletedDate field's value.
func (s *DescribeOrganizationOutput) SetCompletedDate(v time.Time) *DescribeOrganizationOutput {
	s.CompletedDate = &v
	return s
}

// SetDefaultMailDomain sets the DefaultMailDomain field's value.
func (s *DescribeOrganizationOutput) SetDefaultMailDomain(v string) *DescribeOrganizationOutput {
	s.DefaultMailDomain = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeOrganizationOutput) SetDirectoryId(v string) *DescribeOrganizationOutput {
	s.DirectoryId = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *DescribeOrganizationOutput) SetDirectoryType(v string) *DescribeOrganizationOutput {
	s.DirectoryType = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeOrganizationOutput) SetErrorMessage(v string) *DescribeOrganizationOutput {
	s.ErrorMessage = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeOrganizationOutput) SetOrganizationId(v string) *DescribeOrganizationOutput {
	s.OrganizationId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeOrganizationOutput) SetState(v string) *DescribeOrganizationOutput {
	s.State = &v
	return s
}

type DescribeResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the organization for which the resource is
	// described.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource to be described.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeResourceInput) SetOrganizationId(v string) *DescribeResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeResourceInput) SetResourceId(v string) *DescribeResourceInput {
	s.ResourceId = &v
	return s
}

type DescribeResourceOutput struct {
	_ struct{} `type:"structure"`

	// The booking options for the described resource.
	BookingOptions *BookingOptions `type:"structure"`

	// The date and time when a resource was registered from Amazon WorkMail, in
	// UNIX epoch time format.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The email of the described resource.
	Email *string `min:"1" type:"string"`

	// The date and time when a resource was registered to Amazon WorkMail, in UNIX
	// epoch time format.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the described resource.
	Name *string `min:"1" type:"string"`

	// The identifier of the described resource.
	ResourceId *string `type:"string"`

	// The state of the resource: enabled (registered to Amazon WorkMail) or disabled
	// (deregistered or never registered to Amazon WorkMail).
	State *string `type:"string" enum:"EntityState"`

	// The type of the described resource.
	Type *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s DescribeResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceOutput) GoString() string {
	return s.String()
}

// SetBookingOptions sets the BookingOptions field's value.
func (s *DescribeResourceOutput) SetBookingOptions(v *BookingOptions) *DescribeResourceOutput {
	s.BookingOptions = v
	return s
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeResourceOutput) SetDisabledDate(v time.Time) *DescribeResourceOutput {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeResourceOutput) SetEmail(v string) *DescribeResourceOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeResourceOutput) SetEnabledDate(v time.Time) *DescribeResourceOutput {
	s.EnabledDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeResourceOutput) SetName(v string) *DescribeResourceOutput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeResourceOutput) SetResourceId(v string) *DescribeResourceOutput {
	s.ResourceId = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeResourceOutput) SetState(v string) *DescribeResourceOutput {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeResourceOutput) SetType(v string) *DescribeResourceOutput {
	s.Type = &v
	return s
}

type DescribeUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the organization under which the user exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier for the user to be described.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DescribeUserInput) SetOrganizationId(v string) *DescribeUserInput {
	s.OrganizationId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserInput) SetUserId(v string) *DescribeUserInput {
	s.UserId = &v
	return s
}

type DescribeUserOutput struct {
	_ struct{} `type:"structure"`

	// The date and time at which the user was disabled for Amazon WorkMail usage,
	// in UNIX epoch time format.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The display name of the user.
	DisplayName *string `type:"string"`

	// The email of the user.
	Email *string `min:"1" type:"string"`

	// The date and time at which the user was enabled for Amazon WorkMail usage,
	// in UNIX epoch time format.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name for the user.
	Name *string `min:"1" type:"string"`

	// The state of a user: enabled (registered to Amazon WorkMail) or disabled
	// (deregistered or never registered to Amazon WorkMail).
	State *string `type:"string" enum:"EntityState"`

	// The identifier for the described user.
	UserId *string `min:"12" type:"string"`

	// In certain cases other entities are modeled as users. If interoperability
	// is enabled, resources are imported into Amazon WorkMail as users. Because
	// different Amazon WorkMail organizations rely on different directory types,
	// administrators can distinguish between a user that is not registered to Amazon
	// WorkMail (is disabled and has a user role) and the administrative users of
	// the directory. The values are USER, RESOURCE, and SYSTEM_USER.
	UserRole *string `type:"string" enum:"UserRole"`
}

// String returns the string representation
func (s DescribeUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserOutput) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *DescribeUserOutput) SetDisabledDate(v time.Time) *DescribeUserOutput {
	s.DisabledDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeUserOutput) SetDisplayName(v string) *DescribeUserOutput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *DescribeUserOutput) SetEmail(v string) *DescribeUserOutput {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *DescribeUserOutput) SetEnabledDate(v time.Time) *DescribeUserOutput {
	s.EnabledDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeUserOutput) SetName(v string) *DescribeUserOutput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeUserOutput) SetState(v string) *DescribeUserOutput {
	s.State = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DescribeUserOutput) SetUserId(v string) *DescribeUserOutput {
	s.UserId = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *DescribeUserOutput) SetUserRole(v string) *DescribeUserOutput {
	s.UserRole = &v
	return s
}

type DisassociateDelegateFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the member (user, group) to be removed from the resource's
	// delegates.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the resource exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource from which delegates' set members are removed.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateDelegateFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDelegateFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDelegateFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDelegateFromResourceInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *DisassociateDelegateFromResourceInput) SetEntityId(v string) *DisassociateDelegateFromResourceInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DisassociateDelegateFromResourceInput) SetOrganizationId(v string) *DisassociateDelegateFromResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DisassociateDelegateFromResourceInput) SetResourceId(v string) *DisassociateDelegateFromResourceInput {
	s.ResourceId = &v
	return s
}

type DisassociateDelegateFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateDelegateFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateDelegateFromResourceOutput) GoString() string {
	return s.String()
}

type DisassociateMemberFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group from which members are removed.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The identifier for the member to be removed to the group.
	//
	// MemberId is a required field
	MemberId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMemberFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DisassociateMemberFromGroupInput) SetGroupId(v string) *DisassociateMemberFromGroupInput {
	s.GroupId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *DisassociateMemberFromGroupInput) SetMemberId(v string) *DisassociateMemberFromGroupInput {
	s.MemberId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *DisassociateMemberFromGroupInput) SetOrganizationId(v string) *DisassociateMemberFromGroupInput {
	s.OrganizationId = &v
	return s
}

type DisassociateMemberFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMemberFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateMemberFromGroupOutput) GoString() string {
	return s.String()
}

// The representation of an Amazon WorkMail group.
type Group struct {
	_ struct{} `type:"structure"`

	// The date indicating when the group was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The email of the group.
	Email *string `min:"1" type:"string"`

	// The date indicating when the group was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the group.
	Id *string `min:"12" type:"string"`

	// The name of the group.
	Name *string `min:"1" type:"string"`

	// The state of the group, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Group) SetDisabledDate(v time.Time) *Group {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Group) SetEmail(v string) *Group {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Group) SetEnabledDate(v time.Time) *Group {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Group) SetId(v string) *Group {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Group) SetName(v string) *Group {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Group) SetState(v string) *Group {
	s.State = &v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity for which to list the aliases.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the entity exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *ListAliasesInput) SetEntityId(v string) *ListAliasesInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAliasesInput) SetMaxResults(v int64) *ListAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesInput) SetNextToken(v string) *ListAliasesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListAliasesInput) SetOrganizationId(v string) *ListAliasesInput {
	s.OrganizationId = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// The entity's paginated aliases.
	Aliases []*string `type:"list"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*string) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAliasesOutput) SetNextToken(v string) *ListAliasesOutput {
	s.NextToken = &v
	return s
}

type ListGroupMembersInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the group to which the members are associated.
	//
	// GroupId is a required field
	GroupId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the group exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembersInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupMembersInput) SetGroupId(v string) *ListGroupMembersInput {
	s.GroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupMembersInput) SetMaxResults(v int64) *ListGroupMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembersInput) SetNextToken(v string) *ListGroupMembersInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListGroupMembersInput) SetOrganizationId(v string) *ListGroupMembersInput {
	s.OrganizationId = &v
	return s
}

type ListGroupMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members associated to the group.
	Members []*Member `type:"list"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListGroupMembersOutput) SetMembers(v []*Member) *ListGroupMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupMembersOutput) SetNextToken(v string) *ListGroupMembersOutput {
	s.NextToken = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the groups exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListGroupsInput) SetOrganizationId(v string) *ListGroupsInput {
	s.OrganizationId = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The overview of groups for an organization.
	Groups []*Group `type:"list"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

type ListMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entity (user or group) for which to list mailbox permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the organization under which the entity (user or group)
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *ListMailboxPermissionsInput) SetEntityId(v string) *ListMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMailboxPermissionsInput) SetMaxResults(v int64) *ListMailboxPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxPermissionsInput) SetNextToken(v string) *ListMailboxPermissionsInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListMailboxPermissionsInput) SetOrganizationId(v string) *ListMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

type ListMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// One page of the entity's mailbox permissions.
	Permissions []*Permission `type:"list"`
}

// String returns the string representation
func (s ListMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMailboxPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMailboxPermissionsOutput) SetNextToken(v string) *ListMailboxPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListMailboxPermissionsOutput) SetPermissions(v []*Permission) *ListMailboxPermissionsOutput {
	s.Permissions = v
	return s
}

type ListOrganizationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListOrganizationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOrganizationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOrganizationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOrganizationsInput) SetMaxResults(v int64) *ListOrganizationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationsInput) SetNextToken(v string) *ListOrganizationsInput {
	s.NextToken = &v
	return s
}

type ListOrganizationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. The value is "null"
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The overview of owned organizations presented as a list of organization summaries.
	OrganizationSummaries []*OrganizationSummary `type:"list"`
}

// String returns the string representation
func (s ListOrganizationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOrganizationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOrganizationsOutput) SetNextToken(v string) *ListOrganizationsOutput {
	s.NextToken = &v
	return s
}

// SetOrganizationSummaries sets the OrganizationSummaries field's value.
func (s *ListOrganizationsOutput) SetOrganizationSummaries(v []*OrganizationSummary) *ListOrganizationsOutput {
	s.OrganizationSummaries = v
	return s
}

type ListResourceDelegatesInput struct {
	_ struct{} `type:"structure"`

	// The number of maximum results in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate through the delegates associated with a resource.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization that contains the resource for which
	// delegates are listed.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier for the resource whose delegates are listed.
	//
	// ResourceId is a required field
	ResourceId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceDelegatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDelegatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDelegatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceDelegatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourceDelegatesInput) SetMaxResults(v int64) *ListResourceDelegatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDelegatesInput) SetNextToken(v string) *ListResourceDelegatesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListResourceDelegatesInput) SetOrganizationId(v string) *ListResourceDelegatesInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListResourceDelegatesInput) SetResourceId(v string) *ListResourceDelegatesInput {
	s.ResourceId = &v
	return s
}

type ListResourceDelegatesOutput struct {
	_ struct{} `type:"structure"`

	// One page of the resource's delegates.
	Delegates []*Delegate `type:"list"`

	// The token used to paginate through the delegates associated with a resource.
	// While results are still available, it has an associated value. When the last
	// page is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListResourceDelegatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceDelegatesOutput) GoString() string {
	return s.String()
}

// SetDelegates sets the Delegates field's value.
func (s *ListResourceDelegatesOutput) SetDelegates(v []*Delegate) *ListResourceDelegatesOutput {
	s.Delegates = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourceDelegatesOutput) SetNextToken(v string) *ListResourceDelegatesOutput {
	s.NextToken = &v
	return s
}

type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to retrieve the next page of results. The first call does
	// not contain any tokens.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the resources exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListResourcesInput) SetOrganizationId(v string) *ListResourcesInput {
	s.OrganizationId = &v
	return s
}

type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token used to paginate through all the organization's resources. While
	// results are still available, it has an associated value. When the last page
	// is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`

	// One page of the organization's resource representation.
	Resources []*Resource `type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// TBD
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization under which the users exist.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ListUsersInput) SetOrganizationId(v string) *ListUsersInput {
	s.OrganizationId = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is `null`
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// The overview of users for an organization.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

// The representation of a group member (user or group).
type Member struct {
	_ struct{} `type:"structure"`

	// The date indicating when the member was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date indicating when the member was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the member.
	Id *string `type:"string"`

	// The name of the member.
	Name *string `type:"string"`

	// The state of the member, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// A member can be a user or group.
	Type *string `type:"string" enum:"MemberType"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Member) SetDisabledDate(v time.Time) *Member {
	s.DisabledDate = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Member) SetEnabledDate(v time.Time) *Member {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Member) SetId(v string) *Member {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Member) SetName(v string) *Member {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Member) SetState(v string) *Member {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Member) SetType(v string) *Member {
	s.Type = &v
	return s
}

// The brief overview associated with an organization.
type OrganizationSummary struct {
	_ struct{} `type:"structure"`

	// The alias associated with the organization.
	Alias *string `min:"1" type:"string"`

	// The error message associated with the organization. It is only present if
	// unexpected behavior has occurred with regards to the organization. It provides
	// insight or solutions regarding unexpected behavior.
	ErrorMessage *string `type:"string"`

	// The identifier associated with the organization.
	OrganizationId *string `type:"string"`

	// The state associated with the organization.
	State *string `type:"string"`
}

// String returns the string representation
func (s OrganizationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationSummary) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *OrganizationSummary) SetAlias(v string) *OrganizationSummary {
	s.Alias = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *OrganizationSummary) SetErrorMessage(v string) *OrganizationSummary {
	s.ErrorMessage = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *OrganizationSummary) SetOrganizationId(v string) *OrganizationSummary {
	s.OrganizationId = &v
	return s
}

// SetState sets the State field's value.
func (s *OrganizationSummary) SetState(v string) *OrganizationSummary {
	s.State = &v
	return s
}

// Permission granted to an entity (user, group) to access a certain aspect
// of another entity's mailbox.
type Permission struct {
	_ struct{} `type:"structure"`

	// The identifier of the entity (user or group) to which the permissions are
	// granted.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The type of entity (user, group) of the entity referred to in GranteeId.
	//
	// GranteeType is a required field
	GranteeType *string `type:"string" required:"true" enum:"MemberType"`

	// The permissions granted to the grantee. SEND_AS allows the grantee to send
	// email as the owner of the mailbox (the grantee is not mentioned on these
	// emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the
	// owner of the mailbox (the grantee is not mentioned as the physical sender
	// of these emails). FULL_ACCESS allows the grantee full access to the mailbox,
	// irrespective of other folder-level permissions set on the mailbox.
	//
	// PermissionValues is a required field
	PermissionValues []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// SetGranteeId sets the GranteeId field's value.
func (s *Permission) SetGranteeId(v string) *Permission {
	s.GranteeId = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *Permission) SetGranteeType(v string) *Permission {
	s.GranteeType = &v
	return s
}

// SetPermissionValues sets the PermissionValues field's value.
func (s *Permission) SetPermissionValues(v []*string) *Permission {
	s.PermissionValues = v
	return s
}

type PutMailboxPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entity (user or group) for which to update mailbox
	// permissions.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier of the entity (user or group) to which to grant the permissions.
	//
	// GranteeId is a required field
	GranteeId *string `min:"12" type:"string" required:"true"`

	// The identifier of the organization under which the entity (user or group)
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The permissions granted to the grantee. SEND_AS allows the grantee to send
	// email as the owner of the mailbox (the grantee is not mentioned on these
	// emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the
	// owner of the mailbox (the grantee is not mentioned as the physical sender
	// of these emails). FULL_ACCESS allows the grantee full access to the mailbox,
	// irrespective of other folder-level permissions set on the mailbox.
	//
	// PermissionValues is a required field
	PermissionValues []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s PutMailboxPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMailboxPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMailboxPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMailboxPermissionsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.GranteeId == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteeId"))
	}
	if s.GranteeId != nil && len(*s.GranteeId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("GranteeId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.PermissionValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *PutMailboxPermissionsInput) SetEntityId(v string) *PutMailboxPermissionsInput {
	s.EntityId = &v
	return s
}

// SetGranteeId sets the GranteeId field's value.
func (s *PutMailboxPermissionsInput) SetGranteeId(v string) *PutMailboxPermissionsInput {
	s.GranteeId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *PutMailboxPermissionsInput) SetOrganizationId(v string) *PutMailboxPermissionsInput {
	s.OrganizationId = &v
	return s
}

// SetPermissionValues sets the PermissionValues field's value.
func (s *PutMailboxPermissionsInput) SetPermissionValues(v []*string) *PutMailboxPermissionsInput {
	s.PermissionValues = v
	return s
}

type PutMailboxPermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMailboxPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutMailboxPermissionsOutput) GoString() string {
	return s.String()
}

type RegisterToWorkMailInput struct {
	_ struct{} `type:"structure"`

	// The email for the entity to be updated.
	//
	// Email is a required field
	Email *string `min:"1" type:"string" required:"true"`

	// The identifier for the entity to be updated.
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The identifier for the organization under which the Amazon WorkMail entity
	// exists.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterToWorkMailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterToWorkMailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterToWorkMailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterToWorkMailInput"}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *RegisterToWorkMailInput) SetEmail(v string) *RegisterToWorkMailInput {
	s.Email = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *RegisterToWorkMailInput) SetEntityId(v string) *RegisterToWorkMailInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *RegisterToWorkMailInput) SetOrganizationId(v string) *RegisterToWorkMailInput {
	s.OrganizationId = &v
	return s
}

type RegisterToWorkMailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterToWorkMailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterToWorkMailOutput) GoString() string {
	return s.String()
}

type ResetPasswordInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the organization that contains the user for which the password
	// is reset.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The new password for the user.
	//
	// Password is a required field
	Password *string `type:"string" required:"true"`

	// The identifier of the user for whom the password is reset.
	//
	// UserId is a required field
	UserId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetPasswordInput"}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *ResetPasswordInput) SetOrganizationId(v string) *ResetPasswordInput {
	s.OrganizationId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ResetPasswordInput) SetPassword(v string) *ResetPasswordInput {
	s.Password = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResetPasswordInput) SetUserId(v string) *ResetPasswordInput {
	s.UserId = &v
	return s
}

type ResetPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPasswordOutput) GoString() string {
	return s.String()
}

// The overview for a resource containing relevant data regarding it.
type Resource struct {
	_ struct{} `type:"structure"`

	// The date indicating when the resource was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The email of the resource.
	Email *string `min:"1" type:"string"`

	// The date indicating when the resource was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the resource.
	Id *string `min:"12" type:"string"`

	// The name of the resource.
	Name *string `min:"1" type:"string"`

	// The state of the resource, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// The type of the resource: equipment or room.
	Type *string `type:"string" enum:"ResourceType"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *Resource) SetDisabledDate(v time.Time) *Resource {
	s.DisabledDate = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Resource) SetEmail(v string) *Resource {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *Resource) SetEnabledDate(v time.Time) *Resource {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *Resource) SetState(v string) *Resource {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Resource) SetType(v string) *Resource {
	s.Type = &v
	return s
}

type UpdatePrimaryEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// The value of the email to be updated as primary.
	//
	// Email is a required field
	Email *string `min:"1" type:"string" required:"true"`

	// The entity to update (user, group, or resource).
	//
	// EntityId is a required field
	EntityId *string `min:"12" type:"string" required:"true"`

	// The organization that contains the entity to update.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePrimaryEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePrimaryEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePrimaryEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePrimaryEmailAddressInput"}
	if s.Email == nil {
		invalidParams.Add(request.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Email", 1))
	}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.EntityId != nil && len(*s.EntityId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("EntityId", 12))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmail sets the Email field's value.
func (s *UpdatePrimaryEmailAddressInput) SetEmail(v string) *UpdatePrimaryEmailAddressInput {
	s.Email = &v
	return s
}

// SetEntityId sets the EntityId field's value.
func (s *UpdatePrimaryEmailAddressInput) SetEntityId(v string) *UpdatePrimaryEmailAddressInput {
	s.EntityId = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *UpdatePrimaryEmailAddressInput) SetOrganizationId(v string) *UpdatePrimaryEmailAddressInput {
	s.OrganizationId = &v
	return s
}

type UpdatePrimaryEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePrimaryEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePrimaryEmailAddressOutput) GoString() string {
	return s.String()
}

type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource's booking options to be updated.
	BookingOptions *BookingOptions `type:"structure"`

	// The name of the resource to be updated.
	Name *string `min:"1" type:"string"`

	// The identifier associated with the organization for which the resource is
	// updated.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier of the resource to be updated.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OrganizationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationId"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBookingOptions sets the BookingOptions field's value.
func (s *UpdateResourceInput) SetBookingOptions(v *BookingOptions) *UpdateResourceInput {
	s.BookingOptions = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceInput) SetName(v string) *UpdateResourceInput {
	s.Name = &v
	return s
}

// SetOrganizationId sets the OrganizationId field's value.
func (s *UpdateResourceInput) SetOrganizationId(v string) *UpdateResourceInput {
	s.OrganizationId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateResourceInput) SetResourceId(v string) *UpdateResourceInput {
	s.ResourceId = &v
	return s
}

type UpdateResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceOutput) GoString() string {
	return s.String()
}

// The representation of an Amazon WorkMail user.
type User struct {
	_ struct{} `type:"structure"`

	// The date indicating when the user was disabled from Amazon WorkMail use.
	DisabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The display name of the user.
	DisplayName *string `type:"string"`

	// The email of the user.
	Email *string `min:"1" type:"string"`

	// The date indicating when the user was enabled for Amazon WorkMail use.
	EnabledDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier of the user.
	Id *string `min:"12" type:"string"`

	// The name of the user.
	Name *string `min:"1" type:"string"`

	// The state of the user, which can be ENABLED, DISABLED, or DELETED.
	State *string `type:"string" enum:"EntityState"`

	// The role of the user.
	UserRole *string `type:"string" enum:"UserRole"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetDisabledDate sets the DisabledDate field's value.
func (s *User) SetDisabledDate(v time.Time) *User {
	s.DisabledDate = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *User) SetDisplayName(v string) *User {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *User) SetEmail(v string) *User {
	s.Email = &v
	return s
}

// SetEnabledDate sets the EnabledDate field's value.
func (s *User) SetEnabledDate(v time.Time) *User {
	s.EnabledDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *User) SetId(v string) *User {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *User) SetName(v string) *User {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *User) SetState(v string) *User {
	s.State = &v
	return s
}

// SetUserRole sets the UserRole field's value.
func (s *User) SetUserRole(v string) *User {
	s.UserRole = &v
	return s
}

const (
	// EntityStateEnabled is a EntityState enum value
	EntityStateEnabled = "ENABLED"

	// EntityStateDisabled is a EntityState enum value
	EntityStateDisabled = "DISABLED"

	// EntityStateDeleted is a EntityState enum value
	EntityStateDeleted = "DELETED"
)

const (
	// MemberTypeGroup is a MemberType enum value
	MemberTypeGroup = "GROUP"

	// MemberTypeUser is a MemberType enum value
	MemberTypeUser = "USER"
)

const (
	// PermissionTypeFullAccess is a PermissionType enum value
	PermissionTypeFullAccess = "FULL_ACCESS"

	// PermissionTypeSendAs is a PermissionType enum value
	PermissionTypeSendAs = "SEND_AS"

	// PermissionTypeSendOnBehalf is a PermissionType enum value
	PermissionTypeSendOnBehalf = "SEND_ON_BEHALF"
)

const (
	// ResourceTypeRoom is a ResourceType enum value
	ResourceTypeRoom = "ROOM"

	// ResourceTypeEquipment is a ResourceType enum value
	ResourceTypeEquipment = "EQUIPMENT"
)

const (
	// UserRoleUser is a UserRole enum value
	UserRoleUser = "USER"

	// UserRoleResource is a UserRole enum value
	UserRoleResource = "RESOURCE"

	// UserRoleSystemUser is a UserRole enum value
	UserRoleSystemUser = "SYSTEM_USER"
)
