/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.id;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
@ThreadSafe
public class ConfigurationCacheableIdFactory {
    private static final long USED_ASSIGNED_ID_MARKER = -1L;
    private final AtomicLong sequence = new AtomicLong(0L);

    public long createId() {
        long newId = this.sequence.updateAndGet(it -> it == -1L ? it : it + 1L);
        if (newId == -1L) {
            throw new IllegalStateException("Cannot create a new id after one has been loaded");
        }
        return newId;
    }

    public void idRecreated() {
        this.sequence.set(-1L);
    }
}

