//! Autogenerated by GenerateDef from src/aro/Attribute/names.def, do not edit
// zig fmt: off

const std = @import("std");

pub fn with(comptime Properties: type) type {
return struct {

tag: Tag,
properties: Properties,

/// Integer starting at 0 derived from the unique index,
/// corresponds with the data array index.
pub const Tag = enum(u16) { _ };

const Self = @This();

pub fn fromName(name: []const u8) ?@This() {
    const data_index = tagFromName(name) orelse return null;
    return data[@intFromEnum(data_index)];
}

pub fn tagFromName(name: []const u8) ?Tag {
    const unique_index = uniqueIndex(name) orelse return null;
    return @enumFromInt(unique_index - 1);
}

pub fn fromTag(tag: Tag) @This() {
    return data[@intFromEnum(tag)];
}

pub fn nameFromTagIntoBuf(tag: Tag, name_buf: []u8) []u8 {
    std.debug.assert(name_buf.len >= longest_name);
    const unique_index = @intFromEnum(tag) + 1;
    return nameFromUniqueIndex(unique_index, name_buf);
}

pub fn nameFromTag(tag: Tag) NameBuf {
    var name_buf: NameBuf = undefined;
    const unique_index = @intFromEnum(tag) + 1;
    const name = nameFromUniqueIndex(unique_index, &name_buf.buf);
    name_buf.len = @intCast(name.len);
    return name_buf;
}

pub const NameBuf = struct {
    buf: [longest_name]u8 = undefined,
    len: std.math.IntFittingRange(0, longest_name),

    pub fn span(self: *const NameBuf) []const u8 {
        return self.buf[0..self.len];
    }
};

pub fn exists(name: []const u8) bool {
    if (name.len < shortest_name or name.len > longest_name) return false;

    var index: u16 = 0;
    for (name) |c| {
        index = findInList(dafsa[index].child_index, c) orelse return false;
    }
    return dafsa[index].end_of_word;
}

pub const shortest_name = 3;
pub const longest_name = 30;

/// Search siblings of `first_child_index` for the `char`
/// If found, returns the index of the node within the `dafsa` array.
/// Otherwise, returns `null`.
pub fn findInList(first_child_index: u16, char: u8) ?u16 {
    var index = first_child_index;
    while (true) {
        if (dafsa[index].char == char) return index;
        if (dafsa[index].end_of_list) return null;
        index += 1;
    }
    unreachable;
}

/// Returns a unique (minimal perfect hash) index (starting at 1) for the `name`,
/// or null if the name was not found.
pub fn uniqueIndex(name: []const u8) ?u16 {
    if (name.len < shortest_name or name.len > longest_name) return null;

    var index: u16 = 0;
    var node_index: u16 = 0;

    for (name) |c| {
        const child_index = findInList(dafsa[node_index].child_index, c) orelse return null;
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            const sibling_c = dafsa[sibling_index].char;
            std.debug.assert(sibling_c != 0);
            if (sibling_c < c) {
                index += dafsa[sibling_index].number;
            }
            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        node_index = child_index;
        if (dafsa[node_index].end_of_word) index += 1;
    }

    if (!dafsa[node_index].end_of_word) return null;

    return index;
}

/// Returns a slice of `buf` with the name associated with the given `index`.
/// This function should only be called with an `index` that
/// is already known to exist within the `dafsa`, e.g. an index
/// returned from `uniqueIndex`.
pub fn nameFromUniqueIndex(index: u16, buf: []u8) []u8 {
    std.debug.assert(index >= 1 and index <= data.len);

    var node_index: u16 = 0;
    var count: u16 = index;
    var fbs = std.io.fixedBufferStream(buf);
    const w = fbs.writer();

    while (true) {
        var sibling_index = dafsa[node_index].child_index;
        while (true) {
            if (dafsa[sibling_index].number > 0 and dafsa[sibling_index].number < count) {
                count -= dafsa[sibling_index].number;
            } else {
                w.writeByte(dafsa[sibling_index].char) catch unreachable;
                node_index = sibling_index;
                if (dafsa[node_index].end_of_word) {
                    count -= 1;
                }
                break;
            }

            if (dafsa[sibling_index].end_of_list) break;
            sibling_index += 1;
        }
        if (count == 0) break;
    }

    return fbs.getWritten();
}

const Node = packed struct(u32) {
    char: u8,
    /// Nodes are numbered with "an integer which gives the number of words that
    /// would be accepted by the automaton starting from that state." This numbering
    /// allows calculating "a one-to-one correspondence between the integers 1 to L
    /// (L is the number of words accepted by the automaton) and the words themselves."
    ///
    /// Essentially, this allows us to have a minimal perfect hashing scheme such that
    /// it's possible to store & lookup the properties of each name using a separate array.
    number: u8,
    /// If true, this node is the end of a valid name.
    /// Note: This does not necessarily mean that this node does not have child nodes.
    end_of_word: bool,
    /// If true, this node is the end of a sibling list.
    /// If false, then (index + 1) will contain the next sibling.
    end_of_list: bool,
    /// Index of the first child of this node.
    child_index: u14,
};

const dafsa = [_]Node{
    .{ .char = 0, .end_of_word = false, .end_of_list = true, .number = 0, .child_index = 1 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 12, .child_index = 21 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 7, .child_index = 26 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 28 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 30 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 32 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 35 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 36 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 37 },
    .{ .char = 'j', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 39 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 40 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 41 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 24, .child_index = 43 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 45 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 49 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 9, .child_index = 50 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 57 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = false, .number = 6, .child_index = 61 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 64 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 66 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 68 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 69 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 8, .child_index = 70 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 73 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 74 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 75 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 76 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 6, .child_index = 77 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 82 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 84 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 85 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 86 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 87 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 88 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 89 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 90 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 92 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 93 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 94 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 95 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 96 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 98 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 99 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 23, .child_index = 100 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 108 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 110 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 111 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 112 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 113 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 116 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 117 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 118 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 121 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 122 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 123 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 124 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 125 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 126 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 127 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 128 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 129 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 133 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 134 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 135 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 136 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 137 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 138 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 139 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 140 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 141 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 4, .child_index = 143 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 144 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 145 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 146 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 147 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 148 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 149 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 150 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 151 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 152 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 154 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 155 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 157 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 159 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 160 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 161 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 162 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 163 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 164 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 165 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 166 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 167 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 169 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 170 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 13, .child_index = 173 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 178 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 179 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 181 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 3, .child_index = 182 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 184 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 185 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 186 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 99 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 187 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 188 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 69 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 189 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 190 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 191 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 193 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 194 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 195 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 196 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 197 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 198 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 199 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 200 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 201 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 202 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 203 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 204 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 205 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 206 },
    .{ .char = 's', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 207 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 208 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 209 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 210 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 211 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 212 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 213 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 214 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 215 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 216 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 217 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 218 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 219 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 220 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 221 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 222 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 223 },
    .{ .char = 'd', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 225 },
    .{ .char = 'y', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 226 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 227 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 228 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 229 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 230 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 232 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 233 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 234 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 235 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 236 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 237 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 238 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 239 },
    .{ .char = 'f', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 240 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 241 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 242 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 243 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 244 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 246 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 247 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 8, .child_index = 248 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 251 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 252 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 253 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 254 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 255 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 257 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 258 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 259 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 260 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 261 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 262 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 263 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 264 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 265 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 266 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 267 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 268 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 269 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 270 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 271 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 272 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 273 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 274 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 275 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 276 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 277 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 278 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 279 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 280 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 281 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 282 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 3, .child_index = 283 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 285 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 286 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 's', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 287 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 288 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 290 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 291 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 292 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 293 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 294 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 295 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 297 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 298 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 299 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 300 },
    .{ .char = 'x', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 301 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 301 },
    .{ .char = 'r', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 302 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 303 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 304 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 305 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 306 },
    .{ .char = 'c', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 307 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 308 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 237 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 178 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 309 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 310 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 168 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 312 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 5, .child_index = 314 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 315 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 316 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 317 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 318 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 151 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 319 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 91 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 320 },
    .{ .char = 'a', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 321 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 322 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 323 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 324 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 325 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 326 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 327 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 328 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 329 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 224 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 330 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 331 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 112 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 332 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 333 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 334 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 335 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 336 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 337 },
    .{ .char = 'q', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 338 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 339 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 340 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 341 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 343 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 344 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 345 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = '_', .end_of_word = false, .end_of_list = false, .number = 2, .child_index = 346 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 348 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 164 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 349 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 350 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 351 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 352 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 353 },
    .{ .char = 'n', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 300 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 354 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 355 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 357 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 358 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 359 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 360 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 361 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 362 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 363 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 364 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 365 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 366 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 367 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 368 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 369 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 370 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 371 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 372 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 318 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 373 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 374 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 375 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 376 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 377 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 378 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 379 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 380 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 381 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 382 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 384 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 385 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 386 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 387 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 388 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 389 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 390 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 391 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 392 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 393 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 394 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 168 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 396 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 397 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 399 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 264 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 401 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 402 },
    .{ .char = 'p', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 403 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 404 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 405 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 406 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 407 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 408 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 409 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 320 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 410 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 411 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 412 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 413 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 414 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 415 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 416 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 417 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 418 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 419 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 420 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 343 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 421 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 422 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 423 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 424 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 425 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 426 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 427 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 428 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 429 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 430 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 383 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 431 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 432 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 433 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 434 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 435 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 436 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 437 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 438 },
    .{ .char = 'g', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 439 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 440 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 441 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = false, .number = 1, .child_index = 0 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 231 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 442 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 443 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 444 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 159 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 445 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 446 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 447 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 448 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 449 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 450 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 451 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 452 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 453 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 273 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 454 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 455 },
    .{ .char = 'k', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 456 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 150 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 457 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 458 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 459 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 460 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 462 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 463 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 'l', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 464 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 465 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 466 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 467 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 468 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 469 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 398 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 470 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 471 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 472 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 473 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 474 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 428 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 475 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 476 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 477 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 478 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 395 },
    .{ .char = 't', .end_of_word = true, .end_of_list = true, .number = 2, .child_index = 479 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 480 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 208 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 481 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 482 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 483 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 484 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 485 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 2, .child_index = 486 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 488 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 467 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 489 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 490 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 491 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 492 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 493 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 494 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 495 },
    .{ .char = 'b', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 496 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 497 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 498 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 499 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 500 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 296 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 501 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 502 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 503 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 504 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 505 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 506 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 507 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 508 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 509 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 5, .child_index = 510 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 511 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 512 },
    .{ .char = 'p', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 513 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 514 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 515 },
    .{ .char = 'w', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 516 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 517 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 518 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 519 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 520 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 521 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 522 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 523 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 524 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 525 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 526 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 527 },
    .{ .char = 'h', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 528 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 237 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 529 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 530 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 531 },
    .{ .char = 'e', .end_of_word = true, .end_of_list = true, .number = 5, .child_index = 532 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 533 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 534 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 535 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 536 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 537 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 538 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 539 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 378 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 540 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 541 },
    .{ .char = 'z', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 351 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 542 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 543 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 133 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 544 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 545 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 546 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 547 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 548 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 549 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 4, .child_index = 550 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 554 },
    .{ .char = 'm', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 555 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 556 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 557 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 558 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 559 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 560 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 561 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 562 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 555 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 563 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 564 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 565 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 566 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 311 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 567 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 568 },
    .{ .char = 't', .end_of_word = false, .end_of_list = false, .number = 1, .child_index = 569 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 570 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 571 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 91 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 572 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 573 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 574 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 575 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 576 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 577 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 578 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 459 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 579 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 580 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 581 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 582 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 583 },
    .{ .char = 'h', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 126 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 584 },
    .{ .char = 'k', .end_of_word = true, .end_of_list = true, .number = 1, .child_index = 0 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 356 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 585 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 428 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 586 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 268 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 587 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 588 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 273 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 589 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 590 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 591 },
    .{ .char = 'v', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 592 },
    .{ .char = 'd', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 593 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 594 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 313 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 595 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 596 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 597 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 598 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 140 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 599 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 600 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 601 },
    .{ .char = 'u', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 185 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 602 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 603 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 604 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 605 },
    .{ .char = 'f', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 606 },
    .{ .char = 'o', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 607 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 608 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 609 },
    .{ .char = 'c', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 195 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 610 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 525 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 611 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 612 },
    .{ .char = 'g', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 172 },
    .{ .char = '_', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 613 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 614 },
    .{ .char = 'e', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 615 },
    .{ .char = 'a', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 616 },
    .{ .char = 'n', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 617 },
    .{ .char = 'l', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 618 },
    .{ .char = 't', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 619 },
    .{ .char = 'y', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 620 },
    .{ .char = 'r', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 153 },
    .{ .char = 's', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 621 },
    .{ .char = 'i', .end_of_word = false, .end_of_list = true, .number = 1, .child_index = 215 },
};
pub const data = blk: {
    @setEvalBranchQuota(103);
    break :blk [_]@This(){
        // access
        .{ .tag = @enumFromInt(0), .properties = .{ .tag = .access, .gnu = true } },
        // alias
        .{ .tag = @enumFromInt(1), .properties = .{ .tag = .alias, .gnu = true } },
        // align
        .{ .tag = @enumFromInt(2), .properties = .{ .tag = .aligned, .declspec = true } },
        // aligned
        .{ .tag = @enumFromInt(3), .properties = .{ .tag = .aligned, .gnu = true } },
        // alloc_align
        .{ .tag = @enumFromInt(4), .properties = .{ .tag = .alloc_align, .gnu = true } },
        // alloc_size
        .{ .tag = @enumFromInt(5), .properties = .{ .tag = .alloc_size, .gnu = true } },
        // allocate
        .{ .tag = @enumFromInt(6), .properties = .{ .tag = .allocate, .declspec = true } },
        // allocator
        .{ .tag = @enumFromInt(7), .properties = .{ .tag = .allocator, .declspec = true } },
        // always_inline
        .{ .tag = @enumFromInt(8), .properties = .{ .tag = .always_inline, .gnu = true } },
        // appdomain
        .{ .tag = @enumFromInt(9), .properties = .{ .tag = .appdomain, .declspec = true } },
        // artificial
        .{ .tag = @enumFromInt(10), .properties = .{ .tag = .artificial, .gnu = true } },
        // assume_aligned
        .{ .tag = @enumFromInt(11), .properties = .{ .tag = .assume_aligned, .gnu = true } },
        // cleanup
        .{ .tag = @enumFromInt(12), .properties = .{ .tag = .cleanup, .gnu = true } },
        // code_seg
        .{ .tag = @enumFromInt(13), .properties = .{ .tag = .code_seg, .declspec = true } },
        // cold
        .{ .tag = @enumFromInt(14), .properties = .{ .tag = .cold, .gnu = true } },
        // common
        .{ .tag = @enumFromInt(15), .properties = .{ .tag = .common, .gnu = true } },
        // const
        .{ .tag = @enumFromInt(16), .properties = .{ .tag = .@"const", .gnu = true } },
        // constructor
        .{ .tag = @enumFromInt(17), .properties = .{ .tag = .constructor, .gnu = true } },
        // copy
        .{ .tag = @enumFromInt(18), .properties = .{ .tag = .copy, .gnu = true } },
        // deprecated
        .{ .tag = @enumFromInt(19), .properties = .{ .tag = .deprecated, .c23 = true, .gnu = true, .declspec = true } },
        // designated_init
        .{ .tag = @enumFromInt(20), .properties = .{ .tag = .designated_init, .gnu = true } },
        // destructor
        .{ .tag = @enumFromInt(21), .properties = .{ .tag = .destructor, .gnu = true } },
        // dllexport
        .{ .tag = @enumFromInt(22), .properties = .{ .tag = .dllexport, .declspec = true } },
        // dllimport
        .{ .tag = @enumFromInt(23), .properties = .{ .tag = .dllimport, .declspec = true } },
        // error
        .{ .tag = @enumFromInt(24), .properties = .{ .tag = .@"error", .gnu = true } },
        // externally_visible
        .{ .tag = @enumFromInt(25), .properties = .{ .tag = .externally_visible, .gnu = true } },
        // fallthrough
        .{ .tag = @enumFromInt(26), .properties = .{ .tag = .fallthrough, .c23 = true, .gnu = true } },
        // flatten
        .{ .tag = @enumFromInt(27), .properties = .{ .tag = .flatten, .gnu = true } },
        // format
        .{ .tag = @enumFromInt(28), .properties = .{ .tag = .format, .gnu = true } },
        // format_arg
        .{ .tag = @enumFromInt(29), .properties = .{ .tag = .format_arg, .gnu = true } },
        // gnu_inline
        .{ .tag = @enumFromInt(30), .properties = .{ .tag = .gnu_inline, .gnu = true } },
        // hot
        .{ .tag = @enumFromInt(31), .properties = .{ .tag = .hot, .gnu = true } },
        // ifunc
        .{ .tag = @enumFromInt(32), .properties = .{ .tag = .ifunc, .gnu = true } },
        // interrupt
        .{ .tag = @enumFromInt(33), .properties = .{ .tag = .interrupt, .gnu = true } },
        // interrupt_handler
        .{ .tag = @enumFromInt(34), .properties = .{ .tag = .interrupt_handler, .gnu = true } },
        // jitintrinsic
        .{ .tag = @enumFromInt(35), .properties = .{ .tag = .jitintrinsic, .declspec = true } },
        // leaf
        .{ .tag = @enumFromInt(36), .properties = .{ .tag = .leaf, .gnu = true } },
        // malloc
        .{ .tag = @enumFromInt(37), .properties = .{ .tag = .malloc, .gnu = true } },
        // may_alias
        .{ .tag = @enumFromInt(38), .properties = .{ .tag = .may_alias, .gnu = true } },
        // maybe_unused
        .{ .tag = @enumFromInt(39), .properties = .{ .tag = .unused, .c23 = true } },
        // mode
        .{ .tag = @enumFromInt(40), .properties = .{ .tag = .mode, .gnu = true } },
        // naked
        .{ .tag = @enumFromInt(41), .properties = .{ .tag = .naked, .declspec = true } },
        // no_address_safety_analysis
        .{ .tag = @enumFromInt(42), .properties = .{ .tag = .no_address_safety_analysis, .gnu = true } },
        // no_icf
        .{ .tag = @enumFromInt(43), .properties = .{ .tag = .no_icf, .gnu = true } },
        // no_instrument_function
        .{ .tag = @enumFromInt(44), .properties = .{ .tag = .no_instrument_function, .gnu = true } },
        // no_profile_instrument_function
        .{ .tag = @enumFromInt(45), .properties = .{ .tag = .no_profile_instrument_function, .gnu = true } },
        // no_reorder
        .{ .tag = @enumFromInt(46), .properties = .{ .tag = .no_reorder, .gnu = true } },
        // no_sanitize
        .{ .tag = @enumFromInt(47), .properties = .{ .tag = .no_sanitize, .gnu = true } },
        // no_sanitize_address
        .{ .tag = @enumFromInt(48), .properties = .{ .tag = .no_sanitize_address, .gnu = true, .declspec = true } },
        // no_sanitize_coverage
        .{ .tag = @enumFromInt(49), .properties = .{ .tag = .no_sanitize_coverage, .gnu = true } },
        // no_sanitize_thread
        .{ .tag = @enumFromInt(50), .properties = .{ .tag = .no_sanitize_thread, .gnu = true } },
        // no_sanitize_undefined
        .{ .tag = @enumFromInt(51), .properties = .{ .tag = .no_sanitize_undefined, .gnu = true } },
        // no_split_stack
        .{ .tag = @enumFromInt(52), .properties = .{ .tag = .no_split_stack, .gnu = true } },
        // no_stack_limit
        .{ .tag = @enumFromInt(53), .properties = .{ .tag = .no_stack_limit, .gnu = true } },
        // no_stack_protector
        .{ .tag = @enumFromInt(54), .properties = .{ .tag = .no_stack_protector, .gnu = true } },
        // noalias
        .{ .tag = @enumFromInt(55), .properties = .{ .tag = .@"noalias", .declspec = true } },
        // noclone
        .{ .tag = @enumFromInt(56), .properties = .{ .tag = .noclone, .gnu = true } },
        // nocommon
        .{ .tag = @enumFromInt(57), .properties = .{ .tag = .nocommon, .gnu = true } },
        // nodiscard
        .{ .tag = @enumFromInt(58), .properties = .{ .tag = .nodiscard, .c23 = true } },
        // noinit
        .{ .tag = @enumFromInt(59), .properties = .{ .tag = .noinit, .gnu = true } },
        // noinline
        .{ .tag = @enumFromInt(60), .properties = .{ .tag = .@"noinline", .gnu = true, .declspec = true } },
        // noipa
        .{ .tag = @enumFromInt(61), .properties = .{ .tag = .noipa, .gnu = true } },
        // nonstring
        .{ .tag = @enumFromInt(62), .properties = .{ .tag = .nonstring, .gnu = true } },
        // noplt
        .{ .tag = @enumFromInt(63), .properties = .{ .tag = .noplt, .gnu = true } },
        // noreturn
        .{ .tag = @enumFromInt(64), .properties = .{ .tag = .@"noreturn", .c23 = true, .gnu = true, .declspec = true } },
        // packed
        .{ .tag = @enumFromInt(65), .properties = .{ .tag = .@"packed", .gnu = true } },
        // patchable_function_entry
        .{ .tag = @enumFromInt(66), .properties = .{ .tag = .patchable_function_entry, .gnu = true } },
        // persistent
        .{ .tag = @enumFromInt(67), .properties = .{ .tag = .persistent, .gnu = true } },
        // process
        .{ .tag = @enumFromInt(68), .properties = .{ .tag = .process, .declspec = true } },
        // pure
        .{ .tag = @enumFromInt(69), .properties = .{ .tag = .pure, .gnu = true } },
        // reproducible
        .{ .tag = @enumFromInt(70), .properties = .{ .tag = .reproducible, .c23 = true } },
        // restrict
        .{ .tag = @enumFromInt(71), .properties = .{ .tag = .restrict, .declspec = true } },
        // retain
        .{ .tag = @enumFromInt(72), .properties = .{ .tag = .retain, .gnu = true } },
        // returns_nonnull
        .{ .tag = @enumFromInt(73), .properties = .{ .tag = .returns_nonnull, .gnu = true } },
        // returns_twice
        .{ .tag = @enumFromInt(74), .properties = .{ .tag = .returns_twice, .gnu = true } },
        // safebuffers
        .{ .tag = @enumFromInt(75), .properties = .{ .tag = .safebuffers, .declspec = true } },
        // scalar_storage_order
        .{ .tag = @enumFromInt(76), .properties = .{ .tag = .scalar_storage_order, .gnu = true } },
        // section
        .{ .tag = @enumFromInt(77), .properties = .{ .tag = .section, .gnu = true } },
        // selectany
        .{ .tag = @enumFromInt(78), .properties = .{ .tag = .selectany, .declspec = true } },
        // sentinel
        .{ .tag = @enumFromInt(79), .properties = .{ .tag = .sentinel, .gnu = true } },
        // simd
        .{ .tag = @enumFromInt(80), .properties = .{ .tag = .simd, .gnu = true } },
        // spectre
        .{ .tag = @enumFromInt(81), .properties = .{ .tag = .spectre, .declspec = true } },
        // stack_protect
        .{ .tag = @enumFromInt(82), .properties = .{ .tag = .stack_protect, .gnu = true } },
        // symver
        .{ .tag = @enumFromInt(83), .properties = .{ .tag = .symver, .gnu = true } },
        // target
        .{ .tag = @enumFromInt(84), .properties = .{ .tag = .target, .gnu = true } },
        // target_clones
        .{ .tag = @enumFromInt(85), .properties = .{ .tag = .target_clones, .gnu = true } },
        // thread
        .{ .tag = @enumFromInt(86), .properties = .{ .tag = .thread, .declspec = true } },
        // tls_model
        .{ .tag = @enumFromInt(87), .properties = .{ .tag = .tls_model, .gnu = true } },
        // transparent_union
        .{ .tag = @enumFromInt(88), .properties = .{ .tag = .transparent_union, .gnu = true } },
        // unavailable
        .{ .tag = @enumFromInt(89), .properties = .{ .tag = .unavailable, .gnu = true } },
        // uninitialized
        .{ .tag = @enumFromInt(90), .properties = .{ .tag = .uninitialized, .gnu = true } },
        // unsequenced
        .{ .tag = @enumFromInt(91), .properties = .{ .tag = .unsequenced, .c23 = true } },
        // unused
        .{ .tag = @enumFromInt(92), .properties = .{ .tag = .unused, .gnu = true } },
        // used
        .{ .tag = @enumFromInt(93), .properties = .{ .tag = .used, .gnu = true } },
        // uuid
        .{ .tag = @enumFromInt(94), .properties = .{ .tag = .uuid, .declspec = true } },
        // vector_size
        .{ .tag = @enumFromInt(95), .properties = .{ .tag = .vector_size, .gnu = true } },
        // visibility
        .{ .tag = @enumFromInt(96), .properties = .{ .tag = .visibility, .gnu = true } },
        // warn_if_not_aligned
        .{ .tag = @enumFromInt(97), .properties = .{ .tag = .warn_if_not_aligned, .gnu = true } },
        // warn_unused_result
        .{ .tag = @enumFromInt(98), .properties = .{ .tag = .warn_unused_result, .gnu = true } },
        // warning
        .{ .tag = @enumFromInt(99), .properties = .{ .tag = .warning, .gnu = true } },
        // weak
        .{ .tag = @enumFromInt(100), .properties = .{ .tag = .weak, .gnu = true } },
        // weakref
        .{ .tag = @enumFromInt(101), .properties = .{ .tag = .weakref, .gnu = true } },
        // zero_call_used_regs
        .{ .tag = @enumFromInt(102), .properties = .{ .tag = .zero_call_used_regs, .gnu = true } },
    };
};
};
}
