// Code generated by protoc-gen-go-ttrpc. DO NOT EDIT.
// source: github.com/containerd/ttrpc/integration/streaming/test.proto
package streaming

import (
	context "context"
	ttrpc "github.com/containerd/ttrpc"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

type TTRPCStreamingService interface {
	Echo(context.Context, *EchoPayload) (*EchoPayload, error)
	EchoStream(context.Context, TTRPCStreaming_EchoStreamServer) error
	SumStream(context.Context, TTRPCStreaming_SumStreamServer) (*Sum, error)
	DivideStream(context.Context, *Sum, TTRPCStreaming_DivideStreamServer) error
	EchoNull(context.Context, TTRPCStreaming_EchoNullServer) (*emptypb.Empty, error)
	EchoNullStream(context.Context, TTRPCStreaming_EchoNullStreamServer) error
}

type TTRPCStreaming_EchoStreamServer interface {
	Send(*EchoPayload) error
	Recv() (*EchoPayload, error)
	ttrpc.StreamServer
}

type ttrpcstreamingEchoStreamServer struct {
	ttrpc.StreamServer
}

func (x *ttrpcstreamingEchoStreamServer) Send(m *EchoPayload) error {
	return x.StreamServer.SendMsg(m)
}

func (x *ttrpcstreamingEchoStreamServer) Recv() (*EchoPayload, error) {
	m := new(EchoPayload)
	if err := x.StreamServer.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type TTRPCStreaming_SumStreamServer interface {
	Recv() (*Part, error)
	ttrpc.StreamServer
}

type ttrpcstreamingSumStreamServer struct {
	ttrpc.StreamServer
}

func (x *ttrpcstreamingSumStreamServer) Recv() (*Part, error) {
	m := new(Part)
	if err := x.StreamServer.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type TTRPCStreaming_DivideStreamServer interface {
	Send(*Part) error
	ttrpc.StreamServer
}

type ttrpcstreamingDivideStreamServer struct {
	ttrpc.StreamServer
}

func (x *ttrpcstreamingDivideStreamServer) Send(m *Part) error {
	return x.StreamServer.SendMsg(m)
}

type TTRPCStreaming_EchoNullServer interface {
	Recv() (*EchoPayload, error)
	ttrpc.StreamServer
}

type ttrpcstreamingEchoNullServer struct {
	ttrpc.StreamServer
}

func (x *ttrpcstreamingEchoNullServer) Recv() (*EchoPayload, error) {
	m := new(EchoPayload)
	if err := x.StreamServer.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

type TTRPCStreaming_EchoNullStreamServer interface {
	Send(*emptypb.Empty) error
	Recv() (*EchoPayload, error)
	ttrpc.StreamServer
}

type ttrpcstreamingEchoNullStreamServer struct {
	ttrpc.StreamServer
}

func (x *ttrpcstreamingEchoNullStreamServer) Send(m *emptypb.Empty) error {
	return x.StreamServer.SendMsg(m)
}

func (x *ttrpcstreamingEchoNullStreamServer) Recv() (*EchoPayload, error) {
	m := new(EchoPayload)
	if err := x.StreamServer.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func RegisterTTRPCStreamingService(srv *ttrpc.Server, svc TTRPCStreamingService) {
	srv.RegisterService("ttrpc.integration.streaming.Streaming", &ttrpc.ServiceDesc{
		Methods: map[string]ttrpc.Method{
			"Echo": func(ctx context.Context, unmarshal func(interface{}) error) (interface{}, error) {
				var req EchoPayload
				if err := unmarshal(&req); err != nil {
					return nil, err
				}
				return svc.Echo(ctx, &req)
			},
		},
		Streams: map[string]ttrpc.Stream{
			"EchoStream": {
				Handler: func(ctx context.Context, stream ttrpc.StreamServer) (interface{}, error) {
					return nil, svc.EchoStream(ctx, &ttrpcstreamingEchoStreamServer{stream})
				},
				StreamingClient: true,
				StreamingServer: true,
			},
			"SumStream": {
				Handler: func(ctx context.Context, stream ttrpc.StreamServer) (interface{}, error) {
					return svc.SumStream(ctx, &ttrpcstreamingSumStreamServer{stream})
				},
				StreamingClient: true,
				StreamingServer: false,
			},
			"DivideStream": {
				Handler: func(ctx context.Context, stream ttrpc.StreamServer) (interface{}, error) {
					m := new(Sum)
					if err := stream.RecvMsg(m); err != nil {
						return nil, err
					}
					return nil, svc.DivideStream(ctx, m, &ttrpcstreamingDivideStreamServer{stream})
				},
				StreamingClient: false,
				StreamingServer: true,
			},
			"EchoNull": {
				Handler: func(ctx context.Context, stream ttrpc.StreamServer) (interface{}, error) {
					return svc.EchoNull(ctx, &ttrpcstreamingEchoNullServer{stream})
				},
				StreamingClient: true,
				StreamingServer: false,
			},
			"EchoNullStream": {
				Handler: func(ctx context.Context, stream ttrpc.StreamServer) (interface{}, error) {
					return nil, svc.EchoNullStream(ctx, &ttrpcstreamingEchoNullStreamServer{stream})
				},
				StreamingClient: true,
				StreamingServer: true,
			},
		},
	})
}

type TTRPCStreamingClient interface {
	Echo(context.Context, *EchoPayload) (*EchoPayload, error)
	EchoStream(context.Context) (TTRPCStreaming_EchoStreamClient, error)
	SumStream(context.Context) (TTRPCStreaming_SumStreamClient, error)
	DivideStream(context.Context, *Sum) (TTRPCStreaming_DivideStreamClient, error)
	EchoNull(context.Context) (TTRPCStreaming_EchoNullClient, error)
	EchoNullStream(context.Context) (TTRPCStreaming_EchoNullStreamClient, error)
}

type ttrpcstreamingClient struct {
	client *ttrpc.Client
}

func NewTTRPCStreamingClient(client *ttrpc.Client) TTRPCStreamingClient {
	return &ttrpcstreamingClient{
		client: client,
	}
}

func (c *ttrpcstreamingClient) Echo(ctx context.Context, req *EchoPayload) (*EchoPayload, error) {
	var resp EchoPayload
	if err := c.client.Call(ctx, "ttrpc.integration.streaming.Streaming", "Echo", req, &resp); err != nil {
		return nil, err
	}
	return &resp, nil
}

func (c *ttrpcstreamingClient) EchoStream(ctx context.Context) (TTRPCStreaming_EchoStreamClient, error) {
	stream, err := c.client.NewStream(ctx, &ttrpc.StreamDesc{
		StreamingClient: true,
		StreamingServer: true,
	}, "ttrpc.integration.streaming.Streaming", "EchoStream", nil)
	if err != nil {
		return nil, err
	}
	x := &ttrpcstreamingEchoStreamClient{stream}
	return x, nil
}

type TTRPCStreaming_EchoStreamClient interface {
	Send(*EchoPayload) error
	Recv() (*EchoPayload, error)
	ttrpc.ClientStream
}

type ttrpcstreamingEchoStreamClient struct {
	ttrpc.ClientStream
}

func (x *ttrpcstreamingEchoStreamClient) Send(m *EchoPayload) error {
	return x.ClientStream.SendMsg(m)
}

func (x *ttrpcstreamingEchoStreamClient) Recv() (*EchoPayload, error) {
	m := new(EchoPayload)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *ttrpcstreamingClient) SumStream(ctx context.Context) (TTRPCStreaming_SumStreamClient, error) {
	stream, err := c.client.NewStream(ctx, &ttrpc.StreamDesc{
		StreamingClient: true,
		StreamingServer: false,
	}, "ttrpc.integration.streaming.Streaming", "SumStream", nil)
	if err != nil {
		return nil, err
	}
	x := &ttrpcstreamingSumStreamClient{stream}
	return x, nil
}

type TTRPCStreaming_SumStreamClient interface {
	Send(*Part) error
	CloseAndRecv() (*Sum, error)
	ttrpc.ClientStream
}

type ttrpcstreamingSumStreamClient struct {
	ttrpc.ClientStream
}

func (x *ttrpcstreamingSumStreamClient) Send(m *Part) error {
	return x.ClientStream.SendMsg(m)
}

func (x *ttrpcstreamingSumStreamClient) CloseAndRecv() (*Sum, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(Sum)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *ttrpcstreamingClient) DivideStream(ctx context.Context, req *Sum) (TTRPCStreaming_DivideStreamClient, error) {
	stream, err := c.client.NewStream(ctx, &ttrpc.StreamDesc{
		StreamingClient: false,
		StreamingServer: true,
	}, "ttrpc.integration.streaming.Streaming", "DivideStream", req)
	if err != nil {
		return nil, err
	}
	x := &ttrpcstreamingDivideStreamClient{stream}
	return x, nil
}

type TTRPCStreaming_DivideStreamClient interface {
	Recv() (*Part, error)
	ttrpc.ClientStream
}

type ttrpcstreamingDivideStreamClient struct {
	ttrpc.ClientStream
}

func (x *ttrpcstreamingDivideStreamClient) Recv() (*Part, error) {
	m := new(Part)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *ttrpcstreamingClient) EchoNull(ctx context.Context) (TTRPCStreaming_EchoNullClient, error) {
	stream, err := c.client.NewStream(ctx, &ttrpc.StreamDesc{
		StreamingClient: true,
		StreamingServer: false,
	}, "ttrpc.integration.streaming.Streaming", "EchoNull", nil)
	if err != nil {
		return nil, err
	}
	x := &ttrpcstreamingEchoNullClient{stream}
	return x, nil
}

type TTRPCStreaming_EchoNullClient interface {
	Send(*EchoPayload) error
	CloseAndRecv() (*emptypb.Empty, error)
	ttrpc.ClientStream
}

type ttrpcstreamingEchoNullClient struct {
	ttrpc.ClientStream
}

func (x *ttrpcstreamingEchoNullClient) Send(m *EchoPayload) error {
	return x.ClientStream.SendMsg(m)
}

func (x *ttrpcstreamingEchoNullClient) CloseAndRecv() (*emptypb.Empty, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(emptypb.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *ttrpcstreamingClient) EchoNullStream(ctx context.Context) (TTRPCStreaming_EchoNullStreamClient, error) {
	stream, err := c.client.NewStream(ctx, &ttrpc.StreamDesc{
		StreamingClient: true,
		StreamingServer: true,
	}, "ttrpc.integration.streaming.Streaming", "EchoNullStream", nil)
	if err != nil {
		return nil, err
	}
	x := &ttrpcstreamingEchoNullStreamClient{stream}
	return x, nil
}

type TTRPCStreaming_EchoNullStreamClient interface {
	Send(*EchoPayload) error
	Recv() (*emptypb.Empty, error)
	ttrpc.ClientStream
}

type ttrpcstreamingEchoNullStreamClient struct {
	ttrpc.ClientStream
}

func (x *ttrpcstreamingEchoNullStreamClient) Send(m *EchoPayload) error {
	return x.ClientStream.SendMsg(m)
}

func (x *ttrpcstreamingEchoNullStreamClient) Recv() (*emptypb.Empty, error) {
	m := new(emptypb.Empty)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}
