<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# btree

```go
import "github.com/zyedidia/generic/btree"
```

Package btree provides an implementation of a B\-tree. A B\-tree is a logarithmic search tree that maintains key\-value pairs in sorted order. It is not binary because it stores more than 2 data entries per node. The branching factor for this tree is 64.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	g "github.com/zyedidia/generic"
	"github.com/zyedidia/generic/btree"
)

func main() {
	tree := btree.New[int, string](g.Less[int])

	tree.Put(42, "foo")
	tree.Put(-10, "bar")
	tree.Put(0, "baz")

	tree.Each(func(key int, val string) {
		fmt.Println(key, val)
	})

}
```

#### Output

```
-10 bar
0 baz
42 foo
```

</p>
</details>

## Index

- [type Tree](<#type-tree>)
  - [func New[K, V any](less g.LessFn[K]) *Tree[K, V]](<#func-new>)
  - [func (t *Tree[K, V]) Each(fn func(key K, val V))](<#func-treek-v-each>)
  - [func (t *Tree[K, V]) Get(key K) (V, bool)](<#func-treek-v-get>)
  - [func (t *Tree[K, V]) Put(key K, val V)](<#func-treek-v-put>)
  - [func (t *Tree[K, V]) Remove(key K)](<#func-treek-v-remove>)
  - [func (t *Tree[K, V]) Size() int](<#func-treek-v-size>)


## type [Tree](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L18-L24>)

Tree implements a B\-tree.

```go
type Tree[K, V any] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L39>)

```go
func New[K, V any](less g.LessFn[K]) *Tree[K, V]
```

New returns an empty B\-tree.

### func \(\*Tree\[K, V\]\) [Each](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L172>)

```go
func (t *Tree[K, V]) Each(fn func(key K, val V))
```

Each calls 'fn' on every node in the tree in order.

### func \(\*Tree\[K, V\]\) [Get](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L52>)

```go
func (t *Tree[K, V]) Get(key K) (V, bool)
```

Get returns the value associated with 'key'.

### func \(\*Tree\[K, V\]\) [Put](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L79>)

```go
func (t *Tree[K, V]) Put(key K, val V)
```

Put associates 'key' with 'val'.

### func \(\*Tree\[K, V\]\) [Remove](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L102>)

```go
func (t *Tree[K, V]) Remove(key K)
```

Remove removes the value associated with 'key'.

### func \(\*Tree\[K, V\]\) [Size](<https://github.com/zyedidia/generic/blob/master/btree/btree.go#L47>)

```go
func (t *Tree[K, V]) Size() int
```

Size returns the number of elements in the tree.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
