'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var getTransitionStyles = require('./get-transition-styles/get-transition-styles.cjs');
var useTransition = require('./use-transition.cjs');

function Transition({
  keepMounted,
  transition = "fade",
  duration = 250,
  exitDuration = duration,
  mounted,
  children,
  timingFunction = "ease",
  onExit,
  onEntered,
  onEnter,
  onExited,
  enterDelay,
  exitDelay
}) {
  const { transitionDuration, transitionStatus, transitionTimingFunction } = useTransition.useTransition({
    mounted,
    exitDuration,
    duration,
    timingFunction,
    onExit,
    onEntered,
    onEnter,
    onExited,
    enterDelay,
    exitDelay
  });
  if (transitionDuration === 0) {
    return mounted ? /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: children({}) }) : keepMounted ? children({ display: "none" }) : null;
  }
  return transitionStatus === "exited" ? keepMounted ? children({ display: "none" }) : null : /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: children(
    getTransitionStyles.getTransitionStyles({
      transition,
      duration: transitionDuration,
      state: transitionStatus,
      timingFunction: transitionTimingFunction
    })
  ) });
}
Transition.displayName = "@mantine/core/Transition";

exports.Transition = Transition;
//# sourceMappingURL=Transition.cjs.map
