import { EncodedQuery, QueryParamConfigMap } from 'serialize-query-params';
import { UrlUpdateType } from './types';
export declare const defaultOptions: QueryParamOptionsWithRequired;
export interface QueryParamOptions {
    searchStringToObject?: (searchString: string) => EncodedQuery;
    objectToSearchString?: (encodedParams: EncodedQuery) => string;
    updateType?: UrlUpdateType;
    includeKnownParams?: boolean;
    includeAllParams?: boolean;
    /** whether sets that result in no change to the location search string should be ignored (default: true) */
    skipUpdateWhenNoChange?: boolean;
    params?: QueryParamConfigMap;
    /** when a value equals its default, do not encode it in the URL when updating */
    removeDefaultsFromUrl?: boolean;
    /**
     * @experimental this is an experimental option to combine multiple `set` calls
     * into a single URL update.
     */
    enableBatching?: boolean;
}
declare type RequiredOptions = 'searchStringToObject' | 'objectToSearchString';
export declare type QueryParamOptionsWithRequired = Required<Pick<QueryParamOptions, RequiredOptions>> & Omit<QueryParamOptions, RequiredOptions>;
export declare function mergeOptions(parentOptions: QueryParamOptionsWithRequired, currOptions: QueryParamOptions | null | undefined): QueryParamOptionsWithRequired;
export {};
