#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 142
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 75
#define ALIAS_COUNT 0
#define TOKEN_COUNT 44
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 1

enum {
  anon_sym_COLON = 1,
  anon_sym_SEMI = 2,
  anon_sym_COMMA = 3,
  sym_open_squiggly = 4,
  sym_close_squiggly = 5,
  sym_open_square = 6,
  sym_close_square = 7,
  sym_open_arrow = 8,
  sym_close_arrow = 9,
  anon_sym_SLASH = 10,
  anon_sym_DOT = 11,
  sym_identifier = 12,
  anon_sym_DASH = 13,
  anon_sym_SQUOTE = 14,
  anon_sym_DQUOTE = 15,
  sym_single_string_contents = 16,
  sym_double_string_contents = 17,
  anon_sym_BSLASHa = 18,
  anon_sym_BSLASHb = 19,
  anon_sym_BSLASHf = 20,
  anon_sym_BSLASHn = 21,
  anon_sym_BSLASHr = 22,
  anon_sym_BSLASHt = 23,
  anon_sym_BSLASHv = 24,
  anon_sym_BSLASH_QMARK = 25,
  anon_sym_BSLASH_DQUOTE = 26,
  anon_sym_BSLASH_SQUOTE = 27,
  anon_sym_BSLASH = 28,
  anon_sym_BSLASHx = 29,
  anon_sym_BSLASHu = 30,
  anon_sym_BSLASHU000 = 31,
  anon_sym_BSLASHU010 = 32,
  sym_oct = 33,
  sym_hex = 34,
  anon_sym_0 = 35,
  aux_sym_dec_int_token1 = 36,
  sym_oct_int = 37,
  sym_hex_int = 38,
  aux_sym_float_lit_token1 = 39,
  aux_sym_exp_token1 = 40,
  aux_sym_float_token1 = 41,
  anon_sym_POUND = 42,
  aux_sym_comment_token1 = 43,
  sym_message = 44,
  sym_field = 45,
  sym_message_field = 46,
  sym_scalar_field = 47,
  sym_message_value = 48,
  sym_message_list = 49,
  sym_field_name = 50,
  sym_extension_name = 51,
  sym_any_name = 52,
  sym_type_name = 53,
  sym_domain = 54,
  sym_signed_identifier = 55,
  sym_scalar_value = 56,
  sym_scalar_list = 57,
  sym_string = 58,
  sym_single_string = 59,
  sym_double_string = 60,
  sym_string_escape = 61,
  sym_number = 62,
  sym_dec_int = 63,
  sym_float_lit = 64,
  sym_exp = 65,
  sym_float = 66,
  sym_comment = 67,
  aux_sym_message_repeat1 = 68,
  aux_sym_message_list_repeat1 = 69,
  aux_sym_type_name_repeat1 = 70,
  aux_sym_scalar_value_repeat1 = 71,
  aux_sym_scalar_list_repeat1 = 72,
  aux_sym_single_string_repeat1 = 73,
  aux_sym_double_string_repeat1 = 74,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COLON] = ":",
  [anon_sym_SEMI] = ";",
  [anon_sym_COMMA] = ",",
  [sym_open_squiggly] = "open_squiggly",
  [sym_close_squiggly] = "close_squiggly",
  [sym_open_square] = "open_square",
  [sym_close_square] = "close_square",
  [sym_open_arrow] = "open_arrow",
  [sym_close_arrow] = "close_arrow",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT] = ".",
  [sym_identifier] = "identifier",
  [anon_sym_DASH] = "-",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DQUOTE] = "\"",
  [sym_single_string_contents] = "single_string_contents",
  [sym_double_string_contents] = "double_string_contents",
  [anon_sym_BSLASHa] = "\\a",
  [anon_sym_BSLASHb] = "\\b",
  [anon_sym_BSLASHf] = "\\f",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHv] = "\\v",
  [anon_sym_BSLASH_QMARK] = "\\\?",
  [anon_sym_BSLASH_DQUOTE] = "\\\"",
  [anon_sym_BSLASH_SQUOTE] = "\\'",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_BSLASHx] = "\\x",
  [anon_sym_BSLASHu] = "\\u",
  [anon_sym_BSLASHU000] = "\\U000",
  [anon_sym_BSLASHU010] = "\\U010",
  [sym_oct] = "oct",
  [sym_hex] = "hex",
  [anon_sym_0] = "0",
  [aux_sym_dec_int_token1] = "dec_int_token1",
  [sym_oct_int] = "oct_int",
  [sym_hex_int] = "hex_int",
  [aux_sym_float_lit_token1] = "float_lit_token1",
  [aux_sym_exp_token1] = "exp_token1",
  [aux_sym_float_token1] = "float_token1",
  [anon_sym_POUND] = "#",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_message] = "message",
  [sym_field] = "field",
  [sym_message_field] = "message_field",
  [sym_scalar_field] = "scalar_field",
  [sym_message_value] = "message_value",
  [sym_message_list] = "message_list",
  [sym_field_name] = "field_name",
  [sym_extension_name] = "extension_name",
  [sym_any_name] = "any_name",
  [sym_type_name] = "type_name",
  [sym_domain] = "domain",
  [sym_signed_identifier] = "signed_identifier",
  [sym_scalar_value] = "scalar_value",
  [sym_scalar_list] = "scalar_list",
  [sym_string] = "string",
  [sym_single_string] = "single_string",
  [sym_double_string] = "double_string",
  [sym_string_escape] = "string_escape",
  [sym_number] = "number",
  [sym_dec_int] = "dec_int",
  [sym_float_lit] = "float_lit",
  [sym_exp] = "exp",
  [sym_float] = "float",
  [sym_comment] = "comment",
  [aux_sym_message_repeat1] = "message_repeat1",
  [aux_sym_message_list_repeat1] = "message_list_repeat1",
  [aux_sym_type_name_repeat1] = "type_name_repeat1",
  [aux_sym_scalar_value_repeat1] = "scalar_value_repeat1",
  [aux_sym_scalar_list_repeat1] = "scalar_list_repeat1",
  [aux_sym_single_string_repeat1] = "single_string_repeat1",
  [aux_sym_double_string_repeat1] = "double_string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_open_squiggly] = sym_open_squiggly,
  [sym_close_squiggly] = sym_close_squiggly,
  [sym_open_square] = sym_open_square,
  [sym_close_square] = sym_close_square,
  [sym_open_arrow] = sym_open_arrow,
  [sym_close_arrow] = sym_close_arrow,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_identifier] = sym_identifier,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_single_string_contents] = sym_single_string_contents,
  [sym_double_string_contents] = sym_double_string_contents,
  [anon_sym_BSLASHa] = anon_sym_BSLASHa,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHf] = anon_sym_BSLASHf,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHv] = anon_sym_BSLASHv,
  [anon_sym_BSLASH_QMARK] = anon_sym_BSLASH_QMARK,
  [anon_sym_BSLASH_DQUOTE] = anon_sym_BSLASH_DQUOTE,
  [anon_sym_BSLASH_SQUOTE] = anon_sym_BSLASH_SQUOTE,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_BSLASHx] = anon_sym_BSLASHx,
  [anon_sym_BSLASHu] = anon_sym_BSLASHu,
  [anon_sym_BSLASHU000] = anon_sym_BSLASHU000,
  [anon_sym_BSLASHU010] = anon_sym_BSLASHU010,
  [sym_oct] = sym_oct,
  [sym_hex] = sym_hex,
  [anon_sym_0] = anon_sym_0,
  [aux_sym_dec_int_token1] = aux_sym_dec_int_token1,
  [sym_oct_int] = sym_oct_int,
  [sym_hex_int] = sym_hex_int,
  [aux_sym_float_lit_token1] = aux_sym_float_lit_token1,
  [aux_sym_exp_token1] = aux_sym_exp_token1,
  [aux_sym_float_token1] = aux_sym_float_token1,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_message] = sym_message,
  [sym_field] = sym_field,
  [sym_message_field] = sym_message_field,
  [sym_scalar_field] = sym_scalar_field,
  [sym_message_value] = sym_message_value,
  [sym_message_list] = sym_message_list,
  [sym_field_name] = sym_field_name,
  [sym_extension_name] = sym_extension_name,
  [sym_any_name] = sym_any_name,
  [sym_type_name] = sym_type_name,
  [sym_domain] = sym_domain,
  [sym_signed_identifier] = sym_signed_identifier,
  [sym_scalar_value] = sym_scalar_value,
  [sym_scalar_list] = sym_scalar_list,
  [sym_string] = sym_string,
  [sym_single_string] = sym_single_string,
  [sym_double_string] = sym_double_string,
  [sym_string_escape] = sym_string_escape,
  [sym_number] = sym_number,
  [sym_dec_int] = sym_dec_int,
  [sym_float_lit] = sym_float_lit,
  [sym_exp] = sym_exp,
  [sym_float] = sym_float,
  [sym_comment] = sym_comment,
  [aux_sym_message_repeat1] = aux_sym_message_repeat1,
  [aux_sym_message_list_repeat1] = aux_sym_message_list_repeat1,
  [aux_sym_type_name_repeat1] = aux_sym_type_name_repeat1,
  [aux_sym_scalar_value_repeat1] = aux_sym_scalar_value_repeat1,
  [aux_sym_scalar_list_repeat1] = aux_sym_scalar_list_repeat1,
  [aux_sym_single_string_repeat1] = aux_sym_single_string_repeat1,
  [aux_sym_double_string_repeat1] = aux_sym_double_string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_open_squiggly] = {
    .visible = true,
    .named = true,
  },
  [sym_close_squiggly] = {
    .visible = true,
    .named = true,
  },
  [sym_open_square] = {
    .visible = true,
    .named = true,
  },
  [sym_close_square] = {
    .visible = true,
    .named = true,
  },
  [sym_open_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_close_arrow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_single_string_contents] = {
    .visible = true,
    .named = true,
  },
  [sym_double_string_contents] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHx] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHu] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHU000] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHU010] = {
    .visible = true,
    .named = false,
  },
  [sym_oct] = {
    .visible = true,
    .named = true,
  },
  [sym_hex] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_dec_int_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_oct_int] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_int] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_float_lit_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exp_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_message] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_message_field] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_field] = {
    .visible = true,
    .named = true,
  },
  [sym_message_value] = {
    .visible = true,
    .named = true,
  },
  [sym_message_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [sym_extension_name] = {
    .visible = true,
    .named = true,
  },
  [sym_any_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [sym_signed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_value] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_list] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_single_string] = {
    .visible = true,
    .named = true,
  },
  [sym_double_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_int] = {
    .visible = true,
    .named = true,
  },
  [sym_float_lit] = {
    .visible = true,
    .named = true,
  },
  [sym_exp] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_message_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_message_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_scalar_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_scalar_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_single_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_double_string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 11,
  [14] = 14,
  [15] = 14,
  [16] = 12,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 17,
  [21] = 21,
  [22] = 18,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 19,
  [27] = 24,
  [28] = 21,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 47,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 34,
  [72] = 37,
  [73] = 36,
  [74] = 46,
  [75] = 75,
  [76] = 76,
  [77] = 42,
  [78] = 78,
  [79] = 79,
  [80] = 38,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 58,
  [93] = 93,
  [94] = 94,
  [95] = 50,
  [96] = 96,
  [97] = 56,
  [98] = 98,
  [99] = 54,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 55,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 119,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 123,
  [129] = 129,
  [130] = 112,
  [131] = 116,
  [132] = 129,
  [133] = 125,
  [134] = 117,
  [135] = 115,
  [136] = 124,
  [137] = 109,
  [138] = 113,
  [139] = 126,
  [140] = 108,
  [141] = 141,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(15);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(30);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(55);
      if (lookahead == ':') ADVANCE(16);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '>') ADVANCE(24);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == ']') ADVANCE(22);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(28);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(54);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '7')) ADVANCE(53);
      if (('A' <= lookahead && lookahead <= 'E') ||
          ('a' <= lookahead && lookahead <= 'e')) ADVANCE(28);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1)
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '\'') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(34);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(2)
      if (lookahead == '"') ADVANCE(31);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(37);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '"') ADVANCE(31);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(4)
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '\'') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(48);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      if (lookahead != 0) ADVANCE(34);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == ']') ADVANCE(22);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(62);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(63);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(53);
      END_STATE();
    case 8:
      if (lookahead == '0') ADVANCE(11);
      END_STATE();
    case 9:
      if (lookahead == '0') ADVANCE(51);
      END_STATE();
    case 10:
      if (lookahead == '0') ADVANCE(52);
      END_STATE();
    case 11:
      if (lookahead == '0') ADVANCE(9);
      if (lookahead == '1') ADVANCE(10);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 13:
      if (eof) ADVANCE(15);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(30);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(25);
      if (lookahead == '0') ADVANCE(56);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '<') ADVANCE(23);
      if (lookahead == '>') ADVANCE(24);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == ']') ADVANCE(22);
      if (lookahead == '{') ADVANCE(19);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(57);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 14:
      if (eof) ADVANCE(15);
      if (lookahead == '#') ADVANCE(64);
      if (lookahead == ',') ADVANCE(18);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '>') ADVANCE(24);
      if (lookahead == '[') ADVANCE(21);
      if (lookahead == '}') ADVANCE(20);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(27);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_open_squiggly);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_close_squiggly);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_open_square);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_close_square);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_open_arrow);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_close_arrow);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_single_string_contents);
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(34);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(sym_single_string_contents);
      if (lookahead == '#') ADVANCE(66);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(34);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_single_string_contents);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(34);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_double_string_contents);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(37);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(37);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_double_string_contents);
      if (lookahead == '#') ADVANCE(65);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(37);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_double_string_contents);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(37);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_BSLASHa);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_BSLASHf);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_BSLASHv);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_BSLASH_QMARK);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_BSLASH_DQUOTE);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BSLASH_SQUOTE);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      if (lookahead == '"') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(47);
      if (lookahead == '?') ADVANCE(45);
      if (lookahead == 'U') ADVANCE(8);
      if (lookahead == 'a') ADVANCE(38);
      if (lookahead == 'b') ADVANCE(39);
      if (lookahead == 'f') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(41);
      if (lookahead == 'r') ADVANCE(42);
      if (lookahead == 't') ADVANCE(43);
      if (lookahead == 'u') ADVANCE(50);
      if (lookahead == 'v') ADVANCE(44);
      if (lookahead == 'x') ADVANCE(49);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_BSLASHx);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_BSLASHu);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_BSLASHU000);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_BSLASHU010);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_oct);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_hex);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_0);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(58);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_dec_int_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_oct_int);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_hex_int);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_float_lit_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_exp_token1);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_exp_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(61);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_float_token1);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(37);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(34);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(69);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '#') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(68);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(69);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(69);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 13},
  [2] = {.lex_state = 13},
  [3] = {.lex_state = 13},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 13},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 3},
  [15] = {.lex_state = 4},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 1},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 13},
  [30] = {.lex_state = 13},
  [31] = {.lex_state = 13},
  [32] = {.lex_state = 13},
  [33] = {.lex_state = 13},
  [34] = {.lex_state = 13},
  [35] = {.lex_state = 13},
  [36] = {.lex_state = 14},
  [37] = {.lex_state = 13},
  [38] = {.lex_state = 13},
  [39] = {.lex_state = 13},
  [40] = {.lex_state = 13},
  [41] = {.lex_state = 13},
  [42] = {.lex_state = 13},
  [43] = {.lex_state = 13},
  [44] = {.lex_state = 13},
  [45] = {.lex_state = 13},
  [46] = {.lex_state = 13},
  [47] = {.lex_state = 13},
  [48] = {.lex_state = 13},
  [49] = {.lex_state = 13},
  [50] = {.lex_state = 13},
  [51] = {.lex_state = 13},
  [52] = {.lex_state = 13},
  [53] = {.lex_state = 13},
  [54] = {.lex_state = 13},
  [55] = {.lex_state = 13},
  [56] = {.lex_state = 13},
  [57] = {.lex_state = 13},
  [58] = {.lex_state = 13},
  [59] = {.lex_state = 13},
  [60] = {.lex_state = 13},
  [61] = {.lex_state = 13},
  [62] = {.lex_state = 13},
  [63] = {.lex_state = 13},
  [64] = {.lex_state = 13},
  [65] = {.lex_state = 13},
  [66] = {.lex_state = 13},
  [67] = {.lex_state = 13},
  [68] = {.lex_state = 13},
  [69] = {.lex_state = 13},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 5},
  [72] = {.lex_state = 5},
  [73] = {.lex_state = 5},
  [74] = {.lex_state = 5},
  [75] = {.lex_state = 13},
  [76] = {.lex_state = 13},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 13},
  [79] = {.lex_state = 13},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 13},
  [82] = {.lex_state = 13},
  [83] = {.lex_state = 13},
  [84] = {.lex_state = 13},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 13},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 13},
  [90] = {.lex_state = 13},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 13},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 13},
  [108] = {.lex_state = 6},
  [109] = {.lex_state = 6},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 68},
  [112] = {.lex_state = 7},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 0},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 6},
  [121] = {.lex_state = 0},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 14},
  [124] = {.lex_state = 6},
  [125] = {.lex_state = 6},
  [126] = {.lex_state = 6},
  [127] = {.lex_state = 0},
  [128] = {.lex_state = 14},
  [129] = {.lex_state = 14},
  [130] = {.lex_state = 7},
  [131] = {.lex_state = 6},
  [132] = {.lex_state = 14},
  [133] = {.lex_state = 6},
  [134] = {.lex_state = 6},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 6},
  [138] = {.lex_state = 6},
  [139] = {.lex_state = 6},
  [140] = {.lex_state = 6},
  [141] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_open_squiggly] = ACTIONS(1),
    [sym_close_squiggly] = ACTIONS(1),
    [sym_open_square] = ACTIONS(1),
    [sym_close_square] = ACTIONS(1),
    [sym_open_arrow] = ACTIONS(1),
    [sym_close_arrow] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASHa] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHf] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHv] = ACTIONS(1),
    [anon_sym_BSLASH_QMARK] = ACTIONS(1),
    [anon_sym_BSLASH_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASHx] = ACTIONS(1),
    [anon_sym_BSLASHu] = ACTIONS(1),
    [anon_sym_BSLASHU000] = ACTIONS(1),
    [anon_sym_BSLASHU010] = ACTIONS(1),
    [sym_oct] = ACTIONS(1),
    [sym_hex] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [aux_sym_float_token1] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(3),
  },
  [1] = {
    [sym_message] = STATE(118),
    [sym_field] = STATE(79),
    [sym_message_field] = STATE(84),
    [sym_scalar_field] = STATE(84),
    [sym_field_name] = STATE(70),
    [sym_extension_name] = STATE(88),
    [sym_any_name] = STATE(88),
    [sym_comment] = STATE(1),
    [aux_sym_message_repeat1] = STATE(31),
    [sym_open_square] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_POUND] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 22,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      sym_open_squiggly,
    ACTIONS(11), 1,
      sym_open_square,
    ACTIONS(13), 1,
      sym_open_arrow,
    ACTIONS(15), 1,
      anon_sym_DOT,
    ACTIONS(17), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DASH,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(25), 1,
      anon_sym_0,
    ACTIONS(27), 1,
      aux_sym_dec_int_token1,
    STATE(2), 1,
      sym_comment,
    STATE(29), 1,
      aux_sym_scalar_value_repeat1,
    STATE(34), 1,
      sym_dec_int,
    STATE(39), 1,
      sym_string,
    STATE(51), 1,
      sym_float,
    STATE(55), 1,
      sym_float_lit,
    ACTIONS(29), 2,
      sym_oct_int,
      sym_hex_int,
    STATE(40), 2,
      sym_single_string,
      sym_double_string,
    STATE(57), 2,
      sym_signed_identifier,
      sym_number,
    STATE(65), 2,
      sym_scalar_value,
      sym_scalar_list,
    STATE(66), 2,
      sym_message_value,
      sym_message_list,
  [72] = 22,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      sym_open_squiggly,
    ACTIONS(13), 1,
      sym_open_arrow,
    ACTIONS(17), 1,
      sym_identifier,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      sym_close_square,
    ACTIONS(33), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_0,
    ACTIONS(39), 1,
      aux_sym_dec_int_token1,
    STATE(3), 1,
      sym_comment,
    STATE(29), 1,
      aux_sym_scalar_value_repeat1,
    STATE(39), 1,
      sym_string,
    STATE(51), 1,
      sym_float,
    STATE(71), 1,
      sym_dec_int,
    STATE(94), 1,
      sym_message_value,
    STATE(103), 1,
      sym_float_lit,
    STATE(104), 1,
      sym_scalar_value,
    ACTIONS(29), 2,
      sym_oct_int,
      sym_hex_int,
    STATE(40), 2,
      sym_single_string,
      sym_double_string,
    STATE(57), 2,
      sym_signed_identifier,
      sym_number,
  [142] = 11,
    ACTIONS(41), 1,
      anon_sym_SQUOTE,
    ACTIONS(43), 1,
      sym_single_string_contents,
    ACTIONS(47), 1,
      anon_sym_BSLASH,
    ACTIONS(49), 1,
      anon_sym_BSLASHx,
    ACTIONS(53), 1,
      anon_sym_BSLASHU000,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(4), 1,
      sym_comment,
    STATE(9), 1,
      aux_sym_single_string_repeat1,
    STATE(23), 1,
      sym_string_escape,
    ACTIONS(51), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    ACTIONS(45), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [186] = 11,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(57), 1,
      anon_sym_DQUOTE,
    ACTIONS(59), 1,
      sym_double_string_contents,
    ACTIONS(63), 1,
      anon_sym_BSLASH,
    ACTIONS(65), 1,
      anon_sym_BSLASHx,
    ACTIONS(69), 1,
      anon_sym_BSLASHU000,
    STATE(5), 1,
      sym_comment,
    STATE(10), 1,
      aux_sym_double_string_repeat1,
    STATE(25), 1,
      sym_string_escape,
    ACTIONS(67), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    ACTIONS(61), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [230] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(17), 1,
      sym_identifier,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      anon_sym_DOT,
    ACTIONS(35), 1,
      anon_sym_DASH,
    ACTIONS(37), 1,
      anon_sym_0,
    ACTIONS(39), 1,
      aux_sym_dec_int_token1,
    STATE(6), 1,
      sym_comment,
    STATE(29), 1,
      aux_sym_scalar_value_repeat1,
    STATE(39), 1,
      sym_string,
    STATE(51), 1,
      sym_float,
    STATE(71), 1,
      sym_dec_int,
    STATE(103), 1,
      sym_float_lit,
    STATE(106), 1,
      sym_scalar_value,
    ACTIONS(29), 2,
      sym_oct_int,
      sym_hex_int,
    STATE(40), 2,
      sym_single_string,
      sym_double_string,
    STATE(57), 2,
      sym_signed_identifier,
      sym_number,
  [288] = 11,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      sym_double_string_contents,
    ACTIONS(63), 1,
      anon_sym_BSLASH,
    ACTIONS(65), 1,
      anon_sym_BSLASHx,
    ACTIONS(69), 1,
      anon_sym_BSLASHU000,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    STATE(5), 1,
      aux_sym_double_string_repeat1,
    STATE(7), 1,
      sym_comment,
    STATE(25), 1,
      sym_string_escape,
    ACTIONS(67), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    ACTIONS(61), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [332] = 11,
    ACTIONS(43), 1,
      sym_single_string_contents,
    ACTIONS(47), 1,
      anon_sym_BSLASH,
    ACTIONS(49), 1,
      anon_sym_BSLASHx,
    ACTIONS(53), 1,
      anon_sym_BSLASHU000,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(73), 1,
      anon_sym_SQUOTE,
    STATE(4), 1,
      aux_sym_single_string_repeat1,
    STATE(8), 1,
      sym_comment,
    STATE(23), 1,
      sym_string_escape,
    ACTIONS(51), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    ACTIONS(45), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [376] = 10,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(75), 1,
      anon_sym_SQUOTE,
    ACTIONS(77), 1,
      sym_single_string_contents,
    ACTIONS(83), 1,
      anon_sym_BSLASH,
    ACTIONS(86), 1,
      anon_sym_BSLASHx,
    ACTIONS(92), 1,
      anon_sym_BSLASHU000,
    STATE(23), 1,
      sym_string_escape,
    ACTIONS(89), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    STATE(9), 2,
      sym_comment,
      aux_sym_single_string_repeat1,
    ACTIONS(80), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [418] = 10,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(95), 1,
      anon_sym_DQUOTE,
    ACTIONS(97), 1,
      sym_double_string_contents,
    ACTIONS(103), 1,
      anon_sym_BSLASH,
    ACTIONS(106), 1,
      anon_sym_BSLASHx,
    ACTIONS(112), 1,
      anon_sym_BSLASHU000,
    STATE(25), 1,
      sym_string_escape,
    ACTIONS(109), 2,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU010,
    STATE(10), 2,
      sym_comment,
      aux_sym_double_string_repeat1,
    ACTIONS(100), 10,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
  [460] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(117), 1,
      sym_oct,
    STATE(11), 1,
      sym_comment,
    ACTIONS(115), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [489] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(121), 1,
      sym_oct,
    STATE(12), 1,
      sym_comment,
    ACTIONS(119), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [518] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(123), 1,
      sym_oct,
    STATE(13), 1,
      sym_comment,
    ACTIONS(115), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [547] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(125), 1,
      sym_hex,
    STATE(14), 1,
      sym_comment,
    ACTIONS(119), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [576] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(127), 1,
      sym_hex,
    STATE(15), 1,
      sym_comment,
    ACTIONS(119), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [605] = 4,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(129), 1,
      sym_oct,
    STATE(16), 1,
      sym_comment,
    ACTIONS(119), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [634] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(17), 1,
      sym_comment,
    ACTIONS(131), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [660] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(18), 1,
      sym_comment,
    ACTIONS(133), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [686] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(19), 1,
      sym_comment,
    ACTIONS(135), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [712] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(20), 1,
      sym_comment,
    ACTIONS(131), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [738] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(21), 1,
      sym_comment,
    ACTIONS(115), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [764] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(22), 1,
      sym_comment,
    ACTIONS(133), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [790] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(23), 1,
      sym_comment,
    ACTIONS(137), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [816] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(24), 1,
      sym_comment,
    ACTIONS(139), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [842] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(25), 1,
      sym_comment,
    ACTIONS(141), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [868] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(26), 1,
      sym_comment,
    ACTIONS(135), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [894] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(27), 1,
      sym_comment,
    ACTIONS(139), 17,
      anon_sym_SQUOTE,
      sym_single_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [920] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    STATE(28), 1,
      sym_comment,
    ACTIONS(115), 17,
      anon_sym_DQUOTE,
      sym_double_string_contents,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      anon_sym_BSLASH_QMARK,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASH,
      anon_sym_BSLASHx,
      anon_sym_BSLASHu,
      anon_sym_BSLASHU000,
      anon_sym_BSLASHU010,
  [946] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(21), 1,
      anon_sym_SQUOTE,
    ACTIONS(23), 1,
      anon_sym_DQUOTE,
    STATE(29), 1,
      sym_comment,
    STATE(30), 1,
      aux_sym_scalar_value_repeat1,
    STATE(39), 1,
      sym_string,
    STATE(40), 2,
      sym_single_string,
      sym_double_string,
    ACTIONS(143), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [979] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(147), 1,
      anon_sym_SQUOTE,
    ACTIONS(150), 1,
      anon_sym_DQUOTE,
    STATE(39), 1,
      sym_string,
    STATE(30), 2,
      sym_comment,
      aux_sym_scalar_value_repeat1,
    STATE(40), 2,
      sym_single_string,
      sym_double_string,
    ACTIONS(145), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1010] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(5), 1,
      sym_open_square,
    ACTIONS(7), 1,
      sym_identifier,
    STATE(31), 1,
      sym_comment,
    STATE(32), 1,
      aux_sym_message_repeat1,
    STATE(70), 1,
      sym_field_name,
    STATE(79), 1,
      sym_field,
    STATE(84), 2,
      sym_message_field,
      sym_scalar_field,
    STATE(88), 2,
      sym_extension_name,
      sym_any_name,
    ACTIONS(153), 3,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_close_arrow,
  [1045] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(157), 1,
      sym_open_square,
    ACTIONS(160), 1,
      sym_identifier,
    STATE(70), 1,
      sym_field_name,
    STATE(79), 1,
      sym_field,
    STATE(32), 2,
      sym_comment,
      aux_sym_message_repeat1,
    STATE(84), 2,
      sym_message_field,
      sym_scalar_field,
    STATE(88), 2,
      sym_extension_name,
      sym_any_name,
    ACTIONS(155), 3,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_close_arrow,
  [1078] = 11,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(5), 1,
      sym_open_square,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(163), 1,
      sym_close_squiggly,
    STATE(31), 1,
      aux_sym_message_repeat1,
    STATE(33), 1,
      sym_comment,
    STATE(70), 1,
      sym_field_name,
    STATE(79), 1,
      sym_field,
    STATE(127), 1,
      sym_message,
    STATE(84), 2,
      sym_message_field,
      sym_scalar_field,
    STATE(88), 2,
      sym_extension_name,
      sym_any_name,
  [1114] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(167), 1,
      anon_sym_DOT,
    ACTIONS(169), 1,
      sym_identifier,
    ACTIONS(171), 1,
      aux_sym_exp_token1,
    ACTIONS(173), 1,
      aux_sym_float_token1,
    STATE(34), 1,
      sym_comment,
    STATE(54), 1,
      sym_exp,
    ACTIONS(165), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
  [1144] = 11,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(5), 1,
      sym_open_square,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(163), 1,
      sym_close_arrow,
    STATE(31), 1,
      aux_sym_message_repeat1,
    STATE(35), 1,
      sym_comment,
    STATE(70), 1,
      sym_field_name,
    STATE(79), 1,
      sym_field,
    STATE(122), 1,
      sym_message,
    STATE(84), 2,
      sym_message_field,
      sym_scalar_field,
    STATE(88), 2,
      sym_extension_name,
      sym_any_name,
  [1180] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(171), 1,
      aux_sym_exp_token1,
    ACTIONS(179), 1,
      aux_sym_float_lit_token1,
    STATE(36), 1,
      sym_comment,
    STATE(56), 1,
      sym_exp,
    ACTIONS(177), 2,
      sym_identifier,
      aux_sym_float_token1,
    ACTIONS(175), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
  [1208] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(167), 1,
      anon_sym_DOT,
    ACTIONS(171), 1,
      aux_sym_exp_token1,
    ACTIONS(173), 1,
      aux_sym_float_token1,
    ACTIONS(183), 1,
      sym_identifier,
    STATE(37), 1,
      sym_comment,
    STATE(54), 1,
      sym_exp,
    ACTIONS(181), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
  [1238] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(38), 1,
      sym_comment,
    ACTIONS(187), 3,
      sym_identifier,
      aux_sym_exp_token1,
      aux_sym_float_token1,
    ACTIONS(185), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      anon_sym_DOT,
  [1259] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(39), 1,
      sym_comment,
    ACTIONS(189), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1278] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(40), 1,
      sym_comment,
    ACTIONS(191), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1297] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(41), 1,
      sym_comment,
    ACTIONS(193), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1316] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(171), 1,
      aux_sym_exp_token1,
    STATE(42), 1,
      sym_comment,
    STATE(56), 1,
      sym_exp,
    ACTIONS(177), 2,
      sym_identifier,
      aux_sym_float_token1,
    ACTIONS(175), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
  [1341] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(43), 1,
      sym_comment,
    ACTIONS(195), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1360] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(44), 1,
      sym_comment,
    ACTIONS(197), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1379] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(45), 1,
      sym_comment,
    ACTIONS(199), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
  [1398] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(171), 1,
      aux_sym_exp_token1,
    STATE(46), 1,
      sym_comment,
    STATE(58), 1,
      sym_exp,
    ACTIONS(203), 2,
      sym_identifier,
      aux_sym_float_token1,
    ACTIONS(201), 6,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
  [1423] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(15), 1,
      anon_sym_DOT,
    ACTIONS(25), 1,
      anon_sym_0,
    ACTIONS(27), 1,
      aux_sym_dec_int_token1,
    ACTIONS(205), 1,
      sym_identifier,
    STATE(37), 1,
      sym_dec_int,
    STATE(47), 1,
      sym_comment,
    STATE(55), 1,
      sym_float_lit,
    STATE(60), 1,
      sym_float,
    ACTIONS(207), 2,
      sym_oct_int,
      sym_hex_int,
  [1455] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(33), 1,
      anon_sym_DOT,
    ACTIONS(37), 1,
      anon_sym_0,
    ACTIONS(39), 1,
      aux_sym_dec_int_token1,
    ACTIONS(205), 1,
      sym_identifier,
    STATE(48), 1,
      sym_comment,
    STATE(60), 1,
      sym_float,
    STATE(72), 1,
      sym_dec_int,
    STATE(103), 1,
      sym_float_lit,
    ACTIONS(207), 2,
      sym_oct_int,
      sym_hex_int,
  [1487] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(49), 1,
      sym_comment,
    ACTIONS(209), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1504] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(213), 1,
      aux_sym_float_token1,
    STATE(50), 1,
      sym_comment,
    ACTIONS(211), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1523] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(51), 1,
      sym_comment,
    ACTIONS(165), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1540] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(52), 1,
      sym_comment,
    ACTIONS(215), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1557] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(53), 1,
      sym_comment,
    ACTIONS(217), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1574] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(177), 1,
      aux_sym_float_token1,
    STATE(54), 1,
      sym_comment,
    ACTIONS(175), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1593] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(173), 1,
      aux_sym_float_token1,
    STATE(55), 1,
      sym_comment,
    ACTIONS(219), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1612] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(203), 1,
      aux_sym_float_token1,
    STATE(56), 1,
      sym_comment,
    ACTIONS(201), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1631] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(57), 1,
      sym_comment,
    ACTIONS(143), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1648] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(223), 1,
      aux_sym_float_token1,
    STATE(58), 1,
      sym_comment,
    ACTIONS(221), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1667] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(59), 1,
      sym_comment,
    ACTIONS(225), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1684] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(60), 1,
      sym_comment,
    ACTIONS(181), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_square,
      sym_close_arrow,
      sym_identifier,
  [1701] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(61), 1,
      sym_comment,
    ACTIONS(229), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(227), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1719] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(62), 1,
      sym_comment,
    ACTIONS(231), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1735] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(63), 1,
      sym_comment,
    ACTIONS(233), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1751] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(64), 1,
      sym_comment,
    ACTIONS(235), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1767] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(65), 1,
      sym_comment,
    ACTIONS(239), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(237), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1785] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(66), 1,
      sym_comment,
    ACTIONS(243), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(241), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1803] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(67), 1,
      sym_comment,
    ACTIONS(245), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1819] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(68), 1,
      sym_comment,
    ACTIONS(247), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1835] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(69), 1,
      sym_comment,
    ACTIONS(235), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_COMMA,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1851] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      sym_open_squiggly,
    ACTIONS(13), 1,
      sym_open_arrow,
    ACTIONS(249), 1,
      anon_sym_COLON,
    ACTIONS(251), 1,
      sym_open_square,
    STATE(70), 1,
      sym_comment,
    STATE(61), 2,
      sym_message_value,
      sym_message_list,
  [1874] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(253), 1,
      anon_sym_DOT,
    ACTIONS(255), 1,
      aux_sym_exp_token1,
    ACTIONS(257), 1,
      aux_sym_float_token1,
    STATE(71), 1,
      sym_comment,
    STATE(99), 1,
      sym_exp,
    ACTIONS(165), 2,
      anon_sym_COMMA,
      sym_close_square,
  [1897] = 7,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(253), 1,
      anon_sym_DOT,
    ACTIONS(255), 1,
      aux_sym_exp_token1,
    ACTIONS(257), 1,
      aux_sym_float_token1,
    STATE(72), 1,
      sym_comment,
    STATE(99), 1,
      sym_exp,
    ACTIONS(181), 2,
      anon_sym_COMMA,
      sym_close_square,
  [1920] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(255), 1,
      aux_sym_exp_token1,
    ACTIONS(259), 1,
      aux_sym_float_lit_token1,
    STATE(73), 1,
      sym_comment,
    STATE(97), 1,
      sym_exp,
    ACTIONS(175), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [1941] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(255), 1,
      aux_sym_exp_token1,
    STATE(74), 1,
      sym_comment,
    STATE(92), 1,
      sym_exp,
    ACTIONS(201), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [1959] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(261), 2,
      sym_close_square,
      anon_sym_SLASH,
    ACTIONS(263), 2,
      anon_sym_DOT,
      sym_identifier,
    STATE(75), 2,
      sym_comment,
      aux_sym_type_name_repeat1,
  [1975] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(76), 1,
      sym_comment,
    ACTIONS(266), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [1989] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(255), 1,
      aux_sym_exp_token1,
    STATE(77), 1,
      sym_comment,
    STATE(97), 1,
      sym_exp,
    ACTIONS(175), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [2007] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(268), 1,
      sym_close_square,
    ACTIONS(270), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      aux_sym_type_name_repeat1,
    STATE(78), 1,
      sym_comment,
    ACTIONS(272), 2,
      anon_sym_DOT,
      sym_identifier,
  [2027] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(79), 1,
      sym_comment,
    ACTIONS(274), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [2041] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(80), 1,
      sym_comment,
    ACTIONS(185), 5,
      anon_sym_COMMA,
      sym_close_square,
      anon_sym_DOT,
      aux_sym_exp_token1,
      aux_sym_float_token1,
  [2055] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(81), 1,
      sym_comment,
    ACTIONS(276), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [2069] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(278), 1,
      sym_close_square,
    ACTIONS(280), 1,
      anon_sym_SLASH,
    STATE(78), 1,
      aux_sym_type_name_repeat1,
    STATE(82), 1,
      sym_comment,
    ACTIONS(272), 2,
      anon_sym_DOT,
      sym_identifier,
  [2089] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(83), 1,
      sym_comment,
    ACTIONS(241), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [2103] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(84), 1,
      sym_comment,
    ACTIONS(282), 5,
      ts_builtin_sym_end,
      sym_close_squiggly,
      sym_open_square,
      sym_close_arrow,
      sym_identifier,
  [2117] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(85), 1,
      sym_comment,
    ACTIONS(284), 4,
      anon_sym_COLON,
      sym_open_squiggly,
      sym_open_square,
      sym_open_arrow,
  [2130] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(86), 1,
      sym_comment,
    ACTIONS(286), 4,
      anon_sym_COLON,
      sym_open_squiggly,
      sym_open_square,
      sym_open_arrow,
  [2143] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(268), 1,
      sym_close_square,
    STATE(75), 1,
      aux_sym_type_name_repeat1,
    STATE(87), 1,
      sym_comment,
    ACTIONS(272), 2,
      anon_sym_DOT,
      sym_identifier,
  [2160] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(88), 1,
      sym_comment,
    ACTIONS(288), 4,
      anon_sym_COLON,
      sym_open_squiggly,
      sym_open_square,
      sym_open_arrow,
  [2173] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(89), 1,
      sym_comment,
    ACTIONS(290), 4,
      sym_close_square,
      anon_sym_SLASH,
      anon_sym_DOT,
      sym_identifier,
  [2186] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(278), 1,
      sym_close_square,
    STATE(87), 1,
      aux_sym_type_name_repeat1,
    STATE(90), 1,
      sym_comment,
    ACTIONS(272), 2,
      anon_sym_DOT,
      sym_identifier,
  [2203] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      sym_open_squiggly,
    ACTIONS(13), 1,
      sym_open_arrow,
    ACTIONS(292), 1,
      sym_close_square,
    STATE(91), 1,
      sym_comment,
    STATE(94), 1,
      sym_message_value,
  [2222] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(92), 1,
      sym_comment,
    ACTIONS(221), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [2234] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(296), 1,
      sym_close_square,
    STATE(93), 1,
      sym_comment,
    STATE(101), 1,
      aux_sym_scalar_list_repeat1,
  [2250] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(298), 1,
      anon_sym_COMMA,
    ACTIONS(300), 1,
      sym_close_square,
    STATE(94), 1,
      sym_comment,
    STATE(96), 1,
      aux_sym_message_list_repeat1,
  [2266] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(95), 1,
      sym_comment,
    ACTIONS(211), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [2278] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(298), 1,
      anon_sym_COMMA,
    ACTIONS(302), 1,
      sym_close_square,
    STATE(96), 1,
      sym_comment,
    STATE(98), 1,
      aux_sym_message_list_repeat1,
  [2294] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(97), 1,
      sym_comment,
    ACTIONS(201), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [2306] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(304), 1,
      anon_sym_COMMA,
    ACTIONS(307), 1,
      sym_close_square,
    STATE(98), 2,
      sym_comment,
      aux_sym_message_list_repeat1,
  [2320] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(99), 1,
      sym_comment,
    ACTIONS(175), 3,
      anon_sym_COMMA,
      sym_close_square,
      aux_sym_float_token1,
  [2332] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(9), 1,
      sym_open_squiggly,
    ACTIONS(13), 1,
      sym_open_arrow,
    STATE(100), 1,
      sym_comment,
    STATE(105), 1,
      sym_message_value,
  [2348] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(309), 1,
      anon_sym_COMMA,
    ACTIONS(312), 1,
      sym_close_square,
    STATE(101), 2,
      sym_comment,
      aux_sym_scalar_list_repeat1,
  [2362] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(102), 1,
      sym_comment,
    STATE(114), 1,
      sym_type_name,
    STATE(121), 1,
      sym_domain,
  [2378] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(257), 1,
      aux_sym_float_token1,
    STATE(103), 1,
      sym_comment,
    ACTIONS(219), 2,
      anon_sym_COMMA,
      sym_close_square,
  [2392] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(294), 1,
      anon_sym_COMMA,
    ACTIONS(316), 1,
      sym_close_square,
    STATE(93), 1,
      aux_sym_scalar_list_repeat1,
    STATE(104), 1,
      sym_comment,
  [2408] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(105), 1,
      sym_comment,
    ACTIONS(307), 2,
      anon_sym_COMMA,
      sym_close_square,
  [2419] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(106), 1,
      sym_comment,
    ACTIONS(312), 2,
      anon_sym_COMMA,
      sym_close_square,
  [2430] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(318), 1,
      sym_identifier,
    STATE(107), 1,
      sym_comment,
    STATE(110), 1,
      sym_type_name,
  [2443] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(320), 1,
      sym_hex,
    STATE(108), 1,
      sym_comment,
  [2453] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(322), 1,
      sym_hex,
    STATE(109), 1,
      sym_comment,
  [2463] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(324), 1,
      sym_close_square,
    STATE(110), 1,
      sym_comment,
  [2473] = 3,
    ACTIONS(55), 1,
      anon_sym_POUND,
    ACTIONS(326), 1,
      aux_sym_comment_token1,
    STATE(111), 1,
      sym_comment,
  [2483] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(328), 1,
      sym_oct,
    STATE(112), 1,
      sym_comment,
  [2493] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(330), 1,
      sym_hex,
    STATE(113), 1,
      sym_comment,
  [2503] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      sym_close_square,
    STATE(114), 1,
      sym_comment,
  [2513] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(334), 1,
      sym_hex,
    STATE(115), 1,
      sym_comment,
  [2523] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(336), 1,
      sym_hex,
    STATE(116), 1,
      sym_comment,
  [2533] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(338), 1,
      sym_hex,
    STATE(117), 1,
      sym_comment,
  [2543] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(340), 1,
      ts_builtin_sym_end,
    STATE(118), 1,
      sym_comment,
  [2553] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(342), 1,
      sym_hex,
    STATE(119), 1,
      sym_comment,
  [2563] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(344), 1,
      sym_hex,
    STATE(120), 1,
      sym_comment,
  [2573] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(346), 1,
      anon_sym_SLASH,
    STATE(121), 1,
      sym_comment,
  [2583] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(348), 1,
      sym_close_arrow,
    STATE(122), 1,
      sym_comment,
  [2593] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(350), 1,
      aux_sym_float_lit_token1,
    STATE(123), 1,
      sym_comment,
  [2603] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(352), 1,
      sym_hex,
    STATE(124), 1,
      sym_comment,
  [2613] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(354), 1,
      sym_hex,
    STATE(125), 1,
      sym_comment,
  [2623] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(356), 1,
      sym_hex,
    STATE(126), 1,
      sym_comment,
  [2633] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(348), 1,
      sym_close_squiggly,
    STATE(127), 1,
      sym_comment,
  [2643] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(358), 1,
      aux_sym_float_lit_token1,
    STATE(128), 1,
      sym_comment,
  [2653] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(360), 1,
      aux_sym_float_lit_token1,
    STATE(129), 1,
      sym_comment,
  [2663] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(362), 1,
      sym_oct,
    STATE(130), 1,
      sym_comment,
  [2673] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(364), 1,
      sym_hex,
    STATE(131), 1,
      sym_comment,
  [2683] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(366), 1,
      aux_sym_float_lit_token1,
    STATE(132), 1,
      sym_comment,
  [2693] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(368), 1,
      sym_hex,
    STATE(133), 1,
      sym_comment,
  [2703] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(370), 1,
      sym_hex,
    STATE(134), 1,
      sym_comment,
  [2713] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(372), 1,
      sym_hex,
    STATE(135), 1,
      sym_comment,
  [2723] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(374), 1,
      sym_hex,
    STATE(136), 1,
      sym_comment,
  [2733] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(376), 1,
      sym_hex,
    STATE(137), 1,
      sym_comment,
  [2743] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(378), 1,
      sym_hex,
    STATE(138), 1,
      sym_comment,
  [2753] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      sym_hex,
    STATE(139), 1,
      sym_comment,
  [2763] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(382), 1,
      sym_hex,
    STATE(140), 1,
      sym_comment,
  [2773] = 1,
    ACTIONS(384), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 72,
  [SMALL_STATE(4)] = 142,
  [SMALL_STATE(5)] = 186,
  [SMALL_STATE(6)] = 230,
  [SMALL_STATE(7)] = 288,
  [SMALL_STATE(8)] = 332,
  [SMALL_STATE(9)] = 376,
  [SMALL_STATE(10)] = 418,
  [SMALL_STATE(11)] = 460,
  [SMALL_STATE(12)] = 489,
  [SMALL_STATE(13)] = 518,
  [SMALL_STATE(14)] = 547,
  [SMALL_STATE(15)] = 576,
  [SMALL_STATE(16)] = 605,
  [SMALL_STATE(17)] = 634,
  [SMALL_STATE(18)] = 660,
  [SMALL_STATE(19)] = 686,
  [SMALL_STATE(20)] = 712,
  [SMALL_STATE(21)] = 738,
  [SMALL_STATE(22)] = 764,
  [SMALL_STATE(23)] = 790,
  [SMALL_STATE(24)] = 816,
  [SMALL_STATE(25)] = 842,
  [SMALL_STATE(26)] = 868,
  [SMALL_STATE(27)] = 894,
  [SMALL_STATE(28)] = 920,
  [SMALL_STATE(29)] = 946,
  [SMALL_STATE(30)] = 979,
  [SMALL_STATE(31)] = 1010,
  [SMALL_STATE(32)] = 1045,
  [SMALL_STATE(33)] = 1078,
  [SMALL_STATE(34)] = 1114,
  [SMALL_STATE(35)] = 1144,
  [SMALL_STATE(36)] = 1180,
  [SMALL_STATE(37)] = 1208,
  [SMALL_STATE(38)] = 1238,
  [SMALL_STATE(39)] = 1259,
  [SMALL_STATE(40)] = 1278,
  [SMALL_STATE(41)] = 1297,
  [SMALL_STATE(42)] = 1316,
  [SMALL_STATE(43)] = 1341,
  [SMALL_STATE(44)] = 1360,
  [SMALL_STATE(45)] = 1379,
  [SMALL_STATE(46)] = 1398,
  [SMALL_STATE(47)] = 1423,
  [SMALL_STATE(48)] = 1455,
  [SMALL_STATE(49)] = 1487,
  [SMALL_STATE(50)] = 1504,
  [SMALL_STATE(51)] = 1523,
  [SMALL_STATE(52)] = 1540,
  [SMALL_STATE(53)] = 1557,
  [SMALL_STATE(54)] = 1574,
  [SMALL_STATE(55)] = 1593,
  [SMALL_STATE(56)] = 1612,
  [SMALL_STATE(57)] = 1631,
  [SMALL_STATE(58)] = 1648,
  [SMALL_STATE(59)] = 1667,
  [SMALL_STATE(60)] = 1684,
  [SMALL_STATE(61)] = 1701,
  [SMALL_STATE(62)] = 1719,
  [SMALL_STATE(63)] = 1735,
  [SMALL_STATE(64)] = 1751,
  [SMALL_STATE(65)] = 1767,
  [SMALL_STATE(66)] = 1785,
  [SMALL_STATE(67)] = 1803,
  [SMALL_STATE(68)] = 1819,
  [SMALL_STATE(69)] = 1835,
  [SMALL_STATE(70)] = 1851,
  [SMALL_STATE(71)] = 1874,
  [SMALL_STATE(72)] = 1897,
  [SMALL_STATE(73)] = 1920,
  [SMALL_STATE(74)] = 1941,
  [SMALL_STATE(75)] = 1959,
  [SMALL_STATE(76)] = 1975,
  [SMALL_STATE(77)] = 1989,
  [SMALL_STATE(78)] = 2007,
  [SMALL_STATE(79)] = 2027,
  [SMALL_STATE(80)] = 2041,
  [SMALL_STATE(81)] = 2055,
  [SMALL_STATE(82)] = 2069,
  [SMALL_STATE(83)] = 2089,
  [SMALL_STATE(84)] = 2103,
  [SMALL_STATE(85)] = 2117,
  [SMALL_STATE(86)] = 2130,
  [SMALL_STATE(87)] = 2143,
  [SMALL_STATE(88)] = 2160,
  [SMALL_STATE(89)] = 2173,
  [SMALL_STATE(90)] = 2186,
  [SMALL_STATE(91)] = 2203,
  [SMALL_STATE(92)] = 2222,
  [SMALL_STATE(93)] = 2234,
  [SMALL_STATE(94)] = 2250,
  [SMALL_STATE(95)] = 2266,
  [SMALL_STATE(96)] = 2278,
  [SMALL_STATE(97)] = 2294,
  [SMALL_STATE(98)] = 2306,
  [SMALL_STATE(99)] = 2320,
  [SMALL_STATE(100)] = 2332,
  [SMALL_STATE(101)] = 2348,
  [SMALL_STATE(102)] = 2362,
  [SMALL_STATE(103)] = 2378,
  [SMALL_STATE(104)] = 2392,
  [SMALL_STATE(105)] = 2408,
  [SMALL_STATE(106)] = 2419,
  [SMALL_STATE(107)] = 2430,
  [SMALL_STATE(108)] = 2443,
  [SMALL_STATE(109)] = 2453,
  [SMALL_STATE(110)] = 2463,
  [SMALL_STATE(111)] = 2473,
  [SMALL_STATE(112)] = 2483,
  [SMALL_STATE(113)] = 2493,
  [SMALL_STATE(114)] = 2503,
  [SMALL_STATE(115)] = 2513,
  [SMALL_STATE(116)] = 2523,
  [SMALL_STATE(117)] = 2533,
  [SMALL_STATE(118)] = 2543,
  [SMALL_STATE(119)] = 2553,
  [SMALL_STATE(120)] = 2563,
  [SMALL_STATE(121)] = 2573,
  [SMALL_STATE(122)] = 2583,
  [SMALL_STATE(123)] = 2593,
  [SMALL_STATE(124)] = 2603,
  [SMALL_STATE(125)] = 2613,
  [SMALL_STATE(126)] = 2623,
  [SMALL_STATE(127)] = 2633,
  [SMALL_STATE(128)] = 2643,
  [SMALL_STATE(129)] = 2653,
  [SMALL_STATE(130)] = 2663,
  [SMALL_STATE(131)] = 2673,
  [SMALL_STATE(132)] = 2683,
  [SMALL_STATE(133)] = 2693,
  [SMALL_STATE(134)] = 2703,
  [SMALL_STATE(135)] = 2713,
  [SMALL_STATE(136)] = 2723,
  [SMALL_STATE(137)] = 2733,
  [SMALL_STATE(138)] = 2743,
  [SMALL_STATE(139)] = 2753,
  [SMALL_STATE(140)] = 2763,
  [SMALL_STATE(141)] = 2773,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(23),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(22),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(112),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(116),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(126),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 2), SHIFT_REPEAT(120),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(25),
  [100] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(18),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(130),
  [106] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(131),
  [109] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(139),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 2), SHIFT_REPEAT(119),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 3),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 2),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [123] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [125] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [127] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 6),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 1),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 4),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_single_string_repeat1, 1),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_escape, 5),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_double_string_repeat1, 1),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_value, 1),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_scalar_value_repeat1, 2),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_scalar_value_repeat1, 2), SHIFT_REPEAT(8),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_scalar_value_repeat1, 2), SHIFT_REPEAT(7),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message, 1),
  [155] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(102),
  [160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(88),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [169] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [171] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_lit, 2),
  [177] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_lit, 2),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dec_int, 1),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dec_int, 1),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_scalar_value_repeat1, 1),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_string, 2),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_string, 3),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_single_string, 2),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_double_string, 3),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_lit, 3),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_lit, 3),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 2),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exp, 2),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exp, 2),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_value, 3),
  [217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_value, 2),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float, 1),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_lit, 4),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_lit, 4),
  [225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_signed_identifier, 2),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_field, 2),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_list, 4),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_list, 4),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_list, 2),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_field, 3),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_field, 3),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_list, 3),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_list, 3),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_name_repeat1, 2),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_name_repeat1, 2), SHIFT_REPEAT(89),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_field, 4),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_name, 2),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_domain, 2),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 1),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message_field, 4),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_name, 1),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_domain, 1),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_any_name, 5),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_extension_name, 3),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_name, 1),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_name_repeat1, 1),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_list_repeat1, 2), SHIFT_REPEAT(100),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_message_list_repeat1, 2),
  [309] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_scalar_list_repeat1, 2), SHIFT_REPEAT(6),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_scalar_list_repeat1, 2),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [326] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [340] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_textproto(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
