#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 486
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 147
#define ALIAS_COUNT 2
#define TOKEN_COUNT 85
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 24

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_alias = 2,
  anon_sym_COLON_EQ = 3,
  anon_sym_export = 4,
  anon_sym_unexport = 5,
  anon_sym_import = 6,
  anon_sym_QMARK = 7,
  anon_sym_mod = 8,
  anon_sym_AT = 9,
  anon_sym_COLON = 10,
  anon_sym_AMP_AMP = 11,
  anon_sym_LBRACK = 12,
  anon_sym_COMMA = 13,
  anon_sym_RBRACK = 14,
  anon_sym_LPAREN = 15,
  anon_sym_RPAREN = 16,
  anon_sym_DOLLAR = 17,
  anon_sym_EQ = 18,
  anon_sym_PLUS = 19,
  anon_sym_STAR = 20,
  aux_sym_shebang_line_token1 = 21,
  anon_sym_AT_DASH = 22,
  anon_sym_DASH_AT = 23,
  anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv = 24,
  aux_sym_shebang_line_token2 = 25,
  aux_sym_shebang_line_token3 = 26,
  sym_shebang_shell = 27,
  anon_sym_DASH = 28,
  anon_sym_LBRACE_LBRACE_LBRACE_LBRACE = 29,
  aux_sym__recipe_line_choice_token1 = 30,
  anon_sym_LBRACE_LBRACE = 31,
  anon_sym_RBRACE_RBRACE = 32,
  anon_sym_set = 33,
  anon_sym_shell = 34,
  anon_sym_true = 35,
  anon_sym_false = 36,
  anon_sym_if = 37,
  anon_sym_LBRACE = 38,
  anon_sym_RBRACE = 39,
  anon_sym_else = 40,
  anon_sym_assert = 41,
  anon_sym_SLASH = 42,
  anon_sym_PIPE_PIPE = 43,
  anon_sym_EQ_EQ = 44,
  anon_sym_BANG_EQ = 45,
  anon_sym_EQ_TILDE = 46,
  anon_sym_BANG_TILDE = 47,
  anon_sym_BQUOTE = 48,
  aux_sym__backtick_token1 = 49,
  anon_sym_BQUOTE_BQUOTE_BQUOTE = 50,
  aux_sym__indented_backtick_token1 = 51,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 52,
  aux_sym__indented_normal_string_token1 = 53,
  anon_sym_DQUOTE = 54,
  aux_sym__normal_string_token1 = 55,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 56,
  aux_sym__indented_raw_string_token1 = 57,
  anon_sym_SQUOTE = 58,
  aux_sym__raw_string_token1 = 59,
  anon_sym_BSLASHn = 60,
  anon_sym_BSLASHr = 61,
  anon_sym_BSLASHt = 62,
  anon_sym_BSLASH_DQUOTE = 63,
  anon_sym_BSLASH_BSLASH = 64,
  aux_sym_escape_sequence_token1 = 65,
  anon_sym_x_DQUOTE_DQUOTE_DQUOTE = 66,
  aux_sym__shell_expanded_indented_normal_string_token1 = 67,
  aux_sym__shell_expanded_indented_normal_string_token2 = 68,
  anon_sym_x_DQUOTE = 69,
  aux_sym__shell_expanded_normal_string_token1 = 70,
  aux_sym__shell_expanded_normal_string_token2 = 71,
  anon_sym_x_SQUOTE_SQUOTE_SQUOTE = 72,
  aux_sym__shell_expanded_indented_raw_string_token1 = 73,
  anon_sym_x_SQUOTE = 74,
  aux_sym__shell_expanded_raw_string_token1 = 75,
  aux_sym__shell_expanded_raw_string_token2 = 76,
  sym_shell_variable_name = 77,
  sym_escape_variable_end = 78,
  sym_expansion_long_start = 79,
  sym_expansion_long_middle = 80,
  sym_expansion_long_end = 81,
  aux_sym_comment_token1 = 82,
  sym__eol = 83,
  sym_numeric_error = 84,
  sym_file = 85,
  sym_alias = 86,
  sym_assignment = 87,
  sym_unexport = 88,
  sym_import = 89,
  sym_mod = 90,
  sym_recipe = 91,
  sym_recipe_parameters = 92,
  sym__attribute_list = 93,
  sym_attribute = 94,
  sym_recipe_parameter = 95,
  sym_variadic_parameter = 96,
  sym_recipe_dependency = 97,
  sym__recipe_dependency = 98,
  sym_recipe_body = 99,
  sym_shebang_line = 100,
  sym_recipe_line = 101,
  sym__recipe_line_choice = 102,
  sym_interpolation = 103,
  sym_setting = 104,
  sym__setting_boolean = 105,
  sym__setting_string = 106,
  sym__setting_list = 107,
  sym_boolean = 108,
  sym_expression = 109,
  sym_condition = 110,
  sym_assert_parameters = 111,
  sym_value = 112,
  sym_function_call = 113,
  sym_function_parameters = 114,
  sym_external_command = 115,
  sym__backtick = 116,
  sym__indented_backtick = 117,
  sym_string = 118,
  sym_shell_expanded_string = 119,
  sym_escape_sequence = 120,
  sym_expansion_short_start = 121,
  sym_comment = 122,
  sym__ceol = 123,
  aux_sym_file_repeat1 = 124,
  aux_sym_alias_repeat1 = 125,
  aux_sym_recipe_repeat1 = 126,
  aux_sym_recipe_parameters_repeat1 = 127,
  aux_sym__attribute_list_repeat1 = 128,
  aux_sym_recipe_dependency_repeat1 = 129,
  aux_sym_recipe_body_repeat1 = 130,
  aux_sym_shebang_line_repeat1 = 131,
  aux_sym_shebang_line_repeat2 = 132,
  aux_sym__setting_list_repeat1 = 133,
  aux_sym_function_parameters_repeat1 = 134,
  aux_sym__indented_backtick_repeat1 = 135,
  aux_sym__indented_normal_string_repeat1 = 136,
  aux_sym__normal_string_repeat1 = 137,
  aux_sym__indented_raw_string_repeat1 = 138,
  aux_sym__shell_expanded_indented_normal_string_repeat1 = 139,
  aux_sym__shell_expanded_indented_normal_string_repeat2 = 140,
  aux_sym__shell_expanded_normal_string_repeat1 = 141,
  aux_sym__shell_expanded_normal_string_repeat2 = 142,
  aux_sym__shell_expanded_indented_raw_string_repeat1 = 143,
  aux_sym__shell_expanded_indented_raw_string_repeat2 = 144,
  aux_sym__shell_expanded_raw_string_repeat1 = 145,
  aux_sym__shell_expanded_raw_string_repeat2 = 146,
  alias_sym_path = 147,
  alias_sym_regex = 148,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_alias] = "alias",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_export] = "export",
  [anon_sym_unexport] = "unexport",
  [anon_sym_import] = "import",
  [anon_sym_QMARK] = "\?",
  [anon_sym_mod] = "mod",
  [anon_sym_AT] = "@",
  [anon_sym_COLON] = ":",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [aux_sym_shebang_line_token1] = "shebang_line_token1",
  [anon_sym_AT_DASH] = "@-",
  [anon_sym_DASH_AT] = "-@",
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = "#!/usr/bin/env",
  [aux_sym_shebang_line_token2] = "shebang_line_token2",
  [aux_sym_shebang_line_token3] = "shebang_line_token3",
  [sym_shebang_shell] = "shebang_shell",
  [anon_sym_DASH] = "-",
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = "{{{{",
  [aux_sym__recipe_line_choice_token1] = "_recipe_line_choice_token1",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_set] = "set",
  [anon_sym_shell] = "shell",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_if] = "if",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_else] = "else",
  [anon_sym_assert] = "assert",
  [anon_sym_SLASH] = "/",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_BANG_TILDE] = "!~",
  [anon_sym_BQUOTE] = "`",
  [aux_sym__backtick_token1] = "content",
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = "```",
  [aux_sym__indented_backtick_token1] = "_indented_backtick_token1",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [aux_sym__indented_normal_string_token1] = "_indented_normal_string_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__normal_string_token1] = "_normal_string_token1",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [aux_sym__indented_raw_string_token1] = "_indented_raw_string_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__raw_string_token1] = "_raw_string_token1",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASH_DQUOTE] = "\\\"",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = "x\"\"\"",
  [aux_sym__shell_expanded_indented_normal_string_token1] = "_shell_expanded_indented_normal_string_token1",
  [aux_sym__shell_expanded_indented_normal_string_token2] = "_shell_expanded_indented_normal_string_token2",
  [anon_sym_x_DQUOTE] = "x\"",
  [aux_sym__shell_expanded_normal_string_token1] = "_shell_expanded_normal_string_token1",
  [aux_sym__shell_expanded_normal_string_token2] = "_shell_expanded_normal_string_token2",
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = "x'''",
  [aux_sym__shell_expanded_indented_raw_string_token1] = "_shell_expanded_indented_raw_string_token1",
  [anon_sym_x_SQUOTE] = "x'",
  [aux_sym__shell_expanded_raw_string_token1] = "_shell_expanded_raw_string_token1",
  [aux_sym__shell_expanded_raw_string_token2] = "_shell_expanded_raw_string_token2",
  [sym_shell_variable_name] = "shell_variable_name",
  [sym_escape_variable_end] = "escape_variable_end",
  [sym_expansion_long_start] = "expansion_long_start",
  [sym_expansion_long_middle] = "expansion_long_middle",
  [sym_expansion_long_end] = "expansion_long_end",
  [aux_sym_comment_token1] = "comment_token1",
  [sym__eol] = "_eol",
  [sym_numeric_error] = "numeric_error",
  [sym_file] = "file",
  [sym_alias] = "alias",
  [sym_assignment] = "assignment",
  [sym_unexport] = "unexport",
  [sym_import] = "import",
  [sym_mod] = "mod",
  [sym_recipe] = "recipe",
  [sym_recipe_parameters] = "recipe_parameters",
  [sym__attribute_list] = "_attribute_list",
  [sym_attribute] = "attribute",
  [sym_recipe_parameter] = "recipe_parameter",
  [sym_variadic_parameter] = "variadic_parameter",
  [sym_recipe_dependency] = "recipe_dependency",
  [sym__recipe_dependency] = "_recipe_dependency",
  [sym_recipe_body] = "recipe_body",
  [sym_shebang_line] = "shebang_line",
  [sym_recipe_line] = "recipe_line",
  [sym__recipe_line_choice] = "_recipe_line_choice",
  [sym_interpolation] = "interpolation",
  [sym_setting] = "setting",
  [sym__setting_boolean] = "_setting_boolean",
  [sym__setting_string] = "_setting_string",
  [sym__setting_list] = "_setting_list",
  [sym_boolean] = "boolean",
  [sym_expression] = "expression",
  [sym_condition] = "condition",
  [sym_assert_parameters] = "assert_parameters",
  [sym_value] = "value",
  [sym_function_call] = "function_call",
  [sym_function_parameters] = "function_parameters",
  [sym_external_command] = "external_command",
  [sym__backtick] = "_backtick",
  [sym__indented_backtick] = "_indented_backtick",
  [sym_string] = "string",
  [sym_shell_expanded_string] = "shell_expanded_string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_expansion_short_start] = "expansion_short_start",
  [sym_comment] = "comment",
  [sym__ceol] = "_ceol",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_alias_repeat1] = "alias_repeat1",
  [aux_sym_recipe_repeat1] = "recipe_repeat1",
  [aux_sym_recipe_parameters_repeat1] = "recipe_parameters_repeat1",
  [aux_sym__attribute_list_repeat1] = "_attribute_list_repeat1",
  [aux_sym_recipe_dependency_repeat1] = "recipe_dependency_repeat1",
  [aux_sym_recipe_body_repeat1] = "recipe_body_repeat1",
  [aux_sym_shebang_line_repeat1] = "shebang_line_repeat1",
  [aux_sym_shebang_line_repeat2] = "shebang_line_repeat2",
  [aux_sym__setting_list_repeat1] = "_setting_list_repeat1",
  [aux_sym_function_parameters_repeat1] = "function_parameters_repeat1",
  [aux_sym__indented_backtick_repeat1] = "_indented_backtick_repeat1",
  [aux_sym__indented_normal_string_repeat1] = "_indented_normal_string_repeat1",
  [aux_sym__normal_string_repeat1] = "_normal_string_repeat1",
  [aux_sym__indented_raw_string_repeat1] = "_indented_raw_string_repeat1",
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = "_shell_expanded_indented_normal_string_repeat1",
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = "_shell_expanded_indented_normal_string_repeat2",
  [aux_sym__shell_expanded_normal_string_repeat1] = "_shell_expanded_normal_string_repeat1",
  [aux_sym__shell_expanded_normal_string_repeat2] = "_shell_expanded_normal_string_repeat2",
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = "_shell_expanded_indented_raw_string_repeat1",
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = "_shell_expanded_indented_raw_string_repeat2",
  [aux_sym__shell_expanded_raw_string_repeat1] = "_shell_expanded_raw_string_repeat1",
  [aux_sym__shell_expanded_raw_string_repeat2] = "_shell_expanded_raw_string_repeat2",
  [alias_sym_path] = "path",
  [alias_sym_regex] = "regex",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_unexport] = anon_sym_unexport,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [aux_sym_shebang_line_token1] = aux_sym_shebang_line_token1,
  [anon_sym_AT_DASH] = anon_sym_AT_DASH,
  [anon_sym_DASH_AT] = anon_sym_DASH_AT,
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
  [aux_sym_shebang_line_token2] = aux_sym_shebang_line_token2,
  [aux_sym_shebang_line_token3] = aux_sym_shebang_line_token3,
  [sym_shebang_shell] = sym_shebang_shell,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
  [aux_sym__recipe_line_choice_token1] = aux_sym__recipe_line_choice_token1,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_shell] = anon_sym_shell,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ_TILDE] = anon_sym_EQ_TILDE,
  [anon_sym_BANG_TILDE] = anon_sym_BANG_TILDE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym__backtick_token1] = aux_sym__backtick_token1,
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = anon_sym_BQUOTE_BQUOTE_BQUOTE,
  [aux_sym__indented_backtick_token1] = aux_sym__indented_backtick_token1,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym__indented_normal_string_token1] = aux_sym__indented_normal_string_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__normal_string_token1] = aux_sym__normal_string_token1,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym__indented_raw_string_token1] = aux_sym__indented_raw_string_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__raw_string_token1] = aux_sym__raw_string_token1,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASH_DQUOTE] = anon_sym_BSLASH_DQUOTE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
  [aux_sym__shell_expanded_indented_normal_string_token1] = aux_sym__shell_expanded_indented_normal_string_token1,
  [aux_sym__shell_expanded_indented_normal_string_token2] = aux_sym__shell_expanded_indented_normal_string_token2,
  [anon_sym_x_DQUOTE] = anon_sym_x_DQUOTE,
  [aux_sym__shell_expanded_normal_string_token1] = aux_sym__shell_expanded_normal_string_token1,
  [aux_sym__shell_expanded_normal_string_token2] = aux_sym__shell_expanded_normal_string_token2,
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym__shell_expanded_indented_raw_string_token1] = aux_sym__shell_expanded_indented_raw_string_token1,
  [anon_sym_x_SQUOTE] = anon_sym_x_SQUOTE,
  [aux_sym__shell_expanded_raw_string_token1] = aux_sym__shell_expanded_raw_string_token1,
  [aux_sym__shell_expanded_raw_string_token2] = aux_sym__shell_expanded_raw_string_token2,
  [sym_shell_variable_name] = sym_shell_variable_name,
  [sym_escape_variable_end] = sym_escape_variable_end,
  [sym_expansion_long_start] = sym_expansion_long_start,
  [sym_expansion_long_middle] = sym_expansion_long_middle,
  [sym_expansion_long_end] = sym_expansion_long_end,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym__eol] = sym__eol,
  [sym_numeric_error] = sym_numeric_error,
  [sym_file] = sym_file,
  [sym_alias] = sym_alias,
  [sym_assignment] = sym_assignment,
  [sym_unexport] = sym_unexport,
  [sym_import] = sym_import,
  [sym_mod] = sym_mod,
  [sym_recipe] = sym_recipe,
  [sym_recipe_parameters] = sym_recipe_parameters,
  [sym__attribute_list] = sym__attribute_list,
  [sym_attribute] = sym_attribute,
  [sym_recipe_parameter] = sym_recipe_parameter,
  [sym_variadic_parameter] = sym_variadic_parameter,
  [sym_recipe_dependency] = sym_recipe_dependency,
  [sym__recipe_dependency] = sym__recipe_dependency,
  [sym_recipe_body] = sym_recipe_body,
  [sym_shebang_line] = sym_shebang_line,
  [sym_recipe_line] = sym_recipe_line,
  [sym__recipe_line_choice] = sym__recipe_line_choice,
  [sym_interpolation] = sym_interpolation,
  [sym_setting] = sym_setting,
  [sym__setting_boolean] = sym__setting_boolean,
  [sym__setting_string] = sym__setting_string,
  [sym__setting_list] = sym__setting_list,
  [sym_boolean] = sym_boolean,
  [sym_expression] = sym_expression,
  [sym_condition] = sym_condition,
  [sym_assert_parameters] = sym_assert_parameters,
  [sym_value] = sym_value,
  [sym_function_call] = sym_function_call,
  [sym_function_parameters] = sym_function_parameters,
  [sym_external_command] = sym_external_command,
  [sym__backtick] = sym__backtick,
  [sym__indented_backtick] = sym__indented_backtick,
  [sym_string] = sym_string,
  [sym_shell_expanded_string] = sym_shell_expanded_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_expansion_short_start] = sym_expansion_short_start,
  [sym_comment] = sym_comment,
  [sym__ceol] = sym__ceol,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_alias_repeat1] = aux_sym_alias_repeat1,
  [aux_sym_recipe_repeat1] = aux_sym_recipe_repeat1,
  [aux_sym_recipe_parameters_repeat1] = aux_sym_recipe_parameters_repeat1,
  [aux_sym__attribute_list_repeat1] = aux_sym__attribute_list_repeat1,
  [aux_sym_recipe_dependency_repeat1] = aux_sym_recipe_dependency_repeat1,
  [aux_sym_recipe_body_repeat1] = aux_sym_recipe_body_repeat1,
  [aux_sym_shebang_line_repeat1] = aux_sym_shebang_line_repeat1,
  [aux_sym_shebang_line_repeat2] = aux_sym_shebang_line_repeat2,
  [aux_sym__setting_list_repeat1] = aux_sym__setting_list_repeat1,
  [aux_sym_function_parameters_repeat1] = aux_sym_function_parameters_repeat1,
  [aux_sym__indented_backtick_repeat1] = aux_sym__indented_backtick_repeat1,
  [aux_sym__indented_normal_string_repeat1] = aux_sym__indented_normal_string_repeat1,
  [aux_sym__normal_string_repeat1] = aux_sym__normal_string_repeat1,
  [aux_sym__indented_raw_string_repeat1] = aux_sym__indented_raw_string_repeat1,
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = aux_sym__shell_expanded_indented_normal_string_repeat1,
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = aux_sym__shell_expanded_indented_normal_string_repeat2,
  [aux_sym__shell_expanded_normal_string_repeat1] = aux_sym__shell_expanded_normal_string_repeat1,
  [aux_sym__shell_expanded_normal_string_repeat2] = aux_sym__shell_expanded_normal_string_repeat2,
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = aux_sym__shell_expanded_indented_raw_string_repeat1,
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = aux_sym__shell_expanded_indented_raw_string_repeat2,
  [aux_sym__shell_expanded_raw_string_repeat1] = aux_sym__shell_expanded_raw_string_repeat1,
  [aux_sym__shell_expanded_raw_string_repeat2] = aux_sym__shell_expanded_raw_string_repeat2,
  [alias_sym_path] = alias_sym_path,
  [alias_sym_regex] = alias_sym_regex,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unexport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_AT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_shebang_line_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shebang_line_token3] = {
    .visible = false,
    .named = false,
  },
  [sym_shebang_shell] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__recipe_line_choice_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shell] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__backtick_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE_BQUOTE_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_backtick_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__indented_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_x_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_shell_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_variable_end] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_start] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_middle] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_long_end] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__eol] = {
    .visible = false,
    .named = true,
  },
  [sym_numeric_error] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_unexport] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute_list] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_dependency] = {
    .visible = true,
    .named = true,
  },
  [sym__recipe_dependency] = {
    .visible = false,
    .named = true,
  },
  [sym_recipe_body] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang_line] = {
    .visible = true,
    .named = true,
  },
  [sym_recipe_line] = {
    .visible = true,
    .named = true,
  },
  [sym__recipe_line_choice] = {
    .visible = false,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_setting] = {
    .visible = true,
    .named = true,
  },
  [sym__setting_boolean] = {
    .visible = false,
    .named = true,
  },
  [sym__setting_string] = {
    .visible = false,
    .named = true,
  },
  [sym__setting_list] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_external_command] = {
    .visible = true,
    .named = true,
  },
  [sym__backtick] = {
    .visible = false,
    .named = true,
  },
  [sym__indented_backtick] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_shell_expanded_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion_short_start] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__ceol] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alias_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__attribute_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_dependency_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_recipe_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shebang_line_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_shebang_line_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__setting_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_backtick_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__indented_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_normal_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_normal_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_indented_raw_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__shell_expanded_raw_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_path] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_regex] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_interpolation_marker = 1,
  field_name = 2,
  field_recipe_content = 3,
  field_shebang = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_interpolation_marker] = "interpolation_marker",
  [field_name] = "name",
  [field_recipe_content] = "recipe_content",
  [field_shebang] = "shebang",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 1, .length = 1},
  [8] = {.index = 4, .length = 1},
  [9] = {.index = 3, .length = 1},
  [11] = {.index = 5, .length = 1},
  [12] = {.index = 6, .length = 1},
  [13] = {.index = 7, .length = 1},
  [14] = {.index = 8, .length = 1},
  [16] = {.index = 9, .length = 1},
  [17] = {.index = 10, .length = 2},
  [18] = {.index = 8, .length = 1},
  [19] = {.index = 12, .length = 1},
  [20] = {.index = 13, .length = 2},
  [21] = {.index = 15, .length = 1},
  [22] = {.index = 16, .length = 1},
  [23] = {.index = 17, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 1},
  [2] =
    {field_name, 0, .inherited = true},
  [3] =
    {field_name, 2},
  [4] =
    {field_shebang, 0},
  [5] =
    {field_name, 1, .inherited = true},
  [6] =
    {field_recipe_content, 0},
  [7] =
    {field_recipe_content, 0, .inherited = true},
  [8] =
    {field_name, 3},
  [9] =
    {field_recipe_content, 1, .inherited = true},
  [10] =
    {field_recipe_content, 0, .inherited = true},
    {field_recipe_content, 1, .inherited = true},
  [12] =
    {field_recipe_content, 2, .inherited = true},
  [13] =
    {field_interpolation_marker, 0},
    {field_interpolation_marker, 2},
  [15] =
    {field_recipe_content, 3, .inherited = true},
  [16] =
    {field_recipe_content, 4, .inherited = true},
  [17] =
    {field_recipe_content, 5, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [1] = alias_sym_path,
  },
  [5] = {
    [2] = alias_sym_path,
  },
  [7] = {
    [2] = alias_sym_path,
  },
  [9] = {
    [3] = alias_sym_path,
  },
  [10] = {
    [1] = aux_sym__backtick_token1,
  },
  [15] = {
    [2] = alias_sym_regex,
  },
  [18] = {
    [4] = alias_sym_path,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_expression, 2,
    sym_expression,
    alias_sym_regex,
  sym_string, 2,
    sym_string,
    alias_sym_path,
  aux_sym__indented_backtick_repeat1, 2,
    aux_sym__indented_backtick_repeat1,
    aux_sym__backtick_token1,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 3,
  [9] = 3,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 11,
  [17] = 14,
  [18] = 14,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 19,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 28,
  [31] = 25,
  [32] = 28,
  [33] = 28,
  [34] = 25,
  [35] = 35,
  [36] = 25,
  [37] = 35,
  [38] = 27,
  [39] = 35,
  [40] = 19,
  [41] = 27,
  [42] = 42,
  [43] = 21,
  [44] = 21,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 51,
  [69] = 50,
  [70] = 52,
  [71] = 53,
  [72] = 49,
  [73] = 48,
  [74] = 74,
  [75] = 61,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 56,
  [81] = 81,
  [82] = 82,
  [83] = 57,
  [84] = 58,
  [85] = 59,
  [86] = 86,
  [87] = 87,
  [88] = 60,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 54,
  [97] = 55,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 98,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 98,
  [108] = 106,
  [109] = 106,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 111,
  [117] = 113,
  [118] = 113,
  [119] = 111,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 63,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 122,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 182,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 67,
  [199] = 66,
  [200] = 200,
  [201] = 137,
  [202] = 190,
  [203] = 194,
  [204] = 204,
  [205] = 185,
  [206] = 182,
  [207] = 190,
  [208] = 194,
  [209] = 185,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 137,
  [215] = 137,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 137,
  [234] = 137,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 53,
  [254] = 254,
  [255] = 252,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 263,
  [266] = 252,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 269,
  [273] = 270,
  [274] = 274,
  [275] = 263,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 269,
  [280] = 270,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 122,
  [285] = 51,
  [286] = 60,
  [287] = 49,
  [288] = 54,
  [289] = 289,
  [290] = 63,
  [291] = 55,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 48,
  [296] = 296,
  [297] = 50,
  [298] = 52,
  [299] = 299,
  [300] = 63,
  [301] = 301,
  [302] = 57,
  [303] = 303,
  [304] = 61,
  [305] = 58,
  [306] = 56,
  [307] = 59,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 74,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 10,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 7,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 66,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 6,
  [356] = 67,
  [357] = 357,
  [358] = 358,
  [359] = 7,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 345,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 366,
  [368] = 360,
  [369] = 369,
  [370] = 370,
  [371] = 341,
  [372] = 339,
  [373] = 369,
  [374] = 66,
  [375] = 375,
  [376] = 345,
  [377] = 6,
  [378] = 378,
  [379] = 379,
  [380] = 366,
  [381] = 67,
  [382] = 382,
  [383] = 383,
  [384] = 360,
  [385] = 369,
  [386] = 370,
  [387] = 341,
  [388] = 339,
  [389] = 370,
  [390] = 390,
  [391] = 391,
  [392] = 10,
  [393] = 393,
  [394] = 394,
  [395] = 394,
  [396] = 394,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 398,
  [412] = 398,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 417,
  [441] = 441,
  [442] = 422,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 422,
  [450] = 450,
  [451] = 451,
  [452] = 425,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 451,
  [457] = 457,
  [458] = 443,
  [459] = 459,
  [460] = 460,
  [461] = 451,
  [462] = 462,
  [463] = 443,
  [464] = 464,
  [465] = 437,
  [466] = 460,
  [467] = 437,
  [468] = 460,
  [469] = 469,
  [470] = 424,
  [471] = 471,
  [472] = 424,
  [473] = 473,
  [474] = 474,
  [475] = 417,
  [476] = 476,
  [477] = 430,
  [478] = 430,
  [479] = 425,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 152,
  [484] = 482,
  [485] = 482,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(65);
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '!', 46,
        '"', 140,
        '#', 29,
        '$', 81,
        '&', 33,
        '\'', 152,
        '(', 78,
        ')', 79,
        '*', 85,
        '+', 84,
        ',', 76,
        '-', 97,
        '/', 114,
        ':', 72,
        '=', 83,
        '?', 67,
        '@', 69,
        '[', 75,
        '\\', 30,
        ']', 77,
        '`', 121,
        'x', 206,
        '{', 112,
        '|', 51,
        '}', 205,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '!', 46,
        '"', 140,
        '#', 208,
        '&', 33,
        '\'', 152,
        '(', 78,
        ')', 79,
        ',', 76,
        '/', 114,
        '=', 47,
        '`', 121,
        'x', 206,
        '{', 111,
        '|', 51,
        '}', 113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '"', 140,
        '&', 33,
        '\'', 152,
        '(', 78,
        ')', 79,
        '+', 84,
        '/', 114,
        '`', 121,
        'x', 206,
        '|', 51,
        '}', 58,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '$') ADVANCE(80);
      if (lookahead == '*') ADVANCE(85);
      if (lookahead == '+') ADVANCE(84);
      if (lookahead == ':') ADVANCE(71);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '-') ADVANCE(60);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '-') ADVANCE(60);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '\n', 209,
        '\r', 101,
        '#', 106,
        '-', 98,
        '@', 70,
        '{', 107,
        '\t', 102,
        ' ', 102,
      );
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 10:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 11:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '-') ADVANCE(98);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 12:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 13:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(134);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(133);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 14:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(147);
      if (lookahead != 0) ADVANCE(150);
      END_STATE();
    case 15:
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(128);
      if (lookahead == '`') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(127);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 16:
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead == '\r') ADVANCE(171);
      if (lookahead == '"') ADVANCE(172);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(200);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 17:
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead == '\r') ADVANCE(171);
      if (lookahead == '"') ADVANCE(172);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(170);
      if (lookahead != 0) ADVANCE(175);
      END_STATE();
    case 18:
      if (lookahead == '\n') ADVANCE(181);
      if (lookahead == '\r') ADVANCE(182);
      if (lookahead == '"') ADVANCE(139);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      if (lookahead != 0) ADVANCE(181);
      END_STATE();
    case 19:
      if (lookahead == '\n') ADVANCE(181);
      if (lookahead == '\r') ADVANCE(182);
      if (lookahead == '"') ADVANCE(139);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0) ADVANCE(181);
      END_STATE();
    case 20:
      if (lookahead == '\n') ADVANCE(177);
      if (lookahead == '\r') ADVANCE(178);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(177);
      END_STATE();
    case 21:
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(165);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 22:
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(168);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(166);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 23:
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == '\r') ADVANCE(142);
      if (lookahead == '"') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(143);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 24:
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(197);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 25:
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(197);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\'') ADVANCE(151);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(198);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 26:
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead == '\r') ADVANCE(188);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\'') ADVANCE(189);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(201);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 27:
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead == '\r') ADVANCE(188);
      if (lookahead == '$') ADVANCE(81);
      if (lookahead == '\'') ADVANCE(189);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 28:
      if (lookahead == '\n') ADVANCE(192);
      if (lookahead == '\r') ADVANCE(193);
      if (lookahead == '\\') ADVANCE(195);
      if (lookahead == '}') ADVANCE(205);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(192);
      END_STATE();
    case 29:
      if (lookahead == '!') ADVANCE(91);
      END_STATE();
    case 30:
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(49);
      if (lookahead == '}') ADVANCE(202);
      END_STATE();
    case 31:
      if (lookahead == '"') ADVANCE(131);
      END_STATE();
    case 32:
      if (lookahead == '"') ADVANCE(162);
      END_STATE();
    case 33:
      if (lookahead == '&') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == '\'') ADVANCE(145);
      END_STATE();
    case 35:
      if (lookahead == '\'') ADVANCE(185);
      END_STATE();
    case 36:
      if (lookahead == '-') ADVANCE(204);
      END_STATE();
    case 37:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'i') ADVANCE(39);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 38:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(42);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 39:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(45);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 40:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'r') ADVANCE(44);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 41:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 's') ADVANCE(40);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 42:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == 'v') ADVANCE(89);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 43:
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 44:
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 46:
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '~') ADVANCE(119);
      END_STATE();
    case 47:
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '~') ADVANCE(118);
      END_STATE();
    case 48:
      if (lookahead == '`') ADVANCE(125);
      END_STATE();
    case 49:
      if (lookahead == '{') ADVANCE(59);
      END_STATE();
    case 50:
      if (lookahead == '{') ADVANCE(99);
      END_STATE();
    case 51:
      if (lookahead == '|') ADVANCE(115);
      END_STATE();
    case 52:
      if (lookahead == '}') ADVANCE(161);
      END_STATE();
    case 53:
      if (lookahead == '}') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == '}') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == '}') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == '}') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == '}') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == '}') ADVANCE(110);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 61:
      if (eof) ADVANCE(65);
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '!', 46,
        '"', 140,
        '#', 29,
        '$', 81,
        '&', 33,
        '\'', 152,
        '(', 78,
        ')', 79,
        '*', 85,
        '+', 84,
        ',', 76,
        '-', 97,
        '/', 114,
        ':', 73,
        '=', 83,
        '@', 69,
        '[', 75,
        '\\', 30,
        ']', 77,
        '`', 121,
        'x', 206,
        '{', 112,
        '|', 51,
        '}', 113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 62:
      if (eof) ADVANCE(65);
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '!', 46,
        '#', 208,
        '$', 80,
        '&', 33,
        '\'', 151,
        '(', 78,
        ')', 79,
        '*', 85,
        '+', 84,
        ',', 76,
        '/', 114,
        ':', 73,
        '=', 47,
        '?', 67,
        '@', 68,
        '[', 75,
        ']', 77,
        '`', 120,
        '{', 111,
        '|', 51,
        '}', 113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 63:
      if (eof) ADVANCE(65);
      ADVANCE_MAP(
        '\n', 209,
        '\r', 1,
        '!', 46,
        '#', 208,
        '$', 80,
        '&', 33,
        '\'', 151,
        '(', 78,
        ')', 79,
        '*', 85,
        '+', 84,
        ',', 76,
        '/', 114,
        ':', 73,
        '=', 47,
        '@', 68,
        '[', 75,
        ']', 77,
        '`', 120,
        '{', 111,
        '|', 51,
        '}', 113,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 64:
      if (eof) ADVANCE(65);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '@') ADVANCE(68);
      if (lookahead == '[') ADVANCE(75);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(86);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '-') ADVANCE(87);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '-') ADVANCE(87);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(100);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-') ADVANCE(204);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(66);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(203);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(116);
      if (lookahead == '~') ADVANCE(118);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_shebang_line_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(86);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_AT_DASH);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DASH_AT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_shebang_line_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_shebang_line_token3);
      if (lookahead == '/') ADVANCE(94);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_shebang_line_token3);
      if (lookahead == 'b') ADVANCE(37);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_shebang_line_token3);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_shebang_line_token3);
      if (lookahead == 'u') ADVANCE(41);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_shebang_line_token3);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(43);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_shebang_shell);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(96);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '@') ADVANCE(88);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '@') ADVANCE(88);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(100);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_LBRACE_LBRACE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\n') ADVANCE(209);
      if (lookahead != 0 &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(100);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead == '-') ADVANCE(98);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(102);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(108);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(103);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(108);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '-') ADVANCE(98);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(104);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(108);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '\r') ADVANCE(101);
      if (lookahead == '{') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(105);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n') ADVANCE(108);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '!') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(100);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead == '{') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(100);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym__recipe_line_choice_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{') ADVANCE(100);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '{') ADVANCE(50);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '{') ADVANCE(109);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_BANG_TILDE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead == '`') ADVANCE(48);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead == '\r') ADVANCE(123);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(122);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(124);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead == '\n') ADVANCE(124);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(124);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(aux_sym__backtick_token1);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_BQUOTE_BQUOTE_BQUOTE);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead == '\r') ADVANCE(128);
      if (lookahead == '`') ADVANCE(129);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(127);
      if (lookahead != 0) ADVANCE(130);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(126);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead == '`') ADVANCE(48);
      if (lookahead != 0) ADVANCE(126);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__indented_backtick_token1);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(126);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(132);
      if (lookahead == '\r') ADVANCE(134);
      if (lookahead == '"') ADVANCE(135);
      if (lookahead == '\\') ADVANCE(136);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(133);
      if (lookahead != 0) ADVANCE(138);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(132);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead != 0) ADVANCE(132);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(137);
      if (lookahead != 0) ADVANCE(132);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead == '{') ADVANCE(59);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym__indented_normal_string_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(132);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(31);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '\n') ADVANCE(141);
      if (lookahead == '\r') ADVANCE(142);
      if (lookahead == '\\') ADVANCE(144);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(143);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(141);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym__normal_string_token1);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(148);
      if (lookahead == '\'') ADVANCE(149);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(147);
      if (lookahead != 0) ADVANCE(150);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(146);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead == '\'') ADVANCE(34);
      if (lookahead != 0) ADVANCE(146);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym__indented_raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(146);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(34);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead == '\n') ADVANCE(155);
      if (lookahead == '\r') ADVANCE(154);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(155);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead == '\n') ADVANCE(155);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym__raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(155);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_BSLASH_DQUOTE);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_x_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(167);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(163);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '\n') ADVANCE(163);
      if (lookahead == '\r') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(168);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(163);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(49);
      if (lookahead == '}') ADVANCE(202);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token1);
      if (lookahead == '}') ADVANCE(202);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '\n') ADVANCE(175);
      if (lookahead == '\r') ADVANCE(171);
      if (lookahead == '"') ADVANCE(172);
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(175);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '\n') ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(169);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '"') ADVANCE(31);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(169);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(174);
      if (lookahead == '}') ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(169);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead == '{') ADVANCE(59);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_normal_string_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(169);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_x_DQUOTE);
      if (lookahead == '"') ADVANCE(32);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '\n') ADVANCE(177);
      if (lookahead == '\r') ADVANCE(178);
      if (lookahead == '\\') ADVANCE(180);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '}') ADVANCE(177);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token1);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(49);
      if (lookahead == '}') ADVANCE(202);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '\n') ADVANCE(181);
      if (lookahead == '\r') ADVANCE(182);
      if (lookahead == '\\') ADVANCE(184);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(181);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__shell_expanded_normal_string_token2);
      if (lookahead == '"') ADVANCE(159);
      if (lookahead == '\\') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(156);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == 't') ADVANCE(158);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_x_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(190);
      if (lookahead == '\r') ADVANCE(188);
      if (lookahead == '\'') ADVANCE(189);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(190);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\n') ADVANCE(186);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(186);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead == '\'') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '$') ADVANCE(186);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym__shell_expanded_indented_raw_string_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(186);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_x_SQUOTE);
      if (lookahead == '\'') ADVANCE(35);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '\n') ADVANCE(192);
      if (lookahead == '\r') ADVANCE(193);
      if (lookahead == '\\') ADVANCE(195);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '}') ADVANCE(192);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token1);
      if (lookahead == '}') ADVANCE(202);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      if (lookahead == '\n') ADVANCE(209);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym__shell_expanded_raw_string_token2);
      if (lookahead == '\n') ADVANCE(196);
      if (lookahead == '\r') ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(196);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$') ADVANCE(169);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_shell_variable_name);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'') ADVANCE(186);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_escape_variable_end);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_expansion_long_start);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_expansion_long_middle);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_expansion_long_end);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '"') ADVANCE(176);
      if (lookahead == '\'') ADVANCE(191);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym__eol);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_numeric_error);
      if (lookahead == '.') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_numeric_error);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(211);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'e', 2,
        'f', 3,
        'i', 4,
        'm', 5,
        's', 6,
        't', 7,
        'u', 8,
      );
      if (lookahead == '\t' ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      END_STATE();
    case 2:
      if (lookahead == 'l') ADVANCE(11);
      if (lookahead == 'x') ADVANCE(12);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(13);
      END_STATE();
    case 4:
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'm') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'o') ADVANCE(16);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'n') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 'i') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'p') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(25);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 15:
      if (lookahead == 'p') ADVANCE(26);
      END_STATE();
    case 16:
      if (lookahead == 'd') ADVANCE(27);
      END_STATE();
    case 17:
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 19:
      if (lookahead == 'u') ADVANCE(30);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 24:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 26:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_mod);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(38);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 31:
      if (lookahead == 'x') ADVANCE(40);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(47);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(49);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_shell);
      END_STATE();
    case 47:
      if (lookahead == 'o') ADVANCE(51);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_unexport);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 62},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 62},
  [47] = {.lex_state = 62},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 3},
  [50] = {.lex_state = 3},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 3},
  [53] = {.lex_state = 3},
  [54] = {.lex_state = 3},
  [55] = {.lex_state = 3},
  [56] = {.lex_state = 3},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 3},
  [59] = {.lex_state = 3},
  [60] = {.lex_state = 3},
  [61] = {.lex_state = 3},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 0},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 62},
  [69] = {.lex_state = 62},
  [70] = {.lex_state = 62},
  [71] = {.lex_state = 62},
  [72] = {.lex_state = 62},
  [73] = {.lex_state = 62},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 62},
  [76] = {.lex_state = 64},
  [77] = {.lex_state = 64},
  [78] = {.lex_state = 64},
  [79] = {.lex_state = 64},
  [80] = {.lex_state = 62},
  [81] = {.lex_state = 64},
  [82] = {.lex_state = 64},
  [83] = {.lex_state = 62},
  [84] = {.lex_state = 62},
  [85] = {.lex_state = 62},
  [86] = {.lex_state = 64},
  [87] = {.lex_state = 64},
  [88] = {.lex_state = 62},
  [89] = {.lex_state = 64},
  [90] = {.lex_state = 64},
  [91] = {.lex_state = 64},
  [92] = {.lex_state = 64},
  [93] = {.lex_state = 64},
  [94] = {.lex_state = 64},
  [95] = {.lex_state = 64},
  [96] = {.lex_state = 62},
  [97] = {.lex_state = 62},
  [98] = {.lex_state = 17},
  [99] = {.lex_state = 64},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 64},
  [102] = {.lex_state = 17},
  [103] = {.lex_state = 64},
  [104] = {.lex_state = 64},
  [105] = {.lex_state = 17},
  [106] = {.lex_state = 17},
  [107] = {.lex_state = 17},
  [108] = {.lex_state = 17},
  [109] = {.lex_state = 17},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 19},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 19},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 19},
  [116] = {.lex_state = 19},
  [117] = {.lex_state = 19},
  [118] = {.lex_state = 19},
  [119] = {.lex_state = 19},
  [120] = {.lex_state = 64},
  [121] = {.lex_state = 64},
  [122] = {.lex_state = 64},
  [123] = {.lex_state = 9},
  [124] = {.lex_state = 64},
  [125] = {.lex_state = 64},
  [126] = {.lex_state = 64},
  [127] = {.lex_state = 64},
  [128] = {.lex_state = 64},
  [129] = {.lex_state = 16},
  [130] = {.lex_state = 62},
  [131] = {.lex_state = 64},
  [132] = {.lex_state = 64},
  [133] = {.lex_state = 62},
  [134] = {.lex_state = 62},
  [135] = {.lex_state = 62},
  [136] = {.lex_state = 20},
  [137] = {.lex_state = 17},
  [138] = {.lex_state = 62},
  [139] = {.lex_state = 62},
  [140] = {.lex_state = 17},
  [141] = {.lex_state = 17},
  [142] = {.lex_state = 21},
  [143] = {.lex_state = 20},
  [144] = {.lex_state = 62},
  [145] = {.lex_state = 62},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 62},
  [148] = {.lex_state = 62},
  [149] = {.lex_state = 62},
  [150] = {.lex_state = 62},
  [151] = {.lex_state = 62},
  [152] = {.lex_state = 62},
  [153] = {.lex_state = 21},
  [154] = {.lex_state = 0},
  [155] = {.lex_state = 62},
  [156] = {.lex_state = 17},
  [157] = {.lex_state = 62},
  [158] = {.lex_state = 62},
  [159] = {.lex_state = 62},
  [160] = {.lex_state = 62},
  [161] = {.lex_state = 62},
  [162] = {.lex_state = 62},
  [163] = {.lex_state = 62},
  [164] = {.lex_state = 62},
  [165] = {.lex_state = 17},
  [166] = {.lex_state = 21},
  [167] = {.lex_state = 20},
  [168] = {.lex_state = 62},
  [169] = {.lex_state = 62},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 18},
  [172] = {.lex_state = 62},
  [173] = {.lex_state = 62},
  [174] = {.lex_state = 62},
  [175] = {.lex_state = 62},
  [176] = {.lex_state = 62},
  [177] = {.lex_state = 62},
  [178] = {.lex_state = 62},
  [179] = {.lex_state = 62},
  [180] = {.lex_state = 62},
  [181] = {.lex_state = 62},
  [182] = {.lex_state = 23},
  [183] = {.lex_state = 62},
  [184] = {.lex_state = 19},
  [185] = {.lex_state = 13},
  [186] = {.lex_state = 23},
  [187] = {.lex_state = 11},
  [188] = {.lex_state = 19},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 13},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 19},
  [194] = {.lex_state = 23},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 13},
  [197] = {.lex_state = 23},
  [198] = {.lex_state = 62},
  [199] = {.lex_state = 62},
  [200] = {.lex_state = 19},
  [201] = {.lex_state = 19},
  [202] = {.lex_state = 13},
  [203] = {.lex_state = 23},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 13},
  [206] = {.lex_state = 23},
  [207] = {.lex_state = 13},
  [208] = {.lex_state = 23},
  [209] = {.lex_state = 13},
  [210] = {.lex_state = 62},
  [211] = {.lex_state = 62},
  [212] = {.lex_state = 62},
  [213] = {.lex_state = 62},
  [214] = {.lex_state = 21},
  [215] = {.lex_state = 20},
  [216] = {.lex_state = 62},
  [217] = {.lex_state = 62},
  [218] = {.lex_state = 62},
  [219] = {.lex_state = 62},
  [220] = {.lex_state = 62},
  [221] = {.lex_state = 62},
  [222] = {.lex_state = 62},
  [223] = {.lex_state = 62},
  [224] = {.lex_state = 62},
  [225] = {.lex_state = 62},
  [226] = {.lex_state = 62},
  [227] = {.lex_state = 62},
  [228] = {.lex_state = 62},
  [229] = {.lex_state = 62},
  [230] = {.lex_state = 62},
  [231] = {.lex_state = 62},
  [232] = {.lex_state = 62},
  [233] = {.lex_state = 13},
  [234] = {.lex_state = 23},
  [235] = {.lex_state = 62},
  [236] = {.lex_state = 62},
  [237] = {.lex_state = 62},
  [238] = {.lex_state = 62},
  [239] = {.lex_state = 62},
  [240] = {.lex_state = 62},
  [241] = {.lex_state = 62},
  [242] = {.lex_state = 10},
  [243] = {.lex_state = 62},
  [244] = {.lex_state = 62},
  [245] = {.lex_state = 62},
  [246] = {.lex_state = 62},
  [247] = {.lex_state = 62},
  [248] = {.lex_state = 62},
  [249] = {.lex_state = 62},
  [250] = {.lex_state = 62},
  [251] = {.lex_state = 62},
  [252] = {.lex_state = 25},
  [253] = {.lex_state = 62},
  [254] = {.lex_state = 12},
  [255] = {.lex_state = 25},
  [256] = {.lex_state = 12},
  [257] = {.lex_state = 12},
  [258] = {.lex_state = 62},
  [259] = {.lex_state = 12},
  [260] = {.lex_state = 62},
  [261] = {.lex_state = 12},
  [262] = {.lex_state = 12},
  [263] = {.lex_state = 27},
  [264] = {.lex_state = 12},
  [265] = {.lex_state = 27},
  [266] = {.lex_state = 25},
  [267] = {.lex_state = 62},
  [268] = {.lex_state = 4},
  [269] = {.lex_state = 27},
  [270] = {.lex_state = 25},
  [271] = {.lex_state = 62},
  [272] = {.lex_state = 27},
  [273] = {.lex_state = 25},
  [274] = {.lex_state = 12},
  [275] = {.lex_state = 27},
  [276] = {.lex_state = 12},
  [277] = {.lex_state = 12},
  [278] = {.lex_state = 12},
  [279] = {.lex_state = 27},
  [280] = {.lex_state = 25},
  [281] = {.lex_state = 4},
  [282] = {.lex_state = 27},
  [283] = {.lex_state = 25},
  [284] = {.lex_state = 62},
  [285] = {.lex_state = 62},
  [286] = {.lex_state = 62},
  [287] = {.lex_state = 62},
  [288] = {.lex_state = 62},
  [289] = {.lex_state = 62},
  [290] = {.lex_state = 62},
  [291] = {.lex_state = 62},
  [292] = {.lex_state = 62},
  [293] = {.lex_state = 62},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 62},
  [296] = {.lex_state = 62},
  [297] = {.lex_state = 62},
  [298] = {.lex_state = 62},
  [299] = {.lex_state = 26},
  [300] = {.lex_state = 3},
  [301] = {.lex_state = 62},
  [302] = {.lex_state = 62},
  [303] = {.lex_state = 24},
  [304] = {.lex_state = 62},
  [305] = {.lex_state = 62},
  [306] = {.lex_state = 62},
  [307] = {.lex_state = 62},
  [308] = {.lex_state = 62},
  [309] = {.lex_state = 62},
  [310] = {.lex_state = 62},
  [311] = {.lex_state = 28},
  [312] = {.lex_state = 27},
  [313] = {.lex_state = 27},
  [314] = {.lex_state = 25},
  [315] = {.lex_state = 22},
  [316] = {.lex_state = 25},
  [317] = {.lex_state = 62},
  [318] = {.lex_state = 25},
  [319] = {.lex_state = 28},
  [320] = {.lex_state = 62},
  [321] = {.lex_state = 62},
  [322] = {.lex_state = 62},
  [323] = {.lex_state = 62},
  [324] = {.lex_state = 22},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 62},
  [327] = {.lex_state = 27},
  [328] = {.lex_state = 22},
  [329] = {.lex_state = 25},
  [330] = {.lex_state = 28},
  [331] = {.lex_state = 27},
  [332] = {.lex_state = 3},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 62},
  [335] = {.lex_state = 62},
  [336] = {.lex_state = 62},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 62},
  [339] = {.lex_state = 62},
  [340] = {.lex_state = 62},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 62},
  [343] = {.lex_state = 62},
  [344] = {.lex_state = 62},
  [345] = {.lex_state = 14},
  [346] = {.lex_state = 14},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 62},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 62},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 12},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 3},
  [356] = {.lex_state = 3},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 62},
  [359] = {.lex_state = 3},
  [360] = {.lex_state = 15},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 12},
  [363] = {.lex_state = 14},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 14},
  [367] = {.lex_state = 14},
  [368] = {.lex_state = 15},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 15},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 62},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 3},
  [375] = {.lex_state = 5},
  [376] = {.lex_state = 14},
  [377] = {.lex_state = 62},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 3},
  [380] = {.lex_state = 14},
  [381] = {.lex_state = 62},
  [382] = {.lex_state = 62},
  [383] = {.lex_state = 12},
  [384] = {.lex_state = 15},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 15},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 62},
  [389] = {.lex_state = 15},
  [390] = {.lex_state = 62},
  [391] = {.lex_state = 15},
  [392] = {.lex_state = 62},
  [393] = {.lex_state = 62},
  [394] = {.lex_state = 62},
  [395] = {.lex_state = 62},
  [396] = {.lex_state = 62},
  [397] = {.lex_state = 62},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 5},
  [400] = {.lex_state = 62},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 5},
  [403] = {.lex_state = 15},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 62},
  [406] = {.lex_state = 5},
  [407] = {.lex_state = 62},
  [408] = {.lex_state = 5},
  [409] = {.lex_state = 0},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 62},
  [414] = {.lex_state = 62},
  [415] = {.lex_state = 62},
  [416] = {.lex_state = 8},
  [417] = {.lex_state = 62},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 62},
  [420] = {.lex_state = 62},
  [421] = {.lex_state = 62},
  [422] = {.lex_state = 62},
  [423] = {.lex_state = 62},
  [424] = {.lex_state = 62},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 62},
  [427] = {.lex_state = 8},
  [428] = {.lex_state = 62},
  [429] = {.lex_state = 62},
  [430] = {.lex_state = 62},
  [431] = {.lex_state = 8},
  [432] = {.lex_state = 8},
  [433] = {.lex_state = 62},
  [434] = {.lex_state = 5},
  [435] = {.lex_state = 62},
  [436] = {.lex_state = 62},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 62},
  [440] = {.lex_state = 62},
  [441] = {.lex_state = 62},
  [442] = {.lex_state = 62},
  [443] = {.lex_state = 122},
  [444] = {.lex_state = 62},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 62},
  [448] = {.lex_state = 62},
  [449] = {.lex_state = 62},
  [450] = {.lex_state = 5},
  [451] = {.lex_state = 153},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 62},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 62},
  [456] = {.lex_state = 153},
  [457] = {.lex_state = 62},
  [458] = {.lex_state = 122},
  [459] = {.lex_state = 8},
  [460] = {.lex_state = 62},
  [461] = {.lex_state = 153},
  [462] = {.lex_state = 62},
  [463] = {.lex_state = 122},
  [464] = {.lex_state = 8},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 62},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 62},
  [469] = {.lex_state = 62},
  [470] = {.lex_state = 62},
  [471] = {.lex_state = 8},
  [472] = {.lex_state = 62},
  [473] = {.lex_state = 62},
  [474] = {.lex_state = 8},
  [475] = {.lex_state = 62},
  [476] = {.lex_state = 62},
  [477] = {.lex_state = 62},
  [478] = {.lex_state = 62},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 62},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_unexport] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT_DASH] = ACTIONS(1),
    [anon_sym_DASH_AT] = ACTIONS(1),
    [anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv] = ACTIONS(1),
    [aux_sym_shebang_line_token3] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_shell] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_BANG_TILDE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE_BQUOTE_BQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASH_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [anon_sym_x_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [anon_sym_x_DQUOTE] = ACTIONS(1),
    [anon_sym_x_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_x_SQUOTE] = ACTIONS(1),
    [sym_escape_variable_end] = ACTIONS(1),
    [sym_expansion_long_start] = ACTIONS(1),
    [sym_expansion_long_middle] = ACTIONS(1),
    [sym_expansion_long_end] = ACTIONS(1),
    [sym__eol] = ACTIONS(3),
    [sym_numeric_error] = ACTIONS(1),
  },
  [1] = {
    [sym_file] = STATE(418),
    [sym_alias] = STATE(47),
    [sym_assignment] = STATE(47),
    [sym_unexport] = STATE(47),
    [sym_import] = STATE(47),
    [sym_mod] = STATE(47),
    [sym_recipe] = STATE(47),
    [sym__attribute_list] = STATE(246),
    [sym_setting] = STATE(47),
    [sym_comment] = STATE(47),
    [aux_sym_file_repeat1] = STATE(47),
    [aux_sym_alias_repeat1] = STATE(246),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_alias] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_unexport] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_mod] = ACTIONS(17),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_LBRACK] = ACTIONS(21),
    [anon_sym_set] = ACTIONS(23),
    [aux_sym_comment_token1] = ACTIONS(25),
    [sym__eol] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_RPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(5), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(63), 1,
      sym_value,
    STATE(65), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [76] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(294), 1,
      sym_expression,
    STATE(479), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [152] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(91), 1,
      sym_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    ACTIONS(99), 1,
      anon_sym_if,
    ACTIONS(102), 1,
      anon_sym_assert,
    ACTIONS(105), 1,
      anon_sym_SLASH,
    ACTIONS(108), 1,
      anon_sym_BQUOTE,
    ACTIONS(111), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(114), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(117), 1,
      anon_sym_DQUOTE,
    ACTIONS(120), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(126), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(129), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(132), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(135), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(138), 1,
      sym_numeric_error,
    STATE(4), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(63), 1,
      sym_value,
    STATE(65), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [228] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(4), 1,
      aux_sym_recipe_dependency_repeat1,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(63), 1,
      sym_value,
    STATE(65), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [304] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(143), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(145), 18,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [338] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(147), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(149), 18,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [372] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(151), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(294), 1,
      sym_expression,
    STATE(452), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [448] = 24,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(294), 1,
      sym_expression,
    STATE(425), 1,
      sym_function_parameters,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [524] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(155), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(157), 18,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [558] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(477), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [631] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(430), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [704] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(325), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [777] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(437), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [850] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(325), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [923] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(478), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [996] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(465), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1069] = 23,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(271), 1,
      sym_expression,
    STATE(467), 1,
      sym_condition,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1142] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(371), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1212] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(323), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1282] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(396), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1352] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(289), 1,
      sym_expression,
    STATE(290), 1,
      sym_value,
    STATE(291), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(288), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1422] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(379), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1492] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(341), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1562] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(290), 1,
      sym_value,
    STATE(381), 1,
      sym_expression,
    STATE(291), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(288), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1632] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(325), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1702] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(339), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1772] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(199), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1842] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(290), 1,
      sym_value,
    STATE(296), 1,
      sym_expression,
    STATE(291), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(288), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1912] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(63), 1,
      sym_value,
    STATE(66), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [1982] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(198), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2052] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(290), 1,
      sym_value,
    STATE(348), 1,
      sym_expression,
    STATE(291), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(288), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2122] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(374), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2192] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(37), 1,
      anon_sym_SLASH,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(63), 1,
      sym_value,
    STATE(67), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2262] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(373), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2332] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_LPAREN,
    ACTIONS(39), 1,
      anon_sym_BQUOTE,
    ACTIONS(41), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(43), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(53), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(55), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(57), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(59), 1,
      sym_numeric_error,
    ACTIONS(195), 1,
      anon_sym_if,
    ACTIONS(197), 1,
      anon_sym_assert,
    ACTIONS(199), 1,
      anon_sym_SLASH,
    STATE(51), 1,
      sym_shell_expanded_string,
    STATE(300), 1,
      sym_value,
    STATE(356), 1,
      sym_expression,
    STATE(55), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(54), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2402] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(369), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2472] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(372), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2542] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(385), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2612] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(387), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2682] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(388), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2752] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(163), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_LPAREN,
    ACTIONS(167), 1,
      anon_sym_if,
    ACTIONS(169), 1,
      anon_sym_assert,
    ACTIONS(171), 1,
      anon_sym_SLASH,
    ACTIONS(173), 1,
      anon_sym_BQUOTE,
    ACTIONS(175), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(193), 1,
      sym_numeric_error,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(290), 1,
      sym_value,
    STATE(293), 1,
      sym_expression,
    STATE(291), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(288), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2822] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(394), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2892] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(395), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [2962] = 22,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(33), 1,
      anon_sym_if,
    ACTIONS(35), 1,
      anon_sym_assert,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(67), 1,
      anon_sym_SLASH,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(130), 1,
      sym_value,
    STATE(322), 1,
      sym_expression,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3032] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(201), 1,
      ts_builtin_sym_end,
    ACTIONS(203), 1,
      sym_identifier,
    ACTIONS(206), 1,
      anon_sym_alias,
    ACTIONS(209), 1,
      anon_sym_export,
    ACTIONS(212), 1,
      anon_sym_unexport,
    ACTIONS(215), 1,
      anon_sym_import,
    ACTIONS(218), 1,
      anon_sym_mod,
    ACTIONS(221), 1,
      anon_sym_AT,
    ACTIONS(224), 1,
      anon_sym_LBRACK,
    ACTIONS(227), 1,
      anon_sym_set,
    ACTIONS(230), 1,
      aux_sym_comment_token1,
    STATE(246), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    STATE(46), 9,
      sym_alias,
      sym_assignment,
      sym_unexport,
      sym_import,
      sym_mod,
      sym_recipe,
      sym_setting,
      sym_comment,
      aux_sym_file_repeat1,
  [3084] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_alias,
    ACTIONS(11), 1,
      anon_sym_export,
    ACTIONS(13), 1,
      anon_sym_unexport,
    ACTIONS(15), 1,
      anon_sym_import,
    ACTIONS(17), 1,
      anon_sym_mod,
    ACTIONS(19), 1,
      anon_sym_AT,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(23), 1,
      anon_sym_set,
    ACTIONS(25), 1,
      aux_sym_comment_token1,
    ACTIONS(233), 1,
      ts_builtin_sym_end,
    STATE(246), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    STATE(46), 9,
      sym_alias,
      sym_assignment,
      sym_unexport,
      sym_import,
      sym_mod,
      sym_recipe,
      sym_setting,
      sym_comment,
      aux_sym_file_repeat1,
  [3136] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(235), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(237), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3165] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(239), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(241), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3194] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(243), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(245), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3223] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(247), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(249), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3252] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(251), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(253), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3281] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(259), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(257), 12,
      anon_sym_AMP_AMP,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3312] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(255), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(257), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3341] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(261), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(263), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3370] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(265), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(267), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3399] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(269), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(271), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3428] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(273), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(275), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3457] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(277), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(279), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3486] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(281), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(283), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3515] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(285), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(287), 13,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_RBRACE_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3544] = 18,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(292), 1,
      sym_value,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3602] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(289), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(291), 10,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3632] = 18,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_BQUOTE,
    ACTIONS(71), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(89), 1,
      sym_numeric_error,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(301), 1,
      sym_value,
    STATE(97), 2,
      sym__backtick,
      sym__indented_backtick,
    STATE(96), 3,
      sym_function_call,
      sym_external_command,
      sym_string,
  [3690] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(295), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(297), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3719] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(299), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(301), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3748] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(293), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(143), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(145), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3777] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(249), 17,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3800] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(245), 17,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3823] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(253), 17,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3846] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(303), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3871] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(241), 17,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3894] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(237), 17,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3917] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(305), 8,
      anon_sym_if,
      anon_sym_assert,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      anon_sym_x_DQUOTE,
      anon_sym_x_SQUOTE,
      sym_identifier,
    ACTIONS(307), 9,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
      sym_numeric_error,
  [3942] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(287), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [3964] = 7,
    ACTIONS(309), 1,
      ts_builtin_sym_end,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    STATE(101), 1,
      sym_shebang_line,
    STATE(177), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(311), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [3996] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(317), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(173), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(319), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4028] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(321), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(151), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(323), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4060] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(325), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(175), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(327), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4092] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(267), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4114] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(329), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(149), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(331), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4146] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(333), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(179), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(335), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4178] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(271), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4200] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(275), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4222] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(279), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4244] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(337), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(162), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(339), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4276] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(341), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(145), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(343), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4308] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(283), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4330] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(345), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(161), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(347), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4362] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(349), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(180), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(351), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4394] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(353), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(168), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(355), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4426] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(357), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(169), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(359), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4458] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(361), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(163), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(363), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4490] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(365), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(144), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(367), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4522] = 7,
    ACTIONS(313), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(369), 1,
      ts_builtin_sym_end,
    STATE(101), 1,
      sym_shebang_line,
    STATE(172), 1,
      sym_recipe_body,
    STATE(99), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(371), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4554] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(257), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4576] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(263), 16,
      anon_sym_COLON,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
      sym_identifier,
  [4598] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(375), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(379), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(108), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4630] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(383), 1,
      ts_builtin_sym_end,
    ACTIONS(387), 1,
      aux_sym_shebang_line_token1,
    STATE(104), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(385), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4656] = 14,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(389), 1,
      anon_sym_LBRACK,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(419), 1,
      sym_string,
    STATE(448), 1,
      sym_boolean,
    ACTIONS(391), 2,
      anon_sym_true,
      anon_sym_false,
  [4700] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(387), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(393), 1,
      ts_builtin_sym_end,
    STATE(103), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(395), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4726] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    ACTIONS(397), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(399), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(109), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4758] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(387), 1,
      aux_sym_shebang_line_token1,
    ACTIONS(401), 1,
      ts_builtin_sym_end,
    STATE(104), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(403), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4784] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(405), 1,
      ts_builtin_sym_end,
    ACTIONS(409), 1,
      aux_sym_shebang_line_token1,
    STATE(104), 2,
      sym_recipe_line,
      aux_sym_recipe_body_repeat1,
    ACTIONS(407), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [4810] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(412), 1,
      anon_sym_DOLLAR,
    ACTIONS(415), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(423), 1,
      sym_expansion_long_start,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(420), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(105), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(417), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4842] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    ACTIONS(426), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(428), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(105), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4874] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    ACTIONS(430), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(432), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(106), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4906] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    ACTIONS(434), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(428), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(105), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4938] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(373), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      sym_expansion_long_start,
    ACTIONS(436), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(474), 1,
      sym_expansion_short_start,
    ACTIONS(428), 2,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
    STATE(105), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat2,
    ACTIONS(377), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [4970] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(440), 1,
      sym__eol,
    STATE(133), 1,
      sym__ceol,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(350), 1,
      sym_string,
    STATE(484), 1,
      sym_comment,
  [5013] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(446), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5044] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(450), 1,
      sym__eol,
    STATE(139), 1,
      sym__ceol,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(338), 1,
      sym_string,
    STATE(484), 1,
      sym_comment,
  [5087] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    ACTIONS(452), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(111), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5118] = 14,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(454), 1,
      sym__eol,
    STATE(155), 1,
      sym__ceol,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(393), 1,
      sym_string,
    STATE(484), 1,
      sym_comment,
  [5161] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(456), 1,
      anon_sym_DOLLAR,
    ACTIONS(459), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(467), 1,
      sym_expansion_long_start,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(461), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5192] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(426), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(446), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5223] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(375), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    ACTIONS(470), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(119), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5254] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(430), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    ACTIONS(472), 1,
      aux_sym__shell_expanded_normal_string_token2,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(116), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5285] = 8,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(442), 1,
      anon_sym_DOLLAR,
    ACTIONS(446), 1,
      aux_sym__shell_expanded_normal_string_token2,
    ACTIONS(448), 1,
      sym_expansion_long_start,
    STATE(427), 1,
      sym_expansion_short_start,
    STATE(115), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat2,
    ACTIONS(444), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5316] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(474), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(476), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5336] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(478), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(480), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5356] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(482), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(484), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5376] = 9,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(490), 1,
      anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
    ACTIONS(492), 1,
      aux_sym_shebang_line_token3,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(264), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(486), 2,
      anon_sym_AT,
      anon_sym_DASH,
    ACTIONS(488), 2,
      anon_sym_AT_DASH,
      anon_sym_DASH_AT,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [5408] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(498), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(500), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5428] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(502), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(504), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5448] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(506), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(508), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5468] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(510), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(512), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5488] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(514), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(516), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5508] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(520), 1,
      sym_shell_variable_name,
    ACTIONS(518), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5528] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 10,
      anon_sym_AMP_AMP,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [5548] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(524), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(526), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5568] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(524), 2,
      ts_builtin_sym_end,
      aux_sym_shebang_line_token1,
    ACTIONS(526), 10,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_set,
      sym_identifier,
      aux_sym_comment_token1,
  [5588] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(528), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(530), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5607] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(482), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(484), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5626] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(532), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(534), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5645] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(540), 1,
      sym_expansion_long_end,
    ACTIONS(538), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(143), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(536), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5668] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(542), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5685] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(544), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(546), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5704] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(548), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(550), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5723] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(415), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5740] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(552), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [5757] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(558), 1,
      sym_expansion_long_end,
    ACTIONS(556), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(166), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(554), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5780] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(562), 1,
      sym_expansion_long_end,
    ACTIONS(560), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(167), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(536), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [5803] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(353), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(355), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5822] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(349), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(351), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5841] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(564), 1,
      anon_sym_RBRACK,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(404), 1,
      sym_string,
  [5878] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(566), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(568), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5897] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(570), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(572), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5916] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(325), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(327), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5935] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(574), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(576), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5954] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(365), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(367), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5973] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(578), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(580), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [5992] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(584), 1,
      sym_expansion_long_end,
    ACTIONS(582), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(142), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(554), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6015] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(586), 1,
      anon_sym_QMARK,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(344), 1,
      sym_string,
  [6052] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(588), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(590), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6071] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(592), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [6088] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(594), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(596), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6107] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(598), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(600), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6126] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(602), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(604), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6145] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(606), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(608), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6164] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(309), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(311), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6183] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(610), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(612), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6202] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(341), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(343), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6221] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(614), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(616), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6240] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(618), 11,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token2,
      sym_escape_variable_end,
      sym_expansion_long_start,
  [6257] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(626), 1,
      sym_expansion_long_end,
    ACTIONS(623), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
    STATE(166), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_indented_normal_string_repeat1,
    ACTIONS(620), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6280] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(634), 1,
      sym_expansion_long_end,
    ACTIONS(631), 2,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
    STATE(167), 2,
      sym_escape_sequence,
      aux_sym__shell_expanded_normal_string_repeat1,
    ACTIONS(628), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6303] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(333), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(335), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6322] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(636), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(638), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6341] = 12,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    ACTIONS(640), 1,
      anon_sym_RBRACK,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(404), 1,
      sym_string,
  [6378] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(644), 1,
      sym_shell_variable_name,
    ACTIONS(642), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6397] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(329), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(331), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6416] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(369), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(371), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6435] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(646), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(648), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6454] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(337), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(339), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6473] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(650), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(652), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6492] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(361), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(363), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6511] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(654), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(656), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6530] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(357), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(359), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6549] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(658), 4,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_LBRACK,
      aux_sym_comment_token1,
    ACTIONS(660), 7,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_unexport,
      anon_sym_import,
      anon_sym_mod,
      anon_sym_set,
      sym_identifier,
  [6568] = 10,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(664), 1,
      anon_sym_COLON_EQ,
    ACTIONS(666), 1,
      anon_sym_COLON,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    STATE(251), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(308), 1,
      sym_recipe_parameter,
    STATE(415), 1,
      sym_variadic_parameter,
    STATE(469), 1,
      sym_recipe_parameters,
    ACTIONS(670), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [6600] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(672), 1,
      anon_sym_DQUOTE,
    ACTIONS(674), 1,
      aux_sym__normal_string_token1,
    STATE(197), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6622] = 10,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(678), 1,
      anon_sym_COLON_EQ,
    ACTIONS(680), 1,
      anon_sym_COLON,
    STATE(251), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(308), 1,
      sym_recipe_parameter,
    STATE(415), 1,
      sym_variadic_parameter,
    STATE(462), 1,
      sym_recipe_parameters,
    ACTIONS(670), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [6654] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(682), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6670] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(684), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(686), 1,
      aux_sym__indented_normal_string_token1,
    STATE(196), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6692] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(674), 1,
      aux_sym__normal_string_token1,
    ACTIONS(684), 1,
      anon_sym_DQUOTE,
    STATE(197), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6714] = 6,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(264), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
    ACTIONS(486), 4,
      anon_sym_AT,
      anon_sym_AT_DASH,
      anon_sym_DASH_AT,
      anon_sym_DASH,
  [6738] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(690), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6754] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(177), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(179), 1,
      anon_sym_DQUOTE,
    ACTIONS(181), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(183), 1,
      anon_sym_SQUOTE,
    ACTIONS(185), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(189), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(191), 1,
      anon_sym_x_SQUOTE,
    STATE(285), 1,
      sym_shell_expanded_string,
    STATE(334), 1,
      sym_string,
  [6788] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(692), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(694), 1,
      aux_sym__indented_normal_string_token1,
    STATE(185), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6810] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(409), 1,
      sym_string,
  [6844] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(438), 1,
      sym_string,
  [6878] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(696), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [6894] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(692), 1,
      anon_sym_DQUOTE,
    ACTIONS(698), 1,
      aux_sym__normal_string_token1,
    STATE(186), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6916] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(404), 1,
      sym_string,
  [6950] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(700), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(702), 1,
      aux_sym__indented_normal_string_token1,
    STATE(196), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(705), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6972] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(708), 1,
      anon_sym_DQUOTE,
    ACTIONS(710), 1,
      aux_sym__normal_string_token1,
    STATE(197), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(713), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [6994] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(145), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [7012] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(301), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [7030] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(459), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [7046] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(542), 10,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token2,
      sym_expansion_long_start,
  [7062] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(716), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(718), 1,
      aux_sym__indented_normal_string_token1,
    STATE(205), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7084] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(716), 1,
      anon_sym_DQUOTE,
    ACTIONS(720), 1,
      aux_sym__normal_string_token1,
    STATE(206), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7106] = 11,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(73), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(75), 1,
      anon_sym_DQUOTE,
    ACTIONS(77), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(79), 1,
      anon_sym_SQUOTE,
    ACTIONS(81), 1,
      anon_sym_x_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(83), 1,
      anon_sym_x_DQUOTE,
    ACTIONS(85), 1,
      anon_sym_x_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_x_SQUOTE,
    STATE(68), 1,
      sym_shell_expanded_string,
    STATE(357), 1,
      sym_string,
  [7140] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(686), 1,
      aux_sym__indented_normal_string_token1,
    ACTIONS(722), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(196), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7162] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(674), 1,
      aux_sym__normal_string_token1,
    ACTIONS(722), 1,
      anon_sym_DQUOTE,
    STATE(197), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7184] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(724), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(726), 1,
      aux_sym__indented_normal_string_token1,
    STATE(209), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7206] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(724), 1,
      anon_sym_DQUOTE,
    ACTIONS(728), 1,
      aux_sym__normal_string_token1,
    STATE(182), 2,
      sym_escape_sequence,
      aux_sym__normal_string_repeat1,
    ACTIONS(676), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7228] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(672), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(686), 1,
      aux_sym__indented_normal_string_token1,
    STATE(196), 2,
      sym_escape_sequence,
      aux_sym__indented_normal_string_repeat1,
    ACTIONS(688), 6,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7250] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_AMP_AMP,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      sym__eol,
    STATE(95), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7279] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_AMP_AMP,
    ACTIONS(740), 1,
      sym__eol,
    STATE(89), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(219), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7308] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_AMP_AMP,
    ACTIONS(744), 1,
      sym__eol,
    STATE(94), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(222), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7337] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(746), 1,
      anon_sym_AMP_AMP,
    ACTIONS(748), 1,
      sym__eol,
    STATE(81), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7366] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(750), 1,
      sym_expansion_long_end,
    ACTIONS(542), 8,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [7383] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(750), 1,
      sym_expansion_long_end,
    ACTIONS(542), 8,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
      aux_sym__shell_expanded_normal_string_token1,
      sym_escape_variable_end,
  [7400] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(732), 1,
      anon_sym_AMP_AMP,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      sym__eol,
    STATE(95), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(213), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7429] = 9,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(752), 1,
      anon_sym_COLON,
    STATE(251), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(308), 1,
      sym_recipe_parameter,
    STATE(415), 1,
      sym_variadic_parameter,
    STATE(435), 1,
      sym_recipe_parameters,
    ACTIONS(670), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7458] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(754), 1,
      anon_sym_AMP_AMP,
    ACTIONS(756), 1,
      sym__eol,
    STATE(93), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7487] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_AMP_AMP,
    ACTIONS(760), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7516] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_AMP_AMP,
    ACTIONS(760), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(218), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7545] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_AMP_AMP,
    ACTIONS(764), 1,
      sym__eol,
    STATE(78), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(225), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7574] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(766), 1,
      anon_sym_AMP_AMP,
    ACTIONS(768), 1,
      sym__eol,
    STATE(91), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7603] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(770), 1,
      anon_sym_AMP_AMP,
    ACTIONS(772), 1,
      sym__eol,
    STATE(77), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(210), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7632] = 9,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(774), 1,
      anon_sym_COLON,
    STATE(251), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(308), 1,
      sym_recipe_parameter,
    STATE(415), 1,
      sym_variadic_parameter,
    STATE(469), 1,
      sym_recipe_parameters,
    ACTIONS(670), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [7661] = 9,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_AMP_AMP,
    ACTIONS(744), 1,
      sym__eol,
    STATE(94), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7690] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(778), 1,
      anon_sym_AT,
    ACTIONS(780), 1,
      anon_sym_LBRACK,
    STATE(226), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
    ACTIONS(776), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [7710] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(748), 1,
      sym__eol,
    STATE(81), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(243), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7736] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(783), 1,
      sym__eol,
    STATE(87), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7762] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(783), 1,
      sym__eol,
    STATE(87), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(232), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7788] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      sym__eol,
    STATE(76), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(239), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7814] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(736), 1,
      sym__eol,
    STATE(95), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(245), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7840] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(785), 1,
      sym__eol,
    STATE(90), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7866] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(542), 8,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
      aux_sym__indented_normal_string_token1,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7880] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(542), 8,
      anon_sym_DQUOTE,
      aux_sym__normal_string_token1,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASH_DQUOTE,
      anon_sym_BSLASH_BSLASH,
      aux_sym_escape_sequence_token1,
  [7894] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(768), 1,
      sym__eol,
    STATE(91), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7920] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      sym__eol,
    STATE(82), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7946] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      sym__eol,
    STATE(82), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(247), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7972] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(744), 1,
      sym__eol,
    STATE(94), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(235), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [7998] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(756), 1,
      sym__eol,
    STATE(93), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8024] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(768), 1,
      sym__eol,
    STATE(91), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(236), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8050] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(789), 1,
      sym__eol,
    STATE(86), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8076] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(791), 1,
      anon_sym_POUND_BANG_SLASHusr_SLASHbin_SLASHenv,
    ACTIONS(793), 1,
      aux_sym_shebang_line_token3,
    STATE(277), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8100] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__eol,
    STATE(79), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8126] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(756), 1,
      sym__eol,
    STATE(93), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(228), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8152] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(748), 1,
      sym__eol,
    STATE(81), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8178] = 8,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(797), 1,
      sym_identifier,
    ACTIONS(799), 1,
      anon_sym_alias,
    ACTIONS(801), 1,
      anon_sym_export,
    ACTIONS(803), 1,
      anon_sym_mod,
    ACTIONS(805), 1,
      anon_sym_AT,
    STATE(226), 2,
      sym__attribute_list,
      aux_sym_alias_repeat1,
  [8204] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(807), 1,
      sym__eol,
    STATE(92), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8230] = 8,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(730), 1,
      sym_identifier,
    ACTIONS(734), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__eol,
    STATE(79), 1,
      sym__ceol,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(485), 1,
      sym_comment,
    STATE(241), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
  [8256] = 5,
    ACTIONS(809), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_LPAREN,
    STATE(321), 1,
      sym__recipe_dependency,
    STATE(249), 2,
      sym_recipe_dependency,
      aux_sym_recipe_repeat1,
    ACTIONS(812), 3,
      anon_sym_AMP_AMP,
      aux_sym_comment_token1,
      sym__eol,
  [8275] = 6,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(817), 1,
      anon_sym_COLON_EQ,
    ACTIONS(819), 1,
      sym__eol,
    STATE(147), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
    STATE(335), 3,
      sym__setting_boolean,
      sym__setting_string,
      sym__setting_list,
  [8296] = 7,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    STATE(260), 1,
      aux_sym_recipe_parameters_repeat1,
    STATE(309), 1,
      sym_recipe_parameter,
    STATE(428), 1,
      sym_variadic_parameter,
    ACTIONS(670), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
  [8319] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(375), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(823), 1,
      aux_sym__shell_expanded_raw_string_token2,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    STATE(280), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8341] = 2,
    ACTIONS(827), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8353] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(829), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8371] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    ACTIONS(831), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(273), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8393] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(833), 1,
      sym__eol,
    STATE(276), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8411] = 5,
    ACTIONS(838), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(841), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(835), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8429] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(845), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(843), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8443] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(847), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8461] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(852), 1,
      anon_sym_DOLLAR,
    ACTIONS(855), 2,
      anon_sym_PLUS,
      anon_sym_STAR,
    STATE(260), 2,
      sym_recipe_parameter,
      aux_sym_recipe_parameters_repeat1,
  [8479] = 5,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    STATE(274), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8497] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(857), 1,
      sym__eol,
    STATE(254), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8515] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(397), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(861), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    STATE(272), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8537] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(865), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8555] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(430), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    ACTIONS(867), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(269), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8577] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(430), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    ACTIONS(869), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(270), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8599] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(873), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(871), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8613] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(877), 1,
      anon_sym_EQ,
    ACTIONS(875), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8627] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(426), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    ACTIONS(879), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(282), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8649] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(426), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    ACTIONS(881), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(283), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8671] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(883), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(885), 2,
      anon_sym_EQ_TILDE,
      anon_sym_BANG_TILDE,
  [8687] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    ACTIONS(879), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(282), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8709] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(436), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    ACTIONS(881), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(283), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8731] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(887), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8749] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(375), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    ACTIONS(889), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(279), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8771] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(891), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8789] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(893), 1,
      sym__eol,
    STATE(257), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8807] = 5,
    ACTIONS(496), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(895), 1,
      sym__eol,
    STATE(259), 1,
      aux_sym_shebang_line_repeat2,
    ACTIONS(494), 2,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
    STATE(383), 2,
      sym__recipe_line_choice,
      sym_interpolation,
  [8825] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(859), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      sym_expansion_long_start,
    ACTIONS(879), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    STATE(282), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8847] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(434), 1,
      anon_sym_SQUOTE,
    ACTIONS(821), 1,
      anon_sym_DOLLAR,
    ACTIONS(825), 1,
      sym_expansion_long_start,
    ACTIONS(881), 1,
      aux_sym__shell_expanded_raw_string_token2,
    STATE(283), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8869] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(899), 1,
      anon_sym_EQ,
    ACTIONS(897), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [8883] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(901), 1,
      anon_sym_DOLLAR,
    ACTIONS(904), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(906), 1,
      aux_sym__shell_expanded_indented_raw_string_token1,
    ACTIONS(909), 1,
      sym_expansion_long_start,
    STATE(282), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat2,
    STATE(432), 1,
      sym_expansion_short_start,
  [8905] = 7,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(912), 1,
      anon_sym_DOLLAR,
    ACTIONS(915), 1,
      anon_sym_SQUOTE,
    ACTIONS(917), 1,
      aux_sym__shell_expanded_raw_string_token2,
    ACTIONS(920), 1,
      sym_expansion_long_start,
    STATE(283), 1,
      aux_sym__shell_expanded_raw_string_repeat2,
    STATE(416), 1,
      sym_expansion_short_start,
  [8927] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(482), 2,
      anon_sym_AT,
      anon_sym_LBRACK,
    ACTIONS(484), 4,
      anon_sym_alias,
      anon_sym_export,
      anon_sym_mod,
      sym_identifier,
  [8941] = 1,
    ACTIONS(249), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8950] = 1,
    ACTIONS(283), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8959] = 1,
    ACTIONS(241), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8968] = 1,
    ACTIONS(257), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [8977] = 5,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(925), 1,
      sym__eol,
    STATE(178), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
    ACTIONS(923), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [8994] = 2,
    ACTIONS(923), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9005] = 1,
    ACTIONS(263), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9014] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(927), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9025] = 5,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(929), 1,
      sym__eol,
    STATE(158), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
    ACTIONS(923), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9042] = 5,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(931), 1,
      anon_sym_COMMA,
    ACTIONS(933), 1,
      anon_sym_RPAREN,
    STATE(365), 1,
      aux_sym_function_parameters_repeat1,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9059] = 1,
    ACTIONS(237), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9068] = 5,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(935), 1,
      sym__eol,
    STATE(176), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
    ACTIONS(923), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9085] = 1,
    ACTIONS(245), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9094] = 1,
    ACTIONS(253), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9103] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(520), 1,
      sym_shell_variable_name,
    ACTIONS(937), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9116] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(939), 2,
      anon_sym_PLUS,
      anon_sym_SLASH,
    ACTIONS(291), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9129] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(941), 5,
      anon_sym_COLON,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9140] = 1,
    ACTIONS(271), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9149] = 3,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(644), 1,
      sym_shell_variable_name,
    ACTIONS(943), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9162] = 1,
    ACTIONS(287), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9171] = 1,
    ACTIONS(275), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9180] = 1,
    ACTIONS(267), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9189] = 1,
    ACTIONS(279), 6,
      anon_sym_AMP_AMP,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9198] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(947), 1,
      anon_sym_COLON,
    ACTIONS(945), 4,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9211] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(945), 4,
      anon_sym_DOLLAR,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_identifier,
  [9224] = 1,
    ACTIONS(951), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9232] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(955), 1,
      sym_expansion_long_end,
    STATE(319), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(953), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9246] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(904), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9256] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(957), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9266] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(915), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9276] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(961), 1,
      sym_expansion_long_end,
    STATE(328), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(959), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9290] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(963), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9300] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(965), 1,
      anon_sym_COLON,
    ACTIONS(969), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9314] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(971), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9324] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(975), 1,
      sym_expansion_long_end,
    STATE(330), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(973), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9338] = 1,
    ACTIONS(307), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9346] = 1,
    ACTIONS(977), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9354] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(979), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [9366] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(981), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [9378] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(985), 1,
      sym_expansion_long_end,
    STATE(315), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(983), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9392] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(987), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [9404] = 1,
    ACTIONS(989), 5,
      anon_sym_AMP_AMP,
      anon_sym_LPAREN,
      sym_identifier,
      aux_sym_comment_token1,
      sym__eol,
  [9412] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(991), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9422] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(996), 1,
      sym_expansion_long_end,
    STATE(328), 1,
      aux_sym__shell_expanded_indented_raw_string_repeat1,
    ACTIONS(993), 2,
      aux_sym__shell_expanded_indented_normal_string_token1,
      sym_escape_variable_end,
  [9436] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(998), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      aux_sym__shell_expanded_raw_string_token2,
      sym_expansion_long_start,
  [9446] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1003), 1,
      sym_expansion_long_end,
    STATE(330), 1,
      aux_sym__shell_expanded_raw_string_repeat1,
    ACTIONS(1000), 2,
      aux_sym__shell_expanded_raw_string_token1,
      sym_escape_variable_end,
  [9460] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1005), 4,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym__shell_expanded_indented_raw_string_token1,
      sym_expansion_long_start,
  [9470] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(157), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9479] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1007), 1,
      anon_sym_COMMA,
    ACTIONS(1009), 1,
      anon_sym_RBRACK,
    STATE(364), 1,
      aux_sym__attribute_list_repeat1,
  [9492] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1011), 1,
      sym__eol,
    STATE(135), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9505] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1013), 1,
      sym__eol,
    STATE(160), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9518] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1015), 1,
      sym__eol,
    STATE(157), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9531] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1017), 1,
      anon_sym_COMMA,
    ACTIONS(1020), 1,
      anon_sym_RBRACK,
    STATE(337), 1,
      aux_sym__setting_list_repeat1,
  [9544] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1022), 1,
      sym__eol,
    STATE(159), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9557] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1024), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9568] = 1,
    ACTIONS(149), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [9575] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1026), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9586] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1028), 1,
      sym__eol,
    STATE(164), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9599] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1030), 1,
      sym__eol,
    STATE(258), 1,
      sym__ceol,
    STATE(482), 1,
      sym_comment,
  [9612] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1032), 1,
      sym__eol,
    STATE(148), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9625] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(692), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1034), 1,
      aux_sym__indented_raw_string_token1,
    STATE(366), 1,
      aux_sym__indented_raw_string_repeat1,
  [9638] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1036), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1038), 1,
      aux_sym__indented_raw_string_token1,
    STATE(346), 1,
      aux_sym__indented_raw_string_repeat1,
  [9651] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(987), 1,
      anon_sym_RPAREN,
    ACTIONS(1041), 1,
      anon_sym_COMMA,
    STATE(347), 1,
      aux_sym_function_parameters_repeat1,
  [9664] = 2,
    ACTIONS(301), 2,
      aux_sym_comment_token1,
      sym__eol,
    ACTIONS(923), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9673] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1044), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1046), 1,
      sym_shebang_shell,
    STATE(352), 1,
      aux_sym_shebang_line_repeat1,
  [9686] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1048), 1,
      sym__eol,
    STATE(138), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [9699] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1050), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1052), 1,
      sym_shebang_shell,
    STATE(378), 1,
      aux_sym_shebang_line_repeat1,
  [9712] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1054), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1057), 1,
      sym_shebang_shell,
    STATE(352), 1,
      aux_sym_shebang_line_repeat1,
  [9725] = 1,
    ACTIONS(1059), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [9732] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1007), 1,
      anon_sym_COMMA,
    ACTIONS(1061), 1,
      anon_sym_RBRACK,
    STATE(333), 1,
      aux_sym__attribute_list_repeat1,
  [9745] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(145), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9754] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(145), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(939), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9765] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1063), 1,
      anon_sym_COMMA,
    ACTIONS(1065), 1,
      anon_sym_RBRACK,
    STATE(361), 1,
      aux_sym__setting_list_repeat1,
  [9778] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1067), 1,
      sym__eol,
    STATE(267), 1,
      sym__ceol,
    STATE(482), 1,
      sym_comment,
  [9791] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(149), 3,
      anon_sym_AMP_AMP,
      anon_sym_RBRACE_RBRACE,
      anon_sym_PIPE_PIPE,
  [9800] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1069), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    STATE(389), 1,
      aux_sym__indented_backtick_repeat1,
  [9813] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(564), 1,
      anon_sym_RBRACK,
    ACTIONS(1073), 1,
      anon_sym_COMMA,
    STATE(337), 1,
      aux_sym__setting_list_repeat1,
  [9826] = 1,
    ACTIONS(1075), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [9833] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(716), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1077), 1,
      aux_sym__indented_raw_string_token1,
    STATE(367), 1,
      aux_sym__indented_raw_string_repeat1,
  [9846] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1079), 1,
      anon_sym_COMMA,
    ACTIONS(1082), 1,
      anon_sym_RBRACK,
    STATE(364), 1,
      aux_sym__attribute_list_repeat1,
  [9859] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    ACTIONS(1084), 1,
      anon_sym_COMMA,
    STATE(347), 1,
      aux_sym_function_parameters_repeat1,
  [9872] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(684), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1086), 1,
      aux_sym__indented_raw_string_token1,
    STATE(346), 1,
      aux_sym__indented_raw_string_repeat1,
  [9885] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(722), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1086), 1,
      aux_sym__indented_raw_string_token1,
    STATE(346), 1,
      aux_sym__indented_raw_string_repeat1,
  [9898] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1088), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(370), 1,
      aux_sym__indented_backtick_repeat1,
  [9911] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1090), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9922] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1092), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(391), 1,
      aux_sym__indented_backtick_repeat1,
  [9935] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1094), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9946] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1096), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9957] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1098), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9968] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(301), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(939), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [9979] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1100), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1102), 1,
      sym_shebang_shell,
    STATE(349), 1,
      aux_sym_shebang_line_repeat1,
  [9992] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(724), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1104), 1,
      aux_sym__indented_raw_string_token1,
    STATE(380), 1,
      aux_sym__indented_raw_string_repeat1,
  [10005] = 1,
    ACTIONS(145), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [10012] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1044), 1,
      aux_sym_shebang_line_token2,
    ACTIONS(1102), 1,
      sym_shebang_shell,
    STATE(352), 1,
      aux_sym_shebang_line_repeat1,
  [10025] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1106), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(939), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10036] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(672), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(1086), 1,
      aux_sym__indented_raw_string_token1,
    STATE(346), 1,
      aux_sym__indented_raw_string_repeat1,
  [10049] = 2,
    ACTIONS(145), 2,
      aux_sym_comment_token1,
      sym__eol,
    ACTIONS(923), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10058] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1108), 1,
      sym__eol,
    STATE(174), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [10071] = 1,
    ACTIONS(1110), 4,
      anon_sym_LBRACE_LBRACE_LBRACE_LBRACE,
      aux_sym__recipe_line_choice_token1,
      anon_sym_LBRACE_LBRACE,
      sym__eol,
  [10078] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1112), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(386), 1,
      aux_sym__indented_backtick_repeat1,
  [10091] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1114), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10102] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1116), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(391), 1,
      aux_sym__indented_backtick_repeat1,
  [10115] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1118), 1,
      anon_sym_RPAREN,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10126] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1120), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10137] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1071), 1,
      aux_sym__indented_backtick_token1,
    ACTIONS(1122), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    STATE(391), 1,
      aux_sym__indented_backtick_repeat1,
  [10150] = 4,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(662), 1,
      sym_identifier,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    STATE(453), 1,
      sym_recipe_parameter,
  [10163] = 4,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1124), 1,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
    ACTIONS(1126), 1,
      aux_sym__indented_backtick_token1,
    STATE(391), 1,
      aux_sym__indented_backtick_repeat1,
  [10176] = 1,
    ACTIONS(157), 4,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      aux_sym_comment_token1,
      sym__eol,
  [10183] = 4,
    ACTIONS(438), 1,
      aux_sym_comment_token1,
    ACTIONS(1129), 1,
      sym__eol,
    STATE(150), 1,
      sym__ceol,
    STATE(484), 1,
      sym_comment,
  [10196] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1131), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10207] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1133), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10218] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1135), 1,
      anon_sym_RBRACE,
    ACTIONS(522), 2,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [10229] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1137), 1,
      sym_identifier,
    STATE(2), 1,
      sym__recipe_dependency,
  [10239] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1139), 1,
      anon_sym_LPAREN,
    STATE(355), 1,
      sym_assert_parameters,
  [10249] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1141), 1,
      sym_expansion_long_middle,
    ACTIONS(1143), 1,
      sym_expansion_long_end,
  [10259] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1145), 1,
      sym_identifier,
    STATE(354), 1,
      sym_attribute,
  [10269] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1147), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10277] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1149), 1,
      sym_expansion_long_middle,
    ACTIONS(1151), 1,
      sym_expansion_long_end,
  [10287] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1153), 2,
      anon_sym_BQUOTE_BQUOTE_BQUOTE,
      aux_sym__indented_backtick_token1,
  [10295] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1020), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10303] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1155), 1,
      sym_identifier,
    ACTIONS(1157), 1,
      anon_sym_QMARK,
  [10313] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1159), 1,
      sym_expansion_long_middle,
    ACTIONS(1161), 1,
      sym_expansion_long_end,
  [10323] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1145), 1,
      sym_identifier,
    STATE(410), 1,
      sym_attribute,
  [10333] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1163), 1,
      sym_expansion_long_middle,
    ACTIONS(1165), 1,
      sym_expansion_long_end,
  [10343] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1167), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10351] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1082), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10359] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1169), 1,
      anon_sym_LPAREN,
    STATE(6), 1,
      sym_assert_parameters,
  [10369] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    STATE(377), 1,
      sym_assert_parameters,
  [10379] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1173), 2,
      anon_sym_shell,
      sym_identifier,
  [10387] = 3,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1175), 1,
      sym_identifier,
    ACTIONS(1177), 1,
      anon_sym_QMARK,
  [10397] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(947), 1,
      anon_sym_COLON,
  [10404] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1179), 1,
      sym_shell_variable_name,
  [10411] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1181), 1,
      anon_sym_SQUOTE,
  [10418] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1183), 1,
      ts_builtin_sym_end,
  [10425] = 1,
    ACTIONS(1185), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10430] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1187), 1,
      sym_identifier,
  [10437] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1189), 1,
      sym_identifier,
  [10444] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1191), 1,
      anon_sym_BQUOTE,
  [10451] = 1,
    ACTIONS(1193), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10456] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1195), 1,
      anon_sym_else,
  [10463] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1197), 1,
      anon_sym_RPAREN,
  [10470] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1199), 1,
      sym_identifier,
  [10477] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1201), 1,
      sym_shell_variable_name,
  [10484] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(949), 1,
      anon_sym_COLON,
  [10491] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1203), 1,
      sym_identifier,
  [10498] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1205), 1,
      anon_sym_LBRACE,
  [10505] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1207), 1,
      sym_shell_variable_name,
  [10512] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1209), 1,
      sym_shell_variable_name,
  [10519] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1211), 1,
      sym_identifier,
  [10526] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1102), 1,
      sym_shebang_shell,
  [10533] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1213), 1,
      anon_sym_COLON,
  [10540] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1215), 1,
      sym_identifier,
  [10547] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1217), 1,
      anon_sym_COMMA,
  [10554] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
  [10561] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1175), 1,
      sym_identifier,
  [10568] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1221), 1,
      anon_sym_SQUOTE,
  [10575] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1223), 1,
      sym_identifier,
  [10582] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1225), 1,
      anon_sym_BQUOTE,
  [10589] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1227), 1,
      aux_sym__backtick_token1,
  [10596] = 1,
    ACTIONS(1229), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10601] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1231), 1,
      anon_sym_COLON_EQ,
  [10608] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(664), 1,
      anon_sym_COLON_EQ,
  [10615] = 1,
    ACTIONS(1233), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10620] = 1,
    ACTIONS(1235), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10625] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1237), 1,
      anon_sym_BQUOTE,
  [10632] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1052), 1,
      sym_shebang_shell,
  [10639] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1239), 1,
      aux_sym__raw_string_token1,
  [10646] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1241), 1,
      anon_sym_RPAREN,
  [10653] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1243), 1,
      anon_sym_COLON,
  [10660] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1245), 1,
      anon_sym_COLON_EQ,
  [10667] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1247), 1,
      sym_identifier,
  [10674] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1249), 1,
      aux_sym__raw_string_token1,
  [10681] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1251), 1,
      sym_identifier,
  [10688] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1253), 1,
      aux_sym__backtick_token1,
  [10695] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1255), 1,
      sym_shell_variable_name,
  [10702] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1257), 1,
      anon_sym_LBRACE,
  [10709] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1259), 1,
      aux_sym__raw_string_token1,
  [10716] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1261), 1,
      anon_sym_COLON,
  [10723] = 2,
    ACTIONS(315), 1,
      sym__eol,
    ACTIONS(1263), 1,
      aux_sym__backtick_token1,
  [10730] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1265), 1,
      sym_shell_variable_name,
  [10737] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1267), 1,
      anon_sym_COMMA,
  [10744] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1269), 1,
      anon_sym_LBRACE,
  [10751] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1271), 1,
      anon_sym_COMMA,
  [10758] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1273), 1,
      anon_sym_LBRACE,
  [10765] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1275), 1,
      anon_sym_COLON,
  [10772] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1277), 1,
      anon_sym_else,
  [10779] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1279), 1,
      sym_shell_variable_name,
  [10786] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1281), 1,
      anon_sym_else,
  [10793] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1283), 1,
      sym_identifier,
  [10800] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1285), 1,
      sym_shell_variable_name,
  [10807] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1287), 1,
      anon_sym_SQUOTE,
  [10814] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1289), 1,
      sym_identifier,
  [10821] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1291), 1,
      anon_sym_LBRACE,
  [10828] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
  [10835] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1295), 1,
      anon_sym_RPAREN,
  [10842] = 1,
    ACTIONS(1297), 2,
      aux_sym_comment_token1,
      sym__eol,
  [10847] = 2,
    ACTIONS(3), 1,
      sym__eol,
    ACTIONS(1299), 1,
      anon_sym_COLON_EQ,
  [10854] = 1,
    ACTIONS(1301), 1,
      sym__eol,
  [10858] = 1,
    ACTIONS(578), 1,
      sym__eol,
  [10862] = 1,
    ACTIONS(1303), 1,
      sym__eol,
  [10866] = 1,
    ACTIONS(1305), 1,
      sym__eol,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 76,
  [SMALL_STATE(4)] = 152,
  [SMALL_STATE(5)] = 228,
  [SMALL_STATE(6)] = 304,
  [SMALL_STATE(7)] = 338,
  [SMALL_STATE(8)] = 372,
  [SMALL_STATE(9)] = 448,
  [SMALL_STATE(10)] = 524,
  [SMALL_STATE(11)] = 558,
  [SMALL_STATE(12)] = 631,
  [SMALL_STATE(13)] = 704,
  [SMALL_STATE(14)] = 777,
  [SMALL_STATE(15)] = 850,
  [SMALL_STATE(16)] = 923,
  [SMALL_STATE(17)] = 996,
  [SMALL_STATE(18)] = 1069,
  [SMALL_STATE(19)] = 1142,
  [SMALL_STATE(20)] = 1212,
  [SMALL_STATE(21)] = 1282,
  [SMALL_STATE(22)] = 1352,
  [SMALL_STATE(23)] = 1422,
  [SMALL_STATE(24)] = 1492,
  [SMALL_STATE(25)] = 1562,
  [SMALL_STATE(26)] = 1632,
  [SMALL_STATE(27)] = 1702,
  [SMALL_STATE(28)] = 1772,
  [SMALL_STATE(29)] = 1842,
  [SMALL_STATE(30)] = 1912,
  [SMALL_STATE(31)] = 1982,
  [SMALL_STATE(32)] = 2052,
  [SMALL_STATE(33)] = 2122,
  [SMALL_STATE(34)] = 2192,
  [SMALL_STATE(35)] = 2262,
  [SMALL_STATE(36)] = 2332,
  [SMALL_STATE(37)] = 2402,
  [SMALL_STATE(38)] = 2472,
  [SMALL_STATE(39)] = 2542,
  [SMALL_STATE(40)] = 2612,
  [SMALL_STATE(41)] = 2682,
  [SMALL_STATE(42)] = 2752,
  [SMALL_STATE(43)] = 2822,
  [SMALL_STATE(44)] = 2892,
  [SMALL_STATE(45)] = 2962,
  [SMALL_STATE(46)] = 3032,
  [SMALL_STATE(47)] = 3084,
  [SMALL_STATE(48)] = 3136,
  [SMALL_STATE(49)] = 3165,
  [SMALL_STATE(50)] = 3194,
  [SMALL_STATE(51)] = 3223,
  [SMALL_STATE(52)] = 3252,
  [SMALL_STATE(53)] = 3281,
  [SMALL_STATE(54)] = 3312,
  [SMALL_STATE(55)] = 3341,
  [SMALL_STATE(56)] = 3370,
  [SMALL_STATE(57)] = 3399,
  [SMALL_STATE(58)] = 3428,
  [SMALL_STATE(59)] = 3457,
  [SMALL_STATE(60)] = 3486,
  [SMALL_STATE(61)] = 3515,
  [SMALL_STATE(62)] = 3544,
  [SMALL_STATE(63)] = 3602,
  [SMALL_STATE(64)] = 3632,
  [SMALL_STATE(65)] = 3690,
  [SMALL_STATE(66)] = 3719,
  [SMALL_STATE(67)] = 3748,
  [SMALL_STATE(68)] = 3777,
  [SMALL_STATE(69)] = 3800,
  [SMALL_STATE(70)] = 3823,
  [SMALL_STATE(71)] = 3846,
  [SMALL_STATE(72)] = 3871,
  [SMALL_STATE(73)] = 3894,
  [SMALL_STATE(74)] = 3917,
  [SMALL_STATE(75)] = 3942,
  [SMALL_STATE(76)] = 3964,
  [SMALL_STATE(77)] = 3996,
  [SMALL_STATE(78)] = 4028,
  [SMALL_STATE(79)] = 4060,
  [SMALL_STATE(80)] = 4092,
  [SMALL_STATE(81)] = 4114,
  [SMALL_STATE(82)] = 4146,
  [SMALL_STATE(83)] = 4178,
  [SMALL_STATE(84)] = 4200,
  [SMALL_STATE(85)] = 4222,
  [SMALL_STATE(86)] = 4244,
  [SMALL_STATE(87)] = 4276,
  [SMALL_STATE(88)] = 4308,
  [SMALL_STATE(89)] = 4330,
  [SMALL_STATE(90)] = 4362,
  [SMALL_STATE(91)] = 4394,
  [SMALL_STATE(92)] = 4426,
  [SMALL_STATE(93)] = 4458,
  [SMALL_STATE(94)] = 4490,
  [SMALL_STATE(95)] = 4522,
  [SMALL_STATE(96)] = 4554,
  [SMALL_STATE(97)] = 4576,
  [SMALL_STATE(98)] = 4598,
  [SMALL_STATE(99)] = 4630,
  [SMALL_STATE(100)] = 4656,
  [SMALL_STATE(101)] = 4700,
  [SMALL_STATE(102)] = 4726,
  [SMALL_STATE(103)] = 4758,
  [SMALL_STATE(104)] = 4784,
  [SMALL_STATE(105)] = 4810,
  [SMALL_STATE(106)] = 4842,
  [SMALL_STATE(107)] = 4874,
  [SMALL_STATE(108)] = 4906,
  [SMALL_STATE(109)] = 4938,
  [SMALL_STATE(110)] = 4970,
  [SMALL_STATE(111)] = 5013,
  [SMALL_STATE(112)] = 5044,
  [SMALL_STATE(113)] = 5087,
  [SMALL_STATE(114)] = 5118,
  [SMALL_STATE(115)] = 5161,
  [SMALL_STATE(116)] = 5192,
  [SMALL_STATE(117)] = 5223,
  [SMALL_STATE(118)] = 5254,
  [SMALL_STATE(119)] = 5285,
  [SMALL_STATE(120)] = 5316,
  [SMALL_STATE(121)] = 5336,
  [SMALL_STATE(122)] = 5356,
  [SMALL_STATE(123)] = 5376,
  [SMALL_STATE(124)] = 5408,
  [SMALL_STATE(125)] = 5428,
  [SMALL_STATE(126)] = 5448,
  [SMALL_STATE(127)] = 5468,
  [SMALL_STATE(128)] = 5488,
  [SMALL_STATE(129)] = 5508,
  [SMALL_STATE(130)] = 5528,
  [SMALL_STATE(131)] = 5548,
  [SMALL_STATE(132)] = 5568,
  [SMALL_STATE(133)] = 5588,
  [SMALL_STATE(134)] = 5607,
  [SMALL_STATE(135)] = 5626,
  [SMALL_STATE(136)] = 5645,
  [SMALL_STATE(137)] = 5668,
  [SMALL_STATE(138)] = 5685,
  [SMALL_STATE(139)] = 5704,
  [SMALL_STATE(140)] = 5723,
  [SMALL_STATE(141)] = 5740,
  [SMALL_STATE(142)] = 5757,
  [SMALL_STATE(143)] = 5780,
  [SMALL_STATE(144)] = 5803,
  [SMALL_STATE(145)] = 5822,
  [SMALL_STATE(146)] = 5841,
  [SMALL_STATE(147)] = 5878,
  [SMALL_STATE(148)] = 5897,
  [SMALL_STATE(149)] = 5916,
  [SMALL_STATE(150)] = 5935,
  [SMALL_STATE(151)] = 5954,
  [SMALL_STATE(152)] = 5973,
  [SMALL_STATE(153)] = 5992,
  [SMALL_STATE(154)] = 6015,
  [SMALL_STATE(155)] = 6052,
  [SMALL_STATE(156)] = 6071,
  [SMALL_STATE(157)] = 6088,
  [SMALL_STATE(158)] = 6107,
  [SMALL_STATE(159)] = 6126,
  [SMALL_STATE(160)] = 6145,
  [SMALL_STATE(161)] = 6164,
  [SMALL_STATE(162)] = 6183,
  [SMALL_STATE(163)] = 6202,
  [SMALL_STATE(164)] = 6221,
  [SMALL_STATE(165)] = 6240,
  [SMALL_STATE(166)] = 6257,
  [SMALL_STATE(167)] = 6280,
  [SMALL_STATE(168)] = 6303,
  [SMALL_STATE(169)] = 6322,
  [SMALL_STATE(170)] = 6341,
  [SMALL_STATE(171)] = 6378,
  [SMALL_STATE(172)] = 6397,
  [SMALL_STATE(173)] = 6416,
  [SMALL_STATE(174)] = 6435,
  [SMALL_STATE(175)] = 6454,
  [SMALL_STATE(176)] = 6473,
  [SMALL_STATE(177)] = 6492,
  [SMALL_STATE(178)] = 6511,
  [SMALL_STATE(179)] = 6530,
  [SMALL_STATE(180)] = 6549,
  [SMALL_STATE(181)] = 6568,
  [SMALL_STATE(182)] = 6600,
  [SMALL_STATE(183)] = 6622,
  [SMALL_STATE(184)] = 6654,
  [SMALL_STATE(185)] = 6670,
  [SMALL_STATE(186)] = 6692,
  [SMALL_STATE(187)] = 6714,
  [SMALL_STATE(188)] = 6738,
  [SMALL_STATE(189)] = 6754,
  [SMALL_STATE(190)] = 6788,
  [SMALL_STATE(191)] = 6810,
  [SMALL_STATE(192)] = 6844,
  [SMALL_STATE(193)] = 6878,
  [SMALL_STATE(194)] = 6894,
  [SMALL_STATE(195)] = 6916,
  [SMALL_STATE(196)] = 6950,
  [SMALL_STATE(197)] = 6972,
  [SMALL_STATE(198)] = 6994,
  [SMALL_STATE(199)] = 7012,
  [SMALL_STATE(200)] = 7030,
  [SMALL_STATE(201)] = 7046,
  [SMALL_STATE(202)] = 7062,
  [SMALL_STATE(203)] = 7084,
  [SMALL_STATE(204)] = 7106,
  [SMALL_STATE(205)] = 7140,
  [SMALL_STATE(206)] = 7162,
  [SMALL_STATE(207)] = 7184,
  [SMALL_STATE(208)] = 7206,
  [SMALL_STATE(209)] = 7228,
  [SMALL_STATE(210)] = 7250,
  [SMALL_STATE(211)] = 7279,
  [SMALL_STATE(212)] = 7308,
  [SMALL_STATE(213)] = 7337,
  [SMALL_STATE(214)] = 7366,
  [SMALL_STATE(215)] = 7383,
  [SMALL_STATE(216)] = 7400,
  [SMALL_STATE(217)] = 7429,
  [SMALL_STATE(218)] = 7458,
  [SMALL_STATE(219)] = 7487,
  [SMALL_STATE(220)] = 7516,
  [SMALL_STATE(221)] = 7545,
  [SMALL_STATE(222)] = 7574,
  [SMALL_STATE(223)] = 7603,
  [SMALL_STATE(224)] = 7632,
  [SMALL_STATE(225)] = 7661,
  [SMALL_STATE(226)] = 7690,
  [SMALL_STATE(227)] = 7710,
  [SMALL_STATE(228)] = 7736,
  [SMALL_STATE(229)] = 7762,
  [SMALL_STATE(230)] = 7788,
  [SMALL_STATE(231)] = 7814,
  [SMALL_STATE(232)] = 7840,
  [SMALL_STATE(233)] = 7866,
  [SMALL_STATE(234)] = 7880,
  [SMALL_STATE(235)] = 7894,
  [SMALL_STATE(236)] = 7920,
  [SMALL_STATE(237)] = 7946,
  [SMALL_STATE(238)] = 7972,
  [SMALL_STATE(239)] = 7998,
  [SMALL_STATE(240)] = 8024,
  [SMALL_STATE(241)] = 8050,
  [SMALL_STATE(242)] = 8076,
  [SMALL_STATE(243)] = 8100,
  [SMALL_STATE(244)] = 8126,
  [SMALL_STATE(245)] = 8152,
  [SMALL_STATE(246)] = 8178,
  [SMALL_STATE(247)] = 8204,
  [SMALL_STATE(248)] = 8230,
  [SMALL_STATE(249)] = 8256,
  [SMALL_STATE(250)] = 8275,
  [SMALL_STATE(251)] = 8296,
  [SMALL_STATE(252)] = 8319,
  [SMALL_STATE(253)] = 8341,
  [SMALL_STATE(254)] = 8353,
  [SMALL_STATE(255)] = 8371,
  [SMALL_STATE(256)] = 8393,
  [SMALL_STATE(257)] = 8411,
  [SMALL_STATE(258)] = 8429,
  [SMALL_STATE(259)] = 8443,
  [SMALL_STATE(260)] = 8461,
  [SMALL_STATE(261)] = 8479,
  [SMALL_STATE(262)] = 8497,
  [SMALL_STATE(263)] = 8515,
  [SMALL_STATE(264)] = 8537,
  [SMALL_STATE(265)] = 8555,
  [SMALL_STATE(266)] = 8577,
  [SMALL_STATE(267)] = 8599,
  [SMALL_STATE(268)] = 8613,
  [SMALL_STATE(269)] = 8627,
  [SMALL_STATE(270)] = 8649,
  [SMALL_STATE(271)] = 8671,
  [SMALL_STATE(272)] = 8687,
  [SMALL_STATE(273)] = 8709,
  [SMALL_STATE(274)] = 8731,
  [SMALL_STATE(275)] = 8749,
  [SMALL_STATE(276)] = 8771,
  [SMALL_STATE(277)] = 8789,
  [SMALL_STATE(278)] = 8807,
  [SMALL_STATE(279)] = 8825,
  [SMALL_STATE(280)] = 8847,
  [SMALL_STATE(281)] = 8869,
  [SMALL_STATE(282)] = 8883,
  [SMALL_STATE(283)] = 8905,
  [SMALL_STATE(284)] = 8927,
  [SMALL_STATE(285)] = 8941,
  [SMALL_STATE(286)] = 8950,
  [SMALL_STATE(287)] = 8959,
  [SMALL_STATE(288)] = 8968,
  [SMALL_STATE(289)] = 8977,
  [SMALL_STATE(290)] = 8994,
  [SMALL_STATE(291)] = 9005,
  [SMALL_STATE(292)] = 9014,
  [SMALL_STATE(293)] = 9025,
  [SMALL_STATE(294)] = 9042,
  [SMALL_STATE(295)] = 9059,
  [SMALL_STATE(296)] = 9068,
  [SMALL_STATE(297)] = 9085,
  [SMALL_STATE(298)] = 9094,
  [SMALL_STATE(299)] = 9103,
  [SMALL_STATE(300)] = 9116,
  [SMALL_STATE(301)] = 9129,
  [SMALL_STATE(302)] = 9140,
  [SMALL_STATE(303)] = 9149,
  [SMALL_STATE(304)] = 9162,
  [SMALL_STATE(305)] = 9171,
  [SMALL_STATE(306)] = 9180,
  [SMALL_STATE(307)] = 9189,
  [SMALL_STATE(308)] = 9198,
  [SMALL_STATE(309)] = 9211,
  [SMALL_STATE(310)] = 9224,
  [SMALL_STATE(311)] = 9232,
  [SMALL_STATE(312)] = 9246,
  [SMALL_STATE(313)] = 9256,
  [SMALL_STATE(314)] = 9266,
  [SMALL_STATE(315)] = 9276,
  [SMALL_STATE(316)] = 9290,
  [SMALL_STATE(317)] = 9300,
  [SMALL_STATE(318)] = 9314,
  [SMALL_STATE(319)] = 9324,
  [SMALL_STATE(320)] = 9338,
  [SMALL_STATE(321)] = 9346,
  [SMALL_STATE(322)] = 9354,
  [SMALL_STATE(323)] = 9366,
  [SMALL_STATE(324)] = 9378,
  [SMALL_STATE(325)] = 9392,
  [SMALL_STATE(326)] = 9404,
  [SMALL_STATE(327)] = 9412,
  [SMALL_STATE(328)] = 9422,
  [SMALL_STATE(329)] = 9436,
  [SMALL_STATE(330)] = 9446,
  [SMALL_STATE(331)] = 9460,
  [SMALL_STATE(332)] = 9470,
  [SMALL_STATE(333)] = 9479,
  [SMALL_STATE(334)] = 9492,
  [SMALL_STATE(335)] = 9505,
  [SMALL_STATE(336)] = 9518,
  [SMALL_STATE(337)] = 9531,
  [SMALL_STATE(338)] = 9544,
  [SMALL_STATE(339)] = 9557,
  [SMALL_STATE(340)] = 9568,
  [SMALL_STATE(341)] = 9575,
  [SMALL_STATE(342)] = 9586,
  [SMALL_STATE(343)] = 9599,
  [SMALL_STATE(344)] = 9612,
  [SMALL_STATE(345)] = 9625,
  [SMALL_STATE(346)] = 9638,
  [SMALL_STATE(347)] = 9651,
  [SMALL_STATE(348)] = 9664,
  [SMALL_STATE(349)] = 9673,
  [SMALL_STATE(350)] = 9686,
  [SMALL_STATE(351)] = 9699,
  [SMALL_STATE(352)] = 9712,
  [SMALL_STATE(353)] = 9725,
  [SMALL_STATE(354)] = 9732,
  [SMALL_STATE(355)] = 9745,
  [SMALL_STATE(356)] = 9754,
  [SMALL_STATE(357)] = 9765,
  [SMALL_STATE(358)] = 9778,
  [SMALL_STATE(359)] = 9791,
  [SMALL_STATE(360)] = 9800,
  [SMALL_STATE(361)] = 9813,
  [SMALL_STATE(362)] = 9826,
  [SMALL_STATE(363)] = 9833,
  [SMALL_STATE(364)] = 9846,
  [SMALL_STATE(365)] = 9859,
  [SMALL_STATE(366)] = 9872,
  [SMALL_STATE(367)] = 9885,
  [SMALL_STATE(368)] = 9898,
  [SMALL_STATE(369)] = 9911,
  [SMALL_STATE(370)] = 9922,
  [SMALL_STATE(371)] = 9935,
  [SMALL_STATE(372)] = 9946,
  [SMALL_STATE(373)] = 9957,
  [SMALL_STATE(374)] = 9968,
  [SMALL_STATE(375)] = 9979,
  [SMALL_STATE(376)] = 9992,
  [SMALL_STATE(377)] = 10005,
  [SMALL_STATE(378)] = 10012,
  [SMALL_STATE(379)] = 10025,
  [SMALL_STATE(380)] = 10036,
  [SMALL_STATE(381)] = 10049,
  [SMALL_STATE(382)] = 10058,
  [SMALL_STATE(383)] = 10071,
  [SMALL_STATE(384)] = 10078,
  [SMALL_STATE(385)] = 10091,
  [SMALL_STATE(386)] = 10102,
  [SMALL_STATE(387)] = 10115,
  [SMALL_STATE(388)] = 10126,
  [SMALL_STATE(389)] = 10137,
  [SMALL_STATE(390)] = 10150,
  [SMALL_STATE(391)] = 10163,
  [SMALL_STATE(392)] = 10176,
  [SMALL_STATE(393)] = 10183,
  [SMALL_STATE(394)] = 10196,
  [SMALL_STATE(395)] = 10207,
  [SMALL_STATE(396)] = 10218,
  [SMALL_STATE(397)] = 10229,
  [SMALL_STATE(398)] = 10239,
  [SMALL_STATE(399)] = 10249,
  [SMALL_STATE(400)] = 10259,
  [SMALL_STATE(401)] = 10269,
  [SMALL_STATE(402)] = 10277,
  [SMALL_STATE(403)] = 10287,
  [SMALL_STATE(404)] = 10295,
  [SMALL_STATE(405)] = 10303,
  [SMALL_STATE(406)] = 10313,
  [SMALL_STATE(407)] = 10323,
  [SMALL_STATE(408)] = 10333,
  [SMALL_STATE(409)] = 10343,
  [SMALL_STATE(410)] = 10351,
  [SMALL_STATE(411)] = 10359,
  [SMALL_STATE(412)] = 10369,
  [SMALL_STATE(413)] = 10379,
  [SMALL_STATE(414)] = 10387,
  [SMALL_STATE(415)] = 10397,
  [SMALL_STATE(416)] = 10404,
  [SMALL_STATE(417)] = 10411,
  [SMALL_STATE(418)] = 10418,
  [SMALL_STATE(419)] = 10425,
  [SMALL_STATE(420)] = 10430,
  [SMALL_STATE(421)] = 10437,
  [SMALL_STATE(422)] = 10444,
  [SMALL_STATE(423)] = 10451,
  [SMALL_STATE(424)] = 10456,
  [SMALL_STATE(425)] = 10463,
  [SMALL_STATE(426)] = 10470,
  [SMALL_STATE(427)] = 10477,
  [SMALL_STATE(428)] = 10484,
  [SMALL_STATE(429)] = 10491,
  [SMALL_STATE(430)] = 10498,
  [SMALL_STATE(431)] = 10505,
  [SMALL_STATE(432)] = 10512,
  [SMALL_STATE(433)] = 10519,
  [SMALL_STATE(434)] = 10526,
  [SMALL_STATE(435)] = 10533,
  [SMALL_STATE(436)] = 10540,
  [SMALL_STATE(437)] = 10547,
  [SMALL_STATE(438)] = 10554,
  [SMALL_STATE(439)] = 10561,
  [SMALL_STATE(440)] = 10568,
  [SMALL_STATE(441)] = 10575,
  [SMALL_STATE(442)] = 10582,
  [SMALL_STATE(443)] = 10589,
  [SMALL_STATE(444)] = 10596,
  [SMALL_STATE(445)] = 10601,
  [SMALL_STATE(446)] = 10608,
  [SMALL_STATE(447)] = 10615,
  [SMALL_STATE(448)] = 10620,
  [SMALL_STATE(449)] = 10625,
  [SMALL_STATE(450)] = 10632,
  [SMALL_STATE(451)] = 10639,
  [SMALL_STATE(452)] = 10646,
  [SMALL_STATE(453)] = 10653,
  [SMALL_STATE(454)] = 10660,
  [SMALL_STATE(455)] = 10667,
  [SMALL_STATE(456)] = 10674,
  [SMALL_STATE(457)] = 10681,
  [SMALL_STATE(458)] = 10688,
  [SMALL_STATE(459)] = 10695,
  [SMALL_STATE(460)] = 10702,
  [SMALL_STATE(461)] = 10709,
  [SMALL_STATE(462)] = 10716,
  [SMALL_STATE(463)] = 10723,
  [SMALL_STATE(464)] = 10730,
  [SMALL_STATE(465)] = 10737,
  [SMALL_STATE(466)] = 10744,
  [SMALL_STATE(467)] = 10751,
  [SMALL_STATE(468)] = 10758,
  [SMALL_STATE(469)] = 10765,
  [SMALL_STATE(470)] = 10772,
  [SMALL_STATE(471)] = 10779,
  [SMALL_STATE(472)] = 10786,
  [SMALL_STATE(473)] = 10793,
  [SMALL_STATE(474)] = 10800,
  [SMALL_STATE(475)] = 10807,
  [SMALL_STATE(476)] = 10814,
  [SMALL_STATE(477)] = 10821,
  [SMALL_STATE(478)] = 10828,
  [SMALL_STATE(479)] = 10835,
  [SMALL_STATE(480)] = 10842,
  [SMALL_STATE(481)] = 10847,
  [SMALL_STATE(482)] = 10854,
  [SMALL_STATE(483)] = 10858,
  [SMALL_STATE(484)] = 10862,
  [SMALL_STATE(485)] = 10866,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(429),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(420),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(413),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(11),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(458),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(456),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(53),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(39),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0),
  [99] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(11),
  [102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(411),
  [105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(34),
  [108] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(463),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(384),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(207),
  [117] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(208),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(376),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(461),
  [126] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [129] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(117),
  [132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(275),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(252),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 2, 0, 0), SHIFT_REPEAT(54),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 2, 0, 0),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 2, 0, 0),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 9, 0, 0),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 9, 0, 0),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert_parameters, 5, 0, 0),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert_parameters, 5, 0, 0),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 2, 0, 0),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 3, 0, 0),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(12),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(443),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(183),
  [206] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(473),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(429),
  [212] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(420),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(154),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(405),
  [221] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(441),
  [224] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(400),
  [227] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(413),
  [230] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2, 0, 0), SHIFT_REPEAT(152),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1, 0, 0),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_expanded_string, 2, 0, 0),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_expanded_string, 2, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, 0, 0),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shell_expanded_string, 3, 0, 0),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shell_expanded_string, 3, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_external_command, 1, 0, 0),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_external_command, 1, 0, 0),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__indented_backtick, 2, 0, 0),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_backtick, 2, 0, 0),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 3, 0, 0),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 3, 0, 0),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__backtick, 3, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__backtick, 3, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__indented_backtick, 3, 0, 10),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__indented_backtick, 3, 0, 10),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3, 0, 1),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3, 0, 1),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 4, 0, 1),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 4, 0, 1),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_dependency_repeat1, 1, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_dependency_repeat1, 1, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 3, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 3, 0, 0),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__recipe_dependency, 1, 0, 1),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__recipe_dependency, 1, 0, 1),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 6),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 6),
  [313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 3, 0, 1),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 3, 0, 1),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 4, 0, 2),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 4, 0, 2),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 1),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 1),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 1),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 1),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 2),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 2),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 1),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 1),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 6),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 6),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 6),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 6),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 9, 0, 6),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 9, 0, 6),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 6, 0, 2),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 6, 0, 2),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 2),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 2),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 7, 0, 6),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 7, 0, 6),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 5, 0, 2),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 5, 0, 2),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 4, 0, 1),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 4, 0, 1),
  [373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [379] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(459),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 1, 0, 0),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 1, 0, 0),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 1, 0, 8),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 1, 0, 8),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_body, 2, 0, 8),
  [403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_body, 2, 0, 8),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_body_repeat1, 2, 0, 0), SHIFT_REPEAT(187),
  [412] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(129),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0),
  [417] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(137),
  [420] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(105),
  [423] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(459),
  [426] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [430] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [444] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [448] = {.entry = {.count = 1, .reusable = false}}, SHIFT(471),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [456] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(171),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0),
  [461] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(201),
  [464] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(115),
  [467] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 2, 0, 0), SHIFT_REPEAT(471),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 5, 0, 21),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 5, 0, 21),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 4, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 4, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ceol, 2, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ceol, 2, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = false}}, SHIFT(261),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [490] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [492] = {.entry = {.count = 1, .reusable = false}}, SHIFT(450),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [496] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 6, 0, 22),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 6, 0, 22),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 6, 0, 0),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 6, 0, 0),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 5, 0, 0),
  [508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 5, 0, 0),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 3, 0, 16),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_line, 3, 0, 16),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_shebang_line, 7, 0, 23),
  [516] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_shebang_line, 7, 0, 23),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 1, 0, 0),
  [520] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expansion_short_start, 1, 0, 0),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_line, 4, 0, 19),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe_line, 4, 0, 19),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 4, 0, 6),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 4, 0, 6),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 4, 0, 5),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 4, 0, 5),
  [536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 5, 0, 9),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 5, 0, 9),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 5, 0, 14),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 5, 0, 14),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 4, 0, 0),
  [554] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [556] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [560] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setting, 3, 0, 2),
  [568] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setting, 3, 0, 2),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3, 0, 3),
  [572] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 3, 0, 3),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 4, 0, 7),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 4, 0, 7),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1, 0, 0),
  [580] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment, 1, 0, 0),
  [582] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 3, 0, 2),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 3, 0, 2),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 3, 0, 0),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias, 6, 0, 6),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias, 6, 0, 6),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 6, 0, 6),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 6, 0, 6),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mod, 6, 0, 18),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mod, 6, 0, 18),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_setting, 4, 0, 2),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_setting, 4, 0, 2),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 8, 0, 1),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 8, 0, 1),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias, 5, 0, 2),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias, 5, 0, 2),
  [618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat2, 5, 0, 0),
  [620] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(214),
  [623] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(166),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_indented_normal_string_repeat1, 2, 0, 0),
  [628] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(215),
  [631] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(167),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat1, 2, 0, 0),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 9, 0, 2),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 9, 0, 2),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [642] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 1, 0, 0),
  [644] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expansion_short_start, 1, 0, 0),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unexport, 3, 0, 2),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unexport, 3, 0, 2),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 5, 0, 2),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 5, 0, 2),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 4, 0, 1),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment, 4, 0, 1),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe, 10, 0, 6),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_recipe, 10, 0, 6),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [666] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [672] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(197),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [682] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 3, 0, 0),
  [684] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [686] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [688] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [690] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 4, 0, 0),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(295),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_normal_string_repeat2, 5, 0, 0),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [700] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0),
  [702] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(196),
  [705] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0),
  [710] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(197),
  [713] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__normal_string_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [716] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [718] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [720] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [722] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [724] = {.entry = {.count = 1, .reusable = false}}, SHIFT(48),
  [726] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [728] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alias_repeat1, 2, 0, 0), SHIFT_REPEAT(400),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [791] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [793] = {.entry = {.count = 1, .reusable = false}}, SHIFT(434),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [797] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [799] = {.entry = {.count = 1, .reusable = false}}, SHIFT(476),
  [801] = {.entry = {.count = 1, .reusable = false}}, SHIFT(421),
  [803] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [809] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(320),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0),
  [814] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_repeat1, 2, 0, 0), SHIFT_REPEAT(397),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [821] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [823] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [825] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [831] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [833] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [835] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17), SHIFT_REPEAT(362),
  [838] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17), SHIFT_REPEAT(23),
  [841] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 2, 0, 17),
  [843] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_list, 4, 0, 0),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attribute_list, 4, 0, 0),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [849] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(281),
  [852] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(457),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 2, 0, 0),
  [857] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [859] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [861] = {.entry = {.count = 1, .reusable = false}}, SHIFT(272),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [865] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [867] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [869] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [871] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__attribute_list, 5, 0, 0),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__attribute_list, 5, 0, 0),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 2, 0, 2),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(282),
  [881] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [889] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [891] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [893] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 1, 0, 1),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [901] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(299),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0),
  [906] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(282),
  [909] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(431),
  [912] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(303),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0),
  [917] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(283),
  [920] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 2, 0, 0), SHIFT_REPEAT(464),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 4, 0, 2),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameters, 1, 0, 0),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [937] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 1, 0, 0),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameter, 3, 0, 1),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 1, 0, 0),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_recipe_parameters_repeat1, 1, 0, 0),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameters, 1, 0, 0),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_parameters, 2, 0, 0),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 3, 0, 11),
  [953] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [957] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 4, 0, 0),
  [959] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [963] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 3, 0, 0),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 1, 0, 1),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [971] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 4, 0, 0),
  [973] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 1, 0, 4),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 3, 0, 0),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 3, 0, 15),
  [983] = {.entry = {.count = 1, .reusable = false}}, SHIFT(315),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2, 0, 0),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_recipe_dependency, 4, 0, 11),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 3, 0, 0),
  [993] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(328),
  [996] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat1, 2, 0, 0),
  [998] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat2, 5, 0, 0),
  [1000] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(330),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__shell_expanded_raw_string_repeat1, 2, 0, 0),
  [1005] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__shell_expanded_indented_raw_string_repeat2, 5, 0, 0),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1017] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__setting_list_repeat1, 2, 0, 0), SHIFT_REPEAT(195),
  [1020] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__setting_list_repeat1, 2, 0, 0),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1034] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_raw_string_repeat1, 2, 0, 0),
  [1038] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_raw_string_repeat1, 2, 0, 0), SHIFT_REPEAT(346),
  [1041] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(26),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1054] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_shebang_line_repeat1, 2, 0, 0), SHIFT_REPEAT(352),
  [1057] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_shebang_line_repeat1, 2, 0, 0),
  [1059] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpolation, 3, 0, 20),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1069] = {.entry = {.count = 1, .reusable = false}}, SHIFT(306),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1075] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__recipe_line_choice, 1, 0, 12),
  [1077] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [1079] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__attribute_list_repeat1, 2, 0, 0), SHIFT_REPEAT(407),
  [1082] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__attribute_list_repeat1, 2, 0, 0),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1086] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [1088] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1092] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1104] = {.entry = {.count = 1, .reusable = false}}, SHIFT(380),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1110] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_shebang_line_repeat2, 1, 0, 13),
  [1112] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1116] = {.entry = {.count = 1, .reusable = false}}, SHIFT(59),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1122] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [1124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 2, 0, 0),
  [1126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 2, 0, 0), SHIFT_REPEAT(403),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 4, 0, 1),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1153] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__indented_backtick_repeat1, 1, 0, 0),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, 0, 1),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(250),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1183] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_string, 2, 0, 0),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 5, 0, 0),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 6, 0, 0),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_list, 4, 0, 0),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__setting_boolean, 2, 0, 0),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variadic_parameter, 2, 0, 0),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_just(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
