pub const ext = @import("ext.zig");
const appstreamcompose = @This();

const std = @import("std");
const compat = @import("compat");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const gdkpixbuf = @import("gdkpixbuf2");
const appstream = @import("appstream1");
pub const Canvas = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.CanvasClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `AscFont`.
    extern fn asc_canvas_new(p_width: c_int, p_height: c_int) *appstreamcompose.Canvas;
    pub const new = asc_canvas_new;

    /// Gets the canvas height.
    extern fn asc_canvas_get_height(p_canvas: *Canvas) c_uint;
    pub const getHeight = asc_canvas_get_height;

    /// Gets the canvas width.
    extern fn asc_canvas_get_width(p_canvas: *Canvas) c_uint;
    pub const getWidth = asc_canvas_get_width;

    /// Render an SVG graphic from the SVG data provided.
    extern fn asc_canvas_render_svg(p_canvas: *Canvas, p_stream: *gio.InputStream, p_error: ?*?*glib.Error) c_int;
    pub const renderSvg = asc_canvas_render_svg;

    /// Save canvas to PNG file.
    extern fn asc_canvas_save_png(p_canvas: *Canvas, p_fname: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const savePng = asc_canvas_save_png;

    extern fn asc_canvas_get_type() usize;
    pub const getGObjectType = asc_canvas_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Canvas) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Canvas) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Canvas, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Compose = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.ComposeClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.Compose`.
    extern fn asc_compose_new() *appstreamcompose.Compose;
    pub const new = asc_compose_new;

    /// Adds a component ID to the allowlist. If the list is not empty, only
    /// components in the list will be added to the metadata output.
    extern fn asc_compose_add_allowed_cid(p_compose: *Compose, p_component_id: [*:0]const u8) void;
    pub const addAllowedCid = asc_compose_add_allowed_cid;

    /// Add a key to the allowlist that is used to filter custom tag values.
    extern fn asc_compose_add_custom_allowed(p_compose: *Compose, p_key_id: [*:0]const u8) void;
    pub const addCustomAllowed = asc_compose_add_custom_allowed;

    /// Add compose flags.
    extern fn asc_compose_add_flags(p_compose: *Compose, p_flags: appstreamcompose.ComposeFlags) void;
    pub const addFlags = asc_compose_add_flags;

    /// Add an `appstreamcompose.Unit` as data source for metadata processing.
    extern fn asc_compose_add_unit(p_compose: *Compose, p_unit: *appstreamcompose.Unit) void;
    pub const addUnit = asc_compose_add_unit;

    /// Get the results components extracted in the last data processing run.
    extern fn asc_compose_fetch_components(p_compose: *Compose) *glib.PtrArray;
    pub const fetchComponents = asc_compose_fetch_components;

    /// Perform final validation of generated data for the specified
    /// result container.
    extern fn asc_compose_finalize_result(p_compose: *Compose, p_result: *appstreamcompose.Result) void;
    pub const finalizeResult = asc_compose_finalize_result;

    /// Perform final validation of generated data.
    /// Calling this function is not necessary, unless the final check was explicitly
    /// disabled using the `ASC_COMPOSE_FLAG_NO_FINAL_CHECK` flag.
    extern fn asc_compose_finalize_results(p_compose: *Compose) void;
    pub const finalizeResults = asc_compose_finalize_results;

    /// Get the CA file used to verify peers with, or `NULL` for default.
    extern fn asc_compose_get_cainfo(p_compose: *Compose) [*:0]const u8;
    pub const getCainfo = asc_compose_get_cainfo;

    /// Get the data result directory.
    extern fn asc_compose_get_data_result_dir(p_compose: *Compose) [*:0]const u8;
    pub const getDataResultDir = asc_compose_get_data_result_dir;

    /// Get the flags controlling compose behavior.
    extern fn asc_compose_get_flags(p_compose: *Compose) appstreamcompose.ComposeFlags;
    pub const getFlags = asc_compose_get_flags;

    /// get the format type we are generating.
    extern fn asc_compose_get_format(p_compose: *Compose) appstream.FormatKind;
    pub const getFormat = asc_compose_get_format;

    /// Get hints report output directory.
    extern fn asc_compose_get_hints_result_dir(p_compose: *Compose) [*:0]const u8;
    pub const getHintsResultDir = asc_compose_get_hints_result_dir;

    /// Get the policy for how icons should be distributed to
    /// any AppStream clients.
    extern fn asc_compose_get_icon_policy(p_compose: *Compose) *appstreamcompose.IconPolicy;
    pub const getIconPolicy = asc_compose_get_icon_policy;

    /// Get the icon result directory.
    extern fn asc_compose_get_icons_result_dir(p_compose: *Compose) [*:0]const u8;
    pub const getIconsResultDir = asc_compose_get_icons_result_dir;

    /// Get the unit we use for locale processing
    extern fn asc_compose_get_locale_unit(p_compose: *Compose) ?*appstreamcompose.Unit;
    pub const getLocaleUnit = asc_compose_get_locale_unit;

    /// Get the maximum size a screenshot video or image can have.
    /// A size < 0 may be returned for no limit, setting a limit of 0
    /// will disable screenshots.
    extern fn asc_compose_get_max_screenshot_size(p_compose: *Compose) isize;
    pub const getMaxScreenshotSize = asc_compose_get_max_screenshot_size;

    /// Get the media base URL to be used for the generated data,
    /// or `NULL` if no media is cached.
    extern fn asc_compose_get_media_baseurl(p_compose: *Compose) [*:0]const u8;
    pub const getMediaBaseurl = asc_compose_get_media_baseurl;

    /// Get the media result directory, that can be served on a webserver.
    extern fn asc_compose_get_media_result_dir(p_compose: *Compose) [*:0]const u8;
    pub const getMediaResultDir = asc_compose_get_media_result_dir;

    /// Get the metadata origin field.
    extern fn asc_compose_get_origin(p_compose: *Compose) [*:0]const u8;
    pub const getOrigin = asc_compose_get_origin;

    /// Get the directory prefix used for processing.
    extern fn asc_compose_get_prefix(p_compose: *Compose) [*:0]const u8;
    pub const getPrefix = asc_compose_get_prefix;

    /// Get the results of the last processing run.
    extern fn asc_compose_get_results(p_compose: *Compose) *glib.PtrArray;
    pub const getResults = asc_compose_get_results;

    /// Check if the last run generated any errors (which will cause metadata to be ignored).
    extern fn asc_compose_has_errors(p_compose: *Compose) c_int;
    pub const hasErrors = asc_compose_has_errors;

    /// Remove a key from the allowlist used to filter the `<custom/>` tag entries.
    extern fn asc_compose_remove_custom_allowed(p_compose: *Compose, p_key_id: [*:0]const u8) void;
    pub const removeCustomAllowed = asc_compose_remove_custom_allowed;

    /// Remove compose flags.
    extern fn asc_compose_remove_flags(p_compose: *Compose, p_flags: appstreamcompose.ComposeFlags) void;
    pub const removeFlags = asc_compose_remove_flags;

    /// Reset the results, units and run-specific settings so the
    /// instance can be reused for another metadata generation run.
    extern fn asc_compose_reset(p_compose: *Compose) void;
    pub const reset = asc_compose_reset;

    /// Process the registered units and generate catalog metadata from
    /// found components.
    extern fn asc_compose_run(p_compose: *Compose, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) ?*glib.PtrArray;
    pub const run = asc_compose_run;

    /// Set a CA file holding one or more certificates to verify peers with
    /// for download operations performed by this `appstreamcompose.Compose`.
    extern fn asc_compose_set_cainfo(p_compose: *Compose, p_cainfo: [*:0]const u8) void;
    pub const setCainfo = asc_compose_set_cainfo;

    /// Set an custom callback to be run when most of the metadata has been loaded,
    /// but no expensive operations (like downloads or icon rendering) have been done yet.
    /// This can be used to ignore unwanted components early on.
    ///
    /// The callback function may be called from any thread, so it needs to ensure thread safety on its own.
    extern fn asc_compose_set_check_metadata_early_func(p_compose: *Compose, p_func: appstreamcompose.CheckMetadataEarlyFn, p_user_data: ?*anyopaque) void;
    pub const setCheckMetadataEarlyFunc = asc_compose_set_check_metadata_early_func;

    /// Set an output location where generated metadata should be saved.
    /// If this is set to `NULL`, no metadata will be saved.
    extern fn asc_compose_set_data_result_dir(p_compose: *Compose, p_dir: [*:0]const u8) void;
    pub const setDataResultDir = asc_compose_set_data_result_dir;

    /// Set a custom desktop-entry field localization functions to be run for specialized
    /// desktop-entry localization schemes such as used in Ubuntu.
    ///
    /// The callback function may be called from any thread, so it needs to ensure thread safety on its own.
    extern fn asc_compose_set_desktop_entry_l10n_func(p_compose: *Compose, p_func: appstreamcompose.TranslateDesktopTextFn, p_user_data: ?*anyopaque) void;
    pub const setDesktopEntryL10nFunc = asc_compose_set_desktop_entry_l10n_func;

    /// Set compose flags bitfield that controls the enabled features
    /// for this `appstreamcompose.Compose`.
    extern fn asc_compose_set_flags(p_compose: *Compose, p_flags: appstreamcompose.ComposeFlags) void;
    pub const setFlags = asc_compose_set_flags;

    /// Set the format kind of the catalog metadata that we should generate.
    extern fn asc_compose_set_format(p_compose: *Compose, p_kind: appstream.FormatKind) void;
    pub const setFormat = asc_compose_set_format;

    /// Set an output location for HTML reports of issues generated
    /// during a compose run.
    extern fn asc_compose_set_hints_result_dir(p_compose: *Compose, p_dir: [*:0]const u8) void;
    pub const setHintsResultDir = asc_compose_set_hints_result_dir;

    /// Set an icon policy object, overriding the existing one.
    extern fn asc_compose_set_icon_policy(p_compose: *Compose, p_policy: *appstreamcompose.IconPolicy) void;
    pub const setIconPolicy = asc_compose_set_icon_policy;

    /// Set an output location where plain icons for the processed metadata
    /// are stored.
    extern fn asc_compose_set_icons_result_dir(p_compose: *Compose, p_dir: [*:0]const u8) void;
    pub const setIconsResultDir = asc_compose_set_icons_result_dir;

    /// Set a specific unit that is used for fetching locale information.
    /// This may be useful in case a special language pack layout is used,
    /// but is generally not necessary to be set explicitly, as locale
    /// will be found in the unit where the metadata is by default.
    extern fn asc_compose_set_locale_unit(p_compose: *Compose, p_locale_unit: *appstreamcompose.Unit) void;
    pub const setLocaleUnit = asc_compose_set_locale_unit;

    /// Set the maximum size a screenshot video or image can have.
    /// A size < 0 may be set to allow unlimited sizes, setting a limit of 0
    /// will disable screenshot caching entirely.
    extern fn asc_compose_set_max_screenshot_size(p_compose: *Compose, p_size_bytes: isize) void;
    pub const setMaxScreenshotSize = asc_compose_set_max_screenshot_size;

    /// Set the media base URL for the generated metadata. Can be `NULL` if no media
    /// should be cached and the original URLs should be kept.
    extern fn asc_compose_set_media_baseurl(p_compose: *Compose, p_url: ?[*:0]const u8) void;
    pub const setMediaBaseurl = asc_compose_set_media_baseurl;

    /// Set an output location to store media (screenshots, icons, ...) that
    /// will be served on a webserver via the URL set as media baseurl.
    extern fn asc_compose_set_media_result_dir(p_compose: *Compose, p_dir: [*:0]const u8) void;
    pub const setMediaResultDir = asc_compose_set_media_result_dir;

    /// Set the metadata origin field (e.g. "debian" or "flathub")
    extern fn asc_compose_set_origin(p_compose: *Compose, p_origin: [*:0]const u8) void;
    pub const setOrigin = asc_compose_set_origin;

    /// Set the directory prefix the to-be-processed units are using.
    extern fn asc_compose_set_prefix(p_compose: *Compose, p_prefix: [*:0]const u8) void;
    pub const setPrefix = asc_compose_set_prefix;

    extern fn asc_compose_get_type() usize;
    pub const getGObjectType = asc_compose_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Compose) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Compose) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Compose, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DirectoryUnit = extern struct {
    pub const Parent = appstreamcompose.Unit;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.DirectoryUnitClass;
    f_parent_instance: appstreamcompose.Unit,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.DirectoryUnit`.
    extern fn asc_directory_unit_new(p_root_dir: [*:0]const u8) *appstreamcompose.DirectoryUnit;
    pub const new = asc_directory_unit_new;

    /// Get the root directory path for this unit.
    extern fn asc_directory_unit_get_root(p_dirunit: *DirectoryUnit) [*:0]const u8;
    pub const getRoot = asc_directory_unit_get_root;

    /// Sets the root directory path for this unit.
    extern fn asc_directory_unit_set_root(p_dirunit: *DirectoryUnit, p_root_dir: [*:0]const u8) void;
    pub const setRoot = asc_directory_unit_set_root;

    extern fn asc_directory_unit_get_type() usize;
    pub const getGObjectType = asc_directory_unit_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.DirectoryUnit) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.DirectoryUnit) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DirectoryUnit, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Hint = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.HintClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.Hint`.
    extern fn asc_hint_new() *appstreamcompose.Hint;
    pub const new = asc_hint_new;

    /// Creates a new `appstreamcompose.Hint` with the given tag. If the selected tag was not registered+
    /// with the global tag registry, `NULL` is returned and an error is set.
    extern fn asc_hint_new_for_tag(p_tag: [*:0]const u8, p_error: ?*?*glib.Error) ?*appstreamcompose.Hint;
    pub const newForTag = asc_hint_new_for_tag;

    /// Add a replacement variable for the explanation text.
    extern fn asc_hint_add_explanation_var(p_hint: *Hint, p_var_name: [*:0]const u8, p_text: [*:0]const u8) void;
    pub const addExplanationVar = asc_hint_add_explanation_var;

    /// Formats the explanation template to return a human-redable issue hint
    /// explanation, with all placeholder variables replaced.
    extern fn asc_hint_format_explanation(p_hint: *Hint) [*:0]u8;
    pub const formatExplanation = asc_hint_format_explanation;

    /// Gets the explanation template for this hint.
    extern fn asc_hint_get_explanation_template(p_hint: *Hint) [*:0]const u8;
    pub const getExplanationTemplate = asc_hint_get_explanation_template;

    /// Returns a list with the flattened key/value pairs for this hint.
    /// Values are located in uneven list entries, following their keys in even list entries.
    extern fn asc_hint_get_explanation_vars_list(p_hint: *Hint) *glib.PtrArray;
    pub const getExplanationVarsList = asc_hint_get_explanation_vars_list;

    /// Gets the issue severity of this hint.
    extern fn asc_hint_get_severity(p_hint: *Hint) appstream.IssueSeverity;
    pub const getSeverity = asc_hint_get_severity;

    /// Gets the unique tag for the type of this hint.
    extern fn asc_hint_get_tag(p_hint: *Hint) [*:0]const u8;
    pub const getTag = asc_hint_get_tag;

    extern fn asc_hint_is_error(p_hint: *Hint) c_int;
    pub const isError = asc_hint_is_error;

    /// Check if this hint is valid (it requires at least a tag and a severity
    /// in order to be considered valid).
    extern fn asc_hint_is_valid(p_hint: *Hint) c_int;
    pub const isValid = asc_hint_is_valid;

    /// Sets the explanation template for this hint.
    extern fn asc_hint_set_explanation_template(p_hint: *Hint, p_explanation_tmpl: [*:0]const u8) void;
    pub const setExplanationTemplate = asc_hint_set_explanation_template;

    /// Sets the issue severity of this hint.
    extern fn asc_hint_set_severity(p_hint: *Hint, p_severity: appstream.IssueSeverity) void;
    pub const setSeverity = asc_hint_set_severity;

    /// Sets the unique tag for the type of this hint.
    extern fn asc_hint_set_tag(p_hint: *Hint, p_tag: [*:0]const u8) void;
    pub const setTag = asc_hint_set_tag;

    extern fn asc_hint_get_type() usize;
    pub const getGObjectType = asc_hint_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Hint) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Hint) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Hint, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const IconPolicy = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.IconPolicyClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.IconPolicy`.
    extern fn asc_icon_policy_new() *appstreamcompose.IconPolicy;
    pub const new = asc_icon_policy_new;

    /// Loads the icon policy from a textual representation.
    extern fn asc_icon_policy_from_string(p_ipolicy: *IconPolicy, p_serialized_policy: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const fromString = asc_icon_policy_from_string;

    /// Sets a designated state for an icon of the given size.
    extern fn asc_icon_policy_set_policy(p_ipolicy: *IconPolicy, p_icon_size: c_uint, p_icon_scale: c_uint, p_state: appstreamcompose.IconState) void;
    pub const setPolicy = asc_icon_policy_set_policy;

    /// Converts the current icon policy into a textual representation.
    extern fn asc_icon_policy_to_string(p_ipolicy: *IconPolicy) [*:0]u8;
    pub const toString = asc_icon_policy_to_string;

    extern fn asc_icon_policy_get_type() usize;
    pub const getGObjectType = asc_icon_policy_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.IconPolicy) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.IconPolicy) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *IconPolicy, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Image = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.ImageClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Get a set of image format names we can currently read
    /// (via GdkPixbuf).
    extern fn asc_image_supported_format_names() *glib.HashTable;
    pub const supportedFormatNames = asc_image_supported_format_names;

    /// Creates a new `appstreamcompose.Image`.
    extern fn asc_image_new() *appstreamcompose.Image;
    pub const new = asc_image_new;

    /// Creates a new `appstreamcompose.Image` from data in memory.
    extern fn asc_image_new_from_data(p_data: ?*anyopaque, p_len: isize, p_dest_size: c_uint, p_compressed: c_int, p_flags: appstreamcompose.ImageLoadFlags, p_error: ?*?*glib.Error) ?*appstreamcompose.Image;
    pub const newFromData = asc_image_new_from_data;

    /// Creates a new `appstreamcompose.Image` from a file on the filesystem.
    extern fn asc_image_new_from_file(p_fname: [*:0]const u8, p_dest_size: c_uint, p_flags: appstreamcompose.ImageLoadFlags, p_error: ?*?*glib.Error) ?*appstreamcompose.Image;
    pub const newFromFile = asc_image_new_from_file;

    /// Gets the image height.
    extern fn asc_image_get_height(p_image: *Image) c_uint;
    pub const getHeight = asc_image_get_height;

    /// Gets the image pixbuf if set.
    extern fn asc_image_get_pixbuf(p_image: *Image) *gdkpixbuf.Pixbuf;
    pub const getPixbuf = asc_image_get_pixbuf;

    /// Gets the image width.
    extern fn asc_image_get_width(p_image: *Image) c_uint;
    pub const getWidth = asc_image_get_width;

    /// Reads an image from a file.
    extern fn asc_image_load_filename(p_image: *Image, p_filename: [*:0]const u8, p_dest_size: c_uint, p_src_size_min: c_uint, p_flags: appstreamcompose.ImageLoadFlags, p_error: ?*?*glib.Error) c_int;
    pub const loadFilename = asc_image_load_filename;

    /// Saves the image to a file.
    extern fn asc_image_save_filename(p_image: *Image, p_filename: [*:0]const u8, p_width: c_uint, p_height: c_uint, p_flags: appstreamcompose.ImageSaveFlags, p_error: ?*?*glib.Error) c_int;
    pub const saveFilename = asc_image_save_filename;

    /// Resamples a pixbuf to a specific size.
    extern fn asc_image_save_pixbuf(p_image: *Image, p_width: c_uint, p_height: c_uint, p_flags: appstreamcompose.ImageSaveFlags) *gdkpixbuf.Pixbuf;
    pub const savePixbuf = asc_image_save_pixbuf;

    /// Scale the image to the given size.
    extern fn asc_image_scale(p_image: *Image, p_new_width: c_uint, p_new_height: c_uint) void;
    pub const scale = asc_image_scale;

    /// Scale the image to fir in a square with the given edge length,
    /// and keep its aspect ratio.
    extern fn asc_image_scale_to_fit(p_image: *Image, p_size: c_uint) void;
    pub const scaleToFit = asc_image_scale_to_fit;

    /// Scale the image to the given height, preserving
    /// its aspect ratio.
    extern fn asc_image_scale_to_height(p_image: *Image, p_new_height: c_uint) void;
    pub const scaleToHeight = asc_image_scale_to_height;

    /// Scale the image to the given width, preserving
    /// its aspect ratio.
    extern fn asc_image_scale_to_width(p_image: *Image, p_new_width: c_uint) void;
    pub const scaleToWidth = asc_image_scale_to_width;

    /// Sets the image pixbuf.
    extern fn asc_image_set_pixbuf(p_image: *Image, p_pixbuf: *gdkpixbuf.Pixbuf) void;
    pub const setPixbuf = asc_image_set_pixbuf;

    extern fn asc_image_get_type() usize;
    pub const getGObjectType = asc_image_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Image) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Image) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Image, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Result = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.ResultClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.Result`.
    extern fn asc_result_new() *appstreamcompose.Result;
    pub const new = asc_result_new;

    /// Add component to the results set.
    extern fn asc_result_add_component(p_result: *Result, p_cpt: *appstream.Component, p_bytes: *glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const addComponent = asc_result_add_component;

    /// Add component to the results set, using string data.
    extern fn asc_result_add_component_with_string(p_result: *Result, p_cpt: *appstream.Component, p_data: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const addComponentWithString = asc_result_add_component_with_string;

    /// Add an issue hint for a component.
    extern fn asc_result_add_hint(p_result: *Result, p_cpt: *appstream.Component, p_tag: [*:0]const u8, p_key1: [*:0]const u8, ...) c_int;
    pub const addHint = asc_result_add_hint;

    /// Add an issue hint for a component.
    extern fn asc_result_add_hint_by_cid(p_result: *Result, p_component_id: [*:0]const u8, p_tag: [*:0]const u8, p_key1: [*:0]const u8, ...) c_int;
    pub const addHintByCid = asc_result_add_hint_by_cid;

    /// Add an issue hint for a component.
    extern fn asc_result_add_hint_by_cid_v(p_result: *Result, p_component_id: [*:0]const u8, p_tag: [*:0]const u8, p_kv: *[*:0]u8) c_int;
    pub const addHintByCidV = asc_result_add_hint_by_cid_v;

    /// Add an issue hint which does not have any variables to replace in its
    /// explanation text for a component.
    extern fn asc_result_add_hint_simple(p_result: *Result, p_cpt: *appstream.Component, p_tag: [*:0]const u8) c_int;
    pub const addHintSimple = asc_result_add_hint_simple;

    /// Add an issue hint for a component.
    extern fn asc_result_add_hint_v(p_result: *Result, p_cpt: *appstream.Component, p_tag: [*:0]const u8, p_kv: *[*:0]u8) c_int;
    pub const addHintV = asc_result_add_hint_v;

    extern fn asc_result_components_count(p_result: *Result) c_uint;
    pub const componentsCount = asc_result_components_count;

    /// Gets all components this `AsResult` instance contains.
    extern fn asc_result_fetch_components(p_result: *Result) *glib.PtrArray;
    pub const fetchComponents = asc_result_fetch_components;

    /// Get a list of all hints for all components that are registered with this result.
    extern fn asc_result_fetch_hints_all(p_result: *Result) *glib.PtrArray;
    pub const fetchHintsAll = asc_result_fetch_hints_all;

    /// Retrieve the global component-ID string for the given component-ID,
    /// as long as component with the given ID is registered with this `appstreamcompose.Result`.
    /// Otherwise, `NULL` is returned.
    extern fn asc_result_gcid_for_cid(p_result: *Result, p_cid: [*:0]const u8) [*:0]const u8;
    pub const gcidForCid = asc_result_gcid_for_cid;

    extern fn asc_result_gcid_for_component(p_result: *Result, p_cpt: *appstream.Component) [*:0]const u8;
    pub const gcidForComponent = asc_result_gcid_for_component;

    /// Gets the ID name of the bundle (a package / Flatpak / any entity containing metadata)
    /// that these these results are generated for.
    extern fn asc_result_get_bundle_id(p_result: *Result) [*:0]const u8;
    pub const getBundleId = asc_result_get_bundle_id;

    /// Gets the bundle kind these results are for.
    extern fn asc_result_get_bundle_kind(p_result: *Result) appstream.BundleKind;
    pub const getBundleKind = asc_result_get_bundle_kind;

    /// Gets the component by its component-id-
    extern fn asc_result_get_component(p_result: *Result, p_cid: [*:0]const u8) *appstream.Component;
    pub const getComponent = asc_result_get_component;

    /// Retrieve a list of all global component-IDs that this result knows of.
    extern fn asc_result_get_component_gcids(p_result: *Result) [*][*:0]const u8;
    pub const getComponentGcids = asc_result_get_component_gcids;

    /// Gets list of component-IDs which do have issue hints associated with them.
    extern fn asc_result_get_component_ids_with_hints(p_result: *Result) [*][*:0]const u8;
    pub const getComponentIdsWithHints = asc_result_get_component_ids_with_hints;

    /// Gets hints for a component with the given component-id.
    extern fn asc_result_get_hints(p_result: *Result, p_cid: [*:0]const u8) *glib.PtrArray;
    pub const getHints = asc_result_get_hints;

    /// Test if a hint tag is associated with a given component in this result.
    extern fn asc_result_has_hint(p_result: *Result, p_cpt: *appstream.Component, p_tag: [*:0]const u8) c_int;
    pub const hasHint = asc_result_has_hint;

    extern fn asc_result_hints_count(p_result: *Result) c_uint;
    pub const hintsCount = asc_result_hints_count;

    /// Check if an `appstream.Component` was set to be ignored in this result
    /// (usually due to errors).
    extern fn asc_result_is_ignored(p_result: *Result, p_cpt: *appstream.Component) c_int;
    pub const isIgnored = asc_result_is_ignored;

    /// Remove a component from the results set.
    extern fn asc_result_remove_component(p_result: *Result, p_cpt: *appstream.Component) c_int;
    pub const removeComponent = asc_result_remove_component;

    /// Remove a component from the results set.
    extern fn asc_result_remove_component_by_id(p_result: *Result, p_cid: [*:0]const u8) c_int;
    pub const removeComponentById = asc_result_remove_component_by_id;

    /// Remove a component from the results set.
    extern fn asc_result_remove_component_full(p_result: *Result, p_cpt: *appstream.Component, p_remove_gcid: c_int) c_int;
    pub const removeComponentFull = asc_result_remove_component_full;

    /// Remove all hints that we have associated with the selected component-ID.
    extern fn asc_result_remove_hints_for_cid(p_result: *Result, p_cid: [*:0]const u8) void;
    pub const removeHintsForCid = asc_result_remove_hints_for_cid;

    /// Sets the name of the bundle these results are for.
    extern fn asc_result_set_bundle_id(p_result: *Result, p_id: [*:0]const u8) void;
    pub const setBundleId = asc_result_set_bundle_id;

    /// Sets the kind of the bundle these results are for.
    extern fn asc_result_set_bundle_kind(p_result: *Result, p_kind: appstream.BundleKind) void;
    pub const setBundleKind = asc_result_set_bundle_kind;

    extern fn asc_result_unit_ignored(p_result: *Result) c_int;
    pub const unitIgnored = asc_result_unit_ignored;

    /// Update the global component ID for the given component.
    extern fn asc_result_update_component_gcid(p_result: *Result, p_cpt: *appstream.Component, p_bytes: ?*glib.Bytes) c_int;
    pub const updateComponentGcid = asc_result_update_component_gcid;

    /// Update the global component ID for the given component.
    /// This is a convenience method for `appstreamcompose.Result.updateComponentGcid`
    extern fn asc_result_update_component_gcid_with_string(p_result: *Result, p_cpt: *appstream.Component, p_data: ?[*:0]const u8) c_int;
    pub const updateComponentGcidWithString = asc_result_update_component_gcid_with_string;

    extern fn asc_result_get_type() usize;
    pub const getGObjectType = asc_result_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Result) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Result) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Result, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Unit = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstreamcompose.UnitClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {
        /// Close this unit, possibly freeing its resources. Calls to `read_data` or
        /// `get_contents` may not produce results until `open` is called again.
        pub const close = struct {
            pub fn call(p_class: anytype, p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Unit.Class, p_class).f_close.?(gobject.ext.as(Unit, p_unit));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Unit.Class, p_class).f_close = @ptrCast(p_implementation);
            }
        };

        /// Returns `TRUE` if the directory exists and files in it are readable.
        pub const dir_exists = struct {
            pub fn call(p_class: anytype, p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_dirname: [*:0]const u8) c_int {
                return gobject.ext.as(Unit.Class, p_class).f_dir_exists.?(gobject.ext.as(Unit, p_unit), p_dirname);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_dirname: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(Unit.Class, p_class).f_dir_exists = @ptrCast(p_implementation);
            }
        };

        /// Returns `TRUE` if the filename exists and is readable using `appstreamcompose.Unit.readData`.
        pub const file_exists = struct {
            pub fn call(p_class: anytype, p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_filename: [*:0]const u8) c_int {
                return gobject.ext.as(Unit.Class, p_class).f_file_exists.?(gobject.ext.as(Unit, p_unit), p_filename);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_filename: [*:0]const u8) callconv(.C) c_int) void {
                gobject.ext.as(Unit.Class, p_class).f_file_exists = @ptrCast(p_implementation);
            }
        };

        /// Open this unit, populating its content listing.
        pub const open = struct {
            pub fn call(p_class: anytype, p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) c_int {
                return gobject.ext.as(Unit.Class, p_class).f_open.?(gobject.ext.as(Unit, p_unit), p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_error: ?*?*glib.Error) callconv(.C) c_int) void {
                gobject.ext.as(Unit.Class, p_class).f_open = @ptrCast(p_implementation);
            }
        };

        /// Read the contents of the selected file into memory and return them.
        pub const read_data = struct {
            pub fn call(p_class: anytype, p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_filename: [*:0]const u8, p_error: ?*?*glib.Error) ?*glib.Bytes {
                return gobject.ext.as(Unit.Class, p_class).f_read_data.?(gobject.ext.as(Unit, p_unit), p_filename, p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_unit: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_filename: [*:0]const u8, p_error: ?*?*glib.Error) callconv(.C) ?*glib.Bytes) void {
                gobject.ext.as(Unit.Class, p_class).f_read_data = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstreamcompose.Unit`.
    extern fn asc_unit_new() *appstreamcompose.Unit;
    pub const new = asc_unit_new;

    /// Add a path to the list of relevant directories.
    /// A unit may only read data in paths that were previously
    /// registered as relevant.
    extern fn asc_unit_add_relevant_path(p_unit: *Unit, p_path: [*:0]const u8) void;
    pub const addRelevantPath = asc_unit_add_relevant_path;

    /// Close this unit, possibly freeing its resources. Calls to `read_data` or
    /// `get_contents` may not produce results until `open` is called again.
    extern fn asc_unit_close(p_unit: *Unit) void;
    pub const close = asc_unit_close;

    /// Returns `TRUE` if the directory exists and files in it are readable.
    extern fn asc_unit_dir_exists(p_unit: *Unit, p_dirname: [*:0]const u8) c_int;
    pub const dirExists = asc_unit_dir_exists;

    /// Returns `TRUE` if the filename exists and is readable using `appstreamcompose.Unit.readData`.
    extern fn asc_unit_file_exists(p_unit: *Unit, p_filename: [*:0]const u8) c_int;
    pub const fileExists = asc_unit_file_exists;

    /// Gets the ID name of the bundle (a package / Flatpak / any entity containing metadata)
    /// that this unit represents.
    extern fn asc_unit_get_bundle_id(p_unit: *Unit) [*:0]const u8;
    pub const getBundleId = asc_unit_get_bundle_id;

    /// Gets the ID name of the bundle, normalized to be safe to use
    /// in filenames. This may *not* be the same name as set via `appstreamcompose.Unit.getBundleId`
    extern fn asc_unit_get_bundle_id_safe(p_unit: *Unit) [*:0]const u8;
    pub const getBundleIdSafe = asc_unit_get_bundle_id_safe;

    /// Gets the bundle kind of this unit.
    extern fn asc_unit_get_bundle_kind(p_unit: *Unit) appstream.BundleKind;
    pub const getBundleKind = asc_unit_get_bundle_kind;

    /// Get a list of all files contained by this unit.
    extern fn asc_unit_get_contents(p_unit: *Unit) *glib.PtrArray;
    pub const getContents = asc_unit_get_contents;

    /// Get a list of paths that are relevant for data processing.
    extern fn asc_unit_get_relevant_paths(p_unit: *Unit) *glib.PtrArray;
    pub const getRelevantPaths = asc_unit_get_relevant_paths;

    /// Get user-defined data. This is a helper
    /// function for bindings.
    extern fn asc_unit_get_user_data(p_unit: *Unit) ?*anyopaque;
    pub const getUserData = asc_unit_get_user_data;

    /// Open this unit, populating its content listing.
    extern fn asc_unit_open(p_unit: *Unit, p_error: ?*?*glib.Error) c_int;
    pub const open = asc_unit_open;

    /// Read the contents of the selected file into memory and return them.
    extern fn asc_unit_read_data(p_unit: *Unit, p_filename: [*:0]const u8, p_error: ?*?*glib.Error) ?*glib.Bytes;
    pub const readData = asc_unit_read_data;

    /// Sets the ID of the bundle represented by this unit.
    extern fn asc_unit_set_bundle_id(p_unit: *Unit, p_id: [*:0]const u8) void;
    pub const setBundleId = asc_unit_set_bundle_id;

    /// Sets the kind of the bundle this unit represents.
    extern fn asc_unit_set_bundle_kind(p_unit: *Unit, p_kind: appstream.BundleKind) void;
    pub const setBundleKind = asc_unit_set_bundle_kind;

    /// Set list of files this unit contains.
    extern fn asc_unit_set_contents(p_unit: *Unit, p_contents: *glib.PtrArray) void;
    pub const setContents = asc_unit_set_contents;

    /// Assign user-defined data to this object. This is a helper
    /// function for bindings.
    extern fn asc_unit_set_user_data(p_unit: *Unit, p_user_data: ?*anyopaque) void;
    pub const setUserData = asc_unit_set_user_data;

    extern fn asc_unit_get_type() usize;
    pub const getGObjectType = asc_unit_get_type;

    extern fn g_object_ref(p_self: *appstreamcompose.Unit) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstreamcompose.Unit) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Unit, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const CanvasClass = extern struct {
    pub const Instance = appstreamcompose.Canvas;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *CanvasClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ComposeClass = extern struct {
    pub const Instance = appstreamcompose.Compose;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ComposeClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DirectoryUnitClass = extern struct {
    pub const Instance = appstreamcompose.DirectoryUnit;

    f_parent_class: appstreamcompose.UnitClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *DirectoryUnitClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const HintClass = extern struct {
    pub const Instance = appstreamcompose.Hint;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *HintClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const IconPolicyClass = extern struct {
    pub const Instance = appstreamcompose.IconPolicy;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *IconPolicyClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `appstreamcompose.IconPolicyIter` structure represents an iterator that can be used
/// to iterate over the icon sizes / policy entries of an `appstreamcompose.IconPolicy`.
/// `appstreamcompose.IconPolicyIter` structures are typically allocated on the stack and
/// then initialized with `appstreamcompose.IconPolicyIter.init`.
pub const IconPolicyIter = extern struct {
    f_dummy1: ?*anyopaque,
    f_dummy2: c_uint,
    f_dummy3: ?*anyopaque,
    f_dummy4: ?*anyopaque,
    f_dummy5: ?*anyopaque,
    f_dummy6: ?*anyopaque,

    /// Initializes a policy iterator for the policy entry list and associates it
    /// it with `ipolicy`.
    /// The `appstreamcompose.IconPolicyIter` structure is typically allocated on the stack
    /// and does not need to be freed explicitly.
    extern fn asc_icon_policy_iter_init(p_iter: *IconPolicyIter, p_ipolicy: *appstreamcompose.IconPolicy) void;
    pub const init = asc_icon_policy_iter_init;

    /// Returns the current icon policy entry and advances the iterator.
    /// Example:
    /// ```
    /// AscIconPolicyIter iter;
    /// guint icon_size;
    /// guint icon_scale;
    /// AscIconState istate;
    ///
    /// asc_icon_policy_iter_init (&iter, ipolicy);
    /// while (asc_icon_policy_iter_next (&iter, &icon_size, &icon_scale, &istate)) {
    ///     // do something with the icon entry data
    /// }
    /// ```
    extern fn asc_icon_policy_iter_next(p_iter: *IconPolicyIter, p_size: ?*c_uint, p_scale: ?*c_uint, p_state: ?*appstreamcompose.IconState) c_int;
    pub const next = asc_icon_policy_iter_next;
};

pub const ImageClass = extern struct {
    pub const Instance = appstreamcompose.Image;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ImageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ResultClass = extern struct {
    pub const Instance = appstreamcompose.Result;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UnitClass = extern struct {
    pub const Instance = appstreamcompose.Unit;

    f_parent_class: gobject.ObjectClass,
    f_open: ?*const fn (p_unit: *appstreamcompose.Unit, p_error: ?*?*glib.Error) callconv(.C) c_int,
    f_close: ?*const fn (p_unit: *appstreamcompose.Unit) callconv(.C) void,
    f_file_exists: ?*const fn (p_unit: *appstreamcompose.Unit, p_filename: [*:0]const u8) callconv(.C) c_int,
    f_dir_exists: ?*const fn (p_unit: *appstreamcompose.Unit, p_dirname: [*:0]const u8) callconv(.C) c_int,
    f_read_data: ?*const fn (p_unit: *appstreamcompose.Unit, p_filename: [*:0]const u8, p_error: ?*?*glib.Error) callconv(.C) ?*glib.Bytes,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *UnitClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A drawing error.
pub const CanvasError = enum(c_int) {
    failed = 0,
    drawing = 1,
    font = 2,
    unsupported = 3,
    _,

    extern fn asc_canvas_error_quark() glib.Quark;
    pub const quark = asc_canvas_error_quark;

    extern fn asc_canvas_error_get_type() usize;
    pub const getGObjectType = asc_canvas_error_get_type;
};

/// A metadata composition error.
pub const ComposeError = enum(c_int) {
    failed = 0,
    _,

    extern fn asc_compose_error_quark() glib.Quark;
    pub const quark = asc_compose_error_quark;

    extern fn asc_compose_error_get_type() usize;
    pub const getGObjectType = asc_compose_error_get_type;
};

/// Designated state for an icon of a given size.
pub const IconState = enum(c_int) {
    ignored = 0,
    cached_remote = 1,
    cached_only = 2,
    remote_only = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn asc_icon_state_from_string(p_state_str: [*:0]const u8) appstreamcompose.IconState;
    pub const fromString = asc_icon_state_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn asc_icon_state_to_string(p_istate: appstreamcompose.IconState) [*:0]const u8;
    pub const toString = asc_icon_state_to_string;

    extern fn asc_icon_state_get_type() usize;
    pub const getGObjectType = asc_icon_state_get_type;
};

/// An image processing error.
pub const ImageError = enum(c_int) {
    failed = 0,
    unsupported = 1,
    _,

    extern fn asc_image_error_quark() glib.Quark;
    pub const quark = asc_image_error_quark;

    extern fn asc_image_error_get_type() usize;
    pub const getGObjectType = asc_image_error_get_type;
};

/// File format of an image.
pub const ImageFormat = enum(c_int) {
    unknown = 0,
    png = 1,
    jpeg = 2,
    gif = 3,
    svg = 4,
    svgz = 5,
    webp = 6,
    avif = 7,
    xpm = 8,
    _,

    /// Returns the image format type based on the given file's filename.
    extern fn asc_image_format_from_filename(p_fname: [*:0]const u8) appstreamcompose.ImageFormat;
    pub const fromFilename = asc_image_format_from_filename;

    /// Converts the text representation to an enumerated value.
    extern fn asc_image_format_from_string(p_str: [*:0]const u8) appstreamcompose.ImageFormat;
    pub const fromString = asc_image_format_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn asc_image_format_to_string(p_format: appstreamcompose.ImageFormat) [*:0]const u8;
    pub const toString = asc_image_format_to_string;

    extern fn asc_image_format_get_type() usize;
    pub const getGObjectType = asc_image_format_get_type;
};

pub const ComposeFlags = packed struct(c_uint) {
    use_threads: bool = false,
    allow_net: bool = false,
    validate: bool = false,
    store_screenshots: bool = false,
    allow_screencasts: bool = false,
    process_fonts: bool = false,
    process_translations: bool = false,
    ignore_icons: bool = false,
    process_unpaired_desktop: bool = false,
    propagate_custom: bool = false,
    propagate_artifacts: bool = false,
    no_final_check: bool = false,
    no_partial_urls: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ComposeFlags = @bitCast(@as(c_uint, 0));
    const flags_use_threads: ComposeFlags = @bitCast(@as(c_uint, 1));
    const flags_allow_net: ComposeFlags = @bitCast(@as(c_uint, 2));
    const flags_validate: ComposeFlags = @bitCast(@as(c_uint, 4));
    const flags_store_screenshots: ComposeFlags = @bitCast(@as(c_uint, 8));
    const flags_allow_screencasts: ComposeFlags = @bitCast(@as(c_uint, 16));
    const flags_process_fonts: ComposeFlags = @bitCast(@as(c_uint, 32));
    const flags_process_translations: ComposeFlags = @bitCast(@as(c_uint, 64));
    const flags_ignore_icons: ComposeFlags = @bitCast(@as(c_uint, 128));
    const flags_process_unpaired_desktop: ComposeFlags = @bitCast(@as(c_uint, 256));
    const flags_propagate_custom: ComposeFlags = @bitCast(@as(c_uint, 512));
    const flags_propagate_artifacts: ComposeFlags = @bitCast(@as(c_uint, 1024));
    const flags_no_final_check: ComposeFlags = @bitCast(@as(c_uint, 2048));
    const flags_no_partial_urls: ComposeFlags = @bitCast(@as(c_uint, 4096));
    extern fn asc_compose_flags_get_type() usize;
    pub const getGObjectType = asc_compose_flags_get_type;
};

/// The flags used for loading images.
pub const ImageLoadFlags = packed struct(c_uint) {
    sharpen: bool = false,
    allow_unsupported: bool = false,
    always_resize: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ImageLoadFlags = @bitCast(@as(c_uint, 0));
    const flags_sharpen: ImageLoadFlags = @bitCast(@as(c_uint, 1));
    const flags_allow_unsupported: ImageLoadFlags = @bitCast(@as(c_uint, 2));
    const flags_always_resize: ImageLoadFlags = @bitCast(@as(c_uint, 4));
    extern fn asc_image_load_flags_get_type() usize;
    pub const getGObjectType = asc_image_load_flags_get_type;
};

/// The flags used for saving images.
pub const ImageSaveFlags = packed struct(c_uint) {
    optimize: bool = false,
    pad_16_9: bool = false,
    sharpen: bool = false,
    blur: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ImageSaveFlags = @bitCast(@as(c_uint, 0));
    const flags_optimize: ImageSaveFlags = @bitCast(@as(c_uint, 1));
    const flags_pad_16_9: ImageSaveFlags = @bitCast(@as(c_uint, 2));
    const flags_sharpen: ImageSaveFlags = @bitCast(@as(c_uint, 4));
    const flags_blur: ImageSaveFlags = @bitCast(@as(c_uint, 8));
    extern fn asc_image_save_flags_get_type() usize;
    pub const getGObjectType = asc_image_save_flags_get_type;
};

/// Builds a global component ID from a component-id
/// and a (usually MD5) checksum generated from the component data.
///
/// The global-id is used as a global, unique identifier for a component.
/// (while the component-ID is local, e.g. for one source).
/// Its primary usecase is to identify a media directory on the filesystem which is
/// associated with this component.
extern fn asc_build_component_global_id(p_component_id: [*:0]const u8, p_checksum: [*:0]const u8) [*:0]u8;
pub const buildComponentGlobalId = asc_build_component_global_id;

/// Generate a filename from a web-URL that can be used to store the
/// file on disk after download.
extern fn asc_filename_from_url(p_url: [*:0]const u8) [*:0]u8;
pub const filenameFromUrl = asc_filename_from_url;

/// Register a new hint tag. If a previous tag with the given name
/// already existed, the existing tag will not be replaced unless
/// `overrideExisting` is set to `TRUE`.
/// Please be careful when overriding tags! Tag severities can not
/// be lowered by overriding a tag.
extern fn asc_globals_add_hint_tag(p_tag: [*:0]const u8, p_severity: appstream.IssueSeverity, p_explanation: [*:0]const u8, p_overrideExisting: c_int) c_int;
pub const globalsAddHintTag = asc_globals_add_hint_tag;

/// Clear all global state and restore defaults.
extern fn asc_globals_clear() void;
pub const globalsClear = asc_globals_clear;

/// Get path to the "ffprobe" binary we should use.
extern fn asc_globals_get_ffprobe_binary() [*:0]const u8;
pub const globalsGetFfprobeBinary = asc_globals_get_ffprobe_binary;

/// Retrieve all hint tags that we know.
extern fn asc_globals_get_hint_tags() [*][*:0]u8;
pub const globalsGetHintTags = asc_globals_get_hint_tags;

/// Get path to the "optipng" binary we should use.
extern fn asc_globals_get_optipng_binary() [*:0]const u8;
pub const globalsGetOptipngBinary = asc_globals_get_optipng_binary;

/// Get temporary directory used by appstream-compose.
extern fn asc_globals_get_tmp_dir() [*:0]const u8;
pub const globalsGetTmpDir = asc_globals_get_tmp_dir;

/// Get temporary directory used by appstream-compose
/// and try to create it if it does not exist.
extern fn asc_globals_get_tmp_dir_create() [*:0]const u8;
pub const globalsGetTmpDirCreate = asc_globals_get_tmp_dir_create;

/// Get whether images should be optimized using optipng.
extern fn asc_globals_get_use_optipng() c_int;
pub const globalsGetUseOptipng = asc_globals_get_use_optipng;

/// Retrieve the explanation template of the given hint tag.
extern fn asc_globals_hint_tag_explanation(p_tag: [*:0]const u8) [*:0]const u8;
pub const globalsHintTagExplanation = asc_globals_hint_tag_explanation;

/// Retrieve the severity of the given hint tag.
extern fn asc_globals_hint_tag_severity(p_tag: [*:0]const u8) appstream.IssueSeverity;
pub const globalsHintTagSeverity = asc_globals_hint_tag_severity;

/// Set path to the "ffprobe" binary we should use.
extern fn asc_globals_set_ffprobe_binary(p_path: [*:0]const u8) void;
pub const globalsSetFfprobeBinary = asc_globals_set_ffprobe_binary;

/// Set path to the "optipng" binary we should use.
extern fn asc_globals_set_optipng_binary(p_path: [*:0]const u8) void;
pub const globalsSetOptipngBinary = asc_globals_set_optipng_binary;

/// Set temporary directory used by appstream-compose.
extern fn asc_globals_set_tmp_dir(p_path: [*:0]const u8) void;
pub const globalsSetTmpDir = asc_globals_set_tmp_dir;

/// Set whether images should be optimized using optipng.
extern fn asc_globals_set_use_optipng(p_enabled: c_int) void;
pub const globalsSetUseOptipng = asc_globals_set_use_optipng;

/// Optimizes a PNG graphic for size with optipng, if its binary
/// is available and this feature is enabled.
extern fn asc_optimize_png(p_fname: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
pub const optimizePng = asc_optimize_png;

extern fn asc_pixbuf_blur(p_src: *gdkpixbuf.Pixbuf, p_radius: c_int, p_iterations: c_int) void;
pub const pixbufBlur = asc_pixbuf_blur;

extern fn asc_pixbuf_sharpen(p_src: *gdkpixbuf.Pixbuf, p_radius: c_int, p_amount: f64) void;
pub const pixbufSharpen = asc_pixbuf_sharpen;

/// Function which is called after all metainfo and related data (e.g. desktop-entry files)
/// has been loaded, but *before* any expensive operations such as screenshot downloads or
/// font searches are performed.
///
/// This function can be useful to filter out unwanted components early in the process and
/// avoid unneeded downloads and other data processing.
/// By the time this function is called, the component's global ID should be finalized
/// and should not change any longer.
///
/// Please note that this function may be called from any thread, and thread safety needs
/// to be taked care off by the callee.
pub const CheckMetadataEarlyFn = *const fn (p_cres: *appstreamcompose.Result, p_unit: *const appstreamcompose.Unit, p_user_data: ?*anyopaque) callconv(.C) void;

/// Function which is called while parsing a desktop-entry file to allow external
/// translations of string values. This is used in e.g. the Ubuntu distribution.
///
/// The return value must contain a list of strings with the locale name in even indices,
/// and the text translated to the preceding locale in the following odd indices.
pub const TranslateDesktopTextFn = *const fn (p_de: *const glib.KeyFile, p_text: [*:0]const u8, p_user_data: ?*anyopaque) callconv(.C) *glib.PtrArray;
