// { dg-do compile { target c++26 } }
// { dg-additional-options "-freflection" }
// Test std::meta::is_constructible_type.

#include <meta>

using namespace std::meta;

class ClassType { };
class DerivedType : public ClassType { };
enum EnumType { e0 };
struct ThrowDefaultClass { ThrowDefaultClass () noexcept (false); };
struct ThrowCopyConsClass { ThrowCopyConsClass (const ThrowCopyConsClass &) noexcept (false); };
struct ThrowMoveConsClass { ThrowMoveConsClass (ThrowMoveConsClass &&) noexcept (false); };
struct NoexceptDefaultClass { NoexceptDefaultClass () noexcept (true); };
struct ExceptDefaultClass { ExceptDefaultClass () noexcept (false); };
struct NoexceptCopyConsClass { NoexceptCopyConsClass (const NoexceptCopyConsClass &) noexcept (true); };
struct ExceptCopyConsClass { ExceptCopyConsClass (const ExceptCopyConsClass &) noexcept (false); };
struct NoexceptMoveConsClass { NoexceptMoveConsClass (NoexceptMoveConsClass &&) noexcept (true); NoexceptMoveConsClass &operator= (NoexceptMoveConsClass &&) = default; };
struct ExceptMoveConsClass { ExceptMoveConsClass (ExceptMoveConsClass &&) noexcept (false); };
struct NoexceptCopyAssignClass { NoexceptCopyAssignClass &operator= (const NoexceptCopyAssignClass &) noexcept (true); };
struct ExceptCopyAssignClass { ExceptCopyAssignClass &operator= (const ExceptCopyAssignClass &) noexcept (false); };
struct NoexceptMoveAssignClass { NoexceptMoveAssignClass (NoexceptMoveAssignClass &&) = default; NoexceptMoveAssignClass &operator= (NoexceptMoveAssignClass &&) noexcept (true); };
struct ExceptMoveAssignClass { ExceptMoveAssignClass &operator= (ExceptMoveAssignClass &&) noexcept (false); };
struct DeletedCopyAssignClass { DeletedCopyAssignClass & operator= (const DeletedCopyAssignClass &) = delete; };
struct DeletedMoveAssignClass { DeletedMoveAssignClass &operator= (DeletedMoveAssignClass &&) = delete; };
struct NType { int i; int j; virtual ~NType (); };
struct TType { int i; private: int j; };
struct SLType { int i; int j; ~SLType (); };
struct PODType { int i; int j; };
struct Empty {};
struct B { int i; B () {} };
struct D : B {};
enum E { ee1 };
enum E2 { ee2 };
enum class SE { e1 };
enum class SE2 { e2 };
enum OpE : int;
enum class OpSE : bool;
union U { int i; Empty b; };
struct Abstract { virtual ~Abstract () = 0; };
struct AbstractDelDtor { ~AbstractDelDtor () = delete; virtual void foo () = 0; };
struct Ukn;
template <class To>
struct ImplicitTo { operator To (); };
template <class To>
struct DelImplicitTo { operator To () = delete; };
template <class To>
struct ExplicitTo { explicit operator To (); };
struct Ellipsis { Ellipsis (...) {} };
struct DelEllipsis { DelEllipsis (...) = delete; };
struct Any { template <class T> Any (T &&) {} };
struct nAny { template <class... T> nAny (T &&...) {} };
struct DelnAny { template <class... T> DelnAny (T &&...) = delete; };
template <class... Args>
struct FromArgs { FromArgs (Args...); };
struct DelDef { DelDef () = delete; };
struct DelCopy { DelCopy (const DelCopy &) = delete; };
struct DelDtor {
  DelDtor () = default;
  DelDtor (const DelDtor &) = default;
  DelDtor (DelDtor &&) = default;
  DelDtor (int);
  DelDtor (int, B, U);
  ~DelDtor () = delete;
};
struct Nontrivial {
  Nontrivial ();
  Nontrivial (const Nontrivial &);
  Nontrivial &operator= (const Nontrivial &);
  ~Nontrivial ();
};
union NontrivialUnion { int i; Nontrivial n; };
struct UnusualCopy { UnusualCopy (UnusualCopy &); };

static_assert (is_constructible_type (^^int, { ^^int }));
static_assert (is_constructible_type (^^std::nullptr_t, { ^^std::nullptr_t }));
static_assert (is_constructible_type (^^E, { ^^E }));
static_assert (is_constructible_type (^^SE, { ^^SE }));
static_assert (is_constructible_type (^^OpE, { ^^OpE }));
static_assert (is_constructible_type (^^OpSE, { ^^OpSE }));
static_assert (is_constructible_type (^^Empty, { ^^Empty }));
static_assert (is_constructible_type (^^B, { ^^B }));
static_assert (is_constructible_type (^^U, { ^^U }));
static_assert (is_constructible_type (^^int B::*, { ^^int B::* }));
static_assert (is_constructible_type (^^Ellipsis, { ^^Ellipsis }));
static_assert (is_constructible_type (^^int *, { ^^int * }));
static_assert (is_constructible_type (^^void *, { ^^void * }));
static_assert (is_constructible_type (^^Any, { ^^Any }));
static_assert (is_constructible_type (^^nAny, { ^^nAny }));
static_assert (is_constructible_type (^^std::initializer_list <int>, { ^^std::initializer_list <int> }));
static_assert (is_constructible_type (^^DelDef, { ^^DelDef }));
static_assert (!is_constructible_type (^^void, { ^^void }));
static_assert (!is_constructible_type (^^Abstract, { ^^Abstract }));
static_assert (!is_constructible_type (^^int [], { ^^int [] }));
static_assert (!is_constructible_type (^^int [1], { ^^int [1] }));
static_assert (!is_constructible_type (^^DelCopy, { ^^const DelCopy & }));
static_assert (!is_constructible_type (^^DelCopy, { ^^DelCopy && }));
static_assert (!is_constructible_type (^^DelCopy, { ^^DelCopy }));
static_assert (!is_constructible_type (^^DelDtor, { ^^void }));
static_assert (!is_constructible_type (^^DelDtor, { ^^int }));
static_assert (!is_constructible_type (^^DelDtor, { ^^DelDtor }));
static_assert (!is_constructible_type (^^DelDtor, { ^^DelDtor && }));
static_assert (!is_constructible_type (^^DelDtor, { ^^const DelDtor & }));
static_assert (is_constructible_type (^^DelEllipsis, { ^^const DelEllipsis & }));
static_assert (is_constructible_type (^^DelEllipsis, { ^^DelEllipsis && }));
static_assert (is_constructible_type (^^DelEllipsis, { ^^DelEllipsis }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^void }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^B }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^Empty }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^E }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^SE }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^OpE }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^OpSE }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^void () }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^void () const }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^int [1] }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^int [] }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^int * }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^void * }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^int B::* }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^int D::* }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^Abstract }));
static_assert (!is_constructible_type (^^int, { ^^DelImplicitTo <int> }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^DelImplicitTo <std::nullptr_t> }));
static_assert (!is_constructible_type (^^int &, { ^^DelImplicitTo <const int &> }));
static_assert (!is_constructible_type (^^int, { ^^void }));
static_assert (!is_constructible_type (^^void, { ^^int }));
static_assert (is_constructible_type (^^void *, { ^^int * }));
static_assert (!is_constructible_type (^^int *, { ^^void * }));
static_assert (is_constructible_type (^^int *, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^int * }));
static_assert (!is_constructible_type (^^Empty, { ^^E }));
static_assert (!is_constructible_type (^^Empty, { ^^SE }));
static_assert (!is_constructible_type (^^Empty, { ^^OpE }));
static_assert (!is_constructible_type (^^Empty, { ^^OpSE }));
static_assert (!is_constructible_type (^^Empty, { ^^void }));
static_assert (!is_constructible_type (^^Empty, { ^^void * }));
static_assert (!is_constructible_type (^^Empty, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^Empty, { ^^int [] }));
static_assert (!is_constructible_type (^^Empty, { ^^int [3] }));
static_assert (!is_constructible_type (^^Empty, { ^^int }));
static_assert (!is_constructible_type (^^Abstract, { ^^int }));
static_assert (!is_constructible_type (^^Abstract, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^Abstract }));
static_assert (!is_constructible_type (^^Abstract, { ^^int [] }));
static_assert (is_constructible_type (^^B, { ^^D }));
static_assert (!is_constructible_type (^^int [], { ^^int [1] }));
static_assert (!is_constructible_type (^^int [1], { ^^int [] }));
static_assert (!is_constructible_type (^^int [], { ^^Empty }));
static_assert (!is_constructible_type (^^int [], { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^int [1], { ^^Abstract }));
static_assert (is_constructible_type (^^const int *, { ^^int * }));
static_assert (is_constructible_type (^^const void *, { ^^void * }));
static_assert (is_constructible_type (^^const void *, { ^^int * }));
static_assert (!is_constructible_type (^^int *, { ^^const void * }));
static_assert (is_constructible_type (^^int, { ^^E }));
static_assert (!is_constructible_type (^^E, { ^^int }));
static_assert (!is_constructible_type (^^E, { ^^E2 }));
static_assert (is_constructible_type (^^E, { ^^E }));
static_assert (is_constructible_type (^^bool, { ^^E }));
static_assert (!is_constructible_type (^^E, { ^^bool }));
static_assert (is_constructible_type (^^double, { ^^E }));
static_assert (!is_constructible_type (^^E, { ^^double }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^E }));
static_assert (!is_constructible_type (^^E, { ^^std::nullptr_t }));
static_assert (is_constructible_type (^^int, { ^^OpE }));
static_assert (!is_constructible_type (^^OpE, { ^^int }));
static_assert (!is_constructible_type (^^OpE, { ^^E2 }));
static_assert (is_constructible_type (^^OpE, { ^^OpE }));
static_assert (is_constructible_type (^^bool, { ^^OpE }));
static_assert (!is_constructible_type (^^OpE, { ^^bool }));
static_assert (is_constructible_type (^^double, { ^^OpE }));
static_assert (!is_constructible_type (^^OpE, { ^^double }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^OpE }));
static_assert (!is_constructible_type (^^OpE, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^int, { ^^SE }));
static_assert (!is_constructible_type (^^SE, { ^^int }));
static_assert (!is_constructible_type (^^E, { ^^SE }));
static_assert (!is_constructible_type (^^SE, { ^^SE2 }));
static_assert (is_constructible_type (^^SE, { ^^SE }));
static_assert (!is_constructible_type (^^bool, { ^^SE }));
static_assert (!is_constructible_type (^^SE, { ^^bool }));
static_assert (!is_constructible_type (^^double, { ^^SE }));
static_assert (!is_constructible_type (^^SE, { ^^double }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^SE }));
static_assert (!is_constructible_type (^^SE, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^int, { ^^OpSE }));
static_assert (!is_constructible_type (^^OpSE, { ^^int }));
static_assert (!is_constructible_type (^^OpE, { ^^OpSE }));
static_assert (!is_constructible_type (^^OpSE, { ^^SE2 }));
static_assert (is_constructible_type (^^OpSE, { ^^OpSE }));
static_assert (!is_constructible_type (^^bool, { ^^OpSE }));
static_assert (!is_constructible_type (^^OpSE, { ^^bool }));
static_assert (!is_constructible_type (^^double, { ^^OpSE }));
static_assert (!is_constructible_type (^^OpSE, { ^^double }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^OpSE }));
static_assert (!is_constructible_type (^^OpSE, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^D *, { ^^B * }));
static_assert (!is_constructible_type (^^const volatile D *, { ^^B * }));
static_assert (!is_constructible_type (^^D *, { ^^const volatile B * }));
static_assert (!is_constructible_type (^^D *, { ^^B * const }));
static_assert (!is_constructible_type (^^const volatile D *, { ^^B * const }));
static_assert (!is_constructible_type (^^D *, { ^^const volatile B * const }));
static_assert (!is_constructible_type (^^D *, { ^^B * & }));
static_assert (!is_constructible_type (^^const volatile D *, { ^^B * & }));
static_assert (!is_constructible_type (^^D *, { ^^const volatile B * & }));
static_assert (!is_constructible_type (^^int B::*, { ^^int D::* }));
static_assert (!is_constructible_type (^^const volatile int B::*, { ^^int D::* }));
static_assert (!is_constructible_type (^^int B::*, { ^^const volatile int D::* }));
static_assert (!is_constructible_type (^^int B::*, { ^^int D::* const }));
static_assert (!is_constructible_type (^^const volatile int B::*, { ^^int D::* const }));
static_assert (!is_constructible_type (^^int B::*, { ^^const volatile int D::* const }));
static_assert (!is_constructible_type (^^int B::*, { ^^int D::* & }));
static_assert (!is_constructible_type (^^const volatile int B::*, { ^^int D::* & }));
static_assert (!is_constructible_type (^^int B::*, { ^^const volatile int D::* & }));
static_assert (!is_constructible_type (^^int B::*, { ^^int D::* const & }));
static_assert (!is_constructible_type (^^const volatile int B::*, { ^^int D::* const & }));
static_assert (!is_constructible_type (^^int B::*, { ^^const volatile int D::* const & }));
static_assert (!is_constructible_type (^^int &&, { ^^int & }));
static_assert (!is_constructible_type (^^const int &&, { ^^int & }));
static_assert (is_constructible_type (^^B &, { ^^D & }));
static_assert (is_constructible_type (^^B &&, { ^^D && }));
static_assert (is_constructible_type (^^const B &, { ^^D & }));
static_assert (is_constructible_type (^^const B &&, { ^^D && }));
static_assert (!is_constructible_type (^^B &, { ^^const D & }));
static_assert (!is_constructible_type (^^B &&, { ^^const D && }));
static_assert (!is_constructible_type (^^D &, { ^^B & }));
static_assert (is_constructible_type (^^D &&, { ^^B && }));
static_assert (!is_constructible_type (^^D &, { ^^const B & }));
static_assert (is_constructible_type (^^D &&, { ^^const B && }));
static_assert (is_constructible_type (^^const D &, { ^^B & }));
static_assert (is_constructible_type (^^const D &&, { ^^B && }));
static_assert (!is_constructible_type (^^B &&, { ^^B & }));
static_assert (!is_constructible_type (^^B &&, { ^^D & }));
static_assert (is_constructible_type (^^B &&, { ^^ImplicitTo <D &&> }));
static_assert (is_constructible_type (^^B &&, { ^^ImplicitTo <D &&> & }));
static_assert (is_constructible_type (^^int &&, { ^^double & }));
static_assert (is_constructible_type (^^const int &, { ^^ImplicitTo <int &> & }));
static_assert (is_constructible_type (^^const int &, { ^^ImplicitTo <int &> }));
static_assert (is_constructible_type (^^const int &, { ^^ExplicitTo <int &> & }));
static_assert (is_constructible_type (^^const int &, { ^^ExplicitTo <int &> }));
static_assert (!is_constructible_type (^^B &&, { ^^ExplicitTo <D &&> }));
static_assert (!is_constructible_type (^^B &&, { ^^ExplicitTo <D &&> & }));
static_assert (!is_constructible_type (^^B &, { ^^B && }));
static_assert (!is_constructible_type (^^D &, { ^^B && }));
static_assert (!is_constructible_type (^^B &, { ^^D && }));
static_assert (is_constructible_type (^^void (&) (), { ^^void (&) () }));
static_assert (is_constructible_type (^^void (&&) (), { ^^void (&&) () }));
static_assert (is_constructible_type (^^void (&&) (), { ^^void () }));
static_assert (!is_constructible_type (^^void, { }));
static_assert (!is_constructible_type (^^void, { ^^int }));
static_assert (!is_constructible_type (^^void, { ^^int, ^^double }));
static_assert (!is_constructible_type (^^int &, {}));
static_assert (!is_constructible_type (^^const int &, {}));
static_assert (!is_constructible_type (^^int &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const int &, { ^^int, ^^int }));
static_assert (is_constructible_type (^^void (&) (), { ^^void () }));
static_assert (is_constructible_type (^^void (&) (), { ^^void (&&) () }));
static_assert (is_constructible_type (^^int &, { ^^int & }));
static_assert (!is_constructible_type (^^int &, { ^^const int & }));
static_assert (!is_constructible_type (^^int &, { ^^int }));
static_assert (!is_constructible_type (^^int &, { ^^int && }));
static_assert (!is_constructible_type (^^int &, { ^^const int && }));
static_assert (is_constructible_type (^^const int &, { ^^int & }));
static_assert (is_constructible_type (^^const int &, { ^^int }));
static_assert (is_constructible_type (^^const int &, { ^^const int }));
static_assert (is_constructible_type (^^const int &, { ^^int && }));
static_assert (is_constructible_type (^^const int &, { ^^const int && }));
static_assert (is_constructible_type (^^volatile int &, { ^^int & }));
static_assert (!is_constructible_type (^^volatile int &, { ^^const int & }));
static_assert (!is_constructible_type (^^volatile int &, { ^^int }));
static_assert (!is_constructible_type (^^volatile int &, { ^^int && }));
static_assert (!is_constructible_type (^^volatile int &, { ^^const int && }));
static_assert (is_constructible_type (^^const volatile int &, { ^^int & }));
static_assert (!is_constructible_type (^^const volatile int &, { ^^int }));
static_assert (!is_constructible_type (^^const volatile int &, { ^^const int }));
static_assert (!is_constructible_type (^^const volatile int &, { ^^int && }));
static_assert (!is_constructible_type (^^const volatile int &, { ^^const int && }));
static_assert (is_constructible_type (^^int &&, { ^^int }));
static_assert (is_constructible_type (^^int &&, { ^^int && }));
static_assert (!is_constructible_type (^^int &&, { ^^const int && }));
static_assert (!is_constructible_type (^^int &&, { ^^int & }));
static_assert (!is_constructible_type (^^int &&, { ^^const int & }));
static_assert (is_constructible_type (^^int &&, { ^^double & }));
static_assert (is_constructible_type (^^const int &&, { ^^int }));
static_assert (is_constructible_type (^^const int &&, { ^^int && }));
static_assert (is_constructible_type (^^const int &&, { ^^const int }));
static_assert (is_constructible_type (^^const int &&, { ^^const int && }));
static_assert (!is_constructible_type (^^int &&, { ^^const int & }));
static_assert (!is_constructible_type (^^const int &&, { ^^int & }));
static_assert (!is_constructible_type (^^const int &&, { ^^const int & }));
static_assert (is_constructible_type (^^volatile int &&, { ^^int }));
static_assert (is_constructible_type (^^volatile int &&, { ^^int && }));
static_assert (!is_constructible_type (^^volatile int &&, { ^^const int && }));
static_assert (!is_constructible_type (^^volatile int &&, { ^^int & }));
static_assert (!is_constructible_type (^^volatile int &&, { ^^const int & }));
static_assert (is_constructible_type (^^volatile int &&, { ^^double & }));
static_assert (is_constructible_type (^^volatile const int &&, { ^^int }));
static_assert (is_constructible_type (^^const volatile int &&, { ^^int && }));
static_assert (is_constructible_type (^^const volatile int &&, { ^^const int }));
static_assert (is_constructible_type (^^const volatile int &&, { ^^const int && }));
static_assert (!is_constructible_type (^^volatile int &&, { ^^const int & }));
static_assert (!is_constructible_type (^^const volatile int &&, { ^^int & }));
static_assert (!is_constructible_type (^^const volatile int &&, { ^^const int & }));
static_assert (is_constructible_type (^^Empty &, { ^^Empty & }));
static_assert (!is_constructible_type (^^Empty &, { ^^const Empty & }));
static_assert (!is_constructible_type (^^Empty &, { ^^Empty }));
static_assert (!is_constructible_type (^^Empty &, { ^^Empty && }));
static_assert (!is_constructible_type (^^Empty &, { ^^const Empty && }));
static_assert (is_constructible_type (^^const Empty &, { ^^Empty & }));
static_assert (is_constructible_type (^^const Empty &, { ^^Empty }));
static_assert (is_constructible_type (^^const Empty &, { ^^const Empty }));
static_assert (is_constructible_type (^^const Empty &, { ^^Empty && }));
static_assert (is_constructible_type (^^const Empty &, { ^^const Empty && }));
static_assert (is_constructible_type (^^volatile Empty &, { ^^Empty & }));
static_assert (!is_constructible_type (^^volatile Empty &, { ^^const Empty & }));
static_assert (!is_constructible_type (^^volatile Empty &, { ^^Empty }));
static_assert (!is_constructible_type (^^volatile Empty &, { ^^Empty && }));
static_assert (!is_constructible_type (^^volatile Empty &, { ^^const Empty && }));
static_assert (is_constructible_type (^^const volatile Empty &, { ^^Empty & }));
static_assert (!is_constructible_type (^^const volatile Empty &, { ^^Empty }));
static_assert (!is_constructible_type (^^const volatile Empty &, { ^^const Empty }));
static_assert (!is_constructible_type (^^const volatile Empty &, { ^^Empty && }));
static_assert (!is_constructible_type (^^const volatile Empty &, { ^^const Empty && }));
static_assert (is_constructible_type (^^Empty &&, { ^^Empty }));
static_assert (is_constructible_type (^^Empty &&, { ^^Empty && }));
static_assert (!is_constructible_type (^^Empty &&, { ^^const Empty && }));
static_assert (!is_constructible_type (^^Empty &&, { ^^Empty & }));
static_assert (!is_constructible_type (^^Empty &&, { ^^const Empty & }));
static_assert (!is_constructible_type (^^Empty &&, { ^^double & }));
static_assert (!is_constructible_type (^^Empty &&, { ^^const double & }));
static_assert (is_constructible_type (^^const Empty &&, { ^^Empty }));
static_assert (is_constructible_type (^^const Empty &&, { ^^Empty && }));
static_assert (is_constructible_type (^^const Empty &&, { ^^const Empty }));
static_assert (is_constructible_type (^^const Empty &&, { ^^const Empty && }));
static_assert (!is_constructible_type (^^Empty &&, { ^^const Empty & }));
static_assert (!is_constructible_type (^^const Empty &&, { ^^Empty & }));
static_assert (!is_constructible_type (^^const Empty &&, { ^^const Empty & }));
static_assert (is_constructible_type (^^volatile Empty &&, { ^^Empty }));
static_assert (is_constructible_type (^^volatile Empty &&, { ^^Empty && }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^const Empty && }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^Empty & }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^const Empty & }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^double & }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^const double & }));
static_assert (is_constructible_type (^^const volatile Empty &&, { ^^Empty }));
static_assert (is_constructible_type (^^const volatile Empty &&, { ^^Empty && }));
static_assert (is_constructible_type (^^const volatile Empty &&, { ^^const Empty }));
static_assert (is_constructible_type (^^const volatile Empty &&, { ^^const Empty && }));
static_assert (!is_constructible_type (^^volatile Empty &&, { ^^const Empty & }));
static_assert (!is_constructible_type (^^const volatile Empty &&, { ^^Empty & }));
static_assert (!is_constructible_type (^^const volatile Empty &&, { ^^const Empty & }));
static_assert (is_constructible_type (^^Ellipsis, { ^^int }));
static_assert (is_constructible_type (^^Ellipsis, { ^^Empty }));
static_assert (is_constructible_type (^^Ellipsis, { ^^std::nullptr_t }));
static_assert (is_constructible_type (^^Ellipsis, { ^^int [] }));
static_assert (is_constructible_type (^^Ellipsis, { ^^int [1] }));
static_assert (!is_constructible_type (^^Ellipsis, { ^^void }));
static_assert (is_constructible_type (^^int (&) [1], { ^^int (&) [1] }));
static_assert (is_constructible_type (^^const int (&) [1], { ^^int (&) [1] }));
static_assert (is_constructible_type (^^volatile int (&) [1], { ^^int (&) [1] }));
static_assert (is_constructible_type (^^const volatile int (&) [1], { ^^int (&) [1] }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^const int (&) [1] }));
static_assert (!is_constructible_type (^^const int (&) [1], { ^^volatile int (&) [1] }));
static_assert (is_constructible_type (^^int (&) [], { ^^int (&) [] }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^int (&) [2] }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^int & }));
static_assert (!is_constructible_type (^^int &, { ^^int (&) [1] }));
static_assert (!is_constructible_type (^^U, { ^^Empty }));
static_assert (!is_constructible_type (^^void (), { ^^void () }));
static_assert (!is_constructible_type (^^void (), { ^^int }));
static_assert (!is_constructible_type (^^void (), { ^^Abstract }));
static_assert (!is_constructible_type (^^void (), { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^void (), { ^^Empty }));
static_assert (!is_constructible_type (^^void (), { ^^U }));
static_assert (!is_constructible_type (^^void (), { ^^E }));
static_assert (!is_constructible_type (^^void (), { ^^SE }));
static_assert (!is_constructible_type (^^void (), { ^^OpE }));
static_assert (!is_constructible_type (^^void (), { ^^OpSE }));
static_assert (!is_constructible_type (^^void (), { ^^int [] }));
static_assert (!is_constructible_type (^^void (), { ^^int [1] }));
static_assert (!is_constructible_type (^^void () const, { ^^void () volatile }));
static_assert (!is_constructible_type (^^void () const, { ^^int }));
static_assert (!is_constructible_type (^^void () const, { ^^Abstract }));
static_assert (!is_constructible_type (^^void () const, { ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^void () const, { ^^Empty }));
static_assert (!is_constructible_type (^^void () const, { ^^U }));
static_assert (!is_constructible_type (^^void () const, { ^^E }));
static_assert (!is_constructible_type (^^void () const, { ^^SE }));
static_assert (!is_constructible_type (^^void () const, { ^^OpE }));
static_assert (!is_constructible_type (^^void () const, { ^^OpSE }));
static_assert (!is_constructible_type (^^void () const, { ^^int [] }));
static_assert (!is_constructible_type (^^void () const, { ^^int [1] }));
static_assert (!is_constructible_type (^^void (int), { ^^void () }));
static_assert (!is_constructible_type (^^int, { ^^void () }));
static_assert (!is_constructible_type (^^Abstract, { ^^void () }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^void () }));
static_assert (!is_constructible_type (^^Empty, { ^^void () }));
static_assert (!is_constructible_type (^^U, { ^^void () }));
static_assert (!is_constructible_type (^^E, { ^^void () }));
static_assert (!is_constructible_type (^^SE, { ^^void () }));
static_assert (!is_constructible_type (^^OpE, { ^^void () }));
static_assert (!is_constructible_type (^^OpSE, { ^^void () }));
static_assert (!is_constructible_type (^^int [], { ^^void () }));
static_assert (!is_constructible_type (^^int [1], { ^^void () }));
static_assert (!is_constructible_type (^^void (int) const, { ^^void () const }));
static_assert (!is_constructible_type (^^int, { ^^void () const }));
static_assert (!is_constructible_type (^^Abstract, { ^^void () const }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^void () const }));
static_assert (!is_constructible_type (^^Empty, { ^^void () const }));
static_assert (!is_constructible_type (^^U, { ^^void () const }));
static_assert (!is_constructible_type (^^E, { ^^void () const }));
static_assert (!is_constructible_type (^^SE, { ^^void () const }));
static_assert (!is_constructible_type (^^OpE, { ^^void () const }));
static_assert (!is_constructible_type (^^OpSE, { ^^void () const }));
static_assert (!is_constructible_type (^^int [], { ^^void () const }));
static_assert (!is_constructible_type (^^int [1], { ^^void () const }));
static_assert (!is_constructible_type (^^void, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^void, { ^^Empty, ^^B }));
static_assert (!is_constructible_type (^^void, { ^^Empty, ^^Empty }));
static_assert (!is_constructible_type (^^void, { ^^U, ^^Empty }));
static_assert (!is_constructible_type (^^void, { ^^U, ^^U }));
static_assert (!is_constructible_type (^^void, { ^^std::nullptr_t, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^void, { ^^int [1], ^^int [1] }));
static_assert (!is_constructible_type (^^void, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^void, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^void, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^void, { ^^void (), ^^void () }));
static_assert (!is_constructible_type (^^void, { ^^void () const, ^^void () volatile }));
static_assert (!is_constructible_type (^^int, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const int, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^int, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const int, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^int, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const int, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^bool, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const bool, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const std::nullptr_t, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const std::nullptr_t, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^std::nullptr_t, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const std::nullptr_t, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^E, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const E, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^E, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const E, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^E, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const E, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^SE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const SE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^SE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const SE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^SE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const SE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^OpE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const OpE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^OpE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const OpE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^OpE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const OpE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^OpSE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const OpSE, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^OpSE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const OpSE, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^OpSE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const OpSE, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Empty, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const Empty, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Empty, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const Empty, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Empty, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const Empty, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^U, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const U, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^U, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const U, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^U, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const U, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^B, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const B, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^B, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const B, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^B, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const B, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Any, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const Any, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Any, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const Any, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Any, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const Any, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^nAny, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const nAny, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^nAny, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const nAny, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^FromArgs <>, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <>, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <>, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const FromArgs <>, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Abstract, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const Abstract, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Abstract, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const Abstract, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Abstract, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const Abstract, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^AbstractDelDtor, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const AbstractDelDtor, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^AbstractDelDtor, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const AbstractDelDtor, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^AbstractDelDtor, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const AbstractDelDtor, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^int [1], { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const int [1], { ^^int, ^^int }));
static_assert (!is_constructible_type (^^int [1], { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const int [1], { ^^void, ^^int }));
static_assert (!is_constructible_type (^^int [1], { ^^void, ^^void }));
static_assert (!is_constructible_type (^^const int [1], { ^^void, ^^void }));
static_assert (!is_constructible_type (^^int &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^int &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^int &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^int &, { ^^int &, ^^int & }));
static_assert (!is_constructible_type (^^int &, { ^^void, ^^int & }));
static_assert (!is_constructible_type (^^int &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^std::nullptr_t &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^std::nullptr_t &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^std::nullptr_t &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^E &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^E &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^E &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^SE &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^SE &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^SE &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^OpE &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^OpE &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^OpE &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^OpSE &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^OpSE &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^OpSE &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Empty &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Empty &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Empty &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^U &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^U &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^U &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^B &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^B &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^B &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Any &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Any &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Any &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^nAny &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^nAny &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^FromArgs <> &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <> &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <> &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^Abstract &, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^Abstract &, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^Abstract &, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^int, ^^int }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^void, ^^int }));
static_assert (!is_constructible_type (^^int (&) [1], { ^^void, ^^void }));
static_assert (!is_constructible_type (^^void (), { ^^int, ^^int }));
static_assert (!is_constructible_type (^^void (), { ^^void, ^^int }));
static_assert (!is_constructible_type (^^void (), { ^^void, ^^void }));
static_assert (!is_constructible_type (^^void (), { ^^void (), ^^int }));
static_assert (!is_constructible_type (^^void (), { ^^void (), ^^void () }));
static_assert (!is_constructible_type (^^void () const, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^void () const, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^void () const, { ^^void, ^^void }));
static_assert (!is_constructible_type (^^void () const, { ^^void () volatile, ^^int }));
static_assert (!is_constructible_type (^^void () const, { ^^void () volatile const, ^^void () const }));
static_assert (!is_constructible_type (^^FromArgs <int>, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <int>, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <int>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <int>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^FromArgs <int, int>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <int, int>, { ^^void, ^^int }));
static_assert (!is_constructible_type (^^DelDtor, { ^^int, ^^B, ^^U }));
static_assert (!is_constructible_type (^^const DelDtor, { ^^int, ^^B, ^^U }));
static_assert (!is_constructible_type (^^DelDtor, { ^^int }));
static_assert (!is_constructible_type (^^const DelDtor, { ^^int }));
static_assert (!is_constructible_type (^^DelDtor, {}));
static_assert (!is_constructible_type (^^const DelDtor, {}));
static_assert (!is_constructible_type (^^DelDtor, { ^^void *, ^^void (&) () }));
static_assert (!is_constructible_type (^^const DelDtor, { ^^void *, ^^void (&) () }));
static_assert (!is_constructible_type (^^AbstractDelDtor, {}));
static_assert (!is_constructible_type (^^const AbstractDelDtor, {}));
static_assert (!is_constructible_type (^^DelEllipsis, {}));
static_assert (!is_constructible_type (^^const DelEllipsis, {}));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^double }));
static_assert (!is_constructible_type (^^const DelEllipsis, { ^^double }));
static_assert (!is_constructible_type (^^DelEllipsis, { ^^double, ^^int & }));
static_assert (!is_constructible_type (^^const DelEllipsis, { ^^double, ^^int & }));
static_assert (!is_constructible_type (^^DelnAny, {}));
static_assert (!is_constructible_type (^^const DelnAny, {}));
static_assert (!is_constructible_type (^^DelnAny, { ^^int }));
static_assert (!is_constructible_type (^^const DelnAny, { ^^int }));
static_assert (!is_constructible_type (^^DelnAny, { ^^int, ^^void * }));
static_assert (!is_constructible_type (^^const DelnAny, { ^^int, ^^void * }));
static_assert (!is_constructible_type (^^DelnAny, { ^^Empty, ^^B, ^^D }));
static_assert (!is_constructible_type (^^const DelnAny, { ^^Empty, ^^B, ^^D }));
static_assert (!is_constructible_type (^^NontrivialUnion, {}));
static_assert (!is_constructible_type (^^NontrivialUnion, { ^^const NontrivialUnion & }));
static_assert (!is_constructible_type (^^UnusualCopy, {}));
static_assert (!is_constructible_type (^^UnusualCopy, { ^^UnusualCopy }));
static_assert (!is_constructible_type (^^UnusualCopy, { ^^UnusualCopy && }));
static_assert (!is_constructible_type (^^UnusualCopy, { ^^const UnusualCopy & }));
static_assert (is_constructible_type (^^UnusualCopy, { ^^UnusualCopy & }));
static_assert (is_constructible_type (^^FromArgs <int, char>, { ^^int, ^^char }));
static_assert (is_constructible_type (^^const FromArgs <int, char>, { ^^int, ^^char }));
static_assert (is_constructible_type (^^FromArgs <int, char>, { ^^int, ^^int }));
static_assert (is_constructible_type (^^const FromArgs <int, char>, { ^^int, ^^int }));
static_assert (is_constructible_type (^^nAny, { ^^int, ^^int }));
static_assert (is_constructible_type (^^const nAny, { ^^int, ^^int }));
static_assert (is_constructible_type (^^FromArgs <int, char>, { ^^ImplicitTo <int>, ^^ImplicitTo <char> }));
static_assert (is_constructible_type (^^const FromArgs <int, char>, { ^^ImplicitTo <int>, ^^ImplicitTo <char> }));
static_assert (is_constructible_type (^^Ellipsis, { ^^int, ^^char }));
static_assert (is_constructible_type (^^const Ellipsis, { ^^int, ^^char }));
static_assert (is_constructible_type (^^Ellipsis, { ^^B, ^^U, ^^int & }));
static_assert (is_constructible_type (^^const Ellipsis, { ^^B, ^^U, ^^int & }));
static_assert (is_constructible_type (^^nAny, { ^^B, ^^U, ^^int & }));
static_assert (is_constructible_type (^^const nAny, { ^^B, ^^U, ^^int & }));
static_assert (is_constructible_type (^^FromArgs <std::initializer_list <int>, std::initializer_list <B>>, { ^^std::initializer_list <int>, ^^std::initializer_list <B> }));
static_assert (is_constructible_type (^^const FromArgs <std::initializer_list <int>, std::initializer_list <B>>, { ^^std::initializer_list <int>, ^^std::initializer_list <B> }));
static_assert (is_constructible_type (^^FromArgs <std::initializer_list <int>, std::initializer_list <B>>, { ^^std::initializer_list <int> &, ^^std::initializer_list <B> & }));
static_assert (!is_constructible_type (^^FromArgs <std::initializer_list <int> &, std::initializer_list <B> &>, { ^^std::initializer_list <int>, ^^std::initializer_list <B> }));
static_assert (!is_constructible_type (^^FromArgs <std::initializer_list <int>>, { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const FromArgs <std::initializer_list <int>>, { ^^int, ^^int }));
static_assert (is_constructible_type (^^B [2], { ^^B, ^^B }));
static_assert (is_constructible_type (^^const B [2], { ^^B, ^^B }));
static_assert (is_constructible_type (^^U [2], { ^^U, ^^U }));
static_assert (is_constructible_type (^^const U [2], { ^^U, ^^U }));
static_assert (!is_constructible_type (^^E, { ^^E, ^^E }));
static_assert (!is_constructible_type (^^const E, { ^^E, ^^E }));
static_assert (!is_constructible_type (^^SE, { ^^SE, ^^SE }));
static_assert (!is_constructible_type (^^const SE, { ^^SE, ^^SE }));
static_assert (!is_constructible_type (^^E, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^const E, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^SE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^const SE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^E, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^const E, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^SE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^const SE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^OpE, { ^^OpE, ^^OpE }));
static_assert (!is_constructible_type (^^const OpE, { ^^OpE, ^^OpE }));
static_assert (!is_constructible_type (^^OpSE, { ^^OpSE, ^^OpSE }));
static_assert (!is_constructible_type (^^const OpSE, { ^^OpSE, ^^OpSE }));
static_assert (!is_constructible_type (^^OpE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^const OpE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^OpSE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^const OpSE, { ^^B, ^^std::nullptr_t }));
static_assert (!is_constructible_type (^^OpE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^const OpE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^OpSE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^const OpSE, { ^^int [], ^^int [] }));
static_assert (!is_constructible_type (^^int [], { ^^int, ^^int }));
static_assert (!is_constructible_type (^^const int [], { ^^int, ^^int }));
static_assert (is_constructible_type (^^int &, { ^^ImplicitTo <int &> }));
static_assert (is_constructible_type (^^const int &, { ^^ImplicitTo <int &&> }));
static_assert (is_constructible_type (^^int &&, { ^^ImplicitTo <int &&> }));
static_assert (is_constructible_type (^^const int &, { ^^ImplicitTo <int> }));
static_assert (!is_constructible_type (^^const int &, { ^^ExplicitTo <int> }));
static_assert (!is_constructible_type (^^int &&, { ^^ExplicitTo <int> }));
static_assert (is_constructible_type (^^int &, { ^^ExplicitTo <int &> }));
static_assert (is_constructible_type (^^int &&, { ^^ExplicitTo <int &&> }));
static_assert (!is_constructible_type (^^const int &, { ^^ExplicitTo <int &&> }));
static_assert (!is_constructible_type (^^const int &, { ^^ExplicitTo <double &&> }));
static_assert (!is_constructible_type (^^int &&, { ^^ExplicitTo <double &&> }));
static_assert (is_constructible_type (^^void (&&) (), { ^^void (&) () }));
