#include "eval.h"
#include "sh.h"
#include "fdstack.h"
#include "vartab.h"

int eval_pop(struct eval *e)
{
  int ret;
  
  assert(e == sh->eval);
  
  ret = sh->eval->exitcode;
  
  while(fdstack != e->fdstack && &fdstack_root != fdstack)
    fdstack_pop(fdstack);
  
  while(varstack != e->varstack && &vartab_root != varstack)
    vartab_pop(varstack);
  
  sh->eval = e->parent;
  
  return ret;
}

              
