/* $Id$ */
#if !defined UTILS_H
#define UTILS_H

#include "common.h"

typedef struct progress_meter ProgressMeter;
typedef struct property Property;

struct property {
  const char *weight[2];
  const char *slant[2];
  int *width;
  int *height;
  int *dw;
  int dy;
  int (*recast)(char *dst, int *width, int *height, int *dw, int dy, const char *src);
};

ProgressMeter *progress_meter_new(int count_max);
void progress_meter_delete(ProgressMeter *p);
void progress_meter_print(ProgressMeter *p);
void progress_meter_clear(ProgressMeter *p);

FILE *file_open(char *filename);
int replace_property(FILE *fp, size_t size, Property *prop);
char *rstr(char *buf, char c, size_t n);

#endif /* !UTILS_H */
