/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u0015\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0003J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0018\u001a\u00020\u0003J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0018\u001a\u00020\u0003R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/openrewrite/gradle/GradleSourceSetSpec;", "", "name", "", "sourceCharset", "Ljava/nio/charset/Charset;", "resourceCharset", "(Ljava/lang/String;Ljava/nio/charset/Charset;Ljava/nio/charset/Charset;)V", "groovyClasses", "", "javaSources", "kotlinSources", "propertiesFiles", "", "yamlFiles", "build", "dir", "Ljava/io/File;", "groovyClass", "", "source", "java", "kotlin", "propertiesFile", "text", "yamlFile", "plugin"})
public final class GradleSourceSetSpec {
    @NotNull
    private final String name;
    @NotNull
    private final Charset sourceCharset;
    @NotNull
    private final Charset resourceCharset;
    @NotNull
    private final List<String> javaSources;
    @NotNull
    private final List<String> kotlinSources;
    @NotNull
    private final Map<String, String> propertiesFiles;
    @NotNull
    private final Map<String, String> yamlFiles;
    @NotNull
    private final List<String> groovyClasses;

    public GradleSourceSetSpec(@NotNull String name, @NotNull Charset sourceCharset, @NotNull Charset resourceCharset) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sourceCharset, (String)"sourceCharset");
        Intrinsics.checkNotNullParameter((Object)resourceCharset, (String)"resourceCharset");
        this.name = name;
        this.sourceCharset = sourceCharset;
        this.resourceCharset = resourceCharset;
        this.javaSources = new ArrayList();
        this.kotlinSources = new ArrayList();
        this.propertiesFiles = new LinkedHashMap();
        this.yamlFiles = new LinkedHashMap();
        this.groovyClasses = new ArrayList();
    }

    public /* synthetic */ GradleSourceSetSpec(String string, Charset charset, Charset charset2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Charset charset3 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"UTF_8");
            charset = charset3;
        }
        if ((n & 4) != 0) {
            Charset charset4 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"UTF_8");
            charset2 = charset4;
        }
        this(string, charset, charset2);
    }

    public final void java(@Language(value="java") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.javaSources.add(StringsKt.trimIndent((String)source));
    }

    public final void kotlin(@Language(value="kotlin") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.kotlinSources.add(StringsKt.trimIndent((String)source));
    }

    public final void propertiesFile(@NotNull String name, @Language(value="properties") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.propertiesFiles.put(name, text);
    }

    public final void yamlFile(@NotNull String name, @Language(value="yaml") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.yamlFiles.put(name, text);
    }

    public final void groovyClass(@Language(value="groovy") @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.groovyClasses.add(StringsKt.trimIndent((String)source));
    }

    @NotNull
    public final GradleSourceSetSpec build(@NotNull File dir) {
        File file;
        boolean bl;
        File file2;
        String path;
        String clazz;
        String packageDecl;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        dir.mkdirs();
        for (String string : this.javaSources) {
            String string2;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+);", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string2 = (String)matchResult.getGroupValues().get(1);
            } else {
                string2 = "";
            }
            packageDecl = StringsKt.replace$default((String)string2, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)packageDecl).length() == 0 ? this.name + "/java/" + clazz + ".java" : this.name + "/java/" + packageDecl + '/' + clazz + ".java";
            File $this$build_u24lambda_u240 = file2 = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u240.getParentFile().mkdirs();
            FilesKt.writeText((File)$this$build_u24lambda_u240, (String)string, (Charset)this.sourceCharset);
        }
        for (String string : this.kotlinSources) {
            String string3;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string3 = (String)matchResult.getGroupValues().get(1);
            } else {
                string3 = "";
            }
            packageDecl = StringsKt.replace$default((String)string3, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)packageDecl).length() == 0 ? this.name + "/kotlin/" + clazz + ".kt" : this.name + "/kotlin/" + packageDecl + '/' + clazz + ".kt";
            File $this$build_u24lambda_u241 = file2 = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u241.getParentFile().mkdirs();
            FilesKt.writeText((File)$this$build_u24lambda_u241, (String)string, (Charset)this.sourceCharset);
        }
        for (String string : this.groovyClasses) {
            String string4;
            if (StringsKt.startsWith$default((String)string, (String)"package", (boolean)false, (int)2, null)) {
                MatchResult matchResult = Regex.find$default((Regex)new Regex("package\\s+([a-zA-Z0-9.]+);?", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                string4 = (String)matchResult.getGroupValues().get(1);
            } else {
                string4 = "";
            }
            packageDecl = StringsKt.replace$default((String)string4, (String)".", (String)"/", (boolean)false, (int)4, null);
            MatchResult matchResult = Regex.find$default((Regex)new Regex(".*(class|interface|enum)\\s+([a-zA-Z0-9-_]+)", RegexOption.MULTILINE), (CharSequence)string, (int)0, (int)2, null);
            Intrinsics.checkNotNull((Object)matchResult);
            clazz = (String)matchResult.getGroupValues().get(2);
            path = ((CharSequence)packageDecl).length() == 0 ? this.name + "/groovy/" + clazz + ".groovy" : this.name + "/groovy/" + packageDecl + '/' + clazz + ".groovy";
            File $this$build_u24lambda_u242 = file2 = new File(dir, path);
            bl = false;
            $this$build_u24lambda_u242.getParentFile().mkdirs();
            FilesKt.writeText((File)$this$build_u24lambda_u242, (String)string, (Charset)this.sourceCharset);
        }
        if (!this.propertiesFiles.isEmpty()) {
            for (Map.Entry entry : this.propertiesFiles.entrySet()) {
                File $this$build_u24lambda_u243 = file = new File(dir, this.name + "/resources/" + (String)entry.getKey());
                boolean bl2 = false;
                $this$build_u24lambda_u243.getParentFile().mkdirs();
                FilesKt.writeText((File)$this$build_u24lambda_u243, (String)((String)entry.getValue()), (Charset)this.resourceCharset);
            }
        }
        if (!this.yamlFiles.isEmpty()) {
            for (Map.Entry entry : this.yamlFiles.entrySet()) {
                File $this$build_u24lambda_u244 = file = new File(dir, this.name + "/resources/" + (String)entry.getKey());
                boolean bl3 = false;
                $this$build_u24lambda_u244.getParentFile().mkdirs();
                FilesKt.writeText((File)$this$build_u24lambda_u244, (String)((String)entry.getValue()), (Charset)this.resourceCharset);
            }
        }
        return this;
    }
}

