/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.utils;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.ParserConfiguration;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.JavaSymbolSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.CollectionStrategy;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Log;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.ProjectRoot;

public class SymbolSolverCollectionStrategy
implements CollectionStrategy {
    private final ParserConfiguration parserConfiguration;
    private final CombinedTypeSolver typeSolver = new CombinedTypeSolver(new ReflectionTypeSolver(false));

    public SymbolSolverCollectionStrategy() {
        this(new ParserConfiguration());
    }

    public SymbolSolverCollectionStrategy(ParserConfiguration parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
        if (!parserConfiguration.getSymbolResolver().isPresent()) {
            this.parserConfiguration.setSymbolResolver(new JavaSymbolSolver(this.typeSolver));
        }
    }

    @Override
    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    @Override
    public ProjectRoot collect(Path path) {
        final ProjectRoot projectRoot = new ProjectRoot(path, this.parserConfiguration);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private Path current_root;
                private Path currentProjectDir;
                private String previousSourceDirectory;
                private final PathMatcher javaMatcher;
                private final PathMatcher jarMatcher;
                {
                    this.javaMatcher = SymbolSolverCollectionStrategy.this.getPathMatcher("glob:**.java");
                    this.jarMatcher = SymbolSolverCollectionStrategy.this.getPathMatcher("glob:**.jar");
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (this.javaMatcher.matches(file)) {
                        String parent = file.getParent().toString();
                        if (!parent.equals(this.previousSourceDirectory)) {
                            Log.info("Trying to compute the source root from %s", (Supplier<Object> & Serializable)() -> file.toString());
                            this.previousSourceDirectory = parent;
                            this.currentProjectDir = SymbolSolverCollectionStrategy.this.getRoot(file).orElse(null);
                        }
                        if (this.current_root == null || this.currentProjectDir != null && !this.currentProjectDir.equals(this.current_root)) {
                            this.current_root = this.currentProjectDir;
                            if (this.current_root != null) {
                                Log.info("New current source root is %s", (Supplier<Object> & Serializable)() -> this.current_root.toString());
                            }
                        }
                    } else if (this.jarMatcher.matches(file)) {
                        Log.info("Jar file is found %s", (Supplier<Object> & Serializable)() -> file.toString());
                        SymbolSolverCollectionStrategy.this.typeSolver.add(new JarTypeSolver(file.toString()));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (Files.isHidden(dir)) {
                        Log.info("Skipping sub-tree %s", (Supplier<Object> & Serializable)() -> dir.toString());
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (this.current_root != null && Files.isSameFile(dir, this.current_root)) {
                        Log.info("Adding source root %s", (Supplier<Object> & Serializable)() -> dir.toString());
                        projectRoot.addSourceRoot(dir);
                        SymbolSolverCollectionStrategy.this.typeSolver.add(new JavaParserTypeSolver(this.current_root.toFile(), SymbolSolverCollectionStrategy.this.parserConfiguration));
                        this.current_root = null;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Log.error(e, "Unable to walk %s", (Supplier<Object> & Serializable)() -> path);
        }
        return projectRoot;
    }
}

