/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.utils;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.PrimitiveType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.VoidType;

public class TypeUtils {
    public static String getMethodDescriptor(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Class<?> parameter : method.getParameterTypes()) {
            TypeUtils.appendDescriptor(parameter, stringBuilder);
        }
        stringBuilder.append(")");
        TypeUtils.appendDescriptor(method.getReturnType(), stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendDescriptor(Class<?> clazz, StringBuilder stringBuilder) {
        Class<?> currentClass = clazz;
        while (currentClass.isArray()) {
            stringBuilder.append("[");
            currentClass = currentClass.getComponentType();
        }
        if (currentClass.isPrimitive()) {
            String descriptor = TypeUtils.getPrimitiveTypeDescriptor(currentClass);
            stringBuilder.append(descriptor);
        } else {
            stringBuilder.append("L").append(currentClass.getName().replace(".", "/")).append(";");
        }
    }

    public static String getPrimitiveTypeDescriptor(Class<?> clazz) {
        if (clazz == Void.TYPE || clazz == Void.class) {
            return new VoidType().toDescriptor();
        }
        String className = clazz.getSimpleName();
        Optional<PrimitiveType.Primitive> prim = PrimitiveType.Primitive.byTypeName(className);
        if (prim.isPresent()) {
            return prim.get().toDescriptor();
        }
        prim = PrimitiveType.Primitive.byBoxedTypeName(className);
        return (String)prim.map((Function<PrimitiveType.Primitive, String> & Serializable)pType -> pType.toDescriptor()).orElseThrow((Supplier<IllegalArgumentException> & Serializable)() -> new IllegalArgumentException(String.format("Unknown primitive type \"%s\"", className)));
    }
}

