/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import uk.ac.ed.ph.snuggletex.InputContext;
import uk.ac.ed.ph.snuggletex.NumberMatcher;

public class SimpleNumberMatcher
implements NumberMatcher {
    private final char decimalChar;

    public SimpleNumberMatcher() {
        this(Locale.getDefault());
    }

    public SimpleNumberMatcher(Locale locale) {
        this.decimalChar = new DecimalFormatSymbols(locale).getDecimalSeparator();
    }

    @Override
    public int getNumberEnd(InputContext input, int startIndex) {
        int c;
        int index = startIndex;
        boolean foundDigitsBeforeDecimalPoint = false;
        boolean foundDigitsAfterDecimalPoint = false;
        boolean foundDecimalPoint = false;
        while ((c = input.charAt(index)) >= 48 && c <= 57) {
            foundDigitsBeforeDecimalPoint = true;
            ++index;
        }
        if (input.charAt(index) == this.decimalChar) {
            foundDecimalPoint = true;
            ++index;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDecimalPoint) {
            return -1;
        }
        while ((c = input.charAt(index)) >= 48 && c <= 57) {
            foundDigitsAfterDecimalPoint = true;
            ++index;
        }
        if (!foundDigitsBeforeDecimalPoint && !foundDigitsAfterDecimalPoint) {
            return -1;
        }
        return index;
    }
}

