/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListPropertyAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

class FxListPropertyField<M, E, T extends ObservableList<E>, R extends Property<T>>
implements PropertyField<T, M, R> {
    private List<E> defaultValue;
    private final ListPropertyAccessor<M, E> accessor;
    private final ListProperty<E> targetProperty;

    public FxListPropertyField(SideEffect updateFunction, ListPropertyAccessor<M, E> accessor, Supplier<ListProperty<E>> propertySupplier) {
        this(updateFunction, accessor, propertySupplier, Collections.emptyList());
    }

    public FxListPropertyField(SideEffect updateFunction, ListPropertyAccessor<M, E> accessor, Supplier<ListProperty<E>> propertySupplier, List<E> defaultValue) {
        this.accessor = accessor;
        this.defaultValue = defaultValue;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableArrayList());
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
        this.accessor.apply(wrappedObject).setAll((Collection)this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        this.targetProperty.setAll((Collection)this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public void resetToDefault() {
        this.targetProperty.setAll(this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new ArrayList(this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        ListProperty<E> wrapperValue;
        ObservableList modelValue = this.accessor.apply(wrappedObject).getValue();
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

