/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.utils.mapping.BeanListPropertyField;
import de.saxsys.mvvmfx.utils.mapping.BeanMapPropertyField;
import de.saxsys.mvvmfx.utils.mapping.BeanPropertyField;
import de.saxsys.mvvmfx.utils.mapping.BeanSetPropertyField;
import de.saxsys.mvvmfx.utils.mapping.FxListPropertyField;
import de.saxsys.mvvmfx.utils.mapping.FxMapPropertyField;
import de.saxsys.mvvmfx.utils.mapping.FxPropertyField;
import de.saxsys.mvvmfx.utils.mapping.FxSetPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutableBeanPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutableListPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutableMapPropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutablePropertyField;
import de.saxsys.mvvmfx.utils.mapping.ImmutableSetPropertyField;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoubleGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoubleImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoublePropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoubleSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ListSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.MapSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringImmutableSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringSetter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

public class ModelWrapper<M> {
    private final ReadOnlyBooleanWrapper dirtyFlag = new ReadOnlyBooleanWrapper();
    private final ReadOnlyBooleanWrapper diffFlag = new ReadOnlyBooleanWrapper();
    private final Set<PropertyField<?, M, ?>> fields = new LinkedHashSet();
    private final Map<String, PropertyField<?, M, ?>> identifiedFields = new HashMap();
    private final Set<ImmutablePropertyField<?, M, ?>> immutableFields = new LinkedHashSet();
    private final ObjectProperty<M> model;
    private boolean inCommitPhase = false;

    public ModelWrapper(ObjectProperty<M> model) {
        this.model = model;
        this.reload();
        this.model.addListener((observable, oldValue, newValue) -> {
            if (!this.inCommitPhase) {
                this.reload();
            }
        });
    }

    public ModelWrapper(M model) {
        this(new SimpleObjectProperty(model));
    }

    public ModelWrapper() {
        this(new SimpleObjectProperty());
    }

    public void set(M model) {
        this.model.set(model);
    }

    public M get() {
        return (M)this.model.get();
    }

    public ObjectProperty<M> modelProperty() {
        return this.model;
    }

    public void reset() {
        this.fields.forEach(PropertyField::resetToDefault);
        this.immutableFields.forEach(PropertyField::resetToDefault);
        this.calculateDifferenceFlag();
    }

    public void useCurrentValuesAsDefaults() {
        Object wrappedModelInstance = this.model.get();
        if (wrappedModelInstance != null) {
            for (PropertyField<?, Object, ?> propertyField : this.fields) {
                propertyField.updateDefault(wrappedModelInstance);
            }
            for (ImmutablePropertyField immutablePropertyField : this.immutableFields) {
                immutablePropertyField.updateDefault(wrappedModelInstance);
            }
        }
    }

    public void commit() {
        if (this.model.get() != null) {
            this.inCommitPhase = true;
            this.fields.forEach(field -> field.commit(this.model.get()));
            if (!this.immutableFields.isEmpty()) {
                Object tmp = this.model.get();
                for (ImmutablePropertyField<?, Object, ?> immutablePropertyField : this.immutableFields) {
                    tmp = immutablePropertyField.commitImmutable(tmp);
                }
                this.model.set(tmp);
            }
            this.inCommitPhase = false;
            this.dirtyFlag.set(false);
            this.calculateDifferenceFlag();
        }
    }

    public void reload() {
        Object wrappedModelInstance = this.model.get();
        if (wrappedModelInstance != null) {
            this.fields.forEach(field -> field.reload(wrappedModelInstance));
            this.immutableFields.forEach(field -> field.reload(wrappedModelInstance));
            this.dirtyFlag.set(false);
            this.calculateDifferenceFlag();
        }
    }

    public void copyValuesTo(M model) {
        Objects.requireNonNull(model);
        this.fields.forEach(field -> field.commit(model));
    }

    private void propertyWasChanged() {
        this.dirtyFlag.set(true);
        this.calculateDifferenceFlag();
    }

    private void calculateDifferenceFlag() {
        Object wrappedModelInstance = this.model.get();
        if (wrappedModelInstance != null) {
            for (PropertyField<?, Object, ?> propertyField : this.fields) {
                if (!propertyField.isDifferent(wrappedModelInstance)) continue;
                this.diffFlag.set(true);
                return;
            }
            for (ImmutablePropertyField immutablePropertyField : this.immutableFields) {
                if (!immutablePropertyField.isDifferent(wrappedModelInstance)) continue;
                this.diffFlag.set(true);
                return;
            }
            this.diffFlag.set(false);
        }
    }

    private <T, R extends Property<T>> R add(PropertyField<T, M, R> field) {
        this.fields.add(field);
        if (this.model.get() != null) {
            field.reload(this.model.get());
        }
        return field.getProperty();
    }

    private <T, R extends Property<T>> R addIdentified(String fieldName, PropertyField<T, M, R> field) {
        if (this.identifiedFields.containsKey(fieldName)) {
            Object property = this.identifiedFields.get(fieldName).getProperty();
            return (R)property;
        }
        this.identifiedFields.put(fieldName, field);
        return this.add(field);
    }

    private <T, R extends Property<T>> R addImmutable(ImmutablePropertyField<T, M, R> field) {
        this.immutableFields.add(field);
        if (this.model.get() != null) {
            field.reload(this.model.get());
        }
        return field.getProperty();
    }

    private <T, R extends Property<T>> R addIdentifiedImmutable(String fieldName, ImmutablePropertyField<T, M, R> field) {
        if (this.identifiedFields.containsKey(fieldName)) {
            Object property = this.identifiedFields.get(fieldName).getProperty();
            return (R)property;
        }
        this.identifiedFields.put(fieldName, field);
        return this.addImmutable(field);
    }

    public ReadOnlyBooleanProperty differentProperty() {
        return this.diffFlag.getReadOnlyProperty();
    }

    public boolean isDifferent() {
        return this.diffFlag.get();
    }

    public ReadOnlyBooleanProperty dirtyProperty() {
        return this.dirtyFlag.getReadOnlyProperty();
    }

    public boolean isDirty() {
        return this.dirtyFlag.get();
    }

    public StringProperty field(StringGetter<M> getter, StringSetter<M> setter) {
        return (StringProperty)this.add(new BeanPropertyField(this::propertyWasChanged, getter, setter, SimpleStringProperty::new));
    }

    public StringProperty immutableField(StringGetter<M> getter, StringImmutableSetter<M> immutableSetter) {
        return (StringProperty)this.addImmutable(new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, SimpleStringProperty::new));
    }

    public StringProperty field(StringGetter<M> getter, StringSetter<M> setter, String defaultValue) {
        return (StringProperty)this.add(new BeanPropertyField(this::propertyWasChanged, getter, setter, defaultValue, SimpleStringProperty::new));
    }

    public StringProperty immutableField(StringGetter<M> getter, StringImmutableSetter<M> immutableSetter, String defaultValue) {
        return (StringProperty)this.addImmutable(new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, defaultValue, SimpleStringProperty::new));
    }

    public StringProperty field(StringPropertyAccessor<M> accessor) {
        return (StringProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, SimpleStringProperty::new));
    }

    public StringProperty field(StringPropertyAccessor<M> accessor, String defaultValue) {
        return (StringProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, SimpleStringProperty::new));
    }

    public StringProperty field(String identifier, StringGetter<M> getter, StringSetter<M> setter) {
        return (StringProperty)this.addIdentified(identifier, new BeanPropertyField(this::propertyWasChanged, getter, setter, () -> new SimpleStringProperty(null, identifier)));
    }

    public StringProperty field(String identifier, StringGetter<M> getter, StringSetter<M> setter, String defaultValue) {
        return (StringProperty)this.addIdentified(identifier, new BeanPropertyField(this::propertyWasChanged, getter, setter, defaultValue, () -> new SimpleStringProperty(null, identifier)));
    }

    public StringProperty immutableField(String identifier, StringGetter<M> getter, StringImmutableSetter<M> immutableSetter) {
        return (StringProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, () -> new SimpleStringProperty(null, identifier)));
    }

    public StringProperty immutableField(String identifier, StringGetter<M> getter, StringImmutableSetter<M> immutableSetter, String defaultValue) {
        return (StringProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, defaultValue, () -> new SimpleStringProperty(null, identifier)));
    }

    public StringProperty field(String identifier, StringPropertyAccessor<M> accessor) {
        return (StringProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, () -> new SimpleStringProperty(null, identifier)));
    }

    public StringProperty field(String identifier, StringPropertyAccessor<M> accessor, String defaultValue) {
        return (StringProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, () -> new SimpleStringProperty(null, identifier)));
    }

    public BooleanProperty field(BooleanGetter<M> getter, BooleanSetter<M> setter) {
        return (BooleanProperty)this.add(new BeanPropertyField(this::propertyWasChanged, getter, setter, SimpleBooleanProperty::new));
    }

    public BooleanProperty immutableField(BooleanGetter<M> getter, BooleanImmutableSetter<M> immutableSetter) {
        return (BooleanProperty)this.addImmutable(new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanGetter<M> getter, BooleanSetter<M> setter, boolean defaultValue) {
        return (BooleanProperty)this.add(new BeanPropertyField(this::propertyWasChanged, getter, setter, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty immutableField(BooleanGetter<M> getter, BooleanImmutableSetter<M> immutableSetter, boolean defaultValue) {
        return (BooleanProperty)this.addImmutable(new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanPropertyAccessor<M> accessor) {
        return (BooleanProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanPropertyAccessor<M> accessor, boolean defaultValue) {
        return (BooleanProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(String identifier, BooleanGetter<M> getter, BooleanSetter<M> setter) {
        return (BooleanProperty)this.addIdentified(identifier, new BeanPropertyField(this::propertyWasChanged, getter, setter, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public BooleanProperty field(String identifier, BooleanGetter<M> getter, BooleanSetter<M> setter, boolean defaultValue) {
        return (BooleanProperty)this.addIdentified(identifier, new BeanPropertyField(this::propertyWasChanged, getter, setter, defaultValue, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public BooleanProperty immutableField(String identifier, BooleanGetter<M> getter, BooleanImmutableSetter<M> immutableSetter) {
        return (BooleanProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public BooleanProperty immutableField(String identifier, BooleanGetter<M> getter, BooleanImmutableSetter<M> immutableSetter, boolean defaultValue) {
        return (BooleanProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField(this::propertyWasChanged, getter, immutableSetter, defaultValue, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public BooleanProperty field(String identifier, BooleanPropertyAccessor<M> accessor) {
        return (BooleanProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public BooleanProperty field(String identifier, BooleanPropertyAccessor<M> accessor, boolean defaultValue) {
        return (BooleanProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, () -> new SimpleBooleanProperty(null, identifier)));
    }

    public DoubleProperty field(DoubleGetter<M> getter, DoubleSetter<M> setter) {
        return (DoubleProperty)this.add(new BeanPropertyField<Number, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), SimpleDoubleProperty::new));
    }

    public DoubleProperty immutableField(DoubleGetter<M> getter, DoubleImmutableSetter<M> immutableSetter) {
        return (DoubleProperty)this.addImmutable(new ImmutableBeanPropertyField<Number, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.doubleValue()), SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoubleGetter<M> getter, DoubleSetter<M> setter, double defaultValue) {
        return (DoubleProperty)this.add(new BeanPropertyField<Double, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty immutableField(DoubleGetter<M> getter, DoubleImmutableSetter<M> immutableSetter, double defaultValue) {
        return (DoubleProperty)this.addImmutable(new ImmutableBeanPropertyField<Double, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.doubleValue()), defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoublePropertyAccessor<M> accessor) {
        return (DoubleProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoublePropertyAccessor<M> accessor, double defaultValue) {
        return (DoubleProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(String identifier, DoubleGetter<M> getter, DoubleSetter<M> setter) {
        return (DoubleProperty)this.addIdentified(identifier, new BeanPropertyField<Number, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), () -> new SimpleDoubleProperty(null, identifier)));
    }

    public DoubleProperty field(String identifier, DoubleGetter<M> getter, DoubleSetter<M> setter, double defaultValue) {
        return (DoubleProperty)this.addIdentified(identifier, new BeanPropertyField<Double, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), defaultValue, () -> new SimpleDoubleProperty(null, identifier)));
    }

    public DoubleProperty immutableField(String identifier, DoubleGetter<M> getter, DoubleImmutableSetter<M> immutableSetter) {
        return (DoubleProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Number, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.doubleValue()), () -> new SimpleDoubleProperty(null, identifier)));
    }

    public DoubleProperty immutableField(String identifier, DoubleGetter<M> getter, DoubleImmutableSetter<M> immutableSetter, double defaultValue) {
        return (DoubleProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Double, Object, SimpleDoubleProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.doubleValue()), defaultValue, () -> new SimpleDoubleProperty(null, identifier)));
    }

    public DoubleProperty field(String identifier, DoublePropertyAccessor<M> accessor) {
        return (DoubleProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, () -> new SimpleDoubleProperty(null, identifier)));
    }

    public DoubleProperty field(String identifier, DoublePropertyAccessor<M> accessor, double defaultValue) {
        return (DoubleProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, () -> new SimpleDoubleProperty(null, identifier)));
    }

    public FloatProperty field(FloatGetter<M> getter, FloatSetter<M> setter) {
        return (FloatProperty)this.add(new BeanPropertyField<Number, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), SimpleFloatProperty::new));
    }

    public FloatProperty immutableField(FloatGetter<M> getter, FloatImmutableSetter<M> immutableSetter) {
        return (FloatProperty)this.addImmutable(new ImmutableBeanPropertyField<Number, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, Float.valueOf(number.floatValue())), SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatGetter<M> getter, FloatSetter<M> setter, float defaultValue) {
        return (FloatProperty)this.add(new BeanPropertyField<Float, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty immutableField(FloatGetter<M> getter, FloatImmutableSetter<M> immutableSetter, float defaultValue) {
        return (FloatProperty)this.addImmutable(new ImmutableBeanPropertyField<Float, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatPropertyAccessor<M> accessor) {
        return (FloatProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatPropertyAccessor<M> accessor, float defaultValue) {
        return (FloatProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty field(String identifier, FloatGetter<M> getter, FloatSetter<M> setter) {
        return (FloatProperty)this.addIdentified(identifier, new BeanPropertyField<Number, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), () -> new SimpleFloatProperty(null, identifier)));
    }

    public FloatProperty field(String identifier, FloatGetter<M> getter, FloatSetter<M> setter, float defaultValue) {
        return (FloatProperty)this.addIdentified(identifier, new BeanPropertyField<Float, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), () -> new SimpleFloatProperty(null, identifier)));
    }

    public FloatProperty immutableField(String identifier, FloatGetter<M> getter, FloatImmutableSetter<M> immutableSetter) {
        return (FloatProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Number, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, Float.valueOf(number.floatValue())), () -> new SimpleFloatProperty(null, identifier)));
    }

    public FloatProperty immutableField(String identifier, FloatGetter<M> getter, FloatImmutableSetter<M> immutableSetter, float defaultValue) {
        return (FloatProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Float, Object, SimpleFloatProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), () -> new SimpleFloatProperty(null, identifier)));
    }

    public FloatProperty field(String identifier, FloatPropertyAccessor<M> accessor) {
        return (FloatProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, () -> new SimpleFloatProperty(null, identifier)));
    }

    public FloatProperty field(String identifier, FloatPropertyAccessor<M> accessor, float defaultValue) {
        return (FloatProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, Float.valueOf(defaultValue), () -> new SimpleFloatProperty(null, identifier)));
    }

    public IntegerProperty field(IntGetter<M> getter, IntSetter<M> setter) {
        return (IntegerProperty)this.add(new BeanPropertyField<Number, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.intValue()), SimpleIntegerProperty::new));
    }

    public IntegerProperty immutableField(IntGetter<M> getter, IntImmutableSetter<M> immutableSetter) {
        return (IntegerProperty)this.addImmutable(new ImmutableBeanPropertyField<Number, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.intValue()), SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntGetter<M> getter, IntSetter<M> setter, int defaultValue) {
        return (IntegerProperty)this.add(new BeanPropertyField<Integer, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.intValue()), defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty immutableField(IntGetter<M> getter, IntImmutableSetter<M> immutableSetter, int defaultValue) {
        return (IntegerProperty)this.addImmutable(new ImmutableBeanPropertyField<Integer, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.intValue()), defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntPropertyAccessor<M> accessor) {
        return (IntegerProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntPropertyAccessor<M> accessor, int defaultValue) {
        return (IntegerProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(String identifier, IntGetter<M> getter, IntSetter<M> setter) {
        return (IntegerProperty)this.addIdentified(identifier, new BeanPropertyField<Number, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.intValue()), () -> new SimpleIntegerProperty(null, identifier)));
    }

    public IntegerProperty field(String identifier, IntGetter<M> getter, IntSetter<M> setter, int defaultValue) {
        return (IntegerProperty)this.addIdentified(identifier, new BeanPropertyField<Integer, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.intValue()), defaultValue, () -> new SimpleIntegerProperty(null, identifier)));
    }

    public IntegerProperty immutableField(String identifier, IntGetter<M> getter, IntImmutableSetter<M> immutableSetter) {
        return (IntegerProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Number, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.intValue()), () -> new SimpleIntegerProperty(null, identifier)));
    }

    public IntegerProperty immutableField(String identifier, IntGetter<M> getter, IntImmutableSetter<M> immutableSetter, int defaultValue) {
        return (IntegerProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Integer, Object, SimpleIntegerProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.intValue()), defaultValue, () -> new SimpleIntegerProperty(null, identifier)));
    }

    public IntegerProperty field(String identifier, IntPropertyAccessor<M> accessor) {
        return (IntegerProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, () -> new SimpleIntegerProperty(null, identifier)));
    }

    public IntegerProperty field(String identifier, IntPropertyAccessor<M> accessor, int defaultValue) {
        return (IntegerProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, () -> new SimpleIntegerProperty(null, identifier)));
    }

    public LongProperty field(LongGetter<M> getter, LongSetter<M> setter) {
        return (LongProperty)this.add(new BeanPropertyField<Number, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.longValue()), SimpleLongProperty::new));
    }

    public LongProperty immutableField(LongGetter<M> getter, LongImmutableSetter<M> immutableSetter) {
        return (LongProperty)this.addImmutable(new ImmutableBeanPropertyField<Number, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.longValue()), SimpleLongProperty::new));
    }

    public LongProperty field(LongGetter<M> getter, LongSetter<M> setter, long defaultValue) {
        return (LongProperty)this.add(new BeanPropertyField<Long, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.longValue()), defaultValue, SimpleLongProperty::new));
    }

    public LongProperty immutableField(LongGetter<M> getter, LongImmutableSetter<M> immutableSetter, long defaultValue) {
        return (LongProperty)this.addImmutable(new ImmutableBeanPropertyField<Long, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.longValue()), defaultValue, SimpleLongProperty::new));
    }

    public LongProperty field(LongPropertyAccessor<M> accessor) {
        return (LongProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, SimpleLongProperty::new));
    }

    public LongProperty field(LongPropertyAccessor<M> accessor, long defaultValue) {
        return (LongProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, SimpleLongProperty::new));
    }

    public LongProperty field(String identifier, LongGetter<M> getter, LongSetter<M> setter) {
        return (LongProperty)this.addIdentified(identifier, new BeanPropertyField<Number, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.longValue()), () -> new SimpleLongProperty(null, identifier)));
    }

    public LongProperty field(String identifier, LongGetter<M> getter, LongSetter<M> setter, long defaultValue) {
        return (LongProperty)this.addIdentified(identifier, new BeanPropertyField<Long, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> setter.accept(m, number.longValue()), defaultValue, () -> new SimpleLongProperty(null, identifier)));
    }

    public LongProperty immutableField(String identifier, LongGetter<M> getter, LongImmutableSetter<M> immutableSetter) {
        return (LongProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Number, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.longValue()), () -> new SimpleLongProperty(null, identifier)));
    }

    public LongProperty immutableField(String identifier, LongGetter<M> getter, LongImmutableSetter<M> immutableSetter, long defaultValue) {
        return (LongProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<Long, Object, SimpleLongProperty>(this::propertyWasChanged, getter::apply, (m, number) -> immutableSetter.apply(m, number.longValue()), defaultValue, () -> new SimpleLongProperty(null, identifier)));
    }

    public LongProperty field(String identifier, LongPropertyAccessor<M> accessor) {
        return (LongProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, () -> new SimpleLongProperty(null, identifier)));
    }

    public LongProperty field(String identifier, LongPropertyAccessor<M> accessor, long defaultValue) {
        return (LongProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor::apply, defaultValue, () -> new SimpleLongProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> field(ObjectGetter<M, T> getter, ObjectSetter<M, T> setter) {
        return (ObjectProperty)this.add(new BeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, setter, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> immutableField(ObjectGetter<M, T> getter, ObjectImmutableSetter<M, T> immutableSetter) {
        return (ObjectProperty)this.addImmutable(new ImmutableBeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, immutableSetter, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectGetter<M, T> getter, ObjectSetter<M, T> setter, T defaultValue) {
        return (ObjectProperty)this.add(new BeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, setter, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> immutableField(ObjectGetter<M, T> getter, ObjectImmutableSetter<M, T> immutableSetter, T defaultValue) {
        return (ObjectProperty)this.addImmutable(new ImmutableBeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, immutableSetter, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectPropertyAccessor<M, T> accessor) {
        return (ObjectProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectPropertyAccessor<M, T> accessor, T defaultValue) {
        return (ObjectProperty)this.add(new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectGetter<M, T> getter, ObjectSetter<M, T> setter) {
        return (ObjectProperty)this.addIdentified(identifier, new BeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, setter, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectGetter<M, T> getter, ObjectSetter<M, T> setter, T defaultValue) {
        return (ObjectProperty)this.addIdentified(identifier, new BeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, setter, defaultValue, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> immutableField(String identifier, ObjectGetter<M, T> getter, ObjectImmutableSetter<M, T> immutableSetter) {
        return (ObjectProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, immutableSetter, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> immutableField(String identifier, ObjectGetter<M, T> getter, ObjectImmutableSetter<M, T> immutableSetter, T defaultValue) {
        return (ObjectProperty)this.addIdentifiedImmutable(identifier, new ImmutableBeanPropertyField<T, M, SimpleObjectProperty>(this::propertyWasChanged, getter, immutableSetter, defaultValue, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectPropertyAccessor<M, T> accessor) {
        return (ObjectProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectPropertyAccessor<M, T> accessor, T defaultValue) {
        return (ObjectProperty)this.addIdentified(identifier, new FxPropertyField(this::propertyWasChanged, accessor, defaultValue, () -> new SimpleObjectProperty(null, identifier)));
    }

    public <E> ListProperty<E> field(ListGetter<M, E> getter, ListSetter<M, E> setter) {
        return (ListProperty)this.add(new BeanListPropertyField(this::propertyWasChanged, getter, (m, list) -> setter.accept((Object)m, (List)FXCollections.observableArrayList((Collection)list)), SimpleListProperty::new));
    }

    public <E> ListProperty<E> immutableField(ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter) {
        return (ListProperty)this.addImmutable(new ImmutableListPropertyField(this::propertyWasChanged, getter, (m, list) -> immutableSetter.apply((Object)m, (List)FXCollections.observableArrayList((Collection)list)), SimpleListProperty::new));
    }

    public <E> ListProperty<E> field(ListGetter<M, E> getter, ListSetter<M, E> setter, List<E> defaultValue) {
        return (ListProperty)this.add(new BeanListPropertyField(this::propertyWasChanged, getter, (m, list) -> setter.accept((Object)m, (List)FXCollections.observableArrayList((Collection)list)), SimpleListProperty::new, defaultValue));
    }

    public <E> ListProperty<E> immutableField(ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter, List<E> defaultValue) {
        return (ListProperty)this.addImmutable(new ImmutableListPropertyField(this::propertyWasChanged, getter, (m, list) -> immutableSetter.apply((Object)m, (List)FXCollections.observableArrayList((Collection)list)), SimpleListProperty::new, defaultValue));
    }

    public <E> ListProperty<E> field(ListPropertyAccessor<M, E> accessor) {
        return (ListProperty)this.add(new FxListPropertyField(this::propertyWasChanged, accessor, SimpleListProperty::new));
    }

    public <E> ListProperty<E> field(ListPropertyAccessor<M, E> accessor, List<E> defaultValue) {
        return (ListProperty)this.add(new FxListPropertyField(this::propertyWasChanged, accessor, SimpleListProperty::new, defaultValue));
    }

    public <E> ListProperty<E> field(String identifier, ListGetter<M, E> getter, ListSetter<M, E> setter) {
        return (ListProperty)this.addIdentified(identifier, new BeanListPropertyField(this::propertyWasChanged, getter, (m, list) -> setter.accept((Object)m, (List)FXCollections.observableArrayList((Collection)list)), () -> new SimpleListProperty(null, identifier)));
    }

    public <E> ListProperty<E> field(String identifier, ListGetter<M, E> getter, ListSetter<M, E> setter, List<E> defaultValue) {
        return (ListProperty)this.addIdentified(identifier, new BeanListPropertyField(this::propertyWasChanged, getter, (m, list) -> setter.accept((Object)m, (List)FXCollections.observableArrayList((Collection)list)), () -> new SimpleListProperty(null, identifier), defaultValue));
    }

    public <E> ListProperty<E> immutableField(String identifier, ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter) {
        return (ListProperty)this.addIdentifiedImmutable(identifier, new ImmutableListPropertyField(this::propertyWasChanged, getter, (m, list) -> immutableSetter.apply((Object)m, (List)FXCollections.observableArrayList((Collection)list)), () -> new SimpleListProperty(null, identifier)));
    }

    public <E> ListProperty<E> immutableField(String identifier, ListGetter<M, E> getter, ListImmutableSetter<M, E> immutableSetter, List<E> defaultValue) {
        return (ListProperty)this.addIdentifiedImmutable(identifier, new ImmutableListPropertyField(this::propertyWasChanged, getter, (m, list) -> immutableSetter.apply((Object)m, (List)FXCollections.observableArrayList((Collection)list)), () -> new SimpleListProperty(null, identifier), defaultValue));
    }

    public <E> ListProperty<E> field(String identifier, ListPropertyAccessor<M, E> accessor) {
        return (ListProperty)this.addIdentified(identifier, new FxListPropertyField(this::propertyWasChanged, accessor, () -> new SimpleListProperty(null, identifier)));
    }

    public <E> ListProperty<E> field(String identifier, ListPropertyAccessor<M, E> accessor, List<E> defaultValue) {
        return (ListProperty)this.addIdentified(identifier, new FxListPropertyField(this::propertyWasChanged, accessor, () -> new SimpleListProperty(null, identifier), defaultValue));
    }

    private static <T> ObservableSet<T> observableHashSet(Set<T> source) {
        return FXCollections.observableSet(new HashSet<T>(source));
    }

    public <E> SetProperty<E> field(SetGetter<M, E> getter, SetSetter<M, E> setter) {
        return (SetProperty)this.add(new BeanSetPropertyField(this::propertyWasChanged, getter, (m, set) -> setter.accept((Object)m, (Set)ModelWrapper.observableHashSet(set)), SimpleSetProperty::new));
    }

    public <E> SetProperty<E> immutableField(SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter) {
        return (SetProperty)this.addImmutable(new ImmutableSetPropertyField(this::propertyWasChanged, getter, (m, set) -> immutableSetter.apply((Object)m, (Set)ModelWrapper.observableHashSet(set)), SimpleSetProperty::new));
    }

    public <E> SetProperty<E> field(SetGetter<M, E> getter, SetSetter<M, E> setter, Set<E> defaultValue) {
        return (SetProperty)this.add(new BeanSetPropertyField(this::propertyWasChanged, getter, (m, set) -> setter.accept((Object)m, (Set)ModelWrapper.observableHashSet(set)), SimpleSetProperty::new, defaultValue));
    }

    public <E> SetProperty<E> immutableField(SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter, Set<E> defaultValue) {
        return (SetProperty)this.addImmutable(new ImmutableSetPropertyField(this::propertyWasChanged, getter, (m, set) -> immutableSetter.apply((Object)m, (Set)ModelWrapper.observableHashSet(set)), SimpleSetProperty::new, defaultValue));
    }

    public <E> SetProperty<E> field(SetPropertyAccessor<M, E> accessor) {
        return (SetProperty)this.add(new FxSetPropertyField(this::propertyWasChanged, accessor, SimpleSetProperty::new));
    }

    public <E> SetProperty<E> field(SetPropertyAccessor<M, E> accessor, Set<E> defaultValue) {
        return (SetProperty)this.add(new FxSetPropertyField(this::propertyWasChanged, accessor, SimpleSetProperty::new, defaultValue));
    }

    public <E> SetProperty<E> field(String identifier, SetGetter<M, E> getter, SetSetter<M, E> setter) {
        return (SetProperty)this.addIdentified(identifier, new BeanSetPropertyField(this::propertyWasChanged, getter, (m, set) -> setter.accept((Object)m, (Set)ModelWrapper.observableHashSet(set)), () -> new SimpleSetProperty(null, identifier)));
    }

    public <E> SetProperty<E> field(String identifier, SetGetter<M, E> getter, SetSetter<M, E> setter, Set<E> defaultValue) {
        return (SetProperty)this.addIdentified(identifier, new BeanSetPropertyField(this::propertyWasChanged, getter, (m, set) -> setter.accept((Object)m, (Set)ModelWrapper.observableHashSet(set)), () -> new SimpleSetProperty(null, identifier), defaultValue));
    }

    public <E> SetProperty<E> immutableField(String identifier, SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter) {
        return (SetProperty)this.addIdentifiedImmutable(identifier, new ImmutableSetPropertyField(this::propertyWasChanged, getter, (m, set) -> immutableSetter.apply((Object)m, (Set)ModelWrapper.observableHashSet(set)), () -> new SimpleSetProperty(null, identifier)));
    }

    public <E> SetProperty<E> immutableField(String identifier, SetGetter<M, E> getter, SetImmutableSetter<M, E> immutableSetter, Set<E> defaultValue) {
        return (SetProperty)this.addIdentifiedImmutable(identifier, new ImmutableSetPropertyField(this::propertyWasChanged, getter, (m, set) -> immutableSetter.apply((Object)m, (Set)ModelWrapper.observableHashSet(set)), () -> new SimpleSetProperty(null, identifier), defaultValue));
    }

    public <E> SetProperty<E> field(String identifier, SetPropertyAccessor<M, E> accessor) {
        return (SetProperty)this.addIdentified(identifier, new FxSetPropertyField(this::propertyWasChanged, accessor, () -> new SimpleSetProperty(null, identifier)));
    }

    public <E> SetProperty<E> field(String identifier, SetPropertyAccessor<M, E> accessor, Set<E> defaultValue) {
        return (SetProperty)this.addIdentified(identifier, new FxSetPropertyField(this::propertyWasChanged, accessor, () -> new SimpleSetProperty(null, identifier), defaultValue));
    }

    public <K, V> MapProperty<K, V> field(MapGetter<M, K, V> getter, MapSetter<M, K, V> setter) {
        return (MapProperty)this.add(new BeanMapPropertyField(this::propertyWasChanged, getter, (m, map) -> setter.accept((Object)m, (Map)FXCollections.observableMap((Map)map)), SimpleMapProperty::new));
    }

    public <K, V> MapProperty<K, V> immutableField(MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter) {
        return (MapProperty)this.addImmutable(new ImmutableMapPropertyField(this::propertyWasChanged, getter, (m, map) -> immutableSetter.apply((Object)m, (Map)FXCollections.observableMap((Map)map)), SimpleMapProperty::new));
    }

    public <K, V> MapProperty<K, V> field(MapGetter<M, K, V> getter, MapSetter<M, K, V> setter, Map<K, V> defaultValue) {
        return (MapProperty)this.add(new BeanMapPropertyField(this::propertyWasChanged, getter, (m, map) -> setter.accept((Object)m, (Map)FXCollections.observableMap((Map)map)), SimpleMapProperty::new, defaultValue));
    }

    public <K, V> MapProperty<K, V> immutableField(MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter, Map<K, V> defaultValue) {
        return (MapProperty)this.addImmutable(new ImmutableMapPropertyField(this::propertyWasChanged, getter, (m, map) -> immutableSetter.apply((Object)m, (Map)FXCollections.observableMap((Map)map)), SimpleMapProperty::new, defaultValue));
    }

    public <K, V> MapProperty<K, V> field(MapPropertyAccessor<M, K, V> accessor) {
        return (MapProperty)this.add(new FxMapPropertyField(this::propertyWasChanged, accessor, SimpleMapProperty::new));
    }

    public <K, V> MapProperty<K, V> field(MapPropertyAccessor<M, K, V> accessor, Map<K, V> defaultValue) {
        return (MapProperty)this.add(new FxMapPropertyField(this::propertyWasChanged, accessor, SimpleMapProperty::new, defaultValue));
    }

    public <K, V> MapProperty<K, V> field(String identifier, MapGetter<M, K, V> getter, MapSetter<M, K, V> setter) {
        return (MapProperty)this.addIdentified(identifier, new BeanMapPropertyField(this::propertyWasChanged, getter, (m, map) -> setter.accept((Object)m, (Map)FXCollections.observableMap((Map)map)), () -> new SimpleMapProperty(null, identifier)));
    }

    public <K, V> MapProperty<K, V> field(String identifier, MapGetter<M, K, V> getter, MapSetter<M, K, V> setter, Map<K, V> defaultValue) {
        return (MapProperty)this.addIdentified(identifier, new BeanMapPropertyField(this::propertyWasChanged, getter, (m, map) -> setter.accept((Object)m, (Map)FXCollections.observableMap((Map)map)), () -> new SimpleMapProperty(null, identifier), defaultValue));
    }

    public <K, V> MapProperty<K, V> immutableField(String identifier, MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter) {
        return (MapProperty)this.addIdentifiedImmutable(identifier, new ImmutableMapPropertyField(this::propertyWasChanged, getter, (m, map) -> immutableSetter.apply((Object)m, (Map)FXCollections.observableMap((Map)map)), () -> new SimpleMapProperty(null, identifier)));
    }

    public <K, V> MapProperty<K, V> immutableField(String identifier, MapGetter<M, K, V> getter, MapImmutableSetter<M, K, V> immutableSetter, Map<K, V> defaultValue) {
        return (MapProperty)this.addIdentifiedImmutable(identifier, new ImmutableMapPropertyField(this::propertyWasChanged, getter, (m, map) -> immutableSetter.apply((Object)m, (Map)FXCollections.observableMap((Map)map)), () -> new SimpleMapProperty(null, identifier), defaultValue));
    }

    public <K, V> MapProperty<K, V> field(String identifier, MapPropertyAccessor<M, K, V> accessor) {
        return (MapProperty)this.addIdentified(identifier, new FxMapPropertyField(this::propertyWasChanged, accessor, () -> new SimpleMapProperty(null, identifier)));
    }

    public <K, V> MapProperty<K, V> field(String identifier, MapPropertyAccessor<M, K, V> accessor, Map<K, V> defaultValue) {
        return (MapProperty)this.addIdentified(identifier, new FxMapPropertyField(this::propertyWasChanged, accessor, () -> new SimpleMapProperty(null, identifier), defaultValue));
    }
}

