/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.LocalDatePicker;
import com.dlsc.pickerfx.LocalDateTimePicker;
import com.dlsc.pickerfx.LocalTimePicker;
import com.dlsc.pickerfx.skins.PickerSkinBase;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javafx.beans.InvalidationListener;

public class LocalDateTimePickerSkin
extends PickerSkinBase<LocalDateTimePicker> {
    private boolean updatingValue;

    public LocalDateTimePickerSkin(LocalDateTimePicker control) {
        super(control);
        InvalidationListener updateValueListener = it -> this.updateValue();
        LocalDatePicker datePicker = control.getDatePicker();
        datePicker.setShowIndicator(false);
        datePicker.valueProperty().addListener(updateValueListener);
        LocalTimePicker timePicker = control.getTimePicker();
        timePicker.setShowIndicator(false);
        timePicker.valueProperty().addListener(updateValueListener);
        control.valueProperty().addListener(obs -> this.updateSegmentValues());
        this.getContainer().getChildren().add((Object)datePicker);
        this.getContainer().getChildren().add((Object)new PickerSkinBase.SegmentSeparator());
        this.getContainer().getChildren().add((Object)timePicker);
        this.updateValue();
    }

    private void updateValue() {
        LocalDate date = (LocalDate)((LocalDateTimePicker)this.getSkinnable()).getDatePicker().getValue();
        LocalTime time = (LocalTime)((LocalDateTimePicker)this.getSkinnable()).getTimePicker().getValue();
        try {
            this.updatingValue = true;
            if (date != null && time != null) {
                ((LocalDateTimePicker)this.getSkinnable()).setValue(LocalDateTime.of(date, time));
            } else {
                ((LocalDateTimePicker)this.getSkinnable()).setValue(null);
            }
        }
        finally {
            this.updatingValue = false;
        }
    }

    private void updateSegmentValues() {
        LocalDateTime dateTime;
        if (!this.updatingValue && (dateTime = (LocalDateTime)((LocalDateTimePicker)this.getSkinnable()).getValue()) != null) {
            ((LocalDateTimePicker)this.getSkinnable()).getDatePicker().setValue(dateTime.toLocalDate());
            ((LocalDateTimePicker)this.getSkinnable()).getTimePicker().setValue(dateTime.toLocalTime());
        }
    }
}

