/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import org.reactfx.BiGuard;
import org.reactfx.CloseableOnceGuard;
import org.reactfx.MultiGuard;

@FunctionalInterface
public interface Guard
extends AutoCloseable {
    public static final Guard EMPTY_GUARD = () -> {};

    @Override
    public void close();

    default public Guard closeableOnce() {
        return new CloseableOnceGuard(this);
    }

    public static Guard closeableOnce(Guard guard) {
        return guard.closeableOnce();
    }

    public static Guard multi(Guard ... guards) {
        switch (guards.length) {
            case 0: {
                return EMPTY_GUARD;
            }
            case 1: {
                return guards[0];
            }
            case 2: {
                return new BiGuard(guards[0], guards[1]);
            }
        }
        return new MultiGuard(guards);
    }
}

