/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.internal.MultilineStringsJavadocOptionFileOption;
import org.javamodularity.moduleplugin.extensions.JavadocModuleOptions;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.internal.StreamHelper;
import org.javamodularity.moduleplugin.tasks.AbstractModulePluginTask;

public class JavadocTask
extends AbstractModulePluginTask {
    public JavadocTask(Project project) {
        super(project);
    }

    public void configureJavaDoc() {
        this.helper().findTask("javadoc", Javadoc.class).ifPresent(this::configureJavaDoc);
    }

    private void configureJavaDoc(final Javadoc javadoc) {
        final JavadocModuleOptions moduleOptions = (JavadocModuleOptions)javadoc.getExtensions().create("moduleOptions", JavadocModuleOptions.class, new Object[]{this.project});
        javadoc.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                JavadocTask.this.addJavadocOptions(javadoc, moduleOptions);
                javadoc.setClasspath((FileCollection)JavadocTask.this.project.files(new Object[0]));
            }
        });
    }

    private void addJavadocOptions(Javadoc javadoc, JavadocModuleOptions moduleOptions) {
        CoreJavadocOptions options = (CoreJavadocOptions)javadoc.getOptions();
        FileCollection classpath = this.mergeClassesHelper().getMergeAdjustedClasspath(javadoc.getClasspath());
        JavadocOptionFileOption[] addExportsOption = new JavadocOptionFileOption[]{null};
        PatchModuleContainer patchModuleContainer = this.helper().modularityExtension().optionContainer().getPatchModuleContainer();
        StreamHelper.concat(patchModuleContainer.buildModulePathOption(classpath).stream(), patchModuleContainer.mutator(classpath).taskOptionStream(), moduleOptions.buildFullOptionStreamLogged()).forEach(option -> {
            if (option.getJavadocFlag().equals("-add-exports")) {
                if (addExportsOption[0] == null) {
                    addExportsOption[0] = options.addMultilineStringsOption("-add-exports");
                }
                MultilineStringsJavadocOptionFileOption opt = (MultilineStringsJavadocOptionFileOption)addExportsOption[0];
                opt.getValue().add(option.getValue());
            } else {
                option.mutateOptions(options);
            }
        });
    }
}

