/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.javamodularity.moduleplugin.tasks.ModularJavaExec;
import org.javamodularity.moduleplugin.tasks.StartScriptsMutator;

public class ModularCreateStartScripts
extends CreateStartScripts {
    public static final String UNDEFINED_MAIN_CLASS_NAME = "<undefined>";
    private String changedMain;
    @Internal
    private ModularJavaExec runTask;

    public ModularCreateStartScripts() {
        this.setClasspath((FileCollection)this.getProject().files(new Object[0]));
    }

    @Nullable
    public String getMainClassName() {
        String main = this.changedMain;
        if (main == null) {
            main = super.getMainClassName();
        }
        if (main == null) {
            main = UNDEFINED_MAIN_CLASS_NAME;
        }
        return main;
    }

    public void setMainClassName(@Nullable String mainClassName) {
        this.changedMain = mainClassName;
    }

    public ModularJavaExec getRunTask() {
        return this.runTask;
    }

    public void setRunTask(ModularJavaExec runTask) {
        this.runTask = runTask;
    }

    public static void configure(Project project) {
        project.afterEvaluate(ModularCreateStartScripts::configureAfterEvaluate);
    }

    private static void configureAfterEvaluate(Project project) {
        project.getTasks().withType(ModularCreateStartScripts.class).forEach(startScriptsTask -> ModularCreateStartScripts.configure(startScriptsTask, project));
    }

    private static void configure(ModularCreateStartScripts startScriptsTask, Project project) {
        ModularJavaExec runTask;
        ApplicationPluginConvention appConvention = (ApplicationPluginConvention)project.getConvention().findPlugin(ApplicationPluginConvention.class);
        if (appConvention != null) {
            File distDir = project.file((Object)(project.getBuildDir() + "/install/" + appConvention.getApplicationName()));
            startScriptsTask.setOutputDir(new File(distDir, appConvention.getExecutableDir()));
        }
        if ((runTask = startScriptsTask.getRunTask()) == null) {
            throw new GradleException("runTask not set for task " + startScriptsTask.getName());
        }
        List<String> runJvmArgs = runTask.getOwnJvmArgs();
        if (!runJvmArgs.isEmpty()) {
            ArrayList<String> defaultJvmOpts = new ArrayList<String>(runJvmArgs);
            startScriptsTask.getDefaultJvmOpts().forEach(defaultJvmOpts::add);
            startScriptsTask.setDefaultJvmOpts(defaultJvmOpts);
        }
        StartScriptsMutator mutator = new StartScriptsMutator(runTask, project);
        mutator.updateStartScriptsTask(startScriptsTask);
        mutator.movePatchedLibs();
    }
}

